/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: svx_navigatortree.cxx,v $
 *
 *  $Revision: 1.4 $
 *
 *  last change: $Author: rt $ $Date: 2005/09/08 05:48:18 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

// auto strip #ifndef _SVX_DIALMGR_HXX //autogen
// auto strip #include "dialmgr.hxx"
// auto strip #endif
// auto strip #ifndef _SVX_FMSHELL_HXX
// auto strip #include "fmshell.hxx"
// auto strip #endif
// auto strip #ifndef _SVX_FMMODEL_HXX
// auto strip #include "fmmodel.hxx"
// auto strip #endif
// auto strip #ifndef _SVX_FMPAGE_HXX
// auto strip #include "fmpage.hxx"
// auto strip #endif
// auto strip #ifndef _SVDPAGV_HXX
// auto strip #include "svdpagv.hxx"
// auto strip #endif
// auto strip #ifndef _SVDITER_HXX
// auto strip #include "svditer.hxx"
// auto strip #endif

#ifndef _SVX_FMHELP_HRC
#include "fmhelp.hrc"
#endif
#ifndef _SVX_FMEXPL_HRC
#include "fmexpl.hrc"
#endif
#ifndef _SVX_FMEXPL_HXX
#include "fmexpl.hxx"
#endif
#ifndef _SVX_FMRESIDS_HRC
#include "fmresids.hrc"
#endif

#ifndef _COM_SUN_STAR_SDBC_XROWSETLISTENER_HPP_
#include <com/sun/star/sdbc/XRowSetListener.hpp>
#endif

#ifndef _COM_SUN_STAR_SDB_XSQLQUERYCOMPOSERFACTORY_HPP_
#include <com/sun/star/sdb/XSQLQueryComposerFactory.hpp>
#endif

// auto strip #ifndef _SVX_FMSHIMP_HXX
// auto strip #include "fmshimp.hxx"
// auto strip #endif
// auto strip #ifndef _SVX_FMSERVS_HXX
// auto strip #include "fmservs.hxx"
// auto strip #endif
// auto strip #ifndef _SVX_TABORDER_HXX
// auto strip #include "taborder.hxx"
// auto strip #endif
// auto strip #ifndef _SVX_FMUNDO_HXX
// auto strip #include "fmundo.hxx"
// auto strip #endif
// auto strip #ifndef _SVX_FMUNOPGE_HXX
// auto strip #include "fmpgeimp.hxx"
// auto strip #endif
// auto strip #ifndef _MULTIPRO_HXX
// auto strip #include "multipro.hxx"
// auto strip #endif
// auto strip #ifndef _SVX_FMITEMS_HXX
// auto strip #include "fmitems.hxx"
// auto strip #endif

// auto strip #ifndef _SV_WRKWIN_HXX
// auto strip #include <vcl/wrkwin.hxx>
// auto strip #endif
// auto strip #ifndef _SFXVIEWSH_HXX
// auto strip #include <bf_sfx2/viewsh.hxx>
// auto strip #endif
// auto strip #ifndef _SFXDISPATCH_HXX
// auto strip #include <bf_sfx2/dispatch.hxx>
// auto strip #endif
// auto strip #ifndef _SFXVIEWFRM_HXX
// auto strip #include <bf_sfx2/viewfrm.hxx>
// auto strip #endif
// auto strip #ifndef _COMPHELPER_PROCESSFACTORY_HXX_
// auto strip #include <comphelper/processfactory.hxx>
// auto strip #endif
// auto strip #ifndef _COMPHELPER_PROPERTY_HXX_
// auto strip #include <comphelper/property.hxx>
// auto strip #endif

// auto strip #ifndef _COM_SUN_STAR_FORM_FORMCOMPONENTTYPE_HPP_
// auto strip #include <com/sun/star/form/FormComponentType.hpp>
// auto strip #endif
// auto strip #ifndef _COM_SUN_STAR_SDB_COMMANDTYPE_HPP_
// auto strip #include <com/sun/star/sdb/CommandType.hpp>
// auto strip #endif
// auto strip #ifndef _COM_SUN_STAR_BEANS_PROPERTYATTRIBUTE_HPP_
// auto strip #include <com/sun/star/beans/PropertyAttribute.hpp>
// auto strip #endif
// auto strip #ifndef _COM_SUN_STAR_SCRIPT_XEVENTATTACHERMANAGER_HPP_
// auto strip #include <com/sun/star/script/XEventAttacherManager.hpp>
// auto strip #endif
// auto strip #ifndef _COM_SUN_STAR_DATATRANSFER_CLIPBOARD_XCLIPBOARD_HPP_
// auto strip #include <com/sun/star/datatransfer/clipboard/XClipboard.hpp>
// auto strip #endif
// auto strip #ifndef _COM_SUN_STAR_DATATRANSFER_XTRANSFERABLE_HPP_
// auto strip #include <com/sun/star/datatransfer/XTransferable.hpp>
// auto strip #endif
// auto strip #ifndef _LEGACYBINFILTERMGR_HXX
// auto strip #include <legacysmgr/legacy_binfilters_smgr.hxx>	//STRIP002 
// auto strip #endif
namespace binfilter {

//............................................................................
//STRIP001 namespace svxform
//STRIP001 {
//STRIP001 //............................................................................
//STRIP001 
//STRIP001 	#define DROP_ACTION_TIMER_INITIAL_TICKS     10
//STRIP001 		// solange dauert es, bis das Scrollen anspringt
//STRIP001 	#define DROP_ACTION_TIMER_SCROLL_TICKS      3
//STRIP001 		// in diesen Intervallen wird jeweils eine Zeile gescrollt
//STRIP001 	#define DROP_ACTION_TIMER_TICK_BASE         10
//STRIP001 		// das ist die Basis, mit der beide Angaben multipliziert werden (in ms)
//STRIP001 
//STRIP001 	#define EXPLORER_SYNC_DELAY                 200
//STRIP001 		// dieser Betrag an Millisekunden wird gewartet, ehe der Explorer nach einem Select oder Deselect die ::com::sun::star::sdbcx::View synchronisiert
//STRIP001 
//STRIP001 	using namespace ::com::sun::star::uno;
//STRIP001 	using namespace ::com::sun::star::lang;
//STRIP001 	using namespace ::com::sun::star::beans;
//STRIP001 	using namespace ::com::sun::star::form;
//STRIP001 	using namespace ::com::sun::star::awt;
//STRIP001 	using namespace ::com::sun::star::container;
//STRIP001 	using namespace ::com::sun::star::script;
//STRIP001 	using namespace ::com::sun::star::datatransfer;
//STRIP001 	using namespace ::com::sun::star::datatransfer::clipboard;
//STRIP001 	using namespace ::com::sun::star::sdb;
//STRIP001 
//STRIP001 	//========================================================================
//STRIP001 	// helper
//STRIP001 	//========================================================================
//STRIP001 
//STRIP001 	typedef ::std::map< Reference< XInterface >, SdrObject*, ::comphelper::OInterfaceCompare< XInterface > >
//STRIP001 			MapModelToShape;
//STRIP001 	typedef MapModelToShape::value_type ModelShapePair;
//STRIP001 
//STRIP001 	//------------------------------------------------------------------------
//STRIP001 	void	collectShapeModelMapping( SdrPage* _pPage, MapModelToShape& _rMapping )
//STRIP001 	{
//STRIP001 		OSL_ENSURE( _pPage, "collectShapeModelMapping: invalid arg!" );
//STRIP001 
//STRIP001 		_rMapping.clear();
//STRIP001 
//STRIP001 		SdrObjListIter aIter( *_pPage );
//STRIP001 		while ( aIter.IsMore() )
//STRIP001 		{
//STRIP001 			// get the shape
//STRIP001 			SdrObject* pShape = aIter.Next();
//STRIP001 
//STRIP001 			// is it a UNO control shape?
//STRIP001 			if ( pShape->IsUnoObj() )
//STRIP001 			{
//STRIP001 				Reference< XInterface > xNormalizedModel;
//STRIP001 				xNormalizedModel = xNormalizedModel.query( ( static_cast< SdrUnoObj* >( pShape )->GetUnoControlModel() ) );
//STRIP001 					// note that this is normalized (i.e. queried for XInterface explicitly)
//STRIP001 
//STRIP001 #ifdef DBG_UTIL
//STRIP001 				::std::pair< MapModelToShape::iterator, bool > aPos =
//STRIP001 #endif
//STRIP001 				_rMapping.insert( ModelShapePair( xNormalizedModel, pShape ) );
//STRIP001 				DBG_ASSERT( aPos.second, "collectShapeModelMapping: model was already existent!" );
//STRIP001 					// if this asserts, this would mean we have 2 shapes pointing to the same model
//STRIP001 			}
//STRIP001 		}
//STRIP001 	}
//STRIP001 
//STRIP001 	//------------------------------------------------------------------------
//STRIP001 	sal_Bool isModelShapeMarked( FmEntryData* _pEntry, const MapModelToShape& _rModelMap, SdrMarkView* _pView )
//STRIP001 	{
//STRIP001 		DBG_ASSERT( _pEntry && _pView, "isModelShapeMarked: invalid arguments!" );
//STRIP001 		if ( !_pEntry || !_pView )
//STRIP001 			return sal_False;
//STRIP001 
//STRIP001 		DBG_ASSERT( _pEntry->GetElement().get() == Reference< XInterface >( _pEntry->GetElement(), UNO_QUERY ).get(),
//STRIP001 			"isModelShapeMarked: element of the FmEntryData is not normalized!" );
//STRIP001 			// normalization of the XInterface is a prerequisite for properly finding it in the map
//STRIP001 
//STRIP001 		sal_Bool bIsMarked = sal_False;
//STRIP001 
//STRIP001 		MapModelToShape::const_iterator aPos = _rModelMap.find( _pEntry->GetElement() );
//STRIP001 		if ( _rModelMap.end() != aPos )
//STRIP001 		{	// there is a shape for this model ....
//STRIP001 			bIsMarked = _pView->IsObjMarked( aPos->second );
//STRIP001 			if ( !bIsMarked )
//STRIP001 			{
//STRIP001 				// IsObjMarked does not step down grouped objects, so the sal_False we
//STRIP001 				// have is not really reliable (while a sal_True would have been)
//STRIP001 				// Okay, travel the mark list, and see if there is a group marked, and our shape
//STRIP001 				// is a part of this group
//STRIP001 				sal_uInt32 nMarked = _pView->GetMarkList().GetMarkCount();
//STRIP001 				for ( sal_uInt32 i = 0; (i<nMarked ) && !bIsMarked; ++i )
//STRIP001 				{
//STRIP001 					SdrMark* pMark = _pView->GetMarkList().GetMark( i );
//STRIP001 					SdrObject* pObj = pMark ? pMark->GetObj() : NULL;
//STRIP001 					if ( pObj && pObj->IsGroupObject() )
//STRIP001 					{	// the i-th marked shape is a group shape
//STRIP001 						SdrObjListIter aIter( *pObj );
//STRIP001 						while ( aIter.IsMore() )
//STRIP001 						{
//STRIP001 							if ( aIter.Next() == aPos->second )
//STRIP001 							{
//STRIP001 								bIsMarked = sal_True;
//STRIP001 								break;
//STRIP001 							}
//STRIP001 						}
//STRIP001 					}
//STRIP001 				}
//STRIP001 			}
//STRIP001 		}
//STRIP001 
//STRIP001 		return bIsMarked;
//STRIP001 	}
//STRIP001 
//STRIP001 	//========================================================================
//STRIP001 	// class NavigatorTree
//STRIP001 	//========================================================================
//STRIP001 
//STRIP001 	//------------------------------------------------------------------------
//STRIP001 	NavigatorTree::NavigatorTree( const Reference< XMultiServiceFactory >& _xORB,
//STRIP001 						   Window* pParent )
//STRIP001 		:SvTreeListBox( pParent, WB_HASBUTTONS|WB_HASLINES|WB_BORDER|WB_HSCROLL ) // #100258# OJ WB_HSCROLL added
//STRIP001 		,m_aControlExchange(this)
//STRIP001 		,nEditEvent(0)
//STRIP001 		,m_pEditEntry(NULL)
//STRIP001 		,m_nSelectLock(0)
//STRIP001 		,m_aTimerTriggered(-1,-1)
//STRIP001 		,m_bRootSelected(sal_False)
//STRIP001 		,m_nFormsSelected(0)
//STRIP001 		,m_nControlsSelected(0)
//STRIP001 		,m_nHiddenControls(0)
//STRIP001 		,m_bPrevSelectionMixed(sal_False)
//STRIP001 		,m_bInitialUpdate(sal_True)
//STRIP001 		,m_bMarkingObjects(sal_False)
//STRIP001 		,m_sdiState(SDI_DIRTY)
//STRIP001 		,m_bDragDataDirty(sal_False)
//STRIP001 		,m_bKeyboardCut( sal_False )
//STRIP001 		,m_pRootEntry(NULL)
//STRIP001 		,m_xORB(_xORB)
//STRIP001 	{
//STRIP001 		SetHelpId( HID_FORM_NAVIGATOR );
//STRIP001 
//STRIP001 		m_aNavigatorImages = ImageList( SVX_RES( RID_SVXIMGLIST_FMEXPL ) );
//STRIP001 		m_aNavigatorImagesHC = ImageList( SVX_RES( RID_SVXIMGLIST_FMEXPL_HC ) );
//STRIP001 
//STRIP001 		SetNodeBitmaps(
//STRIP001 			m_aNavigatorImages.GetImage( RID_SVXIMG_COLLAPSEDNODE ),
//STRIP001 			m_aNavigatorImages.GetImage( RID_SVXIMG_EXPANDEDNODE ),
//STRIP001 			BMP_COLOR_NORMAL
//STRIP001 		);
//STRIP001 		SetNodeBitmaps(
//STRIP001 			m_aNavigatorImagesHC.GetImage( RID_SVXIMG_COLLAPSEDNODE ),
//STRIP001 			m_aNavigatorImagesHC.GetImage( RID_SVXIMG_EXPANDEDNODE ),
//STRIP001 			BMP_COLOR_HIGHCONTRAST
//STRIP001 		);
//STRIP001 
//STRIP001 		SetDragDropMode(0xFFFF);
//STRIP001 		EnableInplaceEditing( sal_True );
//STRIP001 		SetSelectionMode(MULTIPLE_SELECTION);
//STRIP001 
//STRIP001 		m_pNavModel = new NavigatorTreeModel( m_aNavigatorImages, m_aNavigatorImagesHC );
//STRIP001 		Clear();
//STRIP001 
//STRIP001 		StartListening( *m_pNavModel );
//STRIP001 
//STRIP001 		m_aDropActionTimer.SetTimeoutHdl(LINK(this, NavigatorTree, OnDropActionTimer));
//STRIP001 
//STRIP001 		m_aSynchronizeTimer.SetTimeoutHdl(LINK(this, NavigatorTree, OnSynchronizeTimer));
//STRIP001 		SetSelectHdl(LINK(this, NavigatorTree, OnEntrySelDesel));
//STRIP001 		SetDeselectHdl(LINK(this, NavigatorTree, OnEntrySelDesel));
//STRIP001 	}
//STRIP001 
//STRIP001 	//------------------------------------------------------------------------
//STRIP001 	NavigatorTree::~NavigatorTree()
//STRIP001 	{
//STRIP001 		if( nEditEvent )
//STRIP001 			Application::RemoveUserEvent( nEditEvent );
//STRIP001 
//STRIP001 		if (m_aSynchronizeTimer.IsActive())
//STRIP001 			m_aSynchronizeTimer.Stop();
//STRIP001 
//STRIP001 		DBG_ASSERT(GetNavModel() != NULL, "NavigatorTree::~NavigatorTree : unerwartet : kein ExplorerModel");
//STRIP001 		EndListening( *m_pNavModel );
//STRIP001 		Clear();
//STRIP001 		delete m_pNavModel;
//STRIP001 	}
//STRIP001 
//STRIP001 	//------------------------------------------------------------------------
//STRIP001 	void NavigatorTree::Clear()
//STRIP001 	{
//STRIP001 		m_pNavModel->Clear();
//STRIP001 	}
//STRIP001 
//STRIP001 	//------------------------------------------------------------------------
//STRIP001 	void NavigatorTree::Update( FmFormShell* pFormShell )
//STRIP001 	{
//STRIP001 		if (m_bInitialUpdate)
//STRIP001 		{
//STRIP001 			GrabFocus();
//STRIP001 			m_bInitialUpdate = sal_False;
//STRIP001 		}
//STRIP001 
//STRIP001 		FmFormShell* pOldShell = GetNavModel()->GetFormShell();
//STRIP001 		FmFormPage* pOldPage = GetNavModel()->GetFormPage();
//STRIP001 		FmFormPage* pNewPage = pFormShell ? pFormShell->GetCurPage() : NULL;
//STRIP001 
//STRIP001 		if ((pOldShell != pFormShell) || (pOldPage != pNewPage))
//STRIP001 		{
//STRIP001 			// neue Shell, waehrend ich gerade editiere ?
//STRIP001 			if (IsEditingActive())
//STRIP001 				CancelTextEditing();
//STRIP001 
//STRIP001 			m_bDragDataDirty = sal_True;    // sicherheitshalber, auch wenn ich gar nicht dragge
//STRIP001 		}
//STRIP001 		GetNavModel()->Update( pFormShell );
//STRIP001 
//STRIP001 		// wenn es eine Form gibt, die Root expandieren
//STRIP001 		if (m_pRootEntry && !IsExpanded(m_pRootEntry))
//STRIP001 			Expand(m_pRootEntry);
//STRIP001 		// wenn es GENAU eine Form gibt, auch diese expandieren
//STRIP001 		if (m_pRootEntry)
//STRIP001 		{
//STRIP001 			SvLBoxEntry* pFirst = FirstChild(m_pRootEntry);
//STRIP001 			if (pFirst && !NextSibling(pFirst))
//STRIP001 				Expand(pFirst);
//STRIP001 		}
//STRIP001 	}
//STRIP001 
//STRIP001 	//------------------------------------------------------------------------------
//STRIP001 	sal_Bool NavigatorTree::implAllowExchange( sal_Int8 _nAction, sal_Bool* _pHasNonHidden )
//STRIP001 	{
//STRIP001 		SvLBoxEntry* pCurEntry = GetCurEntry();
//STRIP001 		if (!pCurEntry)
//STRIP001 			return sal_False;
//STRIP001 
//STRIP001 		// die Informationen fuer das AcceptDrop und ExecuteDrop
//STRIP001 		CollectSelectionData(SDI_ALL);
//STRIP001 		if (!m_arrCurrentSelection.Count())
//STRIP001 			// nothing to do
//STRIP001 			return sal_False;
//STRIP001 
//STRIP001 		// testen, ob es sich vielleicht ausschliesslich um hidden controls handelt (dann koennte ich pCtrlExch noch ein
//STRIP001 		// zusaetzliches Format geben)
//STRIP001 		sal_Bool bHasNonHidden = sal_False;
//STRIP001 		for (sal_Int32 i=0; i<m_arrCurrentSelection.Count(); i++)
//STRIP001 		{
//STRIP001 			FmEntryData* pCurrent = static_cast< FmEntryData* >( m_arrCurrentSelection[(sal_uInt16)i]->GetUserData() );
//STRIP001 			if ( IsHiddenControl( pCurrent ) )
//STRIP001 				continue;
//STRIP001 			bHasNonHidden = sal_True;
//STRIP001 			break;
//STRIP001 		}
//STRIP001 
//STRIP001 		if ( bHasNonHidden && ( 0 == ( _nAction & DND_ACTION_MOVE ) ) )
//STRIP001 			// non-hidden controls need to be moved
//STRIP001 			return sal_False;
//STRIP001 
//STRIP001 		if ( _pHasNonHidden )
//STRIP001 			*_pHasNonHidden = bHasNonHidden;
//STRIP001 
//STRIP001 		return sal_True;
//STRIP001 	}
//STRIP001 
//STRIP001 	//------------------------------------------------------------------------------
//STRIP001 	sal_Bool NavigatorTree::implPrepareExchange( sal_Int8 _nAction )
//STRIP001 	{
//STRIP001 		EndSelection();
//STRIP001 
//STRIP001 		sal_Bool bHasNonHidden = sal_False;
//STRIP001 		if ( !implAllowExchange( _nAction, &bHasNonHidden ) )
//STRIP001 			return sal_False;
//STRIP001 
//STRIP001 		m_aControlExchange.prepareDrag();
//STRIP001 		m_aControlExchange->setFocusEntry( GetCurEntry() );
//STRIP001 
//STRIP001 		for (sal_Int32 i=0; i<m_arrCurrentSelection.Count(); ++i)
//STRIP001 			m_aControlExchange->addSelectedEntry(m_arrCurrentSelection[(sal_uInt16)i]);
//STRIP001 
//STRIP001 		m_aControlExchange->setFormsRoot( GetNavModel()->GetFormPage()->GetForms() );
//STRIP001 		m_aControlExchange->buildPathFormat( this, m_pRootEntry );
//STRIP001 
//STRIP001 		if (!bHasNonHidden)
//STRIP001 		{
//STRIP001 			// eine entsprechende Sequenz aufbauen
//STRIP001 			Sequence< Reference< XInterface > > seqIFaces(m_arrCurrentSelection.Count());
//STRIP001 			Reference< XInterface >* pArray = seqIFaces.getArray();
//STRIP001 			for (i=0; i<m_arrCurrentSelection.Count(); ++i, ++pArray)
//STRIP001 				*pArray = static_cast< FmEntryData* >( m_arrCurrentSelection[(sal_uInt16)i]->GetUserData() )->GetElement();
//STRIP001 
//STRIP001 			// und das neue Format
//STRIP001 			m_aControlExchange->addHiddenControlsFormat(seqIFaces);
//STRIP001 		}
//STRIP001 
//STRIP001 		m_bDragDataDirty = sal_False;
//STRIP001 		return sal_True;
//STRIP001 	}
//STRIP001 
//STRIP001 	//------------------------------------------------------------------------------
//STRIP001 	void NavigatorTree::StartDrag( sal_Int8 nAction, const ::Point& rPosPixel )
//STRIP001 	{
//STRIP001 		EndSelection();
//STRIP001 
//STRIP001 		if ( !implPrepareExchange( DND_ACTION_COPYMOVE ) )
//STRIP001 			// nothing to do or something went wrong
//STRIP001 			return;
//STRIP001 
//STRIP001 		// jetzt haben wir alle in der aktuelle Situation moeglichen Formate eingesammelt, es kann also losgehen ...
//STRIP001 		m_aControlExchange.startDrag( DND_ACTION_COPYMOVE );
//STRIP001 	}
//STRIP001 
//STRIP001 	//------------------------------------------------------------------------------
//STRIP001 	void NavigatorTree::Command( const CommandEvent& rEvt )
//STRIP001 	{
//STRIP001 		sal_Bool bHandled = sal_False;
//STRIP001 		switch( rEvt.GetCommand() )
//STRIP001 		{
//STRIP001 			case COMMAND_CONTEXTMENU:
//STRIP001 			{
//STRIP001 				// die Stelle, an der geklickt wurde
//STRIP001 				::Point ptWhere;
//STRIP001 				if (rEvt.IsMouseEvent())
//STRIP001 				{
//STRIP001 					ptWhere = rEvt.GetMousePosPixel();
//STRIP001 					SvLBoxEntry* ptClickedOn = GetEntry(ptWhere);
//STRIP001 					if (ptClickedOn == NULL)
//STRIP001 						break;
//STRIP001 					if ( !IsSelected(ptClickedOn) )
//STRIP001 					{
//STRIP001 						SelectAll(sal_False);
//STRIP001 						Select(ptClickedOn, sal_True);
//STRIP001 						SetCurEntry(ptClickedOn);
//STRIP001 					}
//STRIP001 				}
//STRIP001 				else
//STRIP001 				{
//STRIP001 					if (m_arrCurrentSelection.Count() == 0) // kann nur bei Kontextmenue ueber Tastatur passieren
//STRIP001 						break;
//STRIP001 
//STRIP001 					SvLBoxEntry* pCurrent = GetCurEntry();
//STRIP001 					if (!pCurrent)
//STRIP001 						break;
//STRIP001 					ptWhere = GetEntryPos(pCurrent);
//STRIP001 				}
//STRIP001 
//STRIP001 				// meine Selektionsdaten auf den aktuellen Stand
//STRIP001 				CollectSelectionData(SDI_ALL);
//STRIP001 
//STRIP001 				// wenn mindestens ein Nicht-Root-Eintrag selektiert ist und die Root auch, dann nehme ich letztere aus der Selektion
//STRIP001 				// fix wieder raus
//STRIP001 				if ( (m_arrCurrentSelection.Count() > 1) && m_bRootSelected )
//STRIP001 				{
//STRIP001 					Select( m_pRootEntry, sal_False );
//STRIP001 					SetCursor( m_arrCurrentSelection.GetObject(0), sal_True);
//STRIP001 				}
//STRIP001 				sal_Bool bSingleSelection = (m_arrCurrentSelection.Count() == 1);
//STRIP001 
//STRIP001 
//STRIP001 				DBG_ASSERT( (m_arrCurrentSelection.Count() > 0) | m_bRootSelected, "keine Eintraege selektiert" );
//STRIP001 					// solte nicht passieren, da ich oben bei der IsSelected-Abfrage auf jeden Fall einen selektiert haette,
//STRIP001 					// wenn das vorher nicht der Fall gewesen waere
//STRIP001 
//STRIP001 
//STRIP001 				// das Menue zusammenbasteln
//STRIP001 				FmFormShell* pFormShell = GetNavModel()->GetFormShell();
//STRIP001 				FmFormModel* pFormModel = pFormShell ? pFormShell->GetFormModel() : NULL;
//STRIP001 				if( pFormShell && pFormModel )
//STRIP001 				{
//STRIP001 					PopupMenu aContextMenu(SVX_RES(RID_FMEXPLORER_POPUPMENU));
//STRIP001 					PopupMenu* pSubMenuNew = aContextMenu.GetPopupMenu( SID_FM_NEW );
//STRIP001 
//STRIP001 					// das 'Neu'-Untermenue gibt es nur, wenn genau die Root oder genau ein Formular selektiert sind
//STRIP001 					aContextMenu.EnableItem( SID_FM_NEW, bSingleSelection && (m_nFormsSelected || m_bRootSelected) );
//STRIP001 
//STRIP001 					// 'Neu'\'Formular' unter genau den selben Bedingungen
//STRIP001 					pSubMenuNew->EnableItem( SID_FM_NEW_FORM, bSingleSelection && (m_nFormsSelected || m_bRootSelected) );
//STRIP001 					pSubMenuNew->SetItemImage(SID_FM_NEW_FORM, m_aNavigatorImages.GetImage(RID_SVXIMG_FORM));
//STRIP001 					pSubMenuNew->SetItemImage(SID_FM_NEW_HIDDEN, m_aNavigatorImages.GetImage(RID_SVXIMG_HIDDEN));
//STRIP001 
//STRIP001 					// 'Neu'\'verstecktes...', wenn genau ein Formular selektiert ist
//STRIP001 					pSubMenuNew->EnableItem( SID_FM_NEW_HIDDEN, bSingleSelection && m_nFormsSelected );
//STRIP001 
//STRIP001 					// 'Delete': everything which is not root can be removed
//STRIP001 					aContextMenu.EnableItem( SID_FM_DELETE, !m_bRootSelected );
//STRIP001 
//STRIP001 					// 'Cut', 'Copy' and 'Paste'
//STRIP001 					aContextMenu.EnableItem( SID_CUT, !m_bRootSelected && implAllowExchange( DND_ACTION_MOVE ) );
//STRIP001 					aContextMenu.EnableItem( SID_COPY, !m_bRootSelected && implAllowExchange( DND_ACTION_COPY ) );
//STRIP001 					aContextMenu.EnableItem( SID_PASTE, implAcceptPaste( ) );
//STRIP001 
//STRIP001 					// der TabDialog, wenn es genau ein Formular ist ...
//STRIP001 					aContextMenu.EnableItem( SID_FM_TAB_DIALOG, bSingleSelection && m_nFormsSelected );
//STRIP001 
//STRIP001 					// Properties, wenn es nur Controls oder genau ein Formular ist
//STRIP001 					// (und der ProBrowser nicht sowieso schon offen ist)
//STRIP001 					if( pFormShell->GetImpl()->IsPropBrwOpen() )
//STRIP001 						aContextMenu.RemoveItem( aContextMenu.GetItemPos(SID_FM_SHOW_PROPERTY_BROWSER) );
//STRIP001 					else
//STRIP001 						aContextMenu.EnableItem( SID_FM_SHOW_PROPERTY_BROWSER,
//STRIP001 							(m_nControlsSelected && !m_nFormsSelected) || (!m_nControlsSelected && m_nFormsSelected) );
//STRIP001 
//STRIP001 					// Umbenennen gdw wenn ein Element und nicht die Root
//STRIP001 					aContextMenu.EnableItem( SID_FM_RENAME_OBJECT, bSingleSelection && !m_bRootSelected );
//STRIP001 
//STRIP001 					// der Reandonly-Eintrag ist nur auf der Root erlaubt
//STRIP001 					aContextMenu.EnableItem( SID_FM_OPEN_READONLY, m_bRootSelected );
//STRIP001 					// the same for automatic control focus
//STRIP001 					aContextMenu.EnableItem( SID_FM_AUTOCONTROLFOCUS, m_bRootSelected );
//STRIP001 
//STRIP001 					// die ConvertTo-Slots sind enabled, wenn genau ein Control selektiert ist, der
//STRIP001 					// dem Control entsprechende Slot ist disabled
//STRIP001 					if (!m_bRootSelected && !m_nFormsSelected && (m_nControlsSelected == 1))
//STRIP001 					{
//STRIP001 						aContextMenu.SetPopupMenu( SID_FM_CHANGECONTROLTYPE, FmXFormShell::GetConversionMenu() );
//STRIP001 						FmControlData* pCurrent = (FmControlData*)(m_arrCurrentSelection[0]->GetUserData());
//STRIP001 						Reference< XPropertySet >  xCurrentProps(pCurrent->GetFormComponent(), UNO_QUERY);
//STRIP001 						pFormShell->GetImpl()->CheckControlConversionSlots(xCurrentProps, *aContextMenu.GetPopupMenu(SID_FM_CHANGECONTROLTYPE));
//STRIP001 							// die Shell filtert nach weiteren Bedingungen, zum Beispiel kein 'hidden control'
//STRIP001 					}
//STRIP001 					else
//STRIP001 						aContextMenu.EnableItem( SID_FM_CHANGECONTROLTYPE, sal_False );
//STRIP001 
//STRIP001 					// jetzt alles, was disabled wurde, wech
//STRIP001 					aContextMenu.RemoveDisabledEntries(sal_True, sal_True);
//STRIP001 					//////////////////////////////////////////////////////////
//STRIP001 					// OpenReadOnly setzen
//STRIP001 
//STRIP001 					aContextMenu.CheckItem( SID_FM_OPEN_READONLY, pFormModel->GetOpenInDesignMode() );
//STRIP001 					aContextMenu.CheckItem( SID_FM_AUTOCONTROLFOCUS, pFormModel->GetAutoControlFocus() );
//STRIP001 
//STRIP001 					sal_uInt16 nSlotId = aContextMenu.Execute( this, ptWhere );
//STRIP001 					switch( nSlotId )
//STRIP001 					{
//STRIP001 						case SID_FM_NEW_FORM:
//STRIP001 						{
//STRIP001 							XubString aStr(SVX_RES(RID_STR_FORM));
//STRIP001 							XubString aUndoStr(SVX_RES(RID_STR_UNDO_CONTAINER_INSERT));
//STRIP001 							aUndoStr.SearchAndReplace('#', aStr);
//STRIP001 
//STRIP001 							pFormModel->BegUndo(aUndoStr);
//STRIP001 							// der Slot war nur verfuegbar, wenn es genau einen selektierten Eintrag gibt und dieser die Root
//STRIP001 							// oder ein Formular ist
//STRIP001 							NewForm( m_arrCurrentSelection.GetObject(0) );
//STRIP001 							pFormModel->EndUndo();
//STRIP001 
//STRIP001 						}   break;
//STRIP001 						case SID_FM_NEW_HIDDEN:
//STRIP001 						{
//STRIP001 							XubString aStr(SVX_RES(RID_STR_CONTROL));
//STRIP001 							XubString aUndoStr(SVX_RES(RID_STR_UNDO_CONTAINER_INSERT));
//STRIP001 							aUndoStr.SearchAndReplace('#', aStr);
//STRIP001 
//STRIP001 							pFormModel->BegUndo(aUndoStr);
//STRIP001 							// dieser Slot war guletig bei (genau) einem selektierten Formular
//STRIP001 							::rtl::OUString fControlName = FM_COMPONENT_HIDDEN;
//STRIP001 							NewControl( fControlName, m_arrCurrentSelection.GetObject(0) );
//STRIP001 							pFormModel->EndUndo();
//STRIP001 
//STRIP001 						}   break;
//STRIP001 
//STRIP001 						case SID_CUT:
//STRIP001 							doCut();
//STRIP001 							break;
//STRIP001 
//STRIP001 						case SID_COPY:
//STRIP001 							doCopy();
//STRIP001 							break;
//STRIP001 
//STRIP001 						case SID_PASTE:
//STRIP001 							doPaste();
//STRIP001 							break;
//STRIP001 
//STRIP001 						case SID_FM_DELETE:
//STRIP001 						{
//STRIP001 							DeleteSelection();
//STRIP001 						}
//STRIP001 						break;
//STRIP001 						case SID_FM_TAB_DIALOG:
//STRIP001 						{
//STRIP001 							// dieser Slot galt bei genau einem selektierten Formular
//STRIP001 							SvLBoxEntry* pSelectedForm = m_arrCurrentSelection.GetObject(0);
//STRIP001 							DBG_ASSERT( IsFormEntry(pSelectedForm), "NavigatorTree::Command: Dieser Eintrag muss ein FormEntry sein." );
//STRIP001 
//STRIP001 							FmFormData* pFormData = (FmFormData*)pSelectedForm->GetUserData();
//STRIP001 							Reference< XForm >  xForm(  pFormData->GetFormIface());
//STRIP001 
//STRIP001 							Reference< XTabControllerModel >  xTabController(xForm, UNO_QUERY);
//STRIP001 							if( !xTabController.is() ) break;
//STRIP001 							FmTabOrderDlg aTabDlg(m_xORB, GetpApp()->GetAppWindow(), GetNavModel()->GetFormShell() );
//STRIP001 							aTabDlg.Execute();
//STRIP001 
//STRIP001 						}
//STRIP001 						break;
//STRIP001 						case SID_FM_SHOW_PROPERTY_BROWSER:
//STRIP001 						{
//STRIP001 							ShowSelectionProperties(sal_True);
//STRIP001 						}
//STRIP001 						break;
//STRIP001 						case SID_FM_RENAME_OBJECT:
//STRIP001 						{
//STRIP001 							// das war bei genau einem Nicht-Root-Eintrag erlaubt
//STRIP001 							EditEntry( m_arrCurrentSelection.GetObject(0) );
//STRIP001 						}
//STRIP001 						break;
//STRIP001 						case SID_FM_OPEN_READONLY:
//STRIP001 						{
//STRIP001 							pFormModel->SetOpenInDesignMode( !pFormModel->GetOpenInDesignMode() );
//STRIP001 							pFormShell->GetViewShell()->GetViewFrame()->GetBindings().Invalidate(SID_FM_OPEN_READONLY);
//STRIP001 						}
//STRIP001 						break;
//STRIP001 						case SID_FM_AUTOCONTROLFOCUS:
//STRIP001 						{
//STRIP001 							pFormModel->SetAutoControlFocus( !pFormModel->GetAutoControlFocus() );
//STRIP001 							pFormShell->GetViewShell()->GetViewFrame()->GetBindings().Invalidate(SID_FM_AUTOCONTROLFOCUS);
//STRIP001 						}
//STRIP001 						break;
//STRIP001 						default:
//STRIP001 							if (pFormShell->GetImpl()->IsControlConversionSlot(nSlotId))
//STRIP001 							{
//STRIP001 								FmControlData* pCurrent = (FmControlData*)(m_arrCurrentSelection[0]->GetUserData());
//STRIP001 								if (pFormShell->GetImpl()->ExecuteControlConversionSlot(pCurrent->GetFormComponent(), nSlotId))
//STRIP001 									ShowSelectionProperties();
//STRIP001 							}
//STRIP001 					}
//STRIP001 				}
//STRIP001 				bHandled = sal_True;
//STRIP001 			} break;
//STRIP001 		}
//STRIP001 
//STRIP001 		if (!bHandled)
//STRIP001 			SvTreeListBox::Command( rEvt );
//STRIP001 	}
//STRIP001 
//STRIP001 	//------------------------------------------------------------------------
//STRIP001 	sal_Bool NavigatorTree::IsDeleteAllowed()
//STRIP001 	{
//STRIP001 		//////////////////////////////////////////////////////////////////////
//STRIP001 		// Haben wir eine Form...
//STRIP001 		SvLBoxEntry* pCurEntry = GetCurEntry();
//STRIP001 		sal_uInt32 nCurEntryPos = GetModel()->GetAbsPos( pCurEntry );
//STRIP001 
//STRIP001 		if( nCurEntryPos==0 )           // Root kann nicht geloescht werden
//STRIP001 			return sal_False;
//STRIP001 		else
//STRIP001 			return IsFormEntry(pCurEntry) || IsFormComponentEntry(pCurEntry);
//STRIP001 	}
//STRIP001 
//STRIP001 	//------------------------------------------------------------------------
//STRIP001 	SvLBoxEntry* NavigatorTree::FindEntry( FmEntryData* pEntryData )
//STRIP001 	{
//STRIP001 		if( !pEntryData ) return NULL;
//STRIP001 		SvLBoxEntry* pCurEntry = First();
//STRIP001 		FmEntryData* pCurEntryData;
//STRIP001 		while( pCurEntry )
//STRIP001 		{
//STRIP001 			pCurEntryData = (FmEntryData*)pCurEntry->GetUserData();
//STRIP001 			if( pCurEntryData && pCurEntryData->IsEqualWithoutChilds(pEntryData) )
//STRIP001 				return pCurEntry;
//STRIP001 
//STRIP001 			pCurEntry = Next( pCurEntry );
//STRIP001 		}
//STRIP001 
//STRIP001 		return NULL;
//STRIP001 	}
//STRIP001 
//STRIP001 	//------------------------------------------------------------------------
//STRIP001 	void NavigatorTree::Notify( SfxBroadcaster& rBC, const SfxHint& rHint )
//STRIP001 	{
//STRIP001 		if( rHint.ISA(FmNavRemovedHint) )
//STRIP001 		{
//STRIP001 			FmNavRemovedHint* pRemovedHint = (FmNavRemovedHint*)&rHint;
//STRIP001 			FmEntryData* pEntryData = pRemovedHint->GetEntryData();
//STRIP001 			Remove( pEntryData );
//STRIP001 		}
//STRIP001 
//STRIP001 		else if( rHint.ISA(FmNavInsertedHint) )
//STRIP001 		{
//STRIP001 			FmNavInsertedHint* pInsertedHint = (FmNavInsertedHint*)&rHint;
//STRIP001 			FmEntryData* pEntryData = pInsertedHint->GetEntryData();
//STRIP001 			sal_uInt32 nRelPos = pInsertedHint->GetRelPos();
//STRIP001 			Insert( pEntryData, nRelPos );
//STRIP001 		}
//STRIP001 
//STRIP001 		else if( rHint.ISA(FmNavModelReplacedHint) )
//STRIP001 		{
//STRIP001 			FmEntryData* pData = ((FmNavModelReplacedHint*)&rHint)->GetEntryData();
//STRIP001 			SvLBoxEntry* pEntry = FindEntry( pData );
//STRIP001 			if (pEntry)
//STRIP001 			{   // das Image neu setzen
//STRIP001 				SetCollapsedEntryBmp( pEntry, pData->GetNormalImage(), BMP_COLOR_NORMAL );
//STRIP001 				SetExpandedEntryBmp( pEntry, pData->GetNormalImage(), BMP_COLOR_NORMAL );
//STRIP001 
//STRIP001 				SetCollapsedEntryBmp( pEntry, pData->GetHCImage(), BMP_COLOR_HIGHCONTRAST );
//STRIP001 				SetExpandedEntryBmp( pEntry, pData->GetHCImage(), BMP_COLOR_HIGHCONTRAST );
//STRIP001 			}
//STRIP001 		}
//STRIP001 
//STRIP001 		else if( rHint.ISA(FmNavNameChangedHint) )
//STRIP001 		{
//STRIP001 			FmNavNameChangedHint* pNameChangedHint = (FmNavNameChangedHint*)&rHint;
//STRIP001 			SvLBoxEntry* pEntry = FindEntry( pNameChangedHint->GetEntryData() );
//STRIP001 			SetEntryText( pEntry, pNameChangedHint->GetNewName() );
//STRIP001 		}
//STRIP001 
//STRIP001 		else if( rHint.ISA(FmNavClearedHint) )
//STRIP001 		{
//STRIP001 			SvTreeListBox::Clear();
//STRIP001 
//STRIP001 			//////////////////////////////////////////////////////////////////////
//STRIP001 			// Default-Eintrag "Formulare"
//STRIP001 			Image aRootImage( m_aNavigatorImages.GetImage( RID_SVXIMG_FORMS ) );
//STRIP001 			m_pRootEntry = InsertEntry( SVX_RES(RID_STR_FORMS), aRootImage, aRootImage,
//STRIP001 				NULL, sal_False, 0, NULL );
//STRIP001 
//STRIP001 			if ( m_pRootEntry )
//STRIP001 			{
//STRIP001 				Image aHCRootImage( m_aNavigatorImagesHC.GetImage( RID_SVXIMG_FORMS ) );
//STRIP001 				SetExpandedEntryBmp( m_pRootEntry, aHCRootImage, BMP_COLOR_HIGHCONTRAST );
//STRIP001 				SetCollapsedEntryBmp( m_pRootEntry, aHCRootImage, BMP_COLOR_HIGHCONTRAST );
//STRIP001 			}
//STRIP001 		}
//STRIP001 		else if (!m_bMarkingObjects && rHint.ISA(FmNavRequestSelectHint))
//STRIP001 		{   // wenn m_bMarkingObjects sal_True ist, markiere ich gerade selber Objekte, und da der ganze Mechanismus dahinter synchron ist,
//STRIP001 			// ist das genau der Hint, der durch mein Markieren ausgeloest wird, also kann ich ihn ignorieren
//STRIP001 			FmNavRequestSelectHint* pershHint = (FmNavRequestSelectHint*)&rHint;
//STRIP001 			FmEntryDataArray& arredToSelect = pershHint->GetItems();
//STRIP001 			SynchronizeSelection(arredToSelect);
//STRIP001 
//STRIP001 			if (pershHint->IsMixedSelection())
//STRIP001 				// in diesem Fall habe ich alles deselektiert, obwohl die View u.U. eine gemischte Markierung hatte
//STRIP001 				// ich muss also im naechsten Select den Navigator an die View anpassen
//STRIP001 				m_bPrevSelectionMixed = sal_True;
//STRIP001 		}
//STRIP001 	}
//STRIP001 
//STRIP001 	//------------------------------------------------------------------------
//STRIP001 	SvLBoxEntry* NavigatorTree::Insert( FmEntryData* pEntryData, sal_uInt32 nRelPos )
//STRIP001 	{
//STRIP001 		//////////////////////////////////////////////////////////////////////
//STRIP001 		// Aktuellen Eintrag einfuegen
//STRIP001 		SvLBoxEntry* pParentEntry = FindEntry( pEntryData->GetParent() );
//STRIP001 		SvLBoxEntry* pNewEntry;
//STRIP001 
//STRIP001 		if( !pParentEntry )
//STRIP001 			pNewEntry = InsertEntry( pEntryData->GetText(),
//STRIP001 				pEntryData->GetNormalImage(), pEntryData->GetNormalImage(),
//STRIP001 				m_pRootEntry, sal_False, nRelPos, pEntryData );
//STRIP001 
//STRIP001 		else
//STRIP001 			pNewEntry = InsertEntry( pEntryData->GetText(),
//STRIP001 				pEntryData->GetNormalImage(), pEntryData->GetNormalImage(),
//STRIP001 				pParentEntry, sal_False, nRelPos, pEntryData );
//STRIP001 
//STRIP001 		if ( pNewEntry )
//STRIP001 		{
//STRIP001 			SetExpandedEntryBmp( pNewEntry, pEntryData->GetHCImage(), BMP_COLOR_HIGHCONTRAST );
//STRIP001 			SetCollapsedEntryBmp( pNewEntry, pEntryData->GetHCImage(), BMP_COLOR_HIGHCONTRAST );
//STRIP001 		}
//STRIP001 
//STRIP001 		//////////////////////////////////////////////////////////////////////
//STRIP001 		// Wenn Root-Eintrag Root expandieren
//STRIP001 		if( !pParentEntry )
//STRIP001 			Expand( m_pRootEntry );
//STRIP001 
//STRIP001 		//////////////////////////////////////////////////////////////////////
//STRIP001 		// Childs einfuegen
//STRIP001 		FmEntryDataList* pChildList = pEntryData->GetChildList();
//STRIP001 		sal_uInt32 nChildCount = pChildList->Count();
//STRIP001 		FmEntryData* pChildData;
//STRIP001 		for( sal_uInt32 i=0; i<nChildCount; i++ )
//STRIP001 		{
//STRIP001 			pChildData = pChildList->GetObject(i);
//STRIP001 			Insert( pChildData, LIST_APPEND );
//STRIP001 		}
//STRIP001 
//STRIP001 		return pNewEntry;
//STRIP001 	}
//STRIP001 
//STRIP001 	//------------------------------------------------------------------------
//STRIP001 	void NavigatorTree::Remove( FmEntryData* pEntryData )
//STRIP001 	{
//STRIP001 		if( !pEntryData )
//STRIP001 			return;
//STRIP001 
//STRIP001 		// der Entry zu den Daten
//STRIP001 		SvLBoxEntry* pEntry = FindEntry( pEntryData );
//STRIP001 		if (!pEntry)
//STRIP001 			return;
//STRIP001 
//STRIP001 		// Eintrag aus TreeListBox entfernen
//STRIP001 		// ich darf das Select, das ich ausloese, nicht behandeln :
//STRIP001 		// Select aendert die MarkList der View, wenn das gerade auch jemand anders macht und dabei ein Remove
//STRIP001 		// triggert, haben wir mit ziemlicher Sicherheit ein Problem - Paradebeispiel war das Gruppieren von Controls mit
//STRIP001 		// offenem Navigator ...)
//STRIP001 		LockSelectionHandling();
//STRIP001 
//STRIP001 		// ein kleines Problem : ich merke mir meine selektierten Daten, wenn mir jetzt jemand einen selektierten Eintrag
//STRIP001 		// unter dem Hintern wegschiesst, werde ich inkonsistent ... was schlecht waere
//STRIP001 		Select(pEntry, sal_False);
//STRIP001 
//STRIP001 		// beim eigentlichen Entfernen kann die Selection geaendert werden, da ich aber das SelectionHandling abgeschaltet
//STRIP001 		// habe, muss ich mich hinterher darum kuemmern
//STRIP001 		ULONG nExpectedSelectionCount = GetSelectionCount();
//STRIP001 
//STRIP001 		if( pEntry )
//STRIP001 			GetModel()->Remove( pEntry );
//STRIP001 
//STRIP001 		if (nExpectedSelectionCount != GetSelectionCount())
//STRIP001 			SynchronizeSelection();
//STRIP001 
//STRIP001 		// und standardmaessig behandle ich das Select natuerlich
//STRIP001 		UnlockSelectionHandling();
//STRIP001 	}
//STRIP001 
//STRIP001 	//------------------------------------------------------------------------
//STRIP001 	sal_Bool NavigatorTree::IsFormEntry( SvLBoxEntry* pEntry )
//STRIP001 	{
//STRIP001 		FmEntryData* pEntryData = (FmEntryData*)pEntry->GetUserData();
//STRIP001 		return !pEntryData || pEntryData->ISA(FmFormData);
//STRIP001 	}
//STRIP001 
//STRIP001 	//------------------------------------------------------------------------
//STRIP001 	sal_Bool NavigatorTree::IsFormComponentEntry( SvLBoxEntry* pEntry )
//STRIP001 	{
//STRIP001 		FmEntryData* pEntryData = (FmEntryData*)pEntry->GetUserData();
//STRIP001 		return pEntryData && pEntryData->ISA(FmControlData);
//STRIP001 	}
//STRIP001 
//STRIP001 	//------------------------------------------------------------------------
//STRIP001 	sal_Bool NavigatorTree::implAcceptPaste( )
//STRIP001 	{
//STRIP001 		SvLBoxEntry* pFirstSelected = FirstSelected();
//STRIP001 		if ( !pFirstSelected || NextSelected( pFirstSelected ) )
//STRIP001 			// no selected entry, or at least two selected entries
//STRIP001 			return sal_False;
//STRIP001 
//STRIP001 		// get the clipboard
//STRIP001 		TransferableDataHelper aClipboardContent( TransferableDataHelper::CreateFromSystemClipboard( this ) );
//STRIP001 
//STRIP001 		sal_Int8 nAction = m_aControlExchange.isClipboardOwner() && doingKeyboardCut( ) ? DND_ACTION_MOVE : DND_ACTION_COPY;
//STRIP001 		return ( nAction == implAcceptDataTransfer( aClipboardContent.GetDataFlavorExVector(), nAction, pFirstSelected, sal_False ) );
//STRIP001 	}
//STRIP001 
//STRIP001 	//------------------------------------------------------------------------
//STRIP001 	sal_Int8 NavigatorTree::implAcceptDataTransfer( const DataFlavorExVector& _rFlavors, sal_Int8 _nAction, const ::Point& _rDropPos, sal_Bool _bDnD )
//STRIP001 	{
//STRIP001 		return implAcceptDataTransfer( _rFlavors, _nAction, GetEntry( _rDropPos ), _bDnD );
//STRIP001 	}
//STRIP001 
//STRIP001 	//------------------------------------------------------------------------
//STRIP001 	sal_Int8 NavigatorTree::implAcceptDataTransfer( const DataFlavorExVector& _rFlavors, sal_Int8 _nAction, SvLBoxEntry* _pTargetEntry, sal_Bool _bDnD )
//STRIP001 	{
//STRIP001 		// no target -> no drop
//STRIP001 		if (!_pTargetEntry)
//STRIP001 			return DND_ACTION_NONE;
//STRIP001 
//STRIP001 		// format check
//STRIP001 		sal_Bool bHasDefControlFormat = OControlExchange::hasFieldExchangeFormat( _rFlavors );
//STRIP001 		sal_Bool bHasControlPathFormat = OControlExchange::hasControlPathFormat( _rFlavors );
//STRIP001 		sal_Bool bHasHiddenControlsFormat = OControlExchange::hasHiddenControlModelsFormat( _rFlavors );
//STRIP001 		if (!bHasDefControlFormat && !bHasControlPathFormat && !bHasHiddenControlsFormat)
//STRIP001 			return DND_ACTION_NONE;
//STRIP001 
//STRIP001 		sal_Bool bSelfSource = _bDnD ? m_aControlExchange.isDragSource() : m_aControlExchange.isClipboardOwner();
//STRIP001 
//STRIP001 		if ( bHasHiddenControlsFormat )
//STRIP001 		{	// bHasHiddenControlsFormat means that only hidden controls are part of the data
//STRIP001 
//STRIP001 			// hidden controls can be copied to a form only
//STRIP001 			if ( !_pTargetEntry || ( _pTargetEntry == m_pRootEntry ) || !IsFormEntry( _pTargetEntry ) )
//STRIP001 				return DND_ACTION_NONE;
//STRIP001 
//STRIP001 			return bSelfSource ? ( DND_ACTION_COPYMOVE & _nAction ) : DND_ACTION_COPY;
//STRIP001 		}
//STRIP001 
//STRIP001 		if	( !bSelfSource )
//STRIP001 		{
//STRIP001 			// DnD or CnP crossing navigator boundaries
//STRIP001 			// The main problem here is that the current API does not allow us to sneak into the content which
//STRIP001 			// is to be inserted. So we have to allow it for the moment, but maybe reject later on (in the real drop).
//STRIP001 
//STRIP001 			// TODO: this smart behaviour later on ... at the moment, we disallow data transfer crossing navigator
//STRIP001 			// boundaries.
//STRIP001 
//STRIP001 			return DND_ACTION_NONE;
//STRIP001 		}
//STRIP001 
//STRIP001 		DBG_ASSERT( _bDnD ? m_aControlExchange.isDragSource() : m_aControlExchange.isClipboardOwner(),
//STRIP001 			"NavigatorTree::implAcceptDataTransfer: here only with source=dest!" );
//STRIP001 			// somebody changed the logic of this method ...
//STRIP001 
//STRIP001 		// from here on, I can work with m_aControlExchange instead of _rData!
//STRIP001 
//STRIP001 		sal_Bool bForeignCollection = m_aControlExchange->getFormsRoot().get() != GetNavModel()->GetFormPage()->GetForms().get();
//STRIP001 		if ( bForeignCollection )
//STRIP001 		{
//STRIP001 			// crossing shell/page boundaries, we can exchange hidden controls only
//STRIP001 			// But if we survived the checks above, we do not have hidden controls.
//STRIP001 			// -> no data transfer
//STRIP001 			DBG_ASSERT( !bHasHiddenControlsFormat, "NavigatorTree::implAcceptDataTransfer: still hidden controls format!" );
//STRIP001 				// somebody changed the logic of this method ...
//STRIP001 
//STRIP001 			return DND_ACTION_COPY;
//STRIP001 		}
//STRIP001 
//STRIP001 		if (DND_ACTION_MOVE != _nAction) // 'normal' controls within a shell are moved only (never copied)
//STRIP001 			return DND_ACTION_NONE;
//STRIP001 
//STRIP001 		if ( m_bDragDataDirty || !bHasDefControlFormat )
//STRIP001 		{
//STRIP001 			if (!bHasControlPathFormat)
//STRIP001 				// ich befinde mich zwar in der Shell/Page, aus der die Controls stammen, habe aber kein Format, das den stattgefundenen
//STRIP001 				// Shell-Wechsel ueberlebt hat (SVX_FM_CONTROLS_AS_PATH)
//STRIP001 				return DND_ACTION_NONE;
//STRIP001 
//STRIP001 			// da die Shell waehrend des Draggens umgeschaltet wude, muss ich die Liste des ExchangeObjektes wieder neu aufbauen
//STRIP001 			// (dort stehen SvLBoxEntries drin, und die sind bei der Umschaltung floeten gegangen)
//STRIP001 			m_aControlExchange->buildListFromPath(this, m_pRootEntry);
//STRIP001 			m_bDragDataDirty = sal_False;
//STRIP001 		}
//STRIP001 
//STRIP001 		// die Liste der gedroppten Eintraege aus dem DragServer
//STRIP001 		ListBoxEntryArray aDropped = m_aControlExchange->selected();
//STRIP001 		DBG_ASSERT(aDropped.size() >= 1, "NavigatorTree::implAcceptDataTransfer: keine Eintraege !");
//STRIP001 
//STRIP001 		sal_Bool bDropTargetIsComponent = IsFormComponentEntry( _pTargetEntry );
//STRIP001 		SvLBoxEntry* pDropTargetParent = GetParent( _pTargetEntry );
//STRIP001 
//STRIP001 		// conditions to disallow the drop
//STRIP001 		// 0) the root entry is part of the list (can't DnD the root!)
//STRIP001 		// 1) one of the draged entries is to be dropped onto it's own parent
//STRIP001 		// 2) -               "       - is to be dropped onto itself
//STRIP001 		// 3) -               "       - is a Form and to be dropped onto one of it's descendants
//STRIP001 		// 4) one of the entries is a control and to be dropped onto the root
//STRIP001 		// 5) a control or form will be dropped onto a control which is _not_ a sibling (dropping onto a sibling
//STRIP001 		//      means moving the control)
//STRIP001 
//STRIP001 		// collect the ancestors of the drop targte (speeds up 3)
//STRIP001 		SvLBoxEntrySortedArray arrDropAnchestors;
//STRIP001 		SvLBoxEntry* pLoop = _pTargetEntry;
//STRIP001 		while (pLoop)
//STRIP001 		{
//STRIP001 			arrDropAnchestors.Insert(pLoop);
//STRIP001 			pLoop = GetParent(pLoop);
//STRIP001 		}
//STRIP001 
//STRIP001 		for (size_t i=0; i<aDropped.size(); i++)
//STRIP001 		{
//STRIP001 			SvLBoxEntry* pCurrent = aDropped[i];
//STRIP001 			SvLBoxEntry* pCurrentParent = GetParent(pCurrent);
//STRIP001 
//STRIP001 			// test for 0)
//STRIP001 			if (pCurrent == m_pRootEntry)
//STRIP001 				return DND_ACTION_NONE;
//STRIP001 
//STRIP001 			// test for 1)
//STRIP001 			if ( _pTargetEntry == pCurrentParent )
//STRIP001 				return DND_ACTION_NONE;
//STRIP001 
//STRIP001 			// test for 2)
//STRIP001 			if (pCurrent == _pTargetEntry)
//STRIP001 				return DND_ACTION_NONE;
//STRIP001 
//STRIP001 			// test for 5)
//STRIP001 	//      if ( bDropTargetIsComponent && (pDropTargetParent != pCurrentParent) )
//STRIP001 				if ( bDropTargetIsComponent )   // TODO : die obige Zeile wieder rein, dann muss aber ExecuteDrop das Vertauschen auch beherrschen
//STRIP001 					return DND_ACTION_NONE;
//STRIP001 
//STRIP001 			// test for 3)
//STRIP001 			if ( IsFormEntry(pCurrent) )
//STRIP001 			{
//STRIP001 				sal_uInt16 nPosition;
//STRIP001 				if ( arrDropAnchestors.Seek_Entry(pCurrent, &nPosition) )
//STRIP001 					return DND_ACTION_NONE;
//STRIP001 			} else if ( IsFormComponentEntry(pCurrent) )
//STRIP001 			{
//STRIP001 				// test for 4)
//STRIP001 				if (_pTargetEntry == m_pRootEntry)
//STRIP001 					return DND_ACTION_NONE;
//STRIP001 			}
//STRIP001 		}
//STRIP001 
//STRIP001 		return DND_ACTION_MOVE;
//STRIP001 	}
//STRIP001 
//STRIP001 	//------------------------------------------------------------------------
//STRIP001 	sal_Int8 NavigatorTree::AcceptDrop( const AcceptDropEvent& rEvt )
//STRIP001 	{
//STRIP001 		::Point aDropPos = rEvt.maPosPixel;
//STRIP001 
//STRIP001 		// kuemmern wir uns erst mal um moeglich DropActions (Scrollen und Aufklappen)
//STRIP001 		if (rEvt.mbLeaving)
//STRIP001 		{
//STRIP001 			if (m_aDropActionTimer.IsActive())
//STRIP001 				m_aDropActionTimer.Stop();
//STRIP001 		} else
//STRIP001 		{
//STRIP001 			sal_Bool bNeedTrigger = sal_False;
//STRIP001 			// auf dem ersten Eintrag ?
//STRIP001 			if ((aDropPos.Y() >= 0) && (aDropPos.Y() < GetEntryHeight()))
//STRIP001 			{
//STRIP001 				m_aDropActionType = DA_SCROLLUP;
//STRIP001 				bNeedTrigger = sal_True;
//STRIP001 			} else
//STRIP001 				// auf dem letzten (bzw. in dem Bereich, den ein Eintrag einnehmen wuerde, wenn er unten genau buendig
//STRIP001 				// abschliessen wuerde) ?
//STRIP001 				if ((aDropPos.Y() < GetSizePixel().Height()) && (aDropPos.Y() >= GetSizePixel().Height() - GetEntryHeight()))
//STRIP001 				{
//STRIP001 					m_aDropActionType = DA_SCROLLDOWN;
//STRIP001 					bNeedTrigger = sal_True;
//STRIP001 				} else
//STRIP001 				{   // auf einem Entry mit Childs, der nicht aufgeklappt ist ?
//STRIP001 					SvLBoxEntry* pDropppedOn = GetEntry(aDropPos);
//STRIP001 					if (pDropppedOn && (GetChildCount(pDropppedOn) > 0) && !IsExpanded(pDropppedOn))
//STRIP001 					{
//STRIP001 						// -> aufklappen
//STRIP001 						m_aDropActionType = DA_EXPANDNODE;
//STRIP001 						bNeedTrigger = sal_True;
//STRIP001 					}
//STRIP001 				}
//STRIP001 
//STRIP001 			if (bNeedTrigger && (m_aTimerTriggered != aDropPos))
//STRIP001 			{
//STRIP001 				// neu anfangen zu zaehlen
//STRIP001 				m_aTimerCounter = DROP_ACTION_TIMER_INITIAL_TICKS;
//STRIP001 				// die Pos merken, da ich auch AcceptDrops bekomme, wenn sich die Maus gar nicht bewegt hat
//STRIP001 				m_aTimerTriggered = aDropPos;
//STRIP001 				// und den Timer los
//STRIP001 				if (!m_aDropActionTimer.IsActive()) // gibt es den Timer schon ?
//STRIP001 				{
//STRIP001 					m_aDropActionTimer.SetTimeout(DROP_ACTION_TIMER_TICK_BASE);
//STRIP001 					m_aDropActionTimer.Start();
//STRIP001 				}
//STRIP001 			} else if (!bNeedTrigger)
//STRIP001 				m_aDropActionTimer.Stop();
//STRIP001 		}
//STRIP001 
//STRIP001 		return implAcceptDataTransfer( GetDataFlavorExVector(), rEvt.mnAction, aDropPos, sal_True );
//STRIP001 	}
//STRIP001 
//STRIP001 	//------------------------------------------------------------------------
//STRIP001 	sal_Int8 NavigatorTree::implExecuteDataTransfer( const OControlTransferData& _rData, sal_Int8 _nAction, const ::Point& _rDropPos, sal_Bool _bDnD )
//STRIP001 	{
//STRIP001 		return implExecuteDataTransfer( _rData, _nAction, GetEntry( _rDropPos ), _bDnD );
//STRIP001 	}
//STRIP001 
//STRIP001 	//------------------------------------------------------------------------
//STRIP001 	sal_Int8 NavigatorTree::implExecuteDataTransfer( const OControlTransferData& _rData, sal_Int8 _nAction, SvLBoxEntry* _pTargetEntry, sal_Bool _bDnD )
//STRIP001 	{
//STRIP001 		const DataFlavorExVector& rDataFlavors = _rData.GetDataFlavorExVector();
//STRIP001 
//STRIP001 		if ( DND_ACTION_NONE == implAcceptDataTransfer( rDataFlavors, _nAction, _pTargetEntry, _bDnD ) )
//STRIP001 			// under some platforms, it may happen that ExecuteDrop is called though AcceptDrop returned DND_ACTION_NONE
//STRIP001 			return DND_ACTION_NONE;
//STRIP001 
//STRIP001 		// ware schlecht, wenn nach dem Droppen noch gescrollt wird ...
//STRIP001 		if (m_aDropActionTimer.IsActive())
//STRIP001 			m_aDropActionTimer.Stop();
//STRIP001 
//STRIP001 		if (!_pTargetEntry)
//STRIP001 			// no target -> no drop
//STRIP001 			return DND_ACTION_NONE;
//STRIP001 
//STRIP001 		// format checks
//STRIP001 		sal_Bool bHasHiddenControlsFormat = OControlExchange::hasHiddenControlModelsFormat( rDataFlavors );
//STRIP001 		sal_Bool bForeignCollection = _rData.getFormsRoot().get() != GetNavModel()->GetFormPage()->GetForms().get();
//STRIP001 #ifdef DBG_UTIL
//STRIP001 		DBG_ASSERT(!bForeignCollection || bHasHiddenControlsFormat, "NavigatorTree::implExecuteDataTransfer: invalid format (AcceptDrop shouldn't have let this pass) !");
//STRIP001 		DBG_ASSERT(bForeignCollection || !m_bDragDataDirty, "NavigatorTree::implExecuteDataTransfer: invalid state (shell changed since last exchange resync) !");
//STRIP001 			// das sollte in AcceptDrop erledigt worden sein : dort wird in _rData die Liste der Controls aufgebaut und m_bDragDataDirty
//STRIP001 			// zurueckgesetzt
//STRIP001 #endif
//STRIP001 
//STRIP001 		if ( DND_ACTION_COPY == _nAction )
//STRIP001 		{	// bHasHiddenControlsFormat means that only hidden controls are part of the data
//STRIP001 			DBG_ASSERT( bHasHiddenControlsFormat, "NavigatorTree::implExecuteDataTransfer: copy allowed for hidden controls only!" );
//STRIP001 			DBG_ASSERT( _pTargetEntry && ( _pTargetEntry != m_pRootEntry ) && IsFormEntry( _pTargetEntry ),
//STRIP001 				"NavigatorTree::implExecuteDataTransfer: should not be here!" );
//STRIP001 				// implAcceptDataTransfer should have caught both cases
//STRIP001 
//STRIP001 			DBG_ASSERT(bHasHiddenControlsFormat, "NavigatorTree::implExecuteDataTransfer: only copying of hidden controls is supported !");
//STRIP001 				// das sollte das AcceptDrop abgefangen haben
//STRIP001 
//STRIP001 			// da ich gleich die Zielobjekte alle selektieren will (und nur die)
//STRIP001 			SelectAll(sal_False);
//STRIP001 
//STRIP001 			Sequence< Reference< XInterface > > aControls = _rData.hiddenControls();
//STRIP001 			sal_Int32 nCount = aControls.getLength();
//STRIP001 			const Reference< XInterface >* pControls = aControls.getConstArray();
//STRIP001 
//STRIP001 			FmFormShell* pFormShell = GetNavModel()->GetFormShell();
//STRIP001 			FmFormModel* pFormModel = pFormShell ? pFormShell->GetFormModel() : NULL;
//STRIP001 
//STRIP001 			// innerhalb eines Undo ...
//STRIP001 			if (pFormModel)
//STRIP001 			{
//STRIP001 				XubString aStr(SVX_RES(RID_STR_CONTROL));
//STRIP001 				XubString aUndoStr(SVX_RES(RID_STR_UNDO_CONTAINER_INSERT));
//STRIP001 				aUndoStr.SearchAndReplace('#', aStr);
//STRIP001 				pFormModel->BegUndo(aUndoStr);
//STRIP001 			}
//STRIP001 
//STRIP001 			// die Conrtols kopieren
//STRIP001 			for (sal_Int32 i=0; i<nCount; ++i)
//STRIP001 			{
//STRIP001 				// neues Control anlegen
//STRIP001 				::rtl::OUString fControlName = FM_COMPONENT_HIDDEN;
//STRIP001 				FmControlData* pNewControlData = NewControl( fControlName, _pTargetEntry, sal_False);
//STRIP001 				Reference< XPropertySet >  xNewPropSet( pNewControlData->GetPropertySet() );
//STRIP001 
//STRIP001 				// und die Properties des alten in das neue kopieren
//STRIP001 				Reference< XPropertySet >  xCurrent(pControls[i], UNO_QUERY);
//STRIP001 #if (OSL_DEBUG_LEVEL > 1) || DBG_UTIL
//STRIP001 				// nur mal eben sehen, ob das Ding tatsaechlich ein hidden control ist
//STRIP001 				sal_Int16 nClassId = ::comphelper::getINT16(xCurrent->getPropertyValue(FM_PROP_CLASSID));
//STRIP001 				DBG_ASSERT(nClassId == FormComponentType::HIDDENCONTROL, "NavigatorTree::implExecuteDataTransfer: invalid control in drop list !");
//STRIP001 					// wenn das SVX_FM_HIDDEN_CONTROLS-Format vorhanden ist, dann sollten wirklich nur hidden controls in der Sequenz
//STRIP001 					// stecken
//STRIP001 #endif // (OSL_DEBUG_LEVEL > 1) || DBG_UTIL
//STRIP001 				Reference< XPropertySetInfo >  xPropInfo( xCurrent->getPropertySetInfo());
//STRIP001 				Sequence< Property> seqAllCurrentProps = xPropInfo->getProperties();
//STRIP001 				Property* pAllCurrentProps = seqAllCurrentProps.getArray();
//STRIP001 				for (sal_Int32 j=0; j<seqAllCurrentProps.getLength(); ++j)
//STRIP001 				{
//STRIP001 					::rtl::OUString sCurrentProp = pAllCurrentProps[j].Name;
//STRIP001 					if (((pAllCurrentProps[j].Attributes & PropertyAttribute::READONLY) == 0) && (sCurrentProp != FM_PROP_NAME))
//STRIP001 					{   // (read-only attribs werden natuerlich nicht gesetzt, dito der Name, den hat das NewControl schon eindeutig
//STRIP001 						// festgelegt)
//STRIP001 						xNewPropSet->setPropertyValue(sCurrentProp, xCurrent->getPropertyValue(sCurrentProp));
//STRIP001 					}
//STRIP001 				}
//STRIP001 
//STRIP001 				SvLBoxEntry* pToSelect = FindEntry(pNewControlData);
//STRIP001 				Select(pToSelect, sal_True);
//STRIP001 				if (i == 0)
//STRIP001 					SetCurEntry(pToSelect);
//STRIP001 			}
//STRIP001 
//STRIP001 			if (pFormModel)
//STRIP001 				pFormModel->EndUndo();
//STRIP001 
//STRIP001 			return _nAction;
//STRIP001 		}
//STRIP001 
//STRIP001 		if ( !OControlExchange::hasFieldExchangeFormat( _rData.GetDataFlavorExVector() ) )
//STRIP001 		{
//STRIP001 			// can't do anything without the internal format here ... usually happens when doing DnD or CnP
//STRIP001 			// over navigator boundaries
//STRIP001 			return DND_ACTION_NONE;
//STRIP001 		}
//STRIP001 
//STRIP001 		// some data for the target
//STRIP001 		sal_Bool bDropTargetIsForm = IsFormEntry(_pTargetEntry);
//STRIP001 		FmFormData* pTargetData = bDropTargetIsForm ? (FmFormData*)_pTargetEntry->GetUserData() : NULL;
//STRIP001 
//STRIP001 		DBG_ASSERT( DND_ACTION_COPY != _nAction, "NavigatorTree::implExecuteDataTransfer: somebody changed the logics!" );
//STRIP001 
//STRIP001 		// die Liste der gedraggten Eintraege
//STRIP001 		const ListBoxEntryArray& aDropped = _rData.selected();
//STRIP001 		DBG_ASSERT(aDropped.size() >= 1, "NavigatorTree::implExecuteDataTransfer: no entries!");
//STRIP001 
//STRIP001 		// die Shell und das Model
//STRIP001 		FmFormShell* pFormShell = GetNavModel()->GetFormShell();
//STRIP001 		FmFormModel* pFormModel = pFormShell ? pFormShell->GetFormModel() : NULL;
//STRIP001 		if (!pFormModel)
//STRIP001 			return DND_ACTION_NONE;
//STRIP001 
//STRIP001 		// fuer's Undo
//STRIP001 		XubString strUndoDescription(SVX_RES(RID_STR_UNDO_CONTAINER_REPLACE));
//STRIP001 			// TODO : den ::rtl::OUString aussagekraeftiger machen
//STRIP001 		pFormModel->BegUndo(strUndoDescription);
//STRIP001 
//STRIP001 		// ich nehme vor dem Einfuegen eines Eintrages seine Selection raus, damit die Markierung dabei nicht flackert
//STRIP001 		// -> das Handeln des Select locken
//STRIP001 		LockSelectionHandling();
//STRIP001 
//STRIP001 		// jetzt durch alle gedroppten Eintraege ...
//STRIP001 		for (size_t i=0; i<aDropped.size(); ++i)
//STRIP001 		{
//STRIP001 			// ein paar Daten zum aktuellen Element
//STRIP001 			SvLBoxEntry* pCurrent = aDropped[i];
//STRIP001 			DBG_ASSERT(pCurrent != NULL, "NavigatorTree::implExecuteDataTransfer: ungueltiger Eintrag");
//STRIP001 			DBG_ASSERT(GetParent(pCurrent) != NULL, "NavigatorTree::implExecuteDataTransfer: ungueltiger Eintrag");
//STRIP001 				// die Root darf nicht gedraggt werden
//STRIP001 
//STRIP001 			FmEntryData* pCurrentUserData = (FmEntryData*)pCurrent->GetUserData();
//STRIP001 
//STRIP001 			Reference< XChild >  xCurrentChild(pCurrentUserData->GetChildIFace(), UNO_QUERY);
//STRIP001 			Reference< XIndexContainer >  xContainer(xCurrentChild->getParent(), UNO_QUERY);
//STRIP001 
//STRIP001 
//STRIP001 			FmFormData* pCurrentParentUserData = (FmFormData*)pCurrentUserData->GetParent();
//STRIP001 			DBG_ASSERT(pCurrentParentUserData == NULL || pCurrentParentUserData->ISA(FmFormData), "NavigatorTree::implExecuteDataTransfer: ungueltiges Parent");
//STRIP001 
//STRIP001 			// beim Vater austragen
//STRIP001 			if (pCurrentParentUserData)
//STRIP001 				pCurrentParentUserData->GetChildList()->Remove(pCurrentUserData);
//STRIP001 			else
//STRIP001 				GetNavModel()->GetRootList()->Remove(pCurrentUserData);
//STRIP001 
//STRIP001 			// aus dem Container entfernen
//STRIP001 			sal_Int32 nIndex = getElementPos(Reference< XIndexAccess > (xContainer, UNO_QUERY), xCurrentChild);
//STRIP001 			GetNavModel()->m_pPropChangeList->Lock();
//STRIP001 			// die Undo-Action fuer das Rausnehmen
//STRIP001 			if (GetNavModel()->m_pPropChangeList->CanUndo())
//STRIP001 				pFormModel->AddUndo(new FmUndoContainerAction(*pFormModel, FmUndoContainerAction::Removed,
//STRIP001 															xContainer, xCurrentChild, nIndex));
//STRIP001 
//STRIP001 			// Events mitkopieren
//STRIP001 			Reference< XEventAttacherManager >  xManager(xContainer, UNO_QUERY);
//STRIP001 			Sequence< ScriptEventDescriptor > aEvts;
//STRIP001 
//STRIP001 			if (xManager.is() && nIndex >= 0)
//STRIP001 				aEvts = xManager->getScriptEvents(nIndex);
//STRIP001 			xContainer->removeByIndex(nIndex);
//STRIP001 
//STRIP001 			// die Selection raus
//STRIP001 			Select(pCurrent, sal_False);
//STRIP001 			// und weg
//STRIP001 			Remove(pCurrentUserData);
//STRIP001 
//STRIP001 
//STRIP001 			// die Stelle innerhalb des DropParents, an der ich die gedroppten Eintraege einfuegen muss
//STRIP001 			if (pTargetData)
//STRIP001 				xContainer = Reference< XIndexContainer > (pTargetData->GetElement(), UNO_QUERY);
//STRIP001 			else
//STRIP001 				xContainer = Reference< XIndexContainer > (GetNavModel()->GetForms(), UNO_QUERY);
//STRIP001 
//STRIP001 			// immer ganz hinten einfuegen
//STRIP001 			nIndex = xContainer->getCount();
//STRIP001 
//STRIP001 			// UndoAction fuer das Einfuegen
//STRIP001 			if (GetNavModel()->m_pPropChangeList->CanUndo())
//STRIP001 				pFormModel->AddUndo(new FmUndoContainerAction(*pFormModel, FmUndoContainerAction::Inserted,
//STRIP001 														 xContainer, xCurrentChild, nIndex));
//STRIP001 
//STRIP001 			// einfuegen im neuen Container
//STRIP001 			if (pTargetData)
//STRIP001 			{
//STRIP001 				 // es wird in eine Form eingefuegt, dann brauche ich eine FormComponent
//STRIP001 				xContainer->insertByIndex(nIndex,
//STRIP001 					makeAny(Reference<
//STRIP001 					XFormComponent>(xCurrentChild, UNO_QUERY)));
//STRIP001 			}
//STRIP001 			else
//STRIP001 			{
//STRIP001 				xContainer->insertByIndex(nIndex,
//STRIP001 					makeAny(Reference<
//STRIP001 					XForm>(xCurrentChild, UNO_QUERY)));
//STRIP001 			}
//STRIP001 
//STRIP001 			if (aEvts.getLength())
//STRIP001 			{
//STRIP001 				xManager = Reference< XEventAttacherManager > (xContainer, UNO_QUERY);
//STRIP001 				if (xManager.is())
//STRIP001 					xManager->registerScriptEvents(nIndex, aEvts);
//STRIP001 			}
//STRIP001 
//STRIP001 			GetNavModel()->m_pPropChangeList->UnLock();
//STRIP001 
//STRIP001 			// zuerst dem Eintrag das neue Parent
//STRIP001 			pCurrentUserData->SetParent(pTargetData);
//STRIP001 
//STRIP001 			// dann dem Parent das neue Child
//STRIP001 			if (pTargetData)
//STRIP001 				pTargetData->GetChildList()->Insert(pCurrentUserData, nIndex);
//STRIP001 			else
//STRIP001 				GetNavModel()->GetRootList()->Insert(pCurrentUserData, nIndex);
//STRIP001 
//STRIP001 			// dann bei mir selber bekanntgeben und neu selektieren
//STRIP001 			SvLBoxEntry* pNew = Insert( pCurrentUserData, nIndex );
//STRIP001 			if ( ( 0 == i ) && pNew )
//STRIP001 			{
//STRIP001 				SvLBoxEntry* pParent = GetParent( pNew );
//STRIP001 				if ( pParent )
//STRIP001 					Expand( pParent );
//STRIP001 			}
//STRIP001 		}
//STRIP001 
//STRIP001 		UnlockSelectionHandling();
//STRIP001 		pFormModel->EndUndo();
//STRIP001 
//STRIP001 		// During the move, the markings of the underlying view did not change (because the view is not affected by the logical
//STRIP001 		// hierarchy of the form/control models. But my selection changed - which means I have to adjust it according to the
//STRIP001 		// view marks, again.
//STRIP001 		SynchronizeSelection();
//STRIP001 
//STRIP001 		// in addition, with the move of controls such things as "the current form" may have changed - force the shell
//STRIP001 		// to update itself accordingly
//STRIP001 		if( pFormShell && pFormShell->GetImpl() && pFormShell->GetFormView() )
//STRIP001 			pFormShell->GetImpl()->DetermineSelection( pFormShell->GetFormView()->GetMarkList() );
//STRIP001 
//STRIP001 		if ( m_aControlExchange.isClipboardOwner() && ( DND_ACTION_MOVE == _nAction ) )
//STRIP001 			m_aControlExchange->clear();
//STRIP001 
//STRIP001 		return _nAction;
//STRIP001 	}
//STRIP001 
//STRIP001 	//------------------------------------------------------------------------
//STRIP001 	sal_Int8 NavigatorTree::ExecuteDrop( const ExecuteDropEvent& rEvt )
//STRIP001 	{
//STRIP001 		sal_Int8 nResult( DND_ACTION_NONE );
//STRIP001 
//STRIP001 		if ( m_aControlExchange.isDragSource() )
//STRIP001 			nResult = implExecuteDataTransfer( *m_aControlExchange, rEvt.mnAction, rEvt.maPosPixel, sal_True );
//STRIP001 		else
//STRIP001 		{
//STRIP001 			OControlTransferData aDroppedData( rEvt.maDropEvent.Transferable );
//STRIP001 			nResult = implExecuteDataTransfer( aDroppedData, rEvt.mnAction, rEvt.maPosPixel, sal_True );
//STRIP001 		}
//STRIP001 
//STRIP001 		return nResult;
//STRIP001 	}
//STRIP001 
//STRIP001 	//------------------------------------------------------------------------
//STRIP001 	void NavigatorTree::doPaste()
//STRIP001 	{
//STRIP001    		try
//STRIP001     	{
//STRIP001 			if ( m_aControlExchange.isClipboardOwner() )
//STRIP001 			{
//STRIP001 				implExecuteDataTransfer( *m_aControlExchange, doingKeyboardCut( ) ? DND_ACTION_MOVE : DND_ACTION_COPY, FirstSelected(), sal_False );
//STRIP001 			}
//STRIP001 			else
//STRIP001 			{
//STRIP001 				// the clipboard content
//STRIP001 				Reference< XClipboard >	xClipboard( GetClipboard() );
//STRIP001 				Reference< XTransferable > xTransferable;
//STRIP001 				if ( xClipboard.is() )
//STRIP001 	    			xTransferable = xClipboard->getContents();
//STRIP001 
//STRIP001 				OControlTransferData aClipboardContent( xTransferable );
//STRIP001 				implExecuteDataTransfer( aClipboardContent, DND_ACTION_COPY, FirstSelected(), sal_False );
//STRIP001 			}
//STRIP001 		}
//STRIP001 		catch( const Exception& )
//STRIP001 		{
//STRIP001 			DBG_ERROR( "NavigatorTree::doPaste: caught an exception!" );
//STRIP001 		}
//STRIP001 	}
//STRIP001 
//STRIP001 	//------------------------------------------------------------------------
//STRIP001 	void NavigatorTree::doCopy()
//STRIP001 	{
//STRIP001 		if ( implPrepareExchange( DND_ACTION_COPY ) )
//STRIP001 		{
//STRIP001 			m_aControlExchange.setClipboardListener( LINK( this, NavigatorTree, OnClipboardAction ) );
//STRIP001 			m_aControlExchange.copyToClipboard( );
//STRIP001 		}
//STRIP001 	}
//STRIP001 
//STRIP001 	//------------------------------------------------------------------------
//STRIP001 	void NavigatorTree::ModelHasRemoved( SvListEntry* _pEntry )
//STRIP001 	{
//STRIP001 		sal_uInt16 nPosition;
//STRIP001 		if ( m_aCutEntries.Seek_Entry( static_cast< SvLBoxEntry* >( _pEntry ), &nPosition ) )
//STRIP001 		{
//STRIP001 			m_aCutEntries.Remove( nPosition );
//STRIP001 		}
//STRIP001 	}
//STRIP001 
//STRIP001 	//------------------------------------------------------------------------
//STRIP001 	void NavigatorTree::doCut()
//STRIP001 	{
//STRIP001 		if ( implPrepareExchange( DND_ACTION_MOVE ) )
//STRIP001 		{
//STRIP001 			m_aControlExchange.setClipboardListener( LINK( this, NavigatorTree, OnClipboardAction ) );
//STRIP001 			m_aControlExchange.copyToClipboard( );
//STRIP001 			m_bKeyboardCut = sal_True;
//STRIP001 
//STRIP001 			// mark all the entries we just "cut" into the clipboard as "nearly moved"
//STRIP001 			for ( sal_Int32 i=0; i<m_arrCurrentSelection.Count(); ++i )
//STRIP001 			{
//STRIP001 				SvLBoxEntry* pEntry = m_arrCurrentSelection[ (sal_uInt16)i ];
//STRIP001 				if ( pEntry )
//STRIP001 				{
//STRIP001 					m_aCutEntries.Insert( pEntry );
//STRIP001 					pEntry->SetFlags( pEntry->GetFlags() | SV_ENTRYFLAG_SEMITRANSPARENT );
//STRIP001 					InvalidateEntry( pEntry );
//STRIP001 				}
//STRIP001 			}
//STRIP001 		}
//STRIP001 	}
//STRIP001 
//STRIP001 	//------------------------------------------------------------------------
//STRIP001 	void NavigatorTree::KeyInput(const ::KeyEvent& rKEvt)
//STRIP001 	{
//STRIP001 		const KeyCode& rCode = rKEvt.GetKeyCode();
//STRIP001 
//STRIP001 		// delete?
//STRIP001 		if (rKEvt.GetKeyCode().GetCode() == KEY_DELETE && !rKEvt.GetKeyCode().GetModifier())
//STRIP001 		{
//STRIP001 			DeleteSelection();
//STRIP001 			return;
//STRIP001 		}
//STRIP001 
//STRIP001 		// copy'n'paste?
//STRIP001 		switch ( rCode.GetFunction() )
//STRIP001 		{
//STRIP001 			case KEYFUNC_CUT:
//STRIP001 				doCut();
//STRIP001 				break;
//STRIP001 
//STRIP001 			case KEYFUNC_PASTE:
//STRIP001 				if ( implAcceptPaste() )
//STRIP001 					doPaste();
//STRIP001 				break;
//STRIP001 
//STRIP001 			case KEYFUNC_COPY:
//STRIP001 				doCopy();
//STRIP001 				break;
//STRIP001 		}
//STRIP001 
//STRIP001 		SvTreeListBox::KeyInput(rKEvt);
//STRIP001 	}
//STRIP001 
//STRIP001 	//------------------------------------------------------------------------
//STRIP001 	sal_Bool NavigatorTree::EditingEntry( SvLBoxEntry* pEntry, Selection& rSelection )
//STRIP001 	{
//STRIP001 		if (!SvTreeListBox::EditingEntry( pEntry, rSelection ))
//STRIP001 			return sal_False;
//STRIP001 
//STRIP001 		return (pEntry && (pEntry->GetUserData() != NULL));
//STRIP001 			// die Wurzel, die ich nicht umbenennen darf, hat als UserData NULL
//STRIP001 	}
//STRIP001 
//STRIP001 	//------------------------------------------------------------------------
//STRIP001 	void NavigatorTree::NewForm( SvLBoxEntry* pParentEntry )
//STRIP001 	{
//STRIP001 		//////////////////////////////////////////////////////////////////////
//STRIP001 		// ParentFormData holen
//STRIP001 		if( !IsFormEntry(pParentEntry) )
//STRIP001 			return;
//STRIP001 
//STRIP001 		FmFormData* pParentFormData = (FmFormData*)pParentEntry->GetUserData();
//STRIP001 
//STRIP001 		//////////////////////////////////////////////////////////////////////
//STRIP001 		// Neue Form erzeugen
//STRIP001 		Reference< XForm >  xNewForm(m_xORB->createInstance(FM_SUN_COMPONENT_FORM), UNO_QUERY);
//STRIP001 		if (!xNewForm.is())
//STRIP001 			return;
//STRIP001 
//STRIP001 		FmFormData* pNewFormData = new FmFormData( xNewForm, m_aNavigatorImages, m_aNavigatorImagesHC, pParentFormData );
//STRIP001 
//STRIP001 		//////////////////////////////////////////////////////////////////////
//STRIP001 		// Namen setzen
//STRIP001 		::rtl::OUString aName = GenerateName(pNewFormData);
//STRIP001 		pNewFormData->SetText(aName);
//STRIP001 
//STRIP001 		Reference< XPropertySet >  xPropertySet(xNewForm, UNO_QUERY);
//STRIP001 		if (!xPropertySet.is())
//STRIP001 			return;
//STRIP001 		try
//STRIP001 		{
//STRIP001 			xPropertySet->setPropertyValue( FM_PROP_NAME, makeAny(aName) );
//STRIP001 			// a form should always have the command type table as default
//STRIP001 			xPropertySet->setPropertyValue( FM_PROP_COMMANDTYPE, makeAny(sal_Int32(CommandType::TABLE)));
//STRIP001 		}
//STRIP001 		catch ( const Exception& )
//STRIP001 		{
//STRIP001 			DBG_ERROR("NavigatorTree::NewForm : could not set esssential properties !");
//STRIP001 		}
//STRIP001 
//STRIP001 
//STRIP001 		//////////////////////////////////////////////////////////////////////
//STRIP001 		// Form einfuegen
//STRIP001 		GetNavModel()->Insert( pNewFormData, LIST_APPEND, sal_True );
//STRIP001 
//STRIP001 		//////////////////////////////////////////////////////////////////////
//STRIP001 		// Neue Form als aktive Form setzen
//STRIP001 		FmFormShell* pFormShell = GetNavModel()->GetFormShell();
//STRIP001 		if( pFormShell )
//STRIP001 		{
//STRIP001 			pFormShell->GetImpl()->setCurForm( xNewForm );
//STRIP001 			pFormShell->GetCurPage()->GetImpl()->setCurForm( xNewForm );
//STRIP001 
//STRIP001 			pFormShell->GetViewShell()->GetViewFrame()->GetBindings().Invalidate(SID_FM_PROPERTIES,sal_True,sal_True);
//STRIP001 		}
//STRIP001 		GetNavModel()->SetModified();
//STRIP001 
//STRIP001 		//////////////////////////////////////////////////////////////////////
//STRIP001 		// In EditMode schalten
//STRIP001 		SvLBoxEntry* pNewEntry = FindEntry( pNewFormData );
//STRIP001 		EditEntry( pNewEntry );
//STRIP001 	}
//STRIP001 
//STRIP001 	//------------------------------------------------------------------------
//STRIP001 	FmControlData* NavigatorTree::NewControl( const ::rtl::OUString& rServiceName, SvLBoxEntry* pParentEntry, sal_Bool bEditName )
//STRIP001 	{
//STRIP001 		//////////////////////////////////////////////////////////////////////
//STRIP001 		// ParentForm holen
//STRIP001 		if (!GetNavModel()->GetFormShell())
//STRIP001 			return NULL;
//STRIP001 		if (!IsFormEntry(pParentEntry))
//STRIP001 			return NULL;
//STRIP001 
//STRIP001 		FmFormData* pParentFormData = (FmFormData*)pParentEntry->GetUserData();;
//STRIP001 		Reference< XForm >  xParentForm( pParentFormData->GetFormIface());
//STRIP001 
//STRIP001 		//////////////////////////////////////////////////////////////////////
//STRIP001 		// Neue Component erzeugen
//STRIP001 		Reference< XFormComponent >  xNewComponent(::legacy_binfilters::getLegacyProcessServiceFactory()->createInstance(rServiceName), UNO_QUERY);
//STRIP001 		if (!xNewComponent.is())
//STRIP001 			return NULL;
//STRIP001 
//STRIP001 		FmControlData* pNewFormControlData = new FmControlData( xNewComponent, m_aNavigatorImages, m_aNavigatorImagesHC, pParentFormData );
//STRIP001 
//STRIP001 		//////////////////////////////////////////////////////////////////////
//STRIP001 		// Namen setzen
//STRIP001 		FmFormView*     pFormView       = GetNavModel()->GetFormShell()->GetFormView();
//STRIP001 		SdrPageView*    pPageView       = pFormView->GetPageViewPvNum(0);
//STRIP001 		FmFormPage*     pPage           = (FmFormPage*)pPageView->GetPage();
//STRIP001 
//STRIP001 		::rtl::OUString sName = pPage->GetImpl()->setUniqueName( xNewComponent, xParentForm );
//STRIP001 
//STRIP001 		pNewFormControlData->SetText( sName );
//STRIP001 
//STRIP001 		//////////////////////////////////////////////////////////////////////
//STRIP001 		// FormComponent einfuegen
//STRIP001 		GetNavModel()->Insert( pNewFormControlData, LIST_APPEND, sal_True );
//STRIP001 		GetNavModel()->SetModified();
//STRIP001 
//STRIP001 		if (bEditName)
//STRIP001 		{
//STRIP001 			//////////////////////////////////////////////////////////////////////
//STRIP001 			// In EditMode schalten
//STRIP001 			SvLBoxEntry* pNewEntry = FindEntry( pNewFormControlData );
//STRIP001 			Select( pNewEntry, sal_True );
//STRIP001 			EditEntry( pNewEntry );
//STRIP001 		}
//STRIP001 
//STRIP001 		return pNewFormControlData;
//STRIP001 	}
//STRIP001 
//STRIP001 	//------------------------------------------------------------------------
//STRIP001 	::rtl::OUString NavigatorTree::GenerateName( FmEntryData* pEntryData )
//STRIP001 	{
//STRIP001 		const sal_uInt16 nMaxCount = 99;
//STRIP001 		::rtl::OUString aNewName;
//STRIP001 
//STRIP001 		//////////////////////////////////////////////////////////////////////
//STRIP001 		// BasisNamen erzeugen
//STRIP001 		UniString aBaseName;
//STRIP001 		if( pEntryData->ISA(FmFormData) )
//STRIP001 			aBaseName = SVX_RES( RID_STR_STDFORMNAME );
//STRIP001 
//STRIP001 		else if( pEntryData->ISA(FmControlData) )
//STRIP001 			aBaseName = SVX_RES( RID_STR_CONTROL_CLASSNAME );
//STRIP001 
//STRIP001 		//////////////////////////////////////////////////////////////////////
//STRIP001 		// Neuen Namen erstellen
//STRIP001 		FmFormData* pFormParentData = (FmFormData*)pEntryData->GetParent();
//STRIP001 
//STRIP001 		for( sal_Int32 i=0; i<nMaxCount; i++ )
//STRIP001 		{
//STRIP001 			aNewName = aBaseName;
//STRIP001 			if( i>0 )
//STRIP001 			{
//STRIP001 				aNewName += ::rtl::OUString::createFromAscii(" ");
//STRIP001 				aNewName += ::rtl::OUString::valueOf(i).getStr();
//STRIP001 			}
//STRIP001 
//STRIP001 			if( GetNavModel()->FindData(aNewName, pFormParentData,sal_False) == NULL )
//STRIP001 				break;
//STRIP001 		}
//STRIP001 
//STRIP001 		return aNewName;
//STRIP001 	}
//STRIP001 
//STRIP001 	//------------------------------------------------------------------------
//STRIP001 	sal_Bool NavigatorTree::EditedEntry( SvLBoxEntry* pEntry, const XubString& rNewText )
//STRIP001 	{
//STRIP001 		if (EditingCanceled())
//STRIP001 			return sal_True;
//STRIP001 
//STRIP001 		GrabFocus();
//STRIP001 		FmEntryData* pEntryData = (FmEntryData*)pEntry->GetUserData();
//STRIP001 		sal_Bool bRes = GetNavModel()->Rename( pEntryData, rNewText);
//STRIP001 		if( !bRes )
//STRIP001 		{
//STRIP001 			m_pEditEntry = pEntry;
//STRIP001 			nEditEvent = Application::PostUserEvent( LINK(this, NavigatorTree, OnEdit) );
//STRIP001 		} else
//STRIP001 			SetCursor(pEntry, sal_True);
//STRIP001 
//STRIP001 		return bRes;
//STRIP001 	}
//STRIP001 
//STRIP001 	//------------------------------------------------------------------------
//STRIP001 	IMPL_LINK( NavigatorTree, OnEdit, void*, EMPTYARG )
//STRIP001 	{
//STRIP001 		nEditEvent = 0;
//STRIP001 		EditEntry( m_pEditEntry );
//STRIP001 		m_pEditEntry = NULL;
//STRIP001 
//STRIP001 		return 0L;
//STRIP001 	}
//STRIP001 
//STRIP001 	//------------------------------------------------------------------------
//STRIP001 	IMPL_LINK( NavigatorTree, OnDropActionTimer, void*, EMPTYARG )
//STRIP001 	{
//STRIP001 		if (--m_aTimerCounter > 0)
//STRIP001 			return 0L;
//STRIP001 
//STRIP001 		if (m_aDropActionType == DA_EXPANDNODE)
//STRIP001 		{
//STRIP001 			SvLBoxEntry* pToExpand = GetEntry(m_aTimerTriggered);
//STRIP001 			if (pToExpand && (GetChildCount(pToExpand) > 0) &&  !IsExpanded(pToExpand))
//STRIP001 				// tja, eigentlich muesste ich noch testen, ob die Node nicht schon expandiert ist, aber ich
//STRIP001 				// habe dazu weder in den Basisklassen noch im Model eine Methode gefunden ...
//STRIP001 				// aber ich denke, die BK sollte es auch so vertragen
//STRIP001 				Expand(pToExpand);
//STRIP001 
//STRIP001 			// nach dem Expand habe ich im Gegensatz zum Scrollen natuerlich nix mehr zu tun
//STRIP001 			m_aDropActionTimer.Stop();
//STRIP001 		} else
//STRIP001 		{
//STRIP001 			switch (m_aDropActionType)
//STRIP001 			{
//STRIP001 				case DA_SCROLLUP :
//STRIP001 				{
//STRIP001 					ScrollOutputArea(1);
//STRIP001 					break;
//STRIP001 				}
//STRIP001 
//STRIP001 				case DA_SCROLLDOWN :
//STRIP001 					ScrollOutputArea(-1);
//STRIP001 					break;
//STRIP001 			}
//STRIP001 
//STRIP001 			m_aTimerCounter = DROP_ACTION_TIMER_SCROLL_TICKS;
//STRIP001 		}
//STRIP001 
//STRIP001 		return 0L;
//STRIP001 	}
//STRIP001 
//STRIP001 	//------------------------------------------------------------------------
//STRIP001 	IMPL_LINK(NavigatorTree, OnEntrySelDesel, NavigatorTree*, pThis)
//STRIP001 	{
//STRIP001 		m_sdiState = SDI_DIRTY;
//STRIP001 
//STRIP001 		if (IsSelectionHandlingLocked())
//STRIP001 			return 0L;
//STRIP001 
//STRIP001 		if (m_aSynchronizeTimer.IsActive())
//STRIP001 			m_aSynchronizeTimer.Stop();
//STRIP001 
//STRIP001 		m_aSynchronizeTimer.SetTimeout(EXPLORER_SYNC_DELAY);
//STRIP001 		m_aSynchronizeTimer.Start();
//STRIP001 
//STRIP001 		return 0L;
//STRIP001 	}
//STRIP001 
//STRIP001 	//------------------------------------------------------------------------
//STRIP001 	IMPL_LINK(NavigatorTree, OnSynchronizeTimer, void*, EMPTYARG)
//STRIP001 	{
//STRIP001 		SynchronizeMarkList();
//STRIP001 		return 0L;
//STRIP001 	}
//STRIP001 
//STRIP001 
//STRIP001 	//------------------------------------------------------------------------
//STRIP001 	IMPL_LINK( NavigatorTree, OnClipboardAction, void*, EMPTYARG )
//STRIP001 	{
//STRIP001 		if ( !m_aControlExchange.isClipboardOwner() )
//STRIP001 		{
//STRIP001 			if ( doingKeyboardCut() )
//STRIP001 			{
//STRIP001 				for ( sal_Int32 i=0; i<m_aCutEntries.Count(); ++i )
//STRIP001 				{
//STRIP001 					SvLBoxEntry* pEntry = m_aCutEntries[ (sal_uInt16)i ];
//STRIP001 					if ( pEntry )
//STRIP001 					{
//STRIP001 						pEntry->SetFlags( pEntry->GetFlags() & ~SV_ENTRYFLAG_SEMITRANSPARENT );
//STRIP001 						InvalidateEntry( pEntry );
//STRIP001 					}
//STRIP001 				}
//STRIP001 				m_aCutEntries.Remove( (USHORT)0, (USHORT)m_aCutEntries.Count() );
//STRIP001 
//STRIP001 				m_bKeyboardCut = sal_False;
//STRIP001 			}
//STRIP001 		}
//STRIP001 		return 0L;
//STRIP001 	}
//STRIP001 
//STRIP001 	//------------------------------------------------------------------------
//STRIP001 	void NavigatorTree::ShowSelectionProperties(sal_Bool bForce)
//STRIP001 	{
//STRIP001 		// zuerst brauche ich die FormShell
//STRIP001 		FmFormShell* pFormShell = GetNavModel()->GetFormShell();
//STRIP001 		if (!pFormShell)
//STRIP001 			// keine Shell -> ich koennte kein curObject setzen -> raus
//STRIP001 			return;
//STRIP001 
//STRIP001 		CollectSelectionData(SDI_ALL);
//STRIP001 		DBG_ASSERT( (m_nFormsSelected >= 0) && (m_nControlsSelected >= 0) && (m_nHiddenControls >= 0),
//STRIP001 			"NavigatorTree::ShowSelectionProperties : selection counter(s) invalid !");
//STRIP001 		DBG_ASSERT( m_nFormsSelected + m_nControlsSelected + (m_bRootSelected ? 1 : 0) == m_arrCurrentSelection.Count(),
//STRIP001 			"NavigatorTree::ShowSelectionProperties : selection meta data invalid !");
//STRIP001 
//STRIP001 
//STRIP001 		Reference< XInterface >  xInterfaceSelected;
//STRIP001 		Reference< XForm >  xFormSelected;
//STRIP001 		sal_Bool bPropertiesAvailable = sal_True;
//STRIP001 		sal_Bool bNeedSetCurControl = sal_True;
//STRIP001 
//STRIP001 		if (m_bRootSelected)
//STRIP001 			bPropertiesAvailable = sal_False;   // fuer die Root habe ich keine - weder einzeln noch in einer Gruppe - Properties
//STRIP001 		else if (m_nFormsSelected + m_nControlsSelected == 0)   // keines der beiden sollte kleiner 0 sein !
//STRIP001 			bPropertiesAvailable = sal_False;   // keine Selektion -> keine Properties
//STRIP001 		else if (m_nFormsSelected * m_nControlsSelected != 0)
//STRIP001 			bPropertiesAvailable = sal_False;   // gemischte Selektion -> keine Properties
//STRIP001 		else
//STRIP001 		{   // so, hier bin ich, wenn entweder nur Forms oder nur Controls selektiert sind
//STRIP001 		   if (m_arrCurrentSelection.Count() == 1)
//STRIP001 			{
//STRIP001 				if (m_nFormsSelected > 0)
//STRIP001 				{   // es ist genau eine Form selektiert
//STRIP001 					FmFormData* pFormData = (FmFormData*)m_arrCurrentSelection.GetObject(0)->GetUserData();
//STRIP001 					xFormSelected = pFormData->GetFormIface();
//STRIP001 					xInterfaceSelected = xFormSelected;
//STRIP001 				} else
//STRIP001 				{   // es ist genau ein Control selektiert (egal ob hidden oder normal)
//STRIP001 					FmEntryData* pEntryData = (FmEntryData*)m_arrCurrentSelection.GetObject(0)->GetUserData();
//STRIP001 					xInterfaceSelected = pEntryData->GetElement();
//STRIP001 					pFormShell->GetImpl()->setCurControl(xInterfaceSelected);
//STRIP001 					bNeedSetCurControl = sal_False;
//STRIP001 
//STRIP001 					if (pEntryData->GetParent())
//STRIP001 						xFormSelected = ((FmFormData*)pEntryData->GetParent())->GetFormIface();
//STRIP001 				}
//STRIP001 			} else
//STRIP001 			{   // wir haben eine MultiSelection, also muessen wir ein MultiSet dafuer aufbauen
//STRIP001 				if (m_nFormsSelected > 0)
//STRIP001 				{   // ... nur Forms
//STRIP001 					// erstmal die PropertySet-Interfaces der Forms einsammeln
//STRIP001 					Sequence< Reference< XPropertySet > > seqForms(m_nFormsSelected);
//STRIP001 					Reference< XPropertySet > * pPropSets = seqForms.getArray();
//STRIP001 					for (int i=0; i<m_nFormsSelected; i++)
//STRIP001 					{
//STRIP001 						FmFormData* pFormData = (FmFormData*)m_arrCurrentSelection.GetObject(i)->GetUserData();
//STRIP001 						pPropSets[i] = pFormData->GetPropertySet();
//STRIP001 					}
//STRIP001 					// dann diese in ein MultiSet packen
//STRIP001 					FmXMultiSet* pSelectionSet = new FmXMultiSet( seqForms );
//STRIP001 					xInterfaceSelected = Reference< XInterface > ( (XPropertySet*)pSelectionSet );
//STRIP001 				}
//STRIP001 				else
//STRIP001 				{   // ... nur Controls
//STRIP001 					if (m_nHiddenControls == m_nControlsSelected)
//STRIP001 					{   // ein MultiSet fuer die Properties der hidden controls
//STRIP001 						Sequence< Reference< XPropertySet > > seqHiddenControls(m_nHiddenControls);
//STRIP001 						Reference< XPropertySet > * pPropSets = seqHiddenControls.getArray();
//STRIP001 						FmEntryData* pParentData = ((FmEntryData*)m_arrCurrentSelection.GetObject(0)->GetUserData())->GetParent();
//STRIP001 						for (int i=0; i<m_nHiddenControls; i++)
//STRIP001 						{
//STRIP001 							FmEntryData* pEntryData = (FmEntryData*)m_arrCurrentSelection.GetObject(i)->GetUserData();
//STRIP001 							pPropSets[i] = pEntryData->GetPropertySet();
//STRIP001 
//STRIP001 							if (pParentData && pParentData != pEntryData->GetParent())
//STRIP001 								pParentData = NULL;
//STRIP001 						}
//STRIP001 
//STRIP001 						// dann diese in ein MultiSet packen
//STRIP001 						FmXMultiSet* pSelectionSet = new FmXMultiSet( seqHiddenControls );
//STRIP001 						xInterfaceSelected = Reference< XInterface > ( (XPropertySet*)pSelectionSet );
//STRIP001 						// und der Shell als aktuelles Objekt anzeigen
//STRIP001 						pFormShell->GetImpl()->setCurControl( xInterfaceSelected );
//STRIP001 						bNeedSetCurControl = sal_False;
//STRIP001 
//STRIP001 						if (pParentData)
//STRIP001 							// alle hidden controls gehoeren zu einer Form
//STRIP001 							xFormSelected = ((FmFormData*)pParentData)->GetFormIface();
//STRIP001 					}
//STRIP001 					else if (m_nHiddenControls == 0)
//STRIP001 					{   // nur normale Controls
//STRIP001 						// ein MultiSet aus der MarkList der View aufbauen ...
//STRIP001 						const SdrMarkList& mlMarked = pFormShell->GetFormView()->GetMarkList();
//STRIP001 						FmXMultiSet* pSelectionSet = FmXMultiSet::Create( mlMarked );
//STRIP001 						xInterfaceSelected = Reference< XInterface > ( (XPropertySet*)pSelectionSet );
//STRIP001 						pFormShell->GetImpl()->setCurControl( xInterfaceSelected );
//STRIP001 						bNeedSetCurControl = sal_False;
//STRIP001 
//STRIP001 						// jetzt das Formular setzen
//STRIP001 						sal_Bool bMixedWithFormControls;
//STRIP001 						xFormSelected = pFormShell->GetImpl()->DetermineCurForm(mlMarked,bMixedWithFormControls);
//STRIP001 					} else
//STRIP001 						// gemischte Selektion aus hidden und normalen Controls -> keine Properties
//STRIP001 						bPropertiesAvailable = sal_False;
//STRIP001 				}
//STRIP001 			}
//STRIP001 
//STRIP001 		}
//STRIP001 
//STRIP001 		// um das Setzen des current Controls kann sich die Shell kuemmern (da gibt es einige Feinheiten, die ich hier nicht
//STRIP001 		// neu implementieren moechte)
//STRIP001 		if (bNeedSetCurControl)
//STRIP001 			pFormShell->GetImpl()->DetermineSelection(pFormShell->GetFormView()->GetMarkList());
//STRIP001 		// und dann meine Form und mein SelObject
//STRIP001 		pFormShell->GetImpl()->setSelObject(xInterfaceSelected);
//STRIP001 		pFormShell->GetImpl()->setCurForm(xFormSelected);
//STRIP001 
//STRIP001 		if (pFormShell->GetImpl()->IsPropBrwOpen() || bForce)
//STRIP001 		{
//STRIP001 			// und jetzt kann ich das Ganze dem PropertyBrowser uebergeben
//STRIP001 			FmInterfaceItem aInterfaceItem( SID_FM_SHOW_PROPERTY_BROWSER, xInterfaceSelected );
//STRIP001 			pFormShell->GetViewShell()->GetViewFrame()->GetDispatcher()->Execute( SID_FM_SHOW_PROPERTY_BROWSER, SFX_CALLMODE_ASYNCHRON,
//STRIP001 				&aInterfaceItem, 0L );
//STRIP001 		}
//STRIP001 	}
//STRIP001 
//STRIP001 	//------------------------------------------------------------------------
//STRIP001 	void NavigatorTree::DeleteSelection()
//STRIP001 	{
//STRIP001 		// die Root darf ich natuerlich nicht mitloeschen
//STRIP001 		sal_Bool bRootSelected = IsSelected(m_pRootEntry);
//STRIP001 		int nSelectionCount = GetSelectionCount();
//STRIP001 		if (bRootSelected && (nSelectionCount > 1))     // die Root plus andere Elemente ?
//STRIP001 			Select(m_pRootEntry, sal_False);                // ja -> die Root raus
//STRIP001 
//STRIP001 		if ((nSelectionCount == 0) || bRootSelected)    // immer noch die Root ?
//STRIP001 			return;                                     // -> sie ist das einzige selektierte -> raus
//STRIP001 
//STRIP001 		DBG_ASSERT(!m_bPrevSelectionMixed, "NavigatorTree::DeleteSelection() : loeschen nicht erlaubt wenn Markierung und Selektion nciht konsistent");
//STRIP001 
//STRIP001 		// ich brauche unten das FormModel ...
//STRIP001 		FmFormShell* pFormShell = GetNavModel()->GetFormShell();
//STRIP001 		if (!pFormShell)
//STRIP001 			return;
//STRIP001 		FmFormModel* pFormModel = pFormShell ? pFormShell->GetFormModel() : NULL;
//STRIP001 		if (!pFormModel)
//STRIP001 			return;
//STRIP001 
//STRIP001 		// die Undo-Beschreibung
//STRIP001 		UniString aUndoStr = SVX_RES(RID_STR_UNDO_DELETE_LOGICAL);
//STRIP001 	/*  falls irgendwann mal Ordnung in das Undo kommt (so dass wir wirklich die aeusserste Klammer sind und beim Loeschen nur
//STRIP001 	//  eine, nicht zwei UndoActions erzeugen), koennen wir folgenden Code ja wieder benutzen ...
//STRIP001 		if (m_arrCurrentSelection.Count() == 1)
//STRIP001 		{
//STRIP001 			aUndoStr = SVX_RES(RID_STR_UNDO_CONTAINER_REMOVE);
//STRIP001 			if (m_nFormsSelected)
//STRIP001 				aUndoStr.SearchAndReplace("#", SVX_RES(RID_STR_FORM));
//STRIP001 			else
//STRIP001 				// bei selektierter Root war loeschen nicht erlaubt, also ist es ein Control
//STRIP001 				aUndoStr.SearchAndReplace("#", SVX_RES(RID_STR_CONTROL));
//STRIP001 		}
//STRIP001 		else
//STRIP001 		{
//STRIP001 			aUndoStr = SVX_RES(RID_STR_UNDO_CONTAINER_REMOVE_MULTIPLE);
//STRIP001 			aUndoStr.SearchAndReplace("#", UniString(::rtl::OUString(m_arrCurrentSelection.Count())));
//STRIP001 				// der Umweg ueber den ::rtl::OUString ist notwendig, da nur der den Constructor hat, der gleich eine Zahl formatiert
//STRIP001 		}
//STRIP001 	*/
//STRIP001 
//STRIP001 		// see below for why we need this mapping from models to shapes
//STRIP001 		FmFormView*		pFormView		= pFormShell->GetFormView();
//STRIP001 		SdrPageView*	pPageView		= pFormView ? pFormView->GetPageViewPvNum(0) : NULL;
//STRIP001 		SdrPage*		pPage			= pPageView ? pPageView->GetPage() : NULL;
//STRIP001 		DBG_ASSERT( pPage, "NavigatorTree::DeleteSelection: invalid form page!" );
//STRIP001 
//STRIP001 		MapModelToShape aModelShapes;
//STRIP001 		if ( pPage )
//STRIP001 			collectShapeModelMapping( pPage, aModelShapes );
//STRIP001 
//STRIP001 		// jetzt muss ich noch die DeleteList etwas absichern : wenn man ein Formular und ein abhaengiges
//STRIP001 		// Element loescht - und zwar in dieser Reihenfolge - dann ist der SvLBoxEntryPtr des abhaengigen Elementes
//STRIP001 		// natuerlich schon ungueltig, wenn es geloescht werden soll ... diesen GPF, den es dann mit Sicherheit gibt,
//STRIP001 		// gilt es zu verhindern, also die 'normalisierte' Liste
//STRIP001 		CollectSelectionData(SDI_NORMALIZED);
//STRIP001 
//STRIP001 		// folgendes Problem : ich muss das ExplorerModel::Remove verwenden, da nur dieses sich um das korrekte Loeschen von Form-
//STRIP001 		// Objekten kuemmert. Andererseits muss ich die Controls selber ueber DeleteMarked loeschen (irgendwo im Writer gibt
//STRIP001 		// es sonst Probleme). Wenn ich erst die Struktur, dann die Controls loesche, klappt das Undo nicht (da dann erst die Controls
//STRIP001 		// eingefuegt werden, dann die Struktur, sprich ihr Parent-Formular). Andersrum sind die EntryDatas ungueltig, wenn ich die
//STRIP001 		// Controls geloescht habe und zur Struktur gehe. Also muss ich die Formulare NACH den normalen Controls loeschen, damit sie
//STRIP001 		// beim Undo VOR denen wiederhergestellt werden.
//STRIP001 		pFormShell->GetImpl()->EnableTrackProperties(sal_False);
//STRIP001 		int i;
//STRIP001 		for (i = m_arrCurrentSelection.Count()-1; i>=0; --i)
//STRIP001 		{
//STRIP001 			FmEntryData* pCurrent = (FmEntryData*)(m_arrCurrentSelection.GetObject(i)->GetUserData());
//STRIP001 
//STRIP001 			// eine Form ?
//STRIP001 			sal_Bool bIsForm = pCurrent->ISA(FmFormData);
//STRIP001 
//STRIP001 			// da ich das Loeschen im folgenden der View ueberlasse und dabei auf deren MarkList aufbaue, im Normalfall aber bei
//STRIP001 			// einem makierten Formular nur die direkt, nicht die indirekt abhaengigen Controls markiert werden, muss ich das hier
//STRIP001 			// noch nachholen
//STRIP001 			if (bIsForm)
//STRIP001 				MarkViewObj((FmFormData*)pCurrent, sal_True, sal_True);     // das zweite sal_True heisst "deep"
//STRIP001 
//STRIP001 			// ein hidden control ?
//STRIP001 			sal_Bool bIsHidden = IsHiddenControl(pCurrent);
//STRIP001 
//STRIP001 			// Forms und hidden Controls muss ich behalten, alles andere nicht
//STRIP001 			if (!bIsForm && !bIsHidden)
//STRIP001 			{
//STRIP001 				// well, not form and no hidden control -> we can remove it from m_arrCurrentSelection, as it will
//STRIP001 				// be deleted automatically. This is because for every model (except forms and hidden control models)
//STRIP001 				// there exist a shape, which is marked _if_and_only_if_ the model is selected in our tree.
//STRIP001 				// This is the theory.
//STRIP001 				// Now the practice. There may be models which do not have a shape at all. This may be because of
//STRIP001 				// explicit API programming (in this case it was intentional by the user, or a failuer, but this
//STRIP001 				// does not matter), or by bugs :). One of these bugs is 103597.
//STRIP001 				// Because of this "dead" models (means not connected to a shape), we have to do an extra test
//STRIP001 				// 103597 - 2002-09-25 - fs@openoffice.org
//STRIP001 
//STRIP001 				if ( isModelShapeMarked( pCurrent, aModelShapes, pFormView ) )
//STRIP001 					// there indeed is a _marked_ shape for this model
//STRIP001 					m_arrCurrentSelection.Remove( (sal_uInt16)i, 1 );
//STRIP001 			}
//STRIP001 		}
//STRIP001 		pFormShell->GetImpl()->EnableTrackProperties(sal_True);
//STRIP001 
//STRIP001 		// und jetzt das eigentliche Loeschen
//STRIP001 		// die Controls wech
//STRIP001 		pFormShell->GetFormView()->DeleteMarked();
//STRIP001 
//STRIP001 		// das UNDO beginne ich erst jetzt : Das DeleteMarked erzeugt eine eigene Undo-Action, in die ich mich eigentlich einklinken
//STRIP001 		// muesste, was leider nicht geht (das laeuft irgendwo im SwDoc), also erzeuge ich eine zweite, mit der man das Loeschen der
//STRIP001 		// logischen Struktur zuruecknehmen kann (das ist nicht schoen, dass eine eigentlich atomare Aktion zwei UndoActions erzeugt,
//STRIP001 		// aber das einzige, was wir gefunden haben)
//STRIP001 		pFormModel->BegUndo(aUndoStr);
//STRIP001 
//STRIP001 		// die Struktur wech
//STRIP001 		for (i=0; i<m_arrCurrentSelection.Count(); ++i)
//STRIP001 		{
//STRIP001 			FmEntryData* pCurrent = (FmEntryData*)(m_arrCurrentSelection.GetObject(i)->GetUserData());
//STRIP001 			// noch ein kleines Problem, bevor ich das ganz loesche : wenn es eine Form ist und die Shell diese als CurrentObject
//STRIP001 			// kennt, dann muss ich ihr das natuerlich ausreden
//STRIP001 			if (pCurrent->ISA(FmFormData))
//STRIP001 			{
//STRIP001 				Reference< XForm >  xCurrentForm( static_cast< FmFormData* >( pCurrent )->GetFormIface() );
//STRIP001 				if (pFormShell->GetImpl()->getCurForm() == xCurrentForm)    // die Shell kennt die zu loeschende Form ?
//STRIP001 					pFormShell->GetImpl()->setCurForm( NULL );				// -> wegnehmen ...
//STRIP001 			}
//STRIP001 			GetNavModel()->Remove(pCurrent, sal_True);
//STRIP001 		}
//STRIP001 		pFormModel->EndUndo();
//STRIP001 	}
//STRIP001 
//STRIP001 	//------------------------------------------------------------------------
//STRIP001 	void NavigatorTree::CollectSelectionData(SELDATA_ITEMS sdiHow)
//STRIP001 	{
//STRIP001 		DBG_ASSERT(sdiHow != SDI_DIRTY, "NavigatorTree::CollectSelectionData : ever thought about your parameter ? DIRTY ?");
//STRIP001 		if (sdiHow == m_sdiState)
//STRIP001 			return;
//STRIP001 
//STRIP001 		m_arrCurrentSelection.Remove((sal_uInt16)0, m_arrCurrentSelection.Count());
//STRIP001 		m_nFormsSelected = m_nControlsSelected = m_nHiddenControls = 0;
//STRIP001 		m_bRootSelected = sal_False;
//STRIP001 
//STRIP001 		SvLBoxEntry* pSelectionLoop = FirstSelected();
//STRIP001 		while (pSelectionLoop)
//STRIP001 		{
//STRIP001 			// erst mal die Zaehlung der verschiedenen Elemente
//STRIP001 			if (pSelectionLoop == m_pRootEntry)
//STRIP001 				m_bRootSelected = sal_True;
//STRIP001 			else
//STRIP001 			{
//STRIP001 				if (IsFormEntry(pSelectionLoop))
//STRIP001 					++m_nFormsSelected;
//STRIP001 				else
//STRIP001 				{
//STRIP001 					++m_nControlsSelected;
//STRIP001 					if (IsHiddenControl((FmEntryData*)(pSelectionLoop->GetUserData())))
//STRIP001 						++m_nHiddenControls;
//STRIP001 				}
//STRIP001 			}
//STRIP001 
//STRIP001 			if (sdiHow == SDI_NORMALIZED)
//STRIP001 			{
//STRIP001 				// alles, was schon einen selektierten Vorfahr hat, nicht mitnehmen
//STRIP001 				if (pSelectionLoop == m_pRootEntry)
//STRIP001 					m_arrCurrentSelection.Insert(pSelectionLoop);
//STRIP001 				else
//STRIP001 				{
//STRIP001 					SvLBoxEntry* pParentLoop = GetParent(pSelectionLoop);
//STRIP001 					while (pParentLoop)
//STRIP001 					{
//STRIP001 						// eigentlich muesste ich testen, ob das Parent in der m_arrCurrentSelection steht ...
//STRIP001 						// Aber wenn es selektiert ist, dann steht es in m_arrCurrentSelection, oder wenigstens einer seiner Vorfahren,
//STRIP001 						// wenn der auch schon selektiert war. In beiden Faellen reicht also die Abfrage IsSelected
//STRIP001 						if (IsSelected(pParentLoop))
//STRIP001 							break;
//STRIP001 						else
//STRIP001 						{
//STRIP001 							if (m_pRootEntry == pParentLoop)
//STRIP001 							{
//STRIP001 								// bis (exclusive) zur Root gab es kein selektiertes Parent -> der Eintrag gehoert in die normalisierte Liste
//STRIP001 								m_arrCurrentSelection.Insert(pSelectionLoop);
//STRIP001 								break;
//STRIP001 							}
//STRIP001 							else
//STRIP001 								pParentLoop = GetParent(pParentLoop);
//STRIP001 						}
//STRIP001 					}
//STRIP001 				}
//STRIP001 			}
//STRIP001 			else if (sdiHow == SDI_NORMALIZED_FORMARK)
//STRIP001 			{
//STRIP001 				SvLBoxEntry* pParent = GetParent(pSelectionLoop);
//STRIP001 				if (!pParent || !IsSelected(pParent) || IsFormEntry(pSelectionLoop))
//STRIP001 					m_arrCurrentSelection.Insert(pSelectionLoop);
//STRIP001 			}
//STRIP001 			else
//STRIP001 				m_arrCurrentSelection.Insert(pSelectionLoop);
//STRIP001 
//STRIP001 
//STRIP001 			pSelectionLoop = NextSelected(pSelectionLoop);
//STRIP001 		}
//STRIP001 
//STRIP001 		m_sdiState = sdiHow;
//STRIP001 	}
//STRIP001 
//STRIP001 	//------------------------------------------------------------------------
//STRIP001 	void NavigatorTree::SynchronizeSelection(FmEntryDataArray& arredToSelect)
//STRIP001 	{
//STRIP001 		LockSelectionHandling();
//STRIP001 		if (arredToSelect.Count() == 0)
//STRIP001 		{
//STRIP001 			SelectAll(sal_False);
//STRIP001 		}
//STRIP001 		else
//STRIP001 		{
//STRIP001 			// erst mal gleiche ich meine aktuelle Selektion mit der geforderten SelectList ab
//STRIP001 			SvLBoxEntry* pSelection = FirstSelected();
//STRIP001 			while (pSelection)
//STRIP001 			{
//STRIP001 				FmEntryData* pCurrent = (FmEntryData*)pSelection->GetUserData();
//STRIP001 				if (pCurrent != NULL)
//STRIP001 				{
//STRIP001 					sal_uInt16 nPosition;
//STRIP001 					if ( arredToSelect.Seek_Entry(pCurrent, &nPosition) )
//STRIP001 					{   // der Entry ist schon selektiert, steht aber auch in der SelectList -> er kann aus letzterer
//STRIP001 						// raus
//STRIP001 						arredToSelect.Remove(nPosition, 1);
//STRIP001 					} else
//STRIP001 					{   // der Entry ist selektiert, aber steht nicht in der SelectList -> Selektion rausnehmen
//STRIP001 						Select(pSelection, sal_False);
//STRIP001 						// und sichtbar machen (kann ja sein, dass das die einzige Modifikation ist, die ich hier in dem
//STRIP001 						// ganzen Handler mache, dann sollte das zu sehen sein)
//STRIP001 						MakeVisible(pSelection);
//STRIP001 					}
//STRIP001 				}
//STRIP001 				else
//STRIP001 					Select(pSelection, sal_False);
//STRIP001 
//STRIP001 				pSelection = NextSelected(pSelection);
//STRIP001 			}
//STRIP001 
//STRIP001 			// jetzt habe ich in der SelectList genau die Eintraege, die noch selektiert werden muessen
//STRIP001 			// zwei Moeglichkeiten : 1) ich gehe durch die SelectList, besorge mir zu jedem Eintrag meinen SvLBoxEntry
//STRIP001 			// und selektiere diesen (waere irgendwie intuitiver ;)) 2) ich gehe durch alle meine SvLBoxEntries und selektiere
//STRIP001 			// genau die, die ich in der SelectList finde
//STRIP001 			// 1) braucht O(k*n) (k=Laenge der SelectList, n=Anzahl meiner Entries), plus den Fakt, dass FindEntry nicht den
//STRIP001 			// Pointer auf die UserDaten vergleicht, sondern ein aufwendigeres IsEqualWithoutChilds durchfuehrt
//STRIP001 			// 2) braucht O(n*log k), dupliziert aber etwas Code (naemlich den aus FindEntry)
//STRIP001 			// da das hier eine relativ oft aufgerufenen Stelle sein koennte (bei jeder Aenderung in der Markierung in der View !),
//STRIP001 			// nehme ich doch lieber letzteres
//STRIP001 			SvLBoxEntry* pLoop = First();
//STRIP001 			while( pLoop )
//STRIP001 			{
//STRIP001 				FmEntryData* pCurEntryData = (FmEntryData*)pLoop->GetUserData();
//STRIP001 				sal_uInt16 nPosition;
//STRIP001 				if ( arredToSelect.Seek_Entry(pCurEntryData, &nPosition) )
//STRIP001 				{
//STRIP001 					Select(pLoop, sal_True);
//STRIP001 					MakeVisible(pLoop);
//STRIP001 					SetCursor(pLoop, sal_True);
//STRIP001 				}
//STRIP001 
//STRIP001 				pLoop = Next( pLoop );
//STRIP001 			}
//STRIP001 		}
//STRIP001 		UnlockSelectionHandling();
//STRIP001 	}
//STRIP001 
//STRIP001 	//------------------------------------------------------------------------
//STRIP001 	void NavigatorTree::SynchronizeSelection()
//STRIP001 	{
//STRIP001 		// Shell und View
//STRIP001 		FmFormShell* pFormShell = GetNavModel()->GetFormShell();
//STRIP001 		if(!pFormShell) return;
//STRIP001 
//STRIP001 		FmFormView* pFormView = pFormShell->GetFormView();
//STRIP001 		if (!pFormView) return;
//STRIP001 
//STRIP001 		GetNavModel()->BroadcastMarkedObjects(pFormView->GetMarkList());
//STRIP001 	}
//STRIP001 
//STRIP001 	//------------------------------------------------------------------------
//STRIP001 	void NavigatorTree::SynchronizeMarkList()
//STRIP001 	{
//STRIP001 		// die Shell werde ich brauchen ...
//STRIP001 		FmFormShell* pFormShell = GetNavModel()->GetFormShell();
//STRIP001 		if (!pFormShell) return;
//STRIP001 
//STRIP001 		CollectSelectionData(SDI_NORMALIZED_FORMARK);
//STRIP001 
//STRIP001 		// Die View soll jetzt kein Notify bei einer Aenderung der MarkList rauslassen
//STRIP001 		pFormShell->GetImpl()->EnableTrackProperties(sal_False);
//STRIP001 
//STRIP001 		UnmarkAllViewObj();
//STRIP001 
//STRIP001 		for (sal_uInt32 i=0; i<m_arrCurrentSelection.Count(); ++i)
//STRIP001 		{
//STRIP001 			SvLBoxEntry* pSelectionLoop = m_arrCurrentSelection.GetObject((USHORT)i);
//STRIP001 			// Bei Formselektion alle Controls dieser Form markieren
//STRIP001 			if (IsFormEntry(pSelectionLoop) && (pSelectionLoop != m_pRootEntry))
//STRIP001 				MarkViewObj((FmFormData*)pSelectionLoop->GetUserData(), sal_True, sal_False);
//STRIP001 
//STRIP001 			// Bei Controlselektion Control-SdrObjects markieren
//STRIP001 			else if (IsFormComponentEntry(pSelectionLoop))
//STRIP001 			{
//STRIP001 				FmControlData* pControlData = (FmControlData*)pSelectionLoop->GetUserData();
//STRIP001 				if (pControlData)
//STRIP001 				{
//STRIP001 					/////////////////////////////////////////////////////////////////
//STRIP001 					// Beim HiddenControl kann kein Object selektiert werden
//STRIP001 					Reference< XFormComponent >  xFormComponent( pControlData->GetFormComponent());
//STRIP001 					if (!xFormComponent.is())
//STRIP001 						continue;
//STRIP001 					Reference< XPropertySet >  xSet(xFormComponent, UNO_QUERY);
//STRIP001 					if (!xSet.is())
//STRIP001 						continue;
//STRIP001 
//STRIP001 					sal_uInt16 nClassId = ::comphelper::getINT16(xSet->getPropertyValue(FM_PROP_CLASSID));
//STRIP001 					if (nClassId != FormComponentType::HIDDENCONTROL)
//STRIP001 						MarkViewObj(pControlData, sal_True, sal_True);
//STRIP001 				}
//STRIP001 			}
//STRIP001 		}
//STRIP001 
//STRIP001 		// wenn der PropertyBrowser offen ist, muss ich den entsprechend meiner Selektion anpassen
//STRIP001 		// (NICHT entsprechend der MarkList der View : wenn ich ein Formular selektiert habe, sind in der
//STRIP001 		// View alle zugehoerigen Controls markiert, trotzdem moechte ich natuerlich die Formular-Eigenschaften
//STRIP001 		// sehen)
//STRIP001 		ShowSelectionProperties(sal_False);
//STRIP001 
//STRIP001 		// Flag an View wieder zuruecksetzen
//STRIP001 		pFormShell->GetImpl()->EnableTrackProperties(sal_True);
//STRIP001 
//STRIP001 		// wenn jetzt genau eine Form selektiert ist, sollte die Shell das als CurrentForm mitbekommen
//STRIP001 		// (wenn SelectionHandling nicht locked ist, kuemmert sich die View eigentlich in MarkListHasChanged drum,
//STRIP001 		// aber der Mechanismus greift zum Beispiel nicht, wenn die Form leer ist)
//STRIP001 		if ((m_arrCurrentSelection.Count() == 1) && (m_nFormsSelected == 1))
//STRIP001 		{
//STRIP001 			FmFormData* pSingleSelectionData = PTR_CAST( FmFormData, static_cast< FmEntryData* >( FirstSelected()->GetUserData() ) );
//STRIP001 			DBG_ASSERT( pSingleSelectionData, "NavigatorTree::SynchronizeMarkList: invalid selected form!" );
//STRIP001 			if ( pSingleSelectionData )
//STRIP001 				pFormShell->GetImpl()->setCurForm( pSingleSelectionData->GetFormIface() );
//STRIP001 		}
//STRIP001 	}
//STRIP001 
//STRIP001 	//------------------------------------------------------------------------
//STRIP001 	sal_Bool NavigatorTree::IsHiddenControl(FmEntryData* pEntryData)
//STRIP001 	{
//STRIP001 		if (pEntryData == NULL) return sal_False;
//STRIP001 
//STRIP001 		Reference< XPropertySet > xProperties( pEntryData->GetPropertySet() );
//STRIP001 		if (::comphelper::hasProperty(FM_PROP_CLASSID, xProperties))
//STRIP001 		{
//STRIP001 			Any aClassID = xProperties->getPropertyValue( FM_PROP_CLASSID );
//STRIP001 			return (::comphelper::getINT16(aClassID) == FormComponentType::HIDDENCONTROL);
//STRIP001 		}
//STRIP001 		return sal_False;
//STRIP001 	}
//STRIP001 
//STRIP001 	//------------------------------------------------------------------------
//STRIP001 	sal_Bool NavigatorTree::Select( SvLBoxEntry* pEntry, sal_Bool bSelect )
//STRIP001 	{
//STRIP001 		if (bSelect == IsSelected(pEntry))  // das passiert manchmal, ich glaube, die Basisklasse geht zu sehr auf Nummer sicher ;)
//STRIP001 			return sal_True;
//STRIP001 
//STRIP001 		return SvTreeListBox::Select(pEntry, bSelect );
//STRIP001 	}
//STRIP001 
//STRIP001 	//------------------------------------------------------------------------
//STRIP001 	void NavigatorTree::UnmarkAllViewObj()
//STRIP001 	{
//STRIP001 		FmFormShell* pFormShell = GetNavModel()->GetFormShell();
//STRIP001 		if( !pFormShell )
//STRIP001 			return;
//STRIP001 		FmFormView* pFormView = pFormShell->GetFormView();
//STRIP001 		pFormView->UnMarkAll();
//STRIP001 	}
//STRIP001 
//STRIP001 	//------------------------------------------------------------------------
//STRIP001 	void NavigatorTree::MarkViewObj( FmFormData* pFormData, sal_Bool bMark, sal_Bool bDeep )
//STRIP001 	{
//STRIP001 		//////////////////////////////////////////////////////////////////////
//STRIP001 		// Alle Controls der Form markieren
//STRIP001 		FmEntryDataList* pChildList = pFormData->GetChildList();
//STRIP001 		FmEntryData* pEntryData;
//STRIP001 		FmControlData* pControlData;
//STRIP001 
//STRIP001 		for( sal_uInt32 i=0; i<pChildList->Count(); i++ )
//STRIP001 		{
//STRIP001 			pEntryData = pChildList->GetObject(i);
//STRIP001 			if( pEntryData->ISA(FmControlData) )
//STRIP001 			{
//STRIP001 				pControlData = (FmControlData*)pEntryData;
//STRIP001 				MarkViewObj( pControlData, (i==pChildList->Count()-1), bMark );
//STRIP001 			} else if (bDeep && (pEntryData->ISA(FmFormData)))
//STRIP001 				MarkViewObj((FmFormData*)pEntryData, bMark, bDeep);
//STRIP001 		}
//STRIP001 	}
//STRIP001 
//STRIP001 	//------------------------------------------------------------------------
//STRIP001 	void NavigatorTree::MarkViewObj( FmControlData* pControlData, sal_Bool bMarkHandles, sal_Bool bMark)
//STRIP001 	{
//STRIP001 		if( !pControlData ) return;
//STRIP001 		FmFormShell* pFormShell = GetNavModel()->GetFormShell();
//STRIP001 		if( !pFormShell ) return;
//STRIP001 
//STRIP001 		//////////////////////////////////////////////////////////////////////
//STRIP001 		// In der Page das entsprechende SdrObj finden und selektieren
//STRIP001 		Reference< XFormComponent >  xFormComponent( pControlData->GetFormComponent());
//STRIP001 		FmFormView*     pFormView       = pFormShell->GetFormView();
//STRIP001 		SdrPageView*    pPageView       = pFormView->GetPageViewPvNum(0);
//STRIP001 		SdrPage*        pPage           = pPageView->GetPage();
//STRIP001 
//STRIP001 		SdrObjListIter  aIter( *pPage );
//STRIP001 		while( aIter.IsMore() )
//STRIP001 		{
//STRIP001 			SdrObject* pObj = aIter.Next();
//STRIP001 
//STRIP001 			//////////////////////////////////////////////////////////////////////
//STRIP001 			// Es interessieren nur Uno-Objekte
//STRIP001 			if( pObj->IsUnoObj() )
//STRIP001 			{
//STRIP001 				Reference< XInterface >  xControlModel(((SdrUnoObj*)pObj)->GetUnoControlModel());
//STRIP001 
//STRIP001 				//////////////////////////////////////////////////////////////////////
//STRIP001 				// Ist dieses Objekt ein XFormComponent?
//STRIP001 				Reference< XFormComponent >  xFormViewControl(xControlModel, UNO_QUERY);
//STRIP001 				if( !xFormViewControl.is() )
//STRIP001 					return;
//STRIP001 
//STRIP001 				if (xFormViewControl == xFormComponent )
//STRIP001 				{
//STRIP001 					// Objekt markieren
//STRIP001 					if (bMark != pFormView->IsObjMarked(pObj))
//STRIP001 						// der Writer mag das leider nicht, wenn schon markierte Objekte noch mal markiert werden ...
//STRIP001 						pFormView->MarkObj( pObj, pPageView, !bMark, sal_False );
//STRIP001 
//STRIP001 					// Markierung in allen Fenstern in den sichtbaren Bereich verschieben
//STRIP001 					if( bMarkHandles && bMark)
//STRIP001 					{
//STRIP001 						::Rectangle aMarkRect( pFormView->GetAllMarkedRect());
//STRIP001 
//STRIP001 						for( sal_uInt16 i=0; i<pFormView->GetWinCount(); i++ )
//STRIP001 							pFormView->MakeVisible( aMarkRect, *(Window*)pFormView->GetWin(i) );
//STRIP001 					}
//STRIP001 				}
//STRIP001 			}
//STRIP001 		}
//STRIP001 	}
//STRIP001 
//STRIP001 //............................................................................
//STRIP001 }	// namespace svxform
//............................................................................


}
