/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: sw_edtwin.cxx,v $
 *
 *  $Revision: 1.6 $
 *
 *  last change: $Author: rt $ $Date: 2005/09/09 04:48:30 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/


#pragma hdrstop

// auto strip #include <tools/list.hxx>

// auto strip #ifndef _SWTYPES_HXX
// auto strip #include <swtypes.hxx>
// auto strip #endif
#ifndef _HINTIDS_HXX
#include <hintids.hxx>
#endif
#ifdef ACCESSIBLE_LAYOUT
// auto strip #ifndef _COM_SUN_STAR_ACCESSIBILITY_XACCESSIBLE_HPP_
// auto strip #include <com/sun/star/accessibility/XAccessible.hpp>
// auto strip #endif
#endif

// auto strip #ifndef _SV_HELP_HXX //autogen
// auto strip #include <vcl/help.hxx>
// auto strip #endif
// auto strip #ifndef _SV_GRAPH_HXX //autogen
// auto strip #include <vcl/graph.hxx>
// auto strip #endif
// auto strip #ifndef _SV_MSGBOX_HXX //autogen
// auto strip #include <vcl/msgbox.hxx>
// auto strip #endif
// auto strip #ifndef _SV_KEYCODES_HXX //autogen
// auto strip #include <vcl/keycodes.hxx>
// auto strip #endif
// auto strip #ifndef _VCL_CMDEVT_HXX //autogen
// auto strip #include <vcl/cmdevt.hxx>
// auto strip #endif
// auto strip #ifndef _VCL_CMDEVT_HXX //autogen
// auto strip #include <vcl/cmdevt.hxx>
// auto strip #endif
#ifndef _VCL_CMDEVT_H //autogen
#include <vcl/cmdevt.h>
#endif
// auto strip #ifndef _SVSTOR_HXX //autogen
// auto strip #include <so3/svstor.hxx>
// auto strip #endif
// auto strip #ifndef _ARGS_HXX //autogen
// auto strip #include <svtools/args.hxx>
// auto strip #endif
// auto strip #ifndef _SFXMACITEM_HXX //autogen
// auto strip #include <svtools/macitem.hxx>
// auto strip #endif
// auto strip #ifndef __SBX_SBXVARIABLE_HXX //autogen
// auto strip #include <svtools/sbxvar.hxx>
// auto strip #endif
// auto strip #ifndef _SVTOOLS_CTLOPTIONS_HXX
// auto strip #include <svtools/ctloptions.hxx>
// auto strip #endif
// auto strip #ifndef _SBXCLASS_HXX //autogen
// auto strip #include <svtools/sbx.hxx>
// auto strip #endif
// auto strip #ifndef _SFXENUMITEM_HXX //autogen
// auto strip #include <svtools/eitem.hxx>
// auto strip #endif
// auto strip #ifndef _SFXSTRITEM_HXX //autogen
// auto strip #include <svtools/stritem.hxx>
// auto strip #endif
// auto strip #ifndef _SFXVIEWFRM_HXX //autogen
// auto strip #include <bf_sfx2/viewfrm.hxx>
// auto strip #endif
// auto strip #ifndef _SFXREQUEST_HXX //autogen
// auto strip #include <bf_sfx2/request.hxx>
// auto strip #endif
// auto strip #ifndef _SFX_BINDINGS_HXX //autogen
// auto strip #include <bf_sfx2/bindings.hxx>
// auto strip #endif
// auto strip #ifndef _SFXDISPATCH_HXX //autogen
// auto strip #include <bf_sfx2/dispatch.hxx>
// auto strip #endif
// auto strip #ifndef _SFXPTITEM_HXX 
// auto strip #include <svtools/ptitem.hxx>
// auto strip #endif
#define ITEMID_SIZE SID_ATTR_SIZE
// auto strip #ifndef _SVX_SIZEITEM_HXX 
// auto strip #include <bf_svx/sizeitem.hxx>
// auto strip #endif
// auto strip #ifndef _SVX_HTMLMODE_HXX //autogen
// auto strip #include <bf_svx/htmlmode.hxx>
// auto strip #endif
#ifndef _SVDVIEW_HXX //autogen
#include <bf_svx/svdview.hxx>
#endif
#ifndef _SVDVMARK_HXX //autogen
#include <bf_svx/svdvmark.hxx>
#endif
// auto strip #ifndef _SVDHDL_HXX //autogen
// auto strip #include <bf_svx/svdhdl.hxx>
// auto strip #endif
// auto strip #ifndef _SVDOBJ_HXX //autogen
// auto strip #include <bf_svx/svdobj.hxx>
// auto strip #endif
// auto strip #ifndef _MySVXACORR_HXX //autogen
// auto strip #include <bf_svx/svxacorr.hxx>
// auto strip #endif

#ifndef _SVX_ITEMDATA_HXX
#include <bf_svx/itemdata.hxx>
#endif

#ifndef _SVX_FLDITEM_HXX
#	ifndef ITEMID_FIELD
#		ifndef _EEITEM_HXX //autogen
#			include <bf_svx/eeitem.hxx>
#		endif
#		define ITEMID_FIELD EE_FEATURE_FIELD  // wird fuer #include <flditem.hxx> benoetigt
#	endif
#	ifndef _SVX_FLDITEM_HXX //autogen
#		include <bf_svx/flditem.hxx>
#	endif
#endif
// auto strip #ifndef _SVX_COLRITEM_HXX //autogen
// auto strip #include <bf_svx/colritem.hxx>
// auto strip #endif
// auto strip #ifndef _SVX_BRSHITEM_HXX //autogen
// auto strip #include <bf_svx/brshitem.hxx>
// auto strip #endif
// auto strip #ifndef _OUTLINER_HXX //autogen
// auto strip #include <bf_svx/outliner.hxx>
// auto strip #endif
// auto strip #ifndef _SVX_WGHTITEM_HXX //autogen
// auto strip #include <bf_svx/wghtitem.hxx>
// auto strip #endif
// auto strip #ifndef _SVX_UDLNITEM_HXX //autogen
// auto strip #include <bf_svx/udlnitem.hxx>
// auto strip #endif
// auto strip #ifndef _SVX_POSTITEM_HXX //autogen
// auto strip #include <bf_svx/postitem.hxx>
// auto strip #endif
// auto strip #ifndef _SVX_PROTITEM_HXX //autogen
// auto strip #include <bf_svx/protitem.hxx>
// auto strip #endif
// auto strip #ifndef _OFAACCFG_HXX //autogen
// auto strip #include <bf_offmgr/ofaaccfg.hxx>
// auto strip #endif
// auto strip #ifndef _OFF_APP_HXX //autogen
// auto strip #include <bf_offmgr/app.hxx>
// auto strip #endif
// auto strip #ifndef _UNOTOOLS_CHARCLASS_HXX
// auto strip #include <unotools/charclass.hxx>
// auto strip #endif

#ifndef _EDTWIN_HXX //autogen
#include <edtwin.hxx>
#endif
// auto strip #ifndef _SWVIEW_HXX //autogen
// auto strip #include <view.hxx>
// auto strip #endif

#ifndef _HORIORNT_HXX
#include <horiornt.hxx>
#endif

#ifndef _WRTSH_HXX //autogen
#include <wrtsh.hxx>
#endif
// auto strip #ifndef _FLDBAS_HXX //autogen
// auto strip #include <fldbas.hxx>
// auto strip #endif
// auto strip #ifndef _SWMODULE_HXX //autogen
// auto strip #include <swmodule.hxx>
// auto strip #endif
// auto strip #ifndef _SWDOCSH_HXX //autogen
// auto strip #include <docsh.hxx>
// auto strip #endif
#ifndef _VIEWOPT_HXX //autogen
#include <viewopt.hxx>
#endif
// auto strip #ifndef _SW_DRAWBASE_HXX //autogen
// auto strip #include <drawbase.hxx>
// auto strip #endif
// auto strip #ifndef _SW_DSELECT_HXX //autogen
// auto strip #include <dselect.hxx>
// auto strip #endif
// auto strip #ifndef _SWTEXTSH_HXX //autogen
// auto strip #include <textsh.hxx>
// auto strip #endif
// auto strip #ifndef _SHDWCRSR_HXX
// auto strip #include <shdwcrsr.hxx>
// auto strip #endif
// auto strip #ifndef _FMTANCHR_HXX //autogen
// auto strip #include <fmtanchr.hxx>
// auto strip #endif
// auto strip #ifndef _FMTORNT_HXX //autogen
// auto strip #include <fmtornt.hxx>
// auto strip #endif
// auto strip #ifndef _FMTFSIZE_HXX //autogen
// auto strip #include <fmtfsize.hxx>
// auto strip #endif
// auto strip #ifndef _FMTCLDS_HXX //autogen
// auto strip #include <fmtclds.hxx>
// auto strip #endif
// auto strip #ifndef _FRMFMT_HXX //autogen
// auto strip #include <frmfmt.hxx>
// auto strip #endif
// auto strip #ifndef _MODOPT_HXX //autogen
// auto strip #include <modcfg.hxx>
// auto strip #endif
// auto strip #ifndef _FMTCOL_HXX //autogen
// auto strip #include <fmtcol.hxx>
// auto strip #endif
#ifndef _SWWVIEW_HXX //autogen
#include <wview.hxx>
#endif
// auto strip #ifndef _SWLISTSH_HXX //autogen
// auto strip #include <listsh.hxx>
// auto strip #endif
// auto strip #ifndef _GLOSLST_HXX //autogen
// auto strip #include <gloslst.hxx>
// auto strip #endif
// auto strip #ifndef SW_INPUTWIN_HXX //autogen
// auto strip #include <inputwin.hxx>
// auto strip #endif
// auto strip #ifndef _GLOSHDL_HXX //autogen
// auto strip #include <gloshdl.hxx>
// auto strip #endif
// auto strip #ifndef _SWUNDO_HXX
// auto strip #include <swundo.hxx>
// auto strip #endif
// auto strip #ifndef _SWDRWTXTSH_HXX //autogen
// auto strip #include <drwtxtsh.hxx>
// auto strip #endif
// auto strip #ifndef _FCHRFMT_HXX //autogen
// auto strip #include <fchrfmt.hxx>
// auto strip #endif
// auto strip #ifndef _FMTURL_HXX //autogen
// auto strip #include <fmturl.hxx>
// auto strip #endif
// auto strip #ifndef _ROMENU_HXX
// auto strip #include <romenu.hxx>
// auto strip #endif
// auto strip #ifndef _INITUI_HXX
// auto strip #include <initui.hxx>
// auto strip #endif
// auto strip #ifndef _FRMATR_HXX
// auto strip #include <frmatr.hxx>
// auto strip #endif
// auto strip #ifndef _EXTINPUT_HXX
// auto strip #include <extinput.hxx>
// auto strip #endif
// auto strip #ifndef _ACMPLWRD_HXX
// auto strip #include <acmplwrd.hxx>
// auto strip #endif
// auto strip #ifndef _SWCALWRP_HXX
// auto strip #include <swcalwrp.hxx>
// auto strip #endif
// auto strip #ifndef _SWDTFLVR_HXX
// auto strip #include <swdtflvr.hxx>
// auto strip #endif
#ifndef _SWWDOCSH_HXX //autogen
#include <wdocsh.hxx>
#endif
// auto strip #ifndef _CRSSKIP_HXX
// auto strip #include <crsskip.hxx>
// auto strip #endif

#ifndef _HELPID_H
#include <helpid.h>
#endif
#ifndef _CMDID_H
#include <cmdid.h>
#endif
#ifndef _DOCVW_HRC
#include <docvw.hrc>
#endif
// auto strip #ifndef _UITOOL_HXX
// auto strip #include <uitool.hxx>
// auto strip #endif

// auto strip #include <charfmt.hxx>
// auto strip #include <numrule.hxx>
// auto strip #include <pagedesc.hxx>
namespace binfilter {

//JP 11.10.2001: enable test code for bug fix 91313
#if !defined( PRODUCT ) && (OSL_DEBUG_LEVEL > 1)
//#define TEST_FOR_BUG91313
#endif

/*--------------------------------------------------------------------
	Beschreibung:	Globals
 --------------------------------------------------------------------*/

extern BOOL bNoInterrupt;		// in mainwn.cxx

//Normalerweise wird im MouseButtonUp eine Selektion aufgehoben wenn die
//Selektion nicht gerade aufgezogen wird. Leider wird im MouseButtonDown
//bei doppel-/dreifach-Klick Selektiert, diese Selektion wird in dem Handler
//komplett abgeschlossen und kann deshalb im Up nicht mehr unterschieden
//werden. Um dies Aufzuloese wird bHoldSelection im Down gesetzt und im
//Up ausgewertet.
//STRIP001 static BOOL bHoldSelection 		= FALSE;

//STRIP001 BOOL bFrmDrag 					= FALSE;
//STRIP001 BOOL bValidCrsrPos 				= FALSE;
//STRIP001 BOOL bModePushed 				= FALSE;
//STRIP001 BOOL bDDTimerStarted 			= FALSE;
//STRIP001 BOOL bFlushCharBuffer 			= FALSE;
BOOL SwEditWin::bReplaceQuote 	= FALSE;
//STRIP001 BOOL bDDINetAttr 				= FALSE;
//STRIP001 SdrHdlKind eSdrMoveHdl			= HDL_USER;

QuickHelpData* SwEditWin::pQuickHlpData	= 0;

long 	SwEditWin::nDDStartPosY = 0;
long 	SwEditWin::nDDStartPosX = 0;
Color 	SwEditWin::aTextBackColor(COL_YELLOW);
Color 	SwEditWin::aTextColor(COL_RED);
BOOL	SwEditWin::bTransparentBackColor = FALSE; // Hintergrund nicht transparent


extern BOOL 	bExecuteDrag;

//STRIP001 SfxShell* lcl_GetShellFromDispatcher( SwView& rView, TypeId nType );

//STRIP001 DBG_NAME(edithdl)

//STRIP001 class SwAnchorMarker
//STRIP001 {
//STRIP001 	SdrHdl* pHdl;
//STRIP001 	Point aHdlPos;
//STRIP001 	Point aLastPos;
//STRIP001 public:
//STRIP001 	SwAnchorMarker( SdrHdl* pH ) :
//STRIP001 		pHdl( pH ), aHdlPos( pH->GetPos() ), aLastPos( pH->GetPos() ) {}
//STRIP001 	const Point& GetLastPos() const { return aLastPos; }
//STRIP001 	void SetLastPos( const Point& rNew ) { aLastPos = rNew; }
//STRIP001 	void SetPos( const Point& rNew ) { pHdl->SetPos( rNew ); }
//STRIP001 	const Point& GetPos() { return pHdl->GetPos(); }
//STRIP001 	const Point& GetHdlPos() { return aHdlPos; }
//STRIP001 	void ChgHdl( SdrHdl* pNew ) { pHdl = pNew; }
//STRIP001 };

struct QuickHelpData
{
	SvStringsISortDtor aArr;
	USHORT* pAttrs;
	CommandExtTextInputData* pCETID;
	ULONG nTipId;
	USHORT nLen, nCurArrPos;
	BOOL bClear : 1, bChkInsBlank : 1, bIsTip : 1, bIsAutoText : 1;

	QuickHelpData() : pCETID( 0 ), pAttrs( 0 ) { ClearCntnt(); }

//STRIP001 	void Move( QuickHelpData& rCpy );
	void ClearCntnt();
//STRIP001 	void Start( SwWrtShell& rSh, USHORT nWrdLen );
//STRIP001 	void Stop( SwWrtShell& rSh );

//STRIP001 	BOOL HasCntnt() const		{ return aArr.Count() && 0 != nLen; }

//STRIP001 	void Inc( BOOL bEndLess )
//STRIP001 		{
//STRIP001 			if( ++nCurArrPos >= aArr.Count() )
//STRIP001 				nCurArrPos = (bEndLess && !bIsAutoText )? 0 : nCurArrPos-1;
//STRIP001 		}
//STRIP001 	void Dec( BOOL bEndLess )
//STRIP001 		{
//STRIP001 			if( 0 == nCurArrPos-- )
//STRIP001 				nCurArrPos = (bEndLess && !bIsAutoText ) ? aArr.Count()-1 : 0;
//STRIP001 		}
//STRIP001 	void FillStrArr( SwWrtShell& rSh, const String& rWord );
};


/*--------------------------------------------------------------------
	Beschreibung:	Minimale Bewegung Zittern vermeiden
 --------------------------------------------------------------------*/

#define HIT_PIX  2 /* Hit-Toleranz in Pixel */
#define MIN_MOVE 4

//STRIP001 inline BOOL IsMinMove(const Point &rStartPos, const Point &rLPt)
//STRIP001 {
//STRIP001 	return Abs(rStartPos.X() - rLPt.X()) > MIN_MOVE ||
//STRIP001 		   Abs(rStartPos.Y() - rLPt.Y()) > MIN_MOVE;
//STRIP001 }

/*--------------------------------------------------------------------
	JP 30.07.98: fuer MouseButtonDown - feststellen, ob ein DrawObject
				und KEIN SwgFrame getroffen wurde! Shift/Ctrl sollen
				nur bei DrawObjecte zum Selektieren fuehren, bei SwgFlys
				ggfs zum ausloesen von Hyperlinks (DownLoad/NewWindow!)
 --------------------------------------------------------------------*/
//STRIP001 inline BOOL IsDrawObjSelectable( const SwWrtShell& rSh, const Point& rPt )
//STRIP001 {
//STRIP001 	BOOL bRet = TRUE;
//STRIP001 	SdrObject* pObj;
//STRIP001 	switch( rSh.GetObjCntType( rPt, pObj ))
//STRIP001 	{
//STRIP001 	case OBJCNT_NONE:
//STRIP001 	case OBJCNT_FLY:
//STRIP001 	case OBJCNT_GRF:
//STRIP001 	case OBJCNT_OLE:
//STRIP001 		bRet = FALSE;
//STRIP001 		break;
//STRIP001 	}
//STRIP001 	return bRet;
//STRIP001 }

/*--------------------------------------------------------------------
	Beschreibung: 	Pointer umschalten
 --------------------------------------------------------------------*/


/*N*/ void SwEditWin::UpdatePointer(const Point &rLPt, USHORT nModifier )
/*N*/ {
/*N*/ 	SwWrtShell &rSh = rView.GetWrtShell();
/*N*/ 	if( pApplyTempl )
/*N*/ 	{
/*?*/ 		DBG_BF_ASSERT(0, "STRIP"); //STRIP001 PointerStyle eStyle = POINTER_FILL;
//STRIP001 /*?*/ 		if( rSh.IsOverReadOnlyPos( rLPt ))
//STRIP001 /*?*/ 		{
//STRIP001 /*?*/ 			if( pUserMarker )
//STRIP001 /*?*/ 				DELETEZ( pUserMarker );
//STRIP001 /*?*/ //			rSh.SwCrsrShell::UnSetVisCrsr( rLPt );
//STRIP001 /*?*/ 			eStyle = POINTER_NOTALLOWED;
//STRIP001 /*?*/ 		}
//STRIP001 /*?*/ 		else
//STRIP001 /*?*/ 		{
//STRIP001 /*?*/ 			SwRect aRect;
//STRIP001 /*?*/ 			SwRect* pRect = &aRect;
//STRIP001 /*?*/ 			const SwFrmFmt* pFmt = 0;
//STRIP001 /*?*/ 			if(!pApplyTempl->nColor &&
//STRIP001 /*?*/ 					pApplyTempl->eType == SFX_STYLE_FAMILY_FRAME &&
//STRIP001 /*?*/ 						0 !=(pFmt = rSh.GetFmtFromObj( rLPt, &pRect )) &&
//STRIP001 /*?*/ 						PTR_CAST(SwFlyFrmFmt, pFmt))
//STRIP001 /*?*/ 			{
//STRIP001 /*?*/ 				//Highlight fuer Rahmen anwerfen
//STRIP001 /*?*/ 				Rectangle aTmp( pRect->SVRect() );
//STRIP001 /*?*/ 				if ( !pUserMarker )
//STRIP001 /*?*/ 					pUserMarker = new SdrViewUserMarker( rSh.GetDrawView() );
//STRIP001 /*?*/ 				pUserMarker->SetRectangle( aTmp );
//STRIP001 /*?*/ 				pUserMarker->Show();
//STRIP001 /*?*/ 			}
//STRIP001 /*?*/ 			else if(pUserMarker)
//STRIP001 /*?*/ 				DELETEZ(pUserMarker);
//STRIP001 /*?*/ 			rSh.SwCrsrShell::SetVisCrsr( rLPt );
//STRIP001 /*?*/ 		}
//STRIP001 /*?*/ 		SetPointer( eStyle );
//STRIP001 /*?*/ 		return;
/*N*/ 	}
/*N*/ 
/*N*/ 	if( !rSh.VisArea().Width() )
/*N*/ 		return;
/*?*/ 
/*?*/ 	SET_CURR_SHELL(&rSh);
/*?*/ 
/*?*/ 	if ( IsChainMode() )
/*?*/ 	{
/*?*/ 		DBG_BF_ASSERT(0, "STRIP"); //STRIP001 SwRect aRect;
//STRIP001 /*?*/ 		int nChainable = rSh.Chainable( aRect, *rSh.GetFlyFrmFmt(), rLPt );
//STRIP001 /*?*/ 		PointerStyle eStyle = nChainable
//STRIP001 /*?*/ 				? POINTER_CHAIN_NOTALLOWED : POINTER_CHAIN;
//STRIP001 /*?*/ 		if ( !nChainable )
//STRIP001 /*?*/ 		{
//STRIP001 /*?*/ 			Rectangle aTmp( aRect.SVRect() );
//STRIP001 /*?*/ 			if ( !pUserMarker )
//STRIP001 /*?*/ 				pUserMarker = new SdrViewUserMarker( rSh.GetDrawView() );
//STRIP001 /*?*/ 			pUserMarker->SetRectangle( aTmp );
//STRIP001 /*?*/ 			pUserMarker->Show();
//STRIP001 /*?*/ 		}
//STRIP001 /*?*/ 		else
//STRIP001 /*?*/ 		{
//STRIP001 /*?*/ 			DELETEZ( pUserMarker );
//STRIP001 /*?*/ 		}
//STRIP001 /*?*/ 		rView.GetViewFrame()->ShowStatusText(
//STRIP001 /*?*/ 										SW_RESSTR(STR_CHAIN_OK+nChainable));
//STRIP001 /*?*/ 		SetPointer( eStyle );
/*?*/ 		return;
/*?*/ 	}
/*?*/ 
/*?*/ 	BOOL bExecHyperlinks = rSh.GetViewOptions()->IsExecHyperlinks() ^
/*?*/ 						   (nModifier == KEY_MOD2 ? TRUE : FALSE);
/*?*/ 
/*?*/ 	SdrView *pSdrView = rSh.GetDrawView();
/*?*/ 	BOOL bPrefSdrPointer = FALSE;
/*?*/ 	BOOL bHitHandle = FALSE;
/*?*/ 	BOOL bCntAtPos = FALSE;
/*?*/ 	BOOL bIsDocReadOnly = rView.GetDocShell()->IsReadOnly() &&
/*?*/ 						  rSh.IsCrsrReadonly();
/*?*/ 	aActHitType = SDRHIT_NONE;
/*?*/ 	PointerStyle eStyle = POINTER_TEXT;
/*?*/ 	if ( !pSdrView )
/*?*/ 		bCntAtPos = TRUE;
/*?*/ 	else if ( bHitHandle = pSdrView->HitHandle( rLPt, *(rSh.GetOut())) != 0 )
/*?*/ 	{
/*?*/ 		aActHitType = SDRHIT_OBJECT;
/*?*/ 		bPrefSdrPointer = TRUE;
/*?*/ 	}
/*?*/ 	else
/*?*/ 	{
/*?*/ 		DBG_BF_ASSERT(0, "STRIP"); //STRIP001 const BOOL bNotInSelObj = !rSh.IsInsideSelectedObj( rLPt );
//STRIP001 /*?*/ 		if ( rView.GetDrawFuncPtr() && !bInsDraw && bNotInSelObj )
//STRIP001 /*?*/ 		{
//STRIP001 /*?*/ 			aActHitType = SDRHIT_OBJECT;
//STRIP001 /*?*/ 			if (GetDrawMode() == SID_OBJECT_SELECT)
//STRIP001 /*?*/ 				eStyle = POINTER_ARROW;
//STRIP001 /*?*/ 			else
//STRIP001 /*?*/ 				bPrefSdrPointer = TRUE;
//STRIP001 /*?*/ 		}
//STRIP001 /*?*/ 		else
//STRIP001 /*?*/ 		{
//STRIP001 /*?*/ 			SdrObject* pObj; SdrPageView* pPV;
//STRIP001 /*?*/ 			pSdrView->SetHitTolerancePixel( HIT_PIX );
//STRIP001 /*?*/ 			if ( bNotInSelObj && bExecHyperlinks &&
//STRIP001 /*?*/ 				 pSdrView->PickObj( rLPt, pObj, pPV, SDRSEARCH_PICKMACRO ))
//STRIP001 /*?*/ 			{
//STRIP001 /*?*/ 				SdrObjMacroHitRec aTmp;
//STRIP001 /*?*/ 				aTmp.aPos = rLPt;
//STRIP001 /*?*/ 				aTmp.pPageView = pPV;
//STRIP001 /*?*/ 				SetPointer( pObj->GetMacroPointer( aTmp ) );
//STRIP001 /*?*/ 				return;
//STRIP001 /*?*/ 			}
//STRIP001 /*?*/ 			else
//STRIP001 /*?*/ 			{
//STRIP001 /*?*/                 // dvo: IsObjSelectable() eventually calls SdrView::PickObj, so
//STRIP001 /*?*/                 // apparently this is used to determine whether this is a
//STRIP001 /*?*/                 // drawling layer object or not.
//STRIP001 /*?*/ 				if ( rSh.IsObjSelectable( rLPt ) )
//STRIP001 /*?*/ 				{
//STRIP001 /*?*/ 					if (pSdrView->IsTextEdit())
//STRIP001 /*?*/ 					{
//STRIP001 /*?*/ 						aActHitType = SDRHIT_NONE;
//STRIP001 /*?*/ 						bPrefSdrPointer = TRUE;
//STRIP001 /*?*/ 					}
//STRIP001 /*?*/ 					else
//STRIP001 /*?*/ 					{
//STRIP001 /*?*/ 						SdrViewEvent aVEvt;
//STRIP001 /*?*/ 						SdrHitKind eHit = pSdrView->PickAnything(rLPt, aVEvt);
//STRIP001 /*?*/ 
//STRIP001 /*?*/ 						if (eHit == SDRHIT_URLFIELD && bExecHyperlinks)
//STRIP001 /*?*/ 						{
//STRIP001 /*?*/ 							aActHitType = SDRHIT_OBJECT;
//STRIP001 /*?*/ 							bPrefSdrPointer = TRUE;
//STRIP001 /*?*/ 						}
//STRIP001 /*?*/ 						else
//STRIP001 /*?*/ 						{
//STRIP001 /*?*/                             // if we're over a selected object, we show an
//STRIP001 /*?*/                             // ARROW by default. We only show a MOVE if 1) the
//STRIP001 /*?*/                             // object is selected, and 2) it may be moved
//STRIP001 /*?*/                             // (i.e., position is not protected).
//STRIP001 /*?*/                             bool bMovable =
//STRIP001 /*?*/                                 (!bNotInSelObj) &&
//STRIP001 /*?*/                                 (rSh.IsObjSelected() || rSh.IsFrmSelected()) &&
//STRIP001 /*?*/                                 (!rSh.IsSelObjProtected(FLYPROTECT_POS));
//STRIP001 /*?*/ 
//STRIP001 /*?*/                             eStyle = bMovable ? POINTER_MOVE : POINTER_ARROW;
//STRIP001 /*?*/ 							aActHitType = SDRHIT_OBJECT;
//STRIP001 /*?*/ 						}
//STRIP001 /*?*/ 					}
//STRIP001 /*?*/ 				}
//STRIP001 /*?*/ 				else
//STRIP001 /*?*/ 				{
//STRIP001 /*?*/ 					if ( rSh.IsFrmSelected() && !bNotInSelObj )
//STRIP001 /*?*/ 					{
//STRIP001 /*?*/                         // dvo: this branch appears to be dead and should be
//STRIP001 /*?*/                         // removed in a future version. Reason: The condition
//STRIP001 /*?*/                         // !bNotInSelObj means that this branch will only be
//STRIP001 /*?*/                         // executed in the cursor points inside a selected
//STRIP001 /*?*/                         // object. However, if this is the case, the previous
//STRIP001 /*?*/                         // if( rSh.IsObjSelectable(rLPt) ) must always be true:
//STRIP001 /*?*/                         // rLPt is inside a selected object, then obviously
//STRIP001 /*?*/                         // rLPt is over a selectable object.
//STRIP001 /*?*/ 						if (rSh.IsSelObjProtected(FLYPROTECT_SIZE))
//STRIP001 /*?*/ 							eStyle = POINTER_NOTALLOWED;
//STRIP001 /*?*/ 						else
//STRIP001 /*?*/ 							eStyle = POINTER_MOVE;
//STRIP001 /*?*/ 						aActHitType = SDRHIT_OBJECT;
//STRIP001 /*?*/ 					}
//STRIP001 /*?*/ 					else
//STRIP001 /*?*/ 					{
//STRIP001 /*?*/ 						if ( rView.GetDrawFuncPtr() )
//STRIP001 /*?*/ 							bPrefSdrPointer = TRUE;
//STRIP001 /*?*/ 						else
//STRIP001 /*?*/ 							bCntAtPos = TRUE;
//STRIP001 /*?*/ 					}
//STRIP001 /*?*/ 				}
//STRIP001 /*?*/ 			}
//STRIP001 /*?*/ 		}
/*?*/ 	}
/*?*/ 	if ( bPrefSdrPointer )
/*?*/ 	{
/*?*/ 		if (bIsDocReadOnly || (rSh.IsObjSelected() && rSh.IsSelObjProtected(FLYPROTECT_CONTENT)))
/*?*/ 			SetPointer( POINTER_NOTALLOWED );
/*?*/ 		else
/*?*/ 		{
/*?*/ 			DBG_BF_ASSERT(0, "STRIP"); //STRIP001 if (rView.GetDrawFuncPtr() && rView.GetDrawFuncPtr()->IsInsertForm() && !bHitHandle)
//STRIP001 /*?*/ 				SetPointer( POINTER_DRAW_RECT );
//STRIP001 /*?*/ 			else
//STRIP001 /*?*/ 				SetPointer( pSdrView->GetPreferedPointer( rLPt, rSh.GetOut() ) );
/*?*/ 		}
/*?*/ 	}
/*?*/ 	else
/*?*/ 	{
			{DBG_BF_ASSERT(0, "STRIP");} //STRIP001 /*?*/         if( !rSh.IsPageAtPos( rLPt ) || pAnchorMarker )
//STRIP001 /*?*/ 			eStyle = POINTER_ARROW;
//STRIP001 /*?*/ 		else if( bCntAtPos && bExecHyperlinks )
//STRIP001 /*?*/ 		{
//STRIP001 /*?*/ 			// sollten wir ueber einem InternetAttr/ClickFeld/Fussnote stehen?
//STRIP001 /*?*/ 			SwContentAtPos aSwContentAtPos(
//STRIP001 /*?*/ 				SwContentAtPos::SW_CLICKFIELD|
//STRIP001 /*?*/ 				SwContentAtPos::SW_INETATTR|
//STRIP001 /*?*/ 				SwContentAtPos::SW_FTN );
//STRIP001 /*?*/ 			if( rSh.GetContentAtPos( rLPt, aSwContentAtPos) )
//STRIP001 /*?*/ 				eStyle = POINTER_REFHAND;
//STRIP001 /*?*/ 		}
//STRIP001 /*?*/ 
//STRIP001 /*?*/ 		// which kind of text pointer have we to show - horz / vert - ?
//STRIP001 /*?*/ 		if( POINTER_TEXT == eStyle && rSh.IsInVerticalText( &rLPt ))
//STRIP001 /*?*/ 			eStyle = POINTER_TEXT_VERTICAL;
//STRIP001 /*?*/ 
//STRIP001 /*?*/ 		SetPointer( eStyle );
/*?*/ 	}
/*N*/ }

/*--------------------------------------------------------------------
	Beschreibung: Timer fuer Selektion vergroessern
 --------------------------------------------------------------------*/


/*N*/ IMPL_LINK( SwEditWin, TimerHandler, Timer *, EMPTYARG )
/*N*/ {
/*?*/ 		DBG_BF_ASSERT(0, "STRIP"); //STRIP001 //STRIP001 	DBG_PROFSTART(edithdl);
//STRIP001 
//STRIP001 	SwWrtShell &rSh = rView.GetWrtShell();
//STRIP001 	Point aModPt( aMovePos );
//STRIP001 	const SwRect aOldVis( rSh.VisArea() );
//STRIP001 	FASTBOOL bDone = FALSE;
//STRIP001 
//STRIP001 	if ( !rSh.VisArea().IsInside( aModPt ) )
//STRIP001 	{
//STRIP001 		if ( bInsDraw )
//STRIP001 		{
//STRIP001 			const int nMaxScroll = 40;
//STRIP001 			rView.Scroll( Rectangle(aModPt,Size(1,1)), nMaxScroll, nMaxScroll);
//STRIP001 			bDone = TRUE;
//STRIP001 		}
//STRIP001 		else if ( bFrmDrag )
//STRIP001 		{
//STRIP001 			(rSh.*rSh.fnDrag)(&aModPt,FALSE);
//STRIP001 			bDone = TRUE;
//STRIP001 		}
//STRIP001 		if ( !bDone )
//STRIP001 			aModPt = rSh.GetCntntPos( aModPt,aModPt.Y() > rSh.VisArea().Bottom() );
//STRIP001 	}
//STRIP001 	if ( !bDone && !(bFrmDrag || bInsDraw) )
//STRIP001 	{
//STRIP001 		(rSh.*rSh.fnSetCrsr)( &aModPt, FALSE );
//STRIP001 
//STRIP001 		//fix(24138): Es kann sein, dass der "Sprung" ueber eine Tabelle so
//STRIP001 		//nicht geschafft wird. Deshalb wir hier eben per Up/Down ueber die
//STRIP001 		//Tabelle gesprungen.
//STRIP001 		const SwRect& rVisArea = rSh.VisArea();
//STRIP001 		if( aOldVis == rVisArea && !rSh.IsStartOfDoc() && !rSh.IsEndOfDoc() )
//STRIP001 		{
//STRIP001 			//JP 11.10.2001 Bug 72294 - take the center point of VisArea to
//STRIP001 			//				decide in which direction the user want.
//STRIP001 			if( aModPt.Y() < ( rVisArea.Top() + rVisArea.Height() / 2 ) )
//STRIP001 				rSh.Up( TRUE );
//STRIP001 			else
//STRIP001 				rSh.Down( TRUE );
//STRIP001 		}
//STRIP001 	}
//STRIP001 
//STRIP001 	aMovePos += rSh.VisArea().Pos() - aOldVis.Pos();
//STRIP001 	JustifyAreaTimer();
//STRIP001 	DBG_PROFSTOP(edithdl);
/*N*/ 	return 0;
/*N*/ }

/*--------------------------------------------------------------------
	Beschreibung:
 --------------------------------------------------------------------*/


//STRIP001 void SwEditWin::JustifyAreaTimer()
//STRIP001 {
//STRIP001 	const Rectangle &rVisArea = GetView().GetVisArea();
//STRIP001 #ifdef UNX
//STRIP001 	const long coMinLen = 100;
//STRIP001 #else
//STRIP001 	const long coMinLen = 50;
//STRIP001 #endif
//STRIP001 	long nTimeout = 800,
//STRIP001 		 nDiff = Max(
//STRIP001 		 Max( aMovePos.Y() - rVisArea.Bottom(), rVisArea.Top() - aMovePos.Y() ),
//STRIP001 		 Max( aMovePos.X() - rVisArea.Right(),  rVisArea.Left() - aMovePos.X()));
//STRIP001 #ifdef TEST_FOR_BUG91313
//STRIP001 	aTimer.SetTimeout( Max( coMinLen, nTimeout - nDiff) );
//STRIP001 #else
//STRIP001 	aTimer.SetTimeout( Max( coMinLen, nTimeout - nDiff*2L) );
//STRIP001 #endif
//STRIP001 }

//STRIP001 void SwEditWin::LeaveArea(const Point &rPos)
//STRIP001 {
//STRIP001 	aMovePos = rPos;
//STRIP001 	JustifyAreaTimer();
//STRIP001 	if( !aTimer.IsActive() )
//STRIP001 		aTimer.Start();
//STRIP001 	if( pShadCrsr )
//STRIP001 		delete pShadCrsr, pShadCrsr = 0;
//STRIP001 }

//STRIP001 inline void SwEditWin::EnterArea()
//STRIP001 {
//STRIP001 	aTimer.Stop();
//STRIP001 }

/*------------------------------------------------------------------------
 Beschreibung:	Modus fuer Rahmen einfuegen
------------------------------------------------------------------------*/


//STRIP001 void SwEditWin::InsFrm(USHORT nCols)
//STRIP001 {
//STRIP001 	StdDrawMode(OBJ_NONE);
//STRIP001 	bInsFrm = TRUE;
//STRIP001 	nInsFrmColCount = nCols;
//STRIP001 }



//STRIP001 void SwEditWin::StdDrawMode(USHORT nSlotId)
//STRIP001 {
//STRIP001 	SetDrawMode( nSlotId );

/*	if (GetDrawFuncPtr())
		GetDrawFuncPtr()->Deactivate();*/

//STRIP001 	if (nSlotId == OBJ_NONE)
//STRIP001 		rView.SetDrawFuncPtr(new SwDrawBase( &rView.GetWrtShell(), this, &rView ));
//STRIP001 	else
//STRIP001 		rView.SetDrawFuncPtr(new DrawSelection( &rView.GetWrtShell(), this, &rView ));
//STRIP001 
//STRIP001 	rView.SetSelDrawSlot();
//STRIP001 	SetDrawMode(nSlotId);
//STRIP001 	rView.GetDrawFuncPtr()->Activate( nSlotId );
//STRIP001 	bInsFrm = FALSE;
//STRIP001 	nInsFrmColCount = 1;
//STRIP001 }



//STRIP001 void SwEditWin::StopInsFrm()
//STRIP001 {
//STRIP001 	if (rView.GetDrawFuncPtr())
//STRIP001 	{
//STRIP001 		rView.GetDrawFuncPtr()->Deactivate();
//STRIP001 		rView.SetDrawFuncPtr(NULL);
//STRIP001 	}
//STRIP001 	rView.LeaveDrawCreate();	// Konstruktionsmode verlassen
//STRIP001 	bInsFrm = FALSE;
//STRIP001 	nInsFrmColCount = 1;
//STRIP001 }

/*--------------------------------------------------------------------
	 Beschreibung:	Der Character Buffer wird in das Dokument eingefuegt
 --------------------------------------------------------------------*/


//STRIP001 void SwEditWin::FlushInBuffer( SwWrtShell *pSh )
//STRIP001 {
//STRIP001 	if ( aInBuffer.Len() )
//STRIP001 	{
//STRIP001 		::com::sun::star::uno::Reference< ::com::sun::star::frame::XDispatchRecorder > xRecorder =
//STRIP001 				rView.GetViewFrame()->GetBindings().GetRecorder();
//STRIP001 		if ( xRecorder.is() )
//STRIP001 		{
//STRIP001 			//Shell ermitteln
//STRIP001 			SfxShell *pSfxShell = lcl_GetShellFromDispatcher( rView, TYPE(SwTextShell) );
//STRIP001             // Request generieren und recorden
//STRIP001 			if (pSfxShell)
//STRIP001 			{
//STRIP001                 SfxRequest aReq( rView.GetViewFrame(), FN_INSERT_STRING );
//STRIP001                 aReq.AppendItem( SfxStringItem( FN_INSERT_STRING, aInBuffer ) );
//STRIP001 				aReq.Done();
//STRIP001 			}
//STRIP001 		}
//STRIP001 
//STRIP001         pSh->Insert( aInBuffer );
//STRIP001 		aInBuffer.Erase();
//STRIP001 		bFlushCharBuffer = FALSE;
//STRIP001 	}
//STRIP001 }

#define MOVE_LEFT_SMALL     0
#define MOVE_UP_SMALL       1
#define MOVE_RIGHT_BIG      2
#define MOVE_DOWN_BIG       3
#define MOVE_LEFT_BIG       4
#define MOVE_UP_BIG         5
#define MOVE_RIGHT_SMALL    6
#define MOVE_DOWN_SMALL     7

//STRIP001 void SwEditWin::ChangeFly( BYTE nDir, BOOL bWeb )
//STRIP001 {
//STRIP001 	SwWrtShell &rSh = rView.GetWrtShell();
//STRIP001 	SwRect aTmp = rSh.GetFlyRect();
//STRIP001 	if( aTmp.HasArea() )
//STRIP001 	{
//STRIP001         SfxItemSet aSet(rSh.GetAttrPool(),
//STRIP001 						RES_FRM_SIZE, RES_FRM_SIZE,
//STRIP001 						RES_VERT_ORIENT, RES_ANCHOR,
//STRIP001                         RES_COL, RES_COL,
//STRIP001                         RES_PROTECT, RES_PROTECT, 0);
//STRIP001 		rSh.GetFlyFrmAttr( aSet );
//STRIP001         const SvxProtectItem& rProtect = ((SvxProtectItem&)aSet.Get(RES_PROTECT));
//STRIP001         if( rProtect.IsSizeProtected() ||
//STRIP001             rProtect.IsPosProtected() )
//STRIP001         {
//STRIP001             return;
//STRIP001         }
//STRIP001         RndStdIds eAnchorId = ((SwFmtAnchor&)aSet.Get(RES_ANCHOR)).GetAnchorId();
//STRIP001         Size aSnap;
//STRIP001         if(MOVE_LEFT_SMALL == nDir ||
//STRIP001             MOVE_UP_SMALL == nDir ||
//STRIP001             MOVE_RIGHT_SMALL == nDir ||
//STRIP001             MOVE_DOWN_SMALL == nDir )
//STRIP001             aSnap = PixelToLogic(Size(1,1));
//STRIP001         else
//STRIP001         {
//STRIP001             aSnap = rSh.GetViewOptions()->GetSnapSize();
//STRIP001             short nDiv = rSh.GetViewOptions()->GetDivisionX();
//STRIP001             if ( nDiv > 0 )
//STRIP001                 aSnap.Width() = Max( (ULONG)1, (ULONG)aSnap.Width() / nDiv );
//STRIP001             nDiv = rSh.GetViewOptions()->GetDivisionY();
//STRIP001             if ( nDiv > 0 )
//STRIP001                 aSnap.Height() = Max( (ULONG)1, (ULONG)aSnap.Height() / nDiv );
//STRIP001         }
//STRIP001 
//STRIP001 		SwRect aBoundRect;
//STRIP001 		Point aRefPoint;
//STRIP001 		rSh.CalcBoundRect( aBoundRect, eAnchorId, FRAME, FALSE, &aRefPoint );
//STRIP001 		long nLeft = Min( aTmp.Left() - aBoundRect.Left(), aSnap.Width() );
//STRIP001 		long nRight = Min( aBoundRect.Right() - aTmp.Right(), aSnap.Width() );
//STRIP001 		long nUp = Min( aTmp.Top() - aBoundRect.Top(), aSnap.Height() );
//STRIP001 		long nDown = Min( aBoundRect.Bottom() - aTmp.Bottom(), aSnap.Height() );
//STRIP001 
//STRIP001 		switch ( nDir )
//STRIP001 		{
//STRIP001             case MOVE_LEFT_BIG:
//STRIP001             case MOVE_LEFT_SMALL: aTmp.Left( aTmp.Left() - nLeft ); break;
//STRIP001             case MOVE_UP_BIG:
//STRIP001             case MOVE_UP_SMALL: aTmp.Top( aTmp.Top() - nUp ); break;
//STRIP001             case MOVE_RIGHT_SMALL: if( aTmp.Width() < aSnap.Width() + MINFLY ) break;
//STRIP001 					nRight = aSnap.Width(); // kein break
//STRIP001             case MOVE_RIGHT_BIG: aTmp.Left( aTmp.Left() + nRight ); break;
//STRIP001             case MOVE_DOWN_SMALL: if( aTmp.Height() < aSnap.Height() + MINFLY ) break;
//STRIP001 					nDown = aSnap.Height(); // kein break
//STRIP001             case MOVE_DOWN_BIG: aTmp.Top( aTmp.Top() + nDown ); break;
//STRIP001             default: ASSERT( TRUE, "ChangeFly: Unknown direction." );
//STRIP001 		}
//STRIP001 		BOOL bSet = FALSE;
//STRIP001         if( FLY_IN_CNTNT == eAnchorId && ( nDir % 2 ) )
//STRIP001 		{
//STRIP001 			long aDiff = aTmp.Top() - aRefPoint.Y();
//STRIP001 			if( aDiff > 0 )
//STRIP001 				aDiff = 0;
//STRIP001 			else if ( aDiff < -aTmp.Height() )
//STRIP001 				aDiff = -aTmp.Height();
//STRIP001 			SwFmtVertOrient aVert( (SwFmtVertOrient&)aSet.Get(RES_VERT_ORIENT) );
//STRIP001 			SwVertOrient eNew;
//STRIP001 			if( bWeb )
//STRIP001 			{
//STRIP001 				eNew = aVert.GetVertOrient();
//STRIP001 				BOOL bDown = 0 != ( nDir & 0x02 );
//STRIP001 				switch( eNew )
//STRIP001 				{
//STRIP001 					case VERT_CHAR_TOP:
//STRIP001 						if( bDown ) eNew = VERT_CENTER; break;
//STRIP001 					case VERT_CENTER:
//STRIP001 						eNew = bDown ? VERT_TOP : VERT_CHAR_TOP; break;
//STRIP001 					case VERT_TOP:
//STRIP001 						if( !bDown ) eNew = VERT_CENTER; break;
//STRIP001 					case VERT_LINE_TOP:
//STRIP001 						if( bDown ) eNew = VERT_LINE_CENTER; break;
//STRIP001 					case VERT_LINE_CENTER:
//STRIP001 						eNew = bDown ? VERT_LINE_BOTTOM : VERT_LINE_TOP; break;
//STRIP001 					case VERT_LINE_BOTTOM:
//STRIP001 						if( !bDown ) eNew = VERT_LINE_CENTER; break;
//STRIP001 				}
//STRIP001 			}
//STRIP001 			else
//STRIP001 			{
//STRIP001 				aVert.SetPos( aDiff );
//STRIP001 				eNew = VERT_NONE;
//STRIP001 			}
//STRIP001 			aVert.SetVertOrient( eNew );
//STRIP001 			aSet.Put( aVert );
//STRIP001 			bSet = TRUE;
//STRIP001 		}
//STRIP001         if( bWeb && FLY_AT_CNTNT == eAnchorId && ( nDir==MOVE_LEFT_SMALL || nDir==MOVE_RIGHT_BIG ) )
//STRIP001 		{
//STRIP001 			SwFmtHoriOrient aHori( (SwFmtHoriOrient&)aSet.Get(RES_HORI_ORIENT) );
//STRIP001 			SwHoriOrient eNew;
//STRIP001 			eNew = aHori.GetHoriOrient();
//STRIP001 			switch( eNew )
//STRIP001 			{
//STRIP001 				case HORI_RIGHT:
//STRIP001                     if( nDir==MOVE_LEFT_SMALL )
//STRIP001                         eNew = HORI_LEFT;
//STRIP001                 break;
//STRIP001 				case HORI_LEFT:
//STRIP001                     if( nDir==MOVE_RIGHT_BIG )
//STRIP001                         eNew = HORI_RIGHT;
//STRIP001                 break;
//STRIP001 			}
//STRIP001 			if( eNew != aHori.GetHoriOrient() )
//STRIP001 			{
//STRIP001 				aHori.SetHoriOrient( eNew );
//STRIP001 				aSet.Put( aHori );
//STRIP001 				bSet = TRUE;
//STRIP001 			}
//STRIP001 		}
//STRIP001         rSh.StartAllAction();
//STRIP001 		if( bSet )
//STRIP001 			rSh.SetFlyFrmAttr( aSet );
//STRIP001         BOOL bSetPos = FLY_IN_CNTNT != eAnchorId;
//STRIP001         if(bSetPos && bWeb)
//STRIP001         {
//STRIP001             if(FLY_PAGE != eAnchorId)
//STRIP001                 bSetPos = FALSE;
//STRIP001             else
//STRIP001             {
//STRIP001                 bSetPos = (::binfilter::GetHtmlMode(rView.GetDocShell()) & HTMLMODE_SOME_ABS_POS) ?
//STRIP001                     TRUE : FALSE;
//STRIP001             }
//STRIP001         }
//STRIP001         if( bSetPos )
//STRIP001 			rSh.SetFlyPos( aTmp.Pos() );
//STRIP001 		rSh.EndAllAction();
//STRIP001 	}
//STRIP001 }
/* -----------------------------23.05.2002 11:35------------------------------

 ---------------------------------------------------------------------------*/
//STRIP001 void SwEditWin::ChangeDrawing( BYTE nDir )
//STRIP001 {
//STRIP001     long nX = 0;
//STRIP001     long nY = 0;
//STRIP001     sal_Bool bOnePixel = sal_False;
//STRIP001     USHORT nAnchorDir = SW_MOVE_UP;
//STRIP001     switch(nDir)
//STRIP001     {
//STRIP001         case MOVE_LEFT_SMALL:
//STRIP001             bOnePixel = sal_True;
//STRIP001             //no break;
//STRIP001         case MOVE_LEFT_BIG:
//STRIP001             nX = -1;
//STRIP001             nAnchorDir = SW_MOVE_LEFT;
//STRIP001         break;
//STRIP001         case MOVE_UP_SMALL:
//STRIP001             bOnePixel = sal_True;
//STRIP001             //no break;
//STRIP001         case MOVE_UP_BIG:
//STRIP001             nY = -1;
//STRIP001         break;
//STRIP001         case MOVE_RIGHT_SMALL:
//STRIP001             bOnePixel = sal_True;
//STRIP001             //no break;
//STRIP001         case MOVE_RIGHT_BIG:
//STRIP001             nX = +1;
//STRIP001             nAnchorDir = SW_MOVE_RIGHT;
//STRIP001         break;
//STRIP001         case MOVE_DOWN_SMALL:
//STRIP001             bOnePixel = sal_True;
//STRIP001             //no break;
//STRIP001         case MOVE_DOWN_BIG:
//STRIP001             nY = +1;
//STRIP001             nAnchorDir = SW_MOVE_DOWN;
//STRIP001         break;
//STRIP001     }
//STRIP001 
//STRIP001     if(0 != nX || 0 != nY)
//STRIP001     {
//STRIP001         SwWrtShell &rSh = rView.GetWrtShell();
//STRIP001         BYTE nProtect = rSh.IsSelObjProtected( FlyProtectType(FLYPROTECT_POS|FLYPROTECT_SIZE) );
//STRIP001         Size aSnap( rSh.GetViewOptions()->GetSnapSize() );
//STRIP001         short nDiv = rSh.GetViewOptions()->GetDivisionX();
//STRIP001         if ( nDiv > 0 )
//STRIP001             aSnap.Width() = Max( (ULONG)1, (ULONG)aSnap.Width() / nDiv );
//STRIP001         nDiv = rSh.GetViewOptions()->GetDivisionY();
//STRIP001         if ( nDiv > 0 )
//STRIP001             aSnap.Height() = Max( (ULONG)1, (ULONG)aSnap.Height() / nDiv );
//STRIP001 
//STRIP001         if(bOnePixel)
//STRIP001             aSnap = PixelToLogic(Size(1,1));
//STRIP001 
//STRIP001         nX *= aSnap.Width();
//STRIP001         nY *= aSnap.Height();
//STRIP001 
//STRIP001         SdrView *pSdrView = rSh.GetDrawView();
//STRIP001         const SdrHdlList& rHdlList = pSdrView->GetHdlList();
//STRIP001         SdrHdl* pHdl = rHdlList.GetFocusHdl();
//STRIP001         rSh.StartAllAction();
//STRIP001         if(0L == pHdl)
//STRIP001         {
//STRIP001             // now move the selected draw objects
//STRIP001             // if the object's position is not protected
//STRIP001             if(0 == (nProtect&FLYPROTECT_POS))
//STRIP001             {
//STRIP001                 pSdrView->MoveAllMarked(Size(nX, nY));
//STRIP001                 rSh.SetModified();
//STRIP001             }
//STRIP001         }
//STRIP001         else
//STRIP001         {
//STRIP001             // move handle with index nHandleIndex
//STRIP001             if(pHdl && (nX || nY))
//STRIP001             {
//STRIP001                 if( HDL_ANCHOR == pHdl->GetKind() ||
//STRIP001 				    HDL_ANCHOR_TR == pHdl->GetKind() )
//STRIP001                 {
//STRIP001                     // anchor move cannot be allowed when position is protected
//STRIP001                     if(0 == (nProtect&FLYPROTECT_POS))
//STRIP001                         rSh.MoveAnchor( nAnchorDir );
//STRIP001                 }
//STRIP001                 //now resize if size is protected
//STRIP001                 else if(0 == (nProtect&FLYPROTECT_SIZE))
//STRIP001                 {
//STRIP001                     // now move the Handle (nX, nY)
//STRIP001                     Point aStartPoint(pHdl->GetPos());
//STRIP001                     Point aEndPoint(pHdl->GetPos() + Point(nX, nY));
//STRIP001                     const SdrDragStat& rDragStat = pSdrView->GetDragStat();
//STRIP001 
//STRIP001                     // start dragging
//STRIP001                     pSdrView->BegDragObj(aStartPoint, 0, pHdl, 0);
//STRIP001 
//STRIP001                     if(pSdrView->IsDragObj())
//STRIP001                     {
//STRIP001                         FASTBOOL bWasNoSnap = rDragStat.IsNoSnap();
//STRIP001                         BOOL bWasSnapEnabled = pSdrView->IsSnapEnabled();
//STRIP001 
//STRIP001                         // switch snapping off
//STRIP001                         if(!bWasNoSnap)
//STRIP001                             ((SdrDragStat&)rDragStat).SetNoSnap(TRUE);
//STRIP001                         if(bWasSnapEnabled)
//STRIP001                             pSdrView->SetSnapEnabled(FALSE);
//STRIP001 
//STRIP001                         pSdrView->MovAction(aEndPoint);
//STRIP001                         pSdrView->EndDragObj();
//STRIP001                         rSh.SetModified();
//STRIP001 
//STRIP001                         // restore snap
//STRIP001                         if(!bWasNoSnap)
//STRIP001                             ((SdrDragStat&)rDragStat).SetNoSnap(bWasNoSnap);
//STRIP001                         if(bWasSnapEnabled)
//STRIP001                             pSdrView->SetSnapEnabled(bWasSnapEnabled);
//STRIP001                     }
//STRIP001                 }
//STRIP001             }
//STRIP001         }
//STRIP001         rSh.EndAllAction();
//STRIP001     }
//STRIP001 }

/*--------------------------------------------------------------------
	Beschreibung:	KeyEvents
 --------------------------------------------------------------------*/


//STRIP001 void SwEditWin::KeyInput(const KeyEvent &rKEvt)
//STRIP001 {
//STRIP001 	SfxObjectShell *pObjSh = (SfxObjectShell*)rView.GetViewFrame()->GetObjectShell();
//STRIP001 	if ( bLockInput || pObjSh && pObjSh->GetProgress() )
//STRIP001 		// Wenn die Rechenleiste aktiv ist oder
//STRIP001 		// auf dem Document ein Progress laeuft wird keine
//STRIP001 		// Bestellungen angenommen.
//STRIP001 		return;
//STRIP001 
//STRIP001 	if( pShadCrsr )
//STRIP001 		delete pShadCrsr, pShadCrsr = 0;
//STRIP001 	aKeyInputFlushTimer.Stop();
//STRIP001 
//STRIP001 	SwWrtShell &rSh = rView.GetWrtShell();
//STRIP001 	BOOL bIsDocReadOnly = rView.GetDocShell()->IsReadOnly() &&
//STRIP001 						  rSh.IsCrsrReadonly();
//STRIP001 
//STRIP001 	QuickHelpData aTmpQHD;
//STRIP001 	if( pQuickHlpData->bClear )
//STRIP001 	{
//STRIP001 		aTmpQHD.Move( *pQuickHlpData );
//STRIP001 		pQuickHlpData->Stop( rSh );
//STRIP001 	}
//STRIP001 
//STRIP001 	// OS:auch die DrawView braucht noch ein readonly-Flag
//STRIP001 	if ( !bIsDocReadOnly && rSh.GetDrawView() && rSh.GetDrawView()->KeyInput( rKEvt, this ) )
//STRIP001 	{
//STRIP001 		rSh.GetView().GetViewFrame()->GetBindings().InvalidateAll( FALSE );
//STRIP001 		rSh.SetModified();
//STRIP001 		return; // Event von der SdrView ausgewertet
//STRIP001 	}
//STRIP001 
//STRIP001 	if ( rView.GetDrawFuncPtr() && bInsFrm )
//STRIP001 	{
//STRIP001 		StopInsFrm();
//STRIP001 		rSh.Edit();
//STRIP001 	}
//STRIP001 
//STRIP001 	BOOL bFlushBuffer = FALSE;
//STRIP001 	BOOL bNormalChar = FALSE;
//STRIP001 	BOOL bChkInsBlank = pQuickHlpData->bChkInsBlank;
//STRIP001 	pQuickHlpData->bChkInsBlank = FALSE;
//STRIP001 
//STRIP001 	KeyEvent aKeyEvent( rKEvt );
//STRIP001 	// look for vertical mappings
//STRIP001 	if( !bIsDocReadOnly && !rSh.IsSelFrmMode() && !rSh.IsObjSelected() )
//STRIP001 	{
//STRIP001 		//JP 21.2.2002: must changed from switch to if, because the Linux
//STRIP001 		// compiler has problem with the code. Has to remove if the new general
//STRIP001 		// handler exist.
//STRIP001 		USHORT nKey = rKEvt.GetKeyCode().GetCode();
//STRIP001 
//STRIP001 #ifdef BIDI
//STRIP001         if( KEY_UP == nKey || KEY_DOWN == nKey ||
//STRIP001             KEY_LEFT == nKey || KEY_RIGHT == nKey )
//STRIP001         {
//STRIP001             if( rSh.IsInVerticalText() )
//STRIP001             {
//STRIP001                 if( KEY_UP == nKey ) nKey = KEY_LEFT;
//STRIP001                 else if( KEY_DOWN == nKey ) nKey = KEY_RIGHT;
//STRIP001                 else if( KEY_LEFT == nKey ) nKey = KEY_DOWN;
//STRIP001                 else if( KEY_RIGHT == nKey ) nKey = KEY_UP;
//STRIP001             }
//STRIP001             if ( rSh.IsInRightToLeftText() )
//STRIP001             {
//STRIP001                 if( KEY_LEFT == nKey ) nKey = KEY_RIGHT;
//STRIP001                 else if( KEY_RIGHT == nKey ) nKey = KEY_LEFT;
//STRIP001             }
//STRIP001 
//STRIP001             aKeyEvent = KeyEvent( rKEvt.GetCharCode(),
//STRIP001 							KeyCode( nKey, rKEvt.GetKeyCode().GetModifier() ),
//STRIP001 							rKEvt.GetRepeat() );
//STRIP001 		}
//STRIP001 #else
//STRIP001         if( KEY_UP == nKey ) nKey = KEY_LEFT;
//STRIP001         else if( KEY_DOWN == nKey ) nKey = KEY_RIGHT;
//STRIP001         else if( KEY_LEFT == nKey ) nKey = KEY_DOWN;
//STRIP001         else if( KEY_RIGHT == nKey ) nKey = KEY_UP;
//STRIP001 		else nKey = 0;
//STRIP001 
//STRIP001 		if( nKey && rSh.IsInVerticalText() )
//STRIP001 		{
//STRIP001 			aKeyEvent = KeyEvent( rKEvt.GetCharCode(),
//STRIP001 							KeyCode( nKey, rKEvt.GetKeyCode().GetModifier() ),
//STRIP001 							rKEvt.GetRepeat() );
//STRIP001 		}
//STRIP001 #endif
//STRIP001 	}
//STRIP001 
//STRIP001 	const KeyCode& rKeyCode = aKeyEvent.GetKeyCode();
//STRIP001 	sal_Unicode aCh = aKeyEvent.GetCharCode();
//STRIP001 
//STRIP001 	const SwFrmFmt* pFlyFmt = rSh.GetFlyFrmFmt();
//STRIP001 	if( pFlyFmt )
//STRIP001 	{
//STRIP001 		USHORT nEvent;
//STRIP001 
//STRIP001 		if( 32 <= aCh &&
//STRIP001 			0 == (( KEY_MOD1 | KEY_MOD2 ) & rKeyCode.GetModifier() ))
//STRIP001 			nEvent = SW_EVENT_FRM_KEYINPUT_ALPHA;
//STRIP001 		else
//STRIP001 			nEvent = SW_EVENT_FRM_KEYINPUT_NOALPHA;
//STRIP001 
//STRIP001 		const SvxMacro* pMacro = pFlyFmt->GetMacro().GetMacroTable().Get( nEvent );
//STRIP001 		if( pMacro )
//STRIP001 		{
//STRIP001 			String sRet;
//STRIP001 			SbxArrayRef	xArgs = new SbxArray;
//STRIP001 			SbxVariableRef xVar = new SbxVariable;
//STRIP001 			xVar->PutString( pFlyFmt->GetName() );
//STRIP001 			xArgs->Put( &xVar, 1 );
//STRIP001 
//STRIP001 			xVar = new SbxVariable;
//STRIP001 			if( SW_EVENT_FRM_KEYINPUT_ALPHA == nEvent )
//STRIP001 				xVar->PutChar( aCh );
//STRIP001 			else
//STRIP001 				xVar->PutUShort( rKeyCode.GetModifier() | rKeyCode.GetCode() );
//STRIP001 			xArgs->Put( &xVar, 2 );
//STRIP001 
//STRIP001 			rSh.ExecMacro( *pMacro, &sRet, &xArgs );
//STRIP001 			if( sRet.Len() && 0 != sRet.ToInt32() )
//STRIP001 				return ;
//STRIP001 		}
//STRIP001 	}
//STRIP001     int nLclSelectionType;
//STRIP001     //A is converted to 1
//STRIP001     if( rKeyCode.GetFullCode() == (KEY_A | KEY_MOD1 |KEY_SHIFT)
//STRIP001         && rSh.HasDrawView() &&
//STRIP001 		(0 != (nLclSelectionType = rSh.GetSelectionType()) &&
//STRIP001         ((nLclSelectionType & SwWrtShell::SEL_FRM) ||
//STRIP001         ((nLclSelectionType & SwWrtShell::SEL_DRW|SwWrtShell::SEL_DRW_FORM) &&
//STRIP001                 rSh.GetDrawView()->GetMarkList().GetMarkCount() == 1))))
//STRIP001     {
//STRIP001         SdrHdlList& rHdlList = (SdrHdlList&)rSh.GetDrawView()->GetHdlList();
//STRIP001         SdrHdl* pAnchor = rHdlList.GetHdl(HDL_ANCHOR);
//STRIP001 		if ( ! pAnchor )
//STRIP001 			pAnchor = rHdlList.GetHdl(HDL_ANCHOR_TR);
//STRIP001         if(pAnchor)
//STRIP001             rHdlList.SetFocusHdl(pAnchor);
//STRIP001         return;
//STRIP001     }
//STRIP001 
//STRIP001     OfaAutoCorrCfg* pACfg = 0;
//STRIP001     SvxAutoCorrect* pACorr = 0;
//STRIP001 
//STRIP001     ::com::sun::star::uno::Reference< ::com::sun::star::frame::XDispatchRecorder > xRecorder =
//STRIP001             rView.GetViewFrame()->GetBindings().GetRecorder();
//STRIP001     if ( !xRecorder.is() )
//STRIP001     {
//STRIP001         pACfg = OFF_APP()->GetAutoCorrConfig();
//STRIP001         pACorr = pACfg->GetAutoCorrect();
//STRIP001     }
//STRIP001 
//STRIP001 	SwModuleOptions* pModOpt = SW_MOD()->GetModuleConfig();
//STRIP001 
//STRIP001 	/*TblChgWidthHeightType*/int eTblChgMode;
//STRIP001 	USHORT nTblChgSize = 0;
//STRIP001 	BOOL bStopKeyInputTimer = TRUE;
//STRIP001 	String sFmlEntry;
//STRIP001 
//STRIP001 	enum SW_KeyState { KS_Start,
//STRIP001 					KS_CheckKey, KS_InsChar, KS_InsTab,
//STRIP001 					KS_NoNum, KS_NumOff, KS_NumOrNoNum, KS_NumDown, KS_NumUp,
//STRIP001 					KS_NextCell, KS_PrevCell, KS_OutlineUp, KS_OutlineDown,
//STRIP001 					KS_GlossaryExpand, KS_NextPrevGlossary,
//STRIP001 					KS_AutoFmtByInput, KS_DontExpand,
//STRIP001                     KS_NextObject, KS_PrevObject,
//STRIP001                     KS_KeyToView,
//STRIP001                     KS_LaunchOLEObject, KS_GoIntoFly, KS_GoIntoDrawing,
//STRIP001                     KS_EnterDrawHandleMode,
//STRIP001 					KS_CheckDocReadOnlyKeys,
//STRIP001 					KS_CheckAutoCorrect, KS_EditFormula,
//STRIP001 					KS_ColLeftBig, KS_ColRightBig,
//STRIP001 					KS_ColLeftSmall, KS_ColRightSmall,
//STRIP001 					KS_ColTopBig, KS_ColBottomBig,
//STRIP001 					KS_ColTopSmall, KS_ColBottomSmall,
//STRIP001 					KS_CellLeftBig, KS_CellRightBig,
//STRIP001 					KS_CellLeftSmall, KS_CellRightSmall,
//STRIP001 					KS_CellTopBig, KS_CellBottomBig,
//STRIP001 					KS_CellTopSmall, KS_CellBottomSmall,
//STRIP001 
//STRIP001 					KS_InsDel_ColLeftBig, KS_InsDel_ColRightBig,
//STRIP001 					KS_InsDel_ColLeftSmall, KS_InsDel_ColRightSmall,
//STRIP001 					KS_InsDel_ColTopBig, KS_InsDel_ColBottomBig,
//STRIP001 					KS_InsDel_ColTopSmall, KS_InsDel_ColBottomSmall,
//STRIP001 					KS_InsDel_CellLeftBig, KS_InsDel_CellRightBig,
//STRIP001 					KS_InsDel_CellLeftSmall, KS_InsDel_CellRightSmall,
//STRIP001 					KS_InsDel_CellTopBig, KS_InsDel_CellBottomBig,
//STRIP001 					KS_InsDel_CellTopSmall, KS_InsDel_CellBottomSmall,
//STRIP001 					KS_TblColCellInsDel,
//STRIP001 
//STRIP001                     KS_Fly_Change, KS_Draw_Change,
//STRIP001 					KS_SpecialInsert,
//STRIP001                     KS_EnterCharCell,
//STRIP001 					KS_Ende };
//STRIP001 
//STRIP001 	SW_KeyState eKeyState = bIsDocReadOnly ? KS_CheckDocReadOnlyKeys
//STRIP001 										   : KS_CheckKey,
//STRIP001 				eNextKeyState = KS_Ende;
//STRIP001 	BYTE nDir;
//STRIP001 
//STRIP001 	while( KS_Ende != eKeyState )
//STRIP001 	{
//STRIP001 		SW_KeyState eFlyState = KS_KeyToView;
//STRIP001 
//STRIP001 		switch( eKeyState )
//STRIP001 		{
//STRIP001 		case KS_CheckKey:
//STRIP001 			eKeyState = KS_KeyToView;		// default weiter zur View
//STRIP001 
//STRIP001 #ifndef PRODUCT
//STRIP001 //!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
//STRIP001 			// JP 19.01.99: zum Umschalten des Cursor Verhaltens in ReadOnly
//STRIP001 			//				Bereichen
//STRIP001 			if( 0x7210 == rKeyCode.GetFullCode() )
//STRIP001 				rSh.SetReadOnlyAvailable( !rSh.IsReadOnlyAvailable() );
//STRIP001 			else
//STRIP001 //!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
//STRIP001 #endif
//STRIP001 
//STRIP001 			if( !rKeyCode.IsControlMod() && '=' == aCh &&
//STRIP001 				!rSh.IsTableMode() && rSh.GetTableFmt() &&
//STRIP001 				rSh.IsSttPara() /*&& rSh.IsEndPara()*/ &&
//STRIP001 				!rSh.HasReadonlySel() )
//STRIP001 			{
//STRIP001 				// in der Tabelle am Anfang der Zelle ein '=' ->
//STRIP001 				//	EditZeile aufrufen (F2-Funktionalitaet)
//STRIP001 				rSh.Push();
//STRIP001 				if( !rSh.MoveSection( fnSectionCurr, fnSectionStart) &&
//STRIP001 					!rSh.IsTableBoxTextFormat() )
//STRIP001 				{
//STRIP001 					// steht also am Anfang der Box
//STRIP001 					eKeyState = KS_EditFormula;
//STRIP001 					if( rSh.HasMark() )
//STRIP001 						rSh.SwapPam();
//STRIP001 					else
//STRIP001 						rSh.SttSelect();
//STRIP001 					rSh.MoveSection( fnSectionCurr, fnSectionEnd );
//STRIP001 					rSh.Pop( TRUE );
//STRIP001 					rSh.EndSelect();
//STRIP001 					sFmlEntry = '=';
//STRIP001 				}
//STRIP001 				else
//STRIP001 					rSh.Pop( FALSE );
//STRIP001 			}
//STRIP001 			else
//STRIP001 			{
//STRIP001 				if( pACorr && aTmpQHD.HasCntnt() && !rSh.HasSelection() &&
//STRIP001 					!rSh.HasReadonlySel() && !aTmpQHD.bIsAutoText &&
//STRIP001 					pACorr->GetSwFlags().nAutoCmpltExpandKey ==
//STRIP001 					(rKeyCode.GetModifier() | rKeyCode.GetCode()) )
//STRIP001 				{
//STRIP001 					eKeyState = KS_GlossaryExpand;
//STRIP001 					break;
//STRIP001 				}
//STRIP001 
//STRIP001 				switch( rKeyCode.GetModifier() | rKeyCode.GetCode() )
//STRIP001 				{
//STRIP001 				case KEY_RIGHT | KEY_MOD2:
//STRIP001 					eKeyState = KS_ColRightBig;
//STRIP001 					eFlyState = KS_Fly_Change;
//STRIP001                     nDir = MOVE_RIGHT_SMALL;
//STRIP001 					goto KEYINPUT_CHECKTABLE;
//STRIP001 
//STRIP001 				case KEY_LEFT | KEY_MOD2:
//STRIP001 					eKeyState = KS_ColRightSmall;
//STRIP001 					eFlyState = KS_Fly_Change;
//STRIP001                     nDir = MOVE_LEFT_SMALL;
//STRIP001 					goto KEYINPUT_CHECKTABLE;
//STRIP001 				case KEY_RIGHT | KEY_MOD2 | KEY_SHIFT:
//STRIP001 					eKeyState = KS_ColLeftSmall;
//STRIP001 					goto KEYINPUT_CHECKTABLE;
//STRIP001 				case KEY_LEFT | KEY_MOD2 | KEY_SHIFT:
//STRIP001 					eKeyState = KS_ColLeftBig;
//STRIP001 					goto KEYINPUT_CHECKTABLE;
//STRIP001 
//STRIP001 				case KEY_RIGHT | KEY_MOD2 | KEY_MOD1:
//STRIP001 					eKeyState = KS_CellRightBig;
//STRIP001                     goto KEYINPUT_CHECKTABLE;
//STRIP001 				case KEY_LEFT | KEY_MOD2 | KEY_MOD1:
//STRIP001 					eKeyState = KS_CellRightSmall;
//STRIP001                     goto KEYINPUT_CHECKTABLE;
//STRIP001 				case KEY_RIGHT | KEY_MOD2 | KEY_SHIFT | KEY_MOD1:
//STRIP001 					eKeyState = KS_CellLeftSmall;
//STRIP001                     goto KEYINPUT_CHECKTABLE;
//STRIP001 				case KEY_LEFT | KEY_MOD2 | KEY_SHIFT | KEY_MOD1:
//STRIP001 					eKeyState = KS_CellLeftBig;
//STRIP001                     goto KEYINPUT_CHECKTABLE;
//STRIP001 
//STRIP001 				case KEY_UP | KEY_MOD2:
//STRIP001 					eKeyState = KS_ColBottomSmall;
//STRIP001 					eFlyState = KS_Fly_Change;
//STRIP001                     nDir = MOVE_UP_SMALL;
//STRIP001 					goto KEYINPUT_CHECKTABLE;
//STRIP001 				case KEY_DOWN | KEY_MOD2:
//STRIP001 					eKeyState = KS_ColBottomBig;
//STRIP001 					eFlyState = KS_Fly_Change;
//STRIP001                     nDir = MOVE_DOWN_SMALL;
//STRIP001 					goto KEYINPUT_CHECKTABLE;
//STRIP001 				case KEY_UP | KEY_MOD2 | KEY_SHIFT:
//STRIP001 					eKeyState = KS_ColTopBig;
//STRIP001 					goto KEYINPUT_CHECKTABLE;
//STRIP001 				case KEY_DOWN | KEY_MOD2 | KEY_SHIFT:
//STRIP001 					eKeyState = KS_ColTopSmall;
//STRIP001 					goto KEYINPUT_CHECKTABLE;
//STRIP001 
//STRIP001 				case KEY_UP | KEY_MOD2 | KEY_MOD1:
//STRIP001 					eKeyState = KS_CellBottomSmall;
//STRIP001                     goto KEYINPUT_CHECKTABLE;
//STRIP001 				case KEY_DOWN | KEY_MOD2 | KEY_MOD1:
//STRIP001 					eKeyState = KS_CellBottomBig;
//STRIP001                     goto KEYINPUT_CHECKTABLE;
//STRIP001 				case KEY_UP | KEY_MOD2 | KEY_SHIFT | KEY_MOD1:
//STRIP001 					eKeyState = KS_CellTopBig;
//STRIP001                     goto KEYINPUT_CHECKTABLE;
//STRIP001 				case KEY_DOWN | KEY_MOD2 | KEY_SHIFT | KEY_MOD1:
//STRIP001 					eKeyState = KS_CellTopSmall;
//STRIP001                     goto KEYINPUT_CHECKTABLE;
//STRIP001 
//STRIP001 KEYINPUT_CHECKTABLE:
//STRIP001 					if( rSh.IsTableMode() || !rSh.GetTableFmt() )
//STRIP001 					{
//STRIP001                         if(KS_KeyToView != eFlyState)
//STRIP001                         {
//STRIP001                             if(!pFlyFmt && KS_KeyToView != eFlyState &&
//STRIP001                                 (rSh.GetSelectionType() & (SwWrtShell::SEL_DRW|SwWrtShell::SEL_DRW_FORM))  &&
//STRIP001                                     rSh.GetDrawView()->HasMarkedObj())
//STRIP001                                 eKeyState = KS_Draw_Change;
//STRIP001                         }
//STRIP001 
//STRIP001 						if( pFlyFmt )
//STRIP001 							eKeyState = eFlyState;
//STRIP001                         else if( KS_Draw_Change != eKeyState)
//STRIP001                             eKeyState = KS_EnterCharCell;
//STRIP001 					}
//STRIP001 					break;
//STRIP001 
//STRIP001 //-------
//STRIP001 // Insert/Delete
//STRIP001 				case KEY_LEFT:
//STRIP001 				case KEY_LEFT | KEY_MOD1:
//STRIP001                 {
//STRIP001                     BOOL bMod1 = 0 != (rKeyCode.GetModifier() & KEY_MOD1);
//STRIP001                     if(!bMod1)
//STRIP001                     {
//STRIP001                         eFlyState = KS_Fly_Change;
//STRIP001                         nDir = MOVE_LEFT_BIG;
//STRIP001                     }
//STRIP001                     eTblChgMode = WH_FLAG_INSDEL |
//STRIP001                             ( bMod1
//STRIP001 								? WH_CELL_LEFT
//STRIP001 								: WH_COL_LEFT );
//STRIP001 					nTblChgSize = pModOpt->GetTblVInsert();
//STRIP001                 }
//STRIP001                     goto KEYINPUT_CHECKTABLE_INSDEL;
//STRIP001 //                case KEY_RIGHT:
//STRIP001 				case KEY_RIGHT | KEY_MOD1:
//STRIP001                 {
//STRIP001                     eTblChgMode = WH_FLAG_INSDEL | WH_CELL_RIGHT;
//STRIP001 					nTblChgSize = pModOpt->GetTblVInsert();
//STRIP001                 }
//STRIP001                     goto KEYINPUT_CHECKTABLE_INSDEL;
//STRIP001 				case KEY_UP:
//STRIP001 				case KEY_UP | KEY_MOD1:
//STRIP001                 {
//STRIP001                     BOOL bMod1 = 0 != (rKeyCode.GetModifier() & KEY_MOD1);
//STRIP001                     if(!bMod1)
//STRIP001                     {
//STRIP001                         eFlyState = KS_Fly_Change;
//STRIP001                         nDir = MOVE_UP_BIG;
//STRIP001                     }
//STRIP001                     eTblChgMode = WH_FLAG_INSDEL |
//STRIP001                             ( bMod1
//STRIP001 								? WH_CELL_TOP
//STRIP001 								: WH_ROW_TOP );
//STRIP001 					nTblChgSize = pModOpt->GetTblHInsert();
//STRIP001                 }
//STRIP001                     goto KEYINPUT_CHECKTABLE_INSDEL;
//STRIP001                 case KEY_DOWN:
//STRIP001 				case KEY_DOWN | KEY_MOD1:
//STRIP001                 {
//STRIP001                     BOOL bMod1 = 0 != (rKeyCode.GetModifier() & KEY_MOD1);
//STRIP001                     if(!bMod1)
//STRIP001                     {
//STRIP001                         eFlyState = KS_Fly_Change;
//STRIP001                         nDir = MOVE_DOWN_BIG;
//STRIP001                     }
//STRIP001                     eTblChgMode = WH_FLAG_INSDEL |
//STRIP001                             ( bMod1
//STRIP001 								? WH_CELL_BOTTOM
//STRIP001 								: WH_ROW_BOTTOM );
//STRIP001 					nTblChgSize = pModOpt->GetTblHInsert();
//STRIP001                 }
//STRIP001 					goto KEYINPUT_CHECKTABLE_INSDEL;
//STRIP001 
//STRIP001 KEYINPUT_CHECKTABLE_INSDEL:
//STRIP001 					if( rSh.IsTableMode() || !rSh.GetTableFmt() ||
//STRIP001 						!bTblInsDelMode ||
//STRIP001 						FALSE /* Tabelle geschuetzt */
//STRIP001 							)
//STRIP001                     {
//STRIP001                         const int nSelectionType = rSh.GetSelectionType();
//STRIP001 
//STRIP001                         eKeyState = KS_KeyToView;
//STRIP001                         if(KS_KeyToView != eFlyState)
//STRIP001 						{
//STRIP001                             if((nSelectionType & (SwWrtShell::SEL_DRW|SwWrtShell::SEL_DRW_FORM))  &&
//STRIP001 									rSh.GetDrawView()->HasMarkedObj())
//STRIP001 								eKeyState = KS_Draw_Change;
//STRIP001                             else if(nSelectionType & (SwWrtShell::SEL_FRM|SwWrtShell::SEL_OLE|SwWrtShell::SEL_GRF))
//STRIP001 								eKeyState = KS_Fly_Change;
//STRIP001 						}
//STRIP001                     }
//STRIP001 					else
//STRIP001 					{
//STRIP001 						if( !bTblIsInsMode )
//STRIP001 							eTblChgMode = eTblChgMode | WH_FLAG_BIGGER;
//STRIP001 						eKeyState = KS_TblColCellInsDel;
//STRIP001 					}
//STRIP001 					break;
//STRIP001 
//STRIP001 				case KEY_DELETE | KEY_MOD2:
//STRIP001 					if( !rSh.IsTableMode() && rSh.GetTableFmt() )
//STRIP001 					{
//STRIP001 						eKeyState = KS_Ende;
//STRIP001 						bTblInsDelMode = TRUE;
//STRIP001 						bTblIsInsMode = FALSE;
//STRIP001 						bTblIsColMode = TRUE;
//STRIP001 						aKeyInputTimer.Start();
//STRIP001 						bStopKeyInputTimer = FALSE;
//STRIP001 					}
//STRIP001 					break;
//STRIP001 				case KEY_INSERT | KEY_MOD2:
//STRIP001 					if( !rSh.IsTableMode() && rSh.GetTableFmt() )
//STRIP001 					{
//STRIP001 						eKeyState = KS_Ende;
//STRIP001 						bTblInsDelMode = TRUE;
//STRIP001 						bTblIsInsMode = TRUE;
//STRIP001 						bTblIsColMode = TRUE;
//STRIP001 						aKeyInputTimer.Start();
//STRIP001 						bStopKeyInputTimer = FALSE;
//STRIP001 					}
//STRIP001 					break;
//STRIP001 
//STRIP001 				case KEY_RETURN:				// Return
//STRIP001 					if( !rSh.HasReadonlySel() )
//STRIP001 					{
//STRIP001                         const int nSelectionType = rSh.GetSelectionType();
//STRIP001                         if(nSelectionType & SwWrtShell::SEL_OLE)
//STRIP001                             eKeyState = KS_LaunchOLEObject;
//STRIP001                         else if(nSelectionType & SwWrtShell::SEL_FRM)
//STRIP001                             eKeyState = KS_GoIntoFly;
//STRIP001                         else if((nSelectionType & SwWrtShell::SEL_DRW) &&
//STRIP001                                 0 == (nSelectionType & SwWrtShell::SEL_DRW_TXT) &&
//STRIP001                                 rSh.GetDrawView()->GetMarkList().GetMarkCount() == 1)
//STRIP001                             eKeyState = KS_GoIntoDrawing;
//STRIP001                         else if( aTmpQHD.HasCntnt() && !rSh.HasSelection() &&
//STRIP001 							aTmpQHD.bIsAutoText )
//STRIP001         					eKeyState = KS_GlossaryExpand;
//STRIP001 
//STRIP001 						//RETURN und leerer Absatz in Numerierung -> Num. beenden
//STRIP001 						else if( rSh.GetCurNumRule() && !rSh.HasSelection() &&
//STRIP001 								rSh.IsSttPara() && rSh.IsEndPara() )
//STRIP001 							eKeyState = KS_NumOff;
//STRIP001 
//STRIP001 						//RETURN fuer neuen Absatz mit AutoFormatierung
//STRIP001 						else if( pACfg && pACfg->IsAutoFmtByInput() &&
//STRIP001                                 !(nSelectionType & (SwWrtShell::SEL_GRF |
//STRIP001 									SwWrtShell::SEL_OLE | SwWrtShell::SEL_FRM |
//STRIP001 									SwWrtShell::SEL_TBL_CELLS | SwWrtShell::SEL_DRW |
//STRIP001 									SwWrtShell::SEL_DRW_TXT)) )
//STRIP001 							eKeyState = KS_CheckAutoCorrect, eNextKeyState = KS_AutoFmtByInput;
//STRIP001 						else
//STRIP001 							eNextKeyState = eKeyState, eKeyState = KS_CheckAutoCorrect;
//STRIP001 					}
//STRIP001 					break;
//STRIP001 
//STRIP001 				case KEY_RETURN | KEY_MOD2:		// ALT-Return
//STRIP001 					if( !rSh.HasReadonlySel() && rSh.GetCurNumRule() )
//STRIP001 						eKeyState = KS_NoNum;
//STRIP001 					else if( rSh.CanSpecialInsert() )
//STRIP001 						eKeyState = KS_SpecialInsert;
//STRIP001 					break;
//STRIP001 
//STRIP001 				case KEY_BACKSPACE:
//STRIP001 				case KEY_BACKSPACE | KEY_SHIFT:
//STRIP001 					if( !rSh.HasReadonlySel() )
//STRIP001 					{
//STRIP001 						BOOL bOutline = FALSE;
//STRIP001 #ifdef TASK_59308
//STRIP001 						const SwTxtFmtColl* pColl;
//STRIP001 						if( !rSh.SwCrsrShell::HasSelection() &&
//STRIP001 							0 != ( pColl = rSh.GetCurTxtFmtColl() ) &&
//STRIP001 							NO_NUMBERING != pColl->GetOutlineLevel() &&
//STRIP001 							NO_NUMBERING == rSh.GetNumLevel( FALSE ) )
//STRIP001 							bOutline = TRUE;
//STRIP001 #endif
//STRIP001 
//STRIP001 						if( rSh.NumOrNoNum(
//STRIP001 									KEY_BACKSPACE != rKeyCode.GetFullCode(),
//STRIP001 									TRUE, bOutline ))
//STRIP001 							eKeyState = KS_NumOrNoNum;
//STRIP001 					}
//STRIP001 					break;
//STRIP001 
//STRIP001 				case KEY_END:
//STRIP001 					if( !rSh.HasReadonlySel() && rSh.IsEndPara() &&
//STRIP001 						rSh.DontExpandFmt() )
//STRIP001 						eKeyState = KS_DontExpand;
//STRIP001 					break;
//STRIP001 
//STRIP001 				case KEY_RIGHT:
//STRIP001 					{
//STRIP001                         if( rSh.IsEndPara() && rSh.DontExpandFmt() && !rSh.HasReadonlySel())
//STRIP001 							eKeyState = KS_DontExpand;
//STRIP001 						else
//STRIP001 						{
//STRIP001                             BOOL bMod1 = 0 != (rKeyCode.GetModifier() & KEY_MOD1);
//STRIP001                             eFlyState = KS_Fly_Change;
//STRIP001                             nDir = MOVE_RIGHT_BIG;
//STRIP001                             eTblChgMode = WH_FLAG_INSDEL | WH_COL_RIGHT;
//STRIP001 							nTblChgSize = pModOpt->GetTblVInsert();
//STRIP001 							goto KEYINPUT_CHECKTABLE_INSDEL;
//STRIP001 						}
//STRIP001 					}
//STRIP001 					break;
//STRIP001                 case KEY_TAB:
//STRIP001 				{
//STRIP001 #ifdef SW_CRSR_TIMER
//STRIP001 					BOOL bOld = rSh.ChgCrsrTimerFlag( FALSE );
//STRIP001 #endif
//STRIP001 					if( rSh.GetCurNumRule() && rSh.IsSttOfPara() &&
//STRIP001 						!rSh.HasReadonlySel() )
//STRIP001 						eKeyState = KS_NumDown;
//STRIP001 					else if ( rSh.GetTableFmt() )
//STRIP001 					{
//STRIP001 						if( rSh.HasSelection() || rSh.HasReadonlySel() )
//STRIP001 							eKeyState = KS_NextCell;
//STRIP001 						else
//STRIP001 							eKeyState = KS_CheckAutoCorrect, eNextKeyState = KS_NextCell;
//STRIP001 					}
//STRIP001                     else if ( rSh.GetSelectionType() &
//STRIP001                                 (SwWrtShell::SEL_GRF |
//STRIP001                                     SwWrtShell::SEL_FRM |
//STRIP001                                     SwWrtShell::SEL_OLE |
//STRIP001                                     SwWrtShell::SEL_DRW |
//STRIP001 									SwWrtShell::SEL_DRW_FORM))
//STRIP001 
//STRIP001                             eKeyState = KS_NextObject;
//STRIP001                     else
//STRIP001 					{
//STRIP001 						eKeyState = KS_InsTab;
//STRIP001 						if( rSh.IsSttOfPara() && !rSh.HasReadonlySel() )
//STRIP001 						{
//STRIP001 							SwTxtFmtColl* pColl = rSh.GetCurTxtFmtColl();
//STRIP001 							if( pColl && 0 <= pColl->GetOutlineLevel() &&
//STRIP001 								MAXLEVEL - 1 > pColl->GetOutlineLevel() )
//STRIP001 								eKeyState = KS_OutlineDown;
//STRIP001 						}
//STRIP001 					}
//STRIP001 #ifdef SW_CRSR_TIMER
//STRIP001 					rSh.ChgCrsrTimerFlag( bOld );
//STRIP001 #endif
//STRIP001 				}
//STRIP001 				break;
//STRIP001 				case KEY_TAB | KEY_SHIFT:
//STRIP001 				{
//STRIP001 #ifdef SW_CRSR_TIMER
//STRIP001 					BOOL bOld = rSh.ChgCrsrTimerFlag( FALSE );
//STRIP001 #endif
//STRIP001 					if( rSh.GetCurNumRule() && rSh.IsSttOfPara() &&
//STRIP001 						!rSh.HasReadonlySel() )
//STRIP001 						eKeyState = KS_NumUp;
//STRIP001 					else if ( rSh.GetTableFmt() )
//STRIP001 					{
//STRIP001 						if( rSh.HasSelection() || rSh.HasReadonlySel() )
//STRIP001 							eKeyState = KS_PrevCell;
//STRIP001 						else
//STRIP001 							eKeyState = KS_CheckAutoCorrect, eNextKeyState = KS_PrevCell;
//STRIP001 					}
//STRIP001                     else if ( rSh.GetSelectionType() &
//STRIP001                                 (SwWrtShell::SEL_GRF |
//STRIP001                                     SwWrtShell::SEL_FRM |
//STRIP001                                     SwWrtShell::SEL_OLE |
//STRIP001                                     SwWrtShell::SEL_DRW |
//STRIP001                                     SwWrtShell::SEL_DRW_FORM))
//STRIP001 
//STRIP001                             eKeyState = KS_PrevObject;
//STRIP001                     else
//STRIP001 					{
//STRIP001 						eKeyState = KS_Ende;
//STRIP001 						if( rSh.IsSttOfPara() && !rSh.HasReadonlySel() )
//STRIP001 						{
//STRIP001 							SwTxtFmtColl* pColl = rSh.GetCurTxtFmtColl();
//STRIP001 							if( pColl && 0 < pColl->GetOutlineLevel() &&
//STRIP001 								MAXLEVEL - 1 >= pColl->GetOutlineLevel() )
//STRIP001 								eKeyState = KS_OutlineUp;
//STRIP001 						}
//STRIP001 					}
//STRIP001 #ifdef SW_CRSR_TIMER
//STRIP001 					rSh.ChgCrsrTimerFlag( bOld );
//STRIP001 #endif
//STRIP001 				}
//STRIP001 				break;
//STRIP001 				case KEY_TAB | KEY_MOD1:
//STRIP001                 case KEY_TAB | KEY_MOD2:
//STRIP001                     if( !rSh.HasReadonlySel() )
//STRIP001 					{
//STRIP001 						if( aTmpQHD.HasCntnt() && !rSh.HasSelection() )
//STRIP001 						{
//STRIP001 							// zum naechsten Tip
//STRIP001 							aTmpQHD.Inc( pACorr && pACorr->GetSwFlags().
//STRIP001 												   bAutoCmpltEndless );
//STRIP001 							eKeyState = KS_NextPrevGlossary;
//STRIP001 						}
//STRIP001 						else if( rSh.GetTableFmt() )
//STRIP001 							eKeyState = KS_InsTab;
//STRIP001                         else if((rSh.GetSelectionType() &
//STRIP001                                     (SwWrtShell::SEL_DRW|SwWrtShell::SEL_DRW_FORM|
//STRIP001                                         SwWrtShell::SEL_FRM|SwWrtShell::SEL_OLE|SwWrtShell::SEL_GRF))  &&
//STRIP001                                 rSh.GetDrawView()->HasMarkedObj())
//STRIP001                             eKeyState = KS_EnterDrawHandleMode;
//STRIP001                         else if( rSh.IsSttOfPara() )
//STRIP001 						{
//STRIP001 							if( rSh.GetCurNumRule() )
//STRIP001 								eKeyState = KS_InsTab;
//STRIP001 							else
//STRIP001 							{
//STRIP001 								SwTxtFmtColl* pColl = rSh.GetCurTxtFmtColl();
//STRIP001 								if( pColl && 0 <= pColl->GetOutlineLevel() &&
//STRIP001 									MAXLEVEL - 1 > pColl->GetOutlineLevel() )
//STRIP001 									eKeyState = KS_InsTab;
//STRIP001 							}
//STRIP001 						}
//STRIP001                     }
//STRIP001 					break;
//STRIP001 
//STRIP001                     case KEY_TAB | KEY_MOD1 | KEY_SHIFT:
//STRIP001                         if( aTmpQHD.HasCntnt() && !rSh.HasSelection() &&
//STRIP001                             !rSh.HasReadonlySel() )
//STRIP001                         {
//STRIP001                             // zum vorherigen Tip
//STRIP001                             aTmpQHD.Dec( pACorr && pACorr->GetSwFlags().
//STRIP001                                                         bAutoCmpltEndless );
//STRIP001                             eKeyState = KS_NextPrevGlossary;
//STRIP001                         }
//STRIP001                         else if((rSh.GetSelectionType() & (SwWrtShell::SEL_DRW|SwWrtShell::SEL_DRW_FORM|
//STRIP001                                         SwWrtShell::SEL_FRM|SwWrtShell::SEL_OLE|SwWrtShell::SEL_GRF)) &&
//STRIP001                                 rSh.GetDrawView()->HasMarkedObj())
//STRIP001                             eKeyState = KS_EnterDrawHandleMode;
//STRIP001                     break;
//STRIP001                     case KEY_F2 :
//STRIP001                     if( !rSh.HasReadonlySel() )
//STRIP001                     {
//STRIP001                         const int nSelectionType = rSh.GetSelectionType();
//STRIP001                         if(nSelectionType & SwWrtShell::SEL_FRM)
//STRIP001                             eKeyState = KS_GoIntoFly;
//STRIP001                         else if((nSelectionType & SwWrtShell::SEL_DRW))
//STRIP001                             eKeyState = KS_GoIntoDrawing;
//STRIP001                     }
//STRIP001                     break;
//STRIP001                 }
//STRIP001             }
//STRIP001 			break;
//STRIP001         case KS_CheckDocReadOnlyKeys:
//STRIP001 			{
//STRIP001 				eKeyState = KS_KeyToView;
//STRIP001 				switch( rKeyCode.GetModifier() | rKeyCode.GetCode() )
//STRIP001 				{
//STRIP001                     case KEY_TAB:
//STRIP001                     case KEY_TAB | KEY_SHIFT:
//STRIP001                         bNormalChar = FALSE;
//STRIP001                         eKeyState = KS_Ende;
//STRIP001 						if ( rSh.GetSelectionType() &
//STRIP001                                 (SwWrtShell::SEL_GRF |
//STRIP001                                     SwWrtShell::SEL_FRM |
//STRIP001                                     SwWrtShell::SEL_OLE |
//STRIP001                                     SwWrtShell::SEL_DRW |
//STRIP001                                     SwWrtShell::SEL_DRW_FORM))
//STRIP001 
//STRIP001 						{
//STRIP001 							eKeyState = rKeyCode.GetModifier() & KEY_SHIFT ?
//STRIP001 												KS_PrevObject : KS_NextObject;
//STRIP001 						}
//STRIP001 						else
//STRIP001 							rSh.SelectNextPrevHyperlink(
//STRIP001                                             KEY_SHIFT != rKeyCode.GetModifier() );
//STRIP001                     break;
//STRIP001                     case KEY_RETURN:
//STRIP001                     {
//STRIP001                         const int nSelectionType = rSh.GetSelectionType();
//STRIP001                         if(nSelectionType & SwWrtShell::SEL_FRM)
//STRIP001                             eKeyState = KS_GoIntoFly;
//STRIP001                         else
//STRIP001                         {
//STRIP001                             SfxItemSet aSet(rSh.GetAttrPool(), RES_TXTATR_INETFMT, RES_TXTATR_INETFMT);
//STRIP001                             rSh.GetAttr(aSet);
//STRIP001                             if(SFX_ITEM_SET == aSet.GetItemState(RES_TXTATR_INETFMT, FALSE))
//STRIP001                             {
//STRIP001                                 const SfxPoolItem& rItem = aSet.Get(RES_TXTATR_INETFMT, TRUE);
//STRIP001                                 bNormalChar = FALSE;
//STRIP001                                 eKeyState = KS_Ende;
//STRIP001                                 rSh.ClickToINetAttr((const SwFmtINetFmt&)rItem, URLLOAD_NOFILTER);
//STRIP001                             }
//STRIP001                         }
//STRIP001                     }
//STRIP001                     break;
//STRIP001 				}
//STRIP001 			}
//STRIP001 			break;
//STRIP001 
//STRIP001         case KS_EnterCharCell:
//STRIP001             {
//STRIP001                 eKeyState = KS_KeyToView;
//STRIP001                 switch ( rKeyCode.GetModifier() | rKeyCode.GetCode() )
//STRIP001                 {
//STRIP001                     case KEY_RIGHT | KEY_MOD2:
//STRIP001                         rSh.Right( CRSR_SKIP_CHARS, FALSE, 1, FALSE );
//STRIP001                         eKeyState = KS_Ende;
//STRIP001                         FlushInBuffer( &rSh );
//STRIP001                         break;
//STRIP001                     case KEY_LEFT | KEY_MOD2:
//STRIP001                         rSh.Left( CRSR_SKIP_CHARS, FALSE, 1, FALSE );
//STRIP001                         eKeyState = KS_Ende;
//STRIP001                         FlushInBuffer( &rSh );
//STRIP001                         break;
//STRIP001                 }
//STRIP001             }
//STRIP001             break;
//STRIP001 
//STRIP001 		case KS_KeyToView:
//STRIP001 			{
//STRIP001 				eKeyState = KS_Ende;
//STRIP001 				bNormalChar = !rKeyCode.IsControlMod() &&
//STRIP001 								SW_ISPRINTABLE( aCh );
//STRIP001 				if( aInBuffer.Len() && ( !bNormalChar || bIsDocReadOnly ))
//STRIP001 					FlushInBuffer( &rSh );
//STRIP001 
//STRIP001 				if( rView.KeyInput( aKeyEvent ) )
//STRIP001 					bFlushBuffer = TRUE, bNormalChar = FALSE;
//STRIP001 				else
//STRIP001 				{
//STRIP001 // OS 22.09.95: Da der Sfx Acceleratoren nur aufruft, wenn sie beim letzten
//STRIP001 //				Statusupdate enabled wurden, muss copy ggf. von uns
//STRIP001 //              'gewaltsam' gerufen werden.
//STRIP001 					if( rKeyCode.GetFunction() == KEYFUNC_COPY )
//STRIP001                         GetView().GetViewFrame()->GetBindings().Execute(SID_COPY);
//STRIP001 
//STRIP001 
//STRIP001 					if( !bIsDocReadOnly && bNormalChar )
//STRIP001                     {
//STRIP001                         const int nSelectionType = rSh.GetSelectionType();
//STRIP001                         if((nSelectionType & SwWrtShell::SEL_DRW) &&
//STRIP001                             0 == (nSelectionType & SwWrtShell::SEL_DRW_TXT) &&
//STRIP001                             rSh.GetDrawView()->GetMarkList().GetMarkCount() == 1)
//STRIP001                                 eKeyState = KS_GoIntoDrawing;
//STRIP001                         else
//STRIP001                             eKeyState = KS_InsChar;
//STRIP001                     }
//STRIP001                     else
//STRIP001 					{
//STRIP001 						bNormalChar = FALSE;
//STRIP001 						Window::KeyInput( aKeyEvent );
//STRIP001 					}
//STRIP001 				}
//STRIP001 			}
//STRIP001 			break;
//STRIP001         case KS_LaunchOLEObject:
//STRIP001             rSh.LaunchOLEObj();
//STRIP001             eKeyState = KS_Ende;
//STRIP001         break;
//STRIP001         case KS_GoIntoFly :
//STRIP001             rSh.UnSelectFrm();
//STRIP001             rSh.LeaveSelFrmMode();
//STRIP001             rView.AttrChangedNotify(&rSh);
//STRIP001             eKeyState = KS_Ende;
//STRIP001         break;
//STRIP001         case KS_GoIntoDrawing :
//STRIP001         {
//STRIP001             SdrObject* pObj = rSh.GetDrawView()->GetMarkList().GetMark(0)->GetObj();
//STRIP001             if(pObj)
//STRIP001             {
//STRIP001                 EnterDrawTextMode(pObj->GetLogicRect().Center());
//STRIP001                 if ( rView.GetCurShell()->ISA(SwDrawTextShell) )
//STRIP001                     ((SwDrawTextShell*)rView.GetCurShell())->Init();
//STRIP001             }
//STRIP001             eKeyState = KS_Ende;
//STRIP001         }
//STRIP001         break;
//STRIP001         case KS_EnterDrawHandleMode:
//STRIP001         {
//STRIP001             const SdrHdlList& rHdlList = rSh.GetDrawView()->GetHdlList();
//STRIP001             sal_Bool bForward(!aKeyEvent.GetKeyCode().IsShift());
//STRIP001 
//STRIP001             ((SdrHdlList&)rHdlList).TravelFocusHdl(bForward);
//STRIP001             eKeyState = KS_Ende;
//STRIP001         }
//STRIP001         break;
//STRIP001 		case KS_InsTab:
//STRIP001 			if( rView.ISA( SwWebView ))		//Kein Tabulator fuer Web!
//STRIP001 			{
//STRIP001 				// Bug 56196 - dann sollte der weiter gereicht werden.
//STRIP001 				Window::KeyInput( aKeyEvent );
//STRIP001 				eKeyState = KS_Ende;
//STRIP001 				break;
//STRIP001 			}
//STRIP001 			aCh = '\t';
//STRIP001 			// kein break!
//STRIP001 		case KS_InsChar:
//STRIP001 		if( !rSh.HasReadonlySel() )
//STRIP001 		{
//STRIP001 			BOOL bIsNormalChar = GetAppCharClass().isLetterNumeric(
//STRIP001 														String( aCh ), 0 );
//STRIP001 			if( bChkInsBlank && bIsNormalChar &&
//STRIP001 				(aInBuffer.Len() || !rSh.IsSttPara() || !rSh.IsEndPara() ))
//STRIP001 			{
//STRIP001 				// vor dem Zeichen noch ein Blank einfuegen. Dieses
//STRIP001 				// kommt zwischen den Expandierten Text und dem neuen
//STRIP001 				// "nicht Worttrenner".
//STRIP001 				aInBuffer.Expand( aInBuffer.Len() + 1, ' ' );
//STRIP001 			}
//STRIP001 
//STRIP001 
//STRIP001 			if( !aKeyEvent.GetRepeat() && pACorr &&
//STRIP001 				(( pACorr->IsAutoCorrFlag( ChgWeightUnderl ) &&
//STRIP001 					( '*' == aCh || '_' == aCh ) ) ||
//STRIP001 				 ( pACorr->IsAutoCorrFlag( ChgQuotes ) && ('\"' == aCh ))||
//STRIP001 				 ( pACorr->IsAutoCorrFlag( ChgSglQuotes ) && ( '\'' == aCh))))
//STRIP001 			{
//STRIP001 				FlushInBuffer( &rSh );
//STRIP001 				rSh.AutoCorrect( *pACorr, aCh );
//STRIP001 				if( '\"' != aCh && '\'' != aCh )		// nur bei "*_" rufen!
//STRIP001 					rSh.UpdateAttr();
//STRIP001 			}
//STRIP001 			else if( !aKeyEvent.GetRepeat() && pACorr &&
//STRIP001 				pACorr->IsAutoCorrFlag( CptlSttSntnc | CptlSttWrd |
//STRIP001 										ChgFractionSymbol | ChgOrdinalNumber |
//STRIP001 										ChgToEnEmDash | SetINetAttr |
//STRIP001 										Autocorrect ) &&
//STRIP001 				'\"' != aCh && '\'' != aCh && '*' != aCh && '_' != aCh &&
//STRIP001 				!bIsNormalChar
//STRIP001 				)
//STRIP001 			{
//STRIP001 				FlushInBuffer( &rSh );
//STRIP001 				rSh.AutoCorrect( *pACorr, aCh );
//STRIP001 			}
//STRIP001 			else
//STRIP001 			{
//STRIP001 				aInBuffer.Expand( aInBuffer.Len() + aKeyEvent.GetRepeat() + 1,aCh );
//STRIP001 				bFlushCharBuffer = Application::AnyInput( INPUT_KEYBOARD );
//STRIP001 				bFlushBuffer = !bFlushCharBuffer;
//STRIP001 				if( bFlushCharBuffer )
//STRIP001 					aKeyInputFlushTimer.Start();
//STRIP001 			}
//STRIP001 			eKeyState = KS_Ende;
//STRIP001 		}
//STRIP001 		else
//STRIP001 		{
//STRIP001 			InfoBox( this, SW_RES( MSG_READONLY_CONTENT )).Execute();
//STRIP001 // ???			Window::KeyInput( aKeyEvent );
//STRIP001 			eKeyState = KS_Ende;
//STRIP001 		}
//STRIP001 		break;
//STRIP001 
//STRIP001 		case KS_CheckAutoCorrect:
//STRIP001 		{
//STRIP001 			if( pACorr &&
//STRIP001 				pACorr->IsAutoCorrFlag( CptlSttSntnc | CptlSttWrd |
//STRIP001 										ChgFractionSymbol | ChgOrdinalNumber |
//STRIP001 										ChgToEnEmDash | SetINetAttr |
//STRIP001 										Autocorrect ) &&
//STRIP001 				!rSh.HasReadonlySel() )
//STRIP001 			{
//STRIP001 				FlushInBuffer( &rSh );
//STRIP001 				rSh.AutoCorrect( *pACorr, 0 );
//STRIP001 			}
//STRIP001 			eKeyState = eNextKeyState;
//STRIP001 		}
//STRIP001 		break;
//STRIP001 
//STRIP001 		default:
//STRIP001 		{
//STRIP001             USHORT nSlotId = 0;
//STRIP001             FlushInBuffer( &rSh );
//STRIP001 //???			if( bFlushCharBuffer )
//STRIP001 //???				FlushInBuffer( &rSh );
//STRIP001 			switch( eKeyState )
//STRIP001 			{
//STRIP001 			case KS_SpecialInsert:
//STRIP001 				rSh.DoSpecialInsert();
//STRIP001 				break;
//STRIP001 
//STRIP001 			case KS_NoNum:
//STRIP001 				rSh.NoNum();
//STRIP001 				break;
//STRIP001 
//STRIP001 			case KS_NumOff:
//STRIP001 				// Shellwechsel - also vorher aufzeichnen
//STRIP001 				rSh.DelNumRules();
//STRIP001 				break;
//STRIP001 
//STRIP001 			case KS_NumDown:
//STRIP001 				rSh.NumUpDown( TRUE );
//STRIP001 				break;
//STRIP001 			case KS_NumUp:
//STRIP001 				rSh.NumUpDown( FALSE );
//STRIP001 				break;
//STRIP001 
//STRIP001 			case KS_OutlineDown:
//STRIP001 				rSh.OutlineUpDown( 1 );
//STRIP001 				break;
//STRIP001 			case KS_OutlineUp:
//STRIP001 				rSh.OutlineUpDown( -1 );
//STRIP001 				break;
//STRIP001 
//STRIP001 			case KS_NextCell:
//STRIP001 				//In Tabelle immer 'flushen'
//STRIP001 				rSh.GoNextCell();
//STRIP001                 nSlotId = FN_GOTO_NEXT_CELL;
//STRIP001                 break;
//STRIP001 			case KS_PrevCell:
//STRIP001 				rSh.GoPrevCell();
//STRIP001                 nSlotId = FN_GOTO_PREV_CELL;
//STRIP001                 break;
//STRIP001 			case KS_AutoFmtByInput:
//STRIP001 				rSh.SplitNode( TRUE );
//STRIP001 				break;
//STRIP001 
//STRIP001 //			case KS_NumOrNoNum:
//STRIP001 //			case KS_DontExpand:
//STRIP001 //				break;
//STRIP001             case KS_NextObject:
//STRIP001             case KS_PrevObject:
//STRIP001                 if(rSh.GotoObj( KS_NextObject == eKeyState, GOTO_ANY))
//STRIP001                 {
//STRIP001                     if( rSh.IsFrmSelected() &&
//STRIP001                         rView.GetDrawFuncPtr() )
//STRIP001                     {
//STRIP001                         rView.GetDrawFuncPtr()->Deactivate();
//STRIP001                         rView.SetDrawFuncPtr(NULL);
//STRIP001                         rView.LeaveDrawCreate();
//STRIP001                         rView.AttrChangedNotify( &rSh );
//STRIP001                     }
//STRIP001                     rSh.HideCrsr();
//STRIP001                     rSh.EnterSelFrmMode();
//STRIP001                 }
//STRIP001             break;
//STRIP001 			case KS_GlossaryExpand:
//STRIP001 			{
//STRIP001 				// ersetze das Wort oder Kuerzel durch den den Textbaustein
//STRIP001 				rSh.StartUndo( UNDO_START );
//STRIP001 
//STRIP001 				String sFnd( *aTmpQHD.aArr[ aTmpQHD.nCurArrPos ] );
//STRIP001 				if( aTmpQHD.bIsAutoText )
//STRIP001 				{
//STRIP001 					SwGlossaryList* pList = ::GetGlossaryList();
//STRIP001 					String sShrtNm;
//STRIP001 					String sGroup;
//STRIP001 					if(pList->GetShortName( sFnd, sShrtNm, sGroup))
//STRIP001 					{
//STRIP001 						rSh.SttSelect();
//STRIP001 						rSh.ExtendSelection( FALSE, aTmpQHD.nLen );
//STRIP001 						SwGlossaryHdl* pGlosHdl = GetView().GetGlosHdl();
//STRIP001 						pGlosHdl->SetCurGroup(sGroup, TRUE);
//STRIP001 						pGlosHdl->InsertGlossary( sShrtNm);
//STRIP001 						pQuickHlpData->bChkInsBlank = TRUE;
//STRIP001 					}
//STRIP001 				}
//STRIP001 				else
//STRIP001 				{
//STRIP001 					rSh.Insert( sFnd.Erase( 0, aTmpQHD.nLen ));
//STRIP001 					pQuickHlpData->bChkInsBlank = !pACorr ||
//STRIP001 							pACorr->GetSwFlags().bAutoCmpltAppendBlanc;
//STRIP001 				}
//STRIP001 				rSh.EndUndo( UNDO_END );
//STRIP001 			}
//STRIP001 			break;
//STRIP001 
//STRIP001 			case KS_NextPrevGlossary:
//STRIP001 				pQuickHlpData->Move( aTmpQHD );
//STRIP001 				pQuickHlpData->Start( rSh, USHRT_MAX );
//STRIP001 				break;
//STRIP001 
//STRIP001 			case KS_EditFormula:
//STRIP001 			{
//STRIP001 				const USHORT nId = SwInputChild::GetChildWindowId();
//STRIP001 
//STRIP001 				SfxViewFrame* pVFrame = GetView().GetViewFrame();
//STRIP001 				pVFrame->ToggleChildWindow( nId );
//STRIP001 				SwInputChild* pChildWin = (SwInputChild*)pVFrame->
//STRIP001 													GetChildWindow( nId );
//STRIP001 				if( pChildWin )
//STRIP001 					pChildWin->SetFormula( sFmlEntry );
//STRIP001 			}
//STRIP001 			break;
//STRIP001 
//STRIP001 			case KS_ColLeftBig:			rSh.SetColRowWidthHeight( WH_COL_LEFT|WH_FLAG_BIGGER, pModOpt->GetTblHMove() );	break;
//STRIP001 			case KS_ColRightBig:		rSh.SetColRowWidthHeight( WH_COL_RIGHT|WH_FLAG_BIGGER, pModOpt->GetTblHMove() );	break;
//STRIP001 			case KS_ColLeftSmall:		rSh.SetColRowWidthHeight( WH_COL_LEFT, pModOpt->GetTblHMove() );	break;
//STRIP001 			case KS_ColRightSmall:		rSh.SetColRowWidthHeight( WH_COL_RIGHT, pModOpt->GetTblHMove() );	break;
//STRIP001 			case KS_ColTopBig:			rSh.SetColRowWidthHeight( WH_ROW_TOP|WH_FLAG_BIGGER, pModOpt->GetTblVMove() );	break;
//STRIP001 			case KS_ColBottomBig:		rSh.SetColRowWidthHeight( WH_ROW_BOTTOM|WH_FLAG_BIGGER, pModOpt->GetTblVMove() );	break;
//STRIP001 			case KS_ColTopSmall:		rSh.SetColRowWidthHeight( WH_ROW_TOP, pModOpt->GetTblVMove() );	break;
//STRIP001 			case KS_ColBottomSmall:		rSh.SetColRowWidthHeight( WH_ROW_BOTTOM, pModOpt->GetTblVMove() );	break;
//STRIP001 			case KS_CellLeftBig:		rSh.SetColRowWidthHeight( WH_CELL_LEFT|WH_FLAG_BIGGER, pModOpt->GetTblHMove() );	break;
//STRIP001 			case KS_CellRightBig:		rSh.SetColRowWidthHeight( WH_CELL_RIGHT|WH_FLAG_BIGGER, pModOpt->GetTblHMove() );	break;
//STRIP001 			case KS_CellLeftSmall:		rSh.SetColRowWidthHeight( WH_CELL_LEFT, pModOpt->GetTblHMove() );	break;
//STRIP001 			case KS_CellRightSmall:		rSh.SetColRowWidthHeight( WH_CELL_RIGHT, pModOpt->GetTblHMove() );	break;
//STRIP001 			case KS_CellTopBig:			rSh.SetColRowWidthHeight( WH_CELL_TOP|WH_FLAG_BIGGER, pModOpt->GetTblVMove() );	break;
//STRIP001 			case KS_CellBottomBig:		rSh.SetColRowWidthHeight( WH_CELL_BOTTOM|WH_FLAG_BIGGER, pModOpt->GetTblVMove() );	break;
//STRIP001 			case KS_CellTopSmall:		rSh.SetColRowWidthHeight( WH_CELL_TOP, pModOpt->GetTblVMove() );	break;
//STRIP001 			case KS_CellBottomSmall:	rSh.SetColRowWidthHeight( WH_CELL_BOTTOM, pModOpt->GetTblVMove() );	break;
//STRIP001 
//STRIP001 //---------------
//STRIP001 			case KS_InsDel_ColLeftBig:			rSh.SetColRowWidthHeight( WH_FLAG_INSDEL|WH_COL_LEFT|WH_FLAG_BIGGER, pModOpt->GetTblHInsert() );	break;
//STRIP001 			case KS_InsDel_ColRightBig:			rSh.SetColRowWidthHeight( WH_FLAG_INSDEL|WH_COL_RIGHT|WH_FLAG_BIGGER, pModOpt->GetTblHInsert() );	break;
//STRIP001 			case KS_InsDel_ColLeftSmall:		rSh.SetColRowWidthHeight( WH_FLAG_INSDEL|WH_COL_LEFT, pModOpt->GetTblHInsert() );	break;
//STRIP001 			case KS_InsDel_ColRightSmall:		rSh.SetColRowWidthHeight( WH_FLAG_INSDEL|WH_COL_RIGHT, pModOpt->GetTblHInsert() );	break;
//STRIP001 			case KS_InsDel_ColTopBig:			rSh.SetColRowWidthHeight( WH_FLAG_INSDEL|WH_ROW_TOP|WH_FLAG_BIGGER, pModOpt->GetTblVInsert() );	break;
//STRIP001 			case KS_InsDel_ColBottomBig:		rSh.SetColRowWidthHeight( WH_FLAG_INSDEL|WH_ROW_BOTTOM|WH_FLAG_BIGGER, pModOpt->GetTblVInsert() );	break;
//STRIP001 			case KS_InsDel_ColTopSmall:			rSh.SetColRowWidthHeight( WH_FLAG_INSDEL|WH_ROW_TOP, pModOpt->GetTblVInsert() );	break;
//STRIP001 			case KS_InsDel_ColBottomSmall:		rSh.SetColRowWidthHeight( WH_FLAG_INSDEL|WH_ROW_BOTTOM, pModOpt->GetTblVInsert() );	break;
//STRIP001 			case KS_InsDel_CellLeftBig:			rSh.SetColRowWidthHeight( WH_FLAG_INSDEL|WH_CELL_LEFT|WH_FLAG_BIGGER, pModOpt->GetTblHInsert() );	break;
//STRIP001 			case KS_InsDel_CellRightBig:		rSh.SetColRowWidthHeight( WH_FLAG_INSDEL|WH_CELL_RIGHT|WH_FLAG_BIGGER, pModOpt->GetTblHInsert() );	break;
//STRIP001 			case KS_InsDel_CellLeftSmall:		rSh.SetColRowWidthHeight( WH_FLAG_INSDEL|WH_CELL_LEFT, pModOpt->GetTblHInsert() );	break;
//STRIP001 			case KS_InsDel_CellRightSmall:		rSh.SetColRowWidthHeight( WH_FLAG_INSDEL|WH_CELL_RIGHT, pModOpt->GetTblHInsert() );	break;
//STRIP001 			case KS_InsDel_CellTopBig:			rSh.SetColRowWidthHeight( WH_FLAG_INSDEL|WH_CELL_TOP|WH_FLAG_BIGGER, pModOpt->GetTblVInsert() );	break;
//STRIP001 			case KS_InsDel_CellBottomBig:		rSh.SetColRowWidthHeight( WH_FLAG_INSDEL|WH_CELL_BOTTOM|WH_FLAG_BIGGER, pModOpt->GetTblVInsert() );	break;
//STRIP001 			case KS_InsDel_CellTopSmall:		rSh.SetColRowWidthHeight( WH_FLAG_INSDEL|WH_CELL_TOP, pModOpt->GetTblVInsert() );	break;
//STRIP001 			case KS_InsDel_CellBottomSmall:		rSh.SetColRowWidthHeight( WH_FLAG_INSDEL|WH_CELL_BOTTOM, pModOpt->GetTblVInsert() );	break;
//STRIP001 //---------------
//STRIP001 			case KS_TblColCellInsDel:
//STRIP001 				rSh.SetColRowWidthHeight( eTblChgMode, nTblChgSize );
//STRIP001 				break;
//STRIP001 			case KS_Fly_Change:
//STRIP001             {
//STRIP001                 SdrView *pSdrView = rSh.GetDrawView();
//STRIP001                 const SdrHdlList& rHdlList = pSdrView->GetHdlList();
//STRIP001                 if(rHdlList.GetFocusHdl())
//STRIP001                     ChangeDrawing( nDir );
//STRIP001                 else
//STRIP001                     ChangeFly( nDir, rView.ISA( SwWebView ) );
//STRIP001             }
//STRIP001             break;
//STRIP001             case KS_Draw_Change :
//STRIP001                 ChangeDrawing( nDir );
//STRIP001                 break;
//STRIP001             }
//STRIP001             if( nSlotId && rView.GetViewFrame()->GetBindings().GetRecorder().is() )
//STRIP001             {
//STRIP001                 SfxRequest aReq(rView.GetViewFrame(), nSlotId );
//STRIP001                 aReq.Done();
//STRIP001             }
//STRIP001             eKeyState = KS_Ende;
//STRIP001 		}
//STRIP001         }
//STRIP001 	}
//STRIP001 
//STRIP001 	if( bStopKeyInputTimer )
//STRIP001 	{
//STRIP001 		aKeyInputTimer.Stop();
//STRIP001 		bTblInsDelMode = FALSE;
//STRIP001 	}
//STRIP001 
//STRIP001 	// falls die gepufferten Zeichen eingefuegt werden sollen
//STRIP001 	if( bFlushBuffer && aInBuffer.Len() )
//STRIP001 	{
//STRIP001 		//OS 16.02.96 11.04: bFlushCharBuffer wurde hier nicht zurueckgesetzt
//STRIP001 		// warum nicht?
//STRIP001 		BOOL bSave = bFlushCharBuffer;
//STRIP001 		FlushInBuffer(&rSh);
//STRIP001 		bFlushCharBuffer = bSave;
//STRIP001 
//STRIP001 		// evt. Tip-Hilfe anzeigen
//STRIP001 		String sWord;
//STRIP001         if( bNormalChar && pACfg && pACorr &&
//STRIP001 			( pACfg->IsAutoTextTip() ||
//STRIP001 			  pACorr->GetSwFlags().bAutoCompleteWords ) &&
//STRIP001 			rSh.GetPrevAutoCorrWord( *pACorr, sWord ) )
//STRIP001 		{
//STRIP001             ShowAutoTextCorrectQuickHelp(sWord, pACfg, pACorr);
//STRIP001         }
//STRIP001 	}
//STRIP001 }

/*--------------------------------------------------------------------
	 Beschreibung:	MouseEvents
 --------------------------------------------------------------------*/


//STRIP001 void SwEditWin::RstMBDownFlags()
//STRIP001 {
//STRIP001 	//Nicht auf allen Systemen kommt vor dem modalen
//STRIP001 	//Dialog noch ein MouseButton Up (wie unter WINDOWS).
//STRIP001 	//Daher hier die Stati zuruecksetzen und die Maus
//STRIP001 	//fuer den Dialog freigeben.
//STRIP001 	bMBPressed = bNoInterrupt = FALSE;
//STRIP001 	EnterArea();
//STRIP001 	ReleaseMouse();
//STRIP001 }





//STRIP001 void SwEditWin::MouseButtonDown(const MouseEvent& rMEvt)
//STRIP001 {
//STRIP001 	GrabFocus();
//STRIP001 
//STRIP001 	bWasShdwCrsr = 0 != pShadCrsr;
//STRIP001 	if( bWasShdwCrsr )
//STRIP001 		delete pShadCrsr, pShadCrsr = 0;
//STRIP001 
//STRIP001 	SwWrtShell &rSh = rView.GetWrtShell();
//STRIP001 	const Point aDocPos( PixelToLogic( rMEvt.GetPosPixel() ) );
//STRIP001 
//STRIP001 	if ( IsChainMode() )
//STRIP001 	{
//STRIP001 		SetChainMode( FALSE );
//STRIP001 		SwRect aDummy;
//STRIP001 		SwFlyFrmFmt *pFmt = (SwFlyFrmFmt*)rSh.GetFlyFrmFmt();
//STRIP001 		if ( !rSh.Chainable( aDummy, *pFmt, aDocPos ) )
//STRIP001 			rSh.Chain( *pFmt, aDocPos );
//STRIP001 		UpdatePointer( aDocPos, rMEvt.GetModifier() );
//STRIP001 		return;
//STRIP001 	}
//STRIP001 
//STRIP001 	//Nach GrabFocus sollte eine Shell gepusht sein. Das muss eigentlich
//STRIP001 	//klappen aber in der Praxis ...
//STRIP001 	lcl_SelectShellForDrop( rView );
//STRIP001 
//STRIP001 	BOOL bIsDocReadOnly = rView.GetDocShell()->IsReadOnly();
//STRIP001 	BOOL bCallBase = TRUE;
//STRIP001 
//STRIP001 	if( pQuickHlpData->bClear )
//STRIP001 		pQuickHlpData->Stop( rSh );
//STRIP001 	pQuickHlpData->bChkInsBlank = FALSE;
//STRIP001 
//STRIP001 	if( rSh.FinishOLEObj() )
//STRIP001 		return;	//InPlace beenden und der Klick zaehlt nicht mehr
//STRIP001 
//STRIP001 	SET_CURR_SHELL( &rSh );
//STRIP001 
//STRIP001 	SdrView *pSdrView = rSh.GetDrawView();
//STRIP001 	if ( pSdrView )
//STRIP001 	{
//STRIP001 		if (pSdrView->MouseButtonDown( rMEvt, this ) )
//STRIP001 		{
//STRIP001 			rSh.GetView().GetViewFrame()->GetBindings().InvalidateAll(FALSE);
//STRIP001 			return; // Event von der SdrView ausgewertet
//STRIP001 		}
//STRIP001 	}
//STRIP001 
//STRIP001 #ifdef MAC
//STRIP001 	if (rMEvt.IsMod1() && rMEvt.IsMod2())
//STRIP001 		return;
//STRIP001 #endif
//STRIP001 
//STRIP001 	bIsInMove = FALSE;
//STRIP001 	aStartPos = rMEvt.GetPosPixel();
//STRIP001 	aRszMvHdlPt.X() = 0, aRszMvHdlPt.Y() = 0;
//STRIP001 
//STRIP001     BYTE nMouseTabCol = 0;
//STRIP001     if ( !rSh.IsDrawCreate() && !pApplyTempl && !rSh.IsInSelect() &&
//STRIP001 		 rMEvt.GetClicks() == 1 && MOUSE_LEFT == rMEvt.GetButtons() &&
//STRIP001 		 !rSh.IsTableMode() &&
//STRIP001          0 != (nMouseTabCol = rSh.WhichMouseTabCol( aDocPos ) ))
//STRIP001     {
//STRIP001 		//Zuppeln von Tabellenspalten aus dem Dokument heraus.
//STRIP001 		rView.SetTabColFromDoc( TRUE );
//STRIP001 		rView.SetTabColFromDocPos( aDocPos );
//STRIP001 		rView.InvalidateRulerPos();
//STRIP001 		SfxBindings& rBind = rView.GetViewFrame()->GetBindings();
//STRIP001 		rBind.Update();
//STRIP001         if ( RulerColumnDrag( rView , rMEvt, SW_TABCOL_VERT == nMouseTabCol ) )
//STRIP001 		{
//STRIP001 			rView.SetTabColFromDoc( FALSE );
//STRIP001 			rView.InvalidateRulerPos();
//STRIP001 			rBind.Update();
//STRIP001 			bCallBase = FALSE;
//STRIP001 		}
//STRIP001 		else
//STRIP001 		{
//STRIP001 			return;
//STRIP001 		}
//STRIP001 	}
//STRIP001 
//STRIP001 	//Man kann sich in einem Selektionszustand befinden, wenn zuletzt
//STRIP001 	//mit dem Keyboard selektiert wurde, aber noch kein CURSOR_KEY
//STRIP001 	//anschliessend bewegt worden ist. In diesem Fall muss die vorher-
//STRIP001 	//gehende Selektion zuerst beendet werden.
//STRIP001 	//MA 07. Oct. 95: Und zwar nicht nur bei Linker Maustaste sondern immer.
//STRIP001 	//siehe auch Bug: 19263
//STRIP001 	if ( rSh.IsInSelect() )
//STRIP001 		rSh.EndSelect();
//STRIP001 
//STRIP001 	//Abfrage auf LEFT, da sonst auch bei einem Click mit der rechten Taste
//STRIP001 	//beispielsweise die Selektion aufgehoben wird.
//STRIP001 	if ( MOUSE_LEFT == rMEvt.GetButtons() )
//STRIP001 	{
//STRIP001 		BOOL bOnlyText = FALSE;
//STRIP001 		bMBPressed = bNoInterrupt = TRUE;
//STRIP001 		CaptureMouse();
//STRIP001 
//STRIP001 		//ggf. Cursorpositionen zuruecksetzen
//STRIP001 		rSh.ResetCursorStack();
//STRIP001 
//STRIP001 		switch ( rMEvt.GetModifier() + rMEvt.GetButtons() )
//STRIP001 		{
//STRIP001 			case MOUSE_LEFT:
//STRIP001 			case MOUSE_LEFT + KEY_SHIFT:
//STRIP001 			case MOUSE_LEFT + KEY_MOD2:
//STRIP001 				if( rSh.IsObjSelected() )
//STRIP001 				{
//STRIP001 					SdrHdl* pHdl;
//STRIP001                     if( !bIsDocReadOnly &&
//STRIP001                         !pAnchorMarker &&
//STRIP001                         0 != ( pHdl = pSdrView->HitHandle(aDocPos, *(rSh.GetOut())) ) &&
//STRIP001                             ( pHdl->GetKind() == HDL_ANCHOR ||
//STRIP001                               pHdl->GetKind() == HDL_ANCHOR_TR ) )
//STRIP001 					{
//STRIP001 						pAnchorMarker = new SwAnchorMarker( pHdl );
//STRIP001 						UpdatePointer( aDocPos, rMEvt.GetModifier() );
//STRIP001 						return;
//STRIP001 					}
//STRIP001 				}
//STRIP001 				if ( EnterDrawMode( rMEvt, aDocPos ) )
//STRIP001 				{
//STRIP001 					bNoInterrupt = FALSE;
//STRIP001 					return;
//STRIP001 				}
//STRIP001 				else  if ( rView.GetDrawFuncPtr() && bInsFrm )
//STRIP001 				{
//STRIP001 					StopInsFrm();
//STRIP001 					rSh.Edit();
//STRIP001 				}
//STRIP001 
//STRIP001 				// Ohne SHIFT, da sonst Toggle bei Selektion nicht funktioniert
//STRIP001 				if (rMEvt.GetClicks() == 1)
//STRIP001 				{
//STRIP001 					if ( rSh.IsSelFrmMode())
//STRIP001 					{
//STRIP001 						SdrHdl* pHdl = rSh.GetDrawView()->HitHandle
//STRIP001 													(aDocPos, *(rSh.GetOut()));
//STRIP001 						BOOL bHitHandle = pHdl && pHdl->GetKind() != HDL_ANCHOR &&
//STRIP001 												  pHdl->GetKind() != HDL_ANCHOR_TR;
//STRIP001 
//STRIP001 						if ((rSh.IsInsideSelectedObj(aDocPos) || bHitHandle) &&
//STRIP001 							!(rMEvt.GetModifier() == KEY_SHIFT && !bHitHandle))
//STRIP001 						{
//STRIP001 							rSh.EnterSelFrmMode( &aDocPos );
//STRIP001 							if ( !pApplyTempl )
//STRIP001 							{
//STRIP001 								//nur, wenn keine Position zum Sizen getroffen ist.
//STRIP001 								if (!bHitHandle)
//STRIP001 								{
//STRIP001 									StartDDTimer();
//STRIP001 									SwEditWin::nDDStartPosY = aDocPos.Y();
//STRIP001 									SwEditWin::nDDStartPosX = aDocPos.X();
//STRIP001 								}
//STRIP001 								bFrmDrag = TRUE;
//STRIP001 							}
//STRIP001 							bNoInterrupt = FALSE;
//STRIP001 							return;
//STRIP001 						}
//STRIP001 					}
//STRIP001 				}
//STRIP001 		}
//STRIP001 
//STRIP001 		BOOL bExecHyperlinks = rSh.GetViewOptions()->IsExecHyperlinks()^
//STRIP001 							(rMEvt.GetModifier() == KEY_MOD2 ? TRUE : FALSE);
//STRIP001 
//STRIP001 		switch ( rMEvt.GetModifier() + rMEvt.GetButtons() )
//STRIP001 		{
//STRIP001 			case MOUSE_LEFT:
//STRIP001 			case MOUSE_LEFT + KEY_MOD1:
//STRIP001 			case MOUSE_LEFT + KEY_MOD2:
//STRIP001 				switch ( rMEvt.GetClicks() )
//STRIP001 				{
//STRIP001 					case 1:
//STRIP001 					{
//STRIP001 						UpdatePointer( aDocPos, rMEvt.GetModifier() );
//STRIP001 						SwEditWin::nDDStartPosY = aDocPos.Y();
//STRIP001 						SwEditWin::nDDStartPosX = aDocPos.X();
//STRIP001 
//STRIP001 						// URL in DrawText-Objekt getroffen?
//STRIP001 						BOOL bExecDrawTextLink = FALSE;
//STRIP001 
//STRIP001 						if (bExecHyperlinks && pSdrView)
//STRIP001 						{
//STRIP001 							SdrViewEvent aVEvt;
//STRIP001 							SdrHitKind eHit = pSdrView->PickAnything(rMEvt, SDRMOUSEBUTTONDOWN, aVEvt);
//STRIP001 
//STRIP001 							if (aVEvt.eEvent == SDREVENT_EXECUTEURL)
//STRIP001 								bExecDrawTextLink = TRUE;
//STRIP001 						}
//STRIP001 
//STRIP001 						//Rahmen nur zu selektieren versuchen, wenn
//STRIP001 						//der Pointer bereits entsprechend geschaltet wurde
//STRIP001 						if ( aActHitType != SDRHIT_NONE && !rSh.IsSelFrmMode() &&
//STRIP001 							!SFX_APP()->IsDispatcherLocked() &&
//STRIP001 							!bExecDrawTextLink)
//STRIP001 						{
//STRIP001 							// #107513#
//STRIP001 							// Test if there is a draw object at that position and if it should be selected.
//STRIP001 							sal_Bool bShould = rSh.ShouldObjectBeSelected(aDocPos);
//STRIP001 							
//STRIP001 							if(bShould)
//STRIP001 							{
//STRIP001 								rView.NoRotate();
//STRIP001 								rSh.HideCrsr();
//STRIP001 
//STRIP001 								BOOL bUnLockView = !rSh.IsViewLocked();
//STRIP001 								rSh.LockView( TRUE );
//STRIP001 								BOOL bSelObj = rSh.SelectObj( aDocPos,
//STRIP001 											   rMEvt.IsMod1() ? SW_ENTER_GROUP : 0);
//STRIP001 								if( bUnLockView )
//STRIP001 									rSh.LockView( FALSE );
//STRIP001 
//STRIP001 								if( bSelObj )
//STRIP001 								{
//STRIP001 									// falls im Macro der Rahmen deselektiert
//STRIP001 									// wurde, muss nur noch der Cursor
//STRIP001 									// wieder angezeigt werden.
//STRIP001 									if( FRMTYPE_NONE == rSh.GetSelFrmType() )
//STRIP001 										rSh.ShowCrsr();
//STRIP001 									else
//STRIP001 									{
//STRIP001 										if (rSh.IsFrmSelected() && rView.GetDrawFuncPtr())
//STRIP001 										{
//STRIP001 											rView.GetDrawFuncPtr()->Deactivate();
//STRIP001 											rView.SetDrawFuncPtr(NULL);
//STRIP001 											rView.LeaveDrawCreate();
//STRIP001 											rView.AttrChangedNotify( &rSh );
//STRIP001 										}
//STRIP001 
//STRIP001 										rSh.EnterSelFrmMode( &aDocPos );
//STRIP001 										bFrmDrag = TRUE;
//STRIP001 										UpdatePointer( aDocPos, rMEvt.GetModifier() );
//STRIP001 									}
//STRIP001 									return;
//STRIP001 								}
//STRIP001 								else
//STRIP001 									bOnlyText = rSh.IsObjSelectable( aDocPos );
//STRIP001 
//STRIP001 								if (!rView.GetDrawFuncPtr())
//STRIP001 									rSh.ShowCrsr();
//STRIP001 							}
//STRIP001 						}
//STRIP001 						else if ( rSh.IsSelFrmMode() &&
//STRIP001 								  (aActHitType == SDRHIT_NONE ||
//STRIP001 								   !rSh.IsInsideSelectedObj( aDocPos )))
//STRIP001 						{
//STRIP001 							rView.NoRotate();
//STRIP001 							SdrHdl *pHdl;
//STRIP001 							if( !bIsDocReadOnly && !pAnchorMarker && 0 !=
//STRIP001 								( pHdl = pSdrView->HitHandle(aDocPos, *(rSh.GetOut())) ) &&
//STRIP001 									( pHdl->GetKind() == HDL_ANCHOR ||
//STRIP001 									  pHdl->GetKind() == HDL_ANCHOR_TR ) )
//STRIP001 							{
//STRIP001 								pAnchorMarker = new SwAnchorMarker( pHdl );
//STRIP001 								UpdatePointer( aDocPos, rMEvt.GetModifier() );
//STRIP001 								return;
//STRIP001 							}
//STRIP001 							else
//STRIP001 							{
//STRIP001 								BOOL bUnLockView = !rSh.IsViewLocked();
//STRIP001 								rSh.LockView( TRUE );
//STRIP001                                 BYTE nFlag = rMEvt.IsShift() ? SW_ADD_SELECT :0;
//STRIP001                                 if( rMEvt.IsMod1() )
//STRIP001                                     nFlag = nFlag | SW_ENTER_GROUP;
//STRIP001 
//STRIP001 								if ( rSh.IsSelFrmMode() )
//STRIP001 								{
//STRIP001 									rSh.UnSelectFrm();
//STRIP001 									rSh.LeaveSelFrmMode();
//STRIP001 									rView.AttrChangedNotify(&rSh);
//STRIP001 								}                                
//STRIP001 								
//STRIP001 								BOOL bSelObj = rSh.SelectObj( aDocPos, nFlag );
//STRIP001 								if( bUnLockView )
//STRIP001 									rSh.LockView( FALSE );
//STRIP001 
//STRIP001 								if( !bSelObj )
//STRIP001 								{
//STRIP001 									// Cursor hier umsetzen, damit er nicht zuerst
//STRIP001 									// im Rahmen gezeichnet wird; ShowCrsr() geschieht
//STRIP001 									// in LeaveSelFrmMode()
//STRIP001 									bValidCrsrPos = !(CRSR_POSCHG & (rSh.*rSh.fnSetCrsr)(&aDocPos,FALSE));
//STRIP001 									rSh.LeaveSelFrmMode();
//STRIP001 									rView.AttrChangedNotify( &rSh );
//STRIP001 									bCallBase = FALSE;
//STRIP001 								}
//STRIP001 								else
//STRIP001 								{
//STRIP001 									rSh.HideCrsr();
//STRIP001 									rSh.EnterSelFrmMode( &aDocPos );
//STRIP001 									rSh.SelFlyGrabCrsr();
//STRIP001 									rSh.MakeSelVisible();
//STRIP001 									bFrmDrag = TRUE;
//STRIP001 									if( rSh.IsFrmSelected() &&
//STRIP001 										rView.GetDrawFuncPtr() )
//STRIP001 									{
//STRIP001 										rView.GetDrawFuncPtr()->Deactivate();
//STRIP001 										rView.SetDrawFuncPtr(NULL);
//STRIP001 										rView.LeaveDrawCreate();
//STRIP001 										rView.AttrChangedNotify( &rSh );
//STRIP001 									}
//STRIP001 									UpdatePointer( aDocPos, rMEvt.GetModifier() );
//STRIP001 									return;
//STRIP001 								}
//STRIP001 							}
//STRIP001 						}
//STRIP001 						break;
//STRIP001 					}
//STRIP001 					case 2:
//STRIP001 					{
//STRIP001 						bFrmDrag = FALSE;
//STRIP001 						if ( !bIsDocReadOnly && rSh.IsInsideSelectedObj(aDocPos) &&
//STRIP001 							 0 == rSh.IsSelObjProtected( (FlyProtectType)(FLYPROTECT_CONTENT|FLYPROTECT_PARENT) ) )
//STRIP001 						switch ( rSh.GetSelectionType() )
//STRIP001 						{
//STRIP001 							case SwWrtShell::SEL_GRF:
//STRIP001 								RstMBDownFlags();
//STRIP001                                 GetView().GetViewFrame()->GetBindings().Execute(
//STRIP001                                     FN_FORMAT_GRAFIC_DLG, 0, 0, 
//STRIP001                                     SFX_CALLMODE_RECORD|SFX_CALLMODE_SLOT);
//STRIP001 								return;
//STRIP001 
//STRIP001 								// Doppelklick auf OLE-Objekt --> OLE-InPlace
//STRIP001 							case SwWrtShell::SEL_OLE:
//STRIP001 								if (!rSh.IsSelObjProtected(FLYPROTECT_CONTENT))
//STRIP001 								{
//STRIP001 									RstMBDownFlags();
//STRIP001 									rSh.LaunchOLEObj();
//STRIP001 								}
//STRIP001 								return;
//STRIP001 
//STRIP001 							case SwWrtShell::SEL_FRM:
//STRIP001 								RstMBDownFlags();
//STRIP001                                 GetView().GetViewFrame()->GetBindings().Execute(
//STRIP001                                     FN_FORMAT_FRAME_DLG, 0, 0, SFX_CALLMODE_RECORD|SFX_CALLMODE_SLOT);
//STRIP001 								return;
//STRIP001 
//STRIP001 							case SwWrtShell::SEL_DRW:
//STRIP001 								RstMBDownFlags();
//STRIP001 								EnterDrawTextMode(aDocPos);
//STRIP001 								if ( rView.GetCurShell()->ISA(SwDrawTextShell) )
//STRIP001 									((SwDrawTextShell*)rView.GetCurShell())->Init();
//STRIP001 								return;
//STRIP001 						}
//STRIP001 
//STRIP001 						//falls die Cursorposition korrigiert wurde oder
//STRIP001 						// ein Fly im ReadOnlyModus selektiert ist,
//STRIP001 						//keine Wortselektion.
//STRIP001 						if ( !bValidCrsrPos ||
//STRIP001 							(rSh.IsFrmSelected() && rSh.IsFrmSelected() ))
//STRIP001 							return;
//STRIP001 
//STRIP001 						SwField *pFld;
//STRIP001 						BOOL bFtn = FALSE;
//STRIP001 
//STRIP001 						if( !bIsDocReadOnly &&
//STRIP001 							( 0 != ( pFld = rSh.GetCurFld() ) ||
//STRIP001 							  0 != ( bFtn = rSh.GetCurFtn() )) )
//STRIP001 						{
//STRIP001 							RstMBDownFlags();
//STRIP001 							if( bFtn )
//STRIP001                                 GetView().GetViewFrame()->GetBindings().Execute( FN_EDIT_FOOTNOTE );
//STRIP001 							else
//STRIP001 							{
//STRIP001 								USHORT nTypeId = pFld->GetTypeId();
//STRIP001 								SfxViewFrame* pVFrame = GetView().GetViewFrame();
//STRIP001 								switch( nTypeId )
//STRIP001 								{
//STRIP001 								case TYP_POSTITFLD:
//STRIP001 								case TYP_SCRIPTFLD:
//STRIP001 								{
//STRIP001 									//falls es ein Readonly-Bereich ist, dann muss der Status
//STRIP001 									//enabled werden
//STRIP001 									USHORT nSlot = TYP_POSTITFLD == nTypeId ? FN_POSTIT : FN_JAVAEDIT;
//STRIP001 									SfxBoolItem aItem(nSlot, TRUE);
//STRIP001 									pVFrame->GetBindings().SetState(aItem);
//STRIP001                                     pVFrame->GetBindings().Execute(nSlot);
//STRIP001 									break;
//STRIP001 								}
//STRIP001 								case TYP_AUTHORITY :
//STRIP001                                     pVFrame->GetBindings().Execute(FN_EDIT_AUTH_ENTRY_DLG);
//STRIP001 								break;
//STRIP001 								default:
//STRIP001 									pVFrame->GetBindings().Execute(FN_EDIT_FIELD);
//STRIP001 								}
//STRIP001 							}
//STRIP001 							return;
//STRIP001 						}
//STRIP001 						//im Extended Mode hat Doppel- und
//STRIP001 						//Dreifachklick keine Auswirkungen.
//STRIP001 						if ( rSh.IsExtMode() )
//STRIP001 							return;
//STRIP001 
//STRIP001 						//Wort selektieren, gfs. Additional Mode
//STRIP001 						if ( KEY_MOD1 == rMEvt.GetModifier() && !rSh.IsAddMode() )
//STRIP001 						{
//STRIP001 							rSh.EnterAddMode();
//STRIP001 							rSh.SelWrd( &aDocPos );
//STRIP001 							rSh.LeaveAddMode();
//STRIP001 						}
//STRIP001 						else
//STRIP001 							rSh.SelWrd( &aDocPos );
//STRIP001 						bHoldSelection = TRUE;
//STRIP001 						return;
//STRIP001 					}
//STRIP001 					case 3:
//STRIP001 						bFrmDrag = FALSE;
//STRIP001 						//im Extended Mode hat Doppel- und
//STRIP001 						//Dreifachklick keine Auswirkungen.
//STRIP001 						if ( rSh.IsExtMode() )
//STRIP001 							return;
//STRIP001 
//STRIP001 						//falls die Cursorposition korrigiert wurde oder
//STRIP001 						// ein Fly im ReadOnlyModus selektiert ist,
//STRIP001 						//keine Wortselektion.
//STRIP001 						if ( !bValidCrsrPos || rSh.IsFrmSelected() )
//STRIP001 							return;
//STRIP001 
//STRIP001 						//Zeile selektieren, gfs. Additional Mode
//STRIP001 						if ( KEY_MOD1 == rMEvt.GetModifier() && !rSh.IsAddMode())
//STRIP001 						{
//STRIP001 							rSh.EnterAddMode();
//STRIP001 							rSh.SelLine( &aDocPos );
//STRIP001 							rSh.LeaveAddMode();
//STRIP001 						}
//STRIP001 						else
//STRIP001 							rSh.SelLine( &aDocPos );
//STRIP001 						bHoldSelection = TRUE;
//STRIP001 						return;
//STRIP001 
//STRIP001 					default:
//STRIP001 						return;
//STRIP001 				}
//STRIP001 				/* no break */
//STRIP001 			case MOUSE_LEFT + KEY_SHIFT:
//STRIP001 			case MOUSE_LEFT + KEY_SHIFT + KEY_MOD1:
//STRIP001 			{
//STRIP001 				BOOL bLockView = bWasShdwCrsr;
//STRIP001 
//STRIP001 				switch ( rMEvt.GetModifier() )
//STRIP001 				{
//STRIP001 					case KEY_MOD1 + KEY_SHIFT:
//STRIP001 					{
//STRIP001 						if ( !bInsDraw && IsDrawObjSelectable( rSh, aDocPos ) )
//STRIP001 						{
//STRIP001 							rView.NoRotate();
//STRIP001 							rSh.HideCrsr();
//STRIP001 							if ( rSh.IsSelFrmMode() )
//STRIP001                                 rSh.SelectObj(aDocPos, SW_ADD_SELECT | SW_ENTER_GROUP);
//STRIP001 							else
//STRIP001                             {   if ( rSh.SelectObj( aDocPos, SW_ADD_SELECT | SW_ENTER_GROUP ) )
//STRIP001 								{
//STRIP001 									rSh.EnterSelFrmMode( &aDocPos );
//STRIP001 									SwEditWin::nDDStartPosY = aDocPos.Y();
//STRIP001 									SwEditWin::nDDStartPosX = aDocPos.X();
//STRIP001 									bFrmDrag = TRUE;
//STRIP001 									return;
//STRIP001 								}
//STRIP001 							}
//STRIP001 						}
//STRIP001 						else if( rSh.IsSelFrmMode() &&
//STRIP001 								 rSh.GetDrawView()->HitHandle( aDocPos,
//STRIP001 															*rSh.GetOut() ))
//STRIP001 						{
//STRIP001 							bFrmDrag = TRUE;
//STRIP001 							bNoInterrupt = FALSE;
//STRIP001 							return;
//STRIP001 						}
//STRIP001 					}
//STRIP001 					break;
//STRIP001 					case KEY_MOD1:
//STRIP001 					{
//STRIP001 						if ( !bInsDraw && IsDrawObjSelectable( rSh, aDocPos ) )
//STRIP001 						{
//STRIP001 							rView.NoRotate();
//STRIP001 							rSh.HideCrsr();
//STRIP001 							if ( rSh.IsSelFrmMode() )
//STRIP001                                 rSh.SelectObj(aDocPos, SW_ENTER_GROUP);
//STRIP001 							else
//STRIP001                             {   if ( rSh.SelectObj( aDocPos, SW_ENTER_GROUP ) )
//STRIP001 								{
//STRIP001 									rSh.EnterSelFrmMode( &aDocPos );
//STRIP001 									SwEditWin::nDDStartPosY = aDocPos.Y();
//STRIP001 									SwEditWin::nDDStartPosX = aDocPos.X();
//STRIP001 									bFrmDrag = TRUE;
//STRIP001 									return;
//STRIP001 								}
//STRIP001 							}
//STRIP001 						}
//STRIP001 						else if( rSh.IsSelFrmMode() &&
//STRIP001 								 rSh.GetDrawView()->HitHandle( aDocPos,
//STRIP001 															*rSh.GetOut() ))
//STRIP001 						{
//STRIP001 							bFrmDrag = TRUE;
//STRIP001 							bNoInterrupt = FALSE;
//STRIP001 							return;
//STRIP001 						}
//STRIP001 						else
//STRIP001 						{
//STRIP001 							if ( !rSh.IsAddMode() && !rSh.IsExtMode())
//STRIP001 							{
//STRIP001 								rSh.PushMode();
//STRIP001 								bModePushed = TRUE;
//STRIP001 
//STRIP001 								BOOL bUnLockView = !rSh.IsViewLocked();
//STRIP001 								rSh.LockView( TRUE );
//STRIP001 								rSh.EnterAddMode();
//STRIP001 								if( bUnLockView )
//STRIP001 									rSh.LockView( FALSE );
//STRIP001 							}
//STRIP001 							bCallBase = FALSE;
//STRIP001 						}
//STRIP001 					}
//STRIP001 					break;
//STRIP001 					case KEY_SHIFT:
//STRIP001 					{
//STRIP001 						if ( !bInsDraw && IsDrawObjSelectable( rSh, aDocPos ) )
//STRIP001 						{
//STRIP001 							rView.NoRotate();
//STRIP001 							rSh.HideCrsr();
//STRIP001 							if ( rSh.IsSelFrmMode() )
//STRIP001 							{
//STRIP001                                 rSh.SelectObj(aDocPos, SW_ADD_SELECT);
//STRIP001 
//STRIP001 								const SdrMarkList& rMarkList = pSdrView->GetMarkList();
//STRIP001 								if (rMarkList.GetMark(0) == NULL)
//STRIP001 								{
//STRIP001 									rSh.LeaveSelFrmMode();
//STRIP001 									rView.AttrChangedNotify(&rSh);
//STRIP001 									bFrmDrag = FALSE;
//STRIP001 								}
//STRIP001 							}
//STRIP001 							else
//STRIP001 							{	if ( rSh.SelectObj( aDocPos ) )
//STRIP001 								{
//STRIP001 									rSh.EnterSelFrmMode( &aDocPos );
//STRIP001 									SwEditWin::nDDStartPosY = aDocPos.Y();
//STRIP001 									SwEditWin::nDDStartPosX = aDocPos.X();
//STRIP001 									bFrmDrag = TRUE;
//STRIP001 									return;
//STRIP001 								}
//STRIP001 							}
//STRIP001 						}
//STRIP001 						else
//STRIP001 						{
//STRIP001 							if ( rSh.IsSelFrmMode() &&
//STRIP001 								 rSh.IsInsideSelectedObj( aDocPos ) )
//STRIP001 							{
//STRIP001 								rSh.EnterSelFrmMode( &aDocPos );
//STRIP001 								SwEditWin::nDDStartPosY = aDocPos.Y();
//STRIP001 								SwEditWin::nDDStartPosX = aDocPos.X();
//STRIP001 								bFrmDrag = TRUE;
//STRIP001 								return;
//STRIP001 							}
//STRIP001 							if ( rSh.IsSelFrmMode() )
//STRIP001 							{
//STRIP001 								rSh.UnSelectFrm();
//STRIP001 								rSh.LeaveSelFrmMode();
//STRIP001 								rView.AttrChangedNotify(&rSh);
//STRIP001 								bFrmDrag = FALSE;
//STRIP001 							}
//STRIP001 							if ( !rSh.IsExtMode() )
//STRIP001 							{
//STRIP001 								// keine Selection anfangen, wenn in ein URL-
//STRIP001 								// Feld oder eine -Grafik geklickt wird
//STRIP001 								BOOL bSttSelect = rSh.HasSelection() ||
//STRIP001 												Pointer(POINTER_REFHAND) != GetPointer();
//STRIP001 
//STRIP001 								if( !bSttSelect )
//STRIP001 								{
//STRIP001 									bSttSelect = TRUE;
//STRIP001 									if( bExecHyperlinks )
//STRIP001 									{
//STRIP001 										SwContentAtPos aCntntAtPos(
//STRIP001 											SwContentAtPos::SW_FTN |
//STRIP001 											SwContentAtPos::SW_INETATTR );
//STRIP001 
//STRIP001 										if( rSh.GetContentAtPos( aDocPos, aCntntAtPos ) )
//STRIP001 										{
//STRIP001 											if( !rSh.IsViewLocked() &&
//STRIP001 												!rSh.IsReadOnlyAvailable() &&
//STRIP001 												aCntntAtPos.IsInProtectSect() )
//STRIP001 													bLockView = TRUE;
//STRIP001 
//STRIP001 											bSttSelect = FALSE;
//STRIP001 										}
//STRIP001 										else if( rSh.IsURLGrfAtPos( aDocPos ))
//STRIP001 											bSttSelect = FALSE;
//STRIP001 									}
//STRIP001 								}
//STRIP001 
//STRIP001 								if( bSttSelect )
//STRIP001 									rSh.SttSelect();
//STRIP001 							}
//STRIP001 						}
//STRIP001 						bCallBase = FALSE;
//STRIP001 						break;
//STRIP001 					}
//STRIP001 					default:
//STRIP001 						if( !rSh.IsViewLocked() )
//STRIP001 						{
//STRIP001 							SwContentAtPos aCntntAtPos( SwContentAtPos::SW_CLICKFIELD |
//STRIP001 														SwContentAtPos::SW_INETATTR );
//STRIP001 							if( rSh.GetContentAtPos( aDocPos, aCntntAtPos, FALSE ) &&
//STRIP001 								!rSh.IsReadOnlyAvailable() &&
//STRIP001 								aCntntAtPos.IsInProtectSect() )
//STRIP001 								bLockView = TRUE;
//STRIP001 						}
//STRIP001 				}
//STRIP001 
//STRIP001 				if ( rSh.IsGCAttr() )
//STRIP001 				{
//STRIP001 					rSh.GCAttr();
//STRIP001 					rSh.ClearGCAttr();
//STRIP001 				}
//STRIP001 
//STRIP001 				BOOL bOverSelect = rSh.ChgCurrPam( aDocPos ), bOverURLGrf = FALSE;
//STRIP001 				if( !bOverSelect )
//STRIP001 					bOverURLGrf = bOverSelect = 0 != rSh.IsURLGrfAtPos( aDocPos );
//STRIP001 
//STRIP001 				if ( !bOverSelect )
//STRIP001 				{
//STRIP001 					const BOOL bTmp = bNoInterrupt;
//STRIP001 					bNoInterrupt = FALSE;
//STRIP001 
//STRIP001 					if( !rSh.IsViewLocked() && bLockView )
//STRIP001 						rSh.LockView( TRUE );
//STRIP001 					else
//STRIP001 						bLockView = FALSE;
//STRIP001 
//STRIP001 					{	// nur temp. Move-Kontext aufspannen, da sonst die
//STRIP001 						// Abfrage auf die Inhaltsform nicht funktioniert!!!
//STRIP001 						MV_KONTEXT( &rSh );
//STRIP001 						bValidCrsrPos = !(CRSR_POSCHG & (rSh.*rSh.fnSetCrsr)(&aDocPos,bOnlyText));
//STRIP001 						bCallBase = FALSE;
//STRIP001 					}
//STRIP001 
//STRIP001 					if( bLockView )
//STRIP001 						rSh.LockView( FALSE );
//STRIP001 
//STRIP001 					bNoInterrupt = bTmp;
//STRIP001 				}
//STRIP001 				if( !bOverURLGrf )
//STRIP001 				{
//STRIP001 					const int nSelType = rSh.GetSelectionType();
//STRIP001 					if( nSelType == SwWrtShell::SEL_OLE ||
//STRIP001 						nSelType == SwWrtShell::SEL_GRF )
//STRIP001 					{
//STRIP001 						MV_KONTEXT( &rSh );
//STRIP001 						if( !rSh.IsFrmSelected() )
//STRIP001 							rSh.GotoNextFly();
//STRIP001 						rSh.EnterSelFrmMode();
//STRIP001 						bCallBase = FALSE;
//STRIP001 					}
//STRIP001 				}
//STRIP001 				// nicht mehr hier zuruecksetzen, damit -- falls durch MouseMove
//STRIP001 				// bei gedrueckter Ctrl-Taste eine Mehrfachselektion erfolgen soll,
//STRIP001 				// im Drag nicht die vorherige Selektion aufgehoben wird.
//STRIP001 //				if(bModePushed)
//STRIP001 //					rSh.PopMode(FALSE);
//STRIP001 				break;
//STRIP001 			}
//STRIP001 		}
//STRIP001 	}
//STRIP001 	if (bCallBase)
//STRIP001 		Window::MouseButtonDown(rMEvt);
//STRIP001 }
//STRIP001 
//STRIP001 #pragma optimize("",off)
//STRIP001 
//STRIP001 /*--------------------------------------------------------------------
//STRIP001 	Beschreibung:	MouseMove
//STRIP001  --------------------------------------------------------------------*/
//STRIP001 
//STRIP001 
//STRIP001 void SwEditWin::MouseMove(const MouseEvent& rMEvt)
//STRIP001 {
//STRIP001 	// solange eine Action laeuft sollte das MouseMove abgeklemmt sein
//STRIP001 	// Ansonsten gibt es den Bug 40102
//STRIP001 	SwWrtShell &rSh = rView.GetWrtShell();
//STRIP001 	if( rSh.ActionPend() )
//STRIP001 		return ;
//STRIP001 
//STRIP001 	if( pShadCrsr && 0 != (rMEvt.GetModifier() + rMEvt.GetButtons() ) )
//STRIP001 		delete pShadCrsr, pShadCrsr = 0;
//STRIP001 
//STRIP001 	BOOL bIsDocReadOnly = rView.GetDocShell()->IsReadOnly();
//STRIP001 
//STRIP001 	SET_CURR_SHELL( &rSh );
//STRIP001 
//STRIP001 	//aPixPt == Point in Pixel, rel. zu ChildWin
//STRIP001 	//aDocPt == Point in Twips, Dokumentkoordinaten
//STRIP001 	const Point aPixPt( rMEvt.GetPosPixel() );
//STRIP001 	const Point aDocPt( PixelToLogic( aPixPt ) );
//STRIP001 
//STRIP001 	if ( IsChainMode() )
//STRIP001 	{
//STRIP001 		UpdatePointer( aDocPt, rMEvt.GetModifier() );
//STRIP001 		if ( rMEvt.IsLeaveWindow() )
//STRIP001 			rView.GetViewFrame()->HideStatusText();
//STRIP001 		return;
//STRIP001 	}
//STRIP001 
//STRIP001 	SdrView *pSdrView = rSh.GetDrawView();
//STRIP001 
//STRIP001 	const SwCallMouseEvent aLastCallEvent( aSaveCallEvent );
//STRIP001 	aSaveCallEvent.Clear();
//STRIP001 
//STRIP001 	if ( !bIsDocReadOnly && pSdrView && pSdrView->MouseMove(rMEvt,this) )
//STRIP001 	{
//STRIP001 		SetPointer( POINTER_TEXT );
//STRIP001 		return; // Event von der SdrView ausgewertet
//STRIP001 	}
//STRIP001 
//STRIP001 	const Point aOldPt( rSh.VisArea().Pos() );
//STRIP001 #ifdef TEST_FOR_BUG91313
//STRIP001 	// n Pixel as FUZZY border
//STRIP001 	SwRect aVis( rSh.VisArea() );
//STRIP001 	Size aFuzzySz( 2, 2 );
//STRIP001 	aFuzzySz = PixelToLogic( aFuzzySz );
//STRIP001 
//STRIP001 	aVis.Top(    aVis.Top()    + aFuzzySz.Height() );
//STRIP001 	aVis.Bottom( aVis.Bottom() - aFuzzySz.Height() );
//STRIP001 	aVis.Left(   aVis.Left()   + aFuzzySz.Width() );
//STRIP001 	aVis.Right(  aVis.Right()  - aFuzzySz.Width() );
//STRIP001 	const BOOL bInsWin = aVis.IsInside( aDocPt );
//STRIP001 #else
//STRIP001 	const BOOL bInsWin = rSh.VisArea().IsInside( aDocPt );
//STRIP001 #endif
//STRIP001 
//STRIP001 	if( pShadCrsr && !bInsWin )
//STRIP001 		delete pShadCrsr, pShadCrsr = 0;
//STRIP001 
//STRIP001 	// Position ist noetig fuer OS/2, da dort nach einem MB-Down
//STRIP001 	// offensichtlich sofort ein MB-Move gerufen wird.
//STRIP001 	if( bDDTimerStarted )
//STRIP001 	{
//STRIP001 		Point aDD( SwEditWin::nDDStartPosX, SwEditWin::nDDStartPosY );
//STRIP001 		aDD = LogicToPixel( aDD );
//STRIP001 		Rectangle aRect( aDD.X()-3, aDD.Y()-3, aDD.X()+3, aDD.Y()+3 );
//STRIP001 		if ( !aRect.IsInside( aPixPt ) )	// MA 23. May. 95: Tatterschutz.
//STRIP001 			StopDDTimer( &rSh, aDocPt );
//STRIP001 	}
//STRIP001 
//STRIP001     if(rView.GetDrawFuncPtr())
//STRIP001     {        
//STRIP001         if( bInsDraw  )
//STRIP001         {
//STRIP001             rView.GetDrawFuncPtr()->MouseMove( rMEvt );
//STRIP001             if ( !bInsWin )
//STRIP001             {
//STRIP001                 Point aTmp( aDocPt );
//STRIP001                 aTmp += rSh.VisArea().Pos() - aOldPt;
//STRIP001                 LeaveArea( aTmp );
//STRIP001             }
//STRIP001             else
//STRIP001                 EnterArea();
//STRIP001             return;
//STRIP001         }
//STRIP001         else if(!rSh.IsFrmSelected() && !rSh.IsObjSelected())
//STRIP001         {
//STRIP001             SfxBindings &rBnd = rSh.GetView().GetViewFrame()->GetBindings();
//STRIP001             Point aRelPos = rSh.GetRelativePagePosition(aDocPt);
//STRIP001             if(aRelPos.X() >= 0)
//STRIP001             {        
//STRIP001                 FieldUnit eMetric = ::GetDfltMetric(0 != PTR_CAST(SwWebView, &GetView()));
//STRIP001                 SW_MOD()->PutItem(SfxUInt16Item(SID_ATTR_METRIC, eMetric));
//STRIP001                 const SfxPointItem aTmp1( SID_ATTR_POSITION, aRelPos );
//STRIP001                 rBnd.SetState( aTmp1 );
//STRIP001             }
//STRIP001             else 
//STRIP001             {
//STRIP001                 rBnd.Invalidate(SID_ATTR_POSITION);
//STRIP001             }            
//STRIP001             rBnd.Invalidate(SID_ATTR_SIZE);
//STRIP001             const SfxStringItem aCell( SID_TABLE_CELL, aEmptyStr );
//STRIP001             rBnd.SetState( aCell );
//STRIP001         }            
//STRIP001     }    
//STRIP001 
//STRIP001     BYTE nMouseTabCol;
//STRIP001     if( !bIsDocReadOnly && bInsWin && !pApplyTempl && !rSh.IsInSelect() &&
//STRIP001          0 != (nMouseTabCol = rSh.WhichMouseTabCol( aDocPt )) && !rSh.IsTableMode())
//STRIP001 	{
//STRIP001 		//Zuppeln von Tabellenspalten aus dem Dokument heraus.
//STRIP001 
//STRIP001         SetPointer( SW_TABCOL_VERT == nMouseTabCol ? POINTER_VSIZEBAR : POINTER_HSIZEBAR );
//STRIP001 		return;
//STRIP001 	}
//STRIP001 
//STRIP001 	BOOL bDelShadCrsr = TRUE;
//STRIP001 
//STRIP001 	switch ( rMEvt.GetModifier() + rMEvt.GetButtons() )
//STRIP001 	{
//STRIP001 		case MOUSE_LEFT:
//STRIP001 			if( pAnchorMarker )
//STRIP001 			{
//STRIP001 				// Now we need to refresh the SdrHdl pointer of pAnchorMarker.
//STRIP001 				// This looks a little bit tricky, but it solves the following
//STRIP001 				// problem: the pAnchorMarker contains a pointer to an SdrHdl,
//STRIP001 				// if the FindAnchorPos-call cause a scrolling of the visible
//STRIP001 				// area, it's possible that the SdrHdl will be destroyed and a
//STRIP001 				// new one will initialized at the original position(GetHdlPos).
//STRIP001 				// So the pAnchorMarker has to find the right SdrHdl, if it's
//STRIP001 				// the old one, it will find it with position aOld, if this one
//STRIP001 				// is destroyed, it will find a new one at position GetHdlPos().
//STRIP001 				Point aOld = pAnchorMarker->GetPos();
//STRIP001 				Point aNew = rSh.FindAnchorPos( aDocPt );
//STRIP001 				SdrHdl* pHdl;
//STRIP001 				if( (0!=( pHdl = pSdrView->HitHandle( aOld, *(rSh.GetOut())) )||
//STRIP001 					0 !=(pHdl = pSdrView->HitHandle( pAnchorMarker->GetHdlPos(),
//STRIP001 					*(rSh.GetOut())) ) ) &&
//STRIP001                         ( pHdl->GetKind() == HDL_ANCHOR || 
//STRIP001 						  pHdl->GetKind() == HDL_ANCHOR_TR ) )
//STRIP001 				{
//STRIP001 					pAnchorMarker->ChgHdl( pHdl );
//STRIP001 					if( aNew.X() || aNew.Y() )
//STRIP001 					{
//STRIP001 				 		pAnchorMarker->SetPos( aNew );
//STRIP001 				 		pAnchorMarker->SetLastPos( aDocPt );
//STRIP001 				 		pSdrView->RefreshAllIAOManagers();
//STRIP001 				 	}
//STRIP001 				}
//STRIP001 				else
//STRIP001 				{
//STRIP001 					delete pAnchorMarker;
//STRIP001 					pAnchorMarker = NULL;
//STRIP001 				}
//STRIP001 			}
//STRIP001 			if ( bInsDraw )
//STRIP001 			{
//STRIP001 				if ( !bMBPressed )
//STRIP001 					break;
//STRIP001 				if ( bIsInMove || IsMinMove( aStartPos, aPixPt ) )
//STRIP001 				{
//STRIP001 					if ( !bInsWin )
//STRIP001 						LeaveArea( aDocPt );
//STRIP001 					else
//STRIP001 						EnterArea();
//STRIP001 					if ( rView.GetDrawFuncPtr() )
//STRIP001 					{
//STRIP001 						pSdrView->SetOrtho(FALSE);
//STRIP001 						rView.GetDrawFuncPtr()->MouseMove( rMEvt );
//STRIP001 					}
//STRIP001 					bIsInMove = TRUE;
//STRIP001 				}
//STRIP001 				return;
//STRIP001 			}
//STRIP001 		case MOUSE_LEFT + KEY_SHIFT:
//STRIP001 		case MOUSE_LEFT + KEY_SHIFT + KEY_MOD1:
//STRIP001 			if ( !bMBPressed )
//STRIP001 				break;
//STRIP001 		case MOUSE_LEFT + KEY_MOD1:
//STRIP001 			if ( bFrmDrag && rSh.IsSelFrmMode() )
//STRIP001 			{
//STRIP001 				if( !bMBPressed )
//STRIP001 					break;
//STRIP001 
//STRIP001 				if ( bIsInMove || IsMinMove( aStartPos, aPixPt ) )
//STRIP001 				{
//STRIP001 					// Event-Verarbeitung fuers Resizen
//STRIP001 					if( pSdrView->HasMarkedObj() )
//STRIP001 					{
//STRIP001 						const SwFrmFmt* pFlyFmt;
//STRIP001 						const SvxMacro* pMacro;
//STRIP001 
//STRIP001 						const Point aSttPt( PixelToLogic( aStartPos ) );
//STRIP001 
//STRIP001 						// geht es los?
//STRIP001 						if( HDL_USER == eSdrMoveHdl )
//STRIP001 						{
//STRIP001 							SdrHdl*	pHdl = pSdrView->HitHandle( aSttPt, *this );
//STRIP001 							eSdrMoveHdl = pHdl ? pHdl->GetKind() : HDL_MOVE;
//STRIP001 						}
//STRIP001 
//STRIP001 						USHORT nEvent = HDL_MOVE == eSdrMoveHdl
//STRIP001 											? SW_EVENT_FRM_MOVE
//STRIP001 											: SW_EVENT_FRM_RESIZE;
//STRIP001 
//STRIP001 						if( 0 != ( pFlyFmt = rSh.GetFlyFrmFmt() ) &&
//STRIP001 							0 != ( pMacro = pFlyFmt->GetMacro().GetMacroTable().
//STRIP001 							Get( nEvent )) &&
//STRIP001 // oder nur z.B. alle 20 Twip bescheid sagen?
//STRIP001 //							( 20 > Abs( aRszMvHdlPt.X() - aDocPt.X() ) ||
//STRIP001 //							  20 > Abs( aRszMvHdlPt.Y() - aDocPt.Y() ) )
//STRIP001 							aRszMvHdlPt != aDocPt )
//STRIP001 						{
//STRIP001 							aRszMvHdlPt = aDocPt;
//STRIP001 							USHORT nPos = 0;
//STRIP001 							String sRet;
//STRIP001 							SbxArrayRef	xArgs = new SbxArray;
//STRIP001 							SbxVariableRef xVar = new SbxVariable;
//STRIP001 							xVar->PutString( pFlyFmt->GetName() );
//STRIP001 							xArgs->Put( &xVar, ++nPos );
//STRIP001 
//STRIP001 							if( SW_EVENT_FRM_RESIZE == nEvent )
//STRIP001 							{
//STRIP001 								xVar = new SbxVariable;
//STRIP001 								xVar->PutUShort( eSdrMoveHdl );
//STRIP001 								xArgs->Put( &xVar, ++nPos );
//STRIP001 							}
//STRIP001 
//STRIP001 							xVar = new SbxVariable;
//STRIP001 							xVar->PutLong( aDocPt.X() - aSttPt.X() );
//STRIP001 							xArgs->Put( &xVar, ++nPos );
//STRIP001 							xVar = new SbxVariable;
//STRIP001 							xVar->PutLong( aDocPt.Y() - aSttPt.Y() );
//STRIP001 							xArgs->Put( &xVar, ++nPos );
//STRIP001 
//STRIP001 							ReleaseMouse();
//STRIP001 
//STRIP001 							rSh.ExecMacro( *pMacro, &sRet, &xArgs );
//STRIP001 
//STRIP001 							CaptureMouse();
//STRIP001 
//STRIP001 							if( sRet.Len() && 0 != sRet.ToInt32() )
//STRIP001 								return ;
//STRIP001 						}
//STRIP001 					}
//STRIP001 					// Event-Verarbeitung fuers Resizen
//STRIP001 
//STRIP001 					if( bIsDocReadOnly )
//STRIP001 						break;
//STRIP001 
//STRIP001 					if ( rMEvt.IsShift() )
//STRIP001 					{
//STRIP001 						pSdrView->SetOrtho(TRUE);
//STRIP001 						pSdrView->SetAngleSnapEnabled(TRUE);
//STRIP001 					}
//STRIP001 					else
//STRIP001 					{
//STRIP001 						pSdrView->SetOrtho(FALSE);
//STRIP001 						pSdrView->SetAngleSnapEnabled(FALSE);
//STRIP001 					}
//STRIP001 
//STRIP001 					(rSh.*rSh.fnDrag)( &aDocPt, rMEvt.IsShift() );
//STRIP001 					bIsInMove = TRUE;
//STRIP001 				}
//STRIP001 				else if( bIsDocReadOnly )
//STRIP001 					break;
//STRIP001 
//STRIP001 				if ( !bInsWin )
//STRIP001 				{
//STRIP001 					Point aTmp( aDocPt );
//STRIP001 					aTmp += rSh.VisArea().Pos() - aOldPt;
//STRIP001 					LeaveArea( aTmp );
//STRIP001 				}
//STRIP001 				else if(bIsInMove)
//STRIP001 					EnterArea();
//STRIP001 				return;
//STRIP001 			}
//STRIP001 			if ( !rSh.IsSelFrmMode() && !bDDINetAttr &&
//STRIP001 				(IsMinMove( aStartPos,aPixPt ) || bIsInMove) &&
//STRIP001 				(rSh.IsInSelect() || !rSh.ChgCurrPam( aDocPt )) )
//STRIP001 			{
//STRIP001 				if ( pSdrView )
//STRIP001 				{
//STRIP001 					if ( rMEvt.IsShift() )
//STRIP001 						pSdrView->SetOrtho(TRUE);
//STRIP001 					else
//STRIP001 						pSdrView->SetOrtho(FALSE);
//STRIP001 				}
//STRIP001 				if ( !bInsWin )
//STRIP001 				{
//STRIP001 					Point aTmp( aDocPt );
//STRIP001 					aTmp += rSh.VisArea().Pos() - aOldPt;
//STRIP001 					LeaveArea( aTmp );
//STRIP001 				}
//STRIP001 				else
//STRIP001 				{
//STRIP001 					//JP 24.09.98: Fix fuer die Bugs 55592 / 55931
//STRIP001 					//JP 23.04.99: Fix fuer den Bugs 65289
//STRIP001 					//JP 06.07.99: Fix fuer den Bugs 67360
//STRIP001 					if( !rMEvt.IsSynthetic() &&
//STRIP001 							!(( MOUSE_LEFT + KEY_MOD1 ==
//STRIP001 							rMEvt.GetModifier() + rMEvt.GetButtons() ) &&
//STRIP001 							rSh.Is_FnDragEQBeginDrag() && !rSh.IsAddMode() ))
//STRIP001 					{
//STRIP001 						(rSh.*rSh.fnDrag)( &aDocPt,FALSE );
//STRIP001 
//STRIP001 						bValidCrsrPos = !(CRSR_POSCHG & (rSh.*rSh.fnSetCrsr)(&aDocPt,FALSE));
//STRIP001 						EnterArea();
//STRIP001 					}
//STRIP001 				}
//STRIP001 			}
//STRIP001 			bDDINetAttr = FALSE;
//STRIP001 			break;
//STRIP001 		case 0:
//STRIP001 			if ( pApplyTempl )
//STRIP001 			{
//STRIP001 				UpdatePointer(aDocPt, 0); // evtl. muss hier ein Rahmen markiert werden
//STRIP001 				break;
//STRIP001 			}
//STRIP001 		case KEY_SHIFT:
//STRIP001 		case KEY_MOD2:
//STRIP001 		case KEY_MOD1:
//STRIP001 			if ( !bInsDraw )
//STRIP001 			{
//STRIP001 				BOOL bTstShdwCrsr = TRUE;
//STRIP001 
//STRIP001 				UpdatePointer( aDocPt, rMEvt.GetModifier() );
//STRIP001 
//STRIP001 				const SwFrmFmt* pFmt;
//STRIP001 				const SwFmtINetFmt* pINet = 0;
//STRIP001 				SwContentAtPos aCntntAtPos( SwContentAtPos::SW_INETATTR );
//STRIP001 				if( rSh.GetContentAtPos( aDocPt, aCntntAtPos ) )
//STRIP001 					pINet = (SwFmtINetFmt*)aCntntAtPos.aFnd.pAttr;
//STRIP001 
//STRIP001 				const void* pTmp = pINet;
//STRIP001 
//STRIP001 				if( pINet ||
//STRIP001 					0 != ( pTmp = pFmt = rSh.GetFmtFromAnyObj( aDocPt )))
//STRIP001 				{
//STRIP001 					bTstShdwCrsr = FALSE;
//STRIP001 					if( pTmp == pINet )
//STRIP001 						aSaveCallEvent.Set( pINet );
//STRIP001 					else
//STRIP001 					{
//STRIP001 						IMapObject* pIMapObj = pFmt->GetIMapObject( aDocPt );
//STRIP001 						if( pIMapObj )
//STRIP001 							aSaveCallEvent.Set( pFmt, pIMapObj );
//STRIP001 						else
//STRIP001 							aSaveCallEvent.Set( EVENT_OBJECT_URLITEM, pFmt );
//STRIP001 					}
//STRIP001 
//STRIP001 					// sollte wir ueber einem InternetFeld mit einem
//STRIP001 					// gebundenen Macro stehen?
//STRIP001 					if( aSaveCallEvent != aLastCallEvent )
//STRIP001 					{
//STRIP001 						if( aLastCallEvent.HasEvent() )
//STRIP001 							rSh.CallEvent( SFX_EVENT_MOUSEOUT_OBJECT,
//STRIP001 											aLastCallEvent, TRUE );
//STRIP001 						// 0 besagt, das das Object gar keine Tabelle hat
//STRIP001 						if( !rSh.CallEvent( SFX_EVENT_MOUSEOVER_OBJECT,
//STRIP001 										aSaveCallEvent ))
//STRIP001 							aSaveCallEvent.Clear();
//STRIP001 					}
//STRIP001 				}
//STRIP001 				else if( aLastCallEvent.HasEvent() )
//STRIP001 				{
//STRIP001 					// Cursor stand auf einem Object
//STRIP001 					rSh.CallEvent( SFX_EVENT_MOUSEOUT_OBJECT,
//STRIP001 									aLastCallEvent, TRUE );
//STRIP001 				}
//STRIP001 
//STRIP001 				if( bTstShdwCrsr && bInsWin && !bIsDocReadOnly &&
//STRIP001 					!bInsFrm && !rSh.IsBrowseMode() &&
//STRIP001 					rSh.GetViewOptions()->IsShadowCursor() &&
//STRIP001 					!(rMEvt.GetModifier() + rMEvt.GetButtons()) &&
//STRIP001 					!rSh.HasSelection() && !GetConnectMetaFile() )
//STRIP001 				{
//STRIP001 					SwRect aRect;
//STRIP001 					SwHoriOrient eOrient;
//STRIP001 					SwFillMode eMode = (SwFillMode)rSh.GetViewOptions()->GetShdwCrsrFillMode();
//STRIP001 					if( rSh.GetShadowCrsrPos( aDocPt, eMode, aRect, eOrient ))
//STRIP001 					{
//STRIP001 						if( !pShadCrsr )
//STRIP001 							pShadCrsr = new SwShadowCursor( *this,
//STRIP001                                 SwViewOption::GetDirectCursorColor() );
//STRIP001 						if( HORI_RIGHT != eOrient && HORI_CENTER != eOrient )
//STRIP001 							eOrient = HORI_LEFT;
//STRIP001 						pShadCrsr->SetPos( aRect.Pos(), aRect.Height(), eOrient );
//STRIP001 						bDelShadCrsr = FALSE;
//STRIP001 					}
//STRIP001 				}
//STRIP001 			}
//STRIP001 			break;
//STRIP001 	}
//STRIP001 
//STRIP001 	if( bDelShadCrsr && pShadCrsr )
//STRIP001 		delete pShadCrsr, pShadCrsr = 0;
//STRIP001 	bWasShdwCrsr = FALSE;
//STRIP001 }
//STRIP001 
//STRIP001 /*--------------------------------------------------------------------
//STRIP001 	Beschreibung:	Button Up
//STRIP001  --------------------------------------------------------------------*/
//STRIP001 
//STRIP001 
//STRIP001 void SwEditWin::MouseButtonUp(const MouseEvent& rMEvt)
//STRIP001 {
//STRIP001 	BOOL bCallBase = TRUE;
//STRIP001 
//STRIP001 	BOOL bCallShadowCrsr = bWasShdwCrsr;
//STRIP001 	bWasShdwCrsr = FALSE;
//STRIP001 	if( pShadCrsr )
//STRIP001 		delete pShadCrsr, pShadCrsr = 0;
//STRIP001 
//STRIP001 	SdrHdlKind eOldSdrMoveHdl = eSdrMoveHdl;
//STRIP001 	eSdrMoveHdl = HDL_USER;		// fuer die MoveEvents - wieder zuruecksetzen
//STRIP001 
//STRIP001 	// sicherheitshalber zuruecksetzen Bug 27900
//STRIP001 	rView.SetTabColFromDoc( FALSE );
//STRIP001 	SwWrtShell &rSh = rView.GetWrtShell();
//STRIP001 	SET_CURR_SHELL( &rSh );
//STRIP001 	SdrView *pSdrView = rSh.GetDrawView();
//STRIP001 	if ( pSdrView )
//STRIP001 	{
//STRIP001 		pSdrView->SetOrtho(FALSE);
//STRIP001 
//STRIP001 		if ( pSdrView->MouseButtonUp( rMEvt,this ) )
//STRIP001 		{
//STRIP001 			rSh.GetView().GetViewFrame()->GetBindings().InvalidateAll(FALSE);
//STRIP001 			return; // Event von der SdrView ausgewertet
//STRIP001 		}
//STRIP001 	}
//STRIP001 	//MouseButtonUp nur bearbeiten, wenn auch das Down an dieses Fenster ging.
//STRIP001 	if ( !bMBPressed )
//STRIP001 	{
//STRIP001 // OS 25.02.97 Undo fuer die Giesskann ist bereits im CommandHdl
//STRIP001 //JP 29.09.95: so sollte es sein!!!		if(pApplyTempl->bUndo)
//STRIP001 //		if( pApplyTempl && MOUSE_RIGHT == rMEvt.GetModifier() + rMEvt.GetButtons() )
//STRIP001 //			rSh.Do( SwWrtShell::UNDO );
//STRIP001 		return;
//STRIP001 	}
//STRIP001 
//STRIP001 	Point aDocPt( PixelToLogic( rMEvt.GetPosPixel() ) );
//STRIP001 
//STRIP001 	if ( bDDTimerStarted )
//STRIP001 	{
//STRIP001 		StopDDTimer( &rSh, aDocPt );
//STRIP001 		bMBPressed = FALSE;
//STRIP001 		if ( rSh.IsSelFrmMode() )
//STRIP001 		{
//STRIP001 			(rSh.*rSh.fnEndDrag)( &aDocPt, FALSE );
//STRIP001 			bFrmDrag = FALSE;
//STRIP001 		}
//STRIP001 		bNoInterrupt = FALSE;
//STRIP001 		ReleaseMouse();
//STRIP001 		return;
//STRIP001 	}
//STRIP001 
//STRIP001 	if( pAnchorMarker )
//STRIP001 	{
//STRIP001 		Point aPnt( pAnchorMarker->GetLastPos() );
//STRIP001 		pSdrView->RefreshAllIAOManagers();
//STRIP001 		DELETEZ( pAnchorMarker );
//STRIP001 		if( aPnt.X() || aPnt.Y() )
//STRIP001 			rSh.FindAnchorPos( aPnt, TRUE );
//STRIP001 	}
//STRIP001 	if ( bInsDraw && rView.GetDrawFuncPtr() )
//STRIP001 	{
//STRIP001 		if ( rView.GetDrawFuncPtr()->MouseButtonUp( rMEvt ) )
//STRIP001 		{
//STRIP001 			if (rView.GetDrawFuncPtr())	// Koennte im MouseButtonUp zerstoert worden sein
//STRIP001 			{
//STRIP001 				rView.GetDrawFuncPtr()->Deactivate();
//STRIP001 
//STRIP001 				if (!rView.IsDrawMode())
//STRIP001 				{        
//STRIP001 					rView.SetDrawFuncPtr(NULL);
//STRIP001                     SfxBindings& rBind = rView.GetViewFrame()->GetBindings();
//STRIP001                     rBind.Invalidate( SID_ATTR_SIZE );
//STRIP001                     rBind.Invalidate( SID_TABLE_CELL );
//STRIP001                 }
//STRIP001 			}
//STRIP001 
//STRIP001 			if ( rSh.IsObjSelected() )
//STRIP001 			{
//STRIP001 				rSh.EnterSelFrmMode();
//STRIP001 				if (!rView.GetDrawFuncPtr())
//STRIP001 					StdDrawMode(SID_OBJECT_SELECT);
//STRIP001 			}
//STRIP001 			else if ( rSh.IsFrmSelected() )
//STRIP001 			{
//STRIP001 				rSh.EnterSelFrmMode();
//STRIP001 				StopInsFrm();
//STRIP001 			}
//STRIP001 			else
//STRIP001 			{
//STRIP001 				const Point aDocPos( PixelToLogic( aStartPos ) );
//STRIP001 				bValidCrsrPos = !(CRSR_POSCHG & (rSh.*rSh.fnSetCrsr)(&aDocPos,FALSE));
//STRIP001 				rSh.Edit();
//STRIP001 			}
//STRIP001 
//STRIP001 			rView.AttrChangedNotify( &rSh );
//STRIP001 		}
//STRIP001 		else if (rMEvt.GetButtons() == MOUSE_RIGHT && rSh.IsDrawCreate())
//STRIP001 			rView.GetDrawFuncPtr()->BreakCreate();	 // Zeichnen abbrechen
//STRIP001 
//STRIP001 		bNoInterrupt = FALSE;
//STRIP001 		ReleaseMouse();
//STRIP001 		return;
//STRIP001 	}
//STRIP001 	BOOL bPopMode = FALSE;
//STRIP001 	switch ( rMEvt.GetModifier() + rMEvt.GetButtons() )
//STRIP001 	{
//STRIP001 		case MOUSE_LEFT:
//STRIP001 			if ( bInsDraw && rSh.IsDrawCreate() )
//STRIP001 			{
//STRIP001 				if ( rView.GetDrawFuncPtr() && rView.GetDrawFuncPtr()->MouseButtonUp(rMEvt) == TRUE )
//STRIP001 				{
//STRIP001 					rView.GetDrawFuncPtr()->Deactivate();
//STRIP001 					rView.AttrChangedNotify( &rSh );
//STRIP001 					if ( rSh.IsObjSelected() )
//STRIP001 						rSh.EnterSelFrmMode();
//STRIP001 					if ( rView.GetDrawFuncPtr() && bInsFrm )
//STRIP001 						StopInsFrm();
//STRIP001 				}
//STRIP001 				bCallBase = FALSE;
//STRIP001 				break;
//STRIP001 			}
//STRIP001 		case MOUSE_LEFT + KEY_MOD1:
//STRIP001 		case MOUSE_LEFT + KEY_MOD2:
//STRIP001 		case MOUSE_LEFT + KEY_SHIFT + KEY_MOD1:
//STRIP001 			if ( bFrmDrag && rSh.IsSelFrmMode() )
//STRIP001 			{
//STRIP001 				if ( rMEvt.IsMod1() ) //Kopieren und nicht moven.
//STRIP001 				{
//STRIP001 					//Drag abbrechen, statt dessen internes Copy verwenden
//STRIP001 					Rectangle aRect;
//STRIP001 					rSh.GetDrawView()->TakeActionRect( aRect );
//STRIP001 					if (!aRect.IsEmpty())
//STRIP001 					{
//STRIP001 						rSh.BreakDrag();
//STRIP001 						Point aEndPt, aSttPt;
//STRIP001 						if ( rSh.GetSelFrmType() & FRMTYPE_FLY_ATCNT )
//STRIP001 						{
//STRIP001 							aEndPt = aRect.TopLeft();
//STRIP001 							aSttPt = rSh.GetDrawView()->GetAllMarkedRect().TopLeft();
//STRIP001 						}
//STRIP001 						else
//STRIP001 						{
//STRIP001 							aEndPt = aRect.Center();
//STRIP001 							aSttPt = rSh.GetDrawView()->GetAllMarkedRect().Center();
//STRIP001 						}
//STRIP001 						if ( aSttPt != aEndPt )
//STRIP001 						{
//STRIP001 							rSh.StartUndo( UIUNDO_DRAG_AND_COPY );
//STRIP001 							rSh.Copy(&rSh, aSttPt, aEndPt, FALSE);
//STRIP001 							rSh.EndUndo( UIUNDO_DRAG_AND_COPY );
//STRIP001 						}
//STRIP001 					}
//STRIP001 					else
//STRIP001 						(rSh.*rSh.fnEndDrag)( &aDocPt,FALSE );
//STRIP001 				}
//STRIP001 				else
//STRIP001 				{
//STRIP001 					{
//STRIP001 						const SwFrmFmt* pFlyFmt;
//STRIP001 						const SvxMacro* pMacro;
//STRIP001 
//STRIP001 						USHORT nEvent = HDL_MOVE == eOldSdrMoveHdl
//STRIP001 											? SW_EVENT_FRM_MOVE
//STRIP001 											: SW_EVENT_FRM_RESIZE;
//STRIP001 
//STRIP001 						if( 0 != ( pFlyFmt = rSh.GetFlyFrmFmt() ) &&
//STRIP001 							0 != ( pMacro = pFlyFmt->GetMacro().GetMacroTable().
//STRIP001 							Get( nEvent )) )
//STRIP001 						{
//STRIP001 							const Point aSttPt( PixelToLogic( aStartPos ) );
//STRIP001 							aRszMvHdlPt = aDocPt;
//STRIP001 							USHORT nPos = 0;
//STRIP001 							SbxArrayRef	xArgs = new SbxArray;
//STRIP001 							SbxVariableRef xVar = new SbxVariable;
//STRIP001 							xVar->PutString( pFlyFmt->GetName() );
//STRIP001 							xArgs->Put( &xVar, ++nPos );
//STRIP001 
//STRIP001 							if( SW_EVENT_FRM_RESIZE == nEvent )
//STRIP001 							{
//STRIP001 								xVar = new SbxVariable;
//STRIP001 								xVar->PutUShort( eOldSdrMoveHdl );
//STRIP001 								xArgs->Put( &xVar, ++nPos );
//STRIP001 							}
//STRIP001 
//STRIP001 							xVar = new SbxVariable;
//STRIP001 							xVar->PutLong( aDocPt.X() - aSttPt.X() );
//STRIP001 							xArgs->Put( &xVar, ++nPos );
//STRIP001 							xVar = new SbxVariable;
//STRIP001 							xVar->PutLong( aDocPt.Y() - aSttPt.Y() );
//STRIP001 							xArgs->Put( &xVar, ++nPos );
//STRIP001 
//STRIP001 							xVar = new SbxVariable;
//STRIP001 							xVar->PutUShort( 1 );
//STRIP001 							xArgs->Put( &xVar, ++nPos );
//STRIP001 
//STRIP001 							ReleaseMouse();
//STRIP001 
//STRIP001 							rSh.ExecMacro( *pMacro, 0, &xArgs );
//STRIP001 
//STRIP001 							CaptureMouse();
//STRIP001 						}
//STRIP001 					}
//STRIP001 					(rSh.*rSh.fnEndDrag)( &aDocPt,FALSE );
//STRIP001 				}
//STRIP001 				bFrmDrag = FALSE;
//STRIP001 				bCallBase = FALSE;
//STRIP001 				break;
//STRIP001 			}
//STRIP001 			bPopMode = TRUE;
//STRIP001 			// no break
//STRIP001 		case MOUSE_LEFT + KEY_SHIFT:
//STRIP001 			if (rSh.IsSelFrmMode())
//STRIP001 			{
//STRIP001 
//STRIP001 				(rSh.*rSh.fnEndDrag)( &aDocPt, FALSE );
//STRIP001 				bFrmDrag = FALSE;
//STRIP001 				bCallBase = FALSE;
//STRIP001 				break;
//STRIP001 			}
//STRIP001 
//STRIP001 			if( bHoldSelection )
//STRIP001 			{
//STRIP001 				//JP 27.04.99: Bug 65389 - das EndDrag sollte auf jedenfall
//STRIP001 				//				gerufen werden.
//STRIP001 				bHoldSelection = FALSE;
//STRIP001 				(rSh.*rSh.fnEndDrag)( &aDocPt, FALSE );
//STRIP001 			}
//STRIP001 			else
//STRIP001 			{
//STRIP001 				if ( !rSh.IsInSelect() && rSh.ChgCurrPam( aDocPt ) )
//STRIP001 				{
//STRIP001 					const BOOL bTmp = bNoInterrupt;
//STRIP001 					bNoInterrupt = FALSE;
//STRIP001 					{	// nur temp. Move-Kontext aufspannen, da sonst die
//STRIP001 						// Abfrage auf die Inhaltsform nicht funktioniert!!!
//STRIP001 						MV_KONTEXT( &rSh );
//STRIP001 						const Point aDocPos( PixelToLogic( aStartPos ) );
//STRIP001 						bValidCrsrPos = !(CRSR_POSCHG & (rSh.*rSh.fnSetCrsr)(&aDocPos,FALSE));
//STRIP001 					}
//STRIP001 					bNoInterrupt = bTmp;
//STRIP001 
//STRIP001 				}
//STRIP001 				else
//STRIP001 				{
//STRIP001 					BOOL bInSel = rSh.IsInSelect();
//STRIP001 					(rSh.*rSh.fnEndDrag)( &aDocPt, FALSE );
//STRIP001 
//STRIP001 					// Internetfield? --> Link-Callen (DocLaden!!)
//STRIP001 //JP 18.10.96: Bug 32437 -
//STRIP001 //					if( !rSh.HasSelection() )
//STRIP001 					if( !bInSel )
//STRIP001 					{
//STRIP001 						USHORT nFilter = URLLOAD_NOFILTER;
//STRIP001 						if( KEY_MOD1 == rMEvt.GetModifier() )
//STRIP001 							nFilter |= URLLOAD_NEWVIEW;
//STRIP001 
//STRIP001 						BOOL bExecHyperlinks = rSh.GetViewOptions()->IsExecHyperlinks()^
//STRIP001 											   (rMEvt.GetModifier() == KEY_MOD2 ? TRUE : FALSE);
//STRIP001 						if(pApplyTempl)
//STRIP001 							bExecHyperlinks = FALSE;
//STRIP001 						SwContentAtPos aCntntAtPos( SwContentAtPos::SW_CLICKFIELD |
//STRIP001 													SwContentAtPos::SW_INETATTR );
//STRIP001 
//STRIP001 						if( rSh.GetContentAtPos( aDocPt, aCntntAtPos, TRUE ) )
//STRIP001 						{
//STRIP001 							BOOL bViewLocked = rSh.IsViewLocked();
//STRIP001 							if( !bViewLocked && !rSh.IsReadOnlyAvailable() &&
//STRIP001 								aCntntAtPos.IsInProtectSect() )
//STRIP001 								rSh.LockView( TRUE );
//STRIP001 
//STRIP001 							ReleaseMouse();
//STRIP001 							if( SwContentAtPos::SW_FIELD == aCntntAtPos.eCntntAtPos )
//STRIP001 							{
//STRIP001 								if( bExecHyperlinks )
//STRIP001 									rSh.ClickToField( *aCntntAtPos.aFnd.pFld, nFilter );
//STRIP001 							}
//STRIP001 							else if( bExecHyperlinks )
//STRIP001 							{
//STRIP001 								rSh.ClickToINetAttr( *(SwFmtINetFmt*)
//STRIP001 										aCntntAtPos.aFnd.pAttr, nFilter );
//STRIP001 							}
//STRIP001 							rSh.LockView( bViewLocked );
//STRIP001 							bCallShadowCrsr = FALSE;
//STRIP001 						}
//STRIP001 						else if( bExecHyperlinks )
//STRIP001 						{
//STRIP001 							aCntntAtPos = SwContentAtPos( SwContentAtPos::SW_FTN );
//STRIP001 							if( !rSh.GetContentAtPos( aDocPt, aCntntAtPos, TRUE ) )
//STRIP001 							{
//STRIP001 								SdrViewEvent aVEvt;
//STRIP001 
//STRIP001 								if (pSdrView)
//STRIP001 									pSdrView->PickAnything(rMEvt, SDRMOUSEBUTTONDOWN, aVEvt);
//STRIP001 
//STRIP001 								if (pSdrView && aVEvt.eEvent == SDREVENT_EXECUTEURL)
//STRIP001 								{
//STRIP001 									// URL-Feld getroffen
//STRIP001 									const SvxURLField *pField = aVEvt.pURLField;
//STRIP001 									if (pField)
//STRIP001 									{
//STRIP001 										String sURL(pField->GetURL());
//STRIP001 										String sTarget(pField->GetTargetFrame());
//STRIP001 										::LoadURL( sURL, &rSh, nFilter, &sTarget);
//STRIP001 									}
//STRIP001 									bCallShadowCrsr = FALSE;
//STRIP001 								}
//STRIP001 								else
//STRIP001 								{
//STRIP001 									// Grafik getroffen
//STRIP001 									ReleaseMouse();
//STRIP001 									if( rSh.ClickToINetGrf( aDocPt, nFilter ))
//STRIP001 										bCallShadowCrsr = FALSE;
//STRIP001 								}
//STRIP001 							}
//STRIP001 						}
//STRIP001 
//STRIP001 						if( bCallShadowCrsr &&
//STRIP001 							rSh.GetViewOptions()->IsShadowCursor() &&
//STRIP001 							MOUSE_LEFT == (rMEvt.GetModifier() + rMEvt.GetButtons()) &&
//STRIP001 							!rSh.HasSelection() &&
//STRIP001 							!GetConnectMetaFile() &&
//STRIP001 							rSh.VisArea().IsInside( aDocPt ))
//STRIP001 						{
//STRIP001 							if( UNDO_INS_FROM_SHADOWCRSR == rSh.GetUndoIds() )
//STRIP001 								rSh.Undo();
//STRIP001 							SwFillMode eMode = (SwFillMode)rSh.GetViewOptions()->GetShdwCrsrFillMode();
//STRIP001 							rSh.SetShadowCrsrPos( aDocPt, eMode );
//STRIP001 						}
//STRIP001 					}
//STRIP001 				}
//STRIP001 				bCallBase = FALSE;
//STRIP001 
//STRIP001 			}
//STRIP001 
//STRIP001 			// gfs. im Down gepushten Mode wieder zuruecksetzen
//STRIP001 			if ( bPopMode && bModePushed )
//STRIP001 			{
//STRIP001 				rSh.PopMode();
//STRIP001 				bModePushed = FALSE;
//STRIP001 				bCallBase = FALSE;
//STRIP001 			}
//STRIP001 			break;
//STRIP001 
//STRIP001 		default:
//STRIP001 			ReleaseMouse();
//STRIP001 			return;
//STRIP001 	}
//STRIP001 
//STRIP001 	if( pApplyTempl )
//STRIP001 	{
//STRIP001 		int eSelection = rSh.GetSelectionType();
//STRIP001 		if( pApplyTempl->nColor )
//STRIP001 		{
//STRIP001 			USHORT nId = 0;
//STRIP001 			switch( pApplyTempl->nColor )
//STRIP001 			{
//STRIP001 				case SID_ATTR_CHAR_COLOR_EXT:
//STRIP001 					nId = RES_CHRATR_COLOR;
//STRIP001 				break;
//STRIP001 				case SID_ATTR_CHAR_COLOR_BACKGROUND_EXT:
//STRIP001 					nId = RES_CHRATR_BACKGROUND;
//STRIP001 				break;
//STRIP001 			}
//STRIP001 			if( nId && (SwWrtShell::SEL_TXT|SwWrtShell::SEL_TBL) & eSelection)
//STRIP001 			{
//STRIP001 				if( rSh.IsSelection() && !rSh.HasReadonlySel() )
//STRIP001 				{
//STRIP001 					if(nId == RES_CHRATR_BACKGROUND)
//STRIP001 					{
//STRIP001 						Color aColor( COL_TRANSPARENT  );
//STRIP001 						if( !SwEditWin::bTransparentBackColor )
//STRIP001 							aColor = SwEditWin::aTextBackColor;
//STRIP001 						rSh.SetAttr( SvxBrushItem( aColor, nId ) );
//STRIP001 					}
//STRIP001 					else
//STRIP001 						rSh.SetAttr( SvxColorItem(SwEditWin::aTextColor, nId) );
//STRIP001 					rSh.UnSetVisCrsr();
//STRIP001 					rSh.EnterStdMode();
//STRIP001 					rSh.SetVisCrsr(aDocPt);
//STRIP001 
//STRIP001 					pApplyTempl->bUndo = TRUE;
//STRIP001 					bCallBase = FALSE;
//STRIP001 					aTemplateTimer.Stop();
//STRIP001 				}
//STRIP001 				else if(rMEvt.GetClicks() == 1)
//STRIP001 				{
//STRIP001 					// keine Selektion -> also Giesskanne abschalten
//STRIP001 					aTemplateTimer.Start();
//STRIP001 				}
//STRIP001 			}
//STRIP001 		}
//STRIP001 		else
//STRIP001 		{
//STRIP001             String aStyleName;
//STRIP001 			switch ( pApplyTempl->eType )
//STRIP001 			{
//STRIP001 				case SFX_STYLE_FAMILY_PARA:
//STRIP001 					if( (( SwWrtShell::SEL_TXT | SwWrtShell::SEL_TBL )
//STRIP001 						 & eSelection ) && !rSh.HasReadonlySel() )
//STRIP001 					{
//STRIP001 						rSh.SetTxtFmtColl( pApplyTempl->aColl.pTxtColl );
//STRIP001                         pApplyTempl->bUndo = TRUE;
//STRIP001 						bCallBase = FALSE;
//STRIP001                         if ( pApplyTempl->aColl.pTxtColl )
//STRIP001                             aStyleName = pApplyTempl->aColl.pTxtColl->GetName();
//STRIP001 					}
//STRIP001 					break;
//STRIP001 				case SFX_STYLE_FAMILY_CHAR:
//STRIP001 					if( (( SwWrtShell::SEL_TXT | SwWrtShell::SEL_TBL )
//STRIP001 						 & eSelection ) && !rSh.HasReadonlySel() )
//STRIP001 					{
//STRIP001 						rSh.SetAttr( SwFmtCharFmt(pApplyTempl->aColl.pCharFmt) );
//STRIP001 						rSh.UnSetVisCrsr();
//STRIP001 						rSh.EnterStdMode();
//STRIP001 						rSh.SetVisCrsr(aDocPt);
//STRIP001 						pApplyTempl->bUndo = TRUE;
//STRIP001 						bCallBase = FALSE;
//STRIP001                         if ( pApplyTempl->aColl.pCharFmt )
//STRIP001                             aStyleName = pApplyTempl->aColl.pCharFmt->GetName();
//STRIP001 					}
//STRIP001 					break;
//STRIP001 				case SFX_STYLE_FAMILY_FRAME :
//STRIP001 				{
//STRIP001 					const SwFrmFmt* pFmt = rSh.GetFmtFromObj( aDocPt );
//STRIP001 					if(PTR_CAST(SwFlyFrmFmt, pFmt))
//STRIP001 					{
//STRIP001 						rSh.SetFrmFmt( pApplyTempl->aColl.pFrmFmt, FALSE, &aDocPt );
//STRIP001 						pApplyTempl->bUndo = TRUE;
//STRIP001 						bCallBase = FALSE;
//STRIP001                         if( pApplyTempl->aColl.pFrmFmt )
//STRIP001                             aStyleName = pApplyTempl->aColl.pFrmFmt->GetName();
//STRIP001 					}
//STRIP001 					break;
//STRIP001 				}
//STRIP001 				case SFX_STYLE_FAMILY_PAGE:
//STRIP001 							// Kein Undo bei Seitenvorlagen
//STRIP001 					rSh.ChgCurPageDesc( *pApplyTempl->aColl.pPageDesc );
//STRIP001                     if ( pApplyTempl->aColl.pPageDesc )
//STRIP001                         aStyleName = pApplyTempl->aColl.pPageDesc->GetName();
//STRIP001 					bCallBase = FALSE;
//STRIP001 					break;
//STRIP001 				case SFX_STYLE_FAMILY_PSEUDO:
//STRIP001 					if( !rSh.HasReadonlySel() )
//STRIP001 					{
//STRIP001 						rSh.SetCurNumRule( *pApplyTempl->aColl.pNumRule );
//STRIP001 						bCallBase = FALSE;
//STRIP001 						pApplyTempl->bUndo = TRUE;
//STRIP001                         if( pApplyTempl->aColl.pNumRule )
//STRIP001                             aStyleName = pApplyTempl->aColl.pNumRule->GetName();
//STRIP001 					}
//STRIP001 					break;
//STRIP001 			}
//STRIP001 
//STRIP001             ::com::sun::star::uno::Reference< ::com::sun::star::frame::XDispatchRecorder > xRecorder =
//STRIP001                     rView.GetViewFrame()->GetBindings().GetRecorder();
//STRIP001             if ( aStyleName.Len() && xRecorder.is() )
//STRIP001             {
//STRIP001                 SfxShell *pSfxShell = lcl_GetShellFromDispatcher( rView, TYPE(SwTextShell) );
//STRIP001                 if ( pSfxShell )
//STRIP001                 {
//STRIP001                     SfxRequest aReq( rView.GetViewFrame(), SID_STYLE_APPLY );
//STRIP001                     aReq.AppendItem( SfxStringItem( SID_STYLE_APPLY, aStyleName ) );
//STRIP001                     aReq.AppendItem( SfxUInt16Item( SID_STYLE_FAMILY, (USHORT) pApplyTempl->eType ) );
//STRIP001                     aReq.Done();
//STRIP001                 }
//STRIP001             }
//STRIP001 		}
//STRIP001 
//STRIP001 	}
//STRIP001 	ReleaseMouse();
//STRIP001 	// Hier kommen nur verarbeitete MouseEvents an; nur bei diesen duerfen
//STRIP001 	// die Modi zurueckgesetzt werden.
//STRIP001 	bMBPressed = FALSE;
//STRIP001 
//STRIP001 	//sicherheitshalber aufrufen, da jetzt das Selektieren bestimmt zu Ende ist.
//STRIP001 	//Andernfalls koennte der Timeout des Timers Kummer machen.
//STRIP001 	EnterArea();
//STRIP001 	bNoInterrupt = FALSE;
//STRIP001 
//STRIP001 	if (bCallBase)
//STRIP001 		Window::MouseButtonUp(rMEvt);
//STRIP001 }
//STRIP001 
//STRIP001 
//STRIP001 /*--------------------------------------------------------------------
//STRIP001 	Beschreibung:	Vorlage anwenden
//STRIP001  --------------------------------------------------------------------*/
//STRIP001 
//STRIP001 
//STRIP001 void SwEditWin::SetApplyTemplate(const SwApplyTemplate &rTempl)
//STRIP001 {
//STRIP001 	static BOOL bIdle = FALSE;
//STRIP001 	DELETEZ(pApplyTempl);
//STRIP001 	SwWrtShell &rSh = rView.GetWrtShell();
//STRIP001 
//STRIP001 	if(rTempl.nColor)
//STRIP001 	{
//STRIP001 		pApplyTempl = new SwApplyTemplate( rTempl );
//STRIP001 		SetPointer( POINTER_FILL );
//STRIP001 		rSh.NoEdit( FALSE );
//STRIP001 		bIdle = rSh.GetViewOptions()->IsIdle();
//STRIP001 		((SwViewOption *)rSh.GetViewOptions())->SetIdle( FALSE );
//STRIP001 	}
//STRIP001 	else if( rTempl.eType )
//STRIP001 	{
//STRIP001 		pApplyTempl = new SwApplyTemplate( rTempl );
//STRIP001 		SetPointer( POINTER_FILL  );
//STRIP001 		rSh.NoEdit( FALSE );
//STRIP001 		bIdle = rSh.GetViewOptions()->IsIdle();
//STRIP001 		((SwViewOption *)rSh.GetViewOptions())->SetIdle( FALSE );
//STRIP001 	}
//STRIP001 	else
//STRIP001 	{
//STRIP001 		SetPointer( POINTER_TEXT );
//STRIP001 		rSh.UnSetVisCrsr();
//STRIP001 
//STRIP001 		((SwViewOption *)rSh.GetViewOptions())->SetIdle( bIdle );
//STRIP001 		if ( !rSh.IsSelFrmMode() )
//STRIP001 			rSh.Edit();
//STRIP001 	}
//STRIP001 
//STRIP001 	static USHORT __READONLY_DATA aInva[] =
//STRIP001 	{
//STRIP001 		SID_STYLE_WATERCAN,
//STRIP001 		SID_ATTR_CHAR_COLOR_EXT,
//STRIP001 		SID_ATTR_CHAR_COLOR_BACKGROUND_EXT,
//STRIP001 		0
//STRIP001 	};
//STRIP001 	rView.GetViewFrame()->GetBindings().Invalidate(aInva);
//STRIP001 }
//STRIP001 
//STRIP001 /*--------------------------------------------------------------------
//STRIP001 	Beschreibung:	ctor
//STRIP001  --------------------------------------------------------------------*/
//STRIP001 
//STRIP001 
/*N*/ SwEditWin::SwEditWin(Window *pParent, SwView &rMyView):
/*N*/ 	Window(pParent, WinBits(WB_CLIPCHILDREN | WB_DIALOGCONTROL)),
/*N*/ 	DropTargetHelper( this ),
/*N*/ 	DragSourceHelper( this ),
/*N*/ 	aActHitType(SDRHIT_NONE),
/*N*/ 	eDrawMode(OBJ_NONE),
/*N*/ 	pApplyTempl(0),
/*N*/ 	rView( rMyView ),
//STRIP001 /*N*/ 	pAnchorMarker( 0 ),
/*N*/ 	pUserMarker( 0 ),
/*N*/ 	pUserMarkerObj( 0 ),
//STRIP001 /*N*/ 	pShadCrsr( 0 ),
/*N*/ 	nDropAction( 0 ),
/*N*/ 	nDropFormat( 0 ),
/*N*/ 	nDropDestination( 0 ),
/*N*/ 	nInsFrmColCount( 1 ),
/*N*/ 	bLockInput(FALSE)
/*N*/ {
/*N*/ 	SetHelpId(HID_EDIT_WIN);
/*N*/ 	EnableChildTransparentMode();
/*N*/ 	SetDialogControlFlags( WINDOW_DLGCTRL_RETURN | WINDOW_DLGCTRL_WANTFOCUS );
/*N*/ 
/*N*/ 	bLinkRemoved = bMBPressed = bInsDraw = bInsFrm =
/*N*/ 	bIsInDrag = bOldIdle = bOldIdleSet = bChainMode = bWasShdwCrsr = FALSE;
/*N*/ 
/*N*/ 	SetMapMode(MapMode(MAP_TWIP));
/*N*/ 
/*N*/ 	SetPointer( POINTER_TEXT );
/*N*/ 	aTimer.SetTimeoutHdl(LINK(this, SwEditWin, TimerHandler));
/*N*/ 
/*N*/ 	bTblInsDelMode = FALSE;
/*N*/ 	aKeyInputTimer.SetTimeout( 3000 );
/*N*/ 	aKeyInputTimer.SetTimeoutHdl(LINK(this, SwEditWin, KeyInputTimerHandler));
/*N*/ 
/*N*/ 	aKeyInputFlushTimer.SetTimeout( 200 );
/*N*/ 	aKeyInputFlushTimer.SetTimeoutHdl(LINK(this, SwEditWin, KeyInputFlushHandler));
/*N*/ 
/*N*/ 	// TemplatePointer fuer Farben soll nach Einfachclick
/*N*/ 	// ohne Selektion zurueckgesetzt werden
/*N*/ 	aTemplateTimer.SetTimeout(400);
/*N*/ 	aTemplateTimer.SetTimeoutHdl(LINK(this, SwEditWin, TemplateTimerHdl));
/*N*/ 
/*N*/ 	//JP 16.12.98: temporaere Loesung!!! Sollte bei jeder Cursorbewegung
/*N*/ 	//			den Font von der akt. einfuege Position setzen!
/*N*/ 	if( !rMyView.GetDocShell()->IsReadOnly() )
/*N*/ 	{
/*N*/ 		Font aFont;
/*N*/ 		SetInputContext( InputContext( aFont, INPUTCONTEXT_TEXT |
/*N*/ 											INPUTCONTEXT_EXTTEXTINPUT ) );
/*N*/ 	}
/*N*/ }
/*N*/ 
/*N*/ 
/*N*/ 
/*N*/ SwEditWin::~SwEditWin()
/*N*/ {
/*N*/ 	aKeyInputTimer.Stop();
//STRIP001 /*N*/ 	delete pShadCrsr;
/*N*/ 	if( pQuickHlpData->bClear && rView.GetWrtShellPtr() )
/*?*/ 		{DBG_BF_ASSERT(0, "STRIP"); }//STRIP001 pQuickHlpData->Stop( rView.GetWrtShell() );
/*N*/ 	bExecuteDrag = FALSE;
/*N*/ 	delete pApplyTempl;
//STRIP001 /*N*/ 	rView.SetDrawFuncPtr(NULL);
/*N*/ 	delete pUserMarker;
//STRIP001 /*N*/ 	delete pAnchorMarker;
/*N*/ }
/*N*/ 

//STRIP001 /******************************************************************************
//STRIP001  *	Beschreibung: DrawTextEditMode einschalten
//STRIP001  ******************************************************************************/
//STRIP001 
//STRIP001 
//STRIP001 void SwEditWin::EnterDrawTextMode( const Point& aDocPos )
//STRIP001 {
//STRIP001 	if ( rView.EnterDrawTextMode(aDocPos) == TRUE )
//STRIP001 	{
//STRIP001 		if (rView.GetDrawFuncPtr())
//STRIP001 		{
//STRIP001 			rView.GetDrawFuncPtr()->Deactivate();
//STRIP001 			rView.SetDrawFuncPtr(NULL);
//STRIP001 			rView.LeaveDrawCreate();
//STRIP001 		}
//STRIP001 		rView.NoRotate();
//STRIP001 		rView.AttrChangedNotify( &rView.GetWrtShell() );
//STRIP001 	}
//STRIP001 }
//STRIP001 
//STRIP001 /******************************************************************************
//STRIP001  *	Beschreibung: DrawMode einschalten
//STRIP001  ******************************************************************************/
//STRIP001 
//STRIP001 
//STRIP001 
//STRIP001 BOOL SwEditWin::EnterDrawMode(const MouseEvent& rMEvt, const Point& aDocPos)
//STRIP001 {
//STRIP001 	SwWrtShell &rSh = rView.GetWrtShell();
//STRIP001 	SdrView *pSdrView = rSh.GetDrawView();
//STRIP001 
//STRIP001 //	if ( GetDrawFuncPtr() && (aActHitType == SDRHIT_NONE || rSh.IsDrawCreate()) )
//STRIP001 	if ( rView.GetDrawFuncPtr() )
//STRIP001 	{
//STRIP001 		if (rSh.IsDrawCreate())
//STRIP001 			return TRUE;
//STRIP001 
//STRIP001 		BOOL bRet = rView.GetDrawFuncPtr()->MouseButtonDown( rMEvt );
//STRIP001 		rView.AttrChangedNotify( &rSh );
//STRIP001 		return bRet;
//STRIP001 	}
//STRIP001 
//STRIP001 	if ( pSdrView && pSdrView->IsTextEdit() )
//STRIP001 	{
//STRIP001 		BOOL bUnLockView = !rSh.IsViewLocked();
//STRIP001 		rSh.LockView( TRUE );
//STRIP001 
//STRIP001 		rSh.EndTextEdit(); // Danebengeklickt, Ende mit Edit
//STRIP001 		rSh.SelectObj( aDocPos );
//STRIP001 		if ( !rSh.IsObjSelected() && !rSh.IsFrmSelected() )
//STRIP001 			rSh.LeaveSelFrmMode();
//STRIP001 		else
//STRIP001 		{
//STRIP001 			SwEditWin::nDDStartPosY = aDocPos.Y();
//STRIP001 			SwEditWin::nDDStartPosX = aDocPos.X();
//STRIP001 			bFrmDrag = TRUE;
//STRIP001 		}
//STRIP001 		if( bUnLockView )
//STRIP001 			rSh.LockView( FALSE );
//STRIP001 		rView.AttrChangedNotify( &rSh );
//STRIP001 		return TRUE;
//STRIP001 	}
//STRIP001 	return FALSE;
//STRIP001 }
//STRIP001 
//STRIP001 /******************************************************************************
//STRIP001  *	Beschreibung:
//STRIP001  ******************************************************************************/
//STRIP001 
//STRIP001 
//STRIP001 
//STRIP001 BOOL SwEditWin::IsDrawSelMode()
//STRIP001 {
//STRIP001 //	return (IsFrmAction() == FALSE && GetDrawMode() == OBJ_NONE);
//STRIP001 	return (GetDrawMode() == SID_OBJECT_SELECT);
//STRIP001 }
//STRIP001 
//STRIP001 /******************************************************************************
//STRIP001  *	Beschreibung:
//STRIP001  ******************************************************************************/
//STRIP001 
//STRIP001 
//STRIP001 void SwEditWin::GetFocus()
//STRIP001 {
//STRIP001 	rView.GotFocus();
//STRIP001 	Window::GetFocus();
//STRIP001 #ifdef ACCESSIBLE_LAYOUT
//STRIP001     rView.GetWrtShell().InvalidateAccessibleFocus();
//STRIP001 #endif
//STRIP001 }
//STRIP001 
//STRIP001 /******************************************************************************
//STRIP001  *	Beschreibung:
//STRIP001  ******************************************************************************/
//STRIP001 
//STRIP001 
//STRIP001 
//STRIP001 void SwEditWin::LoseFocus()
//STRIP001 {
//STRIP001 #ifdef ACCESSIBLE_LAYOUT
//STRIP001     rView.GetWrtShell().InvalidateAccessibleFocus();
//STRIP001 #endif
//STRIP001 	Window::LoseFocus();
//STRIP001 	if( pQuickHlpData->bClear )
//STRIP001 		pQuickHlpData->Stop( rView.GetWrtShell() );
//STRIP001 	rView.LostFocus();
//STRIP001 }
//STRIP001 
//STRIP001 /******************************************************************************
//STRIP001  *	Beschreibung:
//STRIP001  ******************************************************************************/
//STRIP001 
//STRIP001 
//STRIP001 
//STRIP001 void SwEditWin::Command( const CommandEvent& rCEvt )
//STRIP001 {
//STRIP001 	if ( !rView.GetViewFrame() || !rView.GetViewFrame()->GetFrame() ||
//STRIP001 		  rView.GetViewFrame()->GetFrame()->TransferForReplaceInProgress())
//STRIP001 	{
//STRIP001 		//Wenn der ViewFrame in Kuerze stirbt kein Popup mehr!
//STRIP001 		Window::Command(rCEvt);
//STRIP001 		return;
//STRIP001 	}
//STRIP001 
//STRIP001 	BOOL bCallBase		= TRUE;
//STRIP001 
//STRIP001 	SwWrtShell &rSh = rView.GetWrtShell();
//STRIP001 
//STRIP001 	switch ( rCEvt.GetCommand() )
//STRIP001 	{
//STRIP001 		case COMMAND_CONTEXTMENU:
//STRIP001 		{
//STRIP001 			const USHORT nId = SwInputChild::GetChildWindowId();
//STRIP001 			SwInputChild* pChildWin = (SwInputChild*)GetView().GetViewFrame()->
//STRIP001 												GetChildWindow( nId );
//STRIP001 
//STRIP001 			if((!pChildWin || pChildWin->GetView() != &rView) &&
//STRIP001 				!rSh.IsDrawCreate() && !IsDrawAction())
//STRIP001 			{
//STRIP001 				SET_CURR_SHELL( &rSh );
//STRIP001 				if (!pApplyTempl)
//STRIP001 				{
//STRIP001 					if (bNoInterrupt == TRUE)
//STRIP001 					{
//STRIP001 						ReleaseMouse();
//STRIP001 						bNoInterrupt = FALSE;
//STRIP001 						bMBPressed = FALSE;
//STRIP001 					}
//STRIP001 					Point aDocPos( PixelToLogic( rCEvt.GetMousePosPixel() ) );
//STRIP001 					if ( !rCEvt.IsMouseEvent() )
//STRIP001 						aDocPos = rSh.GetCharRect().Center();
//STRIP001 					const Point aPixPos = LogicToPixel( aDocPos );
//STRIP001 
//STRIP001 					if ( rView.GetDocShell()->IsReadOnly() )
//STRIP001 						SwReadOnlyPopup( aDocPos, rView ).Execute( this, aPixPos );
//STRIP001 					else if ( !rView.ExecSpellPopup( aDocPos ) )
//STRIP001 						GetView().GetViewFrame()->GetDispatcher()->ExecutePopup( 0, this, &aPixPos);
//STRIP001 				}
//STRIP001 				else if (pApplyTempl->bUndo)
//STRIP001 					rSh.Do(SwWrtShell::UNDO);
//STRIP001 				bCallBase = FALSE;
//STRIP001 			}
//STRIP001 		}
//STRIP001 		break;
//STRIP001 
//STRIP001 		case COMMAND_WHEEL:
//STRIP001 		case COMMAND_STARTAUTOSCROLL:
//STRIP001 		case COMMAND_AUTOSCROLL:
//STRIP001 			if( pShadCrsr )
//STRIP001 				delete pShadCrsr, pShadCrsr = 0;
//STRIP001 			bCallBase = !rView.HandleWheelCommands( rCEvt );
//STRIP001 			break;
//STRIP001 
//STRIP001 		case COMMAND_VOICE:
//STRIP001 			{
//STRIP001 				//ggf. an Outliner weiterleiten
//STRIP001 				if ( rSh.HasDrawView() && rSh.GetDrawView()->IsTextEdit() )
//STRIP001 				{
//STRIP001 					bCallBase = FALSE;
//STRIP001 					rSh.GetDrawView()->GetTextEditOutlinerView()->Command( rCEvt );
//STRIP001 					break;
//STRIP001 				}
//STRIP001 
//STRIP001 				const CommandVoiceData *pCData = rCEvt.GetVoiceData();
//STRIP001 				if ( VOICECOMMANDTYPE_CONTROL == pCData->GetType() )
//STRIP001 					break;
//STRIP001 
//STRIP001 
//STRIP001 				USHORT nSlotId = 0;
//STRIP001 				SfxPoolItem *pItem = 0;
//STRIP001 
//STRIP001 				switch ( pCData->GetCommand() )
//STRIP001 				{
//STRIP001 					case DICTATIONCOMMAND_NEWPARAGRAPH:	nSlotId = FN_INSERT_BREAK; break;
//STRIP001 					case DICTATIONCOMMAND_NEWLINE:		nSlotId = FN_INSERT_LINEBREAK; break;
//STRIP001 					case DICTATIONCOMMAND_LEFT:			nSlotId = FN_PREV_WORD; break;
//STRIP001 					case DICTATIONCOMMAND_RIGHT:		nSlotId = FN_NEXT_WORD; break;
//STRIP001 					case DICTATIONCOMMAND_UP:			nSlotId = FN_LINE_UP; break;
//STRIP001 					case DICTATIONCOMMAND_DOWN:			nSlotId = FN_LINE_DOWN; break;
//STRIP001 					case DICTATIONCOMMAND_UNDO:			nSlotId = SID_UNDO; break;
//STRIP001 					case DICTATIONCOMMAND_REPEAT:		nSlotId = SID_REPEAT; break;
//STRIP001 					case DICTATIONCOMMAND_DEL:			nSlotId = FN_DELETE_BACK_WORD; break;
//STRIP001 
//STRIP001 					case DICTATIONCOMMAND_BOLD_ON:		nSlotId = SID_ATTR_CHAR_WEIGHT;
//STRIP001 														pItem = new SvxWeightItem( WEIGHT_BOLD );
//STRIP001 														break;
//STRIP001 					case DICTATIONCOMMAND_BOLD_OFF:		nSlotId = SID_ATTR_CHAR_WEIGHT;
//STRIP001 														pItem = new SvxWeightItem( WEIGHT_NORMAL );
//STRIP001 														break;
//STRIP001 					case DICTATIONCOMMAND_UNDERLINE_ON:	nSlotId = SID_ATTR_CHAR_UNDERLINE;
//STRIP001 														pItem = new SvxUnderlineItem( UNDERLINE_SINGLE );
//STRIP001 														break;
//STRIP001 					case DICTATIONCOMMAND_UNDERLINE_OFF:nSlotId = SID_ATTR_CHAR_UNDERLINE;
//STRIP001 														pItem = new SvxUnderlineItem( UNDERLINE_NONE );
//STRIP001 														break;
//STRIP001 					case DICTATIONCOMMAND_ITALIC_ON:	nSlotId = SID_ATTR_CHAR_POSTURE;
//STRIP001 														pItem = new SvxPostureItem( ITALIC_NORMAL );
//STRIP001 														break;
//STRIP001 					case DICTATIONCOMMAND_ITALIC_OFF:	nSlotId = SID_ATTR_CHAR_POSTURE;
//STRIP001 														pItem = new SvxPostureItem( ITALIC_NONE );
//STRIP001 														break;
//STRIP001 					case DICTATIONCOMMAND_NUMBERING_ON:
//STRIP001 									if ( !rSh.GetCurNumRule() )
//STRIP001 										nSlotId = FN_NUM_NUMBERING_ON;
//STRIP001 									break;
//STRIP001 					case DICTATIONCOMMAND_NUMBERING_OFF:
//STRIP001 									if ( rSh.GetCurNumRule() )
//STRIP001 									   nSlotId = FN_NUM_NUMBERING_ON;
//STRIP001 									break;
//STRIP001 					case DICTATIONCOMMAND_TAB:
//STRIP001 									{
//STRIP001 									   rSh.Insert( '\t' );
//STRIP001 									}
//STRIP001 									break;
//STRIP001 					case DICTATIONCOMMAND_UNKNOWN:
//STRIP001 									{
//STRIP001 										rView.GetWrtShell().Insert( pCData->GetText() );
//STRIP001 									}
//STRIP001 									break;
//STRIP001 
//STRIP001 #ifdef DBG_UTIL
//STRIP001 					default:
//STRIP001 						ASSERT( !this, "unknown speech command." );
//STRIP001 #endif
//STRIP001 				}
//STRIP001 				if ( nSlotId )
//STRIP001 				{
//STRIP001 					bCallBase = FALSE;
//STRIP001 					if ( pItem )
//STRIP001 					{
//STRIP001 						const SfxPoolItem* aArgs[2];
//STRIP001                         aArgs[0] = pItem;
//STRIP001                         aArgs[1] = 0;
//STRIP001                         GetView().GetViewFrame()->GetBindings().Execute( 
//STRIP001                                     nSlotId, aArgs, 0, SFX_CALLMODE_STANDARD );
//STRIP001 						delete pItem;
//STRIP001 					}
//STRIP001 					else
//STRIP001                         GetView().GetViewFrame()->GetBindings().Execute( nSlotId );
//STRIP001 				}
//STRIP001 			}
//STRIP001 			break;
//STRIP001 
//STRIP001 	case COMMAND_STARTEXTTEXTINPUT:
//STRIP001 		if( rSh.HasDrawView() && rSh.GetDrawView()->IsTextEdit() )
//STRIP001 		{
//STRIP001 			bCallBase = FALSE;
//STRIP001 			rSh.GetDrawView()->GetTextEditOutlinerView()->Command( rCEvt );
//STRIP001 		}
//STRIP001 		else
//STRIP001 		{
//STRIP001 			if( rSh.HasSelection() )
//STRIP001 				rSh.DelRight();
//STRIP001 
//STRIP001 			bCallBase = FALSE;
//STRIP001 			rSh.CreateExtTextInput();
//STRIP001 		}
//STRIP001 		break;
//STRIP001 
//STRIP001 	case COMMAND_ENDEXTTEXTINPUT:
//STRIP001 		if( rSh.HasDrawView() && rSh.GetDrawView()->IsTextEdit() )
//STRIP001 		{
//STRIP001 			bCallBase = FALSE;
//STRIP001 			rSh.GetDrawView()->GetTextEditOutlinerView()->Command( rCEvt );
//STRIP001 		}
//STRIP001 		else
//STRIP001 		{
//STRIP001 			bCallBase = FALSE;
//STRIP001             String sRecord = rSh.DeleteExtTextInput();
//STRIP001             ::com::sun::star::uno::Reference< ::com::sun::star::frame::XDispatchRecorder > xRecorder =
//STRIP001                     rView.GetViewFrame()->GetBindings().GetRecorder();
//STRIP001             
//STRIP001             if ( sRecord.Len() )
//STRIP001             {
//STRIP001                 // #102812# convert quotes in IME text
//STRIP001                 // works on the last input character, this is escpecially in Korean text often done
//STRIP001                 // quotes that are inside of the string are not replaced!
//STRIP001                 const sal_Unicode aCh = sRecord.GetChar(sRecord.Len() - 1);
//STRIP001                 OfaAutoCorrCfg* pACfg = OFF_APP()->GetAutoCorrConfig();
//STRIP001                 SvxAutoCorrect* pACorr = pACfg->GetAutoCorrect();
//STRIP001                 if(pACorr && 
//STRIP001                     ( pACorr->IsAutoCorrFlag( ChgQuotes ) && ('\"' == aCh ))||
//STRIP001                     ( pACorr->IsAutoCorrFlag( ChgSglQuotes ) && ( '\'' == aCh)))
//STRIP001                 {
//STRIP001                     rSh.DelLeft();
//STRIP001                     rSh.AutoCorrect( *pACorr, aCh );
//STRIP001                 }        
//STRIP001             
//STRIP001             if ( xRecorder.is() )
//STRIP001             {
//STRIP001                 //Shell ermitteln
//STRIP001                 SfxShell *pSfxShell = lcl_GetShellFromDispatcher( rView, TYPE(SwTextShell) );
//STRIP001                 // Request generieren und recorden
//STRIP001                 if (pSfxShell)
//STRIP001                 {
//STRIP001                     SfxRequest aReq( rView.GetViewFrame(), FN_INSERT_STRING );
//STRIP001                     aReq.AppendItem( SfxStringItem( FN_INSERT_STRING, sRecord ) );
//STRIP001                     aReq.Done();
//STRIP001                 }
//STRIP001             }
//STRIP001             }
//STRIP001 		}
//STRIP001 		break;
//STRIP001 
//STRIP001 	case COMMAND_EXTTEXTINPUT:
//STRIP001     {
//STRIP001         QuickHelpData aTmpQHD;
//STRIP001         if( pQuickHlpData->bClear )
//STRIP001         {
//STRIP001             aTmpQHD.Move( *pQuickHlpData );
//STRIP001             pQuickHlpData->Stop( rSh );
//STRIP001         }
//STRIP001         String sWord;
//STRIP001 		if( rSh.HasDrawView() && rSh.GetDrawView()->IsTextEdit() )
//STRIP001 		{
//STRIP001 			bCallBase = FALSE;
//STRIP001 			rSh.GetDrawView()->GetTextEditOutlinerView()->Command( rCEvt );
//STRIP001 		}
//STRIP001 		else
//STRIP001 		{
//STRIP001 			const CommandExtTextInputData* pData = rCEvt.GetExtTextInputData();
//STRIP001 			if( pData )
//STRIP001 			{
//STRIP001                 sWord = pData->GetText();
//STRIP001                 bCallBase = FALSE;
//STRIP001 				rSh.SetExtTextInputData( *pData );
//STRIP001 			}
//STRIP001 		}
//STRIP001             ::com::sun::star::uno::Reference< ::com::sun::star::frame::XDispatchRecorder > xRecorder =
//STRIP001                     rView.GetViewFrame()->GetBindings().GetRecorder();
//STRIP001             if(!xRecorder.is())
//STRIP001             {       
//STRIP001                 OfaAutoCorrCfg* pACfg = OFF_APP()->GetAutoCorrConfig();
//STRIP001                 SvxAutoCorrect* pACorr = pACfg->GetAutoCorrect();
//STRIP001                 if( pACfg && pACorr &&
//STRIP001                     ( pACfg->IsAutoTextTip() ||
//STRIP001                       pACorr->GetSwFlags().bAutoCompleteWords ) &&
//STRIP001                     rSh.GetPrevAutoCorrWord( *pACorr, sWord ) )
//STRIP001                 {
//STRIP001                     ShowAutoTextCorrectQuickHelp(sWord, pACfg, pACorr);
//STRIP001                 }
//STRIP001             }
//STRIP001         }
//STRIP001 		break;
//STRIP001 
//STRIP001 	case COMMAND_CURSORPOS:
//STRIP001 		// will be handled by the base class
//STRIP001 		break;
//STRIP001 
//STRIP001 	case COMMAND_PASTESELECTION:
//STRIP001 		if( !rView.GetDocShell()->IsReadOnly() )
//STRIP001 		{
//STRIP001 			TransferableDataHelper aDataHelper(
//STRIP001 						TransferableDataHelper::CreateFromSelection( this ));
//STRIP001 			if( !aDataHelper.GetXTransferable().is() )
//STRIP001 				break;
//STRIP001 
//STRIP001 			ULONG nDropFormat;
//STRIP001 			USHORT nEventAction, nDropAction, nDropDestination;
//STRIP001 			nDropDestination = GetDropDestination( rCEvt.GetMousePosPixel() );
//STRIP001 			if( !nDropDestination )
//STRIP001 				break;
//STRIP001 
//STRIP001 			nDropAction = SotExchange::GetExchangeAction(
//STRIP001 								aDataHelper.GetDataFlavorExVector(),
//STRIP001 								nDropDestination, EXCHG_IN_ACTION_COPY,
//STRIP001 								EXCHG_IN_ACTION_COPY, nDropFormat,
//STRIP001 								nEventAction );
//STRIP001 			if( EXCHG_INOUT_ACTION_NONE != nDropAction )
//STRIP001 			{
//STRIP001 				const Point aDocPt( PixelToLogic( rCEvt.GetMousePosPixel() ) );
//STRIP001 				SwTransferable::PasteData( aDataHelper, rSh, nDropAction,
//STRIP001 									nDropFormat, nDropDestination, FALSE,
//STRIP001 									FALSE, &aDocPt, EXCHG_IN_ACTION_COPY,
//STRIP001 									TRUE );
//STRIP001 			}
//STRIP001 		}
//STRIP001 		break;
//STRIP001         case COMMAND_MODKEYCHANGE :
//STRIP001         {    
//STRIP001             const CommandModKeyData* pCommandData = (const CommandModKeyData*)rCEvt.GetData();
//STRIP001             if(pCommandData->IsMod1() && !pCommandData->IsMod2())
//STRIP001             {
//STRIP001                 USHORT nSlot = 0;
//STRIP001                 if(pCommandData->IsLeftShift() && !pCommandData->IsRightShift())
//STRIP001                     nSlot = SID_ATTR_PARA_LEFT_TO_RIGHT;
//STRIP001                 else if(!pCommandData->IsLeftShift() && pCommandData->IsRightShift())
//STRIP001                     nSlot = SID_ATTR_PARA_RIGHT_TO_LEFT;
//STRIP001                 if(nSlot && SW_MOD()->GetCTLOptions().IsCTLFontEnabled())
//STRIP001                     GetView().GetViewFrame()->GetDispatcher()->Execute(nSlot);
//STRIP001             }        
//STRIP001         }
//STRIP001         break;
//STRIP001 
//STRIP001 #ifdef DBG_UTIL
//STRIP001 		default:
//STRIP001 			ASSERT( !this, "unknown command." );
//STRIP001 #endif
//STRIP001 	}
//STRIP001 	if (bCallBase)
//STRIP001 		Window::Command(rCEvt);
//STRIP001 }
//STRIP001 
//STRIP001 
//STRIP001 
//STRIP001 SfxShell* lcl_GetShellFromDispatcher( SwView& rView, TypeId nType )
//STRIP001 {
//STRIP001 	//Shell ermitteln
//STRIP001 	SfxShell* pShell;
//STRIP001 	SfxDispatcher* pDispatcher = rView.GetViewFrame()->GetDispatcher();
//STRIP001 	for(int  i = 0; TRUE; ++i )
//STRIP001 	{
//STRIP001 		pShell = pDispatcher->GetShell( i );
//STRIP001 		if( !pShell || pShell->IsA( nType ) )
//STRIP001 			break;
//STRIP001 	}
//STRIP001 	return pShell;
//STRIP001 }
//STRIP001 
//STRIP001 
//STRIP001 
//STRIP001 void SwEditWin::ClearTip()
//STRIP001 {
//STRIP001 }
//STRIP001 
/*N*/ IMPL_LINK( SwEditWin, KeyInputFlushHandler, Timer *, EMPTYARG )
/*N*/ {DBG_BF_ASSERT(0, "STRIP"); //STRIP001 
//STRIP001 /*N*/ 	FlushInBuffer( &rView.GetWrtShell() );
/*N*/ 	return 0;
/*N*/ }
//STRIP001 
//STRIP001 
/*N*/ IMPL_LINK( SwEditWin, KeyInputTimerHandler, Timer *, EMPTYARG )
/*N*/ {
/*N*/ 	bTblInsDelMode = FALSE;
/*N*/ 	return 0;
/*N*/ }

/*N*/ void SwEditWin::_InitStaticData()
/*N*/ {
/*N*/ 	pQuickHlpData = new QuickHelpData();
/*N*/ }
/*N*/ 
/*N*/ void SwEditWin::_FinitStaticData()
/*N*/ {
/*N*/ 	delete pQuickHlpData;
/*N*/ }
 /* -----------------23.01.2003 12:15-----------------
 * #i3370# remove quick help to prevent saving 
 * of autocorrection suggestions
 * --------------------------------------------------*/
/*N*/ void SwEditWin::StopQuickHelp()
/*N*/ {
/*N*/     if( HasFocus() && pQuickHlpData && pQuickHlpData->bClear  )
/*?*/         {DBG_BF_ASSERT(0, "STRIP"); }//STRIP001 pQuickHlpData->Stop( rView.GetWrtShell() );
/*N*/ }        

/*-----------------23.02.97 18:39-------------------

--------------------------------------------------*/


/*N*/ IMPL_LINK(SwEditWin, TemplateTimerHdl, Timer*, EMPTYARG)
/*N*/ {DBG_BF_ASSERT(0, "STRIP"); //STRIP001 
//STRIP001 /*N*/ 	SetApplyTemplate(SwApplyTemplate());
/*N*/ 	return 0;
/*N*/ }


//STRIP001 void SwEditWin::SetChainMode( BOOL bOn )
//STRIP001 {
//STRIP001 	if ( !bChainMode )
//STRIP001 		StopInsFrm();
//STRIP001 	if ( pUserMarker )
//STRIP001 	{
//STRIP001 		DELETEZ( pUserMarker );
//STRIP001 	}
//STRIP001 	bChainMode = bOn;
//STRIP001 	if ( !bChainMode )
//STRIP001 		rView.GetViewFrame()->HideStatusText();
//STRIP001 
//STRIP001 	static USHORT __READONLY_DATA aInva[] =
//STRIP001 	{
//STRIP001 		FN_FRAME_CHAIN, FN_FRAME_UNCHAIN, 0
//STRIP001 	};
//STRIP001 	rView.GetViewFrame()->GetBindings().Invalidate(aInva);
//STRIP001 }
//STRIP001 
//STRIP001 #ifdef ACCESSIBLE_LAYOUT
//STRIP001 ::com::sun::star::uno::Reference< ::com::sun::star::accessibility::XAccessible > SwEditWin::CreateAccessible()
//STRIP001 {
//STRIP001 	vos::OGuard aGuard(Application::GetSolarMutex());	// this should have
//STRIP001 														// happend already!!!
//STRIP001 	SwWrtShell *pSh = rView.GetWrtShellPtr();
//STRIP001 	ASSERT( pSh, "no writer shell, no accessible object" );
//STRIP001 	::com::sun::star::uno::Reference<
//STRIP001 		::com::sun::star::accessibility::XAccessible > xAcc;
//STRIP001 	if(	pSh )
//STRIP001 		xAcc = pSh->CreateAccessible();
//STRIP001 
//STRIP001 	return xAcc;
//STRIP001 }
//STRIP001 #endif
//STRIP001 
//STRIP001 //-------------------------------------------------------------
//STRIP001 
//STRIP001 void QuickHelpData::Move( QuickHelpData& rCpy )
//STRIP001 {
//STRIP001 	// Pointer verschieben
//STRIP001 	aArr.Insert( &rCpy.aArr );
//STRIP001 	rCpy.aArr.Remove( (USHORT)0, rCpy.aArr.Count() );
//STRIP001 //	nTipId = rCpy.nTipId;
//STRIP001 	bClear = rCpy.bClear;
//STRIP001 	nLen = rCpy.nLen;
//STRIP001 	nCurArrPos = rCpy.nCurArrPos;
//STRIP001 	bChkInsBlank = rCpy.bChkInsBlank;
//STRIP001 	bIsTip = rCpy.bIsTip;
//STRIP001 	bIsAutoText = rCpy.bIsAutoText;
//STRIP001 
//STRIP001 	if( pCETID ) delete pCETID;
//STRIP001 	pCETID = rCpy.pCETID;
//STRIP001 	rCpy.pCETID = 0;
//STRIP001 
//STRIP001     if( pAttrs )
//STRIP001         delete[] pAttrs;
//STRIP001 	pAttrs = rCpy.pAttrs;
//STRIP001 	rCpy.pAttrs = 0;
//STRIP001 }

/*N*/ void QuickHelpData::ClearCntnt()
/*N*/ {
/*N*/ 	nLen = nCurArrPos = 0;
/*N*/ 	bClear = bChkInsBlank = FALSE;
/*N*/ 	nTipId = 0;
/*N*/ 	aArr.DeleteAndDestroy( 0 , aArr.Count() );
/*N*/ 	bIsTip = TRUE;
/*N*/ 	bIsAutoText = TRUE;
/*N*/ 	delete pCETID, pCETID = 0;
/*N*/     delete[] pAttrs, pAttrs = 0;
/*N*/ }
/*N*/ 

//STRIP001 void QuickHelpData::Start( SwWrtShell& rSh, USHORT nWrdLen )
//STRIP001 {
//STRIP001 	if( pCETID ) delete pCETID, pCETID = 0;
//STRIP001     if( pAttrs ) delete[] pAttrs, pAttrs = 0;
//STRIP001 
//STRIP001 	if( USHRT_MAX != nWrdLen )
//STRIP001 	{
//STRIP001 		nLen = nWrdLen;
//STRIP001 		nCurArrPos = 0;
//STRIP001 	}
//STRIP001 	bClear = TRUE;
//STRIP001 
//STRIP001 	if( bIsTip )
//STRIP001 	{
//STRIP001 		Window& rWin = rSh.GetView().GetEditWin();
//STRIP001 		Point aPt( rWin.OutputToScreenPixel( rWin.LogicToPixel(
//STRIP001 					rSh.GetCharRect().Pos() )));
//STRIP001 		aPt.Y() -= 3;
//STRIP001 		nTipId = Help::ShowTip( &rWin, Rectangle( aPt, Size( 1, 1 )),
//STRIP001 						*aArr[ nCurArrPos ],
//STRIP001 						QUICKHELP_LEFT | QUICKHELP_BOTTOM );
//STRIP001 	}
//STRIP001 	else
//STRIP001 	{
//STRIP001 		String sStr( *aArr[ nCurArrPos ] );
//STRIP001 		sStr.Erase( 0, nLen );
//STRIP001 		USHORT nL = sStr.Len();
//STRIP001 		pAttrs = new USHORT[ nL ];
//STRIP001 		for( USHORT n = nL; n;  )
//STRIP001 			*(pAttrs + --n ) = EXTTEXTINPUT_ATTR_DOTTEDUNDERLINE |
//STRIP001 								EXTTEXTINPUT_ATTR_HIGHLIGHT;
//STRIP001 		pCETID = new CommandExtTextInputData( sStr, pAttrs, nL,
//STRIP001 												0, 0, 0, FALSE );
//STRIP001 		rSh.CreateExtTextInput();
//STRIP001 		rSh.SetExtTextInputData( *pCETID );
//STRIP001 	}
//STRIP001 }
//STRIP001 
//STRIP001 void QuickHelpData::Stop( SwWrtShell& rSh )
//STRIP001 {
//STRIP001 	if( !bIsTip )
//STRIP001 		rSh.DeleteExtTextInput( 0, FALSE );
//STRIP001 	else if( nTipId )
//STRIP001 		Help::HideTip( nTipId );
//STRIP001 	ClearCntnt();
//STRIP001 }
//STRIP001 
//STRIP001 
//STRIP001 
//STRIP001 void QuickHelpData::FillStrArr( SwWrtShell& rSh, const String& rWord )
//STRIP001 {
//STRIP001 	pCalendarWrapper->LoadDefaultCalendar( rSh.GetCurLang() );
//STRIP001 
//STRIP001 	using namespace ::com::sun::star;
//STRIP001 	{
//STRIP001 		uno::Sequence< i18n::CalendarItem > aNames(
//STRIP001 											pCalendarWrapper->getMonths() );
//STRIP001 		for( int n = 0; n < 2; ++n )
//STRIP001 		{
//STRIP001 			for( long nPos = 0, nEnd = aNames.getLength(); nPos < nEnd; ++nPos )
//STRIP001 			{
//STRIP001 				String sStr( aNames[ nPos ].FullName );
//STRIP001 				if( rWord.Len() + 1 < sStr.Len() &&
//STRIP001 
//STRIP001 //!!! UNICODE: fehlendes interface
//STRIP001 //					pIntl->CompareEqual( rWord, sStr.Copy( 0, rWord.Len() ),
//STRIP001 //								INTN_COMPARE_IGNORECASE ) )
//STRIP001 		            COMPARE_EQUAL == rWord.CompareIgnoreCaseToAscii(
//STRIP001 										sStr, rWord.Len() ))
//STRIP001 				{
//STRIP001 					String* pNew = new String( sStr );
//STRIP001 					if( !aArr.Insert( pNew ) )
//STRIP001 						delete pNew;
//STRIP001 				}
//STRIP001 			}
//STRIP001 			if( !n )                    // get data for the second loop
//STRIP001 				aNames = pCalendarWrapper->getDays();
//STRIP001 		}
//STRIP001 	}
//STRIP001 
//STRIP001 	// and than add all words from the AutoCompleteWord-List
//STRIP001 	const SwAutoCompleteWord& rACLst = rSh.GetAutoCompleteWords();
//STRIP001 	USHORT nStt, nEnd;
//STRIP001 	if( rACLst.GetRange( rWord, nStt, nEnd ) )
//STRIP001 	{
//STRIP001 		while( nStt < nEnd )
//STRIP001 		{
//STRIP001 			const String& rS = rACLst[ nStt ];
//STRIP001 			//JP 16.06.99: Bug 66927 - only if the count of chars
//STRIP001 			//				from the suggest greater as the
//STRIP001 			//				actual word
//STRIP001 			if( rS.Len() > rWord.Len() )
//STRIP001 			{
//STRIP001 				String* pNew = new String( rS );
//STRIP001 				if( !aArr.Insert( pNew ) )
//STRIP001 					delete pNew;
//STRIP001 			}
//STRIP001 			++nStt;
//STRIP001 		}
//STRIP001 	}
//STRIP001 }
//STRIP001 /* -----------------06.11.2002 12:01-----------------
//STRIP001  * 
//STRIP001  * --------------------------------------------------*/
//STRIP001 void SwEditWin::ShowAutoTextCorrectQuickHelp(
//STRIP001         const String& rWord, OfaAutoCorrCfg* pACfg, SvxAutoCorrect* pACorr )
//STRIP001 {
//STRIP001     SwWrtShell& rSh = rView.GetWrtShell();
//STRIP001     pQuickHlpData->ClearCntnt();
//STRIP001     if( pACfg->IsAutoTextTip() )
//STRIP001     {
//STRIP001         SwGlossaryList* pList = ::GetGlossaryList();
//STRIP001         pList->HasLongName( rWord, &pQuickHlpData->aArr );
//STRIP001     }
//STRIP001 
//STRIP001     if( pQuickHlpData->aArr.Count() )
//STRIP001     {
//STRIP001         pQuickHlpData->bIsTip = TRUE;
//STRIP001         pQuickHlpData->bIsAutoText = TRUE;
//STRIP001     }
//STRIP001     else if( pACorr->GetSwFlags().bAutoCompleteWords )
//STRIP001     {
//STRIP001         pQuickHlpData->bIsAutoText = FALSE;
//STRIP001         pQuickHlpData->bIsTip = !pACorr ||
//STRIP001                     pACorr->GetSwFlags().bAutoCmpltShowAsTip;
//STRIP001 
//STRIP001         pQuickHlpData->FillStrArr( rSh, rWord );
//STRIP001     }
//STRIP001 
//STRIP001     if( pQuickHlpData->aArr.Count() )
//STRIP001         pQuickHlpData->Start( rSh, rWord.Len() );
//STRIP001 }        

}
