<?php
/**
*
* install.php [Lithuanian]
*
* @package language
* @version $Id: $
* @copyright (c) 2009 phpBB Group
* @author 2009-12-21 - Vilius Šumskas
* @license http://opensource.org/licenses/gpl-license.php GNU Public License
*
*/

/**
* DO NOT CHANGE
*/
if (!defined('IN_PHPBB'))
{
	exit;
}

if (empty($lang) || !is_array($lang))
{
	$lang = array();
}

// DEVELOPERS PLEASE NOTE
//
// All language files should use UTF-8 as their encoding and the files must not contain a BOM.
//
// Placeholders can now contain order information, e.g. instead of
// 'Page %s of %s' you can (and should) write 'Page %1$s of %2$s', this allows
// translators to re-order the output of data while ensuring it remains correct
//
// You do not need this where single placeholders are used, e.g. 'Message %d' is fine
// equally where a string contains only two placeholders which are used to wrap text
// in a url you again do not need to specify an order e.g., 'Click %sHERE%s' is fine

$lang = array_merge($lang, array(
	'ADMIN_CONFIG'	=> 'Administratoriaus nustatymai',
	'ADMIN_PASSWORD'	=> 'Administratoriaus slaptažodis',
	'ADMIN_PASSWORD_CONFIRM'	=> 'Administratoriaus slaptažodžio patvirtinimas',
	'ADMIN_PASSWORD_EXPLAIN'	=> 'Slaptažodis turi būti nuo 6 iki 30 simbolių ilgio.',
	'ADMIN_TEST'	=> 'Patikrinti administratoriaus nustatymus',
	'ADMIN_USERNAME'	=> 'Administratoriaus vartotojo vardas',
	'ADMIN_USERNAME_EXPLAIN'	=> 'Vartotojo vardas turi būti nuo 3 iki 20 simbolių ilgio.',
	'APP_MAGICK'	=> 'Imagemagick palaikymas [ prikabinamiems failams ]',
	'AUTHOR_NOTES'	=> 'Autoriaus pastabos<br />» %s',
	'AVAILABLE'	=> 'Yra',
	'AVAILABLE_CONVERTORS'	=> 'Galimos konversijos',
	'BEGIN_CONVERT'	=> 'Pradėti konversiją',
	'BLANK_PREFIX_FOUND'	=> 'Aptikta, kad jūsų diskusijų lenta įdiegta be duomenų bazės lentelių prefikso.',
	'BOARD_NOT_INSTALLED'	=> 'Nerasta jokių įdiegtų diskusijų lentų.',
	'BOARD_NOT_INSTALLED_EXPLAIN'	=> 'phpBB Unifikuotam Konversijos Mechanizmui funkcionuoti reikalinga įdiegta phpBB3 diskusijų lenta. Prašome iš pradžių <a href="%s">įdiegti phpBB3</a>.',
	'CATEGORY'	=> 'Kategorija',
	'CACHE_STORE'	=> 'Spartinančiųjų duomenų tipas',
	'CACHE_STORE_EXPLAIN'	=> 'Fizinė vieta kur bus saugomi spartinantieji duomenys. Pageidautina kad tai būtų failų sistema.',
	'CAT_CONVERT'	=> 'Konversija',
	'CAT_INSTALL'	=> 'Diegimas',
	'CAT_OVERVIEW'	=> 'Bendra informacija',
	'CAT_UPDATE'	=> 'Atnaujinimas',
	'CHANGE'	=> 'Keisti',
	'CHECK_TABLE_PREFIX'	=> 'Patikrinkite duomenų bazės lentelių prefiksą ir pabandykite dar kartą.',
	'CLEAN_VERIFY'	=> 'Valoma ir tikrinama galutinė struktūra',
	'CLEANING_USERNAMES'	=> 'Valomi vartotojų vardai',
	'COLLIDING_CLEAN_USERNAME'	=> '<strong>%s</strong> atitinka vartotojų vardus:',
	'COLLIDING_USERNAMES_FOUND'	=> 'Senojoje diskusijų lentoje rasta keletas vartotojų vardų, kurie yra panašūs arba sutampa. Norėdami baigti konversiją ištrinkite arba pervadinkite šiuos vartotojų vardus.',
	'COLLIDING_USER'	=> '» vartotojo id: <strong>%d</strong> vartotojo vardas: <strong>%s</strong> (%d pranešimai)',
	'CONFIG_CONVERT'	=> 'Konfigūracijos konversija',
	'CONFIG_FILE_UNABLE_WRITE'	=> 'Nepavyko įrašyti konfigūracijos failo. Apačioje galite pasirinkti kitokį šio failo rašymo metodą.',
	'CONFIG_FILE_WRITTEN'	=> 'Konfigūracijos failas įrašytas. Galite tęsti diegimo procesą.',
	'CONFIG_PHPBB_EMPTY'	=> 'phpBB3 kintamasis “%s” yra tuščias.',
	'CONFIG_RETRY'	=> 'Bandyti dar kartą',
	'CONTACT_EMAIL_CONFIRM'	=> 'Patvirtinti kontaktinį el. pašto adresą',
	'CONTINUE_CONVERT'	=> 'Tęsti konversiją',
	'CONTINUE_CONVERT_BODY'	=> 'Aptiktas ankstesnis mėginimas konvertuoti šią diskusijų lentą. Galite pasirinkti arba tęsti ankstesnį mėginimą, arba pradėti konversiją iš naujo.',
	'CONTINUE_LAST'	=> 'Tęsti paskutiniu sakinius',
	'CONTINUE_OLD_CONVERSION'	=> 'Tęsti ankstesnį mėginimą konvertuoti',
	'CONVERT'	=> 'Konvertuoti',
	'CONVERT_COMPLETE'	=> 'Konversija baigta',
	'CONVERT_COMPLETE_EXPLAIN'	=> 'Jūsų diskusijų lenta sėkmingai konvertuota į phpBB 3.0. Galite <a href="../">prisijungti prie diskusijų lentos</a>. Prieš ištrinant diegimo katalogą ir įjungiant jūsų diskusijų lentą įsitikinkite, kad visi nustatymai buvo sėkmingai perkelti. Atsiminkite, kad pagalbą kaip naudoti phpBB galite rasti <a href="http://www.phpbb.com/support/documentation/3.0/">dokumentacijos puslapyje</a> ir <a href="http://www.phpbb.com/community/viewforum.php?f=46">palaikymo forumuose</a>.',
	'CONVERT_INTRO'	=> 'Sveiki atvykę į phpBB Unifikuotą Konversijos Mechanizmą',
	'CONVERT_INTRO_BODY'	=> 'Iš čia galite perkelti duomenis iš kitų (įdiegtų) diskusijų lentų. Sąrašas apačioje rodo visus šiuo metu galimus konversijos modulius. Jeigu tarp jų nerandate savo naudojamos lentos modulio, apsilankykite mūsų puslapyje, kur galbūt rasite jums reikiamą modulį.',
	'CONVERT_NEW_CONVERSION'	=> 'Pradėti konversiją iš naujo',
	'CONVERT_NOT_EXIST'	=> 'Toks konversijos modulis neegzistuoja.',
	'CONVERT_OPTIONS'	=> 'Galimybės',
	'CONVERT_SETTINGS_VERIFIED'	=> 'Informacija, kurią įrašėte, patikrinta. Norėdami pradėti konversijos procesą paspauskite mygtuką apačioje.',
	'CONV_ERR_FATAL'	=> 'Kritinė konversijos klaida',
	'CONV_ERROR_ATTACH_FTP_DIR'	=> 'Senojoje diskusijų lentoje yra įjungta galimybė prikabinti failus FTP įkėlimo būdu. Išjunkite FTP įkėlimo galimybę ir nustatykite teisingą įkėlimo katalogą, tada į ją perkopijuokite visus prikabintus failus. Kai tai padarysite, paleiskite konversiją iš naujo.',
	'CONV_ERROR_CONFIG_EMPTY'	=> 'Konfigūracijos failas tuščias.',
	'CONV_ERROR_FORUM_ACCESS'	=> 'Nepavyko gauti informacijos apie forumo teises.',
	'CONV_ERROR_GET_CATEGORIES'	=> 'Nepavyko gauti informacijos apie kategorijos.',
	'CONV_ERROR_GET_CONFIG'	=> 'Nepavyko perskaityti diskusijų lentos konfigūracijos failo.',
	'CONV_ERROR_COULD_NOT_READ'	=> 'Nepavyko perskaityti “%s”.',
	'CONV_ERROR_GROUP_ACCESS'	=> 'Nepavyko gauti informacijos apie grupes.',
	'CONV_ERROR_INCONSISTENT_GROUPS'	=> 'Funkcija add_bots() aptiko neatitikimų grupių lentelėje. Visas specialias grupes jums reikės pridėti patiems.',
	'CONV_ERROR_INSERT_BOT'	=> 'Nepavyko įrašyti roboto į "users" lentelę.',
	'CONV_ERROR_INSERT_BOTGROUP'	=> 'Nepavyko įrašyti roboto į "bots" lentelę.',
	'CONV_ERROR_INSERT_USER_GROUP'	=> 'Nepavyko įrašyti vartotojo į "user_group" lentelę.',
	'CONV_ERROR_MESSAGE_PARSER'	=> 'Žinučių apdorojimo klaida',
	'CONV_ERROR_NO_AVATAR_PATH'	=> 'Pastaba kūrėjams: norėdami naudoti %s, turite aprašyti $convertor[\'avatar_path\'].',
	'CONV_ERROR_NO_FORUM_PATH'	=> 'Nenurodytas kelias iki senosios diskusijų lentos.',
	'CONV_ERROR_NO_GALLERY_PATH'	=> 'Pastaba kūrėjams: norėdami naudoti %s, turite aprašyti $convertor[\'avatar_gallery_path\'].',
	'CONV_ERROR_NO_GROUP'	=> '%2$s nėra grupės “%1$s”.',
	'CONV_ERROR_NO_RANKS_PATH'	=> 'Pastaba kūrėjams: norėdami naudoti %s, turite aprašyti $convertor[\'ranks_path\'].',
	'CONV_ERROR_NO_SMILIES_PATH'	=> 'Pastaba kūrėjams: norėdami naudoti %s, turite aprašyti $convertor[\'smilies_path\'].',
	'CONV_ERROR_NO_UPLOAD_DIR'	=> 'Pastaba kūrėjams: norėdami naudoti %s, turite aprašyti $convertor[\'upload_path\'].',
	'CONV_ERROR_PERM_SETTING'	=> 'Nepavyko įrašyti/atnaujinti teisių nustatymų.',
	'CONV_ERROR_PM_COUNT'	=> 'Nepavyko parinkti katalogo žinučių skaičiaus.',
	'CONV_ERROR_REPLACE_CATEGORY'	=> 'Nepavyko įrašyti naujo forumo vietoj senos kategorijos.',
	'CONV_ERROR_REPLACE_FORUM'	=> 'Nepavyko įrašyti naujo forumo vietoj senojo.',
	'CONV_ERROR_USER_ACCESS'	=> 'Nepavyko gauti informacijos apie vartotojo teises.',
	'CONV_ERROR_WRONG_GROUP'	=> '%2$s aprašyta neteisinga grupės “%1$s”.',
	'CONV_OPTIONS_BODY'	=> 'Šiame puslapyje turite įrašyti diskusijų lentos, iš kurios konvertuojate, duomenis. Užpildykite tos diskusijų lentos duomenų bazės laukus; konversijos procesas nieko nekeis nurodytoje duomenų bazėje. Geriau, kad diskusijų lenta, iš kurios konvertuojate, būtų išjungta.',
	'CONV_SAVED_MESSAGES'	=> 'Išsaugotos žinutės',
	'COULD_NOT_COPY'	=> 'Nepavyko nukopijuoti failo <strong>%1$s</strong> į <strong>%2$s</strong><br /><br />Patikrinkite ar katalogas į kurį norite rašyti egzistuoja ir ar interneto serveris turi teises į jį rašyti.',
	'COULD_NOT_FIND_PATH'	=> 'Nepavyko aptikti senosios diskusijų lentos. Patikrinkite visus nustatymus ir pabandykite dar kartą.<br />» Kaip šaltinio kelią jūs nurodėte %s.',
	'DBMS'	=> 'Duomenų bazės tipas',
	'DB_CONFIG'	=> 'Duomenų bazės nustatymai',
	'DB_CONNECTION'	=> 'Prisijungimas prie duomenų bazės',
	'DB_ERR_INSERT'	=> 'Klaida vykdant <code>INSERT</code> užklausą.',
	'DB_ERR_LAST'	=> 'Klaida vykdant <var>query_last</var>.',
	'DB_ERR_QUERY_FIRST'	=> 'Klaida vykdant <var>query_first</var>.',
	'DB_ERR_QUERY_FIRST_TABLE'	=> 'Klaida vykdant <var>query_first</var>, %s (“%s”).',
	'DB_ERR_SELECT'	=> 'Klaida vykdant <code>SELECT</code> užklausą.',
	'DB_HOST'	=> 'Duomenų bazės serverio vardas arba DŠV',
	'DB_HOST_EXPLAIN'	=> 'DŠV yra Duomenų Šaltinio Vardas (DSN) ir svarbus tik naudojant ODBC.',
	'DB_NAME'	=> 'Duomenų bazės pavadinimas',
	'DB_PASSWORD'	=> 'Duomenų bazės slaptažodis',
	'DB_PORT'	=> 'Duomenų bazės serverio portas',
	'DB_PORT_EXPLAIN'	=> 'Palikite tuščią, nebent žinote, kad jūsų serveris veikia nestandartiniu portu.',
	'DB_UPDATE_NOT_SUPPORTED'	=> 'Atsiprašome, bet šis skriptas negali atnaujinti ankstesnių nei “%1$s” phpBB versijų. Pas jus šiuo metu įdiegta “%2$s” versija. Atnaujinkite ją į žemesnį versiją ir tik tada bandykite atnaujinti į šią. Pagalbos dėl to galite kreiptis į palaikymo forumą phpBB.com puslapyje.',
	'DB_USERNAME'	=> 'Duomenų bazės vartotojo vardas',
	'DB_TEST'	=> 'Patikrinti ryšį',
	'DEFAULT_LANG'	=> 'Standartinė diskusijų lentos kalba',
	'DEFAULT_PREFIX_IS'	=> 'Konversijos modulis nerado duomenų bazės lentelių su nurodytu prefiksu. Įsitikinkite, kad įvedėte teisingus duomenis apie senąją diskusijų lentą. Standartinis %1$s lentelių prefiksas yra <strong>%2$s</strong>.',
	'DEV_NO_TEST_FILE'	=> 'Konversijos modulyje neaprašytas test_file kintamasis. Jeigu esate tik vartotojas, jūs neturėtumėte matyti šios klaidos. Informuokite apie tai konversijos modulio autorių. Jeigu esate modulio autorius, turite įrašyti failo, kuris egzistuoja senojoje diskusijų lentoje, pavadinimą, kad galima būtų patikrinti kelia iki jo.',
	'DIRECTORIES_AND_FILES'	=> 'Katalogų ir failų nustatymai',
	'DISABLE_KEYS'	=> 'Raktai išjungiami',
	'DLL_FIREBIRD'	=> 'Firebird',
	'DLL_FTP'	=> 'Nuotolinis FTP palaikymas [ diegimui ]',
	'DLL_GD'	=> 'GD palaikymas [ vizualiam patvirtinimui ]',
	'DLL_MBSTRING'	=> 'Daugiabaičių simbolių palaikymas',
	'DLL_MSSQL'	=> 'MSSQL Server 2000+',
	'DLL_MSSQL_ODBC'	=> 'MSSQL Server 2000+ per ODBC',
	'DLL_MYSQL'	=> 'MySQL',
	'DLL_MYSQLI'	=> 'MySQL su MySQLi moduliu',
	'DLL_ORACLE'	=> 'Oracle',
	'DLL_POSTGRES'	=> 'PostgreSQL 7.x/8.x',
	'DLL_SQLITE'	=> 'SQLite',
	'DLL_XML'	=> 'XML palaikymas [ Jabber ]',
	'DLL_ZLIB'	=> 'zlib kompresijos palaikymas [ gz, .tar.gz, .zip ]',
	'DL_CONFIG'	=> 'Konfigūracijos failo atsisiuntimas',
	'DL_CONFIG_EXPLAIN'	=> 'Jūs galite atsisiųsti visą config.php į savo kompiuterį. Tada galėsite patys įkelti failą į pagrindinį phpBB 3.0 katalogą perrašant bet kokį esamą config.php failą. Neužmirškite, kad failą reikia įkelti ASCII formatu (jeigu nelabai žinote, kaip tai padaryti, skaitykite savo FTP kliento dokumentaciją). Kai baigsite įkėlinėti config.php failą paspauskite “Baigta” ir tęskite diegimo procesą.',
	'DL_DOWNLOAD'	=> 'Atsisiųsti',
	'DONE'	=> 'Baigta',
	'ENABLE_KEYS'	=> 'Raktai įjungiami vėl. Tai gali užtrukti.',
	'FILES_OPTIONAL'	=> 'Kiti failai ir katalogai',
	'FILES_OPTIONAL_EXPLAIN'	=> '<strong>Kiti</strong> - Šie failai, katalogai ar teisių nustatymai yra neprivalomi. Diegimo sistema pabandys juos sukurti, jeigu jie neegzistuoja arba negalima į juos rašyti. Tačiau, jeigu viską nurodysite teisingai, tai gali pagreitinti diegimo procesą.',
	'FILES_REQUIRED'	=> 'Būtini failai ir katalogai',
	'FILES_REQUIRED_EXPLAIN'	=> '<strong>Būtini</strong> - Teisingam phpBB darbui reikalingos skaitymo bei rašymo teisės į tam tikrus failus ir katalogus. Jeigu matote užrašą “Nerasta”, jūs turite sukurti reikiamą failą ar katalogą. Jeigu matote užrašą “Tik skaitymui”, turite pakeistų reikiamo failo ar katalogo teises, kad phpBB galėtų į jį rašyti.',
	'FILLING_TABLE'	=> 'Užpildoma lentelė <strong>%s</strong>',
	'FILLING_TABLES'	=> 'Užpildomos lentelės',
	'FIREBIRD_DBMS_UPDATE_REQUIRED'	=> 'phpBB daugiau nebepalaiko žemesnės nei 2.1 Firebird/Interbase versijos. Prieš tęsdami šį atnaujinimą, atnaujinkite savo Firebird programinę įrangą iki bent 2.1.0 versijos.',
	'FINAL_STEP'	=> 'Vykdyti paskutinį etapą',
	'FORUM_ADDRESS'	=> 'Diskusijų lentos adresas',
	'FORUM_ADDRESS_EXPLAIN'	=> 'Tai yra senasis jūsų diskusijų lentos URL adresas, pavyzdžiui: <samp>http://www.example.com/phpBB2/</samp>. Jeigu čia įrašysite kokį nors adresą, šis adresas kiekviename pranešime, žinutėje ar paraše bus pakeistas į naujos diskusijų lentos adresą.',
	'FORUM_PATH'	=> 'Kelias iki diskusijų lentos ',
	'FORUM_PATH_EXPLAIN'	=> 'Tai yra <strong>tiesioginis</strong> kelias nuo <strong>pagrindinio phpBB3 katalogo</strong> iki senosios diskusijų lentos.',
	'FOUND'	=> 'Surasta',
	'FTP_CONFIG'	=> 'Konfigūracijos failo įkėlimas per FTP',
	'FTP_CONFIG_EXPLAIN'	=> 'Šiame serveryje phpBB rado FTP modulį. Jeigu norite, galite įkelti config.php failą šiuo būdu. Turėsite užpildyti laukus žemiau. Atsiminkite, kad reikia įrašyti FTP serverio vartotojo vardą ir slaptažodį! (jeigu tiksliai nežinote kas tai yra, susisiekite su savo tinklapių talpinimo paslaugų teikėju).',
	'FTP_PATH'	=> 'FTP kelias',
	'FTP_PATH_EXPLAIN'	=> 'Kelias nuo jūsų pagrindinio katalogo iki phpBB pagrindinio katalogo, pvz.: <samp>htdocs/phpBB3/</samp>.',
	'FTP_UPLOAD'	=> 'Įkelti',
	'GPL'	=> 'Bendroji Vieša Licencija',
	'INITIAL_CONFIG'	=> 'Pagrindiniai nustatymai',
	'INITIAL_CONFIG_EXPLAIN'	=> 'Dabar, kai jau žinoma kad jūsų serveris palaiko phpBB, turite įrašyti kai kuriuos duomenis. Jeigu nežinote kaip prisijungti prie savo duomenų bazės, visų pirma susisiekite su savo tinklapių talpinimo paslaugų teikėju arba pasinaudokite phpBB palaikymo forumais. Kai įrašysite visus duomenis patikrinkite ar jie teisingi ir tik tada tęskite diegimo procesą.',
	'INSTALL_CONGRATS'	=> 'Sveikiname!',
	'INSTALL_CONGRATS_EXPLAIN'	=> '		Jūs sėkmingai įdiegėte phpBB %1$s. Dabar turite keletą pasirinkimų ką daryti toliau:</p>
		<h2>Konvertuoti esamą senąją diskusijų lentą į phpBB3</h2>
		<p>phpBB Unifikuoto Konversijos Mechanizmo pagalba galite konvertuoti tiek phpBB 2.0.x tiek kitas diskusijų lentas į phpBB3. Jeigu turite tokią diskusijų lentą, <a href="%2$s">pradėkite konversijos procesą</a>.</p>
		<h2>Paleisti phpBB3!</h2>
		<p>Paspaudę mygtuką apačioje pateksite į puslapį administratoriaus valdymo pulte, kur galėsite išsiųsti statistinius duomenis phpBB kūrėjams. Būtume už tai labai dėkingi. Vėliau, nepagailėkite laiko ir peržiūrėkite visus esamus nustatymus. Atsiminkite, kad pagalbą galite rasti <a href="http://www.phpbb.com/support/documentation/3.0/">dokumentacijos puslapyje</a>, <a href="%3$s">README</a> faile bei <a href="http://www.phpbb.com/community/viewforum.php?f=46">palaikymo forumuose</a>.</p><p><strong>Dabar turite ištrinti, perkelti arba pervadinti įdiegimo katalogą (install). Jeigu to nepadarysite, bus prieinamas tik administratoriaus valdymo pultas.</strong>',
	'INSTALL_INTRO'	=> 'Sveiki atvykę į diegimo proceso pradžią',
	'INSTALL_INTRO_BODY'	=> 'Šio proceso pagalba galite įdiegti phpBB3 savo serveryje.</p><p>Norėdami tęsti, turėsite įrašyti duomenų bazės nustatymus. Jeigu jų nežinote, susisiekite su savo tinklapių talpinimo paslaugų teikėju ir paklauskite. Be šių nustatymų jūs negalėsite tęsti diegimo. Jums prireiks:</p>

	<ul>
		<li>Duomenų bazės tipo.</li>
		<li>Duomenų bazės serverio pavadinimo arba DŠV (DSN).</li>
		<li>Duomenų bazės serverio porto (daugeliu atvejų tai nereikalinga).</li>
		<li>Duomenų bazės pavadinimo.</li>
		<li>Duomenų bazės vartotojo vardo bei slaptažodžio.</li>
	</ul>

	<p><strong>Pastaba:</strong> Jeigu naudojate SQLite, turite įrašyti pilną kelią iki duomenų bazės failo DŠV laukelyje, o vartotojo vardo ir slaptažodžio laukelius palikti tuščius. Saugumo sumetimais turite įsitikinti, kad duomenų bazės failas nėra prieinamas iš išorės per internetinį serverį.</p>

	<p>phpBB3 palaiko šias duomenų bazes:</p>
	<ul>
		<li>MySQL 3.23 arba vėlesnę (MySQLi palaikoma)</li>
		<li>PostgreSQL 7.3+</li>
		<li>SQLite 2.8.2+</li>
		<li>Firebird 2.1+</li>
		<li>MS SQL Server 2000 arba vėlesnę (tiesiogiai per ODBC)</li>
		<li>Oracle</li>
	</ul>
	
	<p>Bus rodomos tik tos duomenų bazės kurias palaiko jūsų serveris.',
	'INSTALL_INTRO_NEXT'	=> 'Norėdami pradėti diegimą, paspauskite mygtuką apačioje.',
	'INSTALL_LOGIN'	=> 'Prisijungti',
	'INSTALL_NEXT'	=> 'Kitas žingsnis',
	'INSTALL_NEXT_FAIL'	=> 'Nepavyko atlikti kai kurių testų. Ištaisykite iškilusias problemas ir tik tada tęskite diegimo procesą. Priešingu atveju diegimas gali nepavykti.',
	'INSTALL_NEXT_PASS'	=> 'Visi pradiniai testai atlikti. Galite tęsti diegimo procesą. Jeigu pakeitėte kokias nors teises, modulius ar panašiai ir norite dar kartą testuoti, galite tai padaryti.',
	'INSTALL_PANEL'	=> 'Diegimo pultas',
	'INSTALL_SEND_CONFIG'	=> 'Deja phpBB negali rašyti į config.php failą. Taip yra todėl, kad failas neegzistuoja arba nėra rašymo teisių. Apačioje galėsite matyti keletą pasirinkimų kaip baigti config.php diegimą.',
	'INSTALL_START'	=> 'Pradėti diegimą',
	'INSTALL_TEST'	=> 'Testuoti dar kartą',
	'INST_ERR'	=> 'Diegimo klaida',
	'INST_ERR_DB_CONNECT'	=> 'Nepavyko prisijungti prie duomenų bazės. Žemiau galite perskaityti klaidos pranešimą.',
	'INST_ERR_DB_FORUM_PATH'	=> 'Nurodytas duomenų bazės failas yra jūsų diskusijų lentos katalogų medyje. Jūs turėtumėte padėti šį failą į internetiniam serveriui neprieinamą vietą.',
	'INST_ERR_DB_NO_ERROR'	=> 'Klaida be pranešimo.',
	'INST_ERR_DB_NO_MYSQLI'	=> 'MySQL versija jūsų serveryje yra nesuderinta su “MySQL su MySQLi moduliu” nustatymu kurį pasirinkote. Bandykite pasirinkti “MySQL”.',
	'INST_ERR_DB_NO_SQLITE'	=> 'SQLite modulis yra per senas. Reikia bent 2.8.2 versijos.',
	'INST_ERR_DB_NO_ORACLE'	=> 'Šiai Oracle versijai jūsų serveryje reikia nustatyti <var>NLS_CHARACTERSET</var> parametrą į <var>UTF8</var>. Arba atnaujinkite Oracle versiją iki 9.2+, arba pakeiskite šį parametrą.',
	'INST_ERR_DB_NO_FIREBIRD'	=> 'Firebird versija jūsų serveryje yra senesnė nei 2.1. Atnaujinkite į naujesnę versiją.',
	'INST_ERR_DB_NO_FIREBIRD_PS'	=> 'Duomenų bazėje, kurią pasirinkote, puslapio dydis (page size) yra mažesnis nei 8192. Jis turi būti bent 8192.',
	'INST_ERR_DB_NO_POSTGRES'	=> 'Duomenų bazė, kurią pasirinkote, buvo sukurta ne su <var>UNICODE</var> arba <var>UTF8</var> koduote. Pabandykite pasirinkti duomenų bazę su <var>UNICODE</var> arba <var>UTF8</var> koduote.',
	'INST_ERR_DB_NO_NAME'	=> 'Neįrašytas duomenų bazės pavadinimas.',
	'INST_ERR_EMAIL_INVALID'	=> 'Įrašytas el. pašto adresas yra neteisingas.',
	'INST_ERR_EMAIL_MISMATCH'	=> 'El. pašto adresai, kuriuos įrašėte, nesutampa.',
	'INST_ERR_FATAL'	=> 'Kritinė diegimo klaida',
	'INST_ERR_FATAL_DB'	=> 'Įvyko kritinė ir neatstatoma duomenų bazės klaida. Taip atsitiko todėl, kad vartotojas, kurį nurodėte, neturi teisių vykdyti užklausos <code>CREATE TABLES</code> arba <code>INSERT</code> ir panašiai. Smulkesnė informacija apie klaidą rodoma žemiau. Susisiekite su savo tinklapių talpinimo paslaugų teikėju arba kreipkitės į phpBB palaikymo forumus.',
	'INST_ERR_FTP_PATH'	=> 'Nepavyko pakeisti katalogo. Patikrinkite kelią.',
	'INST_ERR_FTP_LOGIN'	=> 'Nepavyko prisijungti prie FTP serverio. Patikrinkite vartotojo vardą bei slaptažodį.',
	'INST_ERR_MISSING_DATA'	=> 'Šiame bloge turite užpildyti visus laukus.',
	'INST_ERR_NO_DB'	=> 'PHP neturi reikiamo modulio pasirinktam duomenų bazės tipui.',
	'INST_ERR_PASSWORD_MISMATCH'	=> 'Slaptažodžiai, kuriuos įrašėte, nesutampa.',
	'INST_ERR_PASSWORD_TOO_LONG'	=> 'Slaptažodis, kurį įrašėte, yra per ilgas. Maksimalus ilgis - 30 simbolių.',
	'INST_ERR_PASSWORD_TOO_SHORT'	=> 'Slaptažodis, kurį įrašėte, yra per trumpas. Minimalus ilgis - 6 simboliai.',
	'INST_ERR_PREFIX'	=> 'Duomenų bazės lentelės su tokiu prefiksu jau egzistuoja. Įrašykite kitokį prefiksą.',
	'INST_ERR_PREFIX_INVALID'	=> 'Duomenų bazės lentelių prefiksas, kurį įrašėte, yra neleistinas jūsų duomenų bazei. Pabandykite ištrinti tokius simbolius kaip brūkšneliai ir kabutės.',
	'INST_ERR_PREFIX_TOO_LONG'	=> 'Duomenų bazės lentelių prefiksas, kurį įrašėte, yra per ilgas. Maksimalus ilgis - %d simboliai(ių).',
	'INST_ERR_USER_TOO_LONG'	=> 'Vartotojo vardas, kurį įrašėte, yra per ilgas. Maksimalus ilgis - 20 simbolių.',
	'INST_ERR_USER_TOO_SHORT'	=> 'Vartotojo vardas, kurį įrašėte, yra per trumpas. Minimalus ilgis - 3 simboliai.',
	'INVALID_PRIMARY_KEY'	=> 'Neleistinas pirminis raktas : %s',
	'LONG_SCRIPT_EXECUTION'	=> 'Tai gali užtrukti... Jokiu būdu nestabdykite skripto vykdymo.',
	'MBSTRING_CHECK'	=> '<samp>mbstring</samp> modulio patikrinimas',
	'MBSTRING_CHECK_EXPLAIN'	=> '<strong>Būtinas</strong> - <samp>mbstring</samp> yra PHP modulis, kuris suteikia daugiabaičių žodžių galimybę. Kai kurios mbstring galimybės yra nesuderintos su phpBB ir turi būti išjungtos.',
	'MBSTRING_FUNC_OVERLOAD'	=> 'Funkcijų perkrovimas',
	'MBSTRING_FUNC_OVERLOAD_EXPLAIN'	=> '<var>mbstring.func_overload</var> turi būti 0 arba 4.',
	'MBSTRING_ENCODING_TRANSLATION'	=> 'Atviras simbolių kodavimas',
	'MBSTRING_ENCODING_TRANSLATION_EXPLAIN'	=> '<var>mbstring.encoding_translation</var> turi būti 0.',
	'MBSTRING_HTTP_INPUT'	=> 'HTTP įeinančio srauto simbolių konversija',
	'MBSTRING_HTTP_INPUT_EXPLAIN'	=> '<var>mbstring.http_input</var> turi būti <samp>pass</samp>.',
	'MBSTRING_HTTP_OUTPUT'	=> 'HTTP išeinančio srauto simbolių konversija',
	'MBSTRING_HTTP_OUTPUT_EXPLAIN'	=> '<var>mbstring.http_output</var> turi būti <samp>pass</samp>.',
	'MAKE_FOLDER_WRITABLE'	=> 'Įsitikinkite, kad šis katalogas egzistuoja ir internetinis serveris turi teises į jį rašyti ir pabandykite dar kartą:<br />»<strong>%s</strong>.',
	'MAKE_FOLDERS_WRITABLE'	=> 'Įsitikinkite, kad šie katalogai egzistuoja ir internetinis serveris turi teises į juos rašyti ir pabandykite dar kartą:<br />»<strong>%s</strong>.',
	'MYSQL_SCHEMA_UPDATE_REQUIRED'	=> 'Jūsų MySQL phpBB duomenų bazės schema yra pasenus. phpBB aptiko MySQL 3.x/4.x schemą, tačiau serveryje veikia MySQL %2$s.<br /><strong>Prieš tęsiant jums reikia atnaujinti schemą.</strong><br /><br />Peržiūrėkite <a href="http://www.phpbb.com/kb/article/doesnt-have-a-default-value-errors/">Žinių Bazės straipsnį apie MySQL schemos atnaujinimą</a>. Jeigu susidūrėte su problemomis, kreipkitės į <a href="http://www.phpbb.com/community/viewforum.php?f=46">mūsų palaikymo forumus</a>.',
	'NAMING_CONFLICT'	=> 'Vardų konfliktas: %s ir %s yra panašūs arba vienodi<br /><br />%s',
	'NEXT_STEP'	=> 'Kitas etapas',
	'NOT_FOUND'	=> 'Nerasta',
	'NOT_UNDERSTAND'	=> 'Nepavyko suprasti %s #%d, lentelė %s (“%s”)',
	'NO_CONVERTORS'	=> 'Konversijos modulių nėra.',
	'NO_CONVERT_SPECIFIED'	=> 'Nepasirinktas joks konversijos modulis.',
	'NO_LOCATION'	=> 'Nepavyko rasti Imagemagick. Jeigu žinote kur jis įdiegtas, galėsite tai įrašyti vėliau per administratoriaus valdymo pultą',
	'NO_TABLES_FOUND'	=> 'Lentelių nėra.',
	'OVERVIEW_BODY'	=> 'Sveiki atvykę į phpBB3!<br /><br />phpBB™ yra populiariausia pasaulyje atviro kodo diskusijų sistema. phpBB3 yra naujausia šios nuo 2000 metų kuriamos sistemos versija. Kaip ir ankstesnės versijos, phpBB3 turi daug galimybių, yra patogi naudojimui, o pagalbą visada suteiks phpBB Komanda. phpBB3 buvo patobulinta tai, kas padarė phpBB2 tokia populiaria, o taip pat pridėta daug dažnai prašytų papildomų galimybių, kurių nebuvo ankstesnėse versijose. Tikimės naujoji versija pateisins jūsų lūkesčius.<br /><br />Šios diegimo sistemos pagalba galėsite įdiegti phpBB3, atnaujinti ją į naujausią versiją, bei konvertuoti iš kitų diskusijų lentų programinės įrangos paketų (įskaitant phpBB2). Norėdami sužinoti daugiau apie phpBB3 diegimą, skaitykite <a href="../docs/INSTALL.html">diegimo vadovą</a>.<br /><br />Jeigu norite perskaityti licenciją arba gauti daugiau informacijos apie teikiamą pagalbą, pasirinkę reikiamą punktą iš meniu kairėje. Norėdami tęsti, pasirinkite reikiamą kortelę viršuje.',
	'PCRE_UTF_SUPPORT'	=> 'PCRE UTF-8 palaikymas',
	'PCRE_UTF_SUPPORT_EXPLAIN'	=> 'phpBB <strong>neveiks</strong> jeigu PHP PCRE modulis yra sukompiliuotas be UTF-8 palaikymo.',
	'PHP_GETIMAGESIZE_SUPPORT'	=> 'PHP getimagesize() funkcija',
	'PHP_GETIMAGESIZE_SUPPORT_EXPLAIN'	=> '<strong>Būtina</strong> - teisingam phpBB funkcionavimui reikalinga getimagesize PHP funkcija.',
	'PHP_OPTIONAL_MODULE'	=> 'Kiti moduliai',
	'PHP_OPTIONAL_MODULE_EXPLAIN'	=> '<strong>Nebūtini</strong> - šie moduliai arba programinė įranga nėra būtini. Tačiau jie suteikia papildomų galimybių.',
	'PHP_SUPPORTED_DB'	=> 'Palaikomos duomenų bazės',
	'PHP_SUPPORTED_DB_EXPLAIN'	=> '<strong>Būtina</strong> - PHP turi palaikyti bent vieną duomenų bazę. Jeigu nerastas nei vienas modulis, susisiekite su savo tinklapių talpinimo paslaugų teikėju arba įdiegtos PHP versijos dokumentaciją.',
	'PHP_REGISTER_GLOBALS'	=> 'PHP <var>register_globals</var> nustatymas yra išjungtas',
	'PHP_REGISTER_GLOBALS_EXPLAIN'	=> 'Jeigu šis nustatymas yra įjungtas phpBB vis tiek veiks. Tačiau, saugumo sumetimais, rekomenduojama register_globals išjungti.',
	'PHP_SAFE_MODE'	=> 'Saugos režimas',
	'PHP_SETTINGS'	=> 'PHP versija ir nustatymai',
	'PHP_SETTINGS_EXPLAIN'	=> '<strong>Būtina</strong> - Jūs turite naudoti bent 4.3.3 PHP versiją. Gali būti, kad jūsų PHP dirba <var>saugos režimu</var>. Tai apribos nuotolinį valdymą ir panašias galimybes.',
	'PHP_URL_FOPEN_SUPPORT'	=> 'PHP <var>allow_url_fopen</var> nustatymas yra įjungtas',
	'PHP_URL_FOPEN_SUPPORT_EXPLAIN'	=> '<strong>Nebūtinas</strong> - šis nustatymas yra nebūtinas, tačiau kai kurios galimybės (tokios kaip nutolę avatarai) be jo neveiks.',
	'PHP_VERSION_REQD'	=> 'PHP versija >= 4.3.3',
	'POST_ID'	=> 'Pranešimo ID',
	'PREFIX_FOUND'	=> 'Aptikta ankščiau įdiegta diskusijų lenta su duomenų bazės lentelių prefiksu <strong>%s</strong>.',
	'PREPROCESS_STEP'	=> 'Vykdomos pirminės užklausos',
	'PRE_CONVERT_COMPLETE'	=> 'Visi pirminiai konversijos etapai baigti sėkmingai. Dabar galite pradėti tikrąjį konversijos procesą. Įsidėmėkite, kad kai kuriuos dalykus turėsite nustatyti patys. Po konversijos proceso patikrinkite vartotojams priskirtas teises, atstatykite paieškos indeksą, taip pat įsitikinkite kad visi failai buvo teisingai perkopijuoti, pavyzdžiui avatarai ir šypsenėlės.',
	'PROCESS_LAST'	=> 'Apdorojamos paskutinės užklausos',
	'REFRESH_PAGE'	=> 'Perkrauti puslapį po kiekvieno konversijos etapo',
	'REFRESH_PAGE_EXPLAIN'	=> 'Jeigu šis nustatymas įjungtas, konversija perkraus puslapį po kiekvieno proceso etapo. Jeigu tai jūsų pirma konversija vykdoma testavimo tikslais, rekomenduojame išjungti šį nustatymą.',
	'REQUIREMENTS_TITLE'	=> 'Diegimo suderinamumas',
	'REQUIREMENTS_EXPLAIN'	=> 'Prieš pradedant diegimo procesą phpBB patikrins jūsų serverio konfigūraciją ir kai kuriuos failus. Įdėmiai perskaitykite kiekvieno testo rezultatus ir tęskite tik tada, kai visi rezultatai yra teigiami. Jeigu norite naudotis galimybėmis, kurios priklauso nuo papildomų testų, turėtumėte atlikti ir juos.',
	'RETRY_WRITE'	=> 'Pakartotinis konfigūracijos rašymas',
	'RETRY_WRITE_EXPLAIN'	=> 'Jeigu norite, galite pakeisti config.php failo teises taip, kad phpBB galėtų į jį rašyti. Visada kai tai norėsite padaryti, galėsite paspausti "Bandyti dar kartą" nuorodos apačioje. Po phpBB diegimo proceso nepamirškite atstatyti config.php teisių į ankščiau buvusias.',
	'SCRIPT_PATH'	=> 'Skripto kelias',
	'SCRIPT_PATH_EXPLAIN'	=> 'Kelias iki phpBB neskaitant domeno vardo, pvz.: <samp>/phpBB3</samp>.',
	'SELECT_LANG'	=> 'Pasirinkite kalbą',
	'SERVER_CONFIG'	=> 'Serverio nustatymai',
	'SEARCH_INDEX_UNCONVERTED'	=> 'Paieškos indeksas nebuvo konvertuotas',
	'SEARCH_INDEX_UNCONVERTED_EXPLAIN'	=> 'Senas paieškos indeksas nebuvo konvertuotas. Paieška naujoje diskusijų lentoje visada gražins tuščią rezultatą. Norėdami sukurti naują paieškos indeksą, eikite į administratoriaus valdymo pultą, pasirinkite Priežiūrą ir iš submeniu pasirinkite Paieškos indekso punktą.',
	'SOFTWARE'	=> 'Diskusijų lentos programinė įranga',
	'SPECIFY_OPTIONS'	=> 'Įveskite konversijos nustatymus',
	'STAGE_ADMINISTRATOR'	=> 'Administratoriaus aprašymas',
	'STAGE_ADVANCED'	=> 'Išplėstiniai nustatymai',
	'STAGE_ADVANCED_EXPLAIN'	=> 'Keisti šiuos nustatymus reikia tik tada, jeigu tikrai žinote, kad jums reikia kitokių nei standartiniai nustatymų. Jeigu jūs neįsitikinę, tiesiog eikite į kitą puslapį, kadangi šiuos nustatymus visada galima pakeisti per administratoriaus valdymo pultą.',
	'STAGE_CONFIG_FILE'	=> 'Konfigūracijos failas',
	'STAGE_CREATE_TABLE'	=> 'Duomenų bazės lentelių kūrimas',
	'STAGE_CREATE_TABLE_EXPLAIN'	=> 'Duomenų bazės lentelės, kurias naudoja phpBB 3.0, buvo sukurtos ir užpildytos pradiniais duomenimis. Toliau seka paskutinis phpBB diegimo etapas.',
	'STAGE_DATABASE'	=> 'Duomenų bazės nustatymai',
	'STAGE_FINAL'	=> 'Paskutinis etapas',
	'STAGE_INTRO'	=> 'Įžanga',
	'STAGE_IN_PROGRESS'	=> 'Vykdoma konversija',
	'STAGE_REQUIREMENTS'	=> 'Reikalavimai',
	'STAGE_SETTINGS'	=> 'Nustatymai',
	'STARTING_CONVERT'	=> 'Pradedamas konversijos procesas',
	'STEP_PERCENT_COMPLETED'	=> '<strong>%d</strong> etapas iš <strong>%d</strong>',
	'SUB_INTRO'	=> 'Įžanga',
	'SUB_LICENSE'	=> 'Licencija',
	'SUB_SUPPORT'	=> 'Palaikymas',
	'SUCCESSFUL_CONNECT'	=> 'Prisijungti pavyko',
	'SUPPORT_BODY'	=> 'Pilna einamosios stabilios phpBB3 versijos pagalba yra nemokama. Į ją įeina:</p><ul><li>diegimas</li><li>konfigūracija</li><li>techniniai klausimai</li><li>problemos susijusios su klaidomis programinėje įrangoje</li><li>atnaujinimai iš kandidatinių į naujausią stabilią versiją</li><li>konversija iš phpBB 2.0.x į phpBB3</li><li>konversija iš kitų diskusijų lentų programinės įrangos paketų į phpBB3 (daugiau <a href="http://www.phpbb.com/community/viewforum.php?f=65">konversijų forume</a>)</li></ul><p>Raginame visus vartotojus, kurie vis dar naudojasi beta phpBB3 versijomis, pakeisti jas į naujausią stabilią versiją.</p><h2>MOD`ifikacijos / Stiliai</h2><p>Apie problemas susijusias su modifikacijomis praneškite <a href="http://www.phpbb.com/community/viewforum.php?f=81">modifikacijų forume</a>.<br />Apie problemas susijusias su stiliais, šablonais ir paveikslėlių komplektais praneškite <a href="http://www.phpbb.com/community/viewforum.php?f=80">stilių forume</a>.<br /><br />Jeigu jūsų klausimas yra susijęs su tam tikru paketu, praneškite tiesiai į to paketo temą.</p><h2>Kur gauti pagalbą</h2><p><a href="http://www.phpbb.com/community/viewtopic.php?f=14&amp;t=571070">phpBB pasveikinimo paketas</a><br /><a href="http://www.phpbb.com/support/">Pagalbos sekcija</a><br /><a href="http://www.phpbb.com/support/documentation/3.0/quickstart/">Greitasis vadovas</a><br /><br />Jeigu norite gauti visas naujausias naujienas ir žinutes apie naujus programinės įrangos leidimus, prisijunkite prie <a href="http://www.phpbb.com/support/">mūsų el. pašto konferencijos</a><br /><br />',
	'SYNC_FORUMS'	=> 'Pradedamas forumų sinchronizavimas',
	'SYNC_POST_COUNT'	=> 'Sinchronizuojamas pranešimų skaičius',
	'SYNC_POST_COUNT_ID'	=> 'Sinchronizuojamas pranešimų skaičius nuo %1$s iki %2$s <var>įrašo</var> .',
	'SYNC_TOPICS'	=> 'Pradedamas temų sinchronizavimas',
	'SYNC_TOPIC_ID'	=> 'Sinchronizuojamos temos nuo <var>topic_id</var> %1$s iki %2$s.',
	'TABLES_MISSING'	=> 'Nepavyko rasti šių lentelių<br />» <strong>%s</strong>.',
	'TABLE_PREFIX'	=> 'Duomenų bazės lentelių prefiksas',
	'TABLE_PREFIX_SAME'	=> 'Duomenų bazės lentelių prefiksas turi būti toks, koks naudojamas diskusijų lentos programinėje įrangoje iš kurios konvertuojate.<br />» Jūs įrašėte %s.',
	'TESTS_PASSED'	=> 'Testai pavyko',
	'TESTS_FAILED'	=> 'Testai nepavyko',
	'UNABLE_WRITE_LOCK'	=> 'Nepavyko įrašyti rakto failo.',
	'UNAVAILABLE'	=> 'Nėra',
	'UNWRITABLE'	=> 'Tik skaitymui',
	'UPDATE_TOPICS_POSTED'	=> 'Generuojama temų datos informacija',
	'UPDATE_TOPICS_POSTED_ERR'	=> 'Generuojant temų datos informaciją įvyko klaida. Kai konversijos procesas bus baigtas, galėsite pabandyti padaryti tai dar kartą per administratoriaus valdymo pultą.',
	'VERIFY_OPTIONS'	=> 'Tikrinamos konversijos galimybės',
	'VERSION'	=> 'Versija',
	'WELCOME_INSTALL'	=> 'Sveiki atvykę į phpBB3 diegimo procesą',
	'WRITABLE'	=> 'Galima rašyti',
	'ALL_FILES_UP_TO_DATE'	=> 'Jūs naudojate naujausią phpBB versiją. <a href="../ucp.php?mode=login&amp;redirect=adm/index.php%3Fi=send_statistics%26mode=send_statistics">Prisijunkite prie diskusijų lentos</a> ir patikrinkite ar viskas veikia korektiškai. Nepamirškite ištrinti, pervadinti arba perkelti diegimo katalogo (install)! Atsiųskite mums naujausią informaciją apie jūsų serverį ir diskusijų lentos nustatymus per <a href="../ucp.php?mode=login&amp;redire
ct=adm/index.php%3Fi=send_statistics%26mode=send_statistics">Statistinės informacijos siuntimo</a> puslapį administratoriaus valdymo pulte.',
	'ARCHIVE_FILE'	=> 'Programinio kodo failas archyve',
	'BACK'	=> 'Atgal',
	'BINARY_FILE'	=> 'Binarus failas',
	'BOT'	=> 'Voras/Robotas',
	'CHANGE_CLEAN_NAMES'	=> 'Metodas, naudojamas aptikti vartotojų vardus, kuriuos gali naudoti keletas vartotojų, buvo pakeistas. Aptikti keli tokie vartotojai. Prieš tęsdami, ištrinkite arba pervadinkite šiuo vartotojus ir įsitikinkite, kad kiekvieną vardą naudoją vienas vartotojas.',
	'CHECK_FILES'	=> 'Patikrinti failus',
	'CHECK_FILES_AGAIN'	=> 'Patikrinti failus dar kartą',
	'CHECK_FILES_EXPLAIN'	=> 'Kito etapo metu bus patikrintas visų failų naujumas - jeigu tai pirmas toks patikrinimas, tai gali užtrukti.',
	'CHECK_FILES_UP_TO_DATE'	=> 'Pagal duomenis duomenų bazėje, jūs naudojate naujausią versiją. Galite patikrinti ir visus failus atskirai, norėdami įsitikinti kad tikrai naudojate naujausią phpBB versiją.',
	'CHECK_UPDATE_DATABASE'	=> 'Tęsti atnaujinimo procesą',
	'COLLECTED_INFORMATION'	=> 'Informacija apie failus',
	'COLLECTED_INFORMATION_EXPLAIN'	=> 'Žemiau rodomi duomenys apie failus kurie reikalauja atnaujinimo. Norėdami suprasti ką ji reiškia ir kaip teisingai atnaujinti visus failus, perskaitykite informaciją šalia kiekvieno bloko.',
	'COLLECTING_FILE_DIFFS'	=> 'Renkami duomenys apie failų pasikeitimus',
	'COMPLETE_LOGIN_TO_BOARD'	=> '<a href="../ucp.php?mode=login">Prisijunkite prie diskusijų lentos</a> ir patikrinkite ar viskas veikia korektiškai. Nepamirškite ištrinti, pervadinti arba perkelti diegimo katalogo (install)!',
	'CONTINUE_UPDATE_NOW'	=> 'Tęsti atnaujinimo procesą',
	'CONTINUE_UPDATE'	=> 'Tęsti atnaujinimą',
	'CURRENT_FILE'	=> 'Konflikto pradžia - dabartinio failo kodas prieš atnaujinimą',
	'CURRENT_VERSION'	=> 'Įdiegta versija',
	'DATABASE_TYPE'	=> 'Duomenų bazės tipas',
	'DATABASE_UPDATE_INFO_OLD'	=> 'Duomenų bazės naujumo failas diegimo kataloge yra per senas. Įsitikinkite, kad tikrai įkėlėte naujausią versiją.',
	'DELETE_USER_REMOVE'	=> 'Ištrinti vartotoją ir pašalinti pranešimus',
	'DELETE_USER_RETAIN'	=> 'Ištrinti vartotoją, bet pranešimus palikti',
	'DESTINATION'	=> 'Paskirties failas',
	'DIFF_INLINE'	=> 'Eilutėmis',
	'DIFF_RAW'	=> 'Išplėstinis unifikuotas skirtumas',
	'DIFF_SEP_EXPLAIN'	=> 'Kodo blokas naudojamas atnaujintame/naujame faile',
	'DIFF_SIDE_BY_SIDE'	=> 'Vienas šalia kito',
	'DIFF_UNIFIED'	=> 'Unifikuotas skirtumas',
	'DO_NOT_UPDATE'	=> 'Neatnaujinti šio failo',
	'DOWNLOAD'	=> 'Atsisiųsti',
	'DOWNLOAD_AS'	=> 'Atsisiųsti kaip',
	'DOWNLOAD_UPDATE_METHOD_BUTTON'	=> 'Atsisiųsti pakeistus failus archyve (rekomenduojama)',
	'DOWNLOAD_CONFLICTS'	=> 'Atsisiųsti šio failo konfliktus',
	'DOWNLOAD_CONFLICTS_EXPLAIN'	=> 'Konfliktai pažymėti &lt;&lt;&lt;',
	'DOWNLOAD_UPDATE_METHOD'	=> 'Atsisiųsti pakeistus failus archyve',
	'DOWNLOAD_UPDATE_METHOD_EXPLAIN'	=> 'Kai atsisiųsite, išpakuokite archyvą. Viduje rasite pakeistus failus kuriuos turite įkelti į pagrindinį phpBB katalogą. Įkelkite failus į atitinkamas vietas. Kai baigsite, vėl patikrinkite visus failus paspaudę mygtuką apačioje.',
	'ERROR'	=> 'Klaida',
	'EDIT_USERNAME'	=> 'Keisti vartotojo vardą',
	'FILE_ALREADY_UP_TO_DATE'	=> 'Šis failas ir taip naujausias.',
	'FILE_DIFF_NOT_ALLOWED'	=> 'Šio failo skirtumų pažiūrėti negalima.',
	'FILE_USED'	=> 'Duomenys iš',
	'FILES_CONFLICT'	=> 'Konfliktuojantys failai',
	'FILES_CONFLICT_EXPLAIN'	=> 'Šie failai yra pakeisti ir neatitinka originalių failų senesnėje versijoje. phpBB nustatė, kad jeigu jie bus sujungti, įvyks failų konfliktas. Peržiūrėkite konfliktus ir pabandykite patys juos išspręsti, arba tęskite atnaujinimo procesą pasirinkę norimą sujungimo metodą. Jeigu patys išspręsite konfliktus, patikrinkite failus dar kartą. Taip pat galite rinktis pageidaujamą sujungimo metodą kiekvienam failui atskirai. Pirmasis metodas nesujungs konfliktuojančių eilučių iš senojo failo, antrasis - iš naujojo.',
	'FILES_MODIFIED'	=> 'Pakeisti failai',
	'FILES_MODIFIED_EXPLAIN'	=> 'Šie failai yra pakeisti ir neatitinka originalių failų senesnėje versijoje. Atnaujintas failas bus senojo jūsų pakeisto failo ir naujojo failo junginys.',
	'FILES_NEW'	=> 'Nauji failai',
	'FILES_NEW_EXPLAIN'	=> 'Šie failai neegzistuoja dabartinėje diskusijų lentoje. Jie bus pridėti.',
	'FILES_NEW_CONFLICT'	=> 'Nauji konfliktuojantys failai',
	'FILES_NEW_CONFLICT_EXPLAIN'	=> 'Šie failai atsirado naujausioje versijoje, tačiau jūsų diskusijų lentoje jau yra failas tokiu pavadinimu. Šis failai bus perrašyti naujesne failo versija.',
	'FILES_NOT_MODIFIED'	=> 'Nepakeisti failai',
	'FILES_NOT_MODIFIED_EXPLAIN'	=> 'Šie failai nėra pakeisti ir atitinka originalius failus senojoje phpBB versijoje.',
	'FILES_UP_TO_DATE'	=> 'Jau atnaujinti failai',
	'FILES_UP_TO_DATE_EXPLAIN'	=> 'Šie failai jau atnaujinti ir daugiau nereikalauja jokių veiksmų.',
	'FTP_SETTINGS'	=> 'FTP nustatymai',
	'FTP_UPDATE_METHOD'	=> 'FTP įkėlimas',
	'INCOMPATIBLE_UPDATE_FILES'	=> 'Rasti atnaujinimo failai yra nesuderinti su jūsų įdiegta versija. Jūsų įdiegta versija yra %1$s, tačiau failas skirtas phpBB atnaujinimui iš %2$s į %3$s.',
	'INCOMPLETE_UPDATE_FILES'	=> 'Atnaujinimo failai yra nepilni.',
	'INLINE_UPDATE_SUCCESSFUL'	=> 'Duomenų bazės atnaujinimas baigtas sėkmingai. Dabar galite tęsti atnaujinimo procesą.',
	'KEEP_OLD_NAME'	=> 'Palikti vartotojo vardą',
	'LATEST_VERSION'	=> 'Naujausia versija',
	'LINE'	=> 'Eilutė',
	'LINE_ADDED'	=> 'Pridėta',
	'LINE_MODIFIED'	=> 'Pakeista',
	'LINE_REMOVED'	=> 'Ištrinta',
	'LINE_UNMODIFIED'	=> 'Nepakeista',
	'LOGIN_UPDATE_EXPLAIN'	=> 'Norėdami atnaujinti savo diskusijų lentą turite prisijungti.',
	'MAPPING_FILE_STRUCTURE'	=> 'Šis failų žemėlapis gali pagelbėti įkelti failus į atitinkamus phpBB katalogus.',
	'MERGE_MODIFICATIONS_OPTION'	=> 'Sujungti modulius',
	'MERGE_NO_MERGE_NEW_OPTION'	=> 'Nesujungti - naudoti naują failą',
	'MERGE_NO_MERGE_MOD_OPTION'	=> 'Nesujungti - naudoti esamą failą',
	'MERGE_MOD_FILE_OPTION'	=> 'Sujungti pakeitimus (pašalina naują phpBB kodą konfliktuojančiame bloke)',
	'MERGE_NEW_FILE_OPTION'	=> 'Sujungti pakeitimus (pašalina pakeistą kodą konfliktuojančiame bloke)',
	'MERGE_SELECT_ERROR'	=> 'Blogai pasirinktas konfliktuojančių failų sujungimo metodas.',
	'MERGING_FILES'	=> 'Suliejami failų pasikeitimai',
	'MERGING_FILES_EXPLAIN'	=> 'Dabar renkami duomenys apie galutinius failų pasikeitimus.<br /><br />Palaukite kol phpBB atliks visus veiksmus.',
	'NEW_FILE'	=> 'Konflikto pabaiga',
	'NEW_USERNAME'	=> 'Naujas vartotojo vardas',
	'NO_AUTH_UPDATE'	=> 'Neturite atnaujinimo teisių',
	'NO_ERRORS'	=> 'Klaidų nėra',
	'NO_UPDATE_FILES'	=> 'Šie failai nebus atnaujinti',
	'NO_UPDATE_FILES_EXPLAIN'	=> 'Šie failai yra nauji arba pakeisti, tačiau katalogas, kuriame jie turi būti, neegzistuoja. Jeigu šiame sąraše yra failų ne tik iš language/ ir styles/ katalogų, tai greičiausiai jūs pakeitėte katalogų struktūrą, todėl atnaujinimo procesas gali įvykti ne iki galo.',
	'NO_UPDATE_FILES_OUTDATED'	=> 'Nerastas atnaujinimo katalogas. Įsitikinkite kad įkėlėte visus reikiamus failus.<br /><br />Jūsų diskusijų lenta naudoja <strong>ne</strong> naujausią programinės įrangos versiją. Jūsų naudojamai phpBB %1$s versijai yra atnaujinimų. Apsilankykite <a href="http://www.phpbb.com/downloads/" rel="external">http://www.phpbb.com/downloads/</a> ir atsisiųskite teisingą atnaujinimo iš versijos %2$s į versiją %3$s paketą.',
	'NO_UPDATE_FILES_UP_TO_DATE'	=> 'Jūs naudojate naujausią versiją. Jeigu norite patikrinti visų failų versijas atskirai, įsitikinkite, kad įkėlėte visus reikiamus atnaujinimo failus.',
	'NO_UPDATE_INFO'	=> 'Nepavyko rasti duomenų apie atnaujinimo failą.',
	'NO_UPDATES_REQUIRED'	=> 'Atnaujinimas nereikalingas',
	'NO_VISIBLE_CHANGES'	=> 'Matomų pakeitimų nėra',
	'NOTICE'	=> 'Pastaba',
	'NUM_CONFLICTS'	=> 'Konfliktų skaičius',
	'NUMBER_OF_FILES_COLLECTED'	=> 'Šiuo metu patikrinti skirtumai tarp %1$d iš %2$d failų.<br />Palaukite kol bus patikrinti visi failai.',
	'OLD_UPDATE_FILES'	=> 'Atnaujinimo failai yra per seni. Rasti atnaujinimo failai yra skirti atnaujinti phpBB %1$s į phpBB %2$s, tačiau naujausia phpBB versija yra %3$s.',
	'PACKAGE_UPDATES_TO'	=> 'Šis paketas atnaujina į versiją',
	'PERFORM_DATABASE_UPDATE'	=> 'Duomenų bazės atnaujinimas',
	'PERFORM_DATABASE_UPDATE_EXPLAIN'	=> 'Apačioje rasite mygtuką į duomenų bazės atnaujinimo skriptą. Duomenų bazės atnaujinimas gali užtrukti, todėl, jeigu atrodo, kad procesas sustojo, nenutraukite skripto vykdymo. Kai baigsite, tęskite atnaujinimo procesą.',
	'PREVIOUS_VERSION'	=> 'Ankstesnė versija',
	'PROGRESS'	=> 'Progresas',
	'RESULT'	=> 'Rezultatas',
	'RUN_DATABASE_SCRIPT'	=> 'Atnaujinti duomenų bazę',
	'SELECT_DIFF_MODE'	=> 'Pasirinkite skirtumų radimo metodą',
	'SELECT_DOWNLOAD_FORMAT'	=> 'Pasirinkite atsisiunčiamo archyvo formatą',
	'SELECT_FTP_SETTINGS'	=> 'Pasirinkite FTP nustatymus',
	'SHOW_DIFF_CONFLICT'	=> 'Rodyti skirtumus/konfliktus',
	'SHOW_DIFF_FINAL'	=> 'Rodyti galutinį failą',
	'SHOW_DIFF_MODIFIED'	=> 'Rodyti sujungtus skirtumus',
	'SHOW_DIFF_NEW'	=> 'Rodyti failo turinį',
	'SHOW_DIFF_NEW_CONFLICT'	=> 'Rodyti skirtumus',
	'SHOW_DIFF_NOT_MODIFIED'	=> 'Rodyti skirtumus',
	'SOME_QUERIES_FAILED'	=> 'Nepavyko įvykdyti kai kurių užklausų. Žemiau surašyti sakiniai ir klaidų pranešimai.',
	'SQL'	=> 'SQL',
	'SQL_FAILURE_EXPLAIN'	=> 'Greičiausiai dėl to nereikia jaudintis. Atnaujinimo procesas bus tęsiamas. Jeigu jis nepavyks, ieškokite pagalbos palaikymo forumuose. Norėdami gauti platesnės informacijos perskaitykite <a href="../docs/README.html">README</a> failą.',
	'STAGE_FILE_CHECK'	=> 'Failų patikrinimas',
	'STAGE_UPDATE_DB'	=> 'Duomenų bazės atnaujinimas',
	'STAGE_UPDATE_FILES'	=> 'Failų atnaujinimas',
	'STAGE_VERSION_CHECK'	=> 'Versijos patikrinimas',
	'STATUS_CONFLICT'	=> 'Pakeistas konfliktuojantis failas',
	'STATUS_MODIFIED'	=> 'Pakeistas failas',
	'STATUS_NEW'	=> 'Naujas failas',
	'STATUS_NEW_CONFLICT'	=> 'Konfliktuojantis naujas failas',
	'STATUS_NOT_MODIFIED'	=> 'Nepakeistas failas',
	'STATUS_UP_TO_DATE'	=> 'Failas jau atnaujintas',
	'TOGGLE_DISPLAY'	=> 'Rodyti/Paslėpti failų sąrašą',
	'TRY_DOWNLOAD_METHOD'	=> 'Jūs galite pabandyti atsisiųsti pakeistus failus.<br />Šis metodas visada veikia ir yra rekomenduojamas atnaujinimų kelias.',
	'TRY_DOWNLOAD_METHOD_BUTTON'	=> 'Pabandyti šį metodą',
	'UPDATE_COMPLETED'	=> 'Atnaujinimas baigtas',
	'UPDATE_DATABASE'	=> 'Atnaujinti duomenų bazę',
	'UPDATE_DATABASE_EXPLAIN'	=> 'Kito etapo metu bus atnaujinta jūsų duomenų bazė.',
	'UPDATE_DATABASE_SCHEMA'	=> 'Atnaujinama duomenų bazės struktūra',
	'UPDATE_FILES'	=> 'Atnaujinti failus',
	'UPDATE_FILES_NOTICE'	=> 'Įsitikinkite kad atnaujinote ir savo diskusijų lentos failus. Šis failas yra skirtas tik duomenų bazės atnaujinimui.',
	'UPDATE_INSTALLATION'	=> 'Atnaujinti įdiegtą phpBB diskusijų lentą',
	'UPDATE_INSTALLATION_EXPLAIN'	=> 'Čia galite atnaujinti savo phpBB diskusijų lentą į naujausią versiją.<br />Proceso metu visi jūsų failai bus patikrinti. Visus pakeitimų reikalaujančius failus ir skirtumus jūs pamatysite dar prieš proceso pradžią.<br /><br />Failų atnaujinimas gali būti įvykdytas dviem būdais.</p><h2>Rankinis atnaujinimas</h2><p>Šiuo būdu jūs atsisiųsite visus pakeistus failus. Po to turėsite rankiniu būdu įkelti failus į atitinkamas vietas pagrindiniame phpBB kataloge. Kai baigsite, turėsite pakartoti failų patikrinimo etapą ir įsitikinti, kad visi failai yra reikiamoje vietoje.</p><h2>Automatinis atnaujinimas per FTP</h2><p>Šis metodas panašus į pirmą, tačiau jums nereikės atsisiuntinėti ir įkėlinėti failų patiems. Tai bus atlikta už jus. Norėdami naudoti šį metodą, turite žinoti savo FTP prisijungimo duomenis. Kai baigsite, turėsite pakartoti failų patikrinimo etapą ir įsitikinti, kad įkėlimas sėkmingai pavyko.<br /><br />',
	'UPDATE_INSTRUCTIONS'	=> '		<h1>Pranešimas apie leidimą</h1>

		<p>Prieš tęsdami atnaujinimo procesą, perskaitykite <a href="%1$s" title="%1$s"><strong>pranešimą apie naujausią leidimą</strong></a>. Jame gali būti naudingos informacijos. Taip pat jame rasite atsisiuntimo nuorodas ir pakeitimų istoriją.</p>

		<br />

		<h1>Kaip atnaujinti įdiegtą diskusijų lentą automatinio atnaujinimo paketo pakalba</h1>

		<p>Šie rekomenduojami atnaujinimo žingsniai galioja tik atnaujinant automatinio atnaujinimo paketų pagalba. Dar jūs galite atnaujinti įdiegtą diskusijų lentą kitais būdais nurodytais INSTALL.html faile. Automatinio atnaujinimo žingsniai yra tokie:</p>

		<ul style="margin-left: 20px; font-size: 1.1em;">
			<li>Eikite į <a href="http://www.phpbb.com/downloads/" title="http://www.phpbb.com/downloads/">phpBB.com atsisiuntimų puslapį</a> ir atsisiųskite teisingą "Automatinio atnaujinimo paketo" archyvą.<br /><br /></li>
			<li>Išpakuokite archyvą.<br /><br /></li>
			<li>Įkelkite visą išpakuotą diegimo katalogą į savo phpBB pagrindinį katalogą (kuriame yra config.php failas).<br /><br /></li>
		</ul>

		<p>Kai įkelsite, paprasti vartotojai negalės prisijungti prie jūsų diskusijų lentos.<br /><br />
		<strong><a href="%2$s" title="%2$s">Tada nukreipkite savo naršyklę į diegimo katalogą ir pradėkite atnaujinimo procesą</a>.</strong><br />
		<br />
		Toliau sekite instrukcijas ekrane.
		</p>
	',
	'UPDATE_INSTRUCTIONS_INCOMPLETE'	=> '		<h1>Aptiktas nebaigtas atnaujinimas</h1>		<p>phpBB aptiko nebaigtą automatinio atnaujinimo procesą. Įsitikinkite, kad tikrai sekėte visais automatinio atnaujinimo įrankio nurodymais. Apačioje vėl rasite nuorodą vedančią į atnaujinimo procesą arba patys nukreipkite savo naršyklę į diegimo katalogą.</p>	',
	'UPDATE_METHOD'	=> 'Atnaujinimo metodas',
	'UPDATE_METHOD_EXPLAIN'	=> 'Dabar galite pasirinkti pageidaujamą atnaujinimo metodą. Jeigu pasirinksite FTP įkėlimo metodą, turėsite įvesti FTP prisijungimo duomenis. Šiuo būdu visi failai bus automatiškai perkelti į reikiamas vietas, o prie senųjų failų pavadinimų bus pridėta galūnė .bak. Jeigu pasirinksite pakeistų failų atsisiuntimo metodą, vėliau galėsite išpakuoti juos ir įkelti į reikiamas vietas patys.',
	'UPDATE_REQUIRES_FILE'	=> 'Atnaujinimo įrankiui reikia šio failo: %s',
	'UPDATE_SUCCESS'	=> 'Atnaujinimas sėkmingai baigtas',
	'UPDATE_SUCCESS_EXPLAIN'	=> 'Visi failai sėkmingai atnaujinti. Kito etapo metu dar kartą turite patikrinti visus failus, kad įsitikintumėte, jog įkėlimas sėkmingai pavyko.',
	'UPDATE_VERSION_OPTIMIZE'	=> 'Atnaujinama versija ir optimizuojamos lentelės',
	'UPDATING_DATA'	=> 'Atnaujinami duomenys',
	'UPDATING_TO_LATEST_STABLE'	=> 'Duomenų bazė atnaujinama į naujausią stabilų leidimą',
	'UPDATED_VERSION'	=> 'Atnaujinta versija',
	'UPLOAD_METHOD'	=> 'Įkėlimo metodas',
	'UPDATE_DB_SUCCESS'	=> 'Duomenų bazės atnaujinimas sėkmingai pavyko.',
	'USER_ACTIVE'	=> 'Įjungti vartotoją',
	'USER_INACTIVE'	=> 'Išjungti vartotoją',
	'VERSION_CHECK'	=> 'Versijos patikrinimas',
	'VERSION_CHECK_EXPLAIN'	=> 'Patikrina ar naudojate naujausią phpBB versiją.',
	'VERSION_NOT_UP_TO_DATE'	=> 'Jūs naudojate ne naujausią phpBB versiją. Pradėkite atnaujinimo procesą.',
	'VERSION_NOT_UP_TO_DATE_ACP'	=> 'Jūs naudojate ne naujausią phpBB versiją.<br />Apačioje rasite nuorodą į pranešimą apie naujausią leidimą. Ten pat rasite ir instrukcijas, kaip atnaujinti jūsų naudojamą versiją.',
	'VERSION_UP_TO_DATE'	=> 'Jūs naudojate naujausią phpBB versiją. Nors jos nereikia atnaujinti, tačiau vis tiek galite tęsti ir patikrinti kiekvieną failą atskirai.',
	'VERSION_UP_TO_DATE_ACP'	=> 'Jūs naudojate naujausią phpBB versiją. Šiuo metu atnaujinimų nėra.',
	'VERSION_NOT_UP_TO_DATE_TITLE'	=> 'Jūs naudojate ne naujausią phpBB versiją.',
	'VIEWING_FILE_CONTENTS'	=> 'Rodomas failo turinys',
	'VIEWING_FILE_DIFF'	=> 'Rodomi failų skirtumai',
	'WRONG_INFO_FILE_FORMAT'	=> 'Neteisingas informacinio failo formatas',
	'CONFIG_BOARD_EMAIL_SIG'	=> 'Sėkmės, Administratorius',
	'CONFIG_SITE_DESC'	=> 'Trumpas sakinys apibūdinantis jūsų diskusijų lentą',
	'CONFIG_SITENAME'	=> 'jūsųdomenas.com',
	'DEFAULT_INSTALL_POST'	=> 'Tai yra pavyzdinis pranešimas. Atrodo, kad viskas veikia. Jeigu norite tęsti diskusijų lentos konfigūravimą, galite ištrinti šį pranešimą. Diegimo metu vartotojų grupėms administratoriams, botams, globaliems moderatoriams, svečiams, registruotiems vartotojams bei registruotiems COPPA vartotojams pirmame forume bei pirmoje kategorijoje paskiriamos teisingos teisės. Jeigu norite ištrinti pirmąją kategoriją bei pirmąjį forumą, nepamirškite šioms grupėms paskirti teisių visose naujai sukurtose kategorijose bei forumuose. Rekomenduojama pervadinti pirmąją kategoriją bei forumą ir kopijuoti jų teises naujai kuriamoms kategorijoms ir forumams. Sėkmės!',
	'EXT_GROUP_ARCHIVES'	=> 'Archyvai',
	'EXT_GROUP_DOCUMENTS'	=> 'Dokumentai',
	'EXT_GROUP_DOWNLOADABLE_FILES'	=> 'Failai, kuriuos galima atsisiųsti',
	'EXT_GROUP_FLASH_FILES'	=> 'Flash formato failai',
	'EXT_GROUP_IMAGES'	=> 'Paveiksliukai',
	'EXT_GROUP_PLAIN_TEXT'	=> 'Tekstiniai failai',
	'EXT_GROUP_QUICKTIME_MEDIA'	=> 'Quicktime Media formato failai',
	'EXT_GROUP_REAL_MEDIA'	=> 'Real Media formato failai',
	'EXT_GROUP_WINDOWS_MEDIA'	=> 'Windows Media formato failai',
	'FORUMS_FIRST_CATEGORY'	=> 'Jūsų pirmoji kategorija',
	'FORUMS_TEST_FORUM_DESC'	=> 'Jūsų pirmojo forumo aprašymas.',
	'FORUMS_TEST_FORUM_TITLE'	=> 'Jūsų pirmasis forumas',
	'RANKS_SITE_ADMIN_TITLE'	=> 'Vyr. diskusijų administratorius',
	'REPORT_WAREZ'	=> 'Pranešime yra nuorodų į nelegalią arba piratinę programinę įrangą.',
	'REPORT_SPAM'	=> 'Vienintelis pranešimo tikslas - reklamuoti puslapį arba kitą produktą.',
	'REPORT_OFF_TOPIC'	=> 'Pranešimo turinys neatitinka temos.',
	'REPORT_OTHER'	=> 'Pranešimas neatitinka nei vienos iš šių kategorijų. Užpildykite aprašymo laukelį.',
	'SMILIES_ARROW'	=> 'Rodyklė',
	'SMILIES_CONFUSED'	=> 'Sumišęs',
	'SMILIES_COOL'	=> 'Kietas',
	'SMILIES_CRYING'	=> 'Verkiantis arba labai liūdnas',
	'SMILIES_EMARRASSED'	=> 'Susigėdęs',
	'SMILIES_EVIL'	=> 'Blogas arba labai piktas',
	'SMILIES_EXCLAMATION'	=> 'Šauktukas',
	'SMILIES_GEEK'	=> 'Gykas',
	'SMILIES_IDEA'	=> 'Idėja',
	'SMILIES_LAUGHING'	=> 'Besijuokiantis',
	'SMILIES_MAD'	=> 'Piktas',
	'SMILIES_MR_GREEN'	=> 'Misteris žalioji šypsena',
	'SMILIES_NEUTRAL'	=> 'Neutralus',
	'SMILIES_QUESTION'	=> 'Klausimas',
	'SMILIES_RAZZ'	=> 'Rodo liežuvį',
	'SMILIES_ROLLING_EYES'	=> 'Varto akis',
	'SMILIES_SAD'	=> 'Liūdnas',
	'SMILIES_SHOCKED'	=> 'Šokiruotas',
	'SMILIES_SMILE'	=> 'Išsišiepęs',
	'SMILIES_SURPRISED'	=> 'Nustebęs',
	'SMILIES_TWISTED_EVIL'	=> 'Suktas piktadarys',
	'SMILIES_UBER_GEEK'	=> 'Super gykas',
	'SMILIES_VERY_HAPPY'	=> 'Labai laimingas',
	'SMILIES_WINK'	=> 'Merkia akį',
	'TOPICS_TOPIC_TITLE'	=> 'Sveiki atvykę į phpBB3',
));

?>