<?php
/**
 * Danish Language file for PhpGedView.
 *
 * phpGedView: Genealogy Viewer
 * Copyright (C) 2002 to 2005  Jørgen Hansen
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 * @author Jørgen Hansen
 * @package PhpGedView
 * @version $Id: help_text.da.php,v 1.13.2.9 2006/02/16 18:16:14 canajun2eh Exp $
 */
if (preg_match("/help_text\...\.php$/", $_SERVER["PHP_SELF"])>0) {
print "Du har ikke direkte adgang til sprogfilen.";
exit;
}

$pgv_lang["link_person_id_help"]	= "~#pgv_lang[label_local_id]#~<br /><br />I dette felt angiver du ID på den person du linker til (fx I100).";
$pgv_lang["link_gedcom_id_help"]	= "~#pgv_lang[label_gedcom_id]#~<br /><br />Brug denne sektion til at vælge den database ID, der indeholder den person du linker til.";
$pgv_lang["link_remote_site_help"]	= "~#pgv_lang[label_site]#~<br /><br />I denne sektion specificerer du de parametre, der kræves for at oprette en forbindelse til den eksterne site, der indeholder de data, du linker til. Du har muligheden for at vælge fra en liste over kendte sites, som du har anvendt før, eller angive #pgv_lang[label_site_url2]# og #pgv_lang[label_gedcom_id]# for en ny.<br /><br />I <b>#pgv_lang[label_site_url2]#</b> feltet, angiver du URL-adressen for at få adgang til web services description filen (WDSL), der fortæller PhpGedView, hvordan den skal få adgang til den eksterne site.  For en ekstern PhpGedView website, ser URL-adressen for WSDL filen ud som følger: <u>http://www.remotesite.com/phpGedView/genservice.php?wsdl</u><br /><br /><b>#pgv_lang[label_gedcom_id]#</b> feltet anvendes til at angive en valgfri database ID for de eksterne sites, der kræver en.  For PhpGedView sites, er det navnet på GEDCOM-filen. <br /><br />Felterne til <b>#pgv_lang[label_username_id]#</b> og <b>#pgv_lang[label_password_id]#</b> er nødvendige hvis databasen kræver det.<br /><br /><i>Note: Eksterne PhpGedView sites skal køre med version 4.0 eller senere; tidligere versioner har ikke denne funktion.</i>";
$pgv_lang["link_remote_location_help"]	= "~#pgv_lang[label_location]#~<br /><br />Denne valgmulighed tillader diag at vælge om data for den person du linker til findes på den samme site, men i et andet genealogisk database sæt, eller om dataene befinder sig på en anden site, der er tilgængelig via Internettet.<br /><br />Hvis personen findes på den samme site, vil du blive spurgt om at vælge identifikationen af datasættet og angive personens ID.<br /><br />For en ekstern site, vil du blive spurgt om at angive URL-adressen, en database identifikation, og den eksterne persons ID.";
$pgv_lang["link_remote_rel_help"]	= "~#pgv_lang[label_rel_to_current]#~<br /><br />Bruges denne valgmulighed til at vælge den relation, som den eksterne person har til de personer du knytter personen til på din site.  For eksempel, vælges <i>Far</i> betyder det at personen på den eksterne site er far til den person du knytter ham til på din site.";
$pgv_lang["link_remote_help"]       = "~#pgv_lang[link_remote]#~<br /><br />Brug denne formular til at linke personer til andre personer fra enten en anden site eller en anden slægtsdatabase, du har adgang til via din kopi af PhpGedView.<br /><br />For at tilføje sådan et link skal du først vælge en relationstype, og derefter vælge en site der allerede kendes af PhpGedView eller definere en ny site og derefter indtaste sitens ID på den person du ønsker at linke til.  PhpGedView vil så automatisk downloade information fra den eksterne site.  Den downloadede information bliver <u>ikke</u> en del af din slægtsdatabase; den forbliver på den oprindelige site, men bliver integreret med de forskellige sider, hvor den eksterne person vises.<br /><br />Se hjælpen ved siden af hvert element på siden for mere information om elementet.  Du kan også checke den engelske online hjælp for mere information: <a href=\"http://wiki.phpgedview.net/en/index.php/How_to_Remote_Link\" target=\"_blank\">http://wiki.phpgedview.net/en/index.php/How_to_Remote_Link</a>.";

//-- Edit Interface
$pgv_lang["edit_ABBR_help"]			= "~Forkortet titel~<br /><br />Brug dette felt til at gemme en kort version af en titel.  Dette felt anvendes sammen med titelfeltet til kilder.  Som standard vil PGV først anvende den fulde titel, og derefter den korte titel.<br /><br />Ifølge GEDCOM 5.5 specifikationen, \"dette input giver en kort titel, der anvendes til ar sortere, gemme og finde kilde poster (side 62).\"<br /><br />I PhpGedView er det valgfrit at anvende korte titler, men i andre slægtsprogrammer er det påkrævet.";
$pgv_lang["edit_ROMN_help"]			= "~#factarray[ROMN]#~<br /><br />Her anføres det latinske alfabet med evt. specielle karakterer. Klik på tastaturikonet for at finde specielle karakterer.";
$pgv_lang["edit_SEX_help"]			= "~#factarray[SEX]#~<br /><br />Brug dette felt til at angive om personen er <b>#pgv_lang[male]#</b> eller <b>#pgv_lang[female]#</b>.  Vælg kun <b>#pgv_lang[unknown]#</b> når du ikke er sikker på personens køn.";
$pgv_lang["edit_NAME_help"]			= "~Ændre #factarray[NAME]#~<br /><br />Navn bør angives med skråstreg \"/\" før og efter personens efternavn.<br /><br />Se følgende eksempler:<ul><li>Fornavn /Efternavn/</li><li>Fornavn /Efternavn/ Jr.</li><li>Fornavn /von Efternavn/ de.</li></ul>";
$pgv_lang["edit_add_unlinked_person_help"]	= "~#pgv_lang[add_unlinked_person]#~<br /><br />Brug dette skema til at tilføje en person, som ikke er knyttet til en familie.<br /><br />Når du tilføjer en \"fritstående\" person til din slægtsdatabase, vil personen ikke blive knyttet til andre personer førend du opgiver slægtskabet/familiebåndet.  Du kan når som helst knytte personer sammen ved at vælge dette under fanebladet: <b>#pgv_lang[relatives]#</b> på siden for #pgv_lang[indi_info]#.";
$pgv_lang["edit_URL_help"]			= "Angiv internet adresse (URL) inklusiv http://.<br /><br />Et eksempel på en internet adresse er: <b>http://www.phpgedview.net/</b> <br />Lad dette felt være tomt hvis du ikke ønsker at opgive en adresse (URL).";
$pgv_lang["edit_EMAIL_help"]		= "Angiv en e-mail-adresse.<br /><br />Et eksempel på en e-mail-adresse er: <b>navn@hotmail.com</b> <br />Lad feltet være tomt, hvis du ikke ønsker at opgive en e-mail-adresse.";
$pgv_lang["edit_FAX_help"]			= "Angiv et FAX-nummer, inklusiv landekode og eventuelt områdenummer.<br /><br />Eksempler:<ul><li>Norge: +47 35 00 00 01</li><li>Tyskland: +49 25859 56 76 89</li><li>USA: +1 888 555-1212</li></ul>Lad dette felt være tomt hvis du ikke ønsker at opgive et faxnummer.";
$pgv_lang["edit_PHON_help"]			= "Angiv et telefonnummer, inklusiv landekode og eventuelt områdenummer.<br /><br />Eksempel:<ul><li>Norge: +47 35 00 00 00</li><li>Tyskland: +49 25859 56 76 89</li><li>USA: +1 888 555-1212.</li></ul>Lad dette felt være tomt hvis du ikke ønsker at opgive et telefonnummer.";
$pgv_lang["edit_ADDR_help"]			= "Angiv en postadresse i feltet på samme måde, som du ville gjort på en konvolut.<br /><br />Lad feltet være tomt, hvis du ikke ønsker at opgive en postadresse.";
$pgv_lang["edit_GIVN_help"]			= "~#factarray[GIVN]#~<br /><br />I dette valgfrie felt skrives fornavnet.";
$pgv_lang["edit_SPFX_help"]			= "~#factarray[SPFX]#~<br /><br />Her anføres et evt. præfiks foran efternavnet. Klik på et af de foreslåede præfikser efter feltet, for at indsætte det i feltet. Skriv evt. selv et, hvis du ikke kan finde præfikset blandt de foreslåede.";
$pgv_lang["edit_SURN_help"]			= "~#factarray[SURN]#~<br /><br />Her anføres efternavnet.";
$pgv_lang["edit_NSFX_help"]			= "~#factarray[NSFX]#~<br /><br />Her anføres et suffiks til efternavnet, hvis et sådant findes. Klik på et af de foreslåede suffikser efter feltet, for at indsætte det i feltet. Skriv evt. selv et, hvis du ikke kan finde præfikset blandt de foreslåede.";
$pgv_lang["edit__MARNM_help"]			= "~#factarray[_MARNM]#~<br /><br />Her anføres vielsesnavnet. Oftest for kvinder.";

$pgv_lang["context_help"]			= "Mere hjælp er tilgængelig ved at klikke på <b>?</b> du kan finde efter forskellige valg på siden.";

$pgv_lang["register_gedcomid_help"]	= "~#pgv_lang[gedcomid]#~<br /><br />Hver person i slægtsdatabasen har et entydigt ID nr.  Hvis du kender dit eget ID nr., kan du opgive det her.  Hvis du ikke kan huske ID nummeret, eller ikke kan finde det på grund af indstillingerne for privatlivets beskyttelse, så opgiv venligst nok information i Kommentar-feltet, sål administratoren af websitet kan identificere dig, og så han/hun kan angive ID nummeret for dig.<br /><br />";
$pgv_lang["register_comments_help"]	= "~#pgv_lang[comments]#~<br /><br />Brug dette felt til at fortælle administratoren af websitet hvem du er, og hvem du er i familie med, i slægtsdatabasen. Du kan også bruge feltet til at sende administratoren af websitet en kommentar.<br /><br />";
$pgv_lang["utf8_ansi_help"]			= "~Konvertere fra UTF-8 til ANSI~<br /><br />For at dataene skal vises på den bedste måde på Internettet, så bruger PhpGedView UTF-8 tegnsættet.  Nogle programmer, som for eksempel Family Tree Maker, understøtter ikke import af GEDCOM-filer som bruger UTF-8 tegnsættet.  Ved at afkrydse denne checkboks, vil datafilen blive konverteret fra <b>UTF-8</b> til <b>ANSI (ISO-8859-1)</b>.<br /><br />Det format af GEDCOM-filen du skal downloade, afhænger af det program, du skal bruge til at arbejde videre med dataene i.  Hvis du ikke er sikker på, hvilke formater det understøtter, kan du se i brugervejledningen til programmet.<br /><br />NB! Vær opmærksom på at specielle nationale tegn/bogstaver kan forsvinde/vises forkert ved konvertering. Det er derfor altid det sikreste at bevare dataene i UTF-8 og lade dit eget program bruge sin egen metode til import og konvertering af dataene.  Hvis du får problemer bør du kontakte sælgeren eller udvikleren af dit program.<br /><br />";
$pgv_lang["remove_tags_help"]		= "~Fjern bruger definerede PGV-tags~<br /><br />Ved krydse denne valgmulighed af, vil alle bruger-definerede mærker som er tilføjet til PhpGedView blive fjernet.<br /><br />Bruger-mærker, som PhpGedView anvender er blandt andet <b>_PGVU</b> som identificerer brugere, der har ændret data online og <b>_THUM</b> som fortæller PhpGedView at billedet bør anvendes som miniaturebillede.<br /><br />Brugerdefinerede mærker kan forårsage fejl ved import til andre slægtsprogrammer.<br /><br />";
$pgv_lang["download_zipped_help"]	= "~Download GEDCOM-fil som ZIP-fil~<br /><br />Når du afmærker denne valgmulighed, vil en kopi af GEDCOM-filen komprimeres til en ZIP-fil før downloading starter. Det vil reducere filens størrelse betydeligt, men du vil vil få brug for et program, der kan pakke filen ud igen (for eksempel WinZIP) førend du kan bruge den.<br /><br />Det er en god funtion i forbindelse med at downloade store GEDCOM-filer.  Der er en risiko for at download tiden overskrider den maksimale tilladte tid for GEDCOM-filer, der ikke er komprimeret (zippet), hvilket kan resultere i at den downloaded fil ikke er komplet.  ZIP-funktionen burde reducere download tiden med ca. 75%.<br /><br />";
$pgv_lang["remember_me_help"]		= "~Husk mig~<br /><br />Ved at sætte et mærke i denne checkboks når du logger dig ind, vil PhpGedView (PGV)) huske dig næste gang du besøger websitet så du ikke behøver at logge dig ind igen.  En \"cookie\" vil blive gemt på din harddisk som PhpGedView vil spørge browseren om at hente næste gang du besøger websitet.<br /><br />Hvis PGV husker dig, vil du kunne se private informationer og brugersider direkte. - Men hvis du ønsker at ændre eller administrere websitet, vil du blive bedt om at opgive brugernavn og adgangskode igen.<br /><br /><b>Du bør ikke krydse checkboksen af, hvis du logger dig ind fra en PC på et offentligt sted eller en PC, som du deler med andre, da andre brugere af PC'en da kan få adgang til PhpGedView-websitet, som om de var dig.</b>";
$pgv_lang["edit_NCHI_help"]			= "~#factarray[NCHI]#~<br /><br />Angiv antal børn som personen eller familien har. Dette er et valgfrit felt.<br /><br />";
$pgv_lang["edit_TIME_help"]			= "~#factarray[TIME]#~<br /><br />Angiv klokkeslettet for denne begivenhed. Brug tidsformat med 24 timer:<ul><li>Midnat: 00:00</li><li>04:50</li><li>13:00</li><li>20:30</li></ul>";
$pgv_lang["edit_NOTE_help"]			= "~#factarray[NOTE]#~<br /><br />Noter er fritekst og vises i faktafelterne og under fanebladet: <b>Noter</b>.<br /><br />";
$pgv_lang["edit_CEME_help"]			= "~#factarray[CEME]#~<br /><br />Angiv navnet på kirkegården eller andet bisættelsessted, hvor personen er stedt til hvile.<br /><br />";
$pgv_lang["edit_ASSO_help"]			= "~#factarray[ASSO]#~<br /><br />Angiv tilhørende GEDCOM ID.<br /><br />";
$pgv_lang["edit_RELA_help"]			= "~#factarray[RELA]#~<br /><br />Vælg en benævnelse fra listen. Hvis du vælger <b>Gudfar</b>, så betyder det: <i>Denne person er Gudfar til den viste person</i>.<br /><br />";
$pgv_lang["show_spouse_help"]		= "~#pgv_lang[show_spouses]#~<br /><br />Som standard vises ægtefæller til efterkommere ikke, fordi det gør slægtstræet vanskeligere at læse og/eller forstå.  - Men du har her muligheden for at vise ægtefæller i slægtstræet ved at afmærke denne checkboks.<br /><br />";
$pgv_lang["reorder_families_help"]	= "~#pgv_lang[reorder_families]#~<br /><br />Familier på fanebladet: <b>#pgv_lang[relatives]#</b> bliver vist i den rækkefølge, de er gemt i slægtsdatabasen.  Familierne er ikke sorteret efter vielsesdato fordi denne dato ofte er ukendt i modsætning til rækkefølgen af vielser.<br /><br />Dette valg giver dig mulighed for at ændre rækkefølgen for, hvordan de skal vises på denne side for #pgv_lang[relatives]#.  Hvis du ønsker at sortere familierne efter vielsesdato, kan du klikke på knappen for automatisk sortering.<br /><br />";
$pgv_lang["import_marr_names_help"]	= "~#pgv_lang[import_marr_names]#~<br /><br />Hvis du vælger at tilføje efternavnet som gift (giftenavnet), vil PhpGedView checke alle kvinder i din slægtsdatabase og automatisk tilføje navnet til eventuelle ægtefæller som en tillægsoplysning til pigenavnet.  Herved kan du søge efter disse kvinder udfra både giftenavn og pigenavn.<br /><br />Dette valg vil også give dig mulighed for at vise giftenavn i personlisten, hvis du har aktiveret valget <b>#pgv_lang[SHOW_MARRIED_NAMES]#</b> under indstillinger af GEDCOM-konfigurationen.<br /><br />";
$pgv_lang["firstname_alpha_help"]	= "~Alfabetisk indeks for fornavn~<br /><br />Det efternavn, du har valgt, har flere end 500 personer.  For at hjælpe dig med at finde den rigtige person, har vi opdelt listen således, at du også kan søge på forbogstaverne i fornavnet til personerne.<br /><br />Indekset virker på samme måde som indekset for efternavn; <br /> - Klik på et bogstav for at se alle personer hvis fornavn begynder med dette bogstav.<br /> - Klik på <b>#pgv_lang[NN]#</b> for at se alle personer med ukendt fornavn.<br /> - Klik på <b>ALLE</b> for at se alle personer med dette efternavn.  Hvis der er mange navne, kan der gå lidt tid inden listen vises på skærmen.<br /><br />";
$pgv_lang["edit_UPLOAD_FILE_help"]	= "~Upload mediefiler~<br /><br />Hvis en mediefil ikke findes på serveren, vil dette felt give dig mulighed for at uploade filen til folderen: media.  Hvis du uploader en fil, vil indholdet i feltet #factarray[FILE]# blive slettet.  Hvis systemet understøtter den uploadede filtype, vil der automatisk blive genereret en miniatureversion af billederne i formaterne JPG, GIF eller PNG.<br /><br />";
$pgv_lang["edit_TYPE_help"]			= "~#factarray[TYPE]#~<br /><br />Feltet: <b>#factarray[TYPE]#</b> giver dig mulighed for at angive en brugerdefineret begivenhed.  Feltet er ikke bundet til et format, så der er frit slag mht. hvad indholdet skal være.<br /><br />";
$pgv_lang["edit_TEMP_help"]			= "~#factarray[TEMP]#~<br /><br />I dette felt kan du anføre, hvor LDS (Mormoner) ordineringen fandt sted.<br /><br />";
$pgv_lang["edit_STAT_help"]			= "~#factarray[STAT]#~<br /><br />Dette felt er et valgfrit statusfelt og anvendes for det meste til at angive, hvor langt en person er kommet i LDS (Mormoner) TempleReady ordineringsprogrammet.<br /><br />";
$pgv_lang["edit__PRIM_help"]		= "~#factarray[_PRIM]#~<br /><br />Brug dette felt til at angive at dette billede (mediefil) er hovedbilledet for den person, det er knyttet til.  Hovedbilledet er det, der bliver anvendt i slægtstræer og på siden med personoplysninger for den pågældende person.<br /><br />";
$pgv_lang["edit__THUM_help"]		= "~#factarray[_THUM]#~<br /><br />Dette er et PhpGedView specifikt felt, som giver dig mulighed for at angive, at det er det miniaturebillede, der skal anvendes i slægtstræer, selvom et miniaturebillede ikke findes for originalbilledet.<br /><br />";
$pgv_lang["edit_TITL_help"]			= "~#factarray[TITL]#~<br /><br />Angiv en titel på det objekt du redigerer.  Hvis det er titlen på et multimedieobjekt, angiver du en beskrivende titel, der også vil blive vist for besøgende på websitet.<br /><br />";
$pgv_lang["edit_FILE_help"]			= "~#factarray[FILE]#~<br /><br />Dette er det vigtigste felt i frobindelse med multimediefiler!  Her anføres det, hvilken fil, der skal anvendes.<br />Som et absolut minimum, skal du angive navnet på filen.  Afhængig af, hvilke indstillinger du har foretaget i PhpGedView, så skal du måske angive mere information vedr. filens placering.<br /><br />Du kan vælge <b>#pgv_lang[find_media]#</b> som en hjælp til at lokalisere de mediefiler, du allerede har uploadet til websitet.<br /><br />#pgv_lang[readme_help]#<br /><br />";
$pgv_lang["edit_FORM_help"]			= "~#factarray[FORM]#~<br /><br />Dette er et valgfrit felt, der kan anvendes til at angive format af multimediefilen.  Nogle slægtsprogrammer checker dette felt for at finde ud af, hvordan de skal håndtere objektet.  På den anden side, så er det ikke særlig vigtigt, fordi multimedieobjekter overføres forholdsvis dårlig mellem forskellige PC platforme.<br /><br />";
$pgv_lang["generate_thumb_help"]	= "~Generer miniaturebillede~<br /><br />Vi har fundet ud af at din server har mulighed for automatisk at generere miniaturebilleder ud fra bestemte billedformater.  Filformaterne JPG, GIF og PNG kan understøttes.  Formaterne, som din server understøtter, er vist ved siden af checkboksen.<br /><br />Ved at afkrydse denne checkboks, så fortæller du til systemet, at billeder uploades i et eller flere af disse formater, og at du ønsker, at der skal genereres miniaturebilleder af dem.  Hvis du ikke afkrydser checkboksen, så må du eventuelt lave miniaturebilleder selv.<br /><br />";
$pgv_lang["edit_add_NOTE_help"]		= "~#pgv_lang[add_note]#~<br /><br />Denne del giver dig mulighed for at tilføje en ny note for de oplysninger, du redigerer.  Noter er fritekst og vil vises i detaljer for fakta på forskellige sider.<br /><br />";
$pgv_lang["edit_add_SOUR_help"]		= "~#pgv_lang[add_source]#~<br /><br />Denne del giver dig mulighed for at tilføje en ny kildehenvisning til den oplysning du redigerer.<br /><br />I kildefeltet angiver du kildens ID.  Hvis du skal oprette en ny kilde, kan du klikke på <b>#pgv_lang[create_source]#</b>.  I feltet for henvisningsdetaljer kan du angive sidenummer eller anden information, som kan hjælpe med til at finde frem til oplysningerne i kilden.  I tekstfeltet kan du også skrive direkte tekstuddrag fra kilden.<br /><br />";
$pgv_lang["edit_add_ASSO_help"]		= "~#pgv_lang[add_asso]#~<br /><br />#pgv_lang[add_asso]# giver dig mulighed til for at knytte en oplysning til en tilhørende person i slægtsdatabasen.  Det er den eneste måde, hvorpå du kan knytte en person som forlover, gudfar og lignende til en anden person.<br /><br />";
$pgv_lang["edit_QUAY_help"]			= "~#factarray[QUAY]#~<br /><br />Du kan bruge dette felt til at angive kvaliteten eller pålideligheden af oplysningerne i denne kilde.  Mange slægtsprogrammer anvender et nummer i feltet. <b>1</b> kan betyde, at oplysningerne er en førstehåndskilde, <b>2</b> kan betyde, at oplysningerne stammer fra andenhåndskilde, <b>3</b> kan betyde, at oplysningerne ikke kan dokumenteres eller er meget usikre.<br /><br />";
$pgv_lang["edit_PAGE_help"]			= "~#factarray[PAGE]#~<br /><br />I feltet for henvisningsdetaljer kan du angive sidenummer eller anden information, der kan hjælpe med til at finde frem til oplysningerne i kilden.<br /><br />";
$pgv_lang["edit_TEXT_help"]			= "~#factarray[TEXT]#~<br /><br />I dette feltet kan du angive en henvisningstekst for denne kilde.  Eksempler på oplysninger kan være et uddrag af kildeteksten eller en beskrivelse af, hvad der er i henvisningen.<br /><br />";
$pgv_lang["edit_SOUR_help"]			= "~#factarray[SOUR]#~<br /><br />Dette feltet giver dig mulighed for at ændre, hvilken kilde denne oplysning er knyttet til.  Dette felt skal KUN indeholde en kilde ID.  Ved siden af feltet er den nuværende titel vist for den gældende kilde ID.  Brug denne valgmulighed <b>#pgv_lang[find_id]#</b> til at søge efter ID-nummeret på kilden.  For at fjerne hele kildehenvisningen, så lad dette felt være tomt.<br /><br />";
$pgv_lang["edit_edit_raw_help"]		= "~#pgv_lang[edit_raw]#~<br /><br />Denne side giver dig mulighed for at ændre den \"rå\" GEDCOM-post.  Du bør anvende denne side med forsigtighed og omtanke; Det kræver at du har kendskab til og forstår GEDCOM 5.5.1 standarden.  For mere information om GEDCOM 5.5.1 standarden, se emnet <a href=\"?help=gedcom_info_help\">GEDCOM-fil</a>.<br /><br />PhpGedView giver dig mulighed for at tilføje og ændre information på mange måder, men der kan være situationer, hvor du ønsker at foretage ændringer direkte i det \"rå\" GEDCOM-format.  Hvis det er muligt, bør du benytte de tilbudte skemaer til at tilføje information. MEN, hvis det ikke er muligt, kan du anvende dette \"skema\".  Når du sender det færdig redigerede \"skema\", vil informationen blive checket efter nogle grundregler i standarden og posten CHAN (ændret af hvem og hvornår) bliver opdateret.<br /><br />";
$pgv_lang["add_from_clipboard_help"]	= "~#pgv_lang[add_from_clipboard]#~<br />PhpGedView giver dig mulighed for at kopiere oplysninger til udklipsholderen.  Du kan kopiere op til 5 oplysninger og gemme dem i udklipsholderen.  Fra \"drop-down\"-menuen Tilføj oplysning, kan du vælge at indsætte en af oplysningerne fra udklipsholderen til en anden person.  Dette kan være nyttigt, når du tilføjer de samme oplysninger, som for eksempel folketællingsoplysninger for mange personer.<br /><br />";
$pgv_lang["edit_PLAC_help"]			= "~#factarray[PLAC]#~<br /><br />Steder bør tilføjes i henhold til standarden GEDCOM 5.5.1.  I slægtsforskning skal steder tilføjes med det mest detaljerede stednavn først, og derefter mere og mere globale stednavne, separeret med komma for at angive de forskellige geografiske områder/niveauer.  Startstedet, du anvender for kilder, bør være navnet på et offentligt register eller en kirke, hvor de vitale oplysninger er opbevaret/arkiveret.<br /><br />For eksempel, et sted som Salt Lake City bør tilføjes som \"Salt Lake City, Salt Lake, Utah, USA\".<br /><br />Lad os se nærmere på hvert stednavn.  Første sted, \"Salt Lake City,\" er byen eller bydelen, hvor begivenheden indtraf.  I nogle lande kan det være bydele eller områder i en by, der er vigtig at få med. I de tilfælde bør de angives før navnet på byen.  Det næste sted, \"Salt Lake,\" er kommunenavnet.  \"Utah\" er navnet på staten, og \"USA\" er navnet på landet.  Det er vigtigt at være opmærksom på, at offentlige myndigheder på alle stedniveauer, nævnt i eksemplet, kan have registre, der indeholder slægtsoplysninger.<br /><br />Hvis du ikke kender navnet på et niveau, bør du lade niveauet være tomt ved at tilføje et mellemrum mellem de to kommaer.<br />- Forestil dig at, i nævnte eksempel, at du ikke kendte navnet på den kommune Salt Lake City ligger i.  Da bør stederne på de forskellige niveauer, skrives således: \"Salt Lake City, , Utah, USA\".<br />- Forestil dig, at du kun ved at en person var født i Utah.  Da bør du skrive stedsangivelsen på denne måde: \", , Utah, USA\".<br /><br />Du kan bruge valgmuligheden <b>#pgv_lang[find_place]#</b> for at hjælpe dig med at finde steder, der allerede findes i slægtsdatabasen.<br /><br />";
$pgv_lang["edit_add_parent_help"]	= "~Tilføj ny mor eller far~<br /><br />På denne side kan du tilføje en ny mor eller far til den valgte person.  Anfør navnet på den nye person, samt information om fødselsdato og dødsdato, hvis det kendes.  Har du ikke nok information til at udfylde alle felter, så er det OK at lade felterne være tomme.<br /><br />For at tilføje andre faktaoplysninger, så må du først gemme de ovenfor nævnte oplysninger.  Så kan du gå til den opdaterede familieside og klikke på personens navn. Så vil du få personens faktaside frem, hvor du kan tilføje flere faktaoplysninger.<br /><br />";
$pgv_lang["edit_add_spouse_help"]	= "~Tilføj ny ægtemand eller hustru~<br /><br />På denne siden kan du tilføje en ny ægtemand eller hustru til den valgte person.  Anfør navnet på den nye person, samt information om fødselsdato og dødsdato, hvis det kendes.  Har du ikke nok information til udfylde alle felter, så er det OK at lade felterne være tomme.<br /><br />For at tilføje andre faktaoplysninger, så må du først gemme de ovenfor nævnte oplysningene.  Så kan du gå til den opdaterede familieside og klikke på personens navn. Så vil du få personens faktaside frem, hvor du kan tilføje flere faktaoplysninger.<br /><br />";
$pgv_lang["edit_death_help"] 		= "~#pgv_lang[death]#~<br /><br />Dette område giver dig mulighed for at tilføje information om personens død.<br /><br />Anfør først personens dødsdato i <a href=\"?help=def_gedcom_date_help\">standard datoformat</a> for slægtsforskning (1 OCT 2004).  Du kan klikke på ikonet for <b>Kalender</b> for at få hjælp til at vælge en dato.<br /><br />Derefter angiver du stedet, hvor personen døde i <a href=\"?help=edit_PLAC_help\">standard stedformat</a> for slægtsforskning.  Du kan klikke på ikonet for <b>#pgv_lang[find_place]#</b> for at vælge et sted, der allerede findes i slægtsdatabasen.<br /><br />";
$pgv_lang["edit_birth_help"] 		= "~#pgv_lang[birth]#~<br /><br />Dette området giver dig mulighed for at tilføje information om personens fødsel.<br /><br />Angiv først personens fødselsdato i <a href=\"?help=def_gedcom_date_help\">standard datoformat</a> for slægtsforskning (1 OCT 2004).  Du kan klikke på ikonet for <b>Kalender</b> for at få hjælp til at vælge en dato.<br /><br />Derefter angiver du stedet, hvor personen blev født i <a href=\"?help=edit_PLAC_help\">standard stedformat</a> for slægtsforskning.  Du kan klikke på ikonet for <b>#pgv_lang[find_place]#</b> for at vælge et sted, der allerede findes i slægtsdatabasen.<br /><br />";
$pgv_lang["edit_sex_help"]			= "~#pgv_lang[sex]#~<br /><br />Vælg ret køn fra \"drop-down\"-listen.  Valgmuligheden <b>Ukendt</b> indikerer, at du ikke kender personens køn.<br /><br />";
$pgv_lang["edit_name_help"]			= "~#pgv_lang[name]#~<br /><br />Dette er det vigtigste feltet for en person i slægtsbasen.  Dette felt skulle, som udgangspunkt have været udfyldt automatisk, men det er åbent så du kan ændre informationen i henhold til dine personlige preferencer.  Navnet i dette felt bør skrives ind i henhold til GEDCOM 5.5.1 standarden med efternavnet omgivet af skråstreger \"/\".<br /><br />Som et eksempel, bør navnet \"John Robert Finlay Jr.\" skrives ind som: <b>John Robert /Finlay/ Jr.</b><br />Hvis personen sædvanligvis kun bruger et af fornavnene (her John), kan navnet skrives ind som: <b>\"John\" Robert /Finlay/ Jr.</b><br /><br />";
$pgv_lang["edit_suffix_help"]		= "~#pgv_lang[suffix]#~<br /><br />I dette valgfrie felt kan du tilføje et suffiks til personens navn.  Eksempler på suffiks til et navn kan være \"de.\", \"dy.\",\"Sr.\", \"Jr.\" og \"III\".<br /><br />";
$pgv_lang["edit_surname_help"]		= "~#pgv_lang[surname]#~<br /><br />I dette felt kan du tilføje personens efternavn.  Som et eksempel, i navnet \"John Robert Finlay\", vil efternavnet være \"Finlay\".<br /><br />";
$pgv_lang["edit_NICK_help"]			= "~#factarray[NICK]#~<br /><br />I dette valgfrie felt kan du tilføje personens kaldenavn.<br />Dette felt kan også benyttes, hvis en person er kendt under et alias navn (også kendt som). Eksempel på dette kan være kunstnernavn.<br /><br />";
$pgv_lang["edit_given_name_help"]	= "~#pgv_lang[given_name]#~<br /><br />I dette felt kan du tilføje personens fornavn.  Som et eksempel, i navnet \"John Robert Finlay\", vil fornavnet være \"John Robert\".<br /><br />";
$pgv_lang["edit_NPFX_help"]			= "~#factarray[NPFX]#~<br /><br />Dette valgfrie felt giver dig mulighed for at tilføje et præfiks til navnet som for eksempel \"Dr.\" eller \"Lt.\"<br /><br />";
$pgv_lang["edit_add_child_help"]	= "~#pgv_lang[add_child]#~<br /><br />På denne side kan du tilføje et barn til den valgte familie.  Anfør barnets navn, samt information om fødselsdato og dødsdato, hvis det kendes.  Har du ikke nok information til udfylde alle felter, så er det OK at lade felterne være tomme.<br /><br />For at tilføje andre faktaoplysninger, så må du først gemme de ovenfor nævnte oplysninger.  Så kan du gå til den opdaterede familieside og klikke på barnets navn. Så vil du få barnets faktaside frem, hvor du kan tilføje flere faktaoplysninger.<br /><br />";

$pgv_lang["review_changes_help"]	= "~Ikke godkendte ændringer~<br /><br />Denne ramme viser alle de ændringer, der er foretaget i slægtsdatabasen online, og som skal checkes og godkendes for at de kan vises i slægtstræer, lister og andre faktasider.<br /><br />";
$pgv_lang["quick_update_name_help"] = "~opdater navn~<br /><br />Brug felterne \"opdater navn\" for at ændre navnet på den valgte person.<ul><li>I feltet for fornavn, angiver du personens fornavn og eventuelle mellemnavne.</li><li>I feltet for efternavn angiver du personens efternavn.</li></ul>Eksempel: Hvis personen hedder \"John Robert Finlay\", så angiver du<ul><li>Fornavn: \"John Robert\"</li><li>Etternavn: \"Finlay\"</li></ul><b>NB!</b> Ved at udfylde disse felter, så vil du <u>ændre</u> personens navn; - ikke tilføje et nyt navn!<br /><br /><b>PS!</b> <i>Du bør <u>ikke</u> bruge denne metode til at ændre efternavn på grund af giftermål!<br />- Brug i stedet valgmuligheden nedenfor til at tilføje en ny ægtemand/hustru.</i><br /><br />";
$pgv_lang["quick_update_fact_help"] = "~opdater en faktaoplysning~<br /><br />Brug felterne \"opdater en faktaoplysning\" for at tilføje en ny eller ændre en eksisterende faktaoplysning for personen.<ol><li>Vælg type af faktaoplysning</li><li>Angive datoen for, hvornår begivenheden indtraf i <a href=\"?help=def_gedcom_date_help\">standard datoformat</a> for slægtsforskning (1 OCT 2004).  Du kan klikke på ikonet for <b>Kalender</b> for at få hjælp til at vælge en dato.</li><li>Angiv stedet, hvor begivenheden indtraf i <a href=\"?help=edit_PLAC_help\">standard stedformat</a> for slægtsforskning.  Du kan klikke på ikonet for <b>#pgv_lang[find_place]#</b> for at vælge et sted, der allerede findes i slægtsdatabasen.</li></ol>Som i alle de andre felter i dette skema, så vil oplysningerne du opgiver enten erstatte det eksisterende indhold eller også vil der blive oprettet en ny faktaoplysning alt efter det, der er valgt.<br /><br />";
$pgv_lang["quick_update_photo_help"]	= "~opdater billede~<br /><br />Brug feltet \"opdater billede\" for at uploade et billede af denne person.<br />I titelfeltet kan du anføre en beskrivende titel på billedet, som fx. \"Rasmus Kristensen 1953\".<br />Derefter klikker du på knappen <b>Browse</b> for at finde billedet på din PC.<br /><br />Hvis der allerede findes et billede af denne person, så vil du også få en checkboks, hvor du kan vælge at tilføje billedet eller erstatte det billede, der allerede findes.<br /><br />";
$pgv_lang["quick_update_address_help"]	= "~opdater adresse~<br /><br />Brug felterne \"opdater adresse\" for at ændre adressen, telefonnummeret eller e-mail-adressen til denne person.<br /><br />Som i alle de andre felter i dette skema, så vil oplysningerne du opgiver enten erstatte det eksisterende indhold eller blive oprettet som en ny faktaoplysning alt efter det der er valgt.<br /><br />";
$pgv_lang["quick_update_spouse_help"] 	= "~Tilføj en ny ægtemand/hustru~<br /><br />Brug disse felter, hvis du ønsker at tilføje en ny ægtemand/hustru til denne person.<ol><li>Skriv navnet på den nye ægtefælle</li><li>Angiv datoen for ægteskapet blev indgået i <a href=\"?help=def_gedcom_date_help\">standard datoformat</a> for slægtsforskning (1 OCT 2004).  Du kan klikke på ikonet for <b>Kalender</b> for at få hjælp til at vælge en dato.</li><li>Angiv stedet, hvor ægteskabspagten blev indgået i <a href=\"?help=edit_PLAC_help\">standard stedformat</a> for slægtsforskning.  Du kan klikke på ikonet for <b>#pgv_lang[find_place]#</b> for at vælge et sted, der allerede findes i slægtsdatabasen.</li></ol><b>NB!</b> Disse felter vil <b>bare</b> lægge til en <i>ny</i> partner; de vil <b>ikke</b> opdatere information om et allerede registreret ægteskab.  For at ændre oplysninger om et ægteskab, der allerede er registreret, må du gå til fanebladet: <b>#pgv_lang[relatives]#</b> på siden med personoplysninger for den pågældende person, og vælge den ønskede ægtemand/hustru. Derefter kan du udføre de ændringer du ønsker for denne person.<br /><br />";
$pgv_lang["quick_update_marriage_help"] = "~opdater ægteskab~<br /><br />Du kan bruge disse felter sammen med felterne for at tilføje en ny ægtemand/hustru, hvis du ønsker at tilføje et nyt ægteskab.<br /><br />Hvis du kun tilføjer oplysninger i disse felter for ægteskab, vil ændringerne blive \"bogført\" det sidst registrerede ægteskab for personen.<ol><li>Angiv datoen for ægteskabets indgåelse i <a href=\"?help=def_gedcom_date_help\">standard datoformat</a> for slægtsforskning (1 OCT 2004).  Du kan klikke på ikonet for <b>Kalender</b> for at få hjælp til at vælge en dato.</li><li>Angiv stedet, hvor ægteskabspagten blev indgået i <a href=\"?help=edit_PLAC_help\">standard stedformat</a> for slægtsforskning.  Du kan klikke på ikonet for <b>#pgv_lang[find_place]#</b> for at vælge et sted, der allerede findes i slægtsdatabasen.</li></ol>";
$pgv_lang["quick_update_child_help"] 	= "~Tilføj et nyt barn~<br /><br />Brug disse felter til at tilføje et nyt barn af denne person.<ol><li>Skriv navnet på det nye barn</li><li>Angiv barnets køn</li><li>Angiv barnets fødselsdato i <a href=\"?help=def_gedcom_date_help\">standard datoformat</a> for slægtsforskning (1 OCT 2004).  Du kan klikke på ikonet for <b>Kalender</b> for at få hjælp til at vælge en dato.</li><li>Angiv stedet, hvor barnet blev født i <a href=\"?help=edit_PLAC_help\">standard stedformat</a> for slægtsforskning.  Du kan klikke på ikonet for <b>#pgv_lang[find_place]#</b> for at vælge et sted, der allerede findes i slægtsdatabasen.</li></ol>Disse felter vil <b>kun</b> tilføje et <u>nyt</u> barn.  De vil <b>ikke</b> opdatere oplysninger for et barn, der allerede er registreret.  For at ændre oplysninger om et ægteskab, der allerede er registreret, må du gå til fanebladet: <b>#pgv_lang[relatives]#</b> på siden med personoplysninger for den pågældende person, og vælge det ønskede barn. Derefter kan du udføre de ændringer du ønsker for denne person.<br /><br />";
$pgv_lang["index_top10_pageviews_help"]	= "~Vist flest gange~<br /><br />Denne ramme vil vise de 10 mest viste personer, familier eller kilder på websitet.  For at kunne vise denne ramme, skal administratoren af websitet have aktiveret tælleren.<br /><br />";
$pgv_lang["useradmin_user_default_tab_help"]	= "~Standardindstilling for faneblad~<br /><br />Dette valg giver dig mulighed for at angive, hvilket faneblad, der skal åbnes automatisk når siden #pgv_lang[indi_info]# blir vist.  Hvis en bruger kan ændre sin konto, kan de forskellige brugere vælge sit eget standard faneblad.<br /><br />";
$pgv_lang["edituser_user_default_tab_help"]	= "~Brugerindstilling for standard faneblad~<br /><br />Dette valg giver dig, som bruger, mulighed for at angive, hvilket faneblad, der skal åbnes automatisk når siden #pgv_lang[indi_info]# blir vist.<br /><br />";
$pgv_lang["reorder_children_help"]		= "~Skift rækkefølge på børn~<br /><br />Børnene er vist i den rækkefølge de blev lagt ind i slægtsdatabasen.  Børn bliver ikke vist efter fødselsdato, fordi denne dato ofte er ukendt..<br /><br />Dette valg giver dig muligheden for at ændre rækkefølgen for, hvordan de skal vises på denne side for #pgv_lang[relatives]# og siden for familier.  Hvis du ønsker at sortere børnene efter fødselsdato, kan du klikke på knappen for automatisk sortering.<br /><br />";
$pgv_lang["rss_feed_help"]				= "~Indstillinger for RSS-visning~<br /><br />RSS-visningen, der er tilgængelig i PhpGedView, giver dig mulighed for at se hovedindholdet fra hovedsiden i din favorit-samling for RSS-visning uden at du besøger websitet. De fleste RSS-indsamlere vil vise et \"popup\"-vindue for at gøre dig opmærksom på at noget er blevet ændret på hovedsiden. Dette gør, at du kan følge med i ændringer på et PhpGedView website uden at du besøger det jævnligt. Ved hjælp af rammen for RSS-indstillinger, kan du bestemme, hvilke links, der skal samles ind, vælge specielle indsamlingsmetoder (de fleste browsere kan håndtere de fleste af metoderne, så det kan almindeligvis være sat som standard), og hvilke rammer du ønsker at samle ændringer ind fra. Det sprog, der anvendes ved indsamlingen, vil være baseret på det sprog, der var aktivt i PhpGedView, da du aktiverede RSS-indsamlingen. Indsamlingsmetoderne, der kan blive genereret, inkluderer RSS 0.92, RSS 1.0, RSS 2.0, ATOM, HTML og JavaScript. De 4 første er for ren RSS-indsamling, mens JavaScript og HTML understøttes for at etablere koblinger mellem RSS-indsamlinger fra andre internetsider.<br /><br />Vær opmærksom på, at de forskellige RSS-versionsnumre indikerer forskellige typer og ikke forskellige versioner.<br /><br />";
//-- GENERAL
$pgv_lang["help_header"]				 = "Information om:";
$pgv_lang["privacy_error_help"]			= "<b>~Private oplysninger~</b><br />Der er flere mulige årsager til denne meddelelse:<b><dl><dt>1. Information om levende personer er sat til \"Privat\"</b></dt><dd>Besøgende og registrerede brugere som ikke er logget ind, kan bare se information for døde personer! Hvis administrator har åbnet for det, kan du registrere dig ved at klikke på 'Log ind', og derefter på  #pgv_lang[requestpassword]#.</dd><dt><b>2. Du er en registreret bruger med brugernavn og adgangskode</b></dt><dd>Men du har glemt at logge dig ind eller, at du ikke har været aktiv et stykke tid og er blevet logget ud automatisk.</dd><dt><b>3. Af hensyn til privatlivets beskyttelse</b></dt><dd>Personen ønsker at faktaoplysninger om sig selv skal være \"Privat\" eller at personen ikke ønsker at blive vist i det hele taget (skjult).<br />Beskyttelse af privatlivet kan sættes til:<br />a) #pgv_lang[PRIV_USER]#<br />b) #pgv_lang[PRIV_NONE]#<br />c) #pgv_lang[PRIV_HIDE]#</dd><dt><b>4. Ut fra \"Grad af slægtskab\"</b></dt><dd>Selvom du er en sædvanlig bruger <i>og</i> logget ind, så kan det ske, at du vil se denne meddelelse, hvis den person, du prøver at se, ikke er i <b>nær</b> slægt med dig. Slægtskab er defineret som et vist antal trin, og er bestemt af administratoren af denne slægtsside.<br /><br /><b>Eksempler:</b><br />- Når trinlængden for slægtskab er sat til <b>1</b>, så kan du kun se detaljerne for din egen familie, far, mor, bror og søster (men ikke din brors eller søsters ægtefæller og børn)<br />- Når trinlængden for slægtsskab er sat til <b>2</b>, så kan du også se detaljerne vedr. dine søkendes ægtefæller og deres børn (men ikke ægtefæller til deres børn).<br />- Jo højere trinlængde for slægtsskabet er sat til, jo flere detaljer for fjernere slægtninge kan du se.</dd></dl>Hvis du mener, at du er kvalificeret til at se visse detaljer, så kontakt venligst administratoren ved at anvende kontaktlinket nederst på siderne.";
$pgv_lang["more_help"]					= "<br />Hvis du ønsker mere (detaljeret) hjælp, kan du klikke på <b>#pgv_lang[qm]#</b> anbragt efter de forskellige valgmuligheder, rammer mm. på skærmen.<br />PS. Check at <b>#pgv_lang[show_context_help]#</b> (under hjælp i menuen) er aktiv!<br />";
$pgv_lang["more_config_help"]			= "<br /><b>Mere hjælp</b><br />Yderligere hjælp er tilgængelig for skemaet. - Klik venligst på <b>?</b> bagefter ledeteksten eller boksen.<br />";
$pgv_lang["start_admin_help"]			= "<b>+++ <i>Start ekstra info for Admin</i> +++</b>";
$pgv_lang["end_admin_help"]				= "<b>--- <i>Slut ekstra info for Admin</i> ---</b>";
$pgv_lang["multiple_help"]				= "<center>--- Dette er en generel hjælpetekst for flere sider ---</center>";
$pgv_lang["header_general_help"]		= "<a name=\"#header_general#\"></a><div class=\"name_head\"><center><b>Generel information</b></center></div><br />";
$pgv_lang["best_display_help"]			= "~Din Skærm~<br />PhpGedView ses bedst med en skærmopløsning på 1024x768.<br />Med denne opløsning vil du kunne se alle dele på en gang.<br />Hvis du har valgt en lavere opløsning (for eksempel 800x600), vil du til en vis grad blive tvunget til at bruge den vandrette scroll-funktion for at kunne se al information.<br />";
$pgv_lang["preview_help"]				= "~Udskriftsvenlig version~<br />Ved at klikke på linket \"#pgv_lang[print_preview]#\", vil du få en side frem, der vil se pænere ud i udskrift (Bla. er følgende fjernet: menuen, \"valg-felt\", ekstra \"links\" mm.).<br /><br />Nederst på den \"udskriftsvenlige\" side, vil du se linket \"#pgv_lang[print]#\". Ved at klikke på den, får du et vindue frem, du kan printe ud. Efter at siden er sendt til printeren, kan du trykke på linket \"#pgv_lang[cancel_preview]#\".<br /><br /><b>NB:</b><i> - Selvom der er fjernet mange links i den \"#pgv_lang[print_preview]#n\", kan du bare klikke på de resterende links.</i><br />";
$pgv_lang["readme_help"]				= "<center>Se i filen <a href=\"readme.txt\" target=\"_blank\"><b>Readme.txt</b></a> for mere information.</center>";
$pgv_lang["is_user_help"]				= "<b>PS!<ul><li>Denne hjælpetekst er den samme, som brugere (eller besøgende) vil få.<li>For at spare plads, så er egen tekst for administratorer ikke angivet her.</b></ul>";
$pgv_lang["edit_raw_gedcom_help"]		= "~Ændre kildedata direkte (i GEDCOM)~<br /><br />Hvis du klikker her, vil du få et nyt vindue frem med kildedata (GEDCOM) knyttet til oplysninger på denne side.<br />Her kan du ændre dataene, der findes i slægtsfilen (GEDCOM).<br /><b>PS! Du må <i>kun</i> ændre / tilføje oplysninger i henhold til  GEDCOM 5.5 standarden, fordi ændringerne <i>ikke</i> vil blive kvalitetssikret!</b><br />Ændringerne og/eller tilføjelserme vil blive vist i PhpGedView som Ændringer, og skal godkendes af en bruger med rettigheder til at godkende ændringer før de bliver vist som ordinære data.";
$pgv_lang["RESN_help"]				= "~begrænsning af indstillingsmulighederne for faktaoplysninger~<br /><br />Med undtagelse af generelle indstillinger for privatliv, har man i PhpGedView muligheden for at begrænse visning og ændring af faktaoplysninger for personer og familier. Begrænsningerne kan sættes af alle, der har ret til at ændre information, med undtagelse af, hvor tidligere indstillinger eller indstiller for privatliv forhindrer det.<br /><br />Følgende værdier kan anvendes:<br /><ul><li><b>#pgv_lang[none]#</b><br/>Administratorer af websitet, administratorer af slægtsdatabasen (GEDCOM) og brugere, der har rettigheder til at ændre, kan ændre information.<br />Faktaoplysninger kan vises afhængig af indstillingerne mht. privatliv, der er lagt ind af administratoren.</li><li><b>#pgv_lang[locked]#</b><br />Denne indstilling har ingen indflydelse på, hvorledes faktaoplysninger vises. Den begrænser retten til at ændre for administratorer af websitet og administratorer af slægtsdatabasen (GEDCOM). Hvis oplysningerne gælder brugeren selv, kan han også se og ændre disse, hvis han har rettigheder til at ændre.</li><li><b>#pgv_lang[privacy]#</b><br />Administratorer af websitet og administratorer af slægtsdatabasen (GEDCOM) kan se og ændre oplysningerne. Hvis oplysningerne gælder brugeren selv, kan han også se og ændre disse, hvis han har rettigheder til at ændre. Oplysningerne vil være skjult for alle andre brugere uafhængig af brugerstatus.</li><li><b>#pgv_lang[confidential]#</b><br />Kun administratorer af websitet og administratorer af slægtsdatabasen (GEDCOM) kan se og ændre oplysningerne. Oplysningerne vil være skjult for alle andre brugere uafhengig af brugerstatus.</li></ul><br /><table><tr><th></th><th colspan=2>Admin</th><th colspan=2>Ejer</th><th colspan=2>Andre</th></tr><tr><th></th><th>L</th><th>S</th><th>L</th><th>S</th><th>L</th><th>S</th></tr><tr><td><img src=\"images/RESN_none.gif\" alt=\"\"/> #pgv_lang[none]#</td><th><img src=\"images/checked.gif\"/></th><th><img src=\"images/checked.gif\"/></th><th><img src=\"images/checked_qm.gif\"/></th><th><img src=\"images/checked_qm.gif\"/></th><th><img src=\"images/checked_qm.gif\"/></th><th><img src=\"images/checked_qm.gif\"/></th></tr><tr><td><img src=\"images/RESN_locked.gif\" alt=\"\"/> #pgv_lang[locked]#</td><th><img src=\"images/checked.gif\"/></th><th><img src=\"images/checked.gif\"/></th><th><img src=\"images/checked_qm.gif\"/></th><th><img src=\"images/checked_qm.gif\"/></th><th><img src=\"images/checked_qm.gif\"/></th><th><img src=\"images/forbidden.gif\"/></th></tr><tr><td><img src=\"images/RESN_privacy.gif\" alt=\"\"/> #pgv_lang[privacy]#</td><th><img src=\"images/checked.gif\"/></th><th><img src=\"images/checked.gif\"/></th><th><img src=\"images/checked_qm.gif\" /></th><th><img src=\"images/checked_qm.gif\"/></th><th><img src=\"images/forbidden.gif\"/></th><th><img src=\"images/forbidden.gif\"/></th></tr><tr><td><img src=\"images/RESN_confidential.gif\" alt=\"\"/> #pgv_lang[confidential]#</td><th><img src=\"images/checked.gif\"/></th><th><img src=\"images/checked.gif\"/></th><th><img src=\"images/forbidden.gif\"/></th><th><img src=\"images/forbidden.gif\"/></th><th><img src=\"images/forbidden.gif\"/></th><th><img src=\"images/forbidden.gif\"/></th></tr></table><ul><li>L : kan læse</li><li>S : kan ændre</li><li><img src=\"images/checked_qm.gif\"/> : afhængig af globale indstillinge for privatliv</li></ul>";


//-- Pages Help-messages 
//-- Index-page
$pgv_lang["index_help"]					= "~Velkomstsiden~<br />Velkomstsiden er også hovedside, og  ønsker dig velkommen til denne slægtsdatabase (<a href=\"#def_gedcom\">GEDCOM</a>-fil). Du kan altid komme tilbage til denne side ved at vælge <i>#pgv_lang[welcome_page]#</i> i hovedmenuen. Hvis der er flere slægtsdatabaser på dette website, vil du også få en undermenu op, hvor du kan vælge den ønskede slægtsdatabase.<br /><b>Du kan her få information om:</b><ul><li><a href=\"#index_portal\">#pgv_lang[welcome_page]#</a><li><a href=\"#header\">#pgv_lang[header]#</a><li><a href=\"#menu\">#pgv_lang[menu]#</a><li><a href=\"#header_general\">Generel information</a><li><a href=\"#def\">Definitioner</a></ul><br /><a href=\"#def_pgv\"><b>PhpGedView #VERSION#</b></a> har fået en ny og forhåbentlig bedre udformning.<br />Den har fået en ny menu, helt ny velkomstside, egne brugersider (Min GedView Portal) og flere funktioner er forbedret og/eller fornyet.<br /><br />";

//-- Index-page Header 
$pgv_lang["header_help"]				= "<div class=\"name_head\"><center><b>Topfeltet på siden</b></center></div><br />Den øverste del af siderne (topfeltet) bliver vist på hver side.<br />Her finder du nogle nyttige valgmuligheder / links, som du kan bruge på alle sider.<br />PhpGedView kan have forskellig udseende. Ved at vælge forskellige <a href=\"#def_theme\">temaer</a>, vil topfeltet kunne indeholde forskellige links / valgmuligheder.<br /><br /><b>Valg / links, som du kan finde er:</b><ul><li><a href=\"#header_search\">Søgefelt</a><li><a href=\"#header_lang_select\">Vælg sprog</a><li><a href=\"#header_user_links\">Log ind/log ud</a><li><a href=\"#header_favorites\">#pgv_lang[my_favorites]#</a><li><a href=\"#header_theme\">#pgv_lang[change_theme]#</a></ul>";
$pgv_lang["header_search_help"]			= "~Topfeltet: Søgefelt~<br />Dette søgefelt er kort, men effektivt.<br />Du kan skrive og søge på næsten hvadsomhelst, som du tror du kan finde i slægtsdatabasen. Når du klikker på knappen \" <b>&gt;</b> \" eller \"Søg\", vil du få søgeresultatet vist.<br />Du kan finde yderligere hjælp om dette på søgehovedsiden.<br />";
$pgv_lang["header_lang_select_help"]	= "~Topfeltet: Vælg sprog~<br />En af de gode funktioner i dette program, er at det automatisk vil vælge det sprog, som du bruger på din PC (hvis det er understøttet).<br />- Det kan hænde, at det ikke virker som forventet (f.eks. fordi din browser ikke har den korrekte indstilling mht. \"Foretrukket sprog\").<br />Du kan skifte sprog ved at benytte feltet:&nbsp; <b>Vælg sprog</b>.<br /><br /><b>Vælg sprog</b> kan blive vist på to forskellige måder:<ul><li>Det klassiske valgfelt med en \"drop-ned\"-liste.<li>Et farverigt område med nationalflagene for de forskellige sprog.</ul><br /><b>PS!</b> Af og til vil du kunne finde dette felt nederst på siden...<br />";
$pgv_lang["header_user_links_help"]		= "~Topfeltet: Log ind/log ud~<br />Dette er først og fremmest for dig, der er registreret som bruger på dette website.<br /> PS. Hvis du ikke er en registreret bruger, så kan du søge om at blive det ved at klikke på:<dl><dt><b>Log ind</b></dt><dd>Dette link vil du se, hvis du ikke er logget ind som bruger.</dd><dt><b>Logget ind som (dit brugernavn)</b><dt><dd>Dette link vil du kun se, hvis du er logget ind. Ved at klikke på dette link vil du få siden med \"Min konto\" op.</dd><dt><b>Logout</b></dt><dd> Dette link betyder: Du mister dine brugerrettigheder og bliver en almindelig besøgende.</dd><dt><b>Admin</b></dt><dd>Hvis du har administratorrettigheder, så vil du også se dette link når du er logget ind. Ved at klikke på linket vil du få hovedsiden for Administration op.</dd></dl>";
$pgv_lang["header_favorites_help"]		= "~Topfeltet: Mine favoritter~<br />Denne \"drop-down\"-liste vil vise dig favoritter i slægtsdatabasen, valgt af administratoren af websitet. Hvis du er en registreret bruger og har logget ind, vil du se dne favoritter, som du har valgt på din personlige hovedside.<br />Ved at klikke på en af favoritterne, vil du få siden: <b>Oplysninger om personen</b> op for den valgte favoritperson.<br />Mere hjælp om at tilføje nye links til  \"Dine favoritter\" er tilgængelig på din personlige side (Min GedView Portal).<br />";
$pgv_lang["header_theme_help"]			= "~Topfeltet: Skift tema (layout)~<br />Når denne mulighed er aktiveret af administratoren af websitet, vil \"drop-down listen\" for <i>Skift tema</i> vise dig en liste med forskellige temaer, som du kan anvende på dette website.  Ved at vælge et nyt tema fra denne liste, vil du bruge dette udseende så længe du besøger websitet.  Hvis du er logget ind, vil dette også ændre dit eget standard-tema således, at det nye også vil vises næste gang du logger dig ind.<br />";

//-- Index-page Menu 
$pgv_lang["menu_help"]					= "<div class=\"name_head\"><center><b>Menuen</b></center></div><br />Øverst på hver side finder du menuen med tilhørende undermenuer.<br />Flytter du musen henover menuens ikoner, vil du på de fleste også få en undermenu op.<br />- Klikker du direkte på et af ikonerne i menuen, vil du få den side op, der svarer til det første valg i undermenuen.<br /><br /><b>Du kan få disse valgmuligheder i menuen:</b><ul><li><a href=\"#menu_fam\">#pgv_lang[welcome_page]#</a><li><a href=\"#menu_myged\">#pgv_lang[mygedview]#</a><li><a href=\"#menu_charts\">#pgv_lang[charts]#</a><li><a href=\"#menu_lists\">#pgv_lang[lists]#</a><li><a href=\"#menu_annical\">#pgv_lang[anniversary_calendar]#</a><li><a href=\"#menu_clip\">#pgv_lang[clippings_cart]#</a><li><a href=\"#menu_search\">#pgv_lang[search]#</a><li><a href=\"#menu_help\">#pgv_lang[page_help]#</a></ul><br />";
$pgv_lang["menu_famtree_help"]			= "~Menuvalget: Velkomstside~<br />PhpGedView kan håndtere flere GEDCOM-filer. Hvis der er lagt flere ind, vil alle tilgængelige slægtsdatabaser blive vist i en undermenu.<br />Hver slægtsdatabase vil have sin egen velkomstside eller hovedside, som vil kunne vise forskellige rammer og indhold.<br />";
$pgv_lang["menu_myged_help"]			= "~Menuvalget: Min Gedview Portal~<br />Brugere, der er logget ind, kan her finde links til at tilpasse personlige data og til at ændre sin kontoopsætning.<dl><dt><b>Min side</b></dt><dd>Sender dig til din egen \"Startside\".</dd><dt><b>#pgv_lang[myuserdata]#</b></dt><dd>Her kan du ændre din personlige konfiguration.</dd><dt><br />Hvis du findes i slægtsdatabasen, og administrator har angivet det i din brugerkonto, vil du også kunne se:<br /><br /><b>#pgv_lang[my_pedigree]#</b></dt><dd>Dette vil sende dig til dit anetræ, hvor du har valgt din egen hovedperson (proband).</dd><dt><b>#pgv_lang[my_indi]#</b></dt><dd>Dette vil vise dig din egen side, hvor alle oplysninger om dig selv og din familie bliver vist.</dd><dt><br />Hvis du har administratorrettigheder, vil du også kunne se:<br /><br /><b>Admin</b></dt><dd>Viser dig hovedsiden for administration af PhpGedView.</dd><dt><b>Administrere #pgv_lang[manage_gedcoms]#</b></dt></dl>";
$pgv_lang["menu_charts_help"]			= "~Menuvalget: Slægtstræer~<br />I denne menu får du forskellige typer af slægtstræer op:<dl><dt><a href=\"?help=help_pedigree.php\">#pgv_lang[index_header]#</a></dt><dd>Dette valg vil føre dig til hovedslægtstavlen for denne slægtsdatabase. Anetræet vil starte med en forhåndsdefineret startperson (proband). Hvis du er logget ind, kan startpersonen (proband) være dig eller en anden, som du har bestemt.</dd><dt><a href=\"?help=help_descendancy.php\">#pgv_lang[descend_chart]#</a></dt><dd>Dette valg er på en måde en \"spejlvendt\" <a href=\"?help=help_pedigree.php\">#pgv_lang[index_header]#</a>.<br />Hvor anetræet viser alle aner/forfædre til en startperson, viser efterkommeroversigten dig alle efterkommere (børn, børnebørn, oldebørn, osv) efter startpersonen.</dd><dt><a href=\"?help=help_timeline.php\">#pgv_lang[timeline_chart]#</a></dt><dd>Her kan du se begivenheder knyttet til en eller flere personer langs en tidslinie.</dd><dt><a href=\"?help=help_relationship.php\">#pgv_lang[relationship_chart]#</a></dt><dd>Her kan du checke, hvordan slægtskabet eller familiebåndet er mellem to personer.</dd><dt><a href=\"?help=help_ancestry.php\">#pgv_lang[ancestry_chart]#</a></dt><dd>Dette valg ligner meget en <a href=\"?help=help_pedigree.php\">#pgv_lang[index_header]#</a>, men indeholder flere oplysninger og muligheder for alternative <a href=\"?help=chart_style_help\">udformninger</a>.</dd><dt><a href=\"?help=help_fanchart.php\">#pgv_lang[fan_chart]#</a></dt><dd>Dette valg ligner også meget et <a href=\"?help=help_pedigree.php\">#pgv_lang[index_header]#</a>, men viser det på en mere grafisk måde.<br /><b>PS.</b> <i>Hvis websitet ikke understøtter grafisk visning, vil du ikke få denne valgmulighed!</i></dd></dl>";
$pgv_lang["menu_lists_help"]			= "~Menuvalget: Slægtslister~<br />I denne menu får du forskellige typer af slægtslister op: <dl><dt><a href=\"?help=help_indilist.php\">#pgv_lang[individual_list]#</a></dt><dd>Denne liste viser dig en liste over registrerede efternavne / personer, der begynder med det bogstav, du har valgt.</dd><dt><a href=\"?help=help_famlist.php\">#pgv_lang[family_list]#</a></dt><dd>Denne liste viser dig en liste over registrerede efternavne / familier, der begynder med det bogstav, du har valgt.</dd><dt><a href=\"?help=help_sourcelist.php\">#pgv_lang[source_list]#</a></dt><dd>Her vil du få en oversigt over alle kilderne, der er registreret i slægtsdatabasen.</dd><dt><a href=\"?help=help_placelist.php\">#pgv_lang[place_list]#</a></dt><dd>Her kan du se personer og familier, der er knyttet til forskellige steder.  Alle fund vil blive listet i en tabel. Hvis der er både enkeltpersoner og familier knyttet til stedet, vil personerne blive vist til venstre og familier til højre.</dd><dt><a href=\"?help=help_medialist.php\">#pgv_lang[media_list]#</a></dt><dd>Her vil du kunne se links til alle multimediefiler, der er anvendt i slægtsdatabasen.<br />Du vil kun kunne se dette menuvalg, hvis websitets administrator har aktiveret det for dig.</dd></dl>";
$pgv_lang["menu_annical_help"]			= "~Menuvalget: Mærkedage~<br />Mærkedage viser alle personer og/eller familier, der er knyttet til en valgt dag, måned eller år (standard er dags dato).<br />Hvis du ikke finder en forventet person eller familie, kan det skyldes hensynet til privatlivet. (Disse vil blive vist som <b>#pgv_lang[private]#</b>)<dl><dt><a href=\"?help=day_month_help\">#pgv_lang[viewday]#</a></dt><dd>Her vil du kunne se personer eller familier, der er knyttet til begivenheder på en given valgt dato i året.</dd><dt><a href=\"?help=day_month_help\">#pgv_lang[viewmonth]#</a></dt><dd>Her vil du få vist en kalender med personer og familier knyttet til begivenheder i denne måned.</dd><dt><a href=\"?help=day_month_help\">#pgv_lang[viewyear]#</a></dt><dd>Her vil du kunne se personer eller familier, der er knyttet til begivenheder et valgt år eller et valgt antal år.</dd></dl>";
$pgv_lang["menu_clip_help"]				= "~Menuvalget: Udklipsholder~<br />Du vil kunne se denne menu, hvis websitets administrator har aktiveret det.<br />Udklipsholderen giver dig mulighed for at \"kopiere\" dele af slægtsdatabasen, således at du senere kan downloade dem til din egen PC i GEDCOM 5.5 filformat.<br /><br />";
$pgv_lang["menu_search_help"]			= "~Menuvalget: Søg~<br />Ved at klikke på menupunktet: <b />Søg</b />, markeret med et forstørrelsesglas, her vil du få en søgeside frem. Her vil du få mulighed for at udføre flere type af søgninger i slægtsdatabasen end ved at anvende søgelinket du finder øverst på siden.<br /><br />";
//$pgv_lang["menu_rslog_help"]			= "~Menu til forskningslog~<br />Du vil kun se denne valgmulighed hvis administratoren har aktiveret den.  Forskningsloggen, der kun kan ses efter du har logget ind, giver dig mulighed for at vedligeholde logfiler om dine forskningsaktiviteter.  Du kan dele din logfil med andre, eller du kan beholde dem separat.<br /><br />";
$pgv_lang["menu_help_help"]				= "~Menuvalget: Hjælp~<br />#pgv_lang[help_help_items]#";

//-- Index-page Portal 
$pgv_lang["index_portal_head_help"]		= "<div class=\"name_head\"><center><b>Velkomstsiden</b></center></div><br />";
$pgv_lang["index_portal_help"]			= "\"Velkomstsiden\" ønsker dig velkommen til programmet.<br />Siden er opbygget af flere rammer, der kan tilpasses efter behov. Derfor kan det være, at du kan se flere forskellige velkomstsider på dette website (såfremt der er mere end en tilgængelig slægtsdatabase).<br /><br /><b>Du vil kunne se følgende rammer på denne side:</b><ul><li><a href=\"#index_welcome\">#pgv_lang[welcome]#</a><li><a href=\"#index_login\">#pgv_lang[login]#</a><li><a href=\"#index_events\">#pgv_lang[upcoming_events]#</a><li><a href=\"#index_onthisday\">#pgv_lang[on_this_day]#</a><li><a href=\"#index_favorites\">#pgv_lang[gedcom_favorites]#</a><li><a href=\"#index_stats\">#pgv_lang[gedcom_stats]#</a><li><a href=\"#index_common_surnames\">#pgv_lang[common_surnames]#</a><li><a href=\"#index_media\">#pgv_lang[random_picture]#</a><li><a href=\"#index_loggedin\">#pgv_lang[users_logged_in]#</a><li><a href=\"#recent_changes\">#pgv_lang[recent_changes]#</a></ul>";
$pgv_lang["index_welcome_help"]			= "~Titel~<br />Titelrammen giver dig information om:<br /><ul><li>Den aktive slægtsdatabase samt dato og tid.<br /><li>#pgv_lang[hit_count]# hvis administrator har aktiveret denne funktion.</ul>Tælleren, der viser, hvor mange gange siden har været besøgt, vil du også kunne finde på siderne med oplysninger om enkeltpersoner.  - Tælleren checker ikke de besøgenes URL (PC'ens ID-kode), så hvis siden bliver besøgt flere gange af den samme, vil dette blive registreret som et nyt besøg eller hit.<br />";
$pgv_lang["index_login_help"]			= "~Log ind~<br />Selvom du kan logge dig ind på næsten alle sider i dette program, vil du sikkert normalt gøre dette via velkomstsiden, fordi det er kun når du er logget ind, at du kan få adgang til beskyttet information.<br />Du kan logge dig ind ved at opgive dit <b>brugernavn</b> og <b>adgangskode</b> og klikke på knappen \"Log ind\".<br /><br />#pgv_lang[new_user_help]#<br /><br />#pgv_lang[new_password_help]#<br />";
$pgv_lang["index_events_help"]			= "~Begivenheder~<br />Denne ramme viser dig de begivenheder i slægtsdatabasen, der er indtruffet på datoerne fra og med i morgen og en måned frem i tiden.<br />Begivenheder er fx fødselsdage, dåb, begravelser, dødsfald.";
$pgv_lang["days_to_show_help"]			= "~#pgv_lang[days_to_show]#~<br /><br />Angiv antallet af dage, der skal vises.  Dette tal kan ikke være større end <b>#DAYS_TO_SHOW_LIMIT#</b>.  Hvis du angiver en større værdi, vil grænseværdien blive anvendt.<br /><br />Den viste grænseværdi sættes af administratoren under: <b>Admin - Opsætning af GEDCOM</b>. Her vælger menuen: <b>Visning og layout</b>, og derefter undermenuen: <b>Skjul &amp; Vis</b>.";
$pgv_lang["random_media_persons_or_all_help"] = "~#pgv_lang[random_media_persons_or_all]#~<br /><br />Her kan du vælge, hvilken medietype, der skal vises.<br /><br />Når du vælger <b>#pgv_lang[random_media_persons]#</b>, vil kun medier, der er knyttet til personer blive vist.  Normalt vil det være et fotografi af personen.  Når du vælger <b>#pgv_lang[random_media_events]#</b>, vil kun medier, der er knyttet til fakta eller begivenheder blive vist.  Dette kunne fx være et billede af en dåbsattest.  Når du vælger <b>#pgv_lang[all]#</b>, vil dene ramme vise alle typer af medier.";
$pgv_lang["basic_or_all_help"]			= "~#pgv_lang[basic_or_all]#~<br /><br />Her kan du udelukke nogle daterede begivenheder.  For eksempel, skulle #factarray[DIV]#, #factarray[CREM]#, #factarray[GRAD]#, #factarray[BARM]#, #factarray[FCOM]#, osv. alle være daterede.<br /><br />Når du vælger <b>Ja</b>, vil kun fødsler, dødsfald og vielser blive vist. Når du vælger <b>Nej</b>, vil alle daterede begivenheder blive vist.";
$pgv_lang["index_onthisday_help"]		= "~På denne dag i din slægtshistorie...~<br />Denne ramme viser dig begivenheder i slægtsdatabasen på samme dato i året som i dag.<br />";
$pgv_lang["index_favorites_help"]		= "~Favoritter i denne slægtsdatabase~<br />\"#pgv_lang[gedcom_favorites]#\" svarer til \"#pgv_lang[my_favorites]#\", som findes på siderne for registrerede brugere. - Forskellen er, at her er det kun administrator(er) af websitet, der kan tilføje, slette eller ændre Favoritter.<br />Hensigten med Favoritter er at skabe opmærksomhed om personen eller fordi personen er vigtig i slægten.<br /><br />For at spare plads, indeholder feltet begrænset information.<br />På højre side af navnefeltet vil du se en menu og et forstørrelsesglas. Den øverste kan tage dig til forskellige sider for mere information om personen, mens den nederste viser dig lidt mere information med det samme.<br /><br />Øverst på alle sider er \"#pgv_lang[gedcom_favorites]#\" tilgængelig i form af en \"drop-down\"-liste.<br />";
$pgv_lang["index_add_favorites_help"]	= "~Tilføj en favorit~<br />Denne formular giver dig mulighed for at tilføje en ny favorit til din liste over favoritter.  Du skal angive enten et ID for personen, familien, eller kilden, som du ønsker at gemme som en favorit, eller du skal angive en URL-adresse og en titel.  Notesfeltet er valgfrit og kan anvendes til at beskrive favoritten.  Alt, der anføres i notesfeltet vil blive vist i rammen: <b>Mine favoritter</b>.<br /><br />";
$pgv_lang["index_stats_help"]			= "~Statistik for slægtsdatabasen~<br />I denne ramme vil du se nogle statistiske oplysninger vedr. den aktive slægtsdatabase.<br />Hvis du ønsker mere information, kan du imidlertid sende en forespørgsel til kontaktpersonen, som du finder nederst på siden.<br />";
$pgv_lang["index_common_names_help"]	= "~<i>Oftest forekommende efternavne</i>~<br />Nederst i statistikrammen, finder du en oversigt over de oftest forekommende efternavne i den aktive slægtsdatabase. - Hvilke navne der vises, bestemmes af administratoren af websitet.<br />(Gældende indstilling er efternavne, der forekommer mere end #COMMON_NAMES_THRESHOLD# gange).<br /><br />Ved at klikke på et af navnene, vil du blive sendt videre til en liste over personer med dette efternavn. Der vil du kunne få flere oplysninger om de forskellige personer, med dette navn.<br />";
$pgv_lang["index_media_help"]			= "~Tilfældig udvalgt billede~<br />Hver gang du besøger denne side vil rammen vise dig et tilfældigt udvalgt billede eller anden mediefil. Ved at klikke på billedet, eller på dets navn, vil du se billedet i et nyt vindue.<br />Under billedet er der et link til den person eller familie, billedet er knyttet til.<br />Ved at klikke på personens navn eller familien, vil du få siden op med oplysninger om personen eller familien.<br />";
$pgv_lang["index_loggedin_help"]		= "~Brugere der er logget ind~<br />Denne ramme viser dig, hvilke brugere der er logget ind på det pågældende tidspunkt.<br />Under hver bruger vil du også finde et link til at sende en besked til denne bruger.<br />";
$pgv_lang["index_gedcom_news_help"]		= "~Nyheder~<br />Nyhedsrammen er på en måde en opslagstavle for denne slægtsdatabase.<br />Administratoren af websitet kan her skrive vigtige meddelelser eller interessante nyheder.<br /><br />Hvis du har noget interessant at meddele andre brugere og besøgende, kontakt da venligst administratoren af websitet via linket nederst på siden.";
$pgv_lang["index_gedcom_news_adm_help"]	= "I denne nyhedsramme til dine brugere, kan du anvende <b>HTML koder</b>.<br />Du skal naturligvis kunne lidt om HTML for at anvende det.  Husk altid at bruge både start- og slutkode!<br /><br />Dette program bruger <b>tema-filer (CSS)</b> og disse er forskellige for de forskellige Temaer (layout).<br />Ved at se på en af disse filer (CSS), kan du bruge \"klasser\" fra disse temaer.<br /><br />Hvis du har behov for mere hjælp om dette, kan du finde nogle eksempler på, hvordan du bruger disse koder på denne website <a href=\"http://PhpGedView.sourceforge.net/styleguide.html\" target=\"_blank\" />PhpGedView</a>.<br />";
$pgv_lang["recent_changes_help"]		= "~Seneste ændringer~<br />Denne ramme viser dig de seneste ændringer, der er foretaget i slægtsdatabasen. (Dette er knyttet til GEDCOM-tagget CHAN).<br />";
$pgv_lang["gedcom_news_limit_help"]		= "Du kan begrænse antallet af nyhedsartikler, der vises, og derved reducere højden af nyhedsrammen.<br /><br />Denne mulighed bestemmer om der skal sættes en grænse eller ej, og om grænsen skal sættes efter artiklens alder eller antallet af artikler.<br /><br />";
$pgv_lang["gedcom_news_flag_help"]		= "Skriv grænseværdien her.<br /><br />Hvis du har valgt at begrænse antallet af artikler efter deres alder, vil alle artikler, der er ældre end det antal dage du har anført, ikke blive vist. Hvis du har valgt at begrænse visningen af artikler efter artiklernes antal, vil det specificerede antal af artikler, sorteret efter alder, blive vist. De resterende artikler vil ikke blive vist.<br /><br />Skrives et 0, vil der ikke blive sat nogen grænse, og alle artikler vil blive vist i nyhedsrammen.";
$pgv_lang["gedcom_news_archive_help"]	= "For at reducere højden af nyhedsrammen, har administratoren vlagt at skule nogle artikler. Du kan se de skjulte artikler ved at klikke på linket: <b>#pgv_lang[gedcom_news_archive]#</b><br /><br />";
$pgv_lang["index_htmlplus_help"]		= "~Avanceret HTML ramme~<br />Denne ramme giver administratoren mulighed for at tilføje information til velkomstsiden eller Min GedView Portal.  Formålet med rammen er den samme som for rammerne til HTML, Nyheder og GEDCOM Statistik, men administratoren har mere kontrol over udseendet af rammen.<br /><br />";
$pgv_lang["index_htmlplus_title_help"]	= "Der bør ingen tekst være eller også bør den være meget kort.  Når der ingen tekst angives, vil rammen til avanceret HTML blive vist på indeks-eller portalsiden som en almindelig ramme, på samme måde som for en HTML ramme.  Når der er agnivet noget tekst, vil rammen til avanceret HTML  bive vist som alle andre rammer, fuldstændig med en rammetitel indeholdende den tekst, du har skrevet.";
$pgv_lang["index_htmlplus_template_help"]	= "For at hjælpe di med at komme igang med denne ramme, har vi oprettet adskillige standard skabeloner.  Når du vælger en af disse skabeloner vil tekstområdet indeholde en kopi som du kan ændre alt efter dit behov.";
$pgv_lang["index_htmlplus_content_help"]	= "I modsætning til rammerne for HTML, Nyheder og GEDCOM statistik, så har du fuld kontrol over, hvordan din ramme ser ud. Du kan anvende HTML tags, og rammen anvender CSS stylesheets fra det aktive tema.  Henvisninger til information fra den aktive slægtsdatabase kan inkluderes i teksten.<br /><br />Database henvisninger er vist i teksten vha. nøgleord omgivet af <b>&#35;</b> symboler.  For eksempel repræsenterer <b>&#35;TOTAL_FAM&#35;</b> antallet af familier i databasen.  Lejlighedsvis kan det være du ønsker at anvende en databasehenvisning som tekst istedet for selve tgeksten.  For at gøre det, skal du erstatte <b>&#35;</b> symbolerne, der omgiver nøgleord, med deres tilsvarende symbol.  For eksempel, hvis din tekst indeholder <b>&amp;&#35;35;TOTAL_FAM&amp&#35;35;</b> vil den blive printet som <b>&#35;TOTAL_FAM&#35;</b> istedet for at blive en database henvisning.<br /><br />Listen over nøgleord er som følger:<br /><table><tr valign=top><td><ul><li>COMMON_SURNAMES</li><li>TOTAL_INDI</li><li>TOTAL_FAM</li><li>TOTAL_SOUR</li><li>TOTAL_OTHER</li><li>TOTAL_SURNAMES</li><li>TOTAL_MALES</li><li>TOTAL_FEMALES</li><li>TOTAL_UNKNOWN_SEX</li><li>TOTAL_EVENTS</li><li>TOTAL_EVENTS_BIRTH</li><li>TOTAL_EVENTS_DEATH</li><li>TOTAL_EVENTS_MARRIAGE</li><li>TOTAL_EVENTS_OTHER</li><li>TOTAL_USERS</li><li>FIRST_EVENT</li><li>FIRST_EVENT_TYPE</li><li>FIRST_EVENT_NAME</li><li>FIRST_EVENT_YEAR</li><li>LAST_EVENT</li><li>LAST_EVENT_TYPE</li><li>LAST_EVENT_NAME</li><li>LAST_EVENT_YEAR</li><li>FIRST_BIRTH</li><li>FIRST_BIRTH_NAME</li><li>FIRST_BIRTH_YEAR</li></ul></td><td><ul><li>LAST_BIRTH</li><li>LAST_BIRTH_NAME</li><li>LAST_BIRTH_YEAR</li><li>LONG_LIFE</li><li>LONG_LIFE_NAME</li><li>LONG_LIFE_AGE</li><li>TOP10_OLDEST</li><li>AVG_LIFE</li><li>MOST_CHILD</li><li>MOST_CHILD_NAME</li><li>MOST_CHILD_TOTAL</li><li>TOP10_BIGFAM</li><li>AVG_CHILD</li><li>HIGHLIGHT</li><li>GEDCOM</li><li>GEDCOM_ID</li><li>GEDCOM_TITLE</li><li>CREATED_SOFTWARE</li><li>CREATED_VERSION</li><li>CREATED_DATE</li><li>GEDCOM_UPDATED</li><li>GEDCOM_CONTACT</li><li>WEBMASTER_CONTACT</li></ul></td></tr></table><br />";

//-- Index-Page Help
$pgv_lang["help_help"]					= "Det ville naturligvis have været optimalt at lave et program, der var så enkelt at anvende, at man ikke behøvede nogen forklaringer.<br />Det skulle have været så enkelt som at læse en bog (som om det er enkelt for alle...).<br />Selv om det er et omfattende program, der ligger bagved siderne, så mærker du det ikke som bruger, med undtagelse måske, at enkelte sider kan føles lidt tunge at få frem.<br />Men eftersom vi muligvis har mange besøgende og brugere, der føler sig som nybegyndere i forhold til PC'er og slægtsforskning, så tilbyder vi dig lidt hjælp visse steder.<br />I menuen under hjælp, vil du finde følgende menuvalg:<br />";
$pgv_lang["help_page_help"]				= "<dl><dt><b>Hjælp til denne side</b></dt><dd>For alle sider er der en \"generel hjælp\" tilgængelig.<br />Når du er på en side, kan du klikke på dette menuvalg. Så vil du få \"hjælp til denne side\", som vil fortælle dig om de forskellige elementer, du kan finde på den pågældende side. Hjælpeteksterne er i de fleste tilfælde kortfattede.<br />Hvis du ønsker mere hjælp, eller info om specielle elementer på siden, kan du bruge de spørgsmålstegn, der findes efter forskellige elementer. Check for øvrigt at det tredje menuvalg i hjælpemenuen: \"Hjælp (?) for tekst\" er aktiveret.</dd></dl>";
$pgv_lang["help_content_help"]			= "<dl><dt><b>Emner i hjælp</b></dt><dd>Ved at klikke på dette menupunkt, vil du få et hjælpevindue op, som viser en oversigt over de fleste emner du kan få hjælp til.</dd></dl>";
$pgv_lang["help_faq_help"]			= "<dl><dt><b>FAQ liste</b></dt><dd>#pgv_lang[text_faq_help]#</dd></dl>";
$pgv_lang["help_HS_help"]			= "<dl><dt><b>#pgv_lang[hs_title]#</b></dt><dd>#pgv_lang[hs_intro]#</dd></dl>";
$pgv_lang["help_qm_help"]				= "<dl><dt><b>Skjul / Vis hjælp (?) til tekst</b></dt><dd>Dette menupunkt er måske det mest nyttige for dig. Ved at klikke på dette link vil du enten slå \"hjælp til tekst\" til eller fra.<br />Hvad er så \"hjælp til tekst\" ?<br />Når den er slået til, vil du kunne finde et spørgsmålstegn til højre for nogle links, \"drop-down\"-felter eller knapper. Ved at klikke på dette <b>?</b>, vil der dukke et lille hjælpevindue op med lidt information om dette objekt.<br /><br />Og modsat, når du klikker på \"Skjul hjælp (?) til tekst\", vil der ikke blive vist nogen spørgsmålstegn, indtil til du klikker på \"Vis....\" igen.</dd></dl>";

//-- Index-page Definitions 
$pgv_lang["def_help"]					= "<div class=\"name_head\"><center><b>Definitioner</b></center></div><br />Her er der en forklaring på nogle af de ord, der er anvendt i denne hjælpetekst:<ul><li><a href=\"#def_gedcom\">GEDCOM</a><li><a href=\"#def_gedcom_date\">Datoer</a><li><a href=\"#def_pgv\">PhpGedView</a><li><a href=\"#def_portal\">Velkomstside</a><li><a href=\"#def_theme\">Tema</a></ul>";
$pgv_lang["def_portal_help"]			= "~<i>Velkomstside</i>~<br />Dette er hovedindgangen til slægtsdatabasen. Det er her de fleste kommer ind når de besøger websitet. Her kan du finde vigtig information som forklaringer, beskeder osv.<br />Men, naturligvis er det også muligt at gå ind via en eller flere \"køkkenveje\" ...<br />";
$pgv_lang["def_gedcom_help"]			= "~<i>GEDCOM</i>~<br />En GEDCOM-fil er en data-fil, hvor al information om en slægt gemmes. Der findes også GEDCOM-filer der indeholder kirkebøger eller oplysninger om hele kommuner.<br />Alle personer, familier, fakta, datoer, begivenheder, kildehenvisninger osv. kan gemmes i en GEDCOM-fil.<br />For at gemme en GEDCOM-fil (de fleste slægtsprogrammer kan eksportere data til en GEDCOM-fil), må man følge klare regler. Dette gør det muligt at udveksle data mellem forskellige slægtsprogrammer, computertyper og/eller systemer.<br /><b>PS.</b> Billeder og andre media-filer gemmes ikke i GEDCOM-filen, bare henvisningerne til hvor disse findes som f.eks. på harddisken og/eller internettet (URL)!<br />";
$pgv_lang["def_gedcom_date_help"]		= "~<i>Datoer i en slægtsfil</i>~<br />Fordi formatet til GEDCOM-filer må følge internationale regler, gælder dette også til en vis grad for datoer.<br /><br />Selv om datofeltet i en GEDCOM-fil er et åbent felt (betyder at du også kan skrive ren tekst), så bør man alligevel følge visse standarder:<dl><dt><b>Fuldstændig dato</b></dt><dd>Skrives som \"DD MMM YYYY\":<br />01 Mar 1801 eller 14 Dec 1950</dd><dt><b>Ufuldstændig dato</b></dt><dd>Skrives som om den var fuldstændig:<br />(Du kender f.eks. ikke dagen eller året)<br />Mar 1801 eller 14 Dec<br />hvis du ikke er sikker eller datoen er ubekræftet, kan du skrive:<br />abt Mar 1801 (abt = about = omtrent)<br />bef 20 Dec 1950 (bef = before = før)<br />aft 1949 (aft = after = efter)</dd></dl>Datoer og forkortelser bør/skal skrives på engelsk, fordi så kan GEDCOM-filen udveksles med andre programmer. Slægtsprogrammerne vil oversætte alle datoer og forkortelser til det ønskede sprog.<br />Programmerne foretager også forskellige beregninger med datoerne og for at resultatet skal blive korrekt, må datoformatet følge en given standard.<br />";
$pgv_lang["def_pgv_help"]				= "~<i>PhpGedView</i>~<br />PhpGedView #VERSION# (eller PGV) er et program, udviklet af John Finlay, for at kunne se GEDCOM-filer på internettet.<br />John startede udviklingen af dette program, men efterhånden har det udviklet sig til et stort, internationalt team med udviklere og oversættere, der arbejder sammen om at udvikle og forbedre programmet.<br />- Som du måske har set, så viser dette program ikke statiske sider, men er dynamisk og kan tilpasses den enkelte bruger.<br />Udover at besøgende kan vælge hvad de vil se i GEDCOM-filen (filerne), kan registrerede brugere få rettigheder til at tilføje og ændre personer, begivenheder mm. direkte på internettet.<br />";
$pgv_lang["def_theme_help"]				= "~<i>Tema</i>~<br />Dette website kan have flere forskellige \"ansigter\", kaldet Temaer.<br />Administratoren af websitet kan vælge et standard tema.<br />Alle, der besøger websitet vil da se den samme layout (Tema). Hvis administratoren godkender brugere af siderne, kan de vælge deres eget tema.<br />Hvis en bruger har valgt et andet tema, vil han/hun se dette layout, såsnart de har logget sig ind.<br />";

//-- Index-page MyGEDCOM 
$pgv_lang["mygedview_portal_help"]		= "~Min GedView Portal~<br />Dette er din personlige GedView side.<br />Her kan du finde hurtiglinks til dine personlige data, som <b>#pgv_lang[editowndata]#, #pgv_lang[my_indi]#</b> (dette er siden, hvor dine personlige data vises) og <b>#pgv_lang[my_pedigree]#</b>.<br />I tillæg hertil kan du have en ramme med <b>Beskeder</b>, en <b>Notatblok</b> (som en opslagstavle) og flere andre.<br /><br />Denne siden har det samme udseende som Hovedsiden.<br />Mens rammerne på Hovedsiden er valgt af adminstratoren af websitet, kan du selv vælge dine egne rammer på denne side (med visse begrænsninger naturligvis...).<br /><br />I velkomstrammen på din side, kan du finde linken til at ændre denne side.<br /><br /><b>Du kan vælge imellem følgende rammer:</b><ul><li><a href=\"#mygedview_welcome\">Velkommen</a><li><a href=\"#mygedview_customize\">Tilpas \"Min GedView Portal\"</a><li><a href=\"#mygedview_message\">Beskeder</a><li><a href=\"#mygedview_events\">Kommende begivenheder</a><li><a href=\"#mygedview_onthisday\">Årsdag for begivenheder i slægten</a><li><a href=\"#mygedview_favorites\">Mine favoritter</a><li><a href=\"#mygedview_stats\">Statistik for slægtsdatabasen</a><li><a href=\"#mygedview_myjournal\">Min notesblok</a><li><a href=\"#mygedview_media\">Tilfældig udvalgt billede</a><li><a href=\"#mygedview_loggedin\">Bruger logget ind</a></ul>";
$pgv_lang["mygedview_customize_help"]	= "~Tilpas \"Min GedView Portal\"~<br />Da du kom ind på denne side første gang, havde du allerede nogle rammer på siden.<br />Hvis du ønsker det, kan du tilpasse denne side efter dine egne ønsker/behov.<br />Ved at klikke på dette link, vil du få et nyt vindue op med et skema, hvor du kan tilføje, slette eller flytte på rammer.<br />Mere forklaring kan findes i skemaet.<br />";
$pgv_lang["mygedview_message_help"]		= "~Beskeder~<br />I denne ramme kan du finde de beskeder, der er sendt til dig fra andre brugere, eller fra Admin.<br />Selvfølgelig kan du også sende dine egne beskeder til andre brugere eller administratorer.<br />Mailsystemet i PhpGedView er lavet med henblik på at beskytte dit eget privatliv. Du behøver ikke at opgive din e-mail-adresse her, og andre vil heller ikke kunne se din e-mail-adresse.<br /><br />For at tilføje tekst til en besked, kan du klikke på beskedens overskrift eller på \"+\" tegnet ved siden af den.  Du kan slette flere beskeder ved at afkrydse checkboksen ved siden af de beskeder, du ønsker at slette og derefter klikke på knappen: <b>Slet valgte beskeder</b>.<br />";
$pgv_lang["mygedview_favorites_help"]	= "~Mine favoritter~<br />Mine favoritter virker på samme måde som at indsætte bogmærker i slægtsdatabasen.<br />Forestil dig, at du har nogle i slægten, hvis oplysninger, du ønsker at checke regelmæssigt.<br />Du går da til siden med oplysninger om personen, og klikker på linket: <b>Tilføj en ny favorit</b>. Denne person har nu fået et bogmærke og er blevet føjet til listen over <b>Mine favoritter</b>. Nu vil du kunne finde denne favorit hver gang du besøger siderne ved at klikke på: <b>Mine favoritter</b> øverst på siderne.<br /><br />For at spare plads, er feltet vist med en begrænset information. På højre side af feltet vil du se et forstørrelsesglas, der anvendes til at få lidt mere information frem.<br />Ved at klikke på navnet, vil du blive sendt til siden med oplysninger om personen.<br />";
$pgv_lang["mygedview_myjournal_help"]	= "~Min notesblok~<br />Du kan bruge denne notesblok til at skrive kommentarer (eller huskesedler) til eget brug.<br />Naturligvis vil notatet også være der næste gang du besøger siden.<br /><br />Disse notater vil ikke være synlige for andre.<br />";
$pgv_lang["mygedview_welcome_help"]		= "~Velkommen~<dt>Denne velkomstramme viser dig:</dt><dd>- Den aktive slægtsdatabase</dd><dd>- Dato og klokkeslæt</dd><dd>- Links til:</dd><dd> - - #pgv_lang[myuserdata]#</dd><dd>- - #pgv_lang[my_pedigree]# (se PS under)</dd><dd>- - #pgv_lang[my_indi]# (se PS under)</dd><dd>- - #pgv_lang[customize_page]#</dd><br /><b>PS !</b>  Du vil kun kunne se links til \"#pgv_lang[my_indi]#\" og \"#pgv_lang[my_pedigree]#\" , hvis du er registreret i den aktive slægtsdatabase.<br />Derfor vil du kunne se disse links i nogle af slægtsdatabaserne, mens i andre, hvor du ikke er registreret, vil du ikke kunne se disse links...<br />";

//-- Pedigree-page 
$pgv_lang["help_pedigree.php"]			= "~Anetræ~<br /><br />De fleste brugere og besøgende ved hvad et anetræ (anetavle) er, men her får du alligevel lidt information herom:<br />Et anetræ er en optælling af alle forfædre/-mødre til startpersonen. Startpersonen kaldes proband i slægtsforskningens terminologi<br />Når du åbner siden, er startpersonen vist til venstre (hvis du logger dig ind, kan du vælge din egen startperson (proband).<br /><br />\"Alle forfædre\" betyder som sagt far og mor, og deres forældre osv.<br />På denne side er anetræet vist grafisk.  Du behøver ikke lede flere sider med tekst igennem for at finde ud af, hvem dine forfædre er.<br />Alle personerne bliver vist i særskilte bokse med linier imellem, der viser tilhørsforholdene.<dl><dt><b>Navneboksen i anetræet</b></dt><dd>Hvis anetræet er sat op til at vise detaljer, vil du se navnet på personen samt dato for fødsel og eventuelt død.<br />Du kan klikke på personens navn for at få vist en side med fakta om denne person.</dd><dt><b>Ikoner i navnefeltet</b></dt><dd>Når valget \"Vis detaljer\" er afmærket, vises der ikoner inde i hver navneboks. Afhængig af websitets opsætning, skal du enten flytte musen henover ikonet, eller klikke på det.<br />Når du klikker, eller flytter musen henover ikonet, vil der dukke en ny undermenu op.<br />Valgene \"#pgv_lang[index_header]#\" og \"#pgv_lang[descend_chart]#\" svarer til dem, du finder i hovedmenuen, men forskellen er at startpersonen nu er personen i den valgte boks.<br />Du vil også se \"#pgv_lang[fam_spouse]#\". Nedenunder ser du navnet på ægtefælllen/partneren, efterfulgt af eventuelle børn.<br />Du kan klikke på alle navne.</dd><dt><b>Forstørrelsesglasset inde i navneboksen</b></dt><dd>Dette ikon afhænger også af sidens opsætning. Du skal enten flytte musen henover det, eller klikke på det.<br />Dette gør navneboksen større, så der bliver vist flere oplysninger om personen.<br />Du kan se flere begivenheder og tilhørende datoer. Også her kan du klikke på eventuelle navne.</dd><dt><b>Pilene</b></dt><dd>Til venstre og højre for de yderste navnebokse hhv. til venstre og højre på skærmen, vil du kunne se nogle pile.<br />De giver dig mulighed for, ved at klikke på dem, at forskyde anetræet en generation op eller ned.</dd></dl>Mere hjælp er tilgængelig ved at klikke på <b>?</b> efter boksene eller linkene på siden.";
$pgv_lang["show_full_help"]				= "~Vis detaljer~<br /><br />Med dette valg kan du enten vise alle detaljer i navneboksene, eller skjule detaljer.<br />Hvis detaljerne er skjulte, vil du kunne vise flere bokse på skærmen.<br /><br />Vælger du at skjule detaljer, kan du alligevel få dem at se ved at bruge forstørrelsesglasset. Det afhænger imidlertid af om administratoren af websitet har aktiveret det.<br /><br />Hvis du sædvanligvis kan klikke på forstørrelsesglasset for at zoome ind, så vil du også kunne se detaljer ved at klikke på den enkelte navneboks.<br />Hvis du kan zoome ind ved at flytte musen henover forstørrelsesglasset, så vil det virke på samme måde når du flytter musen henover hver boks.";
$pgv_lang["talloffset_help"]			= "~Opsætning af slægtstræer~<br /><br />Her kan du bestemme, hvordan slægtstræet skal vises.<br />Det kan være nyttigt, hvis du vil printe det ud eller, hvis du vil tilpasse skærmbilledet i forhold til din skærmopløsning.<dl><dt><b>Stående (Portrait)</b></dt><dd>Vælges dette gøres træet højere, så 4 generationer burde passe til et A4-ark med stående udskrift.</dd><dt><b>Liggende (Landscape)</b></dt><dd>Vælges dette gøres træet bredere, så 4 generationer burde passe til et A4-ark med liggende udskrift.</dd></dl>";
$pgv_lang["rootid_help"]				= "~Ny startperson / Find ID~<br /><br />Hvis du ønsker at vise et slægtstræ med en ny startperson (proband), så kan du angive personens ID i denne boks. Hvis du ikke kender personens ID, kan du bruge linket: <b>Find ID</b>.<dl><dt><b>NB!</b></dt><dd><i>Det ID, der bruges i PhpGedView, er ikke det samme som personnummeret! Nummeret bruges kun i slægts/GEDCOM-filer, og er oprettet af det slægtsprogram, der blev anvendt til at generere slægtsfilen!</i></dd></dl>";
$pgv_lang["PEDIGREE_GENERATIONS_help"]	= "~Antal generationer~<br /><br />Her kan du angive antallet af generationer, der skal vises på denne side.<br />Hvad der er bedst for dig afhænger af størrelsen på din skærm, og om du viser detaljer eller ikke.";

//-- LOGIN-page 
$pgv_lang["login_page_help"]			= "~Log ind~<br /><br />På denne side kan du logge dig ind, bestille en ny adgangskode eller en ny brugerkonto.<br />";
$pgv_lang["username_help"]				= "~Brugernavn~<br /><br />I dette felt skriver du dit brugernavn.<br />Brugernavnet skal skrives nøjagtigt, som det blev oprettet (små og/eller store bogstaver)";
$pgv_lang["password_help"]				= "~Adgangskode~<br /><br />I dette felt skriver du din adgangskode.<br />Adgangskoden skal skrives nøjagtigt, som det blev oprettet (små og/eller store bogstaver)";
$pgv_lang["login_buttons_help"]			= "~Log ind knapper~<br /><br />Her ser du to knapper til at logge dig ind på systemet.<br /><dl><dt><b>#pgv_lang[login]#</b></dt><dd>Hvis du klikker på den venstre knap, vil du komme tilbage til den side, du kom fra.<br />Så, hvis du klikker \"#pgv_lang[login]#\" da du var på siden med anetræet, vil du komme tilbage til denne side.<br />Hvis du klikker på <b>#pgv_lang[mygedview]#</b> i menuen, vil du gå direkte til din personlige side, hvor du kan ændre din opsætning,tilføje eller ændre favoritter, sende og læse beskeder og så videre.</dd><dt><b>#pgv_lang[admin]#</b></dt><dd>Hvis du har administratorrettigheder, kan du klikke på knappen til højre og gå direkte til siden for at administrere websitet.</dd></dl>";
$pgv_lang["login_buttons_aut_help"]		= "~Brugergodkendelse~<br /><br />Her ser du to knapper til at logge dig ind i systemet.<dl><dt><b>#pgv_lang[login]#</b></dt><dd>Almindelige brugere benytter kun denne knap efter at de har oplyst brugernavn og adgangskode. Derefter vil de blive sendt til deres egen \"Min GedView Portal\", hvor de kan sende og læse beskeder, ændre deres opsætning, tilføje eller ændre favoritter osv.</dd><dt><b>#pgv_lang[admin]#</b></dt><dd>Den virker kun for brugere med administratorrettigheder. Ved at klikke på denne knap vil siden for administration af websitet blive vist.</dd></dl>";
$pgv_lang["new_password_help"]			= "~<i>Bestil en ny adgangskode</i>~<br />Hvis du har mistet din adgangskode, kan du klikke på linket [Bestil en ny adgangskode].  - Du vil da få siden \"Ansøgning om adgangskode\" op.";
$pgv_lang["new_user_help"]				= "~<i>Bestil en ny brugerkonto</i>~<br />Hvis du er gæst på dette website og ønsker at få en brugerkonto, kan du klikke på linket [Bestil en ny brugerkonto].  - Du vil da få siden \"Ansøgning om brugerkonto\" op.<br /><b>PS!</b> <i>For at få en konto bør du enten være i familie med nogen i slægtsdatabasen eller have en anden god grund!</i>";
$pgv_lang["mygedview_login_help"]		= "<center><b>Siden <i>Min GedView Portal</i> er kun tilgængelig for <i>registrerede brugere</i>.</b><br /><br />I <b><i>Min GedView Portal</i></b> kan du lave dine egne genveje til favoritpersoner,<br />notere i din notatblok, sende meddelelser, se loggen for andre brugere<br />eller skræddersy din egen opsætning af PhpGedView.<br /><br />Hvis du har et brugernavn og en adgangskode, så log dig ind i felterne nedenfor.</center />";
$pgv_lang["new_user_firstname_help"]		= "~#pgv_lang[firstname]#~<br /><br />I dette felt kan du angive dit fornavn.<br /><br />Vi skal bruge dit fornavn og efternavn for at afgøre om du opfylder betingelserne for at få en brugerkonto, og hvilke rettigheder du skal have.  Navnene vil være synlige for andre familiemedlemmer og brugere, der er logget ind.<br /><br />";
$pgv_lang["new_user_lastname_help"]		= "~#pgv_lang[lastname]#~<br /><br />I dette felt kan dy skrive dit efternavn.<br /><br />Vi skal bruge dit fornavn og efternavn for at afgøre om du opfylder betingelserne for at få en brugerkonto, og hvilke rettigheder du skal have.  Navnene vil være synlige for andre familiemedlemmer og brugere, der er logget ind.<br /><br />";
$pgv_lang["register_info_01"]		= "~Anmod om en ny brugerkonto~<br /><br />Mængden af data, der kan vises offentligt på denne website kan begrænses af hensyn til love vedr. privatlivets beskyttelse. Mange mennesker ønsker ikke at deres personlige data gøres offentlig tilgængelig på Internettet. Personlige data kan misbruges til spam eller tyveri af identitet.<br /><br />Adgang til denne site er begrænset til alle, der har en brugerkonto. Efter at administratoren har verificeret og godkendt din ansøgning om en brugerkonto, kan du logge ind.<br /><br />Hvis privatlivsindstilling for relationer er aktiveret, vil du kun være i stand til at se private informationer for dine egne nærmeste slægtninge efter at du har logget ind. Administratoren kan også give visse brugere tilladelse til at redigere databasen, således at de kan ændre eller tilføje information.<br /><br />Hvis du har behov for mere hjælp, venligst bruge linket nedenfor til at kontakte administratoren.<br /><br />";
$pgv_lang["register_info_02"]		= "~Anmod om en ny brugerkonto~<br /><br />Mængden af data, der kan vises offentligt på denne website kan begrænses af hensyn til love vedr. privatlivets beskyttelse. Mange mennesker ønsker ikke at deres personlige data gøres offentlig tilgængelig på Internettet. Personlige data kan misbruges til spam eller tyveri af identitet.<br /><br />Adgang til denne site er kun tilladt for <u>godkendte</u> brugere. Efter at administratoren har verificeret og godkendt din ansøgning om en brugerkonto, kan du logge ind og de private data.<br /><br />Hvis privatlivsindstilling for relationer er aktiveret, vil du kun være i stand til at se private informationer for dine egne nærmeste slægtninge efter at du har logget ind. Administratoren kan også give visse brugere tilladelse til at redigere databasen, således at de kan ændre og tilføje information.<br /><br />Hvis du har behov for mere hjælp, venligst brug linket nedenfor til at kontakte administratoren.<br /><br />";
$pgv_lang["register_info_03"]		= "~Anmod om en ny brugerkonto~<br /><br />Mængden af data, der kan vises offentligt på denne website kan begrænses af hensyn til love vedr. privatlivets beskyttelse. Mange mennesker ønsker ikke at deres personlige data gøres offentlig tilgængelig på Internettet. Personlige data kan misbruges til spam eller tyveri af identitet.<br /><br />Adgang til denne site er kun tilladt for <u>familiemedlemmer</u>. AEfter at administratoren har verificeret og godkendt din ansøgning om en brugerkonto, kan du logge ind og de private data.<br /><br />IHvis privatlivsindstilling for relationer er aktiveret, vil du kun være i stand til at se private informationer for dine egne nærmeste slægtninge efter at du har logget ind. Administratoren kan også give visse brugere tilladelse til at redigere databasen, således at de kan ændre og tilføje information.<br /><br />vis du har behov for mere hjælp, venligst brug linket nedenfor til at kontakte administratoren.<br /><br />";


//-- Descendancy-page 
$pgv_lang["help_descendancy.php"]		= "~Efterkommeroversigt~<br /><br />Denne side vil vise personens efterkommere.<br />Du kan vælge en startperson (proband) for efterkommeroversigten, eller du kan overføres til denne side ved at klikke på linket \"#pgv_lang[descend_chart]#\" på en anden side.<br />Ved at klikke på en pil-op, vil startpersonen blive skiftet ud med forældrene til den person pilen stod ved siden af.  Klikker du på ikonet øverst til højre i personboksen vil du få en ny menu frem med nære slægtninge til denne person.";
$pgv_lang["desc_rootid_help"]			= "~Ny startperson / Find ID~<br /><br />Hvis du ønsker at vise et slægtstræ med en ny startperson, så kan du angive personens ID nr. i denne boks.<br />Hvis du ikke kender personens ID nr., kan du bruge linket <b>Find ID</b>.<dl><dt><b>NB!</b></dt><dd><i>Det ID nummer, der bruges i PhpGedView er ikke det samme som personnummeret for en person!<br />Nummeret bruges kun i GEDCOM-filer, og er oprettet af det slægtsprogram, som har genereret slægtsfilen!</i></dd></dl>";
$pgv_lang["desc_generations_help"]		= "~Antal generationer~<br /><br />Her kan du angive antallet af generationer, der skal vises på siden.<br />Hvad der er bedst for dig afhænger af størrelsen på din skærm, og om du viser detaljer eller ikke.";

//-- Time line-page 
$pgv_lang["help_timeline.php"]			= "~Tidslinie~<br /><br />På denne side kan du vise en eller flere person(er) langs en tidslinie.<br />Du kan for eksempel vise status for to eller flere personer på et givet tidspunkt.<br /><ul><li>Hvis du klikker på et Tidslinie-link på en faktaside for en person eller familie, vil denne person / partner vises som første person på tidslinien.</ul><ul><li>Hvis du klikker på Tidslinie i topmenuen, så starter du med en \"blank\" side uden at der er valgt nogen person(er).</ul>";
$pgv_lang["add_person_help"]			= "~Tilføj en person på tidslinien~<br /><br />Du kan have flere personer på tidslinien.<br />Brug dette felt til at angive personens ID nummer.<br />Hvis du ikke kender personens ID nummer, kan du klikke på linket: <b>Find ID</b> efter feltet.";
$pgv_lang["remove_person_help"]			= "~Fjern en person fra tidslinien~<br /><br />Klik på dette link for at fjerne personen fra tidslinien.";
$pgv_lang["show_age_marker_help"]		= "~Vis aldersmarkør~<br /><br />Hvis du sætter et mærke i denne checkboks, vil du se en aldersmarkør, som du kan flytte op eller ned langs tidslinien.<br />Den bevægelige aldersmarkør er en god funktion til at checke en persons alder i forhold til bestemte begivenheder.<br />For hver person i oversigten kan du indsætte eller fjerne aldersmarkøren.";

//-- Relationship-page 
$pgv_lang["help_relationship.php"]		= "~Slægtsrelation~<br /><br />På denne side kan du vise slægtskabet mellem to personer.<br />Det er ikke sikkert at disse personer har et direkte slægtskab (blodslinie).<br />Ethvert tilhørsforhold vil blive fundet!";
$pgv_lang["relationship_id_help"]		= "~ID for Person 1 og 2~<br /><br />Hvis du blev overført til denne side fra en anden side (for eksempel ved at have klikket på linket: <b>slægtskab med dig</b>), så vil du her se slægtskabet mellem de to personer.<br />Ellers må du skrive ID nummeret på de personer, du ønsker at få oplyst slægtsskabet imellem.<br />Hvis du ikke kender personernes ID nummer, kan du klikke på linket: <b>Find ID</b>";
$pgv_lang["next_path_help"]				= "~Find næste slægtslinie~<br /><br />Du kan klikke på denne knap for at se om der findes en anden sti mellem de to personer.<br />De andre stier kan vises igen ved at klikke på linket med stinummeret.";
$pgv_lang["follow_spouse_help"]			= "~Slægsrelationer efter ægteskab~<br /><br />Når denne boks <b>ikke</b> er afmærket, bliver slægtsrelationer kun checket mellem dem, der er i familie med hinanden.<br />Hvis boksen er afmærket, vil også slægtsrelationer mellem gifte blive kontrolleret.  Du vil sandsynligvis finde flest relationer, hvis dette valg er afmærket.";
$pgv_lang["line_up_generations_help"]	= "~Vis generationer på linie~<br /><br />Når denne checkboks er mærket af, vil slægtsrelationer blive vist med ens generationer på samme vandrette linie på skærmen.  Hvis boksen ikke er afmærket, vil hver generation blive vist nedover på siden uafhængig af slægtskabet imellem f.eks. børn og forældre.";
$pgv_lang["oldest_top_help"]			= "~Vis de ældste øverst~<br><br>Når denne boks er mærket af, vil slægtsrelationer blive vist med de ældste personer øverst. Hvis boksen ikke er afmærket, vil den/de yngste person(er) blive vist øverst.<br /><br />NB! Dette valg er kun muligt, hvis <i>#pgv_lang[line_up_generations]#</i> er afmærket.";

//-- Ancestry-page 
$pgv_lang["help_ancestry.php"]			= "~#pgv_lang[ancestry_chart]#~<br /><br />Denne side ligner meget <a href=\"?help=help_pedigree.php\">#pgv_lang[index_header]#</a>, men med flere oplysninger og mulighed for alternativ <a href=\"?help=chart_style_help\">udforming</a>.<br /><br /><b>Nummerering:</b><br />Hver person i alle generationer har fået tildelt et entydigt nummer, beregnet ud fra <a href=\"#system\">systemet</a> lavet af <i>Sosa</i> og <i>Stradonitz</i>:<ul><li>Startpersonen (proband) blir nr 1., faren nr 2. moren nr 3, farfar nr 4, farmor nr 5, morfar nr 6 og mormor nr 7. Oldeforældrene får numre fra 8 (farfars far) til 16 mormors mor).</li><li>Hver generation begynder med et tal, der også angiver, hvor mange aner det er i denne generation ( f.eks. starter oldeforældre-generationen med nr 8 - farfars far - og vi har 8 oldeforældre).</li><li>Lige numre for mænd</li><li>Ulige numre for kvinder (ægtemand+1) med undtagelse af <b>1</b>, der kan være både en kvinde og en mand.</li><li>Anenummeret for en mand (fader) er det dobbelte af hans barns nummer. Anenummeret for kvinden (moren) er det dobbelte plus 1 af barnets nummer.</li></ul>Eks: <b>7</b> er hustruen/kvindelig partner til <b>6</b>, moren til <b>3</b>, og datteren til <b>14</b> og <b>15</b>.<br /><br /><a name=\"system\"></a>Historik:<br />Det var den tyske genealog Stephan Kekule von Stradonitz (1863-1933), som i 1898 tog dette system i brug. Han fandt ud af at det tidligere havde været brugt af den spanske genealog Hieronymus de Sosa i 1600-tallet. Systemet blev allerede i 1590 brugt af tyskeren Michael Eizinger, og det er så logisk, at det sikkert har været brugt af andre førend det blev \"genopdaget\" af von Stradonitz.";
$pgv_lang["box_width_help"]				= "~Boksbredde: #pgv_lang[ancestry_chart]# / efterkommeroversigt~</b><br /><br />Her kan du ændre bredden på boksen fra 50% til 300%.<br />Standardværdi er 100%: Bredden på hver boks er da omtrent 270 pixels.";
$pgv_lang["chart_style_help"]			= "~Stamtræ i bogform~<br /><dl><dt><b>#pgv_lang[ancestry_list]#</b></dt><dd>Vertikal træ med mulighed for at skjule / vise (udvide) familier.</dd><dt><b>#pgv_lang[ancestry_booklet]#</b></dt><dd>En familie pr. side, med forældre, bedsteforældre og alle registrerede børn.<br />Dette slægtstræ giver pæne udskrifter, som man kan forære til slægtninge/interesserede.</dd></dl>";

//-- Fan chart-page 
$pgv_lang["help_fanchart.php"]			= "~#pgv_lang[fan_chart]#~<br /><br />Denne valgmulighed ligner meget <a href=\"?help=help_pedigree.php\">#pgv_lang[index_header]#</a>, men viser det på en mere grafisk måde.<ul><li>Startpersonen (proband) bliver vist i midten, forældrene i den første ring, bedsteforældrene i den anden ring, osv...</li><li>Hvis årene for hhv. fødsel og død er kendte, vil disse blive vist under navnet.</li><li>Ved at klikke på et navn i slægtstræet, vil du få et nyt slægtstræ op med denne person som startperson (proband).</li><li>Under navnet på startpersonen (proband) er der en pil, og ved at klikke på den, vil du få et vindue frem, hvor du kan vælge børn eller søskende til startpersonen.</li></ul><b>PS.</b> <i>Hvis websitet ikke understøtter grafisk visning, vil du ikke få denne valgmulighed!</i>";
$pgv_lang["fan_width_help"]				= "~Bredden af et #pgv_lang[fan_chart]#~</b><br /><br />Her kan du ændre bredden af anehjulet fra 50% til 300%.<br />Standardværdien er 100%. Bredden på billedet er da omtrent 640 pixels.";
$pgv_lang["fan_style_help"]				= "~#pgv_lang[fan_chart]#styper~<br /><dl><dt><b>1/2:</b> Halvcirkel (180 grader) hjul / vifte</dt><dt><b>3/4:</b> Trekvart (270 grader) hjul /vifte eller 'Englevinge'</dt><dt><b>4/4:</b> Helcirkel (360 grader) hjul</dt></dl>";

//-- Hourglass chart-page
$pgv_lang["help_hourglass.php"]		= "~#pgv_lang[hourglass_chart]#~<br /><br />Slægtstræet <b>Timeglasvisning</b> vil vise forfædre og efterkommere til den valgte person i samme slægtstræ.  Timeglasvisningen er en blanding af et anetræ og en efterkommeroversigt.<br /><br />Hovedpersonen er centreret på siden med efterkommere vist til venstre og forfædre til højre.  I dette slægtstræ er hvert slægtsled vist så det yngste starter til venstre og slutter med det ældste til højre.<br /><br />";

//-- Family Book chart-page
$pgv_lang["help_familybook.php"]	= "~#pgv_lang[familybook_chart]#~<br /><br />Dette træ ligner meget timeglasvisningen.  Den viser aner og efterkommere til den valgte startperson i det samme diagram.  Den viser også startpersonens efterkommere i det samme timeglasformat.<br /><br />Startpersonen centreres på siden med hans/hendes efterkommere listet til venstre og anerne listet til højre.  I denne visning er hver generation opstillet tværs over siden startende med den ældste og sluttende med den yngste generation.<br /><br />Hver efterkommer af startpersonen vil blive startperson for en ekstra timeglasvisning, der printes ud på den samme side.  Denne proces gentages indtil det specificerede antal af efterkommergenerationer er blevet printet.";
$pgv_lang["fambook_descent_help"]	= "~#pgv_lang[descent_steps]#~<br /><br />Denne værdi bestemmer antallet af efterkommergenerationer til startpersonen (proband), der vil blive printet ud i timeglasformat.<br /><br />";

//-- Indilist-page 
$pgv_lang["help_indilist.php"]			= "~Personliste~<br /><br />På denne side kan du få en liste over enkeltpersoner.<br /><br />Navnene vil blive vist med efternavnene først og sorteret i alfabetisk rækkefølge.<br />Hvordan personlisten bliver vist afhænger af:<br /><b>1.</b> Det bogstav du klikkede på i den alfabetiske række.<br /><b>2.</b> Du klikkede på Vis \"udvidet liste\" eller \"kun efternavn\".<br /><br />Hvis du har brug for mere hjælp vedrørende dette, kan du klikke på ? bagefter det ønskede valg.";
$pgv_lang["alpha_help"]					= "~Alfabetisk indeks~<br /><br />Ved at klikke på et bogstav i den alfabetiske række, vil du få en liste frem med navne, der starter med det bogstav du valgte.<br />Som en af de sidste i rækken vil du kunne se <b>#pgv_lang[NN]#</b><br />Denne vil du se, hvis der er personer uden efternavn i slægtsdatabasen eller har et efternavn, der begynder med en bogstav, der ikke findes i sprogets alfabet.<dl><dt><b>NB!</b></dt><dd><i>Hvis en person har et <b>efternavn</b> i slægtsdatabasen, som for eksempel: Nn, NN, Ukendt eller N.N., vil denne persons navn <b>ikke</b> blive vist ved at klikke på <b>#pgv_lang[NN]#</b>. Disse personer kan du finde under \"<b>N</b>\" eller \"<b>U</b>\" i den alfabetiske række (se eksemplerne foran).<br />PhpGedView kan ikke tage højde for alle de måder et efternavn kan angives på.</i></dd></dl>Til sidst i den alfabetiske række vil du se \"<b>ALLE</b>\". Her vil du få en liste frem med alle efternavne i slægtsdatabasen.<dl><dt><b>Manglende bogstaver?</b></dt><dd><i>Det kan være at enkelte bogstaver i alfabetet <b>ikke</b> bliver vist.<br />- Men tag den med ro, det er ikke en fejl!  Det er fordi, der ikke findes nogen personer registreret med et efternavn, der begynder med det \"manglende\" bogstav.</i></dd></dl>";
$pgv_lang["name_list_help"]				= "~Navneliste~<br /><br />Denne tabel vil enten vise en liste med efternavne eller en udvidet navneliste.<br />I begge tilfælde vil alle efternavnene starte med det samme bogstav, som du klikker på i den alfabetiske række. Naurligvis gælder det ikke, hvis du klikket på \"ALLE\"<br /><br />Hvis du kun ønsker at se en liste med kun efternavne eller en udvidet liste, afhænger af status på linket nedenunder boksen.";
$pgv_lang["skip_sublist_help"]			= "~Vis: Kun efternavne / Udvidet liste~<br /><br />Normalt vil du få en liste med ene efternavne. Hvis du klikker på dette link, vil du få en udvidet liste (med mere information) over personer / familier, der har et efternavn, der starter med det samme valgte bogstav.<br />Hvis du har en udvidet liste, vil du få listen tilbage med udelukkende efternavne.<br /><br />Hvis du klikker på et navn i listen over ene efternavne, vil du også få en udvidet liste, men kun med personer / familier med dette efternavn.";

//-- Families-page 
$pgv_lang["help_famlist.php"]			= "~Familieliste~<br /><br />På denne side kan du få en liste over familier.<dl><dt>Navnene vil blive vist med efternavnene først og sorteret i alfabetisk rækkefølge.<br />Hvordan navnelisten bliver vist afhænger af:<br /><br /><b>1.</b>&nbsp;Bogstavet du klikkede på i den alfabetiske række.</dt><dt><b>2.</b>&nbsp;Du klikkede på Vis \"udvidet liste\" eller \"kun efternavn\".</dt></dl>Du kan søge efter efternavnet på både ægtemanden og hustruen. Begge findes i listen.<br /><br />Hvis du har behov for mere hjælp vedrørende dette, kan du klikke på <b>?</b> bagefter det ønskede valg.";
$pgv_lang["help_family.php"]			= "~Familieoplysninger~<br /><br />Denne side vil vise en oversigt over den familie, du valgte på forrige side.<br />På venstre side ser du fra toppen følgende bokse:<br /><b>Ægtemanden og hans forældre, hustruen og hendes forældre, samt børnene.</b><br /><br />Udseendet og indholdet af boksene er magen til den du finder for #pgv_lang[index_header]# og #pgv_lang[descend_chart]#.<br />Til højre for navneboksene med forældrene, kan du se en pil, som du kan klikke på (hvis der findes flere forfædre/-mødre i slægtsdatabasen), og så vil du få siden frem med familien til dem.<br />Til højre i navnerammen kan du se et forstørrelsesglas. Klik på det for at vise lidt mere information om personen. Ved at klikke på navnet, vil du få siden frem med faktaoplysninger om personen.<br />Øverst til højre på siden vil du også finde en lille menu, som kan vise dig sider med mere information eller slægtstræer.<br /><br />Fakta om familien viser alle kendte faktaoplysninger om familien, såsom ægteskab, multimedieobjekter og noter. I faktafelterne kan du klikke på stednavn, datoer, mulimedie-objekt, kilder mm, og så vil du få sider op med andre personer, der er knytter til de samme fakta.<br /><br />Under boksene for børnene, finder du et link til #pgv_lang[add_child_to_family]#.<br />Ved siden af boksene for børnene kan du se #pgv_lang[family_group_info]#.<br /><br />Hvis du har de nødvendige rettigheder, kan du også ændre, slette og tilføje data og fakta.<br /><br />På højre side af skærmen kan du se ikonerne og linkene for #pgv_lang[parents_timeline]#, #pgv_lang[view_gedcom]# og (hvis aktiveret) #pgv_lang[add_to_cart]#.<br /><br />#pgv_lang[more_help]#";
$pgv_lang["add_child_help"]				= "~Tilføj et barn til denne familie~<br /><br />Ved at klikke på dette link, kan du tilføje et barn til denne familie.<br />At tilføje et barn er enkelt: Bare klik på linket, og udfyld felterne i det vindue, der dukker op.<br />";
$pgv_lang["show_fam_gedcom_help"]		= "~Vis GEDCOM-post~<br /><br />Ved at klikke på dette link, vil information om kilden, som den er lagret i GEDCOM-filen, blive vist i et separat vindue.";
$pgv_lang["add_fam_clip_help"]			= "~Kopier familie til udklipsholder~<br /><br />Ved at klikke på dette link kan du kopiere data om familien, som den er lagret i GEDCOM-filen, til din Udklipsholder. På den næste siden, der vil blive vist, kan du vælge, hvilke data du ønsker at kopiere; Kun (ægte)parret alene, eller med forældrene og/eller deres børn og/eller alle efterkommere.";
$pgv_lang["show_fam_timeline_help"]		= "~Vis ægtepar/partnere på en tidslinie~<br /><br />Ved at klikke på dette link, vil du få siden med Tidslinien frem. Her vil alle begivenheder knyttet til ægtefællerne blive vist på en grafisk tidslinie.";

//-- Sourcelist-page 
$pgv_lang["help_sourcelist.php"]		= "~Kildeliste~<br /><br />På denne side vises en liste over kilder.<br />Til forskel fra siderne for Personliste og Familieliste, er der ikke nogen alfabetisk række øverst. Det er fordi kilderne kan være personer med fornavn og efternavn, eller det kan være offentlige databaser, kirkebøger osv.<br />Det betyder, at det er vanskeligt at finde en entydig sorteringsrækkefølge. Kilderne er sorteret i alfabetisk rækkefølge, som i slægtsfilen.<br /><br /><b>Om kilder</b><br />Vi er afhængige af kilder for at kunne lave en slægtsdatabase, fordi al information i databasen kommer fra en eller flere kilder. Det kan være en slægtning til en person, en institution, offentlig database, kirkebog osv.<br />En kilde kan være koblet til mange personer. For at sige det på en anden måde, så kan en person også være koblet til mange kilder. Du kan have flere kilder for hver begivenhed, hvadenten det drejer sig om fødselsdag, erhverv, ægteskab, børn, osv.";
$pgv_lang["sourcelist_listbox_help"]	= "~Listen med kilder~<br /><br />I denne liste kan du se navnet på kilderne, som de er gemt i slægtsfilen. Navnene vises i alfabetisk rækkefølge.<br /><br />Når du klikker på en kilde i listen, vil du få en side med detaljer om kilden frem, hvor der vises en liste over personer og/eller familier, der er knyttet til denne kilde.";

//-- Sources-page 
$pgv_lang["help_source.php"]			= "~Detaljer om kilder~<br /><br />På denne side vises oplysninger om kilderne. Kilder er meget vigtige for slægtsforskere, og vil hjælpe dig til at følge de spor, som andre forskere brugte for at finde informationen.<br /><br />På siden vil du kunne se information om titel på kilden, forfatter, publikation og stedet hvor kilden blev fundet.  Fordi der er så mange forskellige typer kilder, kan nogle kilder indeholde mere information end andre.<ul><li>Hvis et multimedieobjekt er knyttet til kilden (såsom et skannet dokument), kan du se objektet i et \"stort\" vindue ved enten at klikke på objektet eller filnavnet ved siden af.</li><li>Efter detaljeoplysninger om kilden, vil du se en liste med alle personer og/eller familier, der er knyttet til kilden.  Dette betyder, at du kan se al information, der blev fundet i en bestemt datakilde.</li><li>Du vil kunne se en eller to menu-ikoner på siden, hvis administratoren af websitet har aktiveret dem:<br />- <b>Vis GEDCOM-post</b>, som viser informationen i GEDCOM-format.<br />- <b>Tilføj til utklipsholderen</b>, betyder at du kan gemme denne information i din udklipsholder. Derfra kan du download informationen og importere den til dit eget slægtsprogram.</li></ul>";
$pgv_lang["sources_listbox_help"]		= "~Navne knyttet til denne kilde~<br /><br />I denne tabel ser du navne på personer og/eller familier, der er koblet til kilden.<br />Navnene vises i alfabetisk rækkefølge.<br /><br />Hvis du klikker på et navn i tabellen, vil du gå til siden med fakta om den enkelt person eller familie.";
$pgv_lang["show_source_gedcom_help"]	= "~Vis GEDCOM-post~<br /><br />Ved at klikke på dette link, vil information om kilden, som den er lagret i GEDCOM-filen, blive vist i et separat vindue.";
$pgv_lang["add_source_clip_help"]		= "~Kopier kilde til udklipsholderen~<br /><br />Ved at klikke på dette link kan du kopiere kilden, som den er lagret i GEDCOM-filen, til din udklipsholder.";
$pgv_lang["delete_source_help"]			= "~Slet kilde fra slægtsdatabasen~<br /><br />Ved at klikke på denne valgmulighed, vil du afmærke kilden til at blive slettet fra GEDCOM.<br />Hvad betyder det?<br />Lad os antage, at du har en god grund til at fjerne denne kilde fra GEDCOM. Når du klikker på linket vil du få et lille vindue op, hvor du blir spurgt, om du er er sikker eller om du vil afbryde.<br /><br />Hvis du fortsætter og fjerner kilden, så må du vente lidt, førend du efter hvert får et vindue op med en besked om at kilden er fjernet.<br /><br />Når du så fortsætter med at bruge phpGedView, vil du lægge mærke til at kilden fortsat er synlig (ikke slettet?). Den kan faktisk fortsat bruges akkurat som før...!<br /><br />Dette er <b>ikke</b> en fejl!<br />Administratoren af siden vil få en besked om, at der er foretaget en ændring af GEDCOM, og at det var dig, der fjernede kilden.<br />Administratoren skal godkende (eller afslå) din ændring. Hvis ændringen bliver godkendt, er den endelig og kan ikke gøres om.<br />Hvis administratoren er i tvivl, vil han/hun kontakte dig.";

//-- Persons per place page 
$pgv_lang["help_placelist.php"]			= "~Stednavne~<br />(eller Personer fra sted)<br /><br />På denne side kan du se, hvilke personer eller familier, der er koblet til forskellige steder vist som niveauer eller en udvidet liste med alle stednavne.<br /><br />Hvis der er en forbindelse imellem en person eller familie og en begivenhed på et bestemt sted, vil programmet finde det for dig.<br /><br />Resultatet blir vist i en todelt tabel:<br />En for personer og en for familier.<br /><br />#pgv_lang[more_help]#";
$pgv_lang["ppp_default_form_help"]		= "~Sortering af stednavne~<br /><br /><b>Standard sortering</b><br />Dette betyder, at stederne ikke er sorteret i nogen speciel rækkefølge i slægtsdatabasen.<br />I dette tilfælde er standard rækkefølge brugt, som vist på denne side.<br />Stederne bliver vist i standard rækkefølge (#pgv_lang[default_form]#).<br /><br />Hvis der er brugt en anden rækkefølge i slægtsdatabasen, vil dette blive vist imellem (...) i slutningen af linien.";
$pgv_lang["ppp_match_one_help"]			= "~Sortering af stednavne~<br /><br />indstillinger<br />Stederne bliver vist i den rækkefølge de blev fundet i slægtsdatabasen.<br />Dette ignorerer standard opsætningen, som bliver brugt, hvis ikke andet er bestemt i slægtsdatabasen";
$pgv_lang["ppp_numfound_help"]			= "~Koblinger til stednavn fundet~<br /><br />Her vises antallet af koblinger til personer, der er fundet indtil nu.<br />Hvis du fortsat ser listen med steder, betyder det, at du ikke har nået det laveste stedniveau endnu.<br />Du kan allerede nu vælge et navn fra <b>Listen med personer/familier</b> eller du kan gå ned yderligere et stedniveau ned ved at klikke på et andet <b>stednavn</b> i listen ovenover.";
$pgv_lang["ppp_levels_help"]			= "~Niveau for stednavne~<br /><br />Her vises den afgrænsning (niveau), der er valgt indtil nu.<br />Tabellen, som viser steder, er egentlig en liste for de tilbageværende niveauer.<br />- Det afhænger naturligvis af at indholdet i slægtsfilen følger denne standard...!<br /><br /><i><b>Eksempel</b></i>:<br />(Standard) niveauer er: #pgv_lang[default_form]#<ul><li>Hvis nuværende niveau er \"#pgv_lang[top_level]#\", så vil tabellen vise alle de lande, der er repræsenteret i slægtsdatabasen.<li>Hvis det nuværende niveau viser: \"Danmark, Landsniveau (top)\", så vil tabellen vise alle byer i Danmark<li>Osv.</ul><br />Du kan klikke på et niveau for at gå et eller flere niveauer ned.";
$pgv_lang["ppp_placelist_help"]			= "~Listen med stednavne (niveau)~<br /><br />I denne liste kan du se de steder, der er fundet på det niveau, du har valgt.<br />Du kan klikke på et stednavn i listen, og derved sætter du en begrænsning (filter) til et geografisk område. Med andre ord så vil det bringe dig et stedniveau ned.<br />Det er kun når du er på top-niveauet, at navnelisten ikke bliver vist. På alle andre stedniveauer der ligger under, vil du få en liste med personer og/eller familier, der er knyttet til dette sted.";
$pgv_lang["ppp_placelist_help2"]		= "~Listen med stednavne (alle)~<br /><br />I denne liste kan du se <b>alle</b> de steder, der findes i slægtsdatabasen.<br />Du kan klikke på en linie i listen, for at få en liste med personer og/eller familier, som er knyttet til dette sted.";
$pgv_lang["ppp_view_records_help"]		= "~Vis alle poster~<br /><br />Ved at klikke på dette link, vil du se en liste med alle personer og familier, som begivenheder knyttet til samme sted.  Når du er kommet til enden af rækken med stedniveauer, som et sted eller en by, vil listen med person- / familienavn blive vist automatisk.";
$pgv_lang["ppp_name_list_help"]			= "~Navneliste~<br /><br />Denne tabel vil vise dig en liste over alle navne på personer og/eller familier, der er knyttet (på en eller anden måde) til dette sted.<br /><br />Navnene i tabellen kan du klikke på, og så vil føre dig til en side med oplysninger om personen eller familien.<br /><br />Du kan også vælge at ændre udvalget i tabellen ved at klikke på et stednavn over denne liste.";

//-- Multimedia-page 
$pgv_lang["help_medialist.php"]			= "~Billeder eller andre medier~<br /><br />Denne liste viser alle MultiMedie Objekter (MMO), der er gemt i denne slægtsdatabase eller med et link til en Internetadresse (URL).<ul><li>For hvert MMO kan du finde en titel eller et filnavn, navn på personer eller familier, der er knyttet til objektet, og eventuelle noter.</li><li>Ved at klikke på navnet eller direkte på billedet, så vil objektet, afhængig af formatet (eks.: *.gif, *.jpg), åbnes i den interne billedfremviser eller i din browser.</li><li>Ved at klikke på \"Vis ...\" under navnet, så vil du få siden op med oplysninger om personen, familien eller kilden.</li><li>Ved at højreklikke på et MMO, vil du få de valgmuligheder frem, som din browser giver dig. Som for eksempel, gemme et billede, bruge det som baggrund, få en udskrift, osv.</li></ul>";

//-- Upload Media-page 
$pgv_lang["help_uploadmedia.php"]		= "~Upload billed- og mediefiler~<br /><br />At uploade filer er enkelt, så her er lidt tillægsinfomation:<br /><br /><b>#pgv_lang[thumbnail]#</b><br />Disse små billeder bør have en bredde på ca. 100px.<br />Filnavnet <b>skal</b> være det samme som originalen.<br /><br /><b>Upload</b> <br />Filerne vil blive overført og gemt i folderen ../media for de store billeder og ../media/thumbs/ for de små billeder. <br /><br />#pgv_lang[readme_help]#</br>";

//-- Anniversaries-page 
$pgv_lang["help_calendar.php"]			= "~Mærkedage~<br /><br /><ul><li><a href=\"#calendar_general\">Generel information</a><li><a href=\"#calendar_day\">#pgv_lang[day]#</a><li><a href=\"#calendar_month\">#pgv_lang[month]#</a><li><a href=\"#calendar_year\">#pgv_lang[year]#</a><li><a href=\"#calendar_show\">#pgv_lang[show]# / #pgv_lang[showcal]#</a><li><a href=\"#calendar_sex\">#pgv_lang[sex]#</a><li><a href=\"#calendar_event\">Begivenhed</a><li><a href=\"#calendar_button\">Vælg visning (knapper)</a><li><a href=\"#calendar_tip\">Tips</a></ul><br /><a name=\"calendar_general\"></a>Mærkedage viser personer og familier, der er knyttet til en begivenhed på en bestemt dag og/eller måned eller i en bestemt tidsperiode. Kalenderen har flere avancerede funktioner til at vise dig de rette begivenheder.<dl><dt><b>Vis <a href=\"#calendar_day\">dag</a></b></dt><dd>Her vises de begivenheder, der er knyttet til en bestemt dag, uafhængig af det valgte år. Du vil se en <i>liste</i> med navne på personer eller familier, eller en tospaltet liste med personer i den første og familier i den anden.</dd><dt><b>Vis <a href=\"#calendar_month\">måned</a></b></dt><dd>Her får du en <i>kalender</i> med navn på personer og/eller familier fordelt på de enkelte dage i den valgte måned. Kalenderen bliver vist i henhold til det år, der er valgt i feltet for år. Det er kun begivenheder <i>frem til den valgte måned og år</i> der vil blive vist.<br />I kombination med valget \"<a href=\"#calendar_show\">#pgv_lang[recent_events]#</a>\" vil den give en autentisk visning, som dine forfædre ville have set den.</dd><dt><b>Vis <a href=\"#calendar_year\">år</a></b></dt><dd>Her vises de begivenheder, der er knyttet til et bestemt år, eller flere år. Du vil se en <i>liste</i> med navn på personer eller familier, eller en tospaltet liste med personer i den første og familier i den anden.</dd></dl>Valgt dag og måned bliver vist i en anden farve i menuen til kalenderen.<br /><br />De navne du finder i listen for dag eller år eller i kalenderen, kan du klikke på. Så vil du kunne se oplysninger om disse personer eller familier. Klikker du på en dato, vil du hoppe til \"Vis dag\" visning (eller år) med begivenheder knyttet til den dato du har klikket på.<br /><br /><a href=\"#top\">#pgv_lang[UpArrow]#</a><a name=\"calendar_day\"> </a>#pgv_lang[annivers_date_select_help]#<br /><a href=\"#top\">#pgv_lang[UpArrow]#</a><a name=\"calendar_month\"> </a>#pgv_lang[annivers_month_select_help]#<br /><a href=\"#top\">#pgv_lang[UpArrow]#</a><a name=\"calendar_year\"> </a>#pgv_lang[annivers_year_select_help]#<br /><a href=\"#top\">#pgv_lang[UpArrow]#</a><a name=\"calendar_show\"> </a>#pgv_lang[annivers_show_help]#<br /><a href=\"#top\">#pgv_lang[UpArrow]#</a><a name=\"calendar_sex\"> </a>#pgv_lang[annivers_sex_help]#<br /><a href=\"#top\">#pgv_lang[UpArrow]#</a><a name=\"calendar_event\"> </a>#pgv_lang[annivers_event_help]#<br /><a href=\"#top\">#pgv_lang[UpArrow]#</a><a name=\"calendar_button\"> </a>#pgv_lang[day_month_help]#<br /><a href=\"#top\">#pgv_lang[UpArrow]#</a><a name=\"calendar_tip\"> </a>#pgv_lang[annivers_tip_help]#";
$pgv_lang["annivers_date_select_help"]	= "~Valg af dag i måneden~<br />Den øverste række i \"datovalg\" er <i>valg af dag</i>.<br />Resultatet af at klikke på en bestemt dag, afhænger af om du tidligere har valgt \"#pgv_lang[viewday]#\" eller \"#pgv_lang[viewmonth]#\".<br />Alle andre valg, som måned, år og begivenheder vil forblive uændrede.<dl><dt><b>#pgv_lang[viewday]#</b> udgaven:</dt><dd>Efter at have klikket på en valgt dag, vil personer, som er knyttet til begivenheder på denne dato, vises.<br />- Hvis der ikke er nogen personer knyttet til denne dag, vil meddelelsen \"#pgv_lang[no_results]#\" blive vist.</dd><dt><b>#pgv_lang[viewmonth]#</b> udgaven:</dt><dd>At skifte dag vil <b>ikke</b> ændre på indholdet af kalenderen...!<br />Grunden er, at dagen allerede findes i kalenderen.<br />Klikker du derimod på knappen <b>#pgv_lang[viewday]#</b>, vil den valgte dag blive vist.</b>.</dd></dl>Til højre i rækken for dag, kan du se et <b>\"Hurtig-link\"</b>, der viser dags dato.<br />Hvis du klikker på linket, vil du automatisk få vist <b>kun</b> denne dag, uafhængig om du på forhånd havde valgt \"#pgv_lang[viewmonth]#\"!<br />";
$pgv_lang["annivers_month_select_help"]	= "~Valg af måned i året~<br />Den midterste række i \"datovalg\" er <i>valg af måned</i>.<br />Resultatet af at klikke på en bestemt måned, afhænger af om du tidligere har valgt \"#pgv_lang[viewday]#\" eller \"#pgv_lang[viewmonth]#\".<br />Alle andre valg, som dag, år og begivenheder vil forblive uændrede.<dl><dt><b>#pgv_lang[viewday]#</b> udgaven:</dt><dd>Efter at have klikket på en valgt måned, vil personer, som er knyttet til begivenheder på denne dato, i den nye måneden vises.<br />- Hvis der ikke er nogen personer knyttet til denne dag, vil meldingen \"#pgv_lang[no_results]#\" blive vist.</dd><dt><b>#pgv_lang[viewmonth]#</b> udgaven:</dt><dd>Efter at have klikket på en valgt måned, vil personer, der er knyttet til begivenheder på denne måned vises i en månedkalender.</dd></dl>Til højre i rækken for måned, kan du se et <b>\"Hurtig-link\"</b> som viser nuværende måned.<br />Hvis du klikker på den, vil du automatisk få vist denne måned, uafhængig af om du på forhånd havde valgt \"#pgv_lang[viewday]#\"!<br />";
$pgv_lang["annivers_year_select_help"]	= "~Skift år~<br />I dette felt kan du ændre årstallet for kalenderen i \"Måned\" eller listen \"År\".<br />For \"Dag\" vil årstallet ikke have nogen betydning.<dl><dt><b>Avancerede tilføjelser</b> for <b>#pgv_lang[viewyear]#:<br />Flere år</b></dt><dd>Flere år kan vises ved at skrive følgende i feltet år:<br />- Eks. 1: <b>1992-5</b> for alle begivenheder fra 1992 til 1995.<br />- Eks. 2: <b>1970-89</b> for alle begivenheder fra 1970 til 1989.<br />- Eks. 3: <b>1600-799</b> for alle begivenheder fra 1600 til 1799.<br />- Eks. 4: <b>1880-1905</b> for alle begivenheder fra 1880 til 1905.<br />- Eks. 5: <b>880-1105</b> for alle begivenheder fra 880 til 1105.<br /><br />Du kan også bare angive begyndelsen af årstallet og få alle begivenheder, der begynder med disse cifre.<br />- Eks.: <b>197</b> for alle begivenheder fra 1970 til 1979.</dd><dt><br /><b>Forkortelser</b></dt><dd>Nogle gange er man ikke sikker på, hvornår en begivenhed egentlig fandt sted. I disse tilfælde kan man anvende betegnelser som \"efter\", \"før\" og \"omkring\" foran datoen. Datoerne bliver gemt i slægtsdatabasen sammen med disse forklaringenr Når du vælger År, kan du også udføre en søgning med disse tilføjelser, med eller uden den tilhørende dato. Her er nogle eksempler på disse udtryk:<br /><b>abt</b> 1800 (abt = about = omtrent)<br /><b>bet</b> 1950-1959 (bet = between = mellem) skriv: bet 1950 eller bare: 1950-59<br /><b>bef</b> 1950 (bef = before = før)<br /><b>aft</b> 1900 (aft = after = efter)<br /><br /><b>NB!</b> PhpGedView vil søge efter registreringer nøjagtig som du opgiver i feltet for år. Når du søger efter \"abt 1850\", og datoen er gemt som i databasen \"abt oct 1850\", så vil denne <b>ikke</b> blive inkluderet i resultatet på skærmen. - Du kan nøjes med at angive forkortelsen uden noget årstal, for at vise alle begivenheder med datoer, der indeholder denne forkortelse.</dd></dl><b>NB!</b> For at se resultatet af at have ændret årstallet, må du derefter enten klikke på en af knapperne \"<b>#pgv_lang[viewday]#</b>\",\"<b>#pgv_lang[viewmonth]#</b>\" eller \"<b>#pgv_lang[viewyear]#</b>\", - eller et af de andre valgmuligheder.<br />";
$pgv_lang["annivers_show_help"]			= "~Vis begivenheder for...~<br />Her har du mindst to valgmuligheder:<dl><dt><b>Alle personer</b></dt><dd>Her vil du se alle personer og familier, der har begivenheder knyttet til den valgte dag/måned.</dd><dt><b>#pgv_lang[recent_events]#</b></dt><dd>Her vil du også se personer og familier, der har begivenheder knyttet til den valgte dag/måned, men ikke længere tilbage end de sidste 100 år.</dd></dl>Der er også en tredje valgmulighed. - Men for at kunne se dette, må du enten være logget ind eller også skal administratoren have slået beskyttelse af privatliv fra for nulevende personer, sådan at faktaoplysninger kan blive vist til alle:<dl><dt><b>Nulevende personer</b></dt><dd>Her vil du kun se nulevende personer og familiemedlemmer, og som har begivenheder knyttet til den valgte dag/måned.</dd></dl>De andre valg for dag, måned, år og type af visning vil ikke blive ændret.<br />";
$pgv_lang["annivers_sex_help"]			= "~Vælg køn~<br />Når du er logget ind (eller hvis administratoren ikke har aktiveret beskyttelse af privatliv), så vil du her få tre valgmuligheder:<dl><dt><b>1. Ikonet Alle</b></dt><dd>Her vil du se alle begivenheder for personer og/eller familier (standard).</dd><dt><b>2. Ikonet Mand</b></dt><dd>Her vil kun begivenheder for personer af hankøn blive vist. I tillæg hertil vil mænd (ægtemænd) i familier blive vist med tilhørende familiebegivenheder.</dd><dt><b>3. Ikonet Kvinde</b></dt><dd>Her vil kun begivenheder for personer af hunkøn bliv vist. I tillæg hertil vil kvinder (hustruer) i familier blive vist med tilhørende familiebegivenheder.</dd></dl>Når du klikker på en af valgmulighederne, vil skærmbilledet blice opdateret, og i forhold til det valg du har foretaget.<br />Andre valg, som dag, måned og år, og begivenheder og type af visning, vil ikke blive ændret.<br />";
$pgv_lang["annivers_event_help"]		= "~Vælg begivenhed~<br />Her kan du vælge om du vil se alle begivenheder for personer og familier<br />eller bare den begivenhed du vælger.<br /><br />Når du klikker på et af valgene, vil skærmbilledet blive opdateret og i forhold til det valg du har gjort.<br />Andre valg, som dag, måned og år, og begivenheder og type visning vil ikke blive ændret.<br />";
$pgv_lang["annivers_tip_help"]			= "~<i>Tips</i>~<br />Antag at du har en slægtning, der er født 25. januar 1875.<br />Juster dato-felterne til denne dato.<br />Hvis du nu klikker på en af knapperne \"Vis dag/måned\", vil du se en liste eller kalender for denne dato.<br /><br />Hvis du vælger måned, vil alle årsdage blive beregnet påny og vist i henhold til den dato du har angivet i dato-felterne.<br />Derfor vil du nu faktisk se den samme kalender, som dine slægtninge ville have set i det angivne år.<br />";
$pgv_lang["day_month_help"]				= "~Knapperne - Vis dag / Vis måned / Vis år~<dl><dt><b>#pgv_lang[viewday]#</b></dt><dd>Klik på den, for at se personer, der er knyttet til begivenheder på den valgte dato. Der bliver søgt i alle år, så du behøver ikke at ændre feltet år.<br />Du kan begrænse resultatet ved at vælge \"#pgv_lang[recent_events]#\" eller, hvis tilgængelig, \"#pgv_lang[living_only]#\".</dd><dt><br /><b>#pgv_lang[viewmonth]#</b></dt><dd>Klik på den, og du vil få en kalender op for den valgte måned.<br />Personer, der er knyttet til begivenheder i denne måned, vil blive vist på de respektive dage i kalenderen.<br />Her kan du også begrænse resultatet ved at vælge \"#pgv_lang[living_only]#\" eller \"#pgv_lang[recent_events]#\".<br /><br />Ved at angive et år i fortiden, så vil du få se kalenderen som den var på den valgte måned i dette året. Alle aldre i kalenderen bliver vist i forhold til det  år der er angivet i feltet.</dd><dt><br /><b>#pgv_lang[viewyear]#</b></dt><dd>Klik på den for at se personer, der er knyttet til begivenheder i det valgte år.<br />Også her kan du begrænse resultatet ved at vælge \"#pgv_lang[living_only]#\" , hvis den er tilgængelig.<br /><br />En god tillægsfunktion er muligheden for at vise flere end et år:<br />Bare skriv en bindestreg og det sidste tal i det sidste år lige efter det første år, så vil programmet vise alle begivenheder disse år (f.eks: 1990-4 for alle begivenheder fra 1990 til 1994).<br />- Du kan også bare angive begyndelsen af årstallet og få alle begivenheder, der begynder med disse cifre. (f.eks: 197 for alle begivenheder fra 1970 til 1979)<br /><br /><b>PS</b> - hvis du har ændret årstallet, så <b>skal</b> du bruge denne eller en af de andre knapper/valgmuligheder for at se resultatet.</dd></dl>De andre valgmuligheder vil ikke ændre sig når du bruger knapperne.<br />";

//-- Clipping Cart-page 
$pgv_lang["help_clippings.php"]			="~Udklipsholder~<br />Denne side giver dig mulighed for at lave en ny GEDCOM-fil med \"udklip\" fra anetræet, og som du kan downloade til din PC bagefter.<dl><dt><b>Hvordan klipper man ud?</b></dt><dd>Det er meget enkelt. Alle de steder, hvor du kan se et navn, du kan klikke på (enkeltperson, familie eller kilde), kan du gå til den tilsvarende faktaside. På faktasiden kan du se følgende link: \"Tilføj til udklipsholderen\".<br />Ved at klikke på linket, vil du få en ny side op, hvor du bliver præsenteret for flere valgmuligheder mht. at tilføje personer og familier<br />i udklipsholderen.<br /></dd><dt><br /><b>Hvordan downloader man?</b></dt><dd>Når du lagt person(er)/familier i din udklipsholder, kan du downloade dem ved bare at klikke på linket: \"Download nu\".<br />Følg så de næste instruktioner og links.</dd></dl>";
$pgv_lang["clip_download_help"]			="~Download~<br />Ved at klikke på dette link, vil du få en ny side op, hvor du får at vide, hvordan du downloader filen.<br />Hvis der er flere valgmuligheder mht. hvad du kan downloade, vil de blive vist på denne side.<br />Følg bare de viste instruktioner.";
$pgv_lang["empty_cart_help"]			="~Tøm udklipsholderen~<br />Ved at klikke på dette link, vil din udklipsholderen tømmes helt.<br /><br />Hvis du ikke ønsker at fjerne alle personer, familier, osv. fra udklipsholderen, kan du fjerne objekt for objekt ved at klikke på linket \"Fjern\" i navne-tabellen. ";

//-- GEDCOM Edit Utility 
$pgv_lang["show_changes_help"]			="~Vis ændringer i slægtsdatabasen (GEDCOM-fil)~<br />Når du ser denne besked, kan det betyde to ting:<dl><dt>1. Nogen har foretaget en ændring i databaseb (GEDCOM-filen)</dt><dd>Poster kan være tilføjet, slettet eller ændret.</dd><dt>2. Ændringerne er ikke blevet godkendt af administratoren endnu.</dt><dd>Når ændringerne er blevet godkendt (eller afslået), vil du ikke se denne besked længere.</dd></dl>Ved at klikke på linket, kan du se, hvilke ændringer, der er foretaget.<br />Hvis du mener, at en ændring ikke er korrekt, giv da venligst besked til admin.";

//-- Search-page 
$pgv_lang["help_search.php"]			="~Søg~<br />Selv om denne side ser meget simpel ud, så befinder der sig en forholdsvis kraftig søgemaskine bagved de to felter.<br />- På mange websites, der viser anetræer, kan du søge på (efter)navn.<br />På denne side kan du praktisk talt søge på alt muligt!<dl><dt><b>Søgefeltet på venstre side af skærmen</b><br />(er det samme som søgefeltet øverst på siden.)</dt><dd>- Hvis du leder efter personer, der er knyttet til et bestemt år, kan du nøjes med at skrive året. Programmet vil finde alle forbindelser for dig.</dd><br /><dd>- Søge efter et navn, eller et sted?<br />Skriv bare navnet eller stedet, hele eller bare dele af det, og programmet gør resten.</dd><dt><b>Søgefeltet på højre side af skærmen</b><br />Fonetisk søgning.</dt><dd>Her kan du søge efter navne, hvis du ikke er helt sikker på, hvordan det staves.</dd><dt>#pgv_lang[more_help]#</dt></dl>";

$pgv_lang["search_enter_terms_help"]	="~Generel søgning~<br />I feltet: <b>Skriv søgeord</b> kan du skrive søgeord som fx datoer, fornavn, efternavn, steder, multimedie, osv.<dl><dt><b>Navn</b></dt><dd>Wildcards (som * eller ?) <b>virker ikke</b>, men programmet bruger wildcards (*) skjult i søgningen.<br /><b>Hvad betyder det?</b><br />Forestil dig, at du skriver \"<b>Tor</b>\" i søgefeltet.<br />- Resultatet vil blive (hvis disse navne findes i databasen):<br />-- <b>Tor</b> Hansen<br />-- <b>Tor</b>e Johnsen<br />-- Per <b>Tor</b>sen<br />-- Person som er født i <b>Tor</b>shavn<br />-- osv.<br /></dd><dt><b>Årstal</b></dt><dd>Skrives et årstal vil det give dig navnene på alle de personer, der er knyttet til dette årstal. Hvis du skriver <b>1950</b>, så vil du finde de personer, der er født, gift, døde eller andet i 1950.<br /><br />Du kan også bruge søgeudtryk i PHP, hvis du er bekendt med dem.<br />For eksempel, hvis du ønsker at finde alle personer, der er er knyttet til datoer i 1900-tallet (20. århundrede), så kan du søge efter:<br /> <b>19[0-9][0-9]</b>, så vil du finde alle de personer der er knyttet til datoer i perioden fra 1900 til 1999.<br /><b>19[5-9][0-9]</b> vil vise alle de personer, der er knyttet til datoer i perioden fra 1950 til 1999.</dd><dt><b>Datoer</dt><dd>PS!</b> Programmet søger efter data, som de er gemt i slægtsdatabasen.<br />Så hvis du ønsker at søge efter en begivenhed på datoen 14. december, bør du skrive måneden på engelsk: <b>14 dec</b>.<br />Hvis du skriver <b>4 dec</b> så vil alle personer knyttet til en begivenhed den 4. december, uanset årstal, blive vist. I tillæg hertil vil personer knyttet til en begivenhed den 14. og/eller 24. december også blive vist.<br /> Men skriver du \"<b>dec 14</b>\", vil resultatet af søgningen blive personer, der er knyttet til begivenheder på fx. 8 <b>dec</b>ember 18<b>14</b>.</dd></dl>>Hvis du har brug for mere hjælp vedr. søgemulighederne, så send os en besked, så vi kan forbedre denne hjælpetekst endnu mere...";

$pgv_lang["soundex_search_help"]		="~Søg som du tror navnet er skrevet~<br />Fonetisk søgning (<a href=\"#soundex\">soundex-metoden</a>) er en forholdsvis kraftig søgemetode.<br />Det finder navne, der udtales på samme måde, men staves forskelligt.<dl><dt><b><i>Hvad betyder dette for dig:</i></b></dt><dd>Hvis du søger efter \"Smith\", vil du kunne få følgende resultat:<br />Smith, Smid, Smit, Smitt, Schmidt, Smyth, Smithe, Smithee, Schmitt, Smead,  Sneed, Smoote m.fl.</dd><dd>- Bare skriv navnet som du tror det skrives.</dd><dt><b>Fornuftigt at anvende når:</b></dt><dd><li>Du kender navnet, men er ikke sikker på stavemåden.</li><li>Du husker ikke navnet, men det var noget med...!</li><li>Det kan også hænde at et navn er skrevet forkert ind i slægtsdatabasen.</dd><dt><b>Hvordan søger du:</b></dt><dd><li>I disse søgefelter, er det tilstrækkeligt at starte med <b>et</b> navn for at søge.</li><li>Du kan udfylde flere felter for at begrænse antallet af hits.</li><li>År kan være et år eller en periode af år (eks. 19[5-7][0-9] for 1950-1979)</li><li>Søgefeltet År kan <b>ikke</b> bruges alene.</li></dd></dl><b>Tips</b>: For at blive fortrolig med brugen af fonetisk søgning, kan du prøve at finde et bestemt navn ved at skrive det på forskellige måder.<br /><br /><b>Soundex metoden:</b><a name=\"soundex\"> </a><br />En fonetisk søgning begynder med det første bogstav i navnet efterfulgt af en tre-cifret kode, som repræsenterer de næste tre bogstaver i navnet. Nuller vil blive føjet til navne, der ikke har nok bogstaver til at blive kodet.<br />";

//-- Individual Information-page 
$pgv_lang["help_individual.php"]		= "~Oplysninger om en person~<br />Denne side vil vise alle oplysninger om personen.<br /><br />Hvis der er et billede tilgængelig, så vil du se det øverst til venstre.<br />Ved siden af billedet (hvis det er der) vil du se detaljer om personens navn.<br />Under navnet vil du kunne se kilde(r) og note(r).  Hvis nogen af navnene har noter eller kilder, vil du se dem listet under de navne, de er knyttet til.<br />En person kan også have et alias (kendt under et andet navn). Hvis det er tilfældet, vil det også blive vist.<br /><br />Hvis du har de nødvendige rettigheder, vil du se links under navnet for at ændre eller slette navnet eller personen.<br /><br />På denne side vil du se faneblade for \"#pgv_lang[personal_facts]#\", \"#pgv_lang[notes]#\", \"#pgv_lang[ssourcess]#\", \"#pgv_lang[media]#\" og \"#pgv_lang[relatives]#\".<br /><br />Her kan du finde al information, der er gemt i slægtsdatabasen om denne person.<dl><dt><b>#pgv_lang[personal_facts]#</b></dt><dd>Dette faneblad vil vise dig alle faktaoplysninger om denne person og eventuelle ægterskaber.<br />- Klikker du på en dato, så vil du få  #pgv_lang[anniversary_calendar]# op, så du kan se alle begivenheder i slægtsdatabasen, der skete på denne dag.<br />- Klikker du på et sted, vil du få siden med stednavne op, så du kan se alle begivenheder i slægtsdatabasen,  som fandt sted på dette sted.  For ægteskab og andre begivenheder knyttet til familien, vil ægtefællens navn også vises, så du kan se på denne og et link til familien.</dd><dt><b>#pgv_lang[notes]#</b></dt><dd>Dette faneblad vil vise dig eventuelle notater om denne person.</dd><dt><b>#pgv_lang[ssourcess]#</b></dt><dd>Dette faneblad vil vise dig alle kilder, der er knyttet til denne person.  Klikker du på kildens titel, vil du få siden med kilder i slægtsdatabasen op, så du kan se andre personer, der er knyttet til den samme kilde.</dd><dt><b>#pgv_lang[media]#</b></dt><dd>Dette faneblad vil vise dig alle billeder og andre medieobjekter, som er knyttet til personen.  Klikker du på et miniaturebillede, vil du se billedet i fuld størrelse.</dd><dt><b>#pgv_lang[relatives]#</b></dt><dd>Dette faneblad viser dig personens forældre og søskende,samt alle ægtefæller og børn, som denne personen har eller har haft.  Personerne vil blive vist i bokse, der svarer til de,, man kan se i slægtstræerne.</dd></dl>Øverst til højre på siden, vil du se en menu sti.<br />De fleste svarer til dem du kan finde i hovedmenuen. Forskellen er, at her vil personen på siden blive startpersonen (proband) i slægtstræerne i stedet for den normale startperson i slægtsdatabasen.<br /><br />Herudover kan det være, at du vil få valget mht at tilføje denne person til Udklipsholderen, vise oplysningerne om denne person som de er gemt i den originale GEDCOM-fil.<br /><br /Hvis du er logget ind og er knyttet til slægtsdatabasen, vil du også få valget <i>#pgv_lang[relationship_to_me]#</i>. Hvis du er i slægt med denne person, vil du få en side op med et slægtstræ, der viser dig slægtskabet.<br /><br />Yderligere hjælp til siden kan findes ved at klikke på <b>?</b> ved siden af links eller bokse.";
$pgv_lang["delete_person_help"]			= "~Slet person fra slægtsdatabasen~<br />Ved at klikke på denne valgmulighed vil du sætte et MÆRKE ved denne PERSON mht. at blive slettet fra slægtsdatabasen.<br /><br />Hvad betyder det?<br />Forestil dig, at du har en god grund til at fjerne denne person fra slægtsdatabasen. Du klikker på linket, og herefter vil du få et nyt vindue op, hvor du blir bedt om at bekræfte sletningen eller ønsker at afbryde.<br /><br />Hvis du bekræfter sletningen, vil dette blive gemt, førend du efter et styke tid får et nyt vindue op med en besked om at sletningen er udført.<br /><br />Hvis du checker om personen er slettet ved at prøve at vise personen pånyt, vil du se at personen stadig er synlig, som før sletningen.<br /><br />Dette er <b>ikke</b> en fejl!<br />Af hensyn til kvaliteten af slægtsdatabasen, så vil administratoren modtage en besked om, at det er foretaget ændringer, og at det er dig, der har fjernet person.<br />Administratoren SKAL godkende (eller forkaste) ændringen.<br />Hvis der er tvivl, vil administratoren kontakte dig vedr. ændringen.";
$pgv_lang["delete_name_help"]			= "~Ændre eller slette navn fra slægtsdatabasen~<br /><br /><b>Ændre navn</b><br />Ved at klikke på dette link, vil du åbne et nyt vindue, hvor du kan ændre personens navn.<br />Det er meget enkelt: Bare skriv ændringen, klik på knappen \"Gem\" og luk vinduet.<br /><br /><b>Slette navn</b><br />Ved at klikke på denne valgmulighed, vil du afmærke navnet mht. sletning.<br />Husk på at slette et navn er noget helt andet end at slette en person.<br />At slette navnet, fjerner kun personens navnefelt. Selve personen vil ikke blive slettet.<br />Hvis det kun er et alias (også kendt som) du ønsker at slette, har personen stadig sit hovednavn intakt.<br />Hvis du sletter det eneste navn en person har, vil personen stadigvæk ikke bive slettet, men fortsætte som \"Ukendt\".<br />Personen vil heller ikke miste en eventuel tilknytning til slægtninge, kilder, noter, osv.<br /><br /><i>Hvad betyder det?</i><br />Forestil dig, at du har en god grund til at fjerne dette navn fra slægtsdatabasen. Du klikker på linket, og så vil du få et nyt vindue op, hvor du bliver bedt om at bekræfte sletningen eller ønsker at afbryde.<br /><br />Hvis du bekræfter sletningen, vil dette blvei gemt, førend du efter et stykke tid får et nyt vindue op med en besked om at sletningen er udført.<br /><br />Hvis du checker om navnet er slettet ved at prøve at vise personen pånyt, vil du se, at navnet stadig er ligeså synlig som før sletningen.<br /><br />Dette er <b>ikke</b> en fejl!<br />Af hensyn til kvaliteten af slægtsdatabasen, så vil administratoren modtage en besked om, at der er foretaget ændringer, og at det er dig, der har fjernet navnet.<br />Administratoren SKAL godkende (eller forkaste) ændringen.<br />Hvis der er tvivl, vil administratoren kontakte dig.";
$pgv_lang["add_name_help"]				= "~Tilføj et nyt navn~<br /><br />Denne valgmulighed giver dig mulighed for at tilføje et nyt navn til denne person.  Nogle gange hænder det, at personer er bedre kendt under et andet navn og/eller et alias'.  Denne valgmulighed betyder, at du kan give en person et nyt navn uden at ændre det gamle og egentlige navn.";
$pgv_lang["add_sibling_help"]			= "~Tilføj en bror eller søster~<br />Ved at klikke på dette link, kan du tilføje et barn til denne familie.<br />\"Denne familie\", er i dette tilfælde, faren og moren til hovedpersonen på denne side.<br />Så, vær opmærksom på, at du tilføjer en bror eller søster til denne person.<br />At tilføje en bror eller søster er enkelt: Bare klik på linket, og udfyld navnet i vinduet, der dukker op.<br /><br />Hvis du skal tilføje en søn eller datter til hovedpersonen, scroll lidt ned på skærmen og klik på linket i \"Familie med ægtemand/hustru\".";
$pgv_lang["add_son_daughter_help"]		= "~Tilføj en søn eller datter~<br />Ved at klikke på dette link, kan du tilføje et barn til denne familie.<br />\"Denne familie\", er i dette tilfælde, hovedpersonen på denne side og hans/hendes forældre.<br />Så, vær opmærksom på, at du tilføjer en søn eller datter til denne person.<br />At tilføje en søn eller datter er let: Bare klik på linket, og udfyld navnet i vinduet, der dukker op.<br /><br />Hvis du skal tilføje en bror eller søster  til hovedpersonen, scroll lidt ned på skærmen og klik på linket i \"Familie med forældre\".";
$pgv_lang["link_child_help"]			= "~Knyt denne person til en eksisterende familie som barn~<br />Ved at klikke på på dette link, kan du knytte denne person som et barn i en eksisterende familie.<br /><br />Forestil dig, at forældrene til personen var ukendte, og du fandt ud af at de (forældrene) har en post i denne slægtsbasen.<br /><br />Ved kun at klikke på linket, angive ID for familien (hvis du ikke kender ID, kan du søge efter det), og du har fuldført koblingen.";
$pgv_lang["link_husband_help"]			= "~Knyt denne person til en eksisterende familie som ægtemand~<br /><br />Dette valg giver dig mulighed for at knytte personen til en eksisterende familie som en ny ægtemand. Familien vil nå få koblet denne person som familiefar hvor det tidligere blev vist som Ukendt. Alle registerede begivenheder, information om ægteskabet og børn vil forblive uændret.<br /><br />Dette er et avanceret ændringsvalg, som kun bør anvendes, hvis familien du ønsker at lave en kobling til, allerede eksisterer.  hvis du kun ønsker at tilføje en ny familie, bruger du valgmuligheden Tilføj en ny hustru.";
$pgv_lang["add_husband_help"]			= "~Tilføj en ny ægtemand~<br />Ved at klikke på dette link, kan du tilføje en \"Ny\" (hankøn) person og knytte denne person til hovedpersonen som en ny ægtefælle/partner.<br /><br />Bare klikk på linken, så vil du få et vindue op for at tilføje den nye person.<br />Udfyld så mange felter som muligt og klik på knappen \"Gem\".<br /><br />Det er alt.";
$pgv_lang["link_new_husb_help"]			= "~#pgv_lang[link_new_husb]#~<br />Dette vil give dig tilladelse til at knytte en anden person, der allerede findes, som ny ægtemand til denne person.  Det vil oprette en ny familie med den ægtemand du vælger.  Du vil også have mulighed for at specificere en vielse for denne nye familie.<br /><br />";
$pgv_lang["link_wife_help"]				= "~Knyt denne person til en eksisterende familie som hustru~<br />Dette valg gør det muligt at knytte denne person som en hustru / partner til en familie som allerede findes i slægtsbasen.  Dette er et avanceret valg, som kun bør anvendes, hvis den familie, du ønsker at lave en kobling til, findes.  Hvis du kun ønsker at tilføje en ny familie, må du bruge valgmuligheden Tilføj en ny ægtemand.";
$pgv_lang["add_wife_help"]				= "~Tilføj en ny hustru~<br />Ved at klikke på dette link, kan du tilføje en \"Ny\" (hunkøn) person og knytte denne person til hovedpersonen som en ny ægtefælle/partner.<br /><br />Bare klik på linket, så vil du få et vindue op for at tilføje den nye person.<br />Udfyld så mange felter som muligt og klik på knappen \"Gem\".<br /><br />Det er alt.";
$pgv_lang["link_new_wife_help"]			= "~#pgv_lang[link_new_wife]#~<br />Dette vil give dig tilladelse til at knytte en anden person, der allerede findes i databasen, som en ny hustru til denne person.  Der vil blive oprettet en ny familie med den valgte hustru.  Du har også muligheden for at specificere vielsen for den nye familie.<br /><br />";
$pgv_lang["add_new_parent_help"]		= "#pgv_lang[multiple_help]#<br />~Legge til en ny far eller mor~<br /><br />Det er selvagt mange personer i slægtsdatabasen som ikke har registrert med sin far og/eller mor.<br /><br />hvis du ønsker at tilføje en af disse kan du gøre dette på siden med <b>Personoplysninger</b> under fanebladet: <b>Nære slægtninge</b>. Under tabellen <b>Familie med forældre</b>, vil du finde linken(e) til at tilføje en <b>ny</b> far og/eller mor til personen.<br /><br /><b>NB:</b><br />Vær opmærksom på at disse links er for at tilføje en <b>ny</b> far og/eller mor!<br />hvis faren eller moren findes fra før i slægtsbasen, så må du anvende linket: <b>#pgv_lang[link_as]##pgv_lang[child]#</b>, som du også finder på denne side under den nederste tabel.";

//-- Add Facts 
$pgv_lang["add_facts_help"]				= "~Tilføj nye fakta~<br />Her kan du tilføje fakta for en eller flere personer.<br /><br />Vælg først en faktaoplysning fra \"drop-down listen\", og klik så på knappen <b>\"Tilføj\"</b>. <br />I \"drop-down listen\" finder du alle tilgængelige faktaoplysninger for slægtsdatabasen.<br />";
$pgv_lang["add_custom_facts_help"]		= "~Tilføj egne fakta~<br />Hvis du ikke finder den type faktaoplysning, du ønsker at tilføje i faktalisten, kan du selv tilføje <b>Egne fakta</b> til listen.<br />Forskellen på at tilføje fra en forhåndsdefineret faktaoplysning er, at du må give den nye faktaoplysning et navn. Det gør du i det øverste felt: <b>#pgv_lang[type]#</b><br />";
$pgv_lang["add_note_help"]				= "#pgv_lang[multiple_help]#<br />~Tilføj ny note~<br /><br />Hvis du har en note/forklaring, som du ønsker at føje til denne person, så er det her du gør det.<br />Metoden er enkel: Klik på linket, og et vindue vil dukke op, hvor du kan skrive din note.<br /><br />Når du er færdig, klikker du bare på knappen \"Gem\" og lukker vinduet.<br /><br />#pgv_lang[add_facts_general_help]#";
$pgv_lang["add_source_help"]			= "#pgv_lang[multiple_help]#<br />~Tlføj ny kildehenvisning~<br /><br />Hvis du ønsker at tilføje en <b>kildehenvisning</b> for denne person, kan du klikke på linket.<br />Du vil da få et nyt vindue op, hvor du blir bedt om at vælge en kilde fra en liste (Find ID) og føje til \"henvisningen\".<br /><br /><b>PS</b>. I øjeblikket er det ikke muligt at tilføje en helt ny kilde...<br /><br />Hvis kilden, som du ønsker at tilføje, ikke findes i listen, giv da venligst administratoren besked. Opgiv alle nødvendige detaljer om kilden, så vil den blive lagt til kildelisten manuelt.<br />Derefter vil du kunne vælge denne kilde fra kildelisten.<br /><br />Sandsynligvis vil muligheden for at tilføje en kilde direkte, blive tilføjet inden længe...<br /><br />#pgv_lang[add_facts_general_help]#";
$pgv_lang["add_media_help"]				= "~Tilføj nye multimediefiler~<br />At tilføje multimediefiler (MM) til slægtsdatabasen er en meget enkel og god funktion.<br />Selv om dette program ser pænt ud i sig selv, vil det se endnu bedre ud, hvis du tilføjer billeder eller andre multimedieobjekter til dine slægtninge.<dl><dt><b>Hvad bør jeg vide om multimedier?</b></dt><dd>Som du sikkert ved, så findes det utallige formater af multimedieobjekter. Selv om PhpGedView kan håndtere de fleste af dem, så er der visse ting, som du bør tage i betragtning.</dd><dt><b>Format</b></dt><dd>Billeder kan ændres og gemmes i mange forskellige formater.<br />F.eks. billede.jpg / billede.png / billede.bmp / billede.gif / osv.<br />Billeder, som af udseende er lige store, kan have vidt forskellige størrelser på filerne.</dd><dt><b>Opløsning</b></dt><dd>Opløsningen af et billede har betegnelsen \"dpi\" (dots per inch). Du kan på en måde sammenligne det med forskellen mellem lysstyrken for en almindelig fotofilm (25 ASA - 200 ASA - 400 ASA).<br />Jo højere opløsning, jo bedre kvalitet og større fil-størrelse.<br />Normalt er 75 dpi god nok til billeder, der skal bruges på internettet!</dd><dt><b>Farvedybde</b></dt><dd>Den tredje måde at begrænse størrelsen på filer, er at reducere antallet af farver, du bruger i billedet.<br />Antallet af farver kan variere fra rent sort og hvidt (2 farver) til millioner af farver.<br />Igen er det antallet af farver, der bestemmer, hvor stor filen bliver.</dd><dt><b>Hvorfor er det vigtigt at have så små filer som muligt?</b></dt><dd>Først og fremmest af hensyn til pladsen på webserveren, der jo er begrænset.<br />Jo større filer, jo mere plads optager vi på webserveren. Med andre ord et spørgsmål om omkostninger...!</dd><dt><b>Download tiden</b></dt><dd>Hvis du har store filer, vil besøgende (også dig) skulle vente længere på at siderne bliver vist. Husk ikke alle har en bredbåndsforbindelse.</dd><dt><b>Hvordan uploader du dine multimediefiler?</b></dt><dd>For at gøre det kort: Det kan du ikke!<br />Og grundene hertil er, som nævnt ovenfor, at du ikke har adgang til det i slægtsdatabasen.</dd><dt><b>Hvad skal du gøre?</b></dt><dd>Kontakt administaroren og fortæl, at du ønsker at tilføje multimediefiler i slægtsdatabasen. Så vil du få råd mht. hvilket format du skal anvende.<br />Når du har billederne i det rigtige format, kan du sende dem med e-mail til administratoren. Billederne vil blive checket og eventuelt lagt ind i multimedie-folderen på websitet.<br />Du kan tilføje multimediefiler til dine slægtninge ved at bruge dette link.</dd></dl>";
$pgv_lang["add_facts_general_help"]		= "~Generel info om at tilføje~<br />Når du har tilføjet en oplysning, note, kilde eller multimediefil for en eller flere personer, skal disse godkendes af en bruger, der har fået de nødvendige rettigheder af administratoren af websitet.<br />I mellemtiden vil ændringerne være synlige på siden for brugere, som kan ændre, men mærket med en farvekodet ramme. For andre vil de ikke være synlige. Når tilføjelserne er blevet godkendt, vil rammen forsvinde og dataene vises til alle.";
//-- Edit user 
$pgv_lang["edituser_my_account_help"]	="På denne side kan du ændre din opsætning og dine valg.<br /><br />Du kan ændre dit brugernavn, fulde navn, adgangskode, sprog, e-mail-adresse, udseende (tema) på siden, og ønsket kontaktmetode.<br /><br />Du kan imidlertid ikke ændre valget for INDI-posten ID selv.<br />";
$pgv_lang["edituser_username_help"]		="~#pgv_lang[username]#~<br /><br />I dette felt kan du ændre dit brugernavn.<br />Hvis du er blevet træt af dit brugernavn, eller har en anden grund til at ændre det, kan du gøre det ved hjælp af dette felt.<br /><br />Brugernavnet er <b>følsomt mht. bogstavtyper (case-sensitiv)</b>. Det betyder, at \"Jon\" ikke er det samme som \"jon\" eller \"JON\".<br /><br />Du bør <b>kun</b> bruge bogstaver fra alfabetet (små og/eller STORE), tal, bindestreg (-) og understregning (_).<br /><br /><b>Brug</b> ikke skilletegn, mellemrum eller andre tegn udover det almindelige alfabet/talrække.";
$pgv_lang["edituser_firstname_help"]		= "~#pgv_lang[firstname]#~<br /><br />I dette felt kan du ændre dit fornavn.  Det er det navn, som andre brugere kan se, når du er logget ind.<br /><br />Selvom det er dit valg hvad du skriver i dette felt, så bør du informere administratoren når du ændrer det.  Når andre ser en ukendt person, der er online, undrer de sig måske og begynder at stille spørgsmål. Administratoren kan selv finde ud af det uden at have modtaget en meddelelse herom, men du bør spare ham for dette unødvendige arbejde.<br /><br />";
$pgv_lang["edituser_lastname_help"]		= "~#pgv_lang[lastname]#~<br /><br />I dette felt kan du ændre dit efternavn.  Det er det navn som andre brugere kan se, når du er logget ind.<br /><br />Selvom det er dit valg hvad du skriver i dette felt, så bør du informere administratoren når du ændrer det.  Når andre ser en ukendt person, der er online, undrer de sig måske og begynder at stille spørgsmål.  Administratoren kan selv finde ud af det uden at have modtaget en besked derom, men du bør spare ham/hende for det unødvendige arbejde.<br /><br />";
$pgv_lang["edituser_gedcomid_help"]		="~#pgv_lang[gedcomid]#~<br /><br />Dette er et internt nummer (GEDCOM ID), der knytter dig til dine egne data i slægtsdatabasen.<br /><br />Du kan ikke ændre dette ID nr.<br />Dette link er lagt ind af adminstratoren af websitet.<br />Hvis du tror, at dette ID nr. ikke er korrekt, bør du kontakte admin for at få rettet det.<br />";
$pgv_lang["edituser_rootid_help"]		="~#pgv_lang[rootid]#~<br /><br />Dette er <i>hovedpersonen</i> for de slægtstræer du vælger i hovedmenuen.<br />Hovedpersonen er med andre ord \"startpersonen\" i din slægtsdatabase.<br />Hvis du f.eks. vælger at se på \"Anetræ\" (anetavle) fra hovedmenuen, så vil du se, at hovedpersonen er placeret i boksen helt til venstre.<br />Hovedpersonen må naturligvis ikke være dig selv, men kan være hvemsomhelst (med undtagelse af personer, der ikke vises på grund af hensynet til beskyttelse af privatlivet.<br />I nogle typer af slægtstræer kan du skifte hovedperson.<br /><br />Vælger du at se et slægtstræ, hvor du befinder dig på en faktaside med deltaljer om en person, vil denne person blive \"midlertidig\" hovedperson.<br />";
$pgv_lang["edituser_password_help"]		="~#pgv_lang[password]#~<br /><br />Det er en god ide, at skifte din adgangskode regelmæssigt.<br />Du bør huske på, at alle der kender dit brugernavn og adgangskode, vil have adgang til dine data.<br />Opret en adgangskode med mindst 6 tegn. - Jo længere, jo bedre!  Lav en kombination af STORE og små bogstaver, tal og andre tegn, du kan finde på dit tastatur.<br />- Men, lav det ikke så vanskeligt, at du må skrive det ned for at huske det. Et stykke papir kan andre finde...<br />Brugernavnet er <b>følsomt mht. store og små bogstaver (case-sensitiv)</b>. Det betyder, at \"Jon5\" ikke er det samme som \"jon5\" eller \"JON5\".<br /><br /><b>PS!</b> Det er imidlertid hensigtsmæssigt <b>ikke</b> at bruge \" (anførselstegn) eller ' (enkelt anførselstegn). Det kan hænde, at det går godt at bruge disse, men vi kan ikke garantere det.<br /><br />";
$pgv_lang["edituser_conf_password_help"]	="~#pgv_lang[confirm]#~<br /><br />Hvis du har ændret din adgangskode, må du også bekræfte det.<br />Dette er kun for at sikre dig mod, at du ikke skrev forkert i adgangskode-feltet.<br />Hvis de ikke er ens, vil du få en fejlmelding: <b>#pgv_lang[password_mismatch]#</b>.<br />Både adgangskode- og bekræftelsesfeltet vil blive tømt, og du må skrive den nye adgangskode igen i begge felter.<br />";
$pgv_lang["edituser_change_lang_help"]	="~#pgv_lang[change_lang]#~<br /><br />Her kan du angive det sprog, som er dit standardsprog på denne side.<br />Programmet er i stand til at genkende det sprog du har valgt i din browser, så i de fleste tilfælde er der ikke nogen grund til at ændre indstillingen her.<br />Imidlertid kan det f.eks. være, at din browser har Engelsk som foretrukket sprog, men at du ønsker at <b>sproget på dette website</b> skal være dansk, så kan du ændre det her.<br />";
$pgv_lang["edituser_email_help"]		="~#pgv_lang[emailadress]#~<br /><br />Din korrekte e-mail-adresse er, naturligvis, vigtig for os for at holde kontakten.<br />Hvis du har fået en ny e-mail-adresse, så husk venligst at ændre adressen her også.<br />Det kan også være, at du har flere e-mail-adresser og ønsker at modtage beskeder fra os på en anden e-mail-adresse.<br />";
$pgv_lang["edituser_user_theme_help"]	="~#pgv_lang[user_theme]#~<br /><br />På dette website kan du kan vælge imellem flere temaer eller layouts.<br />Du kan også kalde det \"websitets udseende\". I hvert tema vil du se de samme oplysninger, bare med et andet layout.<br />Det er som at sætte et billede i en anden ramme eller hænge billede i et andet rum. Billedet er det samme, men det kan alligevel fremstå helt anderledes.<br />Bare prøv de forskellige temaer, og find det du bedst kan lide. Du vil ikke kunne gøre noget galt...<br />Hver gang du logger dig ind, vil du få dit \"eget\" tema/layout.<br />";
$pgv_lang["edituser_contact_meth_help"]	="~#pgv_lang[user_contact_method]#~<br />Vort mailsystem benytter på en måde ualmindelige kontaktmetoder.<br />Kontaktmetoden for at sende e-mail er valgt af administratoren af websitet, så du kan ikke ændre dette.<br />Metoden til at <b>modtage e-mail</b> kan du imidlertid selv bestemme.<br />Der er 4 typer, du kan vælge imellem.";
$pgv_lang["mail_option1_help"]			="Vælges dette, vil PhpGedView nyhedsmeddelelsessystem blive brugt, og der vil ikke blive sendt nogen e-mail.<br />På denne måde vil du kun modtage <b>interne beskeder</b> fra andre brugere.<br />Når andre brugere sender en besked til dig  fra dette website, vil beskeden blive placeret i din beskedramme på din egen side (såfremt du ikke har fjernet denne ramme fra din side).<br />";
$pgv_lang["mail_option2_help"]			="Dette valg fungerer ligesom #pgv_lang[messaging]#, med en tilføjelse.<br />Her vil en kopi af beskeden også blive sendt til din e-mail-adresse, som du har opgivet i Min konto.<br />Denne kontaktmetode er standard.<br />";
$pgv_lang["mail_option3_help"]			="Vælges dette, vil beskeder <b>kun</b> blive sendt til din e-mail-adresse.<br />Andre brugere vil ikke kunne se beskeden.<br />";
$pgv_lang["mail_option4_help"]			="Vælges dette vil du ikke modtage nogen beskeder overhovedet!<br />";

//-- Add user
//$pgv_lang["help_adduser.php"]			="#pgv_lang[sorry]#";

//-- Admin 
$pgv_lang["admin_help"]					="På denne side vil du finde alle links til konfigurationssiderne, administration, dokumentation og log-filer.<dl><dt><b>Systemtid</b></dt><dd>Lige under overskriften på siden, vises dato og tid, som bliver hentet fra webserveren. Klokkeslættet er statisk, fordi den kun viser tidspunktet, da du åbnede denne side (eller reloadede den).</dd></dl><dl><dt><b>ADVARSEL:</b></dt><dd><i>Hvis du ser en melding i systemtiden, så betyder det, at filen <b>config.php</b> stadig er <b>skrivbar!</b><br />Efter at du har konfigureret dit program, bør du af <b>hensyn til sikkerheden</b>, sætte rettighederne til denne fil tilbage til kun læsbar (read-only).<br />Du må gøre det <b>manuelt</b>, da PhpGedView ikke kan gøre det for dig (i denne version).</i></dd></dl>Bortset fra valgene: LæsMig (Readme, brugerdokumentation og Log-fil, kan du få mere hjælp på de sider du vælger.";

//-- User Admin 
$pgv_lang["useradmin_help"]				="~Administration af brugere~<br /><br />På denne side kan du administrere aktiverede og nye brugere.<br /><br /><b>Aktiverede brugere</b><br />I denne tabel vises aktiverede brugere med deres status og rettigheder.<br />Du kan <b>slette</b> eller <b>ændre</b> brugernes konto.<br /><br /><b>Skemaet \"Opret ny bruger\"</b><br />Dette skema svarer næsten til de skemaer, du vil finde under \"Min konto\".<br />For flere felters vedkommende er der ikke lavet en separat hjælpetekst for administratorer. For disse vil du se følgende melding:";
$pgv_lang["useradmin_gedcomid_help"]	="~Bruger ID i slægtsdatabasen~<br /><br />Dette bruger ID vil identificere brugeren i slægtsdatabasen, og kan kun angives af administratoren.<br />Det vil også give brugeren adgang til \"Mig selv\" og \"Mit anetræ\" for ham/hende.<br /><br />For hver slægtsdatabase du bruger i dette program, kan du angive brugerens ID i databasen.<br />Hvis en bruger ikke er registreret i slægtsdatabasen, kan du lade feltet være tomt.";
$pgv_lang["useradmin_rootid_help"]		="~Hoved ID i slægtsdatabasen~<br /><br />For hver slægtsdatabase i programmet, kan du angive en <b>hovedperson</b> for hver bruger.<br />Det er mest almindeligt, at brugeren  ønsker at starte programmet med sig selv, men det er op til brugeren selv.<br /><br />Alle brugere kan ændre denne indstilling selv for sin egen kontoopsætning.";
$pgv_lang["useradmin_can_admin_help"]	="~Bruger kan administrere~<br /><br />Hvis denne checkboks er afmærket, vil brugeren have de samme rettigheder i programmet, som du har, som administrator.<dl><dt>Brugeren kan da:</dt><dd>Tilføje / Fjerne / Ændre brugere.</dd><dd>Sende beskeder til alle brugere på en gang.</dd><dd>Ændre beskeder på velkomstsiden.</dd><dd>Ændre og sætte sprogfiler op.</dd><dt>Herudover</dt><dd>Opgradere programmet.</dd><dd>Ændre programindstillinger.</dd><dd>Administrere slægtsfiler.</dd><dd>Ændre privatlivsindstillinger.</dd></dl>- Og andre ting, som ikke er nævnt her...<br /><br /><b>Men ikke</b> opsætningen af websitet, der befinder sig \"udenfor\" programmet! ";
$pgv_lang["useradmin_sync_gedcom_help"]		= "~#pgv_lang[sync_gedcom]#~<br /><br />Hvis denne checkboks er afmærket og brugeren har en GEDCOM-ID tilknyttet, så vil indstillingen af brugerkontoen automatisk blive synkroniseret med GEDCOM-posten.  Det betyder, at når brugerens GEDCOM-post redigeres, vil noget af informationen såsom e-mail-adresse og navn, blive kopieret til brugerens kontoopsætning.  Når brugerens konto redigeres, så vil den tilsvarende information blive kopieret til GEDCOM-posten.";
$pgv_lang["useradmin_can_edit_help"]	="~Brugerrettigheder~<br /><br />For hver GEDCOM-fil, der er installeret, kan brugere få forskellige rettigheder mht. hvor meget de kan se og ændre data.<dl><dt>Du kan foretage følgende valg:<br /><b>Ingen</b></dt><dd>Brugeren kan ikke se private oplysninger.</dd><dt><b>Fuld indblik</b></dt><dd>Brugeren kan se private oplysninger, men kan ikke foretage ændringer.</dd><dt><b>Ændre</b></dt><dd>Brugeren kan foretage ændringer, men en anden bruger med rettigheder til at <b>godkende</b> skal sige god for ændringerne førend de bliver føjet til slægtsfilen, sådan at alle brugere kan se ændringerne.</dd><dt><b>Godkende</b></dt><dd>Brugeren kan både ændre og godkende egne og andre brugeres ændringer.</dd><dt><b>Administrere</b></dt><dd>Brugeren får rettigheder til at ændre konfigurationen og privatlivsindstillingerne for denne slægtsdatabase.</dd></dl>Systemadministratorer får automatisk rettigheder til at <b>administrere</b>.";
$pgv_lang["useradmin_verified_help"]	="~Brugerbekræftet ansøgning~<br /><br /><b>Bekræftelse</b><br />Dette betyder, at en bruger har ansøgt om at få en ny brugerkonto</b>.<br />Brugeren har modtaget en e-mail med et link, hvor han/hun skal bekræfte ansøgningen.<br />Hvis brugeren har gjort dette, vil du se, at checkboksen er afmærket, og du kan da gå til det næste felt: <b>Godkendt bruger [af Admin]</b>.<br />Hvis ansøgeren ikke har bekræftet, bør du vente med godkendelsen.<br /><br /><b>Tilføj bruger manuelt</b><br />Hvis du bruger dette skema til at tilføje en bruger manuelt, vil du se, at checkboksen allerede er afmærket.";
$pgv_lang["useradmin_verbyadmin_help"]	="~Godkendt bruger [af ADMIN]~<br /><br />Hvis en bruger har anvendt skemaet \"Søg om brugerkonto\" og bekræftet ansøgningen, skal du godkende brugeren førend kontoen bliver aktiveret.<br /><br />Efter at du har godkendt at brugeren får en konto, vil den nye bruger modtage en e-mail med besked om, at kontoen er aktiveret, og at brugeren nu kan logge ind ved hjælp af brugernavnet og adgangskoden, der blev angivet på siden, hvor du søgte om en konto.";
$pgv_lang["useradmin_edit_user_help"]	="~Ændre brugerkonto~<br /><br />Dette skema blveir brugt af administratoren for at ændre en brugers konto.<br /><br />Skemaet svarer til skemaerne \"Opret ny bruger\" og \"Min konto\".";
$pgv_lang["useradmin_visibleonline_help"]	= "~Vis brugere der er logget ind~<br /><br />Hvis denne checkboks er afmærket, vil brugere, der har logget på, se om du og/eller andre brugere også har logget på.  Afmærkes checkboksen ikke, vil andre ikke kunne se, om du har logget på, og du vil heller ikke kunne se om andre brugere har logget på.";
$pgv_lang["useradmin_editaccount_help"]			= "~Ændre brugerkonto~<br /><br />Hvis denne valgmulighed er afmærket, vil brugeren have rettigheder til at ændre sin egen brugerkonto.<br /><br />Hvis valget ikke er afmærket, vil brugeren ikke kunne ændre sine egne brugervalg.  Dette giver dig muligheden for at lave et fælles brugernavn og adgangskode for flere brugere og hindre dem i at ændre den fælles brugerkonto.";
$pgv_lang["useradmin_relation_priv_help"]		= "~#pgv_lang[user_relationship_priv]#~<br /><br />Hvis denne checkboks er afmærket vil brugeren kun få tilladelse til at se nulevende personer, som de er beslægtet med.  De vil kunne se alle, indenfor den relationsstilængde, der er sat i deres <i>#pgv_lang[user_path_length]#</i>. Du kan kræve privatlivsindstilling for alle dine brugere ved at slå den globale privatlivsindstilling til for GEDCOM-filen.<br /><br />Denne indstilling kræver at brugerne knyttes til et GEDCOM ID førend de kan se nulevende personer.<br /><br />";
$pgv_lang["useradmin_path_length_help"]			= "~#pgv_lang[user_path_length]#~<br /><br />Hvis <i>#pgv_lang[user_relationship_priv]#</i> er aktiveret vil en bruger kun kunne se eller redigere levende personer indenfor dette antal af slægtstrin.<br /><br />";
$pgv_lang["useradmin_auto_accept_help"]			= "~#pgv_lang[user_auto_accept]#~<br /><br />Sættes et checkmærke i denne checkboks giver du systemet tilladelse til automatisk at godkende ændringer, der er udført af denne bruger.  Brugeren skal ligeledes have godkendelsesrettigheder til GEDCOM-filen for at det virker.<br /><br />";

//-- Manage Sites
$pgv_lang["help_managesites"] 			= "~Håndter sites~<br /><br />På denne side kan du tilføje eksterne sites og udelukke IP-adresser.<br /><br />Eksterne sites kan tilføjes ved at opgive sitens titel, URL-adresse, database ID (valgfri), brugernavn, og adgangskode for den eksterne webservice.<br /><br />Udelukkelse af IP-adresser gøres ved at angive et gyldigt IP-adresseområde, som fx. 212.10.*.* Eksterne sites indenfor dette IP-adresseområde på listen over udelukkede sites vil ikke kunne få adgang til din website.  Du kan også udelukke en specifik IP-adresse.";
//-- Tilføje eksterne links
$pgv_lang["help_remotesites"]			= "~Tilføj ekstern site~<br /><br />For at tilføje en ekstern site, angives titlen på siten, URL-adressen på den eksterne website, database ID (valgfri), og brugernavn og adgangskode. Klik på <b>Tilføj</b> knappen for at fuldføre processen.  Hvis den eksterne server tillader anonym adgang, bør du undlade at udfylde felterne med brugernavn og adgangskode.";
//-- Udeluk IP-adresser
$pgv_lang["help_banning"]				= "~Udelukke IP-adresser~<br /><br />For at udelukke eksterne sites i at få adgang til din webservice angives en specifik IP-adresse eller et gyldigt IP-adresseområde, for eksempel, 212.10.*.* og klik derefter på <b>Send</b> knappen.";

//-- Upgrade utility 
$pgv_lang["how_upgrade_help"]			= "~Opgraderingsfunktion~<br /><br />Denne funktion vil håndtere opgradering af din eksisterende PhpGedView installation til en ny version, som du har donwloaded.<dl><dt>Download en ny version?</dt><dd>En ny version kan enten downloades direkte fra http://sourceforge.net/projects/phpgedview/ eller også kan du lade opgraderingsfunktion om at checke, om der findes en nyere version. Hvis der findes en nyere version, vil du blive spurgt om du vil downloade den. Det kan enten være en zip- eller gz-fil eller begge dele.</dd></dl><b>Opgradere hvad?</b><dl><dt>PhpGedView</dt><dd>Dette vil opgradere alle de centrale filer til PhpGedView undtagen config.php, privacy.php og authenticate.php. Den opgraderer også billedfolderen.</dd><dt>Indeksfiler</dt><dd>Denne opgraderer /index folderen. Brug denne med forsigtighed, da filer med samme navn vil blive overskrevet.</dd><dt>Sprog</dt><dd>Denne opgraderer /languages folderen.</dd><dt>Tema</dt><dd>Denne opgraderer /themes folderen. Brug denne med forsigtighed, da ændringer, der er udført i standard temaer vil blive overskrevet.</dd><dt>Konfigurationsfil</dt><dd>Denne checker din nuværende konfigurationsfil i forhold til den nye konfigurationsfil og opdaterer din nuværende fil med de nye ændringer der er fundet i den nye konfigurationsfil. Dette sikrer, at du har en opdateret fil med dine egne indstillinger.</dd><dt>Privatlivsfil</dt><dd>Denne checker din(e) nuværende privatlivsfil(er) i forhold til nye privatlivsfil og opgraderer din nuværende fil med de nye ændringer der er fundet i den nye privatlivsfil. Dette sikrer, at du har den sidste nye fil med dine egne privatlivsindstillinger.</dd><dt>Dokumentation</dt><dd>Denne opgraderer /doc folderen.</dd><dt>Lav sikkerhedskopi</dt><dd>Denne vil lave en sikkerhedskopi af den gamle fil i /backup folderen.</dd></dl><b>Hvordan opgradere?</b><dl><dt>1. Vælg de dele du vil opgradere</dt><dt>2. Klik på Gem</dt></dl>Processen vil blive vist nederst.";

//-- G E D C O M 
$pgv_lang["add_upload_gedcom_help"]		="~Tilføje kontra uploade GEDCOM-fil~<dl><dt>Uploade GEDCOM-fil(er)</dt><dd>At uploade filer kan gøres online, hvis du ikke har et ftp-program.</dd><dt>Tilføje en GEDCOM-fil</dt><dd>Hvis en fil stadigvæk findes i den folder, hvor du gemmer dine GEDCOM-filer, kan du bruge den igen uden at hente den igen.<br />Nogle gange skal man bruge \"Tilføj\" i stedet for at uploade på grund af filstørrelsen eller begrænsninger mht. at uploade.</dd></dl>Både proceduren \"Tilføj\" og \"Upload\" kan udføres i 4 enkle trin.<br />Det er kun trin 1, der er forskellig i procedurene.<br />";
$pgv_lang["gedcom_configfile_help"]		="~Konfigurationsfil~<br /><br />Denne fil indeholder alle de grundlæggende indstillinger af slægtsdatabasen.<br /><br />I kolonnen \"Konfigurationsfil\" på siden for Aktive slægtsfiler, vises stien og navnet til konfigurationsfilen.";
$pgv_lang["default_gedcom_help"]		="~Standard slægtsdatabase~<br /><br />Hvis du har mere end en slægtsdatabase i programmet, kan du her angive hvilken, der skal være <b>standard</b> slægtsdatabase.<br /><br />Denne vil blive vist til besøgende og brugere, der ikke er logget ind.<br /><br />Brugere kan ignorere denne indstilling ved at ændre valget af standard slægtsdatabase når de har logget sig ind via deres egen brugerkonto.<br />";
$pgv_lang["delete_gedcom_help"]			="~Slet slægtsdatabasen~<br /><br />PhpGedView importerer poster fra GEDCOM-filen. Hvis du klikker på <b>Slet</b>, vil programmet slette de poster, der blev importeret fra GEDCOM-filen.<br />Den originale GEDCOM-fil vil ikke blive slettet/berørt.<br /><br />Hvis du senere ønsker at anvende eller arbejde med denne GEDCOM-fil igen, kan du bare vælge: <b>Tilføj en GEDCOM-fil</b>.<br /><br />Efter at du har klikket på \"Slet\", skal du <b>bekræfte</b> at du vil slette.";
$pgv_lang["add_gedcom_help"]			="~Tilføj til slægtsdatabasen~<br /><br />Når du anvender linket \"Tilføj til GEDCOM-fil\", er det forudsat, at du allerede har overført GEDCOM-filen til serveren <i>ved hjælp af et eksternt program</i>, for eksempel med <b>ftp</b>- eller <b>netværks</b>-forbindelse.<br />Hvis GEDCOM-filen ikke ligger på serveren endnu, <b>må</b> du gøre dette først, førend du kan anvende \"Tilføj...\".<br /><br />Du får en trin for trin vejledning gennem hele proceduren.<br />";
$pgv_lang["add_new_gedcom_help"]		="~Opret en ny slægtsdatabase (GEDCOM-fil)~<br /><br />Du har muligheden for at oprette en ny slægtsdatabase fra \"scratch\" (dvs. uden personer).<br /><br /><dl><dt>Trin 1: Giv den nye GEDCOM-fil et navn</dt><dd>Skriv navnet på den nye fil <b>uden</b> efternavnet '.ged'. Den nye fil vil blive oprettet/gemt i folderen, som nævnt i teksten over feltet, hvor du skriver filnavnet.<br />Klik på <b>Tilføj</b>.</dd><dt>Trin 2: Konfigurationssiden.</dt><dd>Dette er den side, hvor du angiver indstillingerne for slægtsdatabasen.</dd><dt>Trin 3: Gyldighed</dt><dd>Den nye database er blevet checket og er godkendt.</dd><dt>Trin 4: Importer poster</dt><dd>Da der ikke er nogen poster at importere, er det meget hurtigt gjort...</dd><dt>Færdig...</dt><dd>Nu kan du gå til Anetræet for at se den \"første\" person i den nye slægtsdatabase. Klik på personens navn og begynd derefter med at ændre denne. Derefter kan du begynde at tilføje nye personer knyttet til den første person.</dd></dl>";
$pgv_lang["download_gedcom_help"]		="~Download GEDCOM-fil~<br /><br />Du har mulighed for at downloade en GEDCOM-fil fra websiten.<br /><br />På  siden: \"Download GEDCOM-fil\", får du valget mellem at konvertere filen fra <b>UTF-8</b> til <b>ANSI (ISO-8859-1)</b> tegnsættet.<br />Hvilket format du har behov for, afhænger af det program du anvender til at arbejde med GEDCOM-filen efter den er downloadet.<br />Se dokumentationen til programmet, hvis du ikke er sikker.";
$pgv_lang["edit_gedcoms_help"]			="~Administration af slægtsfiler~<br /><br />Siden, for administration af slægtsfiler er kontrolcenter, hvor du adminstrerer de <b>aktive</b> og <b>nye</b> slægtsfiler.<br /><dl><b>Aktive slægtsfiler (*.ged)</b><br /><dt>I tabellen med <b>Aktive slægtsfiler</b> har du følgende valgmuligheder:</dt><dd>Slette slægtsfilen</dd><dd>Ændre slægtsfilen</dd><dl><dt>Ændre privatlivsfilen</dt><dd>Hver slægtsfil har sine egne privatlivsindstillinger. At ændre indstillinger her vil kun have indvirkning på den slægtsfil, den er knyttet til.</dd></dl><dd>Angiv standard slægtsdatabase</dd><dd>Importer GEDCOM-fil</dd><dd>Download</dd><dt>Der er også her 3 kolonner med følgende information:</dt><dd>GEDCOM-fil</dd><dd>Titel på slægtsdatabasen</dd><dd>Konfigurationsfil</dd></dl><dl><b>Nye GEDCOM-filer</b><dt>På denne side har du følgende valgmuligheder mht. at tilføje <b>nye</b> og/eller <b>eksisterende</b> GEDCOM-filer til programmet.</dt><dd>Tilføj en GEDCOM-fil</dd><dd>Upload GEDCOM-fil</dd><dd>Generer en ny GEDCOM-fil</dd></dl>#pgv_lang[more_help]#<br />";
$pgv_lang["edit_config_gedcom_help"]	="~Konfigurer slægtsdatabase~<br /><br />Hver slægtsdatabase, som du anvender i dette program har sin egen <b>Konfigurationsfil</b>.<br /><br />I dette skema kan du angive de grundlæggende indstillinger som f.eks, sprog, kalenderformat, val af e-mail, osv. osv.<br />";
$pgv_lang["import_gedcom_help"]			="~Importere GEDCOM-filer~<br /><br />I de fleste tilfælde er import af en GEDCOM-fil en del af en større procedure, som for eksempel at tilføje, generere en ny eller uploade filen.<br /><br />Proceduren udføres i en logisk og nødvendig rækkefølge, og skal gennemføres helt for at importen skal ske rigtig.<br />Hvis du ikke fuldfører alle dele af proceduren, som beskrevet ovenfor, vil du få en <b>advarsel</b> om at slægtsdatabasen ikke er bevet importeret endnu. Så bør du klikke på linket igen for at importere GEDCOM-filen påny.<br /><br /><b>Importere</b><br /><br />Indstillingerne af slægtsdatabasen vil ikke blive ændret når du importerer en GEDCOM-fil påny.<br />Bare eksisterende slægtsdata vil blive overskrevet.";
$pgv_lang["upload_gedcom_help"]			="~Upload GEDCOM-filer~<br /><br />Til forskel fra: \"Tilføj GEDCOM-filer\", behøver du ikke at have gemt GEDCOM-filen på serveren tidligerer.<br /><br />Du starter med at vælge en GEDCOM-fil fra din lokale PC. Angiv både stien og filnavnet i tekstfeltet eller brug knappen <b>Browse</b> ved siden af tekstfeltet.<br /><br />Du vil kunne finde mere hjælp på andre sider i løbet af installationen.<br />";
$pgv_lang["validate_gedcom_help"]		="~Check gyldighed af GEDCOM-fil~<br /><br />At checke gyldigheden af GEDCOM-filen under installationen, er en del af trin 3 i proceduren for at lægge dataene ind i programmet.<br /><br />Filen bliver checket mht.: Datoformat, steder, tegnsæt mm.<br />Nogle af de afvigelser, som programmet finder, vil blive rettet automatisk. Eksempler kan være MacIntosh koder i enden af linier og ugyldig anvendelse af formatet på stednavne.<br />Hvis programmet finder disse, vil du få en besked om, at programmet har ændret dataene.<br />For andre afvigelser vil du få en advarsel med et løsningsforslag.<br /><br /><b>Tillægsværktøj</b><br />I denne version af PhpGedView har du disse værktøjer:<br /><b>Ændre person ID til...</b> og <b>Tilføj mediefiler</b>.<br />Dette værktøj er kun tilgængelig når du bruger en <b>database</b>. I <b>index-mode</b> vil dette valg være skjult.<br /><br /><b>Mere hjælp</b> er tilgængelig i skemaet. #pgv_lang[more_help]#<br />";
$pgv_lang["convert_ansi2utf_help"]		="~Konverter ANSI til UTF-8~<br /><br />For at være sikker på, at programmet kan håndtere GEDCOM-filerne korrekt, bør filerne være kodet i UTF-8 format.<br /><br />De fleste slægtsprogrammer har en valgmulighed  for at kunne eksportere GEDCOM-filer med tegnsættet UTF-8.<br />Hvis det program, du anvender, ikke har denne valgmulighed, kan PhpGedView konvertere filen for dig.<br /><br />Når PhpGedview checker kvaliteten under uploading eller tilføjelse af en fil,  vil programmet opdage om filen har et ANSI tegnsæt.";
$pgv_lang["detected_ansi2utf_help"]		="~ANSI tegnsæt opdaget~<br /><br />GEDCOM-filen, der nu er blevet checket mht. gyldighed, har ANSI tegnsæt.<br />Det anbefales på kraftigste, at filen konverteres til UTF-8 tegnsættet (ellers vil sær-nationale tegn (f.eks. ÆØÅ) blive vist forkert).<br /><br />#pgv_lang[convert_ansi2utf_help]#";
$pgv_lang["detected_date_help"]			="~Forkert datoformat opdaget:<br />Dato-formatet vil blive ændret~<br /><br />Dato-formatet, der er standard i PhpGedview og defineret i <b>GEDCOM 5.5 standarden</b>, er: DD MMM YYYY (eks. 01 Jan 2004)<br /><br />Hvis du får en meddelelse om, at forkert datoformat er opdaget, så vil programmet konvertere datoerne til standardformatet.<br /><br />Du får imidlertid et valg om enten \"<b>dag</b> før måned\" (DD MMM YYYY), eller \"<b>måned</b> før dag\" (MMM DD YYYY).<br />Vi anbefaler, at du bruger den foreslåede indstilling (DD MMM).";
$pgv_lang["addmedia_tool_help"]			= "~Tilføj billeder / andre medier~<br /><br />Værktøjet \"Tilføj billeder / andre medier\" blev lavet for brugere, der har et slægtsprogram, men som ikke kan eksportere GEDCOM-filer med medie-links.  Family Tree Maker er mest berygtet for dette.<br /><br />Værktøjet <b>\"Tilføj medie\"</b> giver dig muligheden for at få en liste med medie-links ved siden af GEDCOM-filen og adskilt fra de almindelige PhpGedView tabeller.  Fordi dataene er gemt i adskilte tabeller, behøver du kun at lægge dataene ind en gang.  Det gør det lettere for administratorer at arbejde med slægtsdataene, da man kan eksportere en ny GEDCOM-fil og så anvende værktøjet <b>\"Tilføj billeder / andre medier\"</b> som en selvstændig del af importprocessen, for at tilføje de samme links til billeder hver gang der genereres en ny GEDCOM-fil.<br /><br />For at anvende værktøjet må man først lave en liste med medie-filer ved at udfylde felterne og så klikke på knappen <b>\"Tilføj billede / andet medieobjekt\"</b> for hvert medie-objekt du ønsker at inkludere i GEDCOM-filen.  Feltet \"#pgv_lang[gedcomid]#\" indeholder ID nummeret på den GEDCOM-post, som du ønsker at billedet skal knyttes til, fx. I100.  I feltet: <b>\"Ekstern fil\"</b> skriver du billedets filnavn.  Angiv derefter filens extension (filtype) i feltet \"#pgv_lang[extension]#\".  Brug så feltet \"#pgv_lang[highlighted]#\" for at angive om dette billede er hovedbilledet for denne person eller ej.  Det første billede, afmærket som hovedbillede, vil blive anvendt i slægtstræer og ved siden af personens navn på faktasiden for den pågældende person.  I feltet: <b>\"#pgv_lang[title]#\"</b> anfører du en beskrivende titel eller overskrift på billedet.  Brug feltet: <b>\"#pgv_lang[order]#\"</b> til at angive, i hvilken rækkefølge billedet skal vises under fanebladet: <b>Billeder / medier</b> for den pågældende person.  Til sidst fortæller feltet: <b>\"#pgv_lang[gedcom_file]#\"</b>, hvilken GEDCOM-fil medie-objektet skal knyttes til.  Det betyder, at du kan bruge dette værktøj sammen med flere GEDCOM-filer.<br /><br />Når listen er udfyldt, klikker du på knappen <b>\"#pgv_lang[click_to_add_media]#\"</b> for at gemme ændringerne i GEDCOM-filen.  Næste gang du opdaterer GEDCOM-filen, behøver du kun at starte værktøjet <b>\"Tilføj billeder / andre medier\"</b> og klikke på denne knap.<br /><br />";
$pgv_lang["change_indi2id_help"]		= "~Skift person ID til ....~<br /><br />Dette værktøj blev lavet for brugere af slægtsprogrammer, der genererer forskellige ID numre for personerne hver gang disse eksporteres til en GEDCOM-fil. For eksempel så gav programmet ved første eksport til en GEDCOM-fil, en person ID I100. Næste gang fik samme person ID I234.  Disse udskiftninger af ID numre gør det vanskeligt at administrere PhpGedView, fordi ID nummeret anvendes til at identificere personer.<br /><br />De fleste slægtsprogrammer anvender også RIN- eller REFN-koder (tag) for at give hver person en unik identifikation, der kan bruges til at genkende personen. Dette værktøj vil erstatte alle personers ID numre i GEDCOM-filen med værdien i et andet felt, som du angiver.  Du kan vælge RIN- eller REFN-feltet som kilde til personernes ID numre i slægtsdatabase.<br /><br />";
$pgv_lang["edit_privacy_help"]			="På denne siden kan du oprette dine egne indstillinger mht. beskyttelse af privatlivet den valgte slægtsdatabase (valgte - hvis du har flere end en).<br />Du kan checke under titlen på siden, om det er den rigtige privatlivsfil.<br />Den er vist således: (path/navnet_til_din_gedcom_priv.php).<br /><br />Hvis du har behov for flere indstillinger, så kan du \"manuelt\" ændre privatlivsfilen. Du kan læse mere om dette på PhpGedViews website.<br />";
$pgv_lang["invalid_header_help"]		= "~Ugyldig start i GEDCOM-fil~<br />En GEDCOM-fil skal, som første linie have: 0 HEAD.  PhpGedView opdaget at GEDCOM-filen din har en annen start.  Etter at du har klikket på knappen Rydd, vil alle linjer før linjen med 0 HEAD bli fjernet i GEDCOM-filen din.<br /><br />Denne feilen betyr vanligvis at programmet du brukte for å lage GEDCOM-filen din ikke lagde en gyldig file eller at filen ikke er en GEDCOM-fil.  Du bør sjekke at du lastet op (uploaded) den rette GEDCOM-filen, og at den starter med linjen 0 HEAD og slutter med linjen 0 TRLR.";
$pgv_lang["macfile_detected_help"]		= "~Macintosh-fil opdaget ~<br />PhpGedView har opdaget at din GEDCOM-fil blev genereret på en Macintosh PC.  Macintosh-filer bruger andre koder for linieafslutning (r) end Unix (n) og DOS/Windows (rn).  PHP-funktioner der anvendes af PhpGedView kræver at GEDCOM-filerne skal være Unix- eller DOS-filer.  Når du klikker på knappen <b>Ryd</b /> vil din fil blive konverteret til en DOS-fil.<br />";
$pgv_lang["cleanup_places_help"]		= "~Ryd op i stedkoder~<br />PhpGedView har opdaget at din GEDCOM-fil bruger stedkoden (2 PLAC) på de forkerte steder.  Mange slægtsprogrammer, som f.eks Family Tree Maker, genererer GEDCOM-filer med denne fejl.  PhpGedView vil som udgangspunkt acceptere disse GEDCOM-filer, men ugyldige stedkoder vil \"snige\" sig ind imellem de gyldige stedkoder.  <br /><br />For eksempel kan dn GEDCOM-fil have følgende kodning:<br />1 SSN<br />2 PLAC 123-45-6789<br />I henhold til gældende GEDCOM-specifikation skulle dette have været kodet sådan her:<br />1 SSN 123-45-6789<br />Hvis du vælger <b>Ja</b />, vil PhpGedView søge efter og rydde op i disse kodefejl.<br />";
$pgv_lang["empty_lines_detected_help"]	= "~Tomme linier opdaget~<br />PhpGedView har opdaget, at der er tomme linier i din GEDCOM-fil.  Disse linier kan forårsag fejl og vil blive fjernet fra GEDCOM-filen førend den bliver importeret.<br />";
$pgv_lang["skip_cleanup_help"]			= "~Ikke ryddet op...!?~<br />Det anbefales på det kraftigste, at du du giver PGV tilladelse til at rydde op i din GEDCOM-fil førend den blveir importeret, ellers kan det føre til, at funktioner i programmet ikke vil virke på den måde, der var hensigten.<br /><br />Men hvis du ønsker det, kan du klikke på denne knap og så vil filen blive importeret som den er (uden den anbefalede oprydning).<br />";

//-- Edit Config 
$pgv_lang["help_editconfig.php"]		="~Opsætning af PhpGedView~<br /><br />På denne side har du felterne for de globale indstillinger,som du må udfylde førend PhpGedView-programmet kan køres på din webserver.<br />#pgv_lang[review_readme]#<br /><br />Da disse indstillinger er <b>globale</b>, gælder de for selve programmet og for alle de slægtsfiler, du bruger i programmet.<br />For hver slægtsdatabase kan du have forskellige indstillinger.<br />Her på Konfigurationssiden kan du også klikke på linket til Redigere GEDCOM-filer lige over skemaet eller gå til den samme side via menuvalget \"Min GedView Portal\".";

//-- merge records 
$pgv_lang["help_edit_merge.php"]		= "~#pgv_lang[merge_records]#~<br /><br />Denne side giver dig mulighed for at flette (lægge sammen) 2 GEDCOM-poster i slægtsdatabasen.  Dette er en nyttig funktion, hvis du har importeret en anden slægtsdatabase (GEDCOM) ind i din egen, og du har fået dubletter af flere personer, familier og/eller kilder.<br /><br />Denne side indeholder 3 trin.<br /><ol><li>Du angiver to ID numre i slægtsdatabasen.  ID numrene skal være af samme type. (dvs. at du kan ikke flette en person og en familie, eller en familie og en kilde).  I feltet <b>#pgv_lang[merge_to]#</b> angiver du postens ID nummer (personen), som du ønsker skal være den nye post efter at fletningen er udført.  I feltet <b>#pgv_lang[merge_from]#</b> angiver du ID nummeret på den post, der skal flettes ind i den første og derefter vil blive slettet.</li><li>Du vælger hvilke oplysninger, du vil beholde fra de to poster efter at de flettet sammen til en post.  Du klikker bare på checkfeltet ved siden af dem du ønsker at beholde.</li><li>Viser dig resultatet af fletningen.</li></ol>For at ændringen skal være gyldig og kan vises til andre, skal du checke resultatet og godkende det først.<br />";

//-- report engine 
$pgv_lang["help_reportengine.php"]		= "~Udskrifter~<br /><br />Efter at have valgt den ønskede type af udskrift, må du foretage forskellige valg mht., hvad der skal vises.<br /> I person- og familieudskrifterne kan du bla. vælge, om du vil vise kilder, noter og billeder.<br /><br />Du kan enten vælge <b>#pgv_lang[run_report]#</b> for at se udskriften eller <b>#pgv_lang[download_report]#</b> for at gemme den på din PC.<br /><br /><b>PS1:</b> For at kunne se en PDF-udskrift skal du have Adobe Reader / Acrobat eller tilsvarende installeret.<br /><br /><b>PS2:</b> For administrator af websitet:<br />Tilgængelige udskrifter i menuen / listen bliver vist udfra de udskrifter, der findes i folderen: reports.<br />Udskrifterne bliver lavet ved hjælp af XML-skabeloner. Du kan lave dine egne udskrifter ved at kopiere en af de eksisterende skabeloner og ændre indholdet.<br />Nye udskrifter i folderen: reports, vil automatisk blive opdaget og gjort tilgængelig i menuvalget \"Udskrifter\".";
$pgv_lang["def_pdf_format_help"]	= "~PDF format~<br />PhpGedViews Udskrift generator producerer udskrifter, der kan downloades i pdf format. GEDCOM 5.5.1 formatet, der er omtalt andet sted i denne hjælpefil, kan også downloades i PDF format. PDF er et akronym for <b>P</b>ortable <b>D</b>ocument <b>F</b>ormat<br /><br />PDF filer kan læses og printes vha. Acrobat Reader, der er gratis og kan hentes hos Adobe Systems Inc. på adressen: <a href=\"http://www.adobe.com\" target=_blank>. Acrobat Reader kan fås til mange operativsystemer, og herunder Microsoft Windows XP og Apple Machintosh. Det fås ligeledes i mange sprog.";
$pgv_lang["help_ahnentafel.xml"]	= "~#pgv_lang[ahnentafel_report]#~<br />Dette er en udskrift af den valgte persons og hans/hendes aner printed i bogformat.  Den starter med den første person og fortsætter med hans eller hendes forældre, bedsteforældre, osv.<br /><br />Bemærk, at p.t. er en anetavle udskrift i bogformat kun tilrængelig på engelsk.<br /><br />";
$pgv_lang["help_birthlist.xml"]		= "~#pgv_lang[birth_report]#~<br />Med denne udskrift kan du vise alle personer, der blev født på en bestemt dato eller et bestemt sted.<br /><br />";
$pgv_lang["help_relativelist.xml"]	= "~#pgv_lang[relatives_report]#~<br />Denne udskrift lister alle slægtninge til den valgte person.  Du kan vælge hvilke af slægtninge, der skal vises i udskriften.<ul><li><b>#pgv_lang[child-family]#</b> viser den valgte person, hans/hendes forældre og brødre og søstre.</li><li><b>#pgv_lang[spouse-family]#</b> viser personen, og ægtefællen samt deres børn.</li><li><b>#pgv_lang[direct-ancestors]#</b> viser personen, hans/hendes forældre, bedsteforældre, oldeforældre, og fortsætter op i træet med at vise alle forædrene til personerne i lige linie.</li><li><b>#pgv_lang[ancestors]#</b> viser alle personerne fra #pgv_lang[direct-ancestors]# listen, men medtager også tanter og onkler, grandtanter og grandonkler, samt indeholder søskende til alle aner i personens familietræ.  Den viser ikke kusiner og fætres børn.</li><li><b>#pgv_lang[descendants]#</b> viser alle personens efterkommere (børn, børnebørn, oldebørn, osv).</li><li><b>#pgv_lang[all]#</b> Denne valgmulighed er en kombination af #pgv_lang[descendants]# og #pgv_lang[ancestors]# i en enkelt udskrift.</li></ul><br /><br />";
$pgv_lang["help_xml_reports"]	= "~Reporting Engine~<br />PhpGedViews udskrift generator anvender skabeloner i form af XML filer til automatisk at generere PDF udskrifter.<br /><br />De udskrifter, der er til rådighed i <b>#pgv_lang[select_report]#</b> listen genereres ud fra XML filerne, der findes i \"reports\" folderen.  Du kan oprette dine egne udskrifter ved at lave en kopi af en af de medfølgende skabeloner og modificere den.  For at tilføje din egen tilpassede udskrift, skal du blot placere den i \"reports\" folderen. PhpGedView vil automatisk opdage den og gøre den tilgængelig i <b>#pgv_lang[select_report]#</b> drop-down listen.<br /><br />";

//-- Help Contents 
$pgv_lang["help_contents_head_help"]		= "<b>Emner i hjælp</b><br />";
$pgv_lang["help_contents_gedcom_info"]		= "GEDCOM-fil";
$pgv_lang["help_contents_gedcom_places"]	= "Steder i slægtsdatabasen (GEDCOM-fil)";

//-- Admin Help Contents Items 
$pgv_lang["admin_help_contents_head_help"]	="<b>Emner i hjælp<br /><br />Emner for Administrator</b> tilføjet i starten af listen.<br /><br />";
// $pgv_lang["ah1_help"]					="_Opgradere";
$pgv_lang["ah2_help"]					="_PhpGedView indstillinger";
$pgv_lang["ah3_help"]					="_GEDCOM: Tilføje kontra uploade";
$pgv_lang["ah4_help"]					="_GEDCOM: Konfigurationsfil";
$pgv_lang["ah5_help"]					="_GEDCOM: Standard";
$pgv_lang["ah6_help"]					="_GEDCOM: Slette";
$pgv_lang["ah7_help"]					="_GEDCOM: Tilføj";
$pgv_lang["ah8_help"]					="_GEDCOM: Oprette ny";
$pgv_lang["ah9_help"]					="_GEDCOM: Download";
$pgv_lang["ah10_help"]					="_GEDCOM: Siden Administration";
$pgv_lang["ah11_help"]					="_GEDCOM: Konfigurere";
$pgv_lang["ah12_help"]					="_GEDCOM: Importere";
$pgv_lang["ah13_help"]					="_GEDCOM: Upload";
$pgv_lang["ah14_help"]					="_GEDCOM: Check gyldighed";
$pgv_lang["ah15_help"]					="_GEDCOM: Konvertere ANSI til UTF-8";
$pgv_lang["ah16_help"]					="_GEDCOM: Privatlivsindstillinger";
$pgv_lang["ah17_help"]					="_Brugere og rettigheder";
$pgv_lang["ah18_help"]					="_Administration";
$pgv_lang["ah19_help"]					="_GEDCOM: Medieværktøj";
$pgv_lang["ah20_help"]					="_GEDCOM: Ændre ID for person(er) til ...";
$pgv_lang["ah21_help"]					= "_Sprogfiler";
//           22 is in the help_text_vars.php
$pgv_lang["ah23_help"]				= "_Konfigurer understøttede sprog";
$pgv_lang["ah24_help"]				= "_Bruger Information flet sammen (Index --&gt;&gt; SQL)";
$pgv_lang["ah25_help"]				= "_PhpGedView backup";
$pgv_lang["ah26_help"]				= "_FAQ liste: Rediger";

//-- Find Media Help 
$pgv_lang["manage_media_help"]		= "~#pgv_lang[manage_media]#~<br /><br />Dette er trin to i forberedelserne for uploading af medie-filer. Her må du checke, at du har de rigtige underfoldere til standard folderen for medie-filer.<br /><br />Som administrator kan du oprette den folderstruktur du har behov for for at holde styr på dine medie-filer. Ved at oprette foldere via denne side, sikrer du at der bliver oprettet underfoldere til miniaturebilleder, og at der oprettes en tilhørende index.php i hver folder.<br /><br />Du kan flytte filer op og ned i folder strukturen ved at bruge valgmuligheden <b>#pgv_lang[move_to]#</b>.  Miniaturebilleder bliver også flyttet, således at folderstrukturen holdes intakt.<br /><br />Hvis du ikke har uploadet miniaturebilleder, glemt at afmærke valget <b>#pgv_lang[gen_thumb]#</b> under uploading eller et miniaturebillede ikke blev fundet (check valgmuligheden <b>#pgv_lang[show_thumbnail]#</b>), har du også her mulighed for at generere miniaturebilleder ved at klikke på valgmuligheden <b>#pgv_lang[gen_thumb]#</b>.<br /><br />";
$pgv_lang["simple_filter_help"]		= "~#pgv_lang[filter]#~<br /><br />Enkelt søgefilter baseret på de bogstaver/tegn, der er skrevet ind.  Ingen wildcards (?*) er tilladt.<br /><br />";
$pgv_lang["show_thumb_help"]		= "~#pgv_lang[show_thumbnail]#~<br /><br />Miniaturebilleder vil blive vist, hvis du sætter et mærke i denne checkboks.<br /><br />";
$pgv_lang["new_dir_help"]			= "~#pgv_lang[add_directory]#~<br /><br />Som en administrator kan du oprette den folderstruktur du har behov for, for at få styr på dine medie-filer. Ved at oprette foldere via denne side, sikrer du at der bliver oprettet underfoldere til miniaturebilleder, og at der oprettes en tilhørende index.php i hver folder.<br /><br />Klik på denne valgmulighed for at angive navnet på den folder, du ønsker at oprette.<br /><br />";
$pgv_lang["find_media_help"]		= "~#pgv_lang[find_media]#~<br /><br />Her har du muligheden for at søge i folderstrukturen for at finde den medie-fil, du ønsker at lave en link til.<br /><br />";

//-- Alive in Year Help 
$pgv_lang["alive_in_year_help"]		= "~#pgv_lang[alive_in_year]#~<br /><br />Her vil du se de personer, der sandsynligvis er i live i det valgte år.<br /><br />Når der er angivet bestemte datoer for fødsel og død for personer, vil disse blive vist, hvis det valgte år ligger indenfor deres levetid.<br /><br />Angiv et andet år og klik på knappen <b>#pgv_lang[view]#</b> for at se, hvem der levede i dette år.  Under listen vil du også se tællere for #pgv_lang[total_living]#, #pgv_lang[total_dead]# og #pgv_lang[total_not_born]#.<br /><br />";
$pgv_lang["year_help"]				= "~#pgv_lang[alive_in_year]#~<br /><br />Angiv det år du ønsker at se de personer, der var i live.<br /><br />";

//--Repository Help 
$pgv_lang["help_repolist.php"]		= "~#pgv_lang[repo_list]#~<br /><br />En liste over opbevaringssteder eller arkiver bliver vist på denne side.<br />Navnene er vist i alfabetisk rækkefølge.<br /><br /><b>Opbevaringssted</b><br />Uden opbevaringssteder for kilder kan vi ikke lave slægtsdatabasen. Der er en kilde til al den information der er gemt her, og kilderne opbevares på et opbevaringssted. Opbevaringssteder kan være en person, en persons arkiv, en institution, en offentlig database, et offentligt eller kirkeligt arkiv, en Internetkilde, osv. For at få adgang til en kilde, så ønsker vi at vide hvor og på hvilket sted den befinder sig. Al nødvendig information til at finde en kilde bør gemmes i en liste over opbevaringssteder.<br /><br />Et opbevaringssted kan knyttes til mange kilder.<br /><br />";
$pgv_lang["help_repo.php"]			= "~#pgv_lang[repo_info]#~<br /><br />Detaljer vedr. opbevaringsstedet bliver vist her. Sammen med kilder, er information om opbevaringsstederne meget vigtig for slægtsforskere.  Ved at have nøjagtig information om kilder og opbevaringsteder, kan du følge de spore, som andre slægtsforskere brugte for at finde informationen.  Du bør kunne finde den samme information igen.<br /><br />På denne side vil du forhåbentligt kunne se information om navnet på opbevaringsstedet, adresse, e-mail og internetside.<br /><br />Efter informationen om opbevaringsstedet, vil du se en liste med alle kilder, der er knyttet til dette opbevaringssted. Det giver dig muligheden for at se al information, der er fundet på dette bestemte opbevaringssted.<br /><br />Du vil også have to eller flere valmuligheder i menuen på denne side, hvis administratoren af websitet har aktiveret det:<br /><b>#pgv_lang[view_gedcom]#</b>, som viser informationen i GEDCOM-format.<br /><b>#pgv_lang[add_to_cart]#</b>, der gør det muligt at kopiere informationen til #pgv_lang[clip_cart]# ditt. Herfra kan du downloade informationen i GEDCOM-format og importe den i dit slægtsprogram på din lokale PC.<br /><br />#pgv_lang[context_help]#<br /><br />";
$pgv_lang["delete_repo_help"]			= "~#pgv_lang[delete_repo]#~<br /><br />Når du klikker på denne valgmulighed, så sætter du et mærke ved opbevaringsstedet til at blive slettet i slægtsdatabasen.<br /><br />Hvad betyder det?<br />Forestil dig, at du har en god grund til at fjerne opbevaringsstedet fra slægtsdatabasen. Du klikker på det valgte sted for at slette.  Du vil nu blive spurgt, om du virkelig ønsker at slette den.  Hvis du vælger at fortsætte, så kan det tage lidt tid førend du kan se beskeden om at opbevaringsstedet er slettet.<br /><br />Hvis du viser listen med opbevaringssteder påny, vil du se, at opbevaringsstedet stadigvæk bliver vist og kan anvendes, som om det ikke var slettet.<br /><br /><b>Dette er <u>ikke</u> en fejl.</b>  Administratoren af websitet vil få en besked om, at en ændring er foretaget i slægtsdatabasen, og at det var dig, der fjernede informationen om opbevaringsstedet.<br />Administratoren kan godkende eller forkaste din ændring. Kun efter at administratoren har godkendt din ændring, vil sletningen blive udført, og <u>kan ikke fortrydes</u>.  Hvis der er tvivl med hensyn til ændringen, vil administratoren kontakte dig.<br /><br />";
$pgv_lang["show_repo_gedcom_help"]	= "~#pgv_lang[view_gedcom]#~<br /><br />Når du klikker på denne valgmulighed, vil informationen om opbevaringsstedet, som det er gemt i slægtsdatabasen, blive vist i et separat vindue.<br /><br />";
$pgv_lang["add_repository_clip_help"]		= "~#pgv_lang[add_to_cart]#~<br /><br />Når du klikker på denne valgmulighed kan du kopiere informationen om opbevaringsstedet, som det er gemt i slægtsdatabasen, til din #pgv_lang[clip_cart]#.<br /><br />";
$pgv_lang["repolist_listbox_help"]		= "~#pgv_lang[repo_list]#~<br /><br />I denne liste kan du se navnene på opbevaringsstederne, som de er gemt i slægtsdatabasen.<br />Navnene vises i alfabetisk rækkefølge.<br /><br />Hvis du klikker på et navn i listen, vil du gå til siden #pgv_lang[repo_info]#, hvor du vil se en ny liste med kilder, der er knyttet til opbevaringsstedet.<br /><br />";
$pgv_lang["repos_listbox_help"]		= "~#pgv_lang[other_repo_records]#~<br /><br />I denne liste kan du se navnene på de kilder, der er knyttet til opbevaringsstedet.<br />Navnene er vist i alfabetisk rækkefølge.<br /><br />Når du klikker på et navn i listen, vil du gå til siden med detaljer for den valgte kilde.<br /><br />";

// Index-Edit
$pgv_lang["block_move_up_help"]		= "~Flyt rammer på listen~<br /><br />Brug disse knapper til at ændre på rækkefølgen af rammerne i listen.  Rammerne vil blive printet ud i den rækkefølge de er listet.<br /><br />Marker den ramme, der skal flyttes, og klik på knappen for at flytte den op eller ned.<br /><br />";
$pgv_lang["block_move_right_help"]	= "~Flyt rammer på listen~<br /><br />Brug disse knapper til at flytte en ramme fra en liste til en anden.<br /><br />Marker den ramme, der skal flyttes, og klik derefter på en knap for enten at flytte eller kopiere rammen i pilens retning.  Brug <b>&raquo;</b> og <b>&laquo;</b> knapperne til at flytte den markerede ramme fra den venstre liste til den højre liste eller omvendt.  Brug <b>&gt;</b> og <b>&lt;</b> knapperne til at flytte den markerede ramme mellem <b>#pgv_lang[available_blocks]#</b> listen og listen til højre eler venstre herfor.<br /><br />Indførslerne i <b>#pgv_lang[available_blocks]#</b> listen ændres ikke, uanset hvad du gør med knapperne <b>#pgv_lang[move_right]#</b> og <b>#pgv_lang[move_left]#</b>, fordi den samme ramme kan vises flere gange på den samme side.  HTML-rammen er et godt eksempel på, hvorfor du måske ønsker at gøre dette.<br /><br />";
$pgv_lang["block_default_index"]	= "~Standard rammer på #pgv_lang[welcome]# siden~<br /><br />Når du fjerner alle rammer fra #pgv_lang[main_section]# og #pgv_lang[right_section]# lister, eller når du klikker på <b>#pgv_lang[reset_default_blocks]#</b> knappen, vil rammelisten sættes som følger:<br /><br /><center><table border=\"1\"><tr><td class=\"list_value\"><b>#pgv_lang[main_section]#</b></td><td class=\"list_value\"><b>#pgv_lang[right_section]#</b></td></tr><td>#pgv_lang[gedcom_stats_block]#<br />#pgv_lang[gedcom_news_block]#<br />#pgv_lang[gedcom_favorites_block]#<br />#pgv_lang[review_changes_block]#</td><td>#pgv_lang[gedcom_block]#<br />#pgv_lang[random_media_block]#<br />#pgv_lang[todays_events_block]#<br />#pgv_lang[logged_in_users_block]#</td></tr></table></center><br />";
$pgv_lang["block_default_portal"]	= "~Standard rammer på #pgv_lang[mygedview]# side~<br /><br />Når du fjerner alle rammer fra #pgv_lang[main_section]# and #pgv_lang[right_section]# lister, eller når du klikker på <b>#pgv_lang[reset_default_blocks]#</b> knappen, så vil rammelisten sættes som følger:<br /><br /><center><table border=\"1\"><tr><td class=\"list_value\"><b>#pgv_lang[main_section]#</b></td><td class=\"list_value\"><b>#pgv_lang[right_section]#</b></td></tr><td>#pgv_lang[todays_events_block]#<br />#pgv_lang[user_messages_block]#<br />#pgv_lang[user_favorites_block]#<br />&nbsp;</td><td>#pgv_lang[welcome_block]#<br />#pgv_lang[random_media_block]#<br />#pgv_lang[upcoming_events_block]#<br />#pgv_lang[logged_in_users_block]#</td></tr></table></center><br />";

// accesskey help
$pgv_lang["accesskey_viewing_advice_help"]	= "~#pgv_lang[accesskeys]#~<br />Hensigten med tastaturgenveje er at hjælpe brugere, der har svært ved at anvende pegeredskaber, som fx en mus.  Genveje varierer afhængig af, hvilken browser, du anvender:<ul><li><b>Internet Explorer 5+:</b> Hold ALT-tasten nede mens du taster de ønskede bogstaver og tegn, og tryk derefter på ENTER tasten.</li><li><b>Firefox og Netscape 6+:</b> Hold ALT-tasten nede, mens du taster de ønskede karakterer.  Tryk IKKE på ENTER tasten bagefter.</li><li><b>Opera:</b> Hold SHIFT- og ESC-tasterne nede samtidigt, mens du taster de ønskede karakterer.  Tryk IKKE på ENTER tasten bagefter.</li><li><b>Internet Explorer 5+ til Mac / Safari 1.2+:</b> Hold CTRL-tasten nede mens du taster de ønskede karakterer.  Tryk IKKE på ENTER tasten bagefter.</li></ul><br />De følgende tastaturgenveje er til rådighed: <ul><li>Alle sider <ul><li><b>nul</b> - Information om tastaturgenveje</li><li><b>et</b> - #pgv_lang[welcome_page]#</li><li><b>#pgv_lang[accesskey_help_content]#</b> - #pgv_lang[help_contents]#</li><li><b>#pgv_lang[accesskey_help_current_page]#</b> - #pgv_lang[help_for_this_page]#</li><li><b>#pgv_lang[accesskey_contact]#</b> - Kontakt </li><li><b>#pgv_lang[accesskey_skip_to_content]#</b> - Skip og gå til indholde</li><li><b>#pgv_lang[accesskey_search]#</b> - #pgv_lang[search]# </li></ul></li><li>Person side<ul><li><b>#pgv_lang[accesskey_individual_details]#</b> - Vis #pgv_lang[personal_facts]# tab</li><li><b>#pgv_lang[accesskey_individual_notes]#</b> - Vis #pgv_lang[notes]# tab</li><li><b>#pgv_lang[accesskey_individual_sources]#</b> - Vis #pgv_lang[ssourcess]# tab</li><li><b>#pgv_lang[accesskey_individual_media]#</b> - Vis #pgv_lang[media]# tab</li><li><b>#pgv_lang[accesskey_individual_relatives]#</b> - Vis #pgv_lang[relatives]# tab</li><li><b>#pgv_lang[accesskey_individual_research_log]#</b> - Vis #pgv_lang[research_log]# tab</li><li><b>#pgv_lang[accesskey_individual_pedigree]#</b> - Vis personers #pgv_lang[pedigree_chart]#</li><li><b>#pgv_lang[accesskey_individual_descendancy]#</b> - Vis personers #pgv_lang[descend_chart]#</li><li><b>#pgv_lang[accesskey_individual_timeline]#</b> - Vis personers #pgv_lang[timeline_chart]#</li><li><b>#pgv_lang[accesskey_individual_relation_to_me]#</b> - Vis personers #pgv_lang[relationship_to_me]# slægtstræer</li><li><b>#pgv_lang[accesskey_individual_gedcom]#</b> - #pgv_lang[view_gedcom]#</li></ul></li><li>Familieside <ul><li><b>#pgv_lang[accesskey_family_parents_timeline]#</b> - #pgv_lang[parents_timeline]# faneblad</li><li><b>#pgv_lang[accesskey_family_children_timeline]#</b> - #pgv_lang[children_timeline]# faneblad</li><li><b>#pgv_lang[accesskey_family_timeline]#</b> - #pgv_lang[family_timeline]# faneblad</li><li><b>#pgv_lang[accesskey_family_gedcom]#</b> - #pgv_lang[view_gedcom]#</li></ul></li></ul><br />";

// FAQ page
$pgv_lang["help_faq.php"] = "~Frequently Asked Questions/Ofte stillede spørgsmål~<br />#pgv_lang[text_faq_help]#<br />";
$pgv_lang["text_faq_help"] = "FAQ (Frequently Asked Questions) siden kan indeholde et overblik eller en liste med spørgsmål og svar vedr. brugen af denne site.<br /><br />Hvordan FAQ-siden anvendes er helt op til administratoren. Administratoren af siten styrer indholdet af hvert emne og også den rækkefølge de vises i.";

// Help search
$pgv_lang["hs_title_help"] 			= "<center>~#pgv_lang[hs_title]#~</center><br />#pgv_lang[hs_intro]#<br /><br />#pgv_lang[hs_keyword_advice]#<br /><br />#pgv_lang[hs_searchhow_advice]#<br /><br />#pgv_lang[hs_searchin_advice]#";
$pgv_lang["hs_intro"]				= "Du kan søge i PhpGedView's hjælpesystem. Funktionen: <b>#pgv_lang[hs_title]#</b> i hovedmenuen giver dig en høj grad af kontrol over den måde, hvorpå søgesystemet fungerer, så du let burde kunne finde det du søger efter.";
$pgv_lang["hs_keyword_advice"] 		= "~#pgv_lang[hs_keyword]#~<br />Du skriver de ord eller den sætning, som du ønsker at finde.<br /><br />Søgningen tager ikke hensyn til store og små bogstaver (er ikke case-sensitiv).  Det betyder, at hvis du søger på ordet <b>Person</b>, så vil du finde de tekster, der indholder ordene <b>Person</b>, <b>person</b>, eller <b>PERSON</b>.  Du vil også finde de tekster, der indeholder ordet i flertal som fx <b>personer</b>, osv. fordi søgesystemet vil lede efter sekvenser af bogstaver frm for ord.<br /><br />Du kan søge på flere ord samtidigt.  Skriv alle ordene adskilt med et mellemrum på følgende måde: <b>person&nbsp;familie&nbsp;barn</b>.  Når man angiver mere end et ord vil betydningen fremgå af feltet: <b>#pgv_lang[hs_searchhow]#</b>.<br />";
$pgv_lang["hs_searchin_advice"]		= "~#pgv_lang[hs_searchin]#~<br />Du definerer omfanget af søgningen her.<br /><br />Administratorer har muligheden for at søge i Brugerhjælpen eller Konfigurationshjælpen eller i begge typer af hjælp.  Brugere har ikke denne mulighed, da de ikke har adgang til funktioner, der vedrører konfiguration (indstilling) af databasen. De kan kun søge i den fil, der indeholder brugerhjælpen.<br /><br />Hjælpefilen indeholder ikke kun hjælpetekst, men også tekststrenge, der anvendes til at opbygge formularer til indtastning samt andre ting.  Ved hjælp af denne valgmulighed kan du bestemme om hele hjælpefilen skal søges igennem eller kun hjælpeteksten.<br />";
$pgv_lang["hs_searchhow_advice"]	= "~#pgv_lang[hs_searchhow]#~<br />Du kan give en forklaring på det, du har indtastet i #pgv_lang[hs_keyword]# feltet ved at vælge mellem de muligheder, der er vist her.<br /><dl><dt><b>#pgv_lang[hs_searchany]#</b></dt><dd>Hvis du har indtastet <b>person&nbsp;familie&nbsp;barn</b>, så vil hjælpeteksten, der indeholder et af disse ord, blive fundet.  Rækkefølgen af ordene er uden betydnng.  Søgningen betyder: \"Find hjælpeteksten, der indeholder ordene <b>person</b> <u>eller</u> <b>familie</b> <u>eller</u> <b>barn</b>\".</dd><br /><dt><b>#pgv_lang[hs_searchall]#</b></dt><dd>Hvis du har indtastet <b>person&nbsp;familie&nbsp;barn</b>, så vil den hjælpetekst, der indheolder alle de tre ord findes.  Rækkefølgen af ordene er uden betydning.  Søgningen betyder: \"Find den hjælpetekst, der indeholder ordene <b>person</b> <u>og</u> <b>familie</b> <u>og</u> <b>barn</b>\".</dd><br /><dt><b>#pgv_lang[hs_searchsentence]#</b></dt><dd>Hvis du har indtastet ordene <b>person&nbsp;familie&nbsp;barn</b>, så vil den hjælpetekst, der indeholder alle ordene i den rækkefølge, de er angivet, findes.  Søgningen betyder: \"Find den hjælpetekst, der indeholder ordene <b>person&nbsp;familie&nbsp;barn</b> i nøjagtig den rækkefølge, de er angiver uden andre ord eller tegn imellem\".  Du vil sandsynligvis ikke finde nøjagtigt denne sætning i en hjælpetekst.<br /><br />For denne type søgning er der nogle få begrænsninger.  Visse specielle tegn som fx <b>&quot; &lt; &gt;</b> osv. findes i hjælpeteksten i form af symboler og vil ikke blive fundet, hvis de indgår i den tekst du indtaster.  Nogle hjælpetekster indeholder en speciel type af mellemrumstegn, der er repræsenteret af <b>&amp;nbsp;</b> og du vil ikke kunne finde sætninger, der indeholder dette tegn.</dd></dl>";

?>
