<?php
/*
 * $Id: class.htmlStatuses.inc.php,v 1.2 2001/05/29 05:42:54 themaniac Exp $
 *
 * Double Choco Latte - Source Configuration Management System
 * Copyright (C) 1999  Michael L. Dean & Tim R. Norman
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *
 * Select License Info from the Help menu to view the terms and conditions of this license.
 */



class htmlStatuses
{
	function createCombo($default = 0, $cbName = 'status', $longShort = 'name', $size = 0, $activeOnly = true, $setid = 0)
	{
		print $this->GetCombo($default, $cbName, $longShort, $size, $activeOnly, $setid);
	}

	function GetCombo($default = 0, $cbName = 'status', $longShort = 'name', $size = 0, $activeOnly = true, $setid = 0)
	{
		$objDBStatuses = CreateObject('ccs.dbStatuses');

		$query = "SELECT a.id,a.$longShort FROM osims_statuses a ";

		/*
// we'll nuke attribute support for now
		if ($setid > 0)
		{
			$query .= ",attributesetsmap b WHERE a.id=b.keyid AND b.typeid=4 AND b.setid=$setid ";
			if ($activeOnly)
				$query .= ' AND a.active=\'Y\' ';
		}
		else
		{
			if ($activeOnly)
				$query .= 'WHERE a.active=\'Y\' ';
		} */

		$query .= "ORDER BY $longShort";
		$objDBStatuses->db->query($query);

		$str = "<select name=\"$cbName";
		if ($size > 0)
			$str .= '[]" multiple size="' . $size;

		$str .= '">';
		if ($size == 0)
			$str .= sprintf('<option value="0">%s</option>', "whooandwhat?");

		while ($objDBStatuses->db->next_record() )
		{
			$id = $objDBStatuses->db->f(0);
			$text = $objDBStatuses->db->f(1);
			$str .= "<option value=\"$id\"";
			if ($id == $default)
				$str .= ' selected';
			$str .= '>' . $text . '</option>';
			//	if ($objDBStatuses->db->next_record() == -1)
			//break;
		}

		$str .= '</select>';

		return $str;
	}

	function PrintAll($orderBy = 'name')
	{
		// global $dcl_info;

		$objDBStatus = CreateObject('ccs.dbStatuses');
		$objDBStatus->Connect();

		$objDBStatus->Query("SELECT id,active,short,name FROM osims_statuses ORDER BY $orderBy");
		$allRecs = $objDBStatus->FetchAllRows();

		//	if ($GLOBALS['SEC'] >= $dcl_info['DCL_ADD_USER'])
		$titleLink = '<a class="alight" href="index.php?menuAction=ccs.boStatuses.add">[ ' . STR_CMMN_NEW . ' ]</a>';
		//	else
		//	$titleLink = '';

		if (is_array($allRecs))
		{
			$allName = array(
					0 => STR_STAT_ID, 
					1 => STR_STAT_ACTIVEABB, 
					2 => STR_STAT_SHORT, 
					3 => STR_STAT_NAME);

			if (count($allRecs) > 0) // && $GLOBALS['SEC'] >= $dcl_info['DCL_ADD_USER'])
			{
				$allName[] = 'Options';
				for ($i = 0; $i < count($allRecs); $i++)
				{
					$options = '<a class="adark" href="index.php?menuAction=boStatuses.modify&id=' . $allRecs[$i][0] . '">' . "edit". '</a>';
					$options .= '&nbsp;';
					$options .= '<a class="adark" href="index.php?menuAction=boStatuses.delete&id=' . $allRecs[$i][0] . '">' . "delete" . '</a>';
					$allRecs[$i][] = $options;
				}
			}
			PrintArrayAsChocoTable($allName, $allRecs, sprintf("Select Status", $orderBy), '', $titleLink);
		}
		else
		{
			print('<center>');
			PrintWithChocoFont(STR_STAT_NOSTATS . '&nbsp;&nbsp;' . $titleLink);
			print('</center>');
		}
	}

	function ShowEntryForm($obj = '')
	{
		global $dcl_info;

		$isEdit = is_object($obj);

		$Template = CreateObject('phpgwapi.Template',$phpgw->common->get_tpl_dir('ccs'));
		// $Template = CreateTemplate(array('hForm' => 'htmlStatusesForm.tpl'));
		$Template->set_file(array('hForm' => 'htmlStatusesForm.tpl'));
		$Template->set_var('COLOR_DARK', $dcl_info['DCL_COLOR_DARK']);
		$Template->set_var('COLOR_LIGHT', $dcl_info['DCL_COLOR_LIGHT']);

		$hidden_vars = '';
		if ($isEdit)
		{
			$Template->set_var('TXT_FUNCTION', "Edit");
			$hidden_vars .= '<input type="hidden" name="menuAction" value="ccs.boStatuses.dbmodify">';
			$hidden_vars .= '<input type="hidden" name="id" value="' . $GLOBALS['id'] . '">';
		}
		else
		{
			$Template->set_var('TXT_FUNCTION', "Add");
			$hidden_vars .= '<input type="hidden" name="menuAction" value="ccs.boStatuses.dbadd">';
		}

		$Template->set_var('HIDDEN_VARS', $hidden_vars);

			// Labels
		$Template->set_var('TXT_ACTIVE', "Active");
		$Template->set_var('TXT_SHORT', "Short");
		$Template->set_var('TXT_NAME', "Name");
		$Template->set_var('BTN_OK', "Ok");
		$Template->set_var('BTN_RESET', "reset");
		$Template->set_var('TXT_HIGHLIGHTEDNOTE', "eh?");
		$Template->set_var('TXT_ATTRIBUTESNOTE', "What?");

			// Data
		if ($isEdit)
		{
			$Template->set_var('CMB_ACTIVE', GetYesNoCombo($obj->active, 'active', 0, false));
			$Template->set_var('VAL_SHORT', $obj->short);
			$Template->set_var('VAL_NAME', $obj->name);
		}
		else
		{
			$Template->set_var('CMB_ACTIVE', GetYesNoCombo('Y', 'active', 0, false));
			$Template->set_var('VAL_SHORT', '');
			$Template->set_var('VAL_NAME', '');
		}

		$Template->pparse('out', 'hForm');
	}
}
?>
