/*************************************************************************/
/* module:          The XML Encoder source file                          */
/* file:            xltencxml.c                                          */
/* target system:   All                                                  */
/* target OS:       All                                                  */   
/*************************************************************************/

/*
 * Copyright Notice
 * Copyright (c) Ericsson, IBM, Lotus, Matsushita Communication 
 * Industrial Co., LTD,Motorola, Nokia, Palm, Inc., Psion, 
 * Starfish Software (2001).
 * All Rights Reserved.
 * Implementation of all or part of any Specification may require 
 * licenses under third party intellectual property rights, 
 * including without limitation, patent rights (such a third party 
 * may or may not be a Supporter). The Sponsors of the Specification 
 * are not responsible and shall not be held responsible in any 
 * manner for identifying or failing to identify any or all such 
 * third party intellectual property rights.
 * 
 * THIS DOCUMENT AND THE INFORMATION CONTAINED HEREIN ARE PROVIDED 
 * ON AN "AS IS" BASIS WITHOUT WARRANTY OF ANY KIND AND ERICSSON, IBM, 
 * LOTUS, MATSUSHITA COMMUNICATION INDUSTRIAL CO. LTD, MOTOROLA, 
 * NOKIA, PALM INC., PSION, STARFISH SOFTWARE AND ALL OTHER SYNCML 
 * SPONSORS DISCLAIM ALL WARRANTIES, EXPRESS OR IMPLIED, INCLUDING 
 * BUT NOT LIMITED TO ANY WARRANTY THAT THE USE OF THE INFORMATION 
 * HEREIN WILL NOT INFRINGE ANY RIGHTS OR ANY IMPLIED WARRANTIES OF 
 * MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE. IN NO EVENT 
 * SHALL ERICSSON, IBM, LOTUS, MATSUSHITA COMMUNICATION INDUSTRIAL CO., 
 * LTD, MOTOROLA, NOKIA, PALM INC., PSION, STARFISH SOFTWARE OR ANY 
 * OTHER SYNCML SPONSOR BE LIABLE TO ANY PARTY FOR ANY LOSS OF 
 * PROFITS, LOSS OF BUSINESS, LOSS OF USE OF DATA, INTERRUPTION OF 
 * BUSINESS, OR FOR DIRECT, INDIRECT, SPECIAL OR EXEMPLARY, INCIDENTAL, 
 * PUNITIVE OR CONSEQUENTIAL DAMAGES OF ANY KIND IN CONNECTION WITH 
 * THIS DOCUMENT OR THE INFORMATION CONTAINED HEREIN, EVEN IF ADVISED 
 * OF THE POSSIBILITY OF SUCH LOSS OR DAMAGE.
 * 
 * The above notice and this paragraph must be included on all copies 
 * of this document that are made.
 * 
 */

/*************************************************************************/
/*  Definitions                                                          */
/*************************************************************************/

#include "xltencxml.h"
#include <libstr.h>
#include "xlttags.h"
#include <libmem.h>

/**
 * FUNCTION: xmlGenerateTag
 *
 * Generates a XML tag
 *
 * PRE-Condition:   valid parameters 
 *
 * POST-Condition:  the XML tag is written to the XML buffer
 *
 * IN:              tagId, the ID for the tag to generate (TN_ADD, ...)
 *                  tagType, the tag type (e.g. Begin Tag -> TT_BEG, ...)
 *                  attFlag, indicates if the encoded tag contain Attributes in namespace extensions
 *
 * IN/OUT:          pBufMgr, pointer to a structure containing buffer management elements
 * 
 * RETURN:          shows error codes of function, 
 *                  0, if OK
 */
Ret_t xmlGenerateTag(XltTagID_t tagId, XltTagType_t tagType, BufferMgmtPtr_t pBufMgr, SmlPcdataExtension_t attFlag)
{
  Ret_t _err;

  MemByte_t _begpar = XML_BEGPAR;
  MemByte_t _tagdel = XML_TAGDEL;
  MemByte_t _endpar = XML_ENDPAR;

  String_t _tagstr;

  if ((_tagstr = (String_t)smlLibMalloc(XML_MAX_TAGLEN)) == NULL) return SML_ERR_NOT_ENOUGH_SPACE;

  if ((_err = getTagString(tagId, _tagstr)) != SML_ERR_OK)
  { 
    smlLibFree(_tagstr);
    return _err;
  }

  if (!_tagstr)
  { 
    smlLibFree(_tagstr);
    return SML_ERR_XLT_INVAL_TAG_TYPE;
  }

  //check if content byte has to be added to the tag
  switch (tagType)
  {
    // set the end tag
    case TT_END:
    {
      if ((_err = xltAddToBuffer((MemPtr_t)(&_begpar), 1, pBufMgr)) != SML_ERR_OK) break;

      if ((_err = xltAddToBuffer((MemPtr_t)(&_tagdel), 1, pBufMgr)) != SML_ERR_OK) break;      
      
      if ((_err = xltAddToBuffer((MemPtr_t)_tagstr, smlLibStrlen(_tagstr), pBufMgr)) != SML_ERR_OK) break;

      if ((_err = xltAddToBuffer((MemPtr_t)(&_endpar), 1, pBufMgr)) != SML_ERR_OK) break;      
      
      break;
    }    
    //Empty tag 
    case TT_ALL:
    {
      if ((_err = xltAddToBuffer((MemPtr_t)(&_begpar), 1, pBufMgr)) != SML_ERR_OK) break;

      if ((_err = xltAddToBuffer((MemPtr_t)_tagstr, smlLibStrlen(_tagstr), pBufMgr)) != SML_ERR_OK) break;

      if ((_err = xltAddToBuffer((MemPtr_t)(&_tagdel), 1, pBufMgr)) != SML_ERR_OK) break;      

      if ((_err = xltAddToBuffer((MemPtr_t)(&_endpar), 1, pBufMgr)) != SML_ERR_OK) break;      

      break;
    }
    //Only Begin Tag -> content follows -> content byte has to be added
    case TT_BEG:
    {
      if ((_err = xltAddToBuffer((MemPtr_t)(&_begpar), 1, pBufMgr)) != SML_ERR_OK) break;

      if ((_err = xltAddToBuffer((MemPtr_t)_tagstr, smlLibStrlen(_tagstr), pBufMgr)) != SML_ERR_OK) break;

      if (attFlag == SML_EXT_META)
      {
        if ((_err = xltAddToBuffer((MemPtr_t) META_INF_ALL, 22, pBufMgr)) != SML_ERR_OK) break;        
      }

      if ((_err = xltAddToBuffer((MemPtr_t)(&_endpar), 1, pBufMgr)) != SML_ERR_OK) break;
      break;
    }
    default: 
    {
      smlLibFree(_tagstr);
      return SML_ERR_XLT_INVAL_TAG_TYPE;
    }
  }
  smlLibFree(_tagstr);

  return _err;
}

