<?php
  /**************************************************************************\
  * phpgwTimeTrack - Setup                                                   *
  * http://www.phpgroupware.org                                              *
  * --------------------------------------------                             *
  *  This program is free software; you can redistribute it and/or modify it *
  *  under the terms of the GNU General Public License as published by the   *
  *  Free Software Foundation; either version 2 of the License, or (at your  *
  *  option) any later version.                                              *
  \**************************************************************************/

  /* $Id: fixcontacts.inc.php,v 1.1 2001/07/13 20:08:55 rschader Exp $ */
$phpgw->db->query("select job_id, contact_id from phpgw_ttrack_jobs");
echo "Fixing Contact ID relations for all job entries...<br>";
$i=0;

while ($phpgw->db->next_record()) {
	$job_id[$i] 	= $phpgw->db->f("job_id");
	$contact_id[$i]	= $phpgw->db->f("contact_id");
	// Can't do any other queries until we've read everything in, so
	// Contemplated trying to fixup org_name entries in this routing too,
	// but it would only cover contacts who have jobs related.
	$i++;
}

for($t=0; $t < $i; $t++) {
	$phpgw->db->query("SELECT ab_id, ab_firstname, ab_lastname from addressbook "
		. "WHERE ab_id=$contact_id[$t]";
	$c_matches = $phpgw->db->num_rows();
	switch($c_matches){
		case 0:
		  //Not good, but what to do?
		  echo "No Match found, Manual intervention needed<br>";
		  echo "Contact ID=$contact_id[$t], Job ID=$$job_id[$t]<br>";
		  break;
		case 1:
		  // This is the best situation we want, no possible duplicates.
		  $phpgw->db->next_record();
		  $n_given = $phpgw->db->f("ab_firstname");
		  $n_family = $phpgw->db->f("ab_lastname");
		  // Use the contacts class to look up the new contact id here
		  $contacts = CreateObject('phpgwapi.contacts');
		  $qfields = array(
			'id' => 'id',
			'n_given' => 'n_given',
			'n_family' => 'n_family'
		  );
		  $start = 0;
		  $offset = 0;
		  $query = $n_given . " " . $n_family;
		  //$query = "";
		  //$filter = "org_name=" . addslashes($compname);
		  $filter='tid=n';
		  $sort = "asc";
		  $order = "id";
		  $entries = $contacts->read($start,$offset,$qfields,$query,$filter,$sort,$order);
		  $num_entries = count($entries);
		  switch($num_entries) {
			case 0:
			  echo "No Match, not good!<br>";
			  break;
			case 1:
			  // One match, what we want.
			default:
			  // Even if there are multiple matches, we will assume they are
			  // duplicates and just go with the first one.
			  $n_id = $entries[0]['id'];
			  // Update the jobs entry to reflect the new id here.
			  $phpgw->db->query("UPDATE jobs set contact_id=$n_id WHERE job_id=$job_id[$t]";
			  break;
		  } // End of switch($num_entries)
		  break;
		default:
		  // After analyzing this, I see that there would never be more
		  // than one match to an auto inc contact_id.
		  echo "Impossible Error, more than one ID matches<br>";
		  break;
	} // End of switch($c_matches)
} // End of for loop

// This next block updates contacts org_name from link of old addressbook->company_id
// We are basically going to grab the entire list of contacts here
$contacts = CreateObject('phpgwapi.contacts');
$qfields = array(
  'id' => 'id',
  'owner' => 'owner',
  'n_given' => 'n_given',
  'n_family' => 'n_family',
  'org_name' => 'org_name'
);
$start = 0;
$offset = 0;
$query = "";
$filter='tid=n';
$sort = "asc";
$order = "n_given,n_family";
$entries = $contacts->read($start,$offset,$qfields,$query,$filter,$sort,$order);
if (count($entries) == 0) {
  echo "Contact List appears to be completely empty.<br>";
}
for ($i=0; $i<count($entries); $i++)
{
  $n_id = $entries[$i]['id'];
  $owner = $entries[$i]['owner'];
  $ab_firstname = $entries[$i]['n_given'];
  $ab_lastname = $entries[$i]['n_family'];
  $org_name = $entries[$i]['org_name'];
  // Find the original data from old addressbook table.
  $phpgw->db->query("SELECT company_id from addressbook "
	. "WHERE ab_firstname='$ab_firstname' AND ab_lastname='$ab_lastname'");
  $c_matches = $phpgw->db->num_rows();
  switch($c_matches){
	case 0:
	  //Not good, but what to do?
	  echo "Lookup of data in old addressbook table failed<br>";
	  break;
	case 1:
	  // This is good, no duplicates
	default:
	  // Go ahead and do it anyway for now.
	  $phpgw->db->next_record();
	  $company_id = $phpgw->db->f("company_id");
	  $phpgw->db->query("SELECT company_name from phpgw_ttrack_customers "
		. "WHERE company_id=$company_id");
	  $phpgw->db->next_record();
	  $company_name = $phpgw->db->f("company_name");
	  if($org_name == ""){
		$fields['org_name'] = $company_name;
		// Might have to add 3 null args to next call? ("","","")
		$contacts->update($n_id,$owner,$fields);
	  }
	  break;
  } // End switch($c_matches)

}

?>
