/* Identities */

INSERT INTO identities (
  type, data
) VALUES ( /* C=CH, O=Linux strongSwan, CN=strongSwan Root CA */
  9, X'3045310B300906035504061302434831193017060355040A13104C696E7578207374726F6E675377616E311B3019060355040313127374726F6E675377616E20526F6F74204341'
 );

INSERT INTO identities (
  type, data
) VALUES ( /* subjkey of 'C=CH, O=Linux strongSwan, CN=strongSwan Root CA' */
  11, X'5da7dd700651327ee7b66db3b5e5e060ea2e4def'
 );

INSERT INTO identities (
  type, data
) VALUES ( /* keyid of 'C=CH, O=Linux strongSwan, CN=strongSwan Root CA' */
  11, X'ae096b87b44886d3b820978623dabd0eae22ebbc'
 );

INSERT INTO identities (
  type, data
) VALUES ( /* moon.strongswan.org */
  2, X'6d6f6f6e2e7374726f6e677377616e2e6f7267'
 );

INSERT INTO identities (
  type, data
) VALUES ( /* sun.strongswan.org */
  2, X'73756e2e7374726f6e677377616e2e6f7267'
 );

INSERT INTO identities (
  type, data
) VALUES ( /* subjkey of 'C=CH, O=Linux strongSwan, CN=moon.strongswan.org' */
  11, X'd8263d21ec7cdbbe5a390c5b70cb038021deae13'
 );

/* Certificates */

INSERT INTO certificates (
   type, keytype, data
) VALUES ( /* C=CH, O=Linux strongSwan, CN=strongSwan Root CA */
  1, 1, X'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'
);

INSERT INTO certificates (
   type, keytype, data
) VALUES ( /* C=CH, O=Linux strongSwan, CN=moon.strongswan.org */
  1, 1, X'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'
);

INSERT INTO certificate_identity (
  certificate, identity
) VALUES (
  1, 1
);

INSERT INTO certificate_identity (
  certificate, identity
) VALUES (
  1, 2
);

INSERT INTO certificate_identity (
  certificate, identity
) VALUES (
  1, 3
);

INSERT INTO certificate_identity (
  certificate, identity
) VALUES (
  2, 4 
);

INSERT INTO certificate_identity (
  certificate, identity
) VALUES (
  2, 6 
);

/* Private Keys */

INSERT INTO private_keys (
   type, data
) VALUES ( /* key of 'C=CH, O=Linux strongSwan, CN=moon.strongswan.org' */
  1, X'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'
);

INSERT INTO private_key_identity (
  private_key, identity
) VALUES (
  1, 4 
);

INSERT INTO private_key_identity (
  private_key, identity
) VALUES (
  1, 6 
);

/* Proposals */

INSERT INTO proposals (
  proposal
) VALUES (
  'aes128-aes192-aes256-sha256-sha384-sha512-modp3072-modp4096-modp8192'
);

/* Configurations */

INSERT INTO ike_configs (
  local, remote
) VALUES (
  'PH_IP_MOON', 'PH_IP_SUN'
);

INSERT INTO ike_config_proposal (
  ike_cfg, prio, prop
) VALUES (
  1, 1, 1
);

INSERT INTO peer_configs (
  name, ike_cfg, local_id, remote_id, mobike, dpd_delay
) VALUES (
  'net-net', 1, 4, 5, 0, 30
);

INSERT INTO child_configs (
  name, updown, start_action, dpd_action
) VALUES (
  'net-1', '/usr/local/libexec/ipsec/_updown iptables', 1, 1
);

INSERT INTO child_configs (
  name, updown, start_action, dpd_action
) VALUES (
  'net-2', '/usr/local/libexec/ipsec/_updown iptables', 1, 1
);

INSERT INTO child_configs (
  name, updown, start_action, dpd_action
) VALUES (
  'net-3', '/usr/local/libexec/ipsec/_updown iptables', 0, 0
);

INSERT INTO peer_config_child_config (
  peer_cfg, child_cfg
) VALUES (
  1, 1
);

INSERT INTO peer_config_child_config (
  peer_cfg, child_cfg
) VALUES (
  1, 2
);

INSERT INTO peer_config_child_config (
  peer_cfg, child_cfg
) VALUES (
  1, 3
);

INSERT INTO child_config_proposal (
  child_cfg, prio, prop
) VALUES (
  1, 1, 1
);

INSERT INTO child_config_proposal (
  child_cfg, prio, prop
) VALUES (
  2, 1, 1
);

INSERT INTO child_config_proposal (
  child_cfg, prio, prop
) VALUES (
  3, 1, 1
);

INSERT INTO traffic_selectors (
  type, start_addr, end_addr
) VALUES (
  7, X'0a010000', X'0a01000f'
);

INSERT INTO traffic_selectors (
  type, start_addr, end_addr
) VALUES (
  7, X'0a010010', X'0a01001f'
);

INSERT INTO traffic_selectors (
  type, start_addr, end_addr
) VALUES (
  7, X'0a010200', X'0a0103ff'
);

INSERT INTO traffic_selectors (
  type, start_addr, end_addr
) VALUES (
  7, X'0a020000', X'0a0201ff'
);

INSERT INTO traffic_selectors (
  type, start_addr, end_addr
) VALUES (
  7, X'0a020200', X'0a0203ff'
);

INSERT INTO child_config_traffic_selector (
  child_cfg, traffic_selector, kind
) VALUES (
  1, 1, 0
);

INSERT INTO child_config_traffic_selector (
	child_cfg, traffic_selector, kind
) VALUES (
  1, 4, 1
);

INSERT INTO child_config_traffic_selector (
  child_cfg, traffic_selector, kind
) VALUES (
  2, 2, 0
);

INSERT INTO child_config_traffic_selector (
	child_cfg, traffic_selector, kind
) VALUES (
  2, 4, 1
);

INSERT INTO child_config_traffic_selector (
  child_cfg, traffic_selector, kind
) VALUES (
  3, 3, 0
);

INSERT INTO child_config_traffic_selector (
	child_cfg, traffic_selector, kind
) VALUES (
  3, 5, 1
);
