//---------------------------------------------------------------------------
#include <vcl.h>
#pragma hdrstop
#include "SplashPage.h"
#include <winreg.h>
#include <dir.h>
#include "sword.h"

USERES("sword.res");
USEFORM("mainfrm.cpp", Form1);
USEFORM("AboutBoxfrm.cpp", AboutBox);
USEFORM("bookmarkfrm.cpp", Bookmarksfrm);
USEFORM("newbmfilefrm.cpp", NewBMfrm);
USEFORM("optionfrm.cpp", Optionsfrm);
USEFORM("searchfrm.cpp", Form2);
USEUNIT("biblecsmgr.cpp");
USEFORM("ModInstForm.cpp", ModInstFrm);
USEFORM("vrslstfrm.cpp", VerseListFrm);
USEFORM("editentryfrm.cpp", EditEntry);
USEFORM("versesel.cpp", VerseSelFrm);
USELIB("swordlib.lib");
USEFORM("RangeMaintFrm.cpp", RangeMaintForm);
USEFORM("ModVisFrm.cpp", ModVisForm);
USEUNIT("..\..\swdisprtfchap.cpp");
USEUNIT("..\..\swdisprtf.cpp");
USEOBJ("rxlib\RxRichEd.obj");
USEOBJ("rxlib\Maxmin.obj");
USEFORM("DevOfTheDay.cpp", DevOfTheDay2);
USEFORM("SplashPage.cpp", SplashPg);
USEFORM("FontSel.cpp", FontSelFrm);
USEOBJ("rxlib\Rxcombos.obj");
USEOBJ("rxlib\Vclutils.obj");
USEOBJ("rxlib\Rxcconst.obj");
USEOBJ("rxlib\Rxconst.obj");
//---------------------------------------------------------------------------
USEFORM("StudyProfessor.cpp", Form3);
USELIB("..\..\..\..\..\icu-sword\as_is\borland\icucommon.lib");
USELIB("..\..\..\..\..\icu-sword\as_is\borland\icudatab.lib");
USELIB("..\..\..\..\..\icu-sword\as_is\borland\icui18n.lib");
//---------------------------------------------------------------------------
WINAPI WinMain(HINSTANCE hInstance, HINSTANCE hPrevInstance, LPSTR lpCmdLine, int nCmdShow) {

        LONG result;

        result = Application->ExeName.Length();
        char * dir = new char[result + 1];
        strcpy (dir, Application->ExeName.c_str());
        for (;result > 0 && dir[result] != '\\'; result--) {
                dir[result] = 0;
        }
        chdir(dir);
        delete [] dir;

        try {
                HKEY hkey;
                HWND otherInst;

                // see if there's a previous instance running
                otherInst = ::FindWindow(NULL, "The SWORD Project for Windows");
                // if so, and we have an argument, send the argument to the other instance
                if (otherInst && *lpCmdLine) {
                        result = RegCreateKeyEx(HKEY_CLASSES_ROOT, "sword\\OpenVerse", NULL, "", NULL, KEY_READ | KEY_WRITE, NULL, &hkey, NULL);
                        result = RegSetValueEx(hkey, NULL, 0, REG_SZ, lpCmdLine, strlen(lpCmdLine) + 1);
                        result = RegCloseKey(hkey);

                        PostMessage(otherInst, WM_VERSE, NULL, NULL);
                        return 0;
                }

                // adjust the registry for our private protocol using the current path
                result = RegCreateKeyEx(HKEY_CLASSES_ROOT, "sword", NULL, "", NULL, KEY_READ | KEY_WRITE, NULL, &hkey, NULL);
                result = RegSetValueEx(hkey, NULL, 0, REG_SZ, "URL:SWORD Protocol", strlen("URL:SWORD Protocol") + 1);
                result = RegSetValueEx(hkey, "URL Protocol", 0, REG_SZ, "", 1);
                result = RegCloseKey(hkey);
                result = RegCreateKeyEx(HKEY_CLASSES_ROOT, "sword\\DefaultIcon", NULL, "", NULL, KEY_READ | KEY_WRITE, NULL, &hkey, NULL);
                result = RegSetValueEx(hkey, NULL, 0, REG_SZ, Application->ExeName.c_str(), Application->ExeName.Length() + 1);
                result = RegCloseKey(hkey);
                AnsiString opencommand = Application->ExeName + " \"%1\"";
                result = RegCreateKeyEx(HKEY_CLASSES_ROOT, "sword\\shell\\open\\command", NULL, "", NULL, KEY_READ | KEY_WRITE, NULL, &hkey, NULL);
                result = RegSetValueEx(hkey, NULL, 0, REG_SZ, opencommand.c_str(), opencommand.Length() + 1);
                result = RegCloseKey(hkey);

                // don't override Logos' setting if it exists
                result = RegOpenKeyEx(HKEY_CLASSES_ROOT, "libronixdls", 0, KEY_READ | KEY_WRITE, &hkey);
                if (!result) {
                        char* libStr = new char[32];
                        unsigned long libSize = 32;
                        result = RegQueryValueEx(hkey, NULL, NULL, NULL, libStr, &libSize);
                        if (!result) {
                                if (strstr(libStr, "SWORD")) {
                                        result = 1;
                                }
                        }
                }
                if (result) {
                        result = RegCreateKeyEx(HKEY_CLASSES_ROOT, "libronixdls", NULL, "", NULL, KEY_READ | KEY_WRITE, NULL, &hkey, NULL);
                        result = RegSetValueEx(hkey, NULL, 0, REG_SZ, "URL:SWORD Protocol", strlen("URL:SWORD Protocol") + 1);
                        result = RegSetValueEx(hkey, "URL Protocol", 0, REG_SZ, "", 1);
                        result = RegCloseKey(hkey);
                        result = RegCreateKeyEx(HKEY_CLASSES_ROOT, "libronixdls\\DefaultIcon", NULL, "", NULL, KEY_READ | KEY_WRITE, NULL, &hkey, NULL);
                        result = RegSetValueEx(hkey, NULL, 0, REG_SZ, Application->ExeName.c_str(), Application->ExeName.Length() + 1);
                        result = RegCloseKey(hkey);
                        AnsiString opencommand = Application->ExeName + " \"%1\"";
                        result = RegCreateKeyEx(HKEY_CLASSES_ROOT, "libronixdls\\shell\\open\\command", NULL, "", NULL, KEY_READ | KEY_WRITE, NULL, &hkey, NULL);
                        result = RegSetValueEx(hkey, NULL, 0, REG_SZ, opencommand.c_str(), opencommand.Length() + 1);
                        result = RegCloseKey(hkey);
                }
        }

	catch (Exception &exception) {
		Application->ShowException(&exception);
	}

	try {
		Application->Initialize();
		Application->Title = "The SWORD Project";
		SplashPg = new TSplashPg(static_cast<void*>(NULL));
		SplashPg->Show();
		Application->ProcessMessages();
		Application->CreateForm(__classid(TForm1), &Form1);


		 if (*lpCmdLine)
			    Application->MainForm->Tag = (int)lpCmdLine;
		Application->CreateForm(__classid(TAboutBox), &AboutBox);
		Application->CreateForm(__classid(TBookmarksfrm), &Bookmarksfrm);
		Application->CreateForm(__classid(TNewBMfrm), &NewBMfrm);
		Application->CreateForm(__classid(TOptionsfrm), &Optionsfrm);
		Application->CreateForm(__classid(TForm2), &Form2);
		Application->CreateForm(__classid(TModInstFrm), &ModInstFrm);
		Application->CreateForm(__classid(TVerseListFrm), &VerseListFrm);
		Application->CreateForm(__classid(TEditEntry), &EditEntry);
		Application->CreateForm(__classid(TVerseSelFrm), &VerseSelFrm);
		Application->CreateForm(__classid(TRangeMaintForm), &RangeMaintForm);
		Application->CreateForm(__classid(TModVisForm), &ModVisForm);
		Application->CreateForm(__classid(TDevOfTheDay2), &DevOfTheDay2);
		Application->CreateForm(__classid(TForm3), &Form3);
		Application->Run();
		delete SplashPg;
	}
	catch (Exception &exception) {
		Application->ShowException(&exception);
	}
	return 0;
}
//---------------------------------------------------------------------------
