//---------------------------------------------------------------------------
#include <vcl.h>
#pragma hdrstop

#include "StatusFrm.h"
#include "MainFrm.h"
//---------------------------------------------------------------------------
#pragma package(smart_init)
#pragma link "IdBaseComponent"
#pragma link "IdComponent"
#pragma link "IdFTP"
#pragma link "IdTCPClient"
#pragma link "IdTCPConnection"
#pragma resource "*.dfm"
TStatusForm *StatusForm;
//---------------------------------------------------------------------------
__fastcall TStatusForm::TStatusForm(TComponent* Owner)
		: TForm(Owner) {
	suffix = "";
	passive = false;
}
//---------------------------------------------------------------------------
void __fastcall TStatusForm::FormShow(TObject *Sender)
{
	abort = false;
	ftpThread = new TFTPThread(ist, src.c_str(), dest.c_str(), dirTransfer, passive, true, suffix.c_str());
	ftpThread->OnTerminate = Cleanup;
	ftpThread->Resume();
}
//---------------------------------------------------------------------------
__fastcall TStatusForm::TFTPThread::TFTPThread(InstallSourceTab *iist, const char *isrc, const char *idest, bool idirTransfer, bool CreateSuspended, bool ipassive, const char *isuffix)
	: TThread(CreateSuspended)
{
	ist = iist;
	src = isrc;
	dest = idest;
	suffix = isuffix;
	dirTransfer = idirTransfer;
	Priority = tpNormal;
	passive = ipassive;
	FreeOnTerminate = true;
	Synchronize((TThreadMethod)&CreateFTPObject);
}

__fastcall TStatusForm::TFTPThread::~TFTPThread()
{
}


void __fastcall TStatusForm::TFTPThread::Execute()
{
	Synchronize((TThreadMethod)&PreConnect);
	StatusForm->ftpCon->Host = ist->Source.c_str();
	StatusForm->ftpCon->Username = "ftp";
	StatusForm->ftpCon->Password = "installmgr@user.com";
	StatusForm->ftpCon->Passive = passive;
	
	try {
		StatusForm->ftpCon->Connect(true, -1);
		StatusForm->ftpCon->TransferType = ftBinary;
		StatusForm->ftpCon->ChangeDir(ist->Directory.c_str());
	}
	catch(...) {
		MessageBox(0, "Can't connect.  Please check your configuration.", "Connection Error", MB_OK);
		StatusForm->Button1Click(0);	// abort thread
	}
	
	if (!Terminated) {
		if (dirTransfer) {
			StatusForm->ftpCon->ChangeDir(src.c_str());
               TStringList *dirText = new TStringList();
               StatusForm->ftpCon->List(dirText, "*", true);
               TIdFTPListItems *dirList = StatusForm->ftpCon->DirectoryListing;
			for (int i = 0; i < dirList->Count; i++) {
				if (dirList->Items[i]->ItemType != ditDirectory) {
					buffer = dest + "/" + (dirList->Items[i]->FileName.c_str() /*+ 55*/);
//                           files->Strings[i].c_str();
					if (!strcmp(&buffer.c_str()[buffer.length()-suffix.length()], suffix.c_str())) {
						buffer2 = "Downloading (";
						buffer2 += IntToStr(i+1).c_str();
						buffer2 += " of ";
						buffer2 += IntToStr(dirList->Count).c_str();
						buffer2 += "): ";
						buffer2 += (dirList->Items[i]->FileName.c_str() /*+ 55*/);
		//				SWLog::systemlog->LogInformation("%s", buffer.c_str());
						TMainForm::createParent(buffer.c_str());	// make sure parent directory exists
						Synchronize((TThreadMethod)&PreDownload1);
						try {
							StatusForm->currentFileSize = dirList->Items[i]->Size;
							StatusForm->ftpCon->Get(dirList->Items[i]->FileName.c_str() /* + 55*/, buffer.c_str(), true, false);
						}
						catch(...) {
							MessageBox(0, "Can't download file.  If you have not done so recently, you might try pressing the Refresh from Remote Source button.", "Download Error", MB_OK);
							StatusForm->Button1Click(0);	// abort thread
						}
						if (Terminated)
							break;
					}
				}
			}
		}
		else {
			Synchronize((TThreadMethod)&PreDownload2);
               try {
				StatusForm->ftpCon->Get(src.c_str(), dest.c_str(), true, false);
			}
			catch(...) {StatusForm->abort = true;}
		}
		try {
			StatusForm->ftpCon->Disconnect();
		}
		catch(...){}
	}
}


void __fastcall TStatusForm::TFTPThread::FTPLinkPacketRecvd(TObject *Sender)
{
//	Synchronize((TThreadMethod)&UpdateBytes);
}


//void __fastcall TStatusForm::TFTPThread::UpdateBytes(void) {
void __fastcall TStatusForm::UpdateBytes(void) {
	StatusForm->statusBar->Caption = IntToStr(StatusForm->currentByteCount) + " bytes out of " + IntToStr(StatusForm->currentFileSize) + " transferred (" + IntToStr((int)((float)(StatusForm->currentByteCount + 1) / (float)(StatusForm->currentFileSize + 1) * 100)) + "%)";
	StatusForm->statusBar->Repaint();
}


void __fastcall TStatusForm::TFTPThread::CreateFTPObject(void)
{
//	FTPLink = new TNMFTP(0);
}


void __fastcall TStatusForm::TFTPThread::PreConnect(void)
{
	buffer = "Connecting to server at ";
	buffer += ist->Source.c_str();
	buffer += "...";
	StatusForm->actionBar->Caption = buffer.c_str();
	StatusForm->statusBar->Caption = "";
	StatusForm->Repaint();
}


void __fastcall TStatusForm::TFTPThread::PreDownload1(void)
{
//	SWLog::systemlog->LogInformation("Creating parent dir: %s", buffer.c_str());
//	SWLog::systemlog->LogInformation("Return: %d", ret);
	StatusForm->actionBar->Caption = buffer2.c_str();
	StatusForm->statusBar->Caption = "";
	StatusForm->Repaint();
}


void __fastcall TStatusForm::TFTPThread::PreDownload2(void)
{
	buffer = "Downloading: ";
	buffer += src.c_str();
	StatusForm->actionBar->Caption = buffer.c_str();
	StatusForm->statusBar->Caption = "";
	StatusForm->Repaint();
	MainForm->createParent(dest.c_str());	// make sure parent directory exists
}


void __fastcall TStatusForm::Cleanup(TObject *Sender)
//void __fastcall TStatusForm::TFTPThread::Cleanup()
{
	if (abort)
		StatusForm->ModalResult = mrCancel;
	else	StatusForm->ModalResult = mrOk;
//	StatusForm->Close();
}

void __fastcall TStatusForm::FormClose(TObject *Sender, TCloseAction &Action)
{
	suffix = "";
	MainForm->SetFocus();
}
//---------------------------------------------------------------------------

void __fastcall TStatusForm::Button1Click(TObject *Sender)
{
	abort = true;
	ftpCon->Abort();
	ftpThread->Terminate();
}
//---------------------------------------------------------------------------


void __fastcall TStatusForm::ftpConWork(TObject *Sender,
	 TWorkMode AWorkMode, const int AWorkCount)
{
	currentByteCount = AWorkCount;
//	Synchronize((TThreadMethod)&UpdateBytes);
	UpdateBytes();
}
//---------------------------------------------------------------------------

