//---------------------------------------------------------------------------
#include <vcl.h>
#pragma hdrstop

#include "AppBar.h"
#include "DockCanvas.h"
#include "ModTabPanel.h"
#include "biblecsmgr.h"
#include "BookMarkPanel.h"
#include "DeskTopNameForm.h"
#include <versekey.h>
#include "vrslstfrm.h"
//---------------------------------------------------------------------------
#pragma package(smart_init)
//#pragma link "MenuBar"
#pragma resource "*.dfm"
TAppBarFrm *AppBarFrm;
//---------------------------------------------------------------------------
__fastcall TAppBarFrm::TAppBarFrm(TComponent* Owner)
	: TForm(Owner)
{
}
//---------------------------------------------------------------------------

void __fastcall TAppBarFrm::FormCreate(TObject *Sender)
{
	ImageList1->Add(BackBtnImage->Picture->Bitmap, NULL);
	ImageList1->Add(SearchBtnImage->Picture->Bitmap, NULL);
	mainmgr = new BibleCSMGR(ModInstFrm);
     commonVK = new VerseKey();
     commonVK->Persist(true);
     commonSK = new SWKey();
     commonSK->Persist(true);
     *commonVK = "Jas 1:19";
     fillVKeySelector(commonVK);
     ModMap::iterator it;
     SWKey *tryKey;
     for (it = mainmgr->Modules.begin(); it != mainmgr->Modules.end(); it++) {
     	tryKey = it->second->CreateKey();
          const SWClass *keyClass = tryKey->getClass();
          bool yes = (keyClass->isAssignableFrom("VerseKey"));
          SWKey *vkey = (yes) ? commonVK:commonSK;
          it->second->SetKey(vkey);
          delete tryKey;
     }
	activeDesktop = 0;
     TextKeyChanged();
}
//---------------------------------------------------------------------------
void __fastcall TAppBarFrm::SpeedButton2Click(TObject *Sender)
{
	if (activeDesktop) {
		TModTabPanel *textTabs = new TModTabPanel(activeDesktop, mainmgr, "Biblical Texts");
		textTabs->ManualDock(activeDesktop, NULL, alLeft);
	}
}
//---------------------------------------------------------------------------
void __fastcall TAppBarFrm::SpeedButton5Click(TObject *Sender)
{
	if (activeDesktop) {
		TBookMarkPanel *bookmarks = new TBookMarkPanel(activeDesktop);
		bookmarks->ManualDock(activeDesktop, NULL, alLeft);
	}
}
//---------------------------------------------------------------------------

void __fastcall TAppBarFrm::SpeedButton3Click(TObject *Sender)
{
	if (activeDesktop) {
		TModTabPanel *textTabs = new TModTabPanel(activeDesktop, mainmgr, "Commentaries");
		textTabs->ManualDock(activeDesktop, NULL, alLeft);
	}
}
//---------------------------------------------------------------------------

void __fastcall TAppBarFrm::SpeedButton4Click(TObject *Sender)
{
	if (activeDesktop) {
		TModTabPanel *textTabs = new TModTabPanel(activeDesktop, mainmgr, "Lexicons / Dictionaries");
		textTabs->ManualDock(activeDesktop, NULL, alLeft);
	}
}
//---------------------------------------------------------------------------

void __fastcall TAppBarFrm::TabControl1Change(TObject *Sender)
{
	int index = TabControl1->TabIndex;
	if (index > -1) {
		activeDesktop = ((TForm *)(TabControl1->Tabs->Objects[index]));
		activeDesktop->Show();
	}
	else activeDesktop = 0;
}
//---------------------------------------------------------------------------

void __fastcall TAppBarFrm::SpeedButton1Click(TObject *Sender)
{
	DeskTopNameFrm->ShowModal();
	activeDesktop = new TDockCanvasFrm(this);
	activeDesktop->OnClose = FormClose;
	activeDesktop->OnActivate = FormActivate;
	activeDesktop->Caption = DeskTopNameFrm->desktopName->Text;
	TabControl1->Tabs->AddObject(activeDesktop->Caption, activeDesktop);
	if (activeDesktop->Top < (this->Top + this->Height))
		activeDesktop->Top = this->Top + this->Height + 1;
	activeDesktop->Show();
}
//---------------------------------------------------------------------------

void __fastcall TAppBarFrm::FormClose(TObject *Sender,
	 TCloseAction &Action)
{
	int index = TabControl1->Tabs->IndexOfObject(Sender);
	TabControl1->Tabs->Delete(index);
	TabControl1->TabIndex = 0;
	TabControl1Change(Sender);
}
//---------------------------------------------------------------------------

void __fastcall TAppBarFrm::FormActivate(TObject *Sender)
{
	int index = TabControl1->Tabs->IndexOfObject(Sender);
	TabControl1->TabIndex = index;
	TabControl1Change(Sender);
}
//---------------------------------------------------------------------------

void TAppBarFrm::fillVKeySelector(VerseKey *vk) {
	VerseKey *myVk = (VerseKey *)vk->clone();
	myVk->Error();	//clear error
	(*myVk) = TOP;
	cbBook->Clear();
	while (!myVk->Error()) {
		AnsiString s1 = (const char *)(*myVk);
		s1.SetLength(s1.Length() - 4);
		cbBook->Items->Add(s1);
		myVk->Book(myVk->Book() + 1);
	}
	delete myVk;
}


void __fastcall TAppBarFrm::FormDestroy(TObject *Sender)
{
	delete commonVK;
     delete commonSK;	
}
void TAppBarFrm::RefreshActiveSheet(TPageControl *pc)
{
	ModMap::iterator it;
	if (mainmgr) {
          it = mainmgr->Modules.find(pc->ActivePage->Caption.c_str());
          if (it != mainmgr->Modules.end()) {
               (*it).second->Display();
//               if (logmodstate)
//                    modstates.insert(modstates.begin(), new ModState(pc, pc->ActivePage, (*it).second->KeyText()));
          }
	}
}
//---------------------------------------------------------------------------
void TAppBarFrm::TextKeyChanged()
{
	cbBook->ItemIndex = cbBook->Items->IndexOf(commonVK->books[commonVK->Testament()-1][commonVK->Book()-1].name);
	CHBox->Text  = commonVK->Chapter();
	VSBox->Text  = commonVK->Verse();
	freeHandLookup->Text = (const char *)*commonVK;

     if (activeDesktop) {
          for (int i = 0; i < activeDesktop->DockClientCount; i++) {
               TPanel *panel = dynamic_cast<TPanel *>(activeDesktop->DockClients[i]);
               if (panel) {
                    TPageControl *pc = dynamic_cast<TPageControl *>(panel->Controls[0]);
                    if (pc)
                         RefreshActiveSheet(pc);
               }
          }
	}

//	RefreshActiveSheet(PageControl1);
//	logmodstate = false;		// only log state once
//	RefreshActiveSheet(PageControl2);
//	logmodstate = true;
}
void __fastcall TAppBarFrm::btnLookupClick(TObject *Sender)
{
	if (!(StrToInt(CHBox->Text)) || (!StrToInt(VSBox->Text)))
		commonVK->AutoNormalize(0);

	if (StrToInt(CHBox->Text) < 0)
		CHBox->Text = StrToInt(CHBox->Text) + 1;
	if (StrToInt(VSBox->Text) < 0)
		VSBox->Text = StrToInt(VSBox->Text) + 1;

	*commonVK       = (cbBook->Text + " " + CHBox->Text + ":" + VSBox->Text).c_str();
	TextKeyChanged();
	commonVK->AutoNormalize(1);	
}

void __fastcall TAppBarFrm::UpDown1Click(TObject *Sender,
      TUDBtnType Button)
{
	btnLookupClick(Sender);	
}
//---------------------------------------------------------------------------

void __fastcall TAppBarFrm::freeHandLookupKeyPress(TObject *Sender,
      char &Key)
{
	if (Key == '\r') {
		ListKey tmpVerseList = commonVK->ParseVerseList(freeHandLookup->Text.c_str(), *commonVK);

		if (tmpVerseList.Count()) {
			int index = freeHandLookup->Items->IndexOf(freeHandLookup->Text);
			freeHandLookup->Items->Insert(0, freeHandLookup->Text);

			if (index >= 0)
				freeHandLookup->Items->Delete(index+1);
		
			freeHandLookup->ItemIndex = 0;

			if (tmpVerseList.Count() > 1) {
				TVerseListFrm *tmpForm = new TVerseListFrm(this, tmpVerseList);
				tmpForm->Caption = "User Verse List";
				tmpForm->Show();
			}

			tmpVerseList = TOP;
			*commonVK = tmpVerseList;
			TextKeyChanged();
		}
	}
}
//---------------------------------------------------------------------------

