/******************************************************************************
 *  tbdisp.cpp  - code for class 'tbdisp'.  tbdisp writes module output to a
 *				MSWindows TextBox (or any other control that takes a
 *				SetDialogItemText
 */

#include <swmodule.h>
#include <tbdisp.h>
#include <windows.h>
#include <string.h>


/******************************************************************************
 * TBDisp Constructor - sets up an instance of TBDisp for use
 *
 * ENT:	iwnd		- window id on which control resides
 *		ictrlid	- control id in which to display module text
 */

TBDisp::TBDisp(HWND iwnd, int ictrlid)
{
	wnd    = iwnd;
	ctrlid = ictrlid;
}


/******************************************************************************
 * SWDisplay::Display - casts a module to a character pointer and displays it in
 *					an MSWindows control
 *
 * ENT:	imodule - module to display
 *
 * RET:	error status
 */

char TBDisp::Display(SWModule &imodule)
{
	char *buf, *to;
	const char *mtext;

	mtext = (const char *)imodule;

	buf = new char [ strlen(mtext) + 100 ];

	for (to = buf; *mtext; mtext++) {
		if (*mtext == '\n')
			*to++ = '\r';
		*to++ = *mtext;
	}
	*to = 0;

	SetDlgItemText(wnd, ctrlid, buf);
     delete [] buf;
	return 0;
}
