/* 
 * frame support
 */

enum {
    F_UNLOADED,
    F_LOADING,
    F_ERROR,
    F_BODY,
    F_FRAMESET,
};

struct frame_element {
    char attr;
    char dummy;
    char *name;
};

struct frame_body {
    char attr;
    char flags;
#define	FB_NOCACHE	0x01
#define	FB_TODELETE	0x02
#define	FB_NO_BUFFER	0x04
    char *name;
    char *url;
    ParsedURL *baseURL;
    char *source;
    char *type;
    char *referer;
#if LANG == MANY
    const char *charset;
#endif
    struct _anchorList *nameList;
    FormList *request;
#ifdef USE_SSL
    char *ssl_certificate;
#endif
};

union frameset_element {
    struct frame_element *element;
    struct frame_body *body;
    struct frameset *set;
};

struct frameset {
    char attr;
    char dummy;
    char *name;
    ParsedURL *currentURL;
    char **width;
    char **height;
    int col;
    int row;
    int i;
    int nunloaded;
    union frameset_element *frame;
};

struct frameset_queue {
    struct frameset_queue *next;
    struct frameset_queue *back;
    struct frameset *frameset;
    struct _Buffer *savebuf;
};

/* Local Variables:    */
/* c-basic-offset: 4   */
/* tab-width: 8        */
/* End:                */
