#!/usr/local/bin/perl
# send_mail.cgi
# Send off an email message

require './sendmail-lib.pl';
require './boxes-lib.pl';

# Check inputs
&ReadParseMime();
&can_read_mail($in{'user'}) || &error($text{'send_ecannot'});
&error_setup($text{'send_err'});
$in{'to'} || &error($text{'send_eto'});
if ($access{'fmode'} == 0) {
	$in{'from'} || &error($text{'send_efrom'});
	}
elsif ($access{'fmode'} == 1) {
	foreach $f (split(/\s+/, $access{'from'})) {
		$found++ if ("$in{'user'}\@$f" eq $in{'from'} ||
			     "$in{'ouser'}\@$f" eq $in{'from'});
		}
	&error($text{'send_efrom'}) if (!$found);
	}
elsif ($access{'fmode'} == 2) {
	foreach $f (split(/\s+/, $access{'from'})) {
		$found++ if ($f eq $in{'from'});
		}
	&error($text{'send_efrom'}) if (!$found);
	}
elsif ($access{'fmode'} == 3) {
	$in{'from'} .= "\@$access{'from'}";
	}
if ($in{'from'} =~ /^(\S+)\@(\S+)$/ && $access{'fromname'}) {
	$in{'from'} = "$access{'fromname'} <$in{'from'}>";
	}

# Construct the email
$mail->{'headers'} = [ [ 'From', $in{'from'} ],
		       [ 'Subject', $in{'subject'} ],
		       [ 'To', $in{'to'} ],
		       [ 'Cc', $in{'cc'} ],
		       [ 'Bcc', $in{'bcc'} ],
		       [ 'X-Originating-IP', $ENV{'REMOTE_ADDR'} ],
		       [ 'X-Mailer', "Webmin ".&get_webmin_version() ] ];
push(@{$mail->{'headers'}}, [ 'X-Priority', $in{'pri'} ]) if ($in{'pri'});
$in{'body'} =~ s/\r//g;
if ($in{'body'} =~ /\S/) {
	@attach = ( { 'headers' => [ [ 'Content-Type', 'text/plain' ],
				     [ 'Content-Transfer-Encoding', '7bit' ] ],
		      'data' => $in{'body'} } );
	}
foreach $i (0 .. 5) {
	# Add uploaded attachment
	next if (!$in{"attach$i"});
	local $filename = $in{"attach${i}_filename"};
	$filename =~ s/^.*(\\|\/)//;
	local $type = $in{"attach${i}_content_type"}."; name=\"".
		      $filenam3."\"";
	local $disp = "inline; filename=\"".$filename."\"";
	push(@attach, { 'data' => $in{"attach${i}"},
			'headers' => [ [ 'Content-type', $type ],
				       [ 'Content-Disposition', $disp ],
				       [ 'Content-Transfer-Encoding',
					 'base64' ] ] });
	$atotal += length($in{"attach${i}"});
	}
foreach $i (0 .. 2) {
	# Add server-side attachment
	next if (!$in{"file$i"} || !$access{'canattach'});
	-r $in{"file$i"} || &error(&text('send_efile', $in{"file$i"}));
	if ($in{'user'} ne 'root') {
		# Is this mailbox user allowed to read the attachment?
		pipe(CHr, CHw);
		if (!fork()) {
			close(CHr);
			@u = getpwnam($in{'user'});
			$( = $u[3]; $) = "$u[3] $u[3]";
			($>, $<) = ($u[2], $u[2]);
			if (!open(TEST, $in{"file$i"})) {
				print CHw "$!\n";
				}
			exit;
			}
		close(CHw);
		chop($resp = <CHr>);
		close(CHr);
		$resp && &error(&text('send_eperms',
				      $in{'user'}, $in{"file$i"}));
		%gaccess = &get_module_acl(undef, "");
		substr($in{"file$i"}, 0, length($gaccess{'root'})) eq
			$gaccess{'root'} || &error(&text('send_eperms2',
						   	 $in{"file$i"}));
		}
	local $data;
	open(DATA, $in{"file$i"}) || &error(&text('send_efile', $in{"file$i"}));
	while(<DATA>) {
		$data .= $_;
		}
	close(DATA);
	$in{"file$i"} =~ s/^.*\///;
	local $type = &guess_type($in{"file$i"})."; name=\"".$in{"file$i"}."\"";
	local $disp = "inline; filename=\"".$in{"file$i"}."\"";
	push(@attach, { 'data' => $data,
			'headers' => [ [ 'Content-type', $type ],
				       [ 'Content-Disposition', $disp ],
				       [ 'Content-Transfer-Encoding',
					 'base64' ] ] });
	$atotal += length($data);
	}
@fwd = split(/\0/, $in{'forward'});
if (@fwd) {
	# Add forwarded attachments
	@mail = &list_mails($in{'user'}, $in{'idx'}, $in{'idx'});
	$fwdmail = $mail[$in{'idx'}];
	&parse_mail($fwdmail);
	foreach $f (@fwd) {
		push(@attach, $fwdmail->{'attach'}->[$f]);
		$atotal += length($fwdmail->{'attach'}->[$f]->{'data'});
		}
	}
@mailfwd = split(/\0/, $in{'mailforward'});
if (@mailfwd) {
	# Add forwarded emails
	@mail = &list_mails($in{'user'}, $mailfwd[0], $mailfwd[@mailfwd-1]);
	foreach $f (@mailfwd) {
		$fwdmail = $mail[$f];
		local $headertext;
		foreach $h (@{$fwdmail->{'headers'}}) {
			$headertext .= $h->[0].": ".$h->[1]."\n";
			}
		push(@attach, { 'data' => $headertext."\n".$fwdmail->{'body'},
				'headers' => [ [ 'Content-type', 'message/rfc822' ],
					       [ 'Content-Description',
						  $fwdmail->{'header'}->{'subject'} ] ]
			      });
		}
	}
$mail->{'attach'} = \@attach;
if ($access{'attach'} >= 0 && $atotal > $access{'attach'}*1024) {
	&error(&text('send_eattach', $access{'attach'}));
	}

# Send it off
&send_mail($mail);
if ($access{'sent'}) {
	# Save a copy in the sent mailbox
	local $sfile = &user_mail_file($access{'sent'});
	&send_mail($mail, $sfile);
	&system_logged("chown $access{'sent'} $sfile 2>/dev/null");
	}
&webmin_log("send", undef, undef, { 'from' => $in{'from'}, 'to' => $in{'to'} });
&header($text{'send_title'}, "");
print "<hr>\n";

print "<p>",&text('send_ok', "<tt>".&html_escape($in{'to'})."</tt>"),"<p>\n";
print "<hr>\n";
local $nb = $access{'mmode'} == 2 && $access{'musers'} =~ /^\S+$/ ||
	    $access{'mmode'} == 4;
if ($in{'idx'} ne '') {
	&footer("view_mail.cgi?user=$in{'user'}&idx=$in{'idx'}",
		$text{'view_return'},
		"list_mail.cgi?user=$in{'user'}", $text{'mail_return'},
		$nb ? ( ) : ( "list_boxes.cgi", $text{'boxes_return'} ),
		"", $text{'index_return'});
	}
else {
	&footer("list_mail.cgi?user=$in{'user'}", $text{'mail_return'},
		$nb ? ( ) : ( "list_boxes.cgi", $text{'boxes_return'} ),
		"", $text{'index_return'});
	}

