#!/usr/local/bin/perl
# index.cgi
# Display sshd option categories

require './sshd-lib.pl';
&header($text{'index_title'}, "", "intro", 1, 1);
print "<hr>\n";

# Check if config file exists
if (!-r $config{'sshd_config'}) {
	print &text('index_econfig', "<tt>$config{'sshd_config'}</tt>",
		    "/config.cgi?$module_name"),"<p>\n";
	print "<hr>\n";
	&footer("/", $text{"index"});
	exit;
	}

# Check if sshd exists
if (!&has_command($config{'sshd_path'})) {
	print &text('index_esshd', "<tt>$config{'sshd_path'}</tt>",
		    "/config.cgi?$module_name"),"<p>\n";
	print "<hr>\n";
	&footer("/", $text{"index"});
	exit;
	}

# Check if sshd is the right version
$out = `$config{'sshd_path'} -h 2>&1`;
if ($out =~ /sshd\s+version\s+([0-9\.]+)/i ||
    $out =~ /ssh\s+secure\s+shell\s+([0-9\.]+)/i) {
	# Classic SSH - only versions 1 and 2 are supported
	if ($1 >= 3) {
		print &text('index_eversion2',
			    "<tt>$config{'sshd_path'}</tt>", $1),"<p>\n";
		print "<hr>\n";
		&footer("/", $text{"index"});
		exit;
		}
	$version{'type'} = 'ssh';
	$version{'number'} = $1;
	}
elsif ($out =~ /OpenSSH.([0-9\.]+)/i) {
	# OpenSSH .. assume all versions are supported
	$version{'type'} = 'openssh';
	$version{'number'} = $1;
	}
else {
	# Unknown version
	print &text('index_eversion', "<tt>$config{'sshd_path'}</tt>",
		    "/config.cgi?$module_name"),"<p>\n";
	print "<hr>\n";
	&footer("/", $text{"index"});
	exit;
	}
&write_file("$module_config_directory/version", \%version);

# Display icons for options
foreach $i ('users', 'net', 'access', 'misc') {
	push(@links, "edit_$i.cgi");
	push(@titles, $text{$i.'_title'});
	push(@icons, "images/$i.gif");
	}
if (-r $config{'client_config'}) {
	push(@links, "list_hosts.cgi");
	push(@titles, $text{'hosts_title'});
	push(@icons, "images/hosts.gif");
	}
push(@links, "edit_sync.cgi");
push(@titles, $text{'sync_title'});
push(@icons, "images/sync.gif");
&icons_table(\@links, \@titles, \@icons, scalar(@links));

# Check if sshd is running
$conf = &get_sshd_config();
$pidfile = &find_value("PidFile", $conf);
$pidfile = $config{'pid_file'} if (!$pidfile);
if (open(PID, $pidfile) && ($pid = int(<PID>)) && kill(0, $pid)) {
	# Running .. offer to apply changes
	print "<hr>\n";
	print "<form action=apply.cgi>\n";
	print "<input name=pid type=hidden value='$pid'>\n";
	print "<table width=100%><tr>\n";
	print "<td><input type=submit value=\"$text{'index_apply'}\"></td>\n";
	print "<td>$text{'index_applymsg'}</td>\n";
	print "</tr></table></form>\n";
	}
else {
	# Not running .. offer to start
	print "<hr>\n";
	print "<form action=start.cgi>\n";
	print "<table width=100%><tr>\n";
	print "<td><input type=submit value=\"$text{'index_start'}\"></td>\n";
	print "<td>$text{'index_startmsg'}</td>\n";
	print "</tr></table></form>\n";
	}
close(PID);

print "<hr>\n";
&footer("/", $text{"index"});

