/* xzgv 0.7 - picture viewer for X, with file selector.
 * Copyright (C) 1999,2000 Russell Marks. See main.c for license details.
 *
 * readjpeg.c - read JPEG files. Based on zgv's readjpeg.c.
 */

#include <stdio.h>
#include <string.h>
#include <unistd.h>
#include <stdlib.h>
#include <setjmp.h>
#include <sys/file.h>  /* for open et al */
#include <jpeglib.h>

#include "rcfile.h"

#include "readjpeg.h"


/* the default setting is good (and fast) enough that it's difficult to
 * see any point in complicating matters by having a config file option
 * for it.
 */
#define JPEG_IDX_SIZE	4	/* like zgv's `jpegindexstyle 2' */



/* The way that libjpeg v5 works means that this more-or-less *has* to
 * global if I want to allow aborting in mid-read. Oh well. :-(
 */
static struct jpeg_decompress_struct cinfo;

/* stuff for error routines */
struct my_error_mgr
  {
  struct jpeg_error_mgr pub;	/* "public" fields */
  jmp_buf setjmp_buffer;	/* for return to caller */
  };

typedef struct my_error_mgr * my_error_ptr;


void my_error_exit(j_common_ptr cinfo)
{
my_error_ptr myerr=(my_error_ptr) cinfo->err;

/* cleanup is done after jump back, so just do that now... */
longjmp(myerr->setjmp_buffer, 1);
}


/* No warning messages */
void my_output_message(j_common_ptr cinfo)
{
}



/* origwp/orighp can be NULL if not interested */
int read_jpeg_file(char *filename,unsigned char **imagep,
                   int *wp,int *hp,int *origwp,int *orighp,int for_tn)
{
static FILE *in;
struct my_error_mgr jerr;
static unsigned char **lineptrs;
unsigned char *ptr,*ptr2;
int width,height;
int chkw,chkh;
int f,rec;
unsigned char *image;
static int greyscale;	/* static to satisfy gcc -Wall */

greyscale=0;

lineptrs=NULL;

if((in=fopen(filename,"rb"))==NULL)
  return(0);

cinfo.err=jpeg_std_error(&jerr.pub);
jerr.pub.error_exit=my_error_exit;
jerr.pub.output_message=my_output_message;

if(setjmp(jerr.setjmp_buffer))
  {
  if(lineptrs) free(lineptrs);
  jpeg_destroy_decompress(&cinfo);
  fclose(in);
  return(0);
  }

/* Now we can initialize the JPEG decompression object. */
jpeg_create_decompress(&cinfo);

jpeg_stdio_src(&cinfo,in);	/* indicate source is the file */

jpeg_read_header(&cinfo,TRUE);

/* setup parameters for decompression */

/* fix to greys if greyscale - this is required to read greyscale JPEGs */
if(cinfo.jpeg_color_space==JCS_GRAYSCALE)
  {
  cinfo.out_color_space=JCS_GRAYSCALE;
  cinfo.desired_number_of_colors=256;
  cinfo.quantize_colors=FALSE;
  cinfo.two_pass_quantize=FALSE;
  greyscale=1;
  }

*wp=width=cinfo.image_width;
*hp=height=cinfo.image_height;

if(origwp) *origwp=width;
if(orighp) *orighp=height;

if(for_tn)
  {
  chkw=JPEG_IDX_SIZE*80;
  chkh=JPEG_IDX_SIZE*60;

  cinfo.scale_num=1;
  cinfo.scale_denom=1;

  while((width>chkw || height>chkh) && cinfo.scale_denom<8)
    {
    width/=2;
    height/=2;
    cinfo.scale_denom*=2;
    }

  cinfo.dct_method=JDCT_FASTEST;
  cinfo.do_fancy_upsampling=FALSE;

  jpeg_calc_output_dimensions(&cinfo);

  *wp=width=cinfo.output_width;
  *hp=height=cinfo.output_height;
  }

/* this turns out to be the key reason Imlib1 was loading JPEGs
 * faster. This is what is technically known as "cheating", you gits. ;-)
 * Now I suppose I have to default to it for consistency, which is awkward
 * as it wouldn't have been my first choice for a default...
 */
if(!careful_jpeg)
  cinfo.do_fancy_upsampling=FALSE;

/* this one shouldn't hurt */
cinfo.do_block_smoothing=FALSE;

if((*imagep=image=malloc(width*height*3))==NULL)
  longjmp(jerr.setjmp_buffer,1);

jpeg_start_decompress(&cinfo);

/* read the image */
if((lineptrs=malloc(height*sizeof(unsigned char *)))==NULL)
  longjmp(jerr.setjmp_buffer,1);

ptr=image+width*2*greyscale;	/* put data at end of line if greyscale */
for(f=0;f<height;f++,ptr+=width*3)
  lineptrs[f]=ptr;

rec=cinfo.rec_outbuf_height;
while(cinfo.output_scanline<height)
  {
  f=height-cinfo.output_scanline;
  jpeg_read_scanlines(&cinfo,lineptrs+cinfo.output_scanline,
                      f>rec?rec:f);
  }

free(lineptrs);

jpeg_finish_decompress(&cinfo);
jpeg_destroy_decompress(&cinfo);
fclose(in);

if(greyscale)
  {
  int x,y;
  
  ptr=image+width*2*greyscale;
  ptr2=image;
  
  /* convert greyscale to RGB */
  for(y=0;y<height;y++,ptr+=width*2)
    for(x=0;x<width;x++)
      {
      *ptr2++=*ptr;
      *ptr2++=*ptr;
      *ptr2++=*ptr++;
      }
  }

return(1);
}
