//  This program is free software; you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published by
//  the Free Software Foundation; either version 2 of the License, or
//  (at your option) any later version.
//
//  This program is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.
//
//  You should have received a copy of the GNU General Public License
//  along with this program; if not, write to the Free Software
//  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

//  Based on code written by Aecio F. Neto (afn@harvest.com.br)
//              Harvest Consultoria (www.harvest.com.br)
//
//  hacked by m4d.
//

#include "SophieScan.hpp"


extern OptionContainer o;


// Constructor
SophieEngine::SophieEngine ()
{
}

// Deconstructor
SophieEngine::~SophieEngine ()
{
};


int
SophieEngine::scanFile (const char *_fname)
{
  int sockd = 0;
  int infected = 0;

#ifdef DGDEBUG
  cout << "Entering SophieEngine scanFile" << endl;
  cout << "Before calling dconnect" << endl;
#endif

  if ((sockd = dconnect ()) < 0)
    {
      err_str = "Error connecting to sophie daemon";
#ifdef DGDEBUG
      cout << err_str << endl;
#endif
      infected = VirusEngine::AV_FAIL;
    }
  else
    {
#ifdef DGDEBUG
      cout << "Before calling dsfile" << endl;
#endif
      infected = dsfile (sockd, _fname);
      close (sockd);
    }

  return infected;
}


int
SophieEngine::dsfile (int sockd, const char *filename)
{
  int infected = 0;
  char buff[4096], scancmd[512];
  FILE *fd;

#ifdef DGDEBUG
  cout << "Entering dsfile" << endl;
#endif

  snprintf (scancmd, 512, "%s", filename);

#ifdef DGDEBUG
  cout << "Before sending sophie command: " << scancmd << endl;
#endif

  if (write (sockd, scancmd, strlen (scancmd)) <= 0)
    {
      // Error writing to sophie socket
      infected = VirusEngine::AV_FAIL;
    }

  // reading response from sophie
  if ((fd = fdopen (dup (sockd), "r")) == NULL)
    {
      // Error opening socket for reading
      err_str = "Error opening sophie socket for reading";
#ifdef DGDEBUG
      cout << err_str << endl;
#endif
      infected = VirusEngine::AV_FAIL;
      return infected;
    }

  while (fgets (buff, sizeof (buff), fd))
    {
      if (buff[0] == '1')
        {                       // FOUND
          infected = VirusEngine::AV_VIRUS;
        }
      else
        {
          if (buff[0] == '0')
            {                   // ERROR
              infected = VirusEngine::AV_CLEAN;
            }
          else
            {
              infected = VirusEngine::AV_FAIL;
            }
        }
    }
#ifdef DGDEBUG
  cout << "Got reply from sophie: '" << buff << "'" << endl;
#endif

  if (infected == VirusEngine::AV_VIRUS)
    {
      setVirusName (buff + 2);
#ifdef DGDEBUG
      cout << "Virus found: '" << vname << "'" << endl;
#endif
    }
  else if (infected == VirusEngine::AV_FAIL)
    {
      setErrString ("unknown");
#ifdef DGDEBUG
      cout << "Error found: '" << err_str << "'" << endl;
#endif
    }
  fclose (fd);

  return infected;
}

int
SophieEngine::dconnect ()
{
  int sockd;
  struct sockaddr_un server;

  const char *LocalSocket = o.sophiesocket.c_str ();

  // maybe we should alos allow tcp sockets here in the future? (mad@madness.at)
  server.sun_family = AF_UNIX;
  strncpy (server.sun_path, LocalSocket, sizeof (server.sun_path));

  if ((sockd = socket (AF_UNIX, SOCK_STREAM, 0)) < 0)
    {
      return -1;
    }

  if (connect (sockd, (struct sockaddr *) &server, sizeof (struct sockaddr_un)) < 0)
    {
      return -1;
    }

  return sockd;
}
