/* ctostr.c  94.07.13
 * Copyright 1983-1992   Albert Davis
 * get string from string
 */
#include "ecah.h"
#include "declare.h"
/*--------------------------------------------------------------------------*/
	char	*ctostr(const char*,int*,char*,int,const char*);
/*--------------------------------------------------------------------------*/
/* ctostr: character input to string
 * scan (and eat) an input string (cmd) using index (cnt).
 * result in (des)  (null terminated).
 * max length (actual char count) is (len).
 * (des) must be at least (len)+1 characters long.
 * (cmd) unchanged.  (*cnt) updated to point to next argument.
 * skips leading whitespace.  skips trailing whitespace and comma
 * skips parts of input word too big for destination
 */
char *ctostr(const char *cmd, int *cnt, char *des, int len, const char *term)
{
 char chr;
 int dind;

 skipbl(cmd,cnt);
 for (dind = 0;  dind < len;  (*cnt)++, dind++){
    chr = cmd[*cnt];
    if (isterm(chr,term))
       break;
    des[dind] = chr;
 }
 des[dind] = '\0';

 while (!isterm(cmd[*cnt],term))
    (*cnt)++;
 skipcom(cmd,cnt);
 return des;
}
/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/
