/*
 * route.c - diald routing code.
 *
 * Copyright (c) 1994, 1995 Eric Schenk.
 * All rights reserved. Please see the file LICENSE which should be
 * distributed with this software for terms of use.
 */

#include "diald.h"

/* set up a point to point route for a device */
void set_ptp(char *itype, int iface, char *rip)
{
    char buf[128];
    if (debug&DEBUG_VERBOSE)
	syslog(LOG_INFO, "Setting pointopoint route for %s%d",itype,iface);
    sprintf(buf,"%s add %s %s%d",PATH_ROUTE,rip,itype,iface); 
    system(buf);
}

/*
 * Add in a direct and default route to the slip link.
 * The default route is only added if the "default" option was
 * requested by the user.
 */

void add_routes(char *itype, int iface, char *lip, char *rip)
{
    char buf[128];

    if (debug&DEBUG_VERBOSE)
	syslog(LOG_INFO,"Establishing routes for %s%d",itype,iface);

    if (mon_fp) {
	fprintf(mon_fp,"INTERFACE\n%s%d\n%s\n%s\n", itype, iface, lip, rip);
	fflush(mon_fp);
    }

    /* Add in a default route for the link */
    /* FIXME: should this refuse to add if a default route exists? */
    if (default_route) {
        sprintf(buf,"%s add default gw %s %s%d",PATH_ROUTE,rip,itype,iface);
        system(buf);
    }
    /* FIXME: I should do proxyarp routing here as well */
    /* call addroute script */
    if (addroute) {
        sprintf(buf,"%s %s%d %s %s %s",
	    addroute,itype,iface,(netmask)?netmask:"default",lip,rip);
        if (system(buf) < 0) {
	    syslog(LOG_ERR,"addroute script %s failed",addroute);
        }
    }
}

/*
 * Call the delroute script and take the pty out of slip mode.
 */
void del_routes(char *itype, int iface, char *lip, char *rip)
{
    char buf[128];
    if (debug&DEBUG_VERBOSE)
	syslog(LOG_INFO,"Removing routes for %s%d",itype,iface);
    if (delroute) {
	/* call delroute <iface> <netmask> <local> <remote> */
        sprintf(buf,"%s %s%d %s %s %s",
	    delroute,itype,iface,(netmask)?netmask:"default",lip,rip);
        if (system(buf) < 0) {
	    syslog(LOG_ERR,"delroute script %s failed",delroute);
        }
    }
}
