/* This file is part of the KDE libraries
    Copyright (C) 1997 Christian Czezatke (e9025461@student.tuwien.ac.at)

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
    Boston, MA 02111-1307, USA.
*/
//
//  KPROCESSCONTROLLER -- A helper class for KProcess
//
//  version 0.2.2, Aug 31st 1997

#ifndef __KPROCCTRL_H__
#define __KPROCCTRL_H__


#include <qsocknot.h>
#include "kprocess.h"

/**
  A class for internal use by KProcess only. -- Exactly one instance
  of this class is generated by the first instance of KProcess that is
  created (a pointer to it gets stored in "theKProcessController".
*/
class KProcessController : public QObject
{
  Q_OBJECT

public:
  KProcessController();
  ~KProcessController();

  QList<KProcess> *processList;

 public slots:

 void slotDoHousekeeping(int socket);
//  void slotNoteSocket(int socket);
private:

  static void theSigCHLDHandler(int signal);
  // handler for sigchld

  int fd[2];
  QSocketNotifier *notifier;
};

extern KProcessController *theKProcessController;

#endif

