/*
 * Copyright (C) 1996,1997 Michael R. Elkins <me@cs.hmc.edu>
 * 
 *     This program is free software; you can redistribute it and/or modify
 *     it under the terms of the GNU General Public License as published by
 *     the Free Software Foundation; either version 2 of the License, or
 *     (at your option) any later version.
 * 
 *     This program is distributed in the hope that it will be useful,
 *     but WITHOUT ANY WARRANTY; without even the implied warranty of
 *     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *     GNU General Public License for more details.
 * 
 *     You should have received a copy of the GNU General Public License
 *     along with this program; if not, write to the Free Software
 *     Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */ 

#include "config.h"

#include <stdio.h>
#include <sys/types.h>
#include <time.h>
#include <limits.h>
#include <stdarg.h>

#include "rfc822.h"

#define TRUE 1
#define FALSE 0

#define EPOCH 1970

#ifdef HAVE_SRAND48
#define LRAND lrand48
#define SRAND srand48
#define DRAND drand48
#else
#define LRAND rand
#define SRAND srand
#define DRAND (double)rand
#endif /* HAVE_SRAND48 */

#ifdef HAVE_SETEGID
#define SETEGID setegid
#else
#define SETEGID setgid
#endif

#define whitespace(c) ((c) == ' ' || (c) == '\t' || (c) == '\r' || (c) == '\n')

#define FOREVER while (1)

#ifdef DEBUG
#define dprint(N,X) if(debuglevel>=N) fprintf X
#else
#define dprint(N,X) 
#endif

#define strfcpy(A,B,C) strncpy(A,B,C), *(A+(C)-1)=0

#define SKIPWS(c) while (*(c) && isspace ((unsigned char) *(c))) c++;

#ifdef LOCALES_HACK
#define IsPrint(c) (isprint((unsigned char)(c)) || \
	(((unsigned char)(c) > 0xa0) && ((unsigned char)(c) < 0xff)))
#else
#define IsPrint(c) (isprint((unsigned char)(c)) || \
	(option (OPTLOCALES) ? 0 : \
	((unsigned char)(c) > 0xa0 && (unsigned char)(c) < 0xff)))
#endif

#define HUGE_STRING	5120
#define LONG_STRING     1024
#define STRING          256
#define SHORT_STRING    128

/* Content-Disposition values */
#define DISPINLINE 0
#define DISPATTACH 1
#define DISPFORMDATA 2

#define TYPE(X) body_types[(X)]
#define ENCODING(X) body_encodings[(X)]

#define is_multipart(x) \
    ((x)->type == TYPEMULTIPART \
     || ((x)->type == TYPEMESSAGE && (!strcasecmp((x)->subtype, "rfc822") \
				      || !strcasecmp((x)->subtype, "news"))))

/* Content-Type */
enum
{
  TYPEOTHER,
  TYPEAUDIO,
  TYPEAPPLICATION,
  TYPEIMAGE,
  TYPEMESSAGE,
  TYPEMULTIPART,
  TYPETEXT,
  TYPEVIDEO
};

/* Content-Transfer-Encoding */
enum
{
  ENCOTHER,
  ENC7BIT,
  ENC8BIT,
  ENCQUOTEDPRINTABLE,
  ENCBASE64,
  ENCBINARY
};

/* MIME encoding/decoding global vars */
extern int Index_hex[];
extern int Index_64[];
extern char Base64_chars[];

#define hexval(c) Index_hex[(int)(c)]
#define base64val(c) Index_64[(int)(c)]

/* supported mailbox formats */
enum
{
  M_MBOX = 1,
  M_MMDF,
  M_MH,
  M_MAILDIR,
  M_IMAP
};

/* flags for mutt_copy_header() */
#define CH_UPDATE	1      /* update the status and x-status fields? */
#define CH_WEED		(1<<1) /* weed the headers? */
#define CH_DECODE	(1<<2) /* do RFC1522 decoding? */
#define CH_XMIT		(1<<3) /* transmitting this message? */
#define CH_FROM		(1<<4) /* retain the "From " message separator? */
#define CH_PREFIX	(1<<5) /* use Prefix string? */
#define CH_NOSTATUS	(1<<6) /* supress the status and x-status fields */
#define CH_REORDER	(1<<7) /* Re-order output of headers */
#define CH_MIME		(1<<8) /* update MIME headers */

typedef int sort_t (const void *, const void *);
sort_t *mutt_get_sort_func (int);

#define REDRAW_INDEX		(1)
#define REDRAW_MOTION		(1<<1)
#define REDRAW_MOTION_RESYNCH	(1<<2)
#define REDRAW_CURRENT		(1<<3)
#define REDRAW_STATUS		(1<<4)
#define REDRAW_FULL		(1<<5)

/* forced redraw types */
#define R_NONE			0
#define R_INDEX			(1<<0)
#define R_PAGER			(1<<1)
#define R_BOTH			(R_INDEX | R_PAGER)

/* These must be in the same order as in the global var "Sort_methods" */
#define SORT_DATE     1   /* the date the mail was sent. */
#define SORT_SIZE     2
#define SORT_SUBJECT  3
#define SORT_FROM     4
#define SORT_ORDER    5   /* the order the messages appear in the mailbox. */
#define SORT_THREADS  6
#define SORT_RECEIVED 7   /* when the message were delivered locally */
#define SORT_MAX      7   /* FOO - needs to be changed if more methods */
#define SORT_MASK     0x7
#define SORT_REVERSE  8
#define SORT_LAST     16

/* flags for mutt_open_mailbox() */
#define M_NOSORT	(1<<0) /* do not sort the mailbox after opening it */
#define M_APPEND	(1<<1) /* open mailbox for appending messages */
#define M_READONLY	(1<<2) /* open in read-only mode */
#define M_QUIET		(1<<3) /* do not print any messages */

/* flags for ci_enter_string() */
#define  M_ALIAS 1      /* do alias "completion" by calling up the alias-menu */
#define  M_FILE  (1<<1) /* do file completion */
#define  M_EFILE (1<<2) /* do file completion, plus incoming folders */
#define  M_CMD   (1<<3) /* do completion on previous word */
#define  M_PASS  (1<<4) /* password mode (no echo) */
#define  M_CLEAR (1<<5) /* clear input if printable character is pressed */

/* flags for mutt_extract_token() */
#define M_EQUAL		1	/* treat '=' as a special */
#define M_CONDENSE	(1<<1)	/* ^(char) to control chars (macros) */
#define M_SPACE		(1<<2)

/* flags for _mutt_system() */
#define M_DETACH_PROCESS	1	/* detach subprocess from group */

/* flags for _mutt_make_string() */
#define M_FORCESUBJ	(1<<0) /* print the subject even if it didn't change */
#define M_TREE		(1<<1) /* draw the thread tree */

enum
{
  /* types for mutt_add_hook() */
  M_FOLDERHOOK = 1,
  M_FCCHOOK,
  M_SAVEHOOK,
  M_MBOXHOOK,
  M_SENDHOOK,

  /* modes for mutt_view_attachment() */
  M_REGULAR,
  M_MAILCAP,
  M_AS_TEXT,

  /* action codes used by mutt_set_flag() and mutt_pattern_function() */
  M_ALL,
  M_NONE,
  M_NEW,
  M_OLD,
  M_REPLIED,
  M_READ,
  M_UNREAD,
  M_DELETE,
  M_UNDELETE,
  M_DELETED,
  M_FLAG,
  M_TAG,
  M_UNTAG,
  M_LIMIT,

  /* actions for doString() / mutt_pattern_function() */
  M_TO,
  M_CC,
  M_SUBJECT,
  M_FROM,
  M_DATE,
  M_DATE_RECEIVED,
  M_ID,
  M_BODY,
  M_HEADER,
  M_SENDER,
  M_MESSAGE,
  M_THREAD,

  /* Options for Mailcap lookup */
  M_EDIT,
  M_COMPOSE,
  M_PRINT,
  M_AUTOVIEW,

  /* Options for mutt_save_attachment */
  M_SAVE_APPEND
};

/* possible arguments to set_quadoption() */
enum
{
  M_NO,
  M_YES,
  M_ASKNO,
  M_ASKYES
};

/* quad-option vars */
enum
{
  OPT_VERIFYSIG, /* verify PGP signatures */
  OPT_USEMAILCAP,
  OPT_PRINT,
  OPT_INCLUDE,
  OPT_DELETE,
  OPT_MOVE,
  OPT_COPY,
  OPT_POSTPONE,
  OPT_REPLYTO,
  OPT_ABORT,
  OPT_RECALL,
  OPT_SUBJECT
};

/* flags to ci_send_message() */
#define SENDREPLY	(1<<0)
#define SENDGROUPREPLY	(1<<1)
#define SENDLISTREPLY	(1<<2)
#define SENDFORWARD	(1<<3)
#define SENDPOSTPONED	(1<<4)
#define SENDBATCH	(1<<5)
#define SENDMAILX	(1<<6)

/* boolean vars */
enum
{
  OPTPROMPTAFTER,
  OPTSTATUSONTOP,
  OPTALLOW8BIT,
  OPTASCIICHARS,
  OPTHOLD,
  OPTMETOO,
  OPTEDITHDRS,
  OPTARROWCURSOR,
  OPTASKCC,
  OPTHEADER,
  OPTPOINTNEW,
  OPTREVALIAS,
  OPTREVNAME,
  OPTFORCENAME,
  OPTSAVEEMPTY,
  OPTPAGERSTOP,
  OPTSIGDASHES,
  OPTASKBCC,
  OPTAUTOEDIT,
#ifdef _PGPPATH
  OPTPGPAUTOSIGN,
  OPTPGPAUTOENCRYPT,
  OPTPGPREPLYENCRYPT,
  OPTPGPREPLYSIGN,
  OPTPGPENCRYPTSELF,
  OPTPGPSTRICTENC,
#endif
  OPTMARKOLD,
  OPTCONFIRMCREATE,
  OPTCONFIRMAPPEND,
  OPTPOPDELETE,
  OPTSAVENAME,
  OPTTHOROUGHSRC,
  OPTTILDE,
  OPTMIMEFWD,
  OPTMARKERS,
  OPTFCCATTACH,
  OPTATTACHSPLIT,
  OPTPIPESPLIT,
  OPTPIPEDECODE,
  OPTFORWDECODE,
  OPTREADONLY,
  OPTRESOLVE,
  OPTSTRICTTHREADS,
  OPTAUTOTAG,
  OPTBEEP,
  OPTHELP,
  OPTHDRS,
  OPTWEED,
  OPTWRAP,
  OPTCHECKNEW,
  OPTFASTREPLY,
  OPTWAITKEY,
  OPTIGNORELISTREPLYTO,
  OPTSAVEADDRESS,
  OPTSUSPEND,
  OPTSORTRE,
  OPTUSEDOMAIN,
  OPTUSEFROM,
  OPTUSE8BITMIME,
  OPTLOCALES,		/* (pseudo) set if user has valid locale definition */
  OPTFORWARD,		/* (pseudo) set when forwarding messages */
  OPTVERIFYSIG,		/* (pseudo) controlled by M_VERIFYSIG */
  OPTNOCURSES,		/* (pseudo) when sending in batch mode */
  OPTNEEDREDRAW,	/* (pseudo) to notify caller of a submenu */
  OPTSEARCHREVERSE,	/* (pseudo) used by ci_search_command */
  OPTMSGERR,		/* (pseudo) used by mutt_error/mutt_message */
  OPTSEARCHINVALID,	/* (pseudo) used to invalidate the search pat */
  OPTNOAUTOVIEW, 	/* (pseudo) used by pipe_msg */
  OPTSIGNALSBLOCKED,	/* (pseudo) using by mutt_block_signals () */
  OPTNEEDRESORT,	/* (pseudo) used to force a re-sort */
  OPTVIEWATTACH,	/* (pseudo) signals that we are viewing attachments */
  OPTFORCEREDRAWINDEX,	/* (pseudo) used to force a redraw in the main index */
  OPTFORCEREDRAWPAGER,	/* (pseudo) used to force a redraw in the pager */
  OPTMAX
};

#define set_option(x) Options[(x)/8] |= (1 << ((x) % 8))
#define unset_option(x) Options[(x)/8] &= ~(1 << ((x) % 8))
#define toggle_option(x) Options[(x)/8] ^= (1 << ((x) % 8))
#define option(x) (Options[(x)/8] & (1 << ((x) % 8)))

/* Bit fields for ``Signals'' */
#define S_INTERRUPT (1<<1)
#define S_SIGWINCH  (1<<2)

struct mapping_t
{
  char *name;
  int value;
};

typedef struct
{
  FILE *fpin;
  FILE *fpout;
  char *prefix;
  short displaying; /* nonzero iff sending the output to a pager. */
} STATE;

typedef struct alias
{
  char *name;
  ADDRESS *addr;
  struct alias *next;
} ALIAS;

typedef struct list_t
{
  char *data;
  struct list_t *next;
} LIST;

typedef struct
{
  char *pattern;
  void *rx; /* avoid including "mutt_regex.h" everywhere... */
} REGEXP;

typedef struct buffy_t
{
  char *path;
#ifdef BUFFY_SIZE
  long size;
#endif /* BUFFY_SIZE */
  int new;
  struct buffy_t *next;
} BUFFY;

typedef struct envelope
{
  ADDRESS *return_path;
  ADDRESS *from;
  ADDRESS *to;
  ADDRESS *cc;
  ADDRESS *bcc;
  ADDRESS *sender;
  ADDRESS *reply_to;
  char *subject;
  char *real_subj;   /* offset of the real subject */
  char *message_id;
  LIST *references;  /* message references (in reverse order) */
  LIST *userhdrs;    /* user defined headers */
} ENVELOPE;

typedef struct parameter
{
  char *attribute;
  char *value;
  struct parameter *next;
} PARAMETER;

/* Information that helps in determing the Content-* of an attachment */
typedef struct content
{
  unsigned int space : 1;  /* whitespace at the end of lines? */
  unsigned int binary : 1; /* long lines, or CR not in CRLF pair */
  unsigned int from : 1;   /* has a line beginning with "From "? */
  unsigned int dot : 1;    /* has a line consisting of a single dot? */
  long hibin;              /* 8-bit characters */
  long lobin;              /* unprintable 7-bit chars (eg., control chars) */
  long ascii;              /* number of ascii chars */
  long linemax;            /* length of the longest line in the file */
} CONTENT;

typedef struct body
{
  unsigned int type : 3;        /* content-type primary type */
  unsigned int encoding : 3;    /* content-transfer-encoding */
  unsigned int disposition : 2; /* content-disposition */
  unsigned int use_disp : 1;    /* Content-Disposition field printed? */
  unsigned int unlink : 1;      /* flag to indicate the the file named by
				 * "filename" should be unlink()ed before
				 * free()ing this structure
				 */
  unsigned int marked : 1;      /* used for computing subtree spans */
  unsigned int empty : 1;       /* attachment without underlying file in 
				 * the compose menu
				 */
  char *subtype;                /* content-type subtype */
  PARAMETER *parameter;         /* parameters of the content-type */
  char *description;            /* content-description */
  char *form_name;		/* Content-Disposition form-data name param */
  long hdr_offset;              /* offset in stream where the headers begin.
				 * this info is used when invoking metamail,
				 * where we need to send the headers of the
				 * attachment
				 */
  long offset;                  /* offset where the actual data begins */
  long length;                  /* length (in bytes) of attachment */
  char *filename;               /* when sending a message, this is the file
				 * to which this structure refers
				 */
  CONTENT *content;             /* structure used to store detailed info about
				 * the content of the attachment.  this is used
				 * to determine what content-transfer-encoding
				 * is required when sending mail.
				 */
  struct body *next;            /* next attachment in the list */
  struct body *parts;           /* parts of a multipart or message/rfc822 */
  struct header *hdr;		/* header information for message/rfc822 */
} BODY;

typedef struct header
{
  unsigned int mime : 1;    /* has a Mime-Version header? */
  unsigned int mailcap : 1; /* requires mailcap to display? */
  unsigned int flagged : 1; /* marked important? */
  unsigned int tagged : 1;
  unsigned int deleted : 1;
  unsigned int changed : 1;
  unsigned int old : 1;
  unsigned int read : 1;

  unsigned int pgp : 3;
  unsigned int replied : 1;
  unsigned int subject_changed : 1; /* used for threading */
  unsigned int display_subject : 1; /* used for threading */
  unsigned int fake_thread : 1;     /* used for threading */
  unsigned int xxx : 1;             /* unused */

  /* timezone of the sender of this message */
  unsigned int zhours : 5;
  unsigned int zminutes : 6;
  unsigned int zoccident : 1;
  unsigned int yyy : 4;		/* unused */

  time_t date_sent;     /* time when the message was sent (UTC) */
  time_t received;      /* time when the message was placed in the mailbox */
  long offset;          /* where in the stream does this message begin? */
  unsigned short lines; /* how many lines in the body of this message? */
  unsigned short index; /* the absolute (unsorted) message number */
  unsigned short msgno;	/* number displayed to the user */
  short virtual;        /* virtual message number */
  ENVELOPE *env;	/* envelope information */
  BODY *content;	/* list of MIME parts */
  char *path;
  
  /* the following are used for threading support */
  struct header *parent;
  struct header *child;  /* decendants of this message */
  struct header *next;   /* next message in this thread */
  struct header *prev;   /* previous message in thread */
  struct header *last_sort; /* last message in subthread, for secondary SORT_LAST */
  char *tree;            /* character string to print thread tree */

} HEADER;

typedef struct
{
  char *path;
  FILE *fp;
  time_t mtime;
  off_t size;
  HEADER **hdrs;
  short *v2r;			/* mapping from virtual to real msgno */
  unsigned short hdrmax;	/* number of pointers in hdrs */
  unsigned short msgcount;	/* number of messages in the mailbox */
  unsigned short vcount;	/* the number of virtual messages */
  unsigned short tagged;	/* how many messages are tagged? */
  unsigned short new;		/* how many new messages? */
  unsigned short deleted;	/* how many deleted messages */
  unsigned short flagged;	/* how many flagged messages */
  short magic;			/* mailbox type */
  short msgnotreadyet;		/* which msg "new" in pager, -1 if none */
  unsigned int locked : 1;	/* is the mailbox locked? */
  unsigned int changed : 1;	/* mailbox has been modified */
  unsigned int readonly : 1;    /* don't allow changes to the mailbox */
  unsigned int dontwrite : 1;   /* dont write the mailbox on close */
  unsigned int append : 1;	/* mailbox is opened in append mode */
  unsigned int setgid : 1;
  unsigned int quiet : 1;	/* inhibit status messages? */
  unsigned int revsort : 1;	/* mailbox sorted in reverse? */

#ifdef USE_IMAP
  void *data;		/* driver specific data */
  int fd;
#endif /* USE_IMAP */

} CONTEXT;

typedef struct
{
  FILE *fp;	/* pointer to the message data */
#ifdef USE_IMAP
  char *path;	/* path to temp file */
#endif /* USE_IMAP */
  short magic;	/* type of mailbox this message belongs to */
  short write;	/* nonzero if message is open for writing */
} MESSAGE;

typedef struct attachptr
{
  BODY *content;
  char *tree;
  int level;
  int tagged;
  struct attachptr *next;
} ATTACHPTR;

#include "protos.h"
#include "globals.h"
