/*
 * ProFTPD - FTP server daemon
 * Copyright (c) 1997, Public Flood Software
 *  
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#ifndef __MODULES_H
#define __MODULES_H

typedef struct module_struc module;

typedef struct {
  char *directive;
  char *(*handler)(cmd_rec*);
  module *m;				/* Reference to owning module
					 * set when module is initialized
					 */
} conftable;

typedef struct {
  char *command;
  char *group;				/* Command grouping */
  char *(*handler)(cmd_rec*);
  int requires_auth;			/* Authenication required? */
  int interrupt_xfer;			/* Allowed to issue during xfer? */
  module *m;

} cmdtable;

struct module_struc {
  module *next,*prev;

  int ver;		/* API version _not_ module version */
  char *name;		/* Module name */

  conftable *conftable;	/* Configuration directive table */
  cmdtable *cmdtable;	/* Command table */ 
  int (*module_init)(); /* Module initialization */
  int (*module_init_child)(); /* Initialize newly forked child */
};


/* These are stored in modules.c */

extern conftable *m_conftable;			/* Master conftable */
extern cmdtable *m_cmdtable;			/* Master cmdtable */

#define ANY_MODULE	((module*)0xffffffff)

/* Prototypes */

int init_modules();				/* Initialize modules */
int init_child_modules();
void *call_module(module *m, char *(*func)(cmd_rec*), cmd_rec *cmd);
void *call_module_cmd(module *m, char *(*func)(cmd_rec*), cmd_rec *cmd);

/* This function is in main.c, but is prototyped here */
void set_auth_check(int (*ck)(cmd_rec*));
void xfer_set_data_port(in_addr_t*,int);

#endif /* __MODULES_H */
