/* $Id: scan_num.cc,v 1.3 1997/03/22 20:21:33 dps Exp $ */
/* Simple number analyser */
#define __EXCLUDE_READER_CLASSES
#include "lib.h"

num_info scan_num(const char *scan)
{
    int nd, p;
    num_info r;

    r.wd[0]=r.wd[1]=r.has_sign=nd=0;
    p=1;

    switch (*scan)
    {
    case '-':
    case '+':
	scan++;
	r.wd[0]++;
	p++;
	r.has_sign=1;
	break;

    case '0':
    case '1':
    case '2':
    case '3':
    case '4':
    case '5':
    case '6':
    case '7':
    case '8':
    case '9':
	break;

    default:
	r.dot_pos=-1;
	return r;
    }

    for ( ; *scan!='\0'; scan++, p++)
    {
	switch (*scan)
	{
	case '0':
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':
	    r.wd[nd]++;	// Digit
	    break;

	case '.':
	    r.dot_pos=p;
	    if ((++nd)==1)
		break;
	    /* Fall through */
	default:
	    r.dot_pos=-1;
	    return r;
	}
    }
    if (nd==0)
	r.dot_pos=p;
    return r;
}






