
#ifndef	CMAP_FUNCS_H
#define CMAP_FUNCS_H

/* 
 *
 * cmap_funcs.h: V1.00
 * Author: 	Jim GEUTHER
 * Date:    	13-May-96
 * Environment: Personal Power System 850 + AIX V4.1.3.0
 *
 * This code was originally developed on the Amiga for ImageKnife.
 *
 * History:
 * V1.00	Jim GEUTHER, original development for Gimp.
 *
 */
 
/*
 * This is a plug-in for the GIMP.
 *
 * Copyright (C) 1993/94/95/96 Jim Geuther
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 *
 */
 
#include "cmap_palette.h"

#define BIG_DISTANCE 1000000L	/* Big distance between two colors */

/*
** Changing the casting in the DIST macro doesnot influence
** the generated code. Converting this macro to a function
** did not help a lot.
*/

#define	MUL3( x )	((x)*3)

/* Converting DIST() to floating point doesnot make it any faster */
/*
** So what DIST do and why does it take a long time to run.
**
** DIST uses three multiplications for each time it is called
** that is three multiplications for each pixel. Thats what makes
** the process so slow.
**
** Take some examples: R1=78 G1=95 B1=233, R2=213 G2=123 B2=17
**
** r1-r2=-135
** -405 * -135 = 54675
** g1-g2=-28
** -112 * -28 = 3136
**
*/

/*
** NO multiplication macros to avoid possible problems with
** signs
*/
#define DIST(r1,g1,b1,r2,g2,b2) \
	    (long) ( MUL3((short)((r1)-(r2)))*(short)((r1)-(r2)) + \
		     mul4((short)((g1)-(g2)))*(short)((g1)-(g2)) + \
		     mul2((short)((b1)-(b2)))*(short)((b1)-(b2)))

u_long		truecolourdifference(struct ColourTriplet *triplet0,
			struct ColourTriplet	*triplet1
			);
return_code	req_colcomplement(Image	input,Image output);
return_code	req_antique(Image input,Image output);
return_code	req_palette(Image,Image,int);
return_code	req_colorremap(Image,Image,int);
void 		replacepalette(struct palette *palette0,
			struct palette *palette1);
return_code 	req_adjust_hls(Image,Image);
void 		cmap2palette(u_char *,struct palette *,int);
void 		palette2cmap(struct palette *,u_char *,int);


#endif




