// -*- C++ -*-
/*
  This file is part of
  ======================================================
  
  LyX, the High Level Word Processor
  
  Copyright (C) 1995 Matthias Ettrich
  
  ======================================================
  */

#ifndef LYX_STY_H
#define LYX_STY_H


//\NeedsTeXFormat{LaTeX2e}
//\ProvidesPackage{lyx}[1996/01/11 LLE v0.2 (LyX LaTeX Extensions)]
//\message{LyX LaTeX Extensions (LLE v0.2) of 11-Jan-1996.} 


static const char* lyx_sty[] = {
  "\\makeatletter",
  "\\def\\LyX{L\\kern-.1667em\\lower.25em\\hbox{Y}\\kern-.125emX\\spacefactor1000}%",

  "\\newcommand{\\lyxtitle}[1] {\\thispagestyle{empty}",
  "\\global\\@topnum\\z@",
  "\\section*{\\LARGE \\centering \\sffamily \\bfseries \\protect#1 }",
  "}",

   "\\newcommand{\\lyxline}[1]{",
   "{#1 \\vspace{1ex} \\hrule width \\columnwidth \\vspace{1ex}}",
   "}",
//  "\\newcommand{\\lyxline}[1][1pt]{",
//  "  {\\medskip\\noindent\\rule{\\columnwidth}{#1}\\linebreak\\medskip}",
//  "}",

//   "\\newenvironment{lyxsectionbibliography}",
//   "{",
//   "\\section*{\\refname}",
//   "\\@mkboth{\\uppercase{\\refname}}{\\uppercase{\\refname}}",
//   "\\begin{list}{}{",
//   "\\itemindent-\\leftmargin",
//   "\\labelsep 0pt",
//   "\\renewcommand{\\makelabel}{}",
//   "}",
//   "}",
//   "{\\end{list}}",

  "\\newenvironment{lyxbibliography}",
  "{",
  "\\begin{thebibliography}{99}" // this {99} must do for now (Lgb)
  "}",
  "{\\end{thebibliography}}",

//   "\\newenvironment{lyxchapterbibliography}",
//   "{",
//   "\\chapter*{\\bibname}",
//   "\\@mkboth{\\uppercase{\\bibname}}{\\uppercase{\\bibname}}",
//   "\\begin{list}{}{",
//   "\\itemindent-\\leftmargin",
//   "\\labelsep 0pt",
//   "\\renewcommand{\\makelabel}{}",
//   "}",
//   "}",
//   "{\\end{list}}",
  
  "\\def\\lxq{\"}",
  "\\newenvironment{lyxcode}",
  "{\\list{}{",
  "\\rightmargin\\leftmargin", 
  "\\raggedright",
  "\\itemsep 0pt",
  "\\parsep 0pt",
  "\\ttfamily",
  "}%",
  "\\item[]",
  "}",
  "{\\endlist}",

  "\\newcommand{\\lyxlabel}[1]{#1 \\hfill}",

  "\\newenvironment{lyxlist}[1]",
  "{\\begin{list}{}",
  "{\\settowidth{\\labelwidth}{#1}",
  "\\setlength{\\leftmargin}{\\labelwidth}",
  "\\addtolength{\\leftmargin}{\\labelsep}",
  "\\renewcommand{\\makelabel}{\\lyxlabel}}}",
  "{\\end{list}}",

  "\\newcommand{\\lyxletterstyle}{",
  "\\setlength\\parskip{0.7em}",
  "\\setlength\\parindent{0pt}",
  "}",

  "\\newcommand{\\lyxaddress}[1]{",
  "\\par {\\raggedright #1 ",
  "\\vspace{1.4em}",
  "\\noindent\\par}",
  "}",

  "\\newcommand{\\lyxrightaddress}[1]{",
  "\\par {\\raggedleft \\begin{tabular}{l}\\ignorespaces",
  "#1",
  "\\end{tabular}",
  "\\vspace{1.4em}",
  "\\par}",
  "}",

  "\\newcommand{\\lyxformula}[1]{",
  "\\begin{eqnarray*}",
  "#1",
  "\\end{eqnarray*}",
  "}",
  "\\newcommand{\\lyxnumberedformula}[1]{",
  "\\begin{eqnarray}",
  "#1",
  "\\end{eqnarray}",
  "}",
  "\\makeatother",
  NULL
};

#endif
