/***************************************************************************
**    xIrcConnect.h  $Revision: 1.19 $ - $Name: V1-17B $ 
**    Class for making the server connections
**
** Copyright (C) 1995, 1996  Joseph Croft <jcroft@unicomp.net>  
** 
** This program is free software; you can redistribute it and/or modify
** it under the terms of the GNU General Public License as published by
** the Free Software Foundation; either version 1, or (at your option)
** any later version.
** 
** This program is distributed in the hope that it will be useful,
** but WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
** GNU General Public License for more details.
** 
** You should have received a copy of the GNU General Public License
** along with this program; if not, write to the Free Software
** Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
**
 ***************************************************************************/
#ifndef _xIRCCONNECT_H
#define _xIRCCONNECT_H

#include <qstring.h>
#include <xMultiLineFrame.h>
#include <xPshBtnFrame.h>
#include <xSocketDialog.h>
#include <xResources.h>
#include "xIrcSocket.h"
#include "xIrcMsgFrame.h"
#include "xIrcCommands.h"
#include "xIrcMsgQuery.h"
#include "xIrcDccChatFrame.h"
#include "xIrcNickActionQuery.h"
#include "xIrcBanDialog.h"

class xIrcConnect : public xDialog
{
   Q_OBJECT

public:   
   xIrcConnect(xWidgetResInfo *pPRes, QWidget *parent=0, const char *name=0, 
               WFlags iFlags = 0,
               int width = 80, int height = 25, int maxLines = 300);
   ~xIrcConnect();

   QString buildBanMask(xIrcMessage *pMsg);

signals:
   void textOut(const char *);
   void msgOut(xIrcMessage *pMsg);

public slots:
   void newServer();

protected slots:
   void stopConnection();
   void keyboardInput();
   void newChannel();
   void newNick();
   void quitIrc();
   void sendMsgToSocket(const char *pBuf);
   void ircMsgFrameClosing(xIrcMessageFrame *pMF);
   void msgQryHandler(xIrcMessage *pMsg);
   void dccChatHandler(xIrcMessage *pMsg);
   void gotErrorAck(int rspCode);
   void socketClosed();
   void gotChanBoxResult(int result);
   void acceptInvite(QString strChannel);
   void buttonPressed(int btn);
   void nickActionHandler(xMultiLineTextSelection txtSel);
      
private slots:
   void recvMessage(xIrcMessage *pMsg);
   void sendMessage(xIrcMessage *pMsg);
   void goodConnection(int sock);
   void failedConnection(int err);
   void connStatus(int err);
   void initiateDCCChat(xIrcDccChatFrame*);
   
protected:
   void              gotPing(xIrcMessage *pMsg);
   void              gotPong(xIrcMessage *pMsg);
   void              gotResponse(xIrcMessage *pMsg);
   bool              doSpecialMessage(xIrcMessage *pMsg);
   void              showResponse(xIrcMessage *pMsg);
   void              showError(xIrcMessage *pMsg);
   xIrcMessageFrame  *findMsgFrame(const char *pName);
   xIrcMessageFrame  *makeNewMsgFrame(QWidget *pParent, const char *pName);
   virtual void      resizeEvent(QResizeEvent *pEvt);
//   xIrcMessageFrame *queryNewMessage(xIrcMsgQuery *pMsgQry,
//                                      xIrcMessage *pMsg);
   
private:
   enum btnVals
   {
      btnServer, btnChannel, btnAction, btnNick, btnQuit
   };

   xIrcNickActionQuery  *pNickAction;
   xPshBtnFrame      *pButtons;
   xIrcMessageFrame  *pIrcMsgFrames;
   xMultiLineFrame   *pMainWin;
   QMenuBar          *pMenu;
   xIrcSocket        *pSocket;
   xIrcCommands      cmds;
   xSocketDialog     *pSocketBox;
   xIrcBanDialog     *pBanBox;
   QString           nickName;
   QString           realName;
   QString           hostName;
   QString           userName;
   QString           banChan;
   QString           banNick;
   bool              banFlag;
   bool              quitFlag;
   bool              serverFlag;
   int               resizeCnt;   
   xWidgetResInfo    *wdtRes;
   xWidgetResInfo    *wdtPrv;
   bool  isMsg(int cmd, char *pStr);
};

#endif
