/*
** Copyright (C) 1995, 1996  Joseph Croft <jcroft@unicomp.net>  
** 
** This program is free software; you can redistribute it and/or modify
** it under the terms of the GNU General Public License as published by
** the Free Software Foundation; either version 1, or (at your option)
** any later version.
** 
** This program is distributed in the hope that it will be useful,
** but WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
** GNU General Public License for more details.
** 
** You should have received a copy of the GNU General Public License
** along with this program; if not, write to the Free Software
** Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/
#include "ircreply.h"
#include "xIrcMsgDispatch.h"

static int dbg = 0;

static int *pResponseList[] = 
{
   // OPER
   { RPL_YOUREOPER, 0 },
   // MODE
   { RPL_CHANNELMODEIS, RPL_ENDOFBANLIST, 0 },
   // TOPIC
   { RPL_TOPIC, RPL_NOTOPIC, 0 },
   // NAMES
   { RPL_NAMEREPLY, RPL_ENDOFNAMES, 0 },
   // LIST
   { RPL_LIST, RPL_LISTSTART, RPL_LISTEND, 0 },
   // INVITE
   { RPL_INVITE, RPL_AWAY, 0 },
   // VERSION
   { RPL_VERSION, 0 },
   // STATS
   { RPL_STATSCLINE, RPL_STATSILINE, RPL_STATSQLINE, RPL_STATSLINKINFO,
     RPL_STATSHLINE, RPL_STATSNLINE, RPL_STATSKLINE, RPL_STATSLLINE,
     RPL_UPTIME, RPL_STATSOLINE, RPL_ENDOFSTATS, 0 },
   // LINKS
   { RPL_LINKS, RPL_ENDOFLINKS, 0 },
   // TIME
   { RPL_TIME, 0 },
   // TRACE
   { RPL_TRACECONNECTING, RPL_TRACEUNKNOWN, RPL_TRACEUSER, RPL_TRACESERVICE,
     RPL_TRACECLASS, RPL_TRACEHANDSHAKE, RPL_TRACEOPERATOR, RPL_TRACESERVER,
     RPL_TRACENEWTYPE, 0 },
   // ADMIN
   { RPL_ADMINME, RPL_ADMINLOC2, RPL_ADMINLOC1, RPL_ADMINEMAIL, 0 },
   // INFO
   { RPL_INFO, RPL_ENDOFINFO, 0 },
   // PRIVMSG
   { RPL_AWAY, 0 },
   // NOTICE
   { RPL_AWAY, 0 },
   // WHO
   { RPL_WHOREPLY, RPL_ENDOFWHO, 0 },
   // WHOIS
   { RPL_WHOISUSER, RPL_WHOISCHANNELS, RPL_AWAY, RPL_WHOISIDLE, RPL_ENOFWHOIS,
     RPL_WHOISSERVER, RPL_WHOISOPERATOR, 0 },
   // WHOWAS
   { RPL_WHOWASUSER, RPL_ENDOFWHOWAS, RPL_WHOISSERVER, 0 },
   // AWAY
   { RPL_UNAWAY, RPL_NOAWAY, 0 },
   // REHASH
   { RPL_REHASHING, 0 },
   // SUMMONING
   { RPL_SUMMONING, 0 },
   // USERS
   { RPL_USERSTART, RPL_NOUSERS, RPL_USERS, 0 },
   // ISON
   { RPL_ISON, 0 },
};

enum 
{
   OPER=0, MODE, TOPIC, NAMES, LIST, INVITE, VERSION, STATS, LINKS,
   TIME, TRACE, ADMIN, INFO, PRIVMSG, NOTICE, WHO, WHOIS, WHOWAS, AWAY, REHASH,
   SUMMONING, USERS, ISON
} IrcCommandsRef;

typedef struct
{
   IrcCommandRef  cmdRef;
   char           *cmdName;
   int            *replies;
} IrcCommands

IrcComands cmdList[] =
{
   { OPER, "OPER", pResponseList[OPER] },
   { MODE, "MODE", pResponseList[MODE] },
   { TOPIC, "TOPIC", pResponseList[TOPIC] },
   { NAMES, "NAMES", pResponseList[NAMES] },
   { LIST, "LIST", pResponseList[LIST] },
   { INVITE, "INVITE", pResponseList[INVITE] },
   { VERSION, "VERSION", pResponseList[VERSION] },
   { STATS, "STATS", pResponseList[STATS] },
   { LINKS, "LINKS", pResponseList[LINKS] },
   { TIME, "TIME", pResponseList[TIME] },
   { TRACE, "TRACE", pResponseList[TRACE] },
   { ADMIN, "ADMIN", pResponseList[ADMIN] },
   { INFO, "INFO", pResponseList[INFO] },
   { PRIVMSG, "PRIVMSG", pResponseList[PRIVMSG] },
   { NOTICE, "NOTICE", pResponseList[NOTICE] },
   { WHO, "WHO", pResponseList[WHO] },
   { WHOIS, "WHOIS", pResponseList[WHOIS] },
   { WHOWAS, "WHOWAS", pResponseList[WHOWAS] },
   { AWAY, "AWAY", pResponseList[AWAY] },
   { REHASH, "REHASH", pResponseList[REHASH] },
   { SUMMONING, "SUMMONING", pResponseList[SUMMONING] },
   { USERS, "USERS", pResponseList[USERS] },
   { ISON, "ISON", pResponseList[ISON] }
};

xIrcMsgDispatch::xIrcMsgDispatch(xIrcSocket *p_Socket, QWidget *p_Widget,
                                 const char *p_Slot)
{
   pWidget = p_Widget;
   pSlot = pSlot;
   pSocket = p_Socket;
   dspList.setAutoDelete(TRUE);
   connect(this, SIGNAL(dispatchResponse(xIrcMessage *)), pWidget, pSlot);
}

xIrcMsgDispatch::~xIrcMsgDispatch()
{
   unlink();
}

void xIrcMsgDispatch::dispatchMsg(xIrcSocket *pSocket, QWidget *pWidget, 
                                  const char *pSlot, xIrcMessage *pMsg)
{
   xIrcMsgDispatchEntry *pEnt;
   int accepted;

   connect xIrcSocket
   pEnt = new xIrcMsgDispatchEntry(pWidget, pSlot, pMsg, accepted);
   if (accepted > 0)
      dspList.append(pEntry);
   if (accepted >= 0)
      pSocket->sendIrcServerMessage(pMsg);
   if (accepted <= 0)
      delete pEnt;
}
