/***************************************************************************
**    xIrcMsgQuery.cpp  $Revision: 1.12 $ - $Name: V1-17B $ 
**    Dialog box to ask about Private messages
**
** Copyright (C) 1995, 1996  Joseph Croft <jcroft@unicomp.net>  
** 
** This program is free software; you can redistribute it and/or modify
** it under the terms of the GNU General Public License as published by
** the Free Software Foundation; either version 1, or (at your option)
** any later version.
** 
** This program is distributed in the hope that it will be useful,
** but WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
** GNU General Public License for more details.
** 
** You should have received a copy of the GNU General Public License
** along with this program; if not, write to the Free Software
** Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
**
 ***************************************************************************/
#include <stdio.h>
#include <qfont.h>
#include "xIrcMsgQuery.h"

static int dbg = 0;

xIrcMsgQuery::xIrcMsgQuery(xWidgetResInfo *pPRes, QWidget *pParent, 
                           const char *pName, bool autoDelete) :
               xDialog(wdtRes = new xWidgetResInfo(pPRes, QString("messagedialog"),
                                                   QString("MessageDialog")), 
                       pParent, pName)
{
   setDefPallet(this, wdtRes);
   setDefFont(this, wdtRes);

   initClass(pParent, pName, autoDelete);
}

void xIrcMsgQuery::initClass(QWidget *pParent, const char *pName, bool autoDelete)
{
   if (dbg) fprintf(stdout, "xIrcMsgQuery::initClass():Enter\n");
   if (dbg) fflush(stdout);

   // Appease the compiler warnings
   pParent = pParent;
   pName = pName;
      
   setAcceptFocus(TRUE);   
   deleteFlag = autoDelete;
   
   pHeader = new QLabel(this);
   pHeader->setFont(font());
   pMessage = new QLabel(this);
   pMessage->setFont(font());

   pButtons = new xPshBtnFrame(wdtRes, this);
   pButtons->setFrameStyle(QFrame::Panel | QFrame::Raised);
   pButtons->setAlignment(xALIGN_Horz);
   pButtons->addButton("OK", QDialog::Accepted);
   pButtons->addButton("Cancel", QDialog::Rejected);

//   pHeader->setFont(QFont("helvetica", 12));
   pHeader->setAlignment(AlignCenter);
   
//   pMessage->setFont(QFont("helvetica", 12));
   pMessage->setAlignment(AlignCenter);
   
   addWidget(pMessage);
   addWidget(pHeader);
   addWidget(pButtons);
   setMargins(10, 0);
   setWidgetSpacing(0);
   initFrame();
   
   connect(pButtons, SIGNAL(clicked(int)), this, SLOT(buttonPressed(int)));
   if (dbg) fprintf(stdout, "xIrcMsgQuery::initClass():Exit\n");
   if (dbg) fflush(stdout);   
}

void xIrcMsgQuery::buttonPressed(int results)
{
   xIrcMessage *pMsg;
   
   if (dbg) fprintf(stdout, "xIrcMsgQuery::button pressed():results = %d\n", results);
   if (dbg) fflush(stdout);
   
   pMsg = (results) ? &msg : (xIrcMessage *)NULL;
   if (dbg) fprintf(stdout, "xIrcMsgQuery::button pressed():signaling...\n");
   if (dbg) fflush(stdout);
   
   emit done(pMsg);
   if (deleteFlag)
   {
      disconnect(this);
      delete this;
   }
}

void xIrcMsgQuery::setupQuery(xIrcMessage *pMsg)
{
   QString strTmp;
   
   if (dbg) fprintf(stdout, "xIrcMsgQuery::setupQuery():Enter\n");
   if (dbg) fflush(stdout);
   msg = *pMsg;
   strName = pMsg->srcNick;
   strTmp = pMsg->srcNick;
   setCaption((const char *)strTmp);
   
   strTmp = "Private Message from:";
   strTmp += pMsg->srcNick;
   strTmp += "\nOpen a new frame?";
   pHeader->setText(strTmp);
   pMessage->setText(pMsg->msgStr);
   pHeader->adjustSize();
   pMessage->adjustSize();
   initFrame();
   if (dbg) fprintf(stdout, "xIrcMsgQuery::setupQuery():Exit\n");
   if (dbg) fflush(stdout);   
}

xIrcMsgQuery::~xIrcMsgQuery()
{
   if (dbg) fprintf(stdout, "xIrcMsgQuery::~xIrcMsgQuery():Enter\n");
   if (dbg) fflush(stdout);
   if (pHeader)
      delete pHeader;
   if (pMessage)
      delete pMessage;
   if (pButtons)
      delete pButtons;
   if (dbg) fprintf(stdout, "xIrcMsgQuery::~xIrcMsgQuery():Exit\n");
   if (dbg) fflush(stdout);
}

#include "xIrcMsgQuery.moc"
