.\"
.\" Copyright (c) Mark J. Kilgard, 1996.
.\"
.TH glutVisibilityFunc 3GLUT "3.2" "GLUT" "GLUT"
.SH NAME
glutVisibilityFunc - sets the visibility callback for the current window. 
.SH SYNTAX
.nf
.LP
void glutVisibilityFunc(void (*func)(int state));
.fi
.SH ARGUMENTS
.IP \fIfunc\fP 1i
The new visibility callback function. 
.SH DESCRIPTION
glutVisibilityFunc sets the visibility callback for the current
window. The visibility callback for a window is called when the visibility
of a window changes. The state callback parameter is either
GLUT_NOT_VISIBLE or GLUT_VISIBLE depending on the current
visibility of the window. GLUT_VISIBLE does not distinguish a window
being totally versus partially visible. GLUT_NOT_VISIBLE means no part
of the window is visible, i.e., until the window's visibility changes, all
further rendering to the window is discarded. 

GLUT considers a window visible if any pixel of the window is visible or
any pixel of any descendant window is visible on the screen. 

Passing NULL to glutVisibilityFunc disables the generation of the
visibility callback. 

If the visibility callback for a window is disabled and later re-enabled, the
visibility status of the window is undefined; any change in window
visibility will be reported, that is if you disable a visibility callback and
re-enable the callback, you are guaranteed the next visibility change will
be reported. 
.SH SEE ALSO
glutCreateWindow, glutPopWindow
.SH AUTHOR
Mark J. Kilgard (mjk@sgi.com)
