/*
 **************************************************************************
 *
 * Boot-ROM-Code to load an operating system across a TCP/IP network.
 *
 * Module:  arp.h
 * Purpose: Definitions for implementing the ARP protocol
 * Entries: none
 *
 **************************************************************************
 *
 * Copyright (C) 1995,1996 Gero Kuhlmann <gero@gkminix.han.de>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */


/*
 **************************************************************************
 *
 * ARP timeout in timer ticks when sending a request
 */
#define ARP_TIMEOUT	(15 * 18)	/* Timeout is 15 seconds	*/



/*
 **************************************************************************
 *
 * ARP protocol HARDWARE identifiers:
 */
#define ARPHRD_ETHER 	1		/* Ethernet 10Mbps		*/
#define	ARPHRD_EETHER	2		/* Experimental Ethernet	*/
#define	ARPHRD_AX25	3		/* AX.25 Level 2		*/
#define	ARPHRD_APPLETLK	8		/* APPLEtalk			*/



/*
 **************************************************************************
 *
 * ARP protocol opcodes:
 */
#define	ARPOP_REQUEST	1		/* ARP request			*/
#define	ARPOP_REPLY	2		/* ARP reply			*/



/*
 **************************************************************************
 *
 * Ethernet ARP header:
 */
struct arphdr
{
	unsigned short	ar_hrd;		/* format of hardware address	*/
	unsigned short	ar_pro;		/* format of protocol address	*/
	unsigned char	ar_hln;		/* length of hardware address	*/
	unsigned char	ar_pln;		/* length of protocol address	*/
	unsigned short	ar_op;		/* ARP opcode (command)		*/
	unsigned char	ar_sha[ETH_ALEN];/* sender hardware address	*/
	unsigned long	ar_sip;          /* sender IP address		*/
	unsigned char	ar_tha[ETH_ALEN];/* target hardware address	*/
	unsigned long	ar_tip;          /* target IP address		*/
};



/*
 **************************************************************************
 * 
 * ARP cache structure
 */
struct arp_cache {
	t_ipaddr ipaddr;			/* IP address		*/
	unsigned char hwaddr[ETH_ALEN];		/* hardware address	*/
};

#define ARPNUM 8		/* number of entries in ARP cache	*/



/*
 **************************************************************************
 *
 * Functions in ARP module:
 */

/* Initialize ARP module */
extern int init_arp(void);

/* Resolve IP address and return pointer to hardware address */
extern unsigned char *ip_resolve(t_ipaddr ip);

/* Add a new antry to the ARP cache */
extern void addcache(unsigned char *ha, t_ipaddr ip);

/* Set default gateway */
extern void set_gateway(t_ipaddr gw);

