;*---------------------------------------------------------------------*/
;*    Copyright (c) 1996 by Manuel Serrano. All rights reserved.       */
;*                                                                     */
;*                                     ,--^,                           */
;*                               _ ___/ /|/                            */
;*                           ,;'( )__, ) '                             */
;*                          ;;  //   L__.                              */
;*                          '   \    /  '                              */
;*                               ^   ^                                 */
;*                                                                     */
;*                                                                     */
;*    This program is distributed in the hope that it will be useful.  */
;*    Use and copying of this software and preparation of derivative   */
;*    works based upon this software are permitted, so long as the     */
;*    following conditions are met:                                    */
;*           o credit to the authors is acknowledged following         */
;*             current academic behaviour                              */
;*           o no fees or compensation are charged for use, copies,    */
;*             or access to this software                              */
;*           o this copyright notice is included intact.               */
;*      This software is made available AS IS, and no warranty is made */
;*      about the software or its performance.                         */
;*                                                                     */
;*      Bug descriptions, use reports, comments or suggestions are     */
;*      welcome Send them to                                           */
;*        <Manuel.Serrano@inria.fr>                                    */
;*        Manuel Serrano                                               */
;*        INRIA -- Rocquencourt                                        */
;*        Domaine de Voluceau, BP 105                                  */
;*        78153 Le Chesnay Cedex                                       */
;*        France                                                       */
;*---------------------------------------------------------------------*/


;*=====================================================================*/
;*    serrano/prgm/project/bigloo/comptime1.8/Cfa/tvector.scm          */
;*    -------------------------------------------------------------    */
;*    Author      :  Manuel Serrano                                    */
;*    Creation    :  Wed Apr  5 18:47:23 1995                          */
;*    Last change :  Fri Oct 27 14:05:29 1995 (serrano)                */
;*    -------------------------------------------------------------    */
;*    The `vector->tvector' optimization.                              */
;*=====================================================================*/

;*---------------------------------------------------------------------*/
;*    The module                                                       */
;*---------------------------------------------------------------------*/
(module cfa_tvector
   (include "Tools/trace.sch"
	    "Ast/node.sch"
	    "Type/type.sch"
	    "Cfa/approx.sch"
	    "Tvector/tvector.sch")
   (import  cfa_approx
	    cfa_cache
	    cfa_collect
	    cfa_dead
	    cfa_special
	    cfa_vector
	    ast_dump
	    ast_global
	    ast_sexp
	    ast_build
	    ast_global-definition
	    ast_global-mutation
	    ast_env
	    ast_pragma
	    engine_param
	    inline_inline
	    bivalue_walk
	    globalize_globalize
	    globalize_ast
	    tvector_declare
	    tvector_install
	    type_cache
	    type_env
	    tools_set
	    tools_shape
	    tools_speek)
   (export  (tvector-optimization! <global>*)
	    (add-vector-access!    <ast>)
	    (add-vector!           <ast>)))

;*---------------------------------------------------------------------*/
;*    *vector-list* ...                                                */
;*---------------------------------------------------------------------*/
(define *vector-list* '())

;*---------------------------------------------------------------------*/
;*    add-vector! ...                                                  */
;*---------------------------------------------------------------------*/
(define (add-vector! ast)
   (set! *vector-list* (cons ast *vector-list*)))

;*---------------------------------------------------------------------*/
;*    *vector-access-list* ...                                         */
;*---------------------------------------------------------------------*/
(define *vector-access-list* '())

;*---------------------------------------------------------------------*/
;*    *tvector-marker* ...                                             */
;*---------------------------------------------------------------------*/
(define *tvector-marker* #unspecified)

;*---------------------------------------------------------------------*/
;*    add-vector-access! ...                                           */
;*---------------------------------------------------------------------*/
(define (add-vector-access! ast)
   (set! *vector-access-list* (cons ast *vector-access-list*)))

;*---------------------------------------------------------------------*/
;*    tvector-optimization! ...                                        */
;*---------------------------------------------------------------------*/
(define (tvector-optimization! globals)
   (trace cfa
	  #\Newline "--------------------------------------" #\Newline
	  "tvector-optimization! :" #\Newline)
   (set! *tvector-marker* (gensym 'tvector-marker))
   (let ((tvector (get-tvector)))
      (if (null? tvector)
	  '()
	  (let ((item-types (get-item-types tvector)))
	     (trace (cfa loop) "  item-types: " (shape item-types) #\Newline)
	     ;; for each item-type, we declare a tvector type and we
	     ;; mark the association between the item type and the
	     ;; new tvector type
	     (make-tvectors! item-types)
	     (let ((tvect-defs (make-tvectors-def item-types)))
		(show-tvector tvector)
		;; we set the new types for expressions and we
		;; change the generic vector accesses.
		(change-type-and-accessors!)
		tvect-defs)))))

;*---------------------------------------------------------------------*/
;*    get-tvector ...                                                  */
;*---------------------------------------------------------------------*/
(define (get-tvector)
   (let loop ((vector-list  *vector-list*)
	      (tvector-list '()))
      (if (null? vector-list)
	  tvector-list
	  (let* ((vect   (car vector-list))
		 (approx (get-special-approx vect)))
	     (trace cfa
		    "  " (ast->sexp vect)
		    " : " (if (approx? approx)
			      (approx-shape approx)
			      #f))
	     (if (not (approx? approx))
		 (loop (cdr vector-list) tvector-list)
		 (let ((type (set->list (approx-type approx))))
		    ;; type locked approximation can be found in, for instance,
		    ;; exported (or used before initialized) global variables.
		    ;; These approximated values can't be replaced by typed
		    ;; vectors, because we are not allowed to change
		    ;; their types.
		    (if (and (not (approx-type-locked? approx))
			     (pair? type)
			     (null? (cdr type))
			     (not (sub-obj-type? (car type))))
			;; ok, we got a typed vector
			(begin
			   (trace cfa "   [typable]" #\Newline)
			   (mark-typable-vector! vect (car type))
			   (loop (cdr vector-list) (cons vect tvector-list)))
			(begin
			   (trace cfa "   [non typable]" #\Newline)
			   (mark-non-typable-vector! vect)
			   (loop (cdr vector-list) tvector-list)))))))))

;*---------------------------------------------------------------------*/
;*    get-tvector-item-type ...                                        */
;*---------------------------------------------------------------------*/
(define (get-tvector-item-type vect)
   (app-tvector-info vect))

;*---------------------------------------------------------------------*/
;*    set-tvector-item-type! ...                                       */
;*---------------------------------------------------------------------*/
(define (set-tvector-item-type! vect type)
   (app-tvector-info-set! vect type))

;*---------------------------------------------------------------------*/
;*    mark-typable-vector! ...                                         */
;*---------------------------------------------------------------------*/
(define (mark-typable-vector! vect type)
   (set-tvector-item-type! vect type))

;*---------------------------------------------------------------------*/
;*    mark-non-typable-vector! ...                                     */
;*---------------------------------------------------------------------*/
(define (mark-non-typable-vector! vect)
   (trace (cfa loop) "*** mark-non-typable-vector! ***: "
	  (shape vect) #\Newline)
   (set-tvector-item-type! vect #f))
   
;*---------------------------------------------------------------------*/
;*    marked-typable-vector? ...                                       */
;*---------------------------------------------------------------------*/
(define (marked-typable-vector? vect)
   (type? (get-tvector-item-type vect)))

;*---------------------------------------------------------------------*/
;*    typable-access? ...                                              */
;*---------------------------------------------------------------------*/
(define (typable-access? access)
   (let ((A (get-approx (car (app-actuals access)))))
      (cond
	 ((=fx (set-length (approx-alloc A)) 0)
	  #f)
	 (else
	  (let ((alloc (set->list (approx-alloc A))))
	     (cond
		((and (not (is-vector-alloc? (car alloc)))
		      (not (is-tvector-alloc? (car alloc))))
		 #f)
		(else
		 (marked-typable-vector? (car alloc)))))))))

;*---------------------------------------------------------------------*/
;*    get-tvector-access-item-type ...                                 */
;*---------------------------------------------------------------------*/
(define (get-tvector-access-item-type access)
   (let* ((vect-a (get-approx (car (app-actuals access))))
	  (alloc  (set->list (approx-alloc vect-a))))
      (get-tvector-item-type (car alloc))))

;*---------------------------------------------------------------------*/
;*    get-item-types ...                                               */
;*---------------------------------------------------------------------*/
(define (get-item-types tvector)
   (let loop ((tvector tvector)
	      (types   '()))
      (cond
	 ((null? tvector)
	  types)
	 ((memq (get-tvector-item-type (car tvector)) types)
	  (loop (cdr tvector)
		types))
	 (else
	  (loop (cdr tvector)
		(cons (get-tvector-item-type (car tvector)) types))))))

;* {*---------------------------------------------------------------------*} */
;* {*    mark-typable-access! ...                                         *} */
;* {*---------------------------------------------------------------------*} */
;* (define (mark-typable-access! access type)                          */
;*    (trace (cfa loop) "mark-typable-access!: " (ast->sexp access)    */
;* 	  (shape type) #\Newline)                                      */
;*    (set-tvector-item-type! access type))                             */
;*                                                                     */
;* {*---------------------------------------------------------------------*} */
;* {*    mark-non-typable-access! ...                                     *} */
;* {*---------------------------------------------------------------------*} */
;* (define (mark-non-typable-access! access)                           */
;*    (trace (cfa loop) "mark-non-typable-access!: " (ast->sexp access) */
;* 	  #\Newline)                                                   */
;*    (set-tvector-item-type! access #f))                               */

;*---------------------------------------------------------------------*/
;*    make-tvectors! ...                                               */
;*---------------------------------------------------------------------*/
(define (make-tvectors! items)
   (for-each (lambda (item)
		(let* ((item-id (type-id item))
		       (tvec-id (gensym (symbol-append 'tv-of- item-id)))
		       (tvec    (declare-tvector-type! tvec-id
						       item-id
						       'cfa-type)))
		   (type-cfa-info-set! item tvec)
		   tvec))
	     items))

;*---------------------------------------------------------------------*/
;*    make-tvectors-def ...                                            */
;*---------------------------------------------------------------------*/
(define (make-tvectors-def item)
   (let* ((verbose    *verbose*)
	  (tvect-decl (require-global 'tvectors-declarations!
				      *module-name*
				      #f))
	  (tvect-fun  (global-value tvect-decl)))
      (set! *verbose* 0)
      (let loop ((item item)
		 (defs '()))
	 (if (null? item)
	     (begin
		(set! *verbose* verbose)
		defs) 
	     (let* ((tvec  (type-cfa-info (car item)))
		    (sexps (install-tvector-accessors tvec))
		    (asts  (begin
			      (find-and-check-globals! sexps)
			      (find-and-check-mutations! sexps '())
			      (let loop ((sexps sexps)
					 (ast   '()))
				 (if (null? sexps)
				     ast
				     (loop (cdr sexps)
					   (append (toplevel->ast (car sexps))
						   ast))))))
		    (info (type-tinfo tvec))
		    (sexp `(set! ,(tvector-info-descr info)
				 (declare-tvector!
				  ,(symbol->string (type-id tvec))
				  ,(tvector-info-allocate info)
				  ,(tvector-info-ref info)
				  ,(tvector-info-set! info))))
		    (ast  (sexp->ast sexp
				     '()
				     (global-name tvect-decl)
				     #f
				     'read))
		    (ast-b (bivalue! ast))
		    (ast-g (ast-globalize! ast-b tvect-decl '()))
		    (body (function-body tvect-fun)))
		(function-body-set! tvect-fun
				    (ast-sequence #f
						  #f
						  #f
						  (list ast-g body)))
		;; the bivaluation
		(for-each (lambda (ast)
			     (if (global? ast)
				 (let* ((fun  (global-value ast))
					(body (function-body fun)))
				    (function-body-set! fun (bivalue! body)))))
			  asts)
		;; the globalization
		(let liip ((asts asts)
			   (new  defs))
		   (cond
		      ((null? asts)
		       (loop (cdr item) new))
		      ((not (global? (car asts)))
		       (liip (cdr asts)
			     new))
		      (else
		       (liip (cdr asts)
			     (append (globalize! (car asts)) new))))))))))
	     
;*---------------------------------------------------------------------*/
;*    show-tvector ...                                                 */
;*---------------------------------------------------------------------*/
(define (show-tvector tvector-list)
   (verbose 2 "           tvector: " #\newline)
   (for-each
    (lambda (ast)
       (verbose 2
		"              vector of " (shape *obj*)
		" -> vector of "
		(shape (get-tvector-item-type ast))
		#\Newline))
    tvector-list))

;*---------------------------------------------------------------------*/
;*    is-a-typable-vector? ...                                         */
;*---------------------------------------------------------------------*/
(define (is-a-typable-vector? node)
   (let ((approx (get-approx node)))
      (and (approx? approx)
	   (let* ((type   (set->list (approx-type approx)))
		  (alloc  (set->list (approx-alloc approx))))
	      (and (match-case type
		      ((?type)
		       (eq? type *vector*))
		      (else
		       #f))
		   (pair? alloc)
		   (or (is-vector-alloc? (car alloc))
		       (is-tvector-alloc? (car alloc)))
		   (marked-typable-vector? (car alloc)))))))

;*---------------------------------------------------------------------*/
;*    trace-why-not-typable-vector ...                                 */
;*---------------------------------------------------------------------*/
(define (trace-why-not-typable-vector node)
   (trace (cfa loop init) "NOT TYPABLE VECTOR: " (shape node) " because ...")
   (let ((approx (get-approx node)))
      (trace (cfa loop init) 
	     (if (not (approx? approx))
		 "  not approx"
		 (let* ((type   (set->list (approx-type approx)))
			(alloc  (set->list (approx-alloc approx))))
		    (if (not (match-case type
				((?type)
				 (eq? type *vector*))
				(else
				 #f)))
			" not a vector"
			(if (not (pair? alloc))
			    " not pair alloc"
			    (if (and (not (is-vector-alloc? (car alloc)))
				     (not (is-tvector-alloc? (car alloc))))
				" not a vector allocation"
				" not mared typable vector")))))
	     #\Newline)))

;*---------------------------------------------------------------------*/
;*    get-tvector-type/node ...                                        */
;*---------------------------------------------------------------------*/
(define (get-tvector-type/node node)
   (let* ((approx (get-approx node))
	  (v-app  (car (set->list (approx-alloc approx)))))
      (type-cfa-info (app-tvector-info v-app))))

;*---------------------------------------------------------------------*/
;*    is-tvector-alloc? ...                                            */
;*    -------------------------------------------------------------    */
;*    This is really horrible. We use in this optimization the         */
;*    field `app-stack-info' which should have been used only          */
;*    in stack optimization. This field is just a simple marker.       */
;*---------------------------------------------------------------------*/
(define (is-tvector-alloc? app)
   [assert check (app) (app? app)]
   (eq? (app-stack-info app) *tvector-marker*))

;*---------------------------------------------------------------------*/
;*    change-type-and-accessors! ...                                   */
;*    -------------------------------------------------------------    */
;*    This function affect types to all programs variables (i.e.       */
;*    global variables, local variables, function bodies) according    */
;*    to cfa approximations.                                           */
;*---------------------------------------------------------------------*/
(define (change-type-and-accessors!)
   (trace (cfa loop init) "change-type-and-accessors!: " #\Newline)
   ;; first of all, we affect global variable types
   (for-each-global!
    (lambda (global)
       (cond
	  ((and (not (eq? (global-import global) 'static))
		(not (eq? (global-import global) 'export)))
	   (trace (cfa loop init) (shape global) " [not local]" #\Newline)
	   'nothing-to-do)
	  ((eq? (global-class global) 'variable)
	   (trace (cfa loop init) (shape global) " [variable] ..." )
	   (if (is-a-typable-vector? global)
	       (begin
		  (trace (cfa loop init) "typable" " "
			 (shape (get-tvector-type/node global))
			 #\Newline)
		  (global-type-set! global (get-tvector-type/node global)))
	       (begin
		  (trace (cfa loop init) "not typable" #\Newline
			 "             "
			 (if (approx? (get-approx global))
			     (approx-shape (get-approx global))
			     "no approx")
			 #\Newline)
		  (trace-why-not-typable-vector global))))
	  (else
	   'noting-to-do))))
   ;; then we iterate on functions
   (for-each-global!
    (lambda (global)
       (cond
	  ((and (not (eq? (global-import global) 'static))
		(not (eq? (global-import global) 'export)))
	   'nothing-to-do)
	  ((eq? (global-class global) 'sprocedure)
	   (trace (cfa loop init) (shape global) " [sprocedure]" #\Newline)
	   'nothing-to-do)
	  ((or (eq? (global-class global) 'procedure)
	       (eq? (global-class global) 'inline))
	   (if (not (alive-function? global))
	       (trace (cfa loop init) (shape global) " [dead-function]" 
		      #\Newline)
	       (begin
		  (trace (cfa loop init) (shape global) " [function]" 
			 #\Newline)
		  (change-type-and-accessors/function! global))))))))

;*---------------------------------------------------------------------*/
;*    change-type-and-accessors/function! ...                          */
;*---------------------------------------------------------------------*/
(define (change-type-and-accessors/function! var)
   (let ((fun (variable-value var)))
      (if (is-a-typable-vector? var)
	  (function-type-res-set! fun (get-tvector-type/node var)))
      (for-each (lambda (l)
		   (if (is-a-typable-vector? l)
		       (local-type-set! l (get-tvector-type/node l))))
		(function-args fun))
      (change-type-and-accessors/ast! (function-body fun))))

;*---------------------------------------------------------------------*/
;*    change-type-and-accessors/ast! ...                               */
;*---------------------------------------------------------------------*/
(define (change-type-and-accessors/ast! ast)
   (let loop ((ast ast))
      (trace (cfa loop) "change-type-and-accessors/ast!: "
	     (ast->sexp ast)
	     #\Newline)
      (ast-case ast
	 ((atom)
	  ast)
	 ((kwote)
	  (if (and (ast? (kwote-cfa-info ast))
		   (marked-typable-vector? (kwote-cfa-info ast)))
	      (change-kvector! ast)
	      ast))
	 ((var)
	  ast)
	 ((fun)
	  (internal-error "change-type-and-accessors/ast!"
			  "Illegal node found (fun node)"
			  (ast->sexp ast)))
	 ((prag-ma)
	  (let liip ((values (prag-ma-values ast)))
	     (if (null? values)
		 ast
		 (begin
		    (set-car! values (loop (car values)))
		    (liip (cdr values))))))
	 ((fail)
	  (fail-proc-set! ast (loop (fail-proc ast)))
	  (fail-msg-set! ast (loop (fail-msg ast)))
	  (fail-obj-set! ast (loop (fail-obj ast)))
	  ast)
	 ((sequence)
	  (let liip ((exp (sequence-exp ast)))
	     (if (null? exp)
		 ast
		 (begin
		    (set-car! exp (loop (car exp)))
		    (liip (cdr exp))))))
	 ((conditional)
	  (conditional-test-set! ast (loop (conditional-test ast)))
	  (conditional-then-set! ast (loop (conditional-then ast)))
	  (conditional-else-set! ast (loop (conditional-else ast)))
	  ast)
	 ((switch)
	  (switch-test-set! ast (loop (switch-test ast)))
	  (for-each (lambda (clause)
		       (set-cdr! clause (loop (cdr clause))))
		    (switch-clauses ast))
	  ast)
	 ((setq)
	  (setq-val-set! ast (loop (setq-val ast)))
	  ast)
	 ((let-var)
	  (for-each (lambda (binding)
		       (let ((l (car binding)))
			  (if (is-a-typable-vector? l)
			      (local-type-set! l (get-tvector-type/node l))))
 		       (set-cdr! binding (loop (cdr binding))))
		    (let-var-bindings ast))
	  (let-var-body-set! ast (loop (let-var-body ast)))
	  ast)
	 ((let-fun)
	  (for-each change-type-and-accessors/function! (let-fun-locals ast))
	  (let-fun-body-set! ast (loop (let-fun-body ast)))
	  ast)
	 ((set-ex-it)
	  (set-ex-it-body-set! ast (loop (set-ex-it-body ast)))
	  ast)
	 ((jump-ex-it)
	  (jump-ex-it-exit-set! ast (loop (jump-ex-it-exit ast)))
	  (jump-ex-it-value-set! ast (loop (jump-ex-it-value ast)))
	  ast)
	 ((app-ly)
	  (app-ly-fun-set! ast (loop (app-ly-fun ast)))
	  (app-ly-value-set! ast (loop (app-ly-value ast)))
	  ast)
	 ((funcall)
	  (funcall-fun-set! ast (loop (funcall-fun ast)))
	  (let liip ((actuals (funcall-actuals ast)))
	     (if (null? actuals)
		 ast
		 (begin
		    (set-car! actuals (loop (car actuals)))
		    (liip (cdr actuals))))))
	 ((make-box)
	  (make-box-value-set! ast (loop (make-box-value ast)))
	  ast)
	 ((box-ref)
	  ast)
	 ((box-set!)
	  (box-set!-value-set! ast (loop (box-set!-value ast)))
	  ast)
	 ((app)
	  (let liip ((actuals (app-actuals ast)))
	     (if (null? actuals)
		 ast
		 (begin
		    (set-car! actuals (loop (car actuals)))
		    (liip (cdr actuals)))))
	  (cond
	     ((is-vector-access? ast)
	      (change-vector-access! ast))
	     ((is-vector-alloc? ast)
	      (change-vector-alloc! ast))
	     (else
	      ast))))))

;*---------------------------------------------------------------------*/
;*    is-vector-access? ...                                            */
;*---------------------------------------------------------------------*/
(define (is-vector-access? app)
   (let ((fun (var-variable (app-fun app))))
      (cond
	 ((eq? fun *vector-ref*)
	  #t)
	 ((eq? fun *vector-set!*)
	  #t)
	 ((eq? fun *vector-length*)
	  #t)
	 (else
	  #f))))

;*---------------------------------------------------------------------*/
;*    change-vector-alloc! ...                                         */
;*---------------------------------------------------------------------*/
(define (change-vector-alloc! app)
   (trace (cfa loop)
	  "***> change-vector-alloc!: " (ast->sexp app) #\:)
   (let ((fun (var-variable (app-fun app))))
      (cond
	 ((eq? fun *make-vector*)
	  (if (marked-typable-vector? app)
	      (let* ((type (type-cfa-info (get-tvector-item-type app)))
		     (al   (find-global (tvector-info-make
					 (type-tinfo type)))))
		 (trace (cfa loop) "[make-vector -> tmake-vector]" #\Newline)
		 (trace (cfa loop)
			"                   type: " (shape type) #\Newline)
		 (var-variable-set! (app-fun app) al)
		 (app-stack-info-set! app *tvector-marker*)
		 (inline-ast app 1000 '()))
	      (begin
		 (trace (cfa loop) "[not tvector]" #\Newline)
		 app)))
	 ((eq? fun *make-s-vector*)
	  (if (marked-typable-vector? app)
	      (let* ((type (type-cfa-info (get-tvector-item-type app)))
		     (al   (find-global (tvector-info-make-s
					 (type-tinfo type)))))
		 (trace (cfa loop) "[make-s-vector -> tmake-s-vector]"
			#\Newline)
		 (trace (cfa loop)
			"                   type: " (shape type) #\Newline)
		 (var-variable-set! (app-fun app) al)
		 (app-stack-info-set! app *tvector-marker*)
		 (inline-ast app 1000 '()))
	      (begin
		 (trace (cfa loop) "[not tvector]" #\Newline)
		 app)))
	 ((eq? fun *create-vector*)
	  (if (marked-typable-vector? app)
	      (let* ((type (type-cfa-info (get-tvector-item-type app)))
		     (al   (find-global (tvector-info-allocate
					 (type-tinfo type)))))
		 (trace (cfa loop) "[create-vector->alloc-tvector]" #\Newline)
		 (trace (cfa loop)
			"                   type: " (shape type) #\Newline)
		 (app-stack-info-set! app *tvector-marker*)
		 (var-variable-set! (app-fun app) al)
		 (inline-ast app 1000 '()))
	      (begin
		 (trace (cfa loop) "[not tvector]" #\Newline)
		 app)))
	 ((eq? fun *create-s-vector*)
	  (if (marked-typable-vector? app)
	      (let* ((type (type-cfa-info (get-tvector-item-type app)))
		     (al   (find-global (tvector-info-allocate-s
					 (type-tinfo type)))))
		 (trace (cfa loop) "[create-s-vector->alloc-s-tvector]"
			#\Newline)
		 (trace (cfa loop)
			"                   type: " (shape type) #\Newline)
		 (app-stack-info-set! app *tvector-marker*)
		 (var-variable-set! (app-fun app) al)
		 (inline-ast app 1000 '()))
	      (begin
		 (trace (cfa loop) "[not tvector]" #\Newline)
		 app)))
	 (else
	  (internal-error "change-vector-alloc!"
			  "Unknown vector allocation"
			  (ast->sexp app))))))

;*---------------------------------------------------------------------*/
;*    change-vector-access! ...                                        */
;*---------------------------------------------------------------------*/
(define (change-vector-access! app)
   (trace (cfa loop)
	  "***> change-vector-access!: " (ast->sexp app) #\:)
   (if (not (typable-access? app))
       (begin
	  (trace (cfa loop) " [not typable]" #\Newline)
	  app)
       (let* ((fun       (var-variable (app-fun app)))
	      (type-item (get-tvector-access-item-type app))
	      (type      (type-cfa-info type-item)))
	  (trace (cfa loop) "[typable:" (shape type) "]" #\Newline)
	  (cond
	     ((eq? fun *vector-ref*)
	      (var-variable-set! (app-fun app)
				 (find-global
				  (tvector-info-tv-ref (type-tinfo type))))
	      (inline-ast app 1000 '()))
	     ((eq? fun *vector-set!*)
	      (var-variable-set! (app-fun app)
				 (find-global
				  (tvector-info-tv-set! (type-tinfo type))))
	      (inline-ast app 1000 '()))
	     ((eq? fun *vector-length*)
	      (var-variable-set! (app-fun app) *tvector-length*)
	      (inline-ast app 1000 '()))
	     (else
	      (internal-error "change-vector-access!"
			      "Not a vector access"
			      (ast->sexp app)))))))
		    
;*---------------------------------------------------------------------*/
;*    change-kvectors! ...                                             */
;*---------------------------------------------------------------------*/
(define (change-kvector! kvect)
   (trace (cfa loop)
	  "***> change-kvector-alloc!: " (ast->sexp kvect) #\:)
   (let* ((app (kwote-cfa-info kvect))
	  (type (type-cfa-info (get-tvector-item-type app))))
      (kwote-value-set! kvect (a-tvector type (kwote-value kvect)))
      (kwote-type-set!  kvect type)
      ;; we need to change the function called in the dummy app
      ;; because this value is use to set the type of the expression
      (change-vector-alloc! app)
      kvect))





   
