;*---------------------------------------------------------------------*/
;*    Copyright (c) 1996 by Manuel Serrano. All rights reserved.       */
;*                                                                     */
;*                                     ,--^,                           */
;*                               _ ___/ /|/                            */
;*                           ,;'( )__, ) '                             */
;*                          ;;  //   L__.                              */
;*                          '   \    /  '                              */
;*                               ^   ^                                 */
;*                                                                     */
;*                                                                     */
;*    This program is distributed in the hope that it will be useful.  */
;*    Use and copying of this software and preparation of derivative   */
;*    works based upon this software are permitted, so long as the     */
;*    following conditions are met:                                    */
;*           o credit to the authors is acknowledged following         */
;*             current academic behaviour                              */
;*           o no fees or compensation are charged for use, copies,    */
;*             or access to this software                              */
;*           o this copyright notice is included intact.               */
;*      This software is made available AS IS, and no warranty is made */
;*      about the software or its performance.                         */
;*                                                                     */
;*      Bug descriptions, use reports, comments or suggestions are     */
;*      welcome Send them to                                           */
;*        <Manuel.Serrano@inria.fr>                                    */
;*        Manuel Serrano                                               */
;*        INRIA -- Rocquencourt                                        */
;*        Domaine de Voluceau, BP 105                                  */
;*        78153 Le Chesnay Cedex                                       */
;*        France                                                       */
;*---------------------------------------------------------------------*/


;*=====================================================================*/
;*    serrano/prgm/project/bigloo/comptime1.8/Cnst/alloc.scm           */
;*    -------------------------------------------------------------    */
;*    Author      :  Manuel Serrano                                    */
;*    Creation    :  Mon Feb  6 13:51:36 1995                          */
;*    Last change :  Wed Sep  6 13:26:38 1995 (serrano)                */
;*    -------------------------------------------------------------    */
;*    The constant allocations.                                        */
;*=====================================================================*/
    
;*---------------------------------------------------------------------*/
;*    The module                                                       */
;*---------------------------------------------------------------------*/
(module cnst_alloc
   (include "Ast/node.sch"
	    "Tvector/tvector.sch") ;; a supprimer apres le bootstrap
   (import  ast_global
	    ast_sexp
	    ast_dump
	    engine_param
	    parse_definition
	    type_cache
	    coerce_coerce
	    tvector_cnst
	    tools_shape
	    cnst_cache
	    cnst_ast)
   (export  (start-cnst-alloc!)
	    (stop-cnst-alloc!)
	    (get-cnst-offset)
	    (get-cnst-set)
	    (get-cnst-ast)
	    (get-cnst-table)
	    (cnst-table-name)
	    (cnst-alloc-string    <string>    <loc>)
	    (cnst-alloc-symbol    <symbol>    <loc>)
	    (cnst-alloc-procedure <procedure> <loc>)
	    (cnst-alloc-real      <real>      <loc>)
	    (cnst-alloc-list      <list>      <loc>)
	    (cnst-alloc-vector    <vector>    <loc>)
	    (cnst-alloc-tvector   <tvector>   <loc>)))

;*---------------------------------------------------------------------*/
;*    structures                                                       */
;*---------------------------------------------------------------------*/
(define-struct cnst-info      cnst offset)
(define-struct procedure-info proc variable)

;*---------------------------------------------------------------------*/
;*    *cnst-table* ...                                                 */
;*---------------------------------------------------------------------*/
(define *cnst-table*      #unspecified)
(define *cnst-offset*     -1)

;*---------------------------------------------------------------------*/
;*    get-cnst-offset ...                                              */
;*---------------------------------------------------------------------*/
(define (get-cnst-offset)
   *cnst-offset*)

;*---------------------------------------------------------------------*/
;*    get-cnst-set ...                                                 */
;*---------------------------------------------------------------------*/
(define (get-cnst-set)
   *global-set*)

;*---------------------------------------------------------------------*/
;*    get-cnst-table ...                                               */
;*---------------------------------------------------------------------*/
(define (get-cnst-table)
   *cnst-table*)

;*---------------------------------------------------------------------*/
;*    get-cnst-ast ...                                                 */
;*---------------------------------------------------------------------*/
(define (get-cnst-ast)
   (reverse! *global-ast*))

;*---------------------------------------------------------------------*/
;*    cnst-info-create ...                                             */
;*---------------------------------------------------------------------*/
(define (cnst-info-create cnst)
   (let ((new (make-cnst-info)))
      (cnst-info-cnst-set! new cnst)
      new))

;*---------------------------------------------------------------------*/
;*    The local hash-tables                                            */
;*---------------------------------------------------------------------*/
(define *string-env*    '())
(define *real-env*      '())
(define *symbol-env*    '())
(define *list-env*      '())
(define *vector-env*    '())
(define *global-set*    '())
(define *global-ast*    '())

;*---------------------------------------------------------------------*/
;*    *old-debug*                                                      */
;*---------------------------------------------------------------------*/
(define *old-debug* #unspecified)

;*---------------------------------------------------------------------*/
;*    cnst-table-name ...                                              */
;*---------------------------------------------------------------------*/
(define (cnst-table-name)
   '__CNSTS_TABLE)

;*---------------------------------------------------------------------*/
;*    start-cnst-alloc! ...                                            */
;*---------------------------------------------------------------------*/
(define (start-cnst-alloc!)
   (set! *old-debug* *compiler-debug*)
   ;; this pass use the sexp->ast construction which can
   ;; introduce `trace' expression when the variable *compiler-debug* is #t.
   ;; In order to avoid this, we force it to #f
   (set! *compiler-debug* 0)
   (set! *cnst-table* (declare-global-variable! 'static
						*module-name*
						'variable
						(parse-formal-ident
						 `(:: ,(cnst-table-name) cnst*))))
   (set! *cnst-offset* 0)
   (set! *string-env* (make-hash-table 1024
				       (lambda (s) (string->0..2^x-1 s 10))
				       cnst-info-cnst
				       string=?))
   (set! *real-env*   '())
   (set! *symbol-env* (make-hash-table 1024
				       (lambda (s) (string->0..2^x-1
						    (symbol->string s)
						    10))
				       cnst-info-cnst
				       eq?))
   #t)

;*---------------------------------------------------------------------*/
;*    stop-cnst-alloc! ...                                             */
;*---------------------------------------------------------------------*/
(define (stop-cnst-alloc!)
   (set! *compiler-debug* *old-debug*)
   (set! *string-env* #unspecified)
   (set! *real-env*   #unspecified) 
   (set! *symbol-env* #unspecified)
   (set! *list-env*   #unspecified) 
   (set! *vector-env* #unspecified) 
   #t)

;*---------------------------------------------------------------------*/
;*    make-cnst-table-ref ...                                          */
;*---------------------------------------------------------------------*/
(define (make-cnst-table-ref offset loc)
   (ast-app loc
	    #f
	    #f
	    (ast-var loc #f #f *cnst-table-ref*)
	    (list (ast-atom loc #f #f offset))
	    #f
	    #f
	    #f
	    #f))
	 
;*---------------------------------------------------------------------*/
;*    cnst-alloc-string ...                                            */
;*    -------------------------------------------------------------    */
;*    Strings can't be allocated via the reader because we use         */
;*    the string constant compilation to create the                    */
;*    input-string-port !                                              */
;*---------------------------------------------------------------------*/
(define (cnst-alloc-string string loc)
   (define (alloc-string)
      ;; in lib-mode string are statically allocated
      (let ((var (declare-global-variable! 'static
					   *module-name*
					   'sstring
					   (parse-formal-ident
					    (symbol-append
					     (gensym 'string)
					     '::bstring)))))
	 (global-value-set! var string)
	 (global-occurrence-set! var 1)
	 (if *shared-cnst?*
	     (put-hash! (cnst-info string var) *string-env*))
	 (ast-var loc #f #f var)))
   (let ((old (and *shared-cnst?* (get-hash string *string-env*))))
      (cond
	 (old
	  (ast-var loc #f #f (cnst-info-offset old)))
	 (else
	  (alloc-string)))))

;*---------------------------------------------------------------------*/
;*    cnst-alloc-symbol ...                                            */
;*---------------------------------------------------------------------*/
(define (cnst-alloc-symbol symbol loc)
   (define (lib-alloc-symbol)
      (let ((var (declare-global-variable! 'static
					   *module-name*
					   'variable
					   (parse-formal-ident
					    (gensym 'symbol)))))
	 (use-global! *string->symbol*)
	 (put-hash! (cnst-info symbol var) *symbol-env*)
	 (set! *global-ast*
	       (cons (ast-setq loc
			       #f
			       #f
			       (ast-var loc #f #f var)
			       (ast-app loc
					#f
					#f 
					(ast-var loc #f #f *string->symbol*)
					(list (ast-atom
					       loc
					       #f
					       #f
					       (symbol->string symbol)))
					#f
					#f
					#f
					#f))
		     *global-ast*))
	 (ast-var loc #f #f var)))
   (define (read-alloc-symbol)
      (let ((offset *cnst-offset*))
	 (set! *cnst-offset* (+fx 1 *cnst-offset*))
	 (set! *global-set* (cons symbol *global-set*))
	 (put-hash! (cnst-info symbol offset) *symbol-env*)
	 (make-cnst-table-ref offset loc)))
   (let ((old (get-hash symbol *symbol-env*))
	 (symbol-as-string (symbol->string symbol)))
      (cond
	 (old
	  (if (eq? *init-mode* 'lib)
	      (ast-var loc #f #f (cnst-info-offset old))
	      (make-cnst-table-ref (cnst-info-offset old) loc)))
	 ((or (eq? *init-mode* 'lib)
	      (=fx (string-length symbol-as-string) 0)
	      (char=? (string-ref symbol-as-string 0) #\;))
	  (lib-alloc-symbol))
	 (else
	  (read-alloc-symbol)))))

;*---------------------------------------------------------------------*/
;*    cnst-alloc-procedure ...                                         */
;*---------------------------------------------------------------------*/
(define (cnst-alloc-procedure procedure loc)
   (let ((var (declare-global-variable! 'static
					*module-name*
					'sprocedure
					(parse-formal-ident
					 (symbol-append (gensym 'lambda)
							'::procedure)))))
      (global-value-set! var procedure)
      (global-occurrence-set! var 1)
      (ast-var loc #f #f var)))

;*---------------------------------------------------------------------*/
;*    cnst-alloc-real ...                                              */
;*---------------------------------------------------------------------*/
(define (cnst-alloc-real real loc)
   (define (lib-alloc-real)
      (let ((var (declare-global-variable! 'static
					   *module-name*
					   'sreal
					   (parse-formal-ident
					    (symbol-append
					     (gensym 'real)
					     '::real)))))
	 (global-value-set! var real)
	 (global-occurrence-set! var 1)
	 (set! *real-env* (cons (cons real var) *real-env*))
	 (ast-var loc #f #f var)))
   (define (find-real)
      (let loop ((list *real-env*))
	 (cond
	    ((null? list)
	     #f)
	    ((=fl (car (car list)) real)
	     (cdr (car list)))
	    (else
	     (loop (cdr list))))))
   (let ((old (find-real)))
      (cond
	 (old
	  (ast-var loc #f #f old))
	 (else
	  (lib-alloc-real)))))

;*---------------------------------------------------------------------*/
;*    cnst-alloc-list ...                                              */
;*---------------------------------------------------------------------*/
(define (cnst-alloc-list pair loc)
   (define (cnst-list pair)
      (let loop ((pair pair))
	 (cond
	    ((null? pair)
	     (ast-atom loc #f #f '()))
	    ((not (pair? pair))
	     (cnst-quote (ast-kwote #f #f #f pair #f)))
	    (else
	     (ast-app loc
		      #f
		      #f
		      (ast-var loc #f #f *cons*)
		      (list
		       (cnst-quote (ast-kwote #f #f #f (car pair) #f))
		       (loop (cdr pair)))
		      #f
		      #f
		      #f
		      #f)))))
   (define (lib-alloc-list)
      (let ((var (declare-global-variable! 'static
					   *module-name*
					   'variable
					   (parse-formal-ident
					    (gensym 'list)))))
	 (if *shared-cnst?*
	     (set! *list-env* (cons (cnst-info pair var) *list-env*)))
	 (let ((setq (ast-setq loc
			       #f
			       #f
			       (ast-var loc #f #f var)
			       (coerce! (cnst-list pair) *obj*))))
	    ;; the setq computation can modify *global-ast*, then
	    ;; to force the evaluation order we nest it into a let
	    ;; construction.
	    (set! *global-ast* (cons setq *global-ast*)))
	 (ast-var loc #f #f var)))
   (define (read-alloc-list)
      (let ((offset *cnst-offset*))
	 (set! *cnst-offset* (+fx 1 *cnst-offset*))
	 (set! *global-set* (cons pair *global-set*))
	 (if *shared-cnst?*
	     (set! *list-env* (cons (cnst-info pair offset) *list-env*)))
	 (make-cnst-table-ref offset loc)))
   (let ((old (and *shared-cnst?*
		   (let loop ((env *list-env*))
		      (cond
			 ((null? env)
			  #f)
			 ((equal? (cnst-info-cnst (car env)) pair)
			  (car env))
			 (else
			  (loop (cdr env))))))))
      (cond
	 (old
	  (if (eq? *init-mode* 'lib)
	      (ast-var loc #f #f (cnst-info-offset old))
	      (make-cnst-table-ref (cnst-info-offset old) loc)))
	 ((eq? *init-mode* 'lib)
	  (lib-alloc-list))
	 (else
	  (read-alloc-list)))))

;*---------------------------------------------------------------------*/
;*    cnst-alloc-vector ...                                            */
;*---------------------------------------------------------------------*/
(define (cnst-alloc-vector vec loc)
   (define (lib-alloc-vector)
      (cnst (coerce! (sexp->ast `(let ((vec (list->vector
					     ',(vector->list vec))))
				    (vector-tag-set! vec ,(vector-tag vec))
				    vec)
				'()
				#f
				loc
				'read)
		     *obj*)))
   (define (read-alloc-vector)
      (let ((offset *cnst-offset*))
	 (set! *cnst-offset* (+fx 1 *cnst-offset*))
	 (set! *global-set* (cons vec *global-set*))
	 (if *shared-cnst?*
	     (set! *vector-env* (cons (cnst-info vec offset) *vector-env*)))
	 (make-cnst-table-ref offset loc)))
   (let ((old (and *shared-cnst?*
		   (let loop ((env *vector-env*))
		      (cond
			 ((null? env)
			  #f)
			 ((equal? (cnst-info-cnst (car env)) vec)
			  (car env))
			 (else
			  (loop (cdr env))))))))
      (cond
	 (old
	  (if (eq? *init-mode* 'lib)
	      (ast-var loc #f #f (cnst-info-offset old))
	      (make-cnst-table-ref (cnst-info-offset old) loc)))
	 ((eq? *init-mode* 'lib)
	  (lib-alloc-vector))
	 (else
	  (read-alloc-vector)))))

;*---------------------------------------------------------------------*/
;*    cnst-alloc-tvector ...                                           */
;*---------------------------------------------------------------------*/
(define (cnst-alloc-tvector tvec loc)
   (define (C-static-alloc-tvector)
      (let ((var (declare-global-variable! 'static
					   *module-name*
					   'stvector
					   (parse-formal-ident
					    (symbol-append (gensym 'tvector)
							   '::tvector)))))
	 (global-value-set! var tvec)
	 (global-occurrence-set! var 1)
	 (let* ((id  (tvector-id tvec))
		(aid (cnst (ast-kwote loc #f #f id #f))))
	    ;; we first need to compile the symbol holding the identifier
	    ;; because this compilation modifies the *global-ast*
	    ;; variable.
	    (use-global! *tvector-descr-set!*)
	    (use-global! *get-tvector-descr*)
	    (set! *global-ast*
		  (cons (ast-app loc
				 #f
				 #f
				 (ast-var loc #f #f *tvector-descr-set!*)
				 (list
				  (ast-var loc #f #f var)
				  (ast-app loc
					   #f
					   #f
					   (ast-var loc
						    #f
						    #f
						    *get-tvector-descr*)
					   (list aid)
					   #f
					   #f
					   #f
					   #f))
				 #f
				 #f
				 #f
				 #f)
			*global-ast*)))
	 (ast-var loc #f #f var)))
   (define (read-alloc-tvector)
      (internal-error "read-alloc-tvector"
		      "Unimplementable until bootstrap"
		      tvec)
      (let ((offset *cnst-offset*))
	 (set! *cnst-offset* (+fx 1 *cnst-offset*))
	 (set! *global-set* (cons tvec *global-set*))
	 (make-cnst-table-ref offset loc)))
   (if (tvector-C-static? tvec)
       (C-static-alloc-tvector)
       (read-alloc-tvector)))

