;*---------------------------------------------------------------------*/
;*    Copyright (c) 1996 by Manuel Serrano. All rights reserved.       */
;*                                                                     */
;*                                     ,--^,                           */
;*                               _ ___/ /|/                            */
;*                           ,;'( )__, ) '                             */
;*                          ;;  //   L__.                              */
;*                          '   \    /  '                              */
;*                               ^   ^                                 */
;*                                                                     */
;*                                                                     */
;*    This program is distributed in the hope that it will be useful.  */
;*    Use and copying of this software and preparation of derivative   */
;*    works based upon this software are permitted, so long as the     */
;*    following conditions are met:                                    */
;*           o credit to the authors is acknowledged following         */
;*             current academic behaviour                              */
;*           o no fees or compensation are charged for use, copies,    */
;*             or access to this software                              */
;*           o this copyright notice is included intact.               */
;*      This software is made available AS IS, and no warranty is made */
;*      about the software or its performance.                         */
;*                                                                     */
;*      Bug descriptions, use reports, comments or suggestions are     */
;*      welcome Send them to                                           */
;*        <Manuel.Serrano@inria.fr>                                    */
;*        Manuel Serrano                                               */
;*        INRIA -- Rocquencourt                                        */
;*        Domaine de Voluceau, BP 105                                  */
;*        78153 Le Chesnay Cedex                                       */
;*        France                                                       */
;*---------------------------------------------------------------------*/


;*=====================================================================*/
;*    serrano/prgm/project/bigloo/comptime1.8/Coerce/funcall.scm       */
;*    -------------------------------------------------------------    */
;*    Author      :  Manuel Serrano                                    */
;*    Creation    :  Fri Jan 20 17:21:26 1995                          */
;*    Last change :  Thu Aug 24 09:33:47 1995 (serrano)                */
;*    -------------------------------------------------------------    */
;*    The `funcall' coercion                                           */
;*=====================================================================*/

;*---------------------------------------------------------------------*/
;*    The module                                                       */
;*---------------------------------------------------------------------*/
(module coerce_funcall
   (include "Type/type.sch"
	    "Ast/node.sch"
	    "Tools/trace.sch")
   (import  tools_shape
	    tools_location
	    type_cache
	    engine_param
	    ast_sexp
	    ast_dump
	    ast_app
	    ast_env
	    coerce_coerce
	    coerce_convert)
   (export  (coerce-funcall! <ast> <type>)))

;*---------------------------------------------------------------------*/
;*    coerce-funcall! ...                                              */
;*---------------------------------------------------------------------*/
(define (coerce-funcall! ast to)
   (trace type "coerce-funcall!: " (ast->sexp ast) #\Newline)
   (let ((error-msg (list 'quote (ast->sexp ast)))
	 (strength  (funcall-strength ast)))
      ;; we coerce the arguments
      (coerce-funcall-actuals! ast to)
      ;; we coerce the procedure
      (if (and (not (eq? strength 'light)) (not (eq? strength 'extra-light)))
	  (funcall-fun-set! ast (coerce! (funcall-fun ast) *procedure*)))
      ;; we check arity
      (if (or *unsafe-arity*
	      (eq? strength 'light)
	      (eq? strength 'extra-light))
	  (convert! ast *obj* to)
	  (let* ((aux  (gensym 'aux))
		 (loc  (ast-location ast))
		 (len  (-fx (length (funcall-actuals ast)) 2))
		 ;; we substract 2, 1 for the environment and 1 for eao
		 (last (sexp->ast
			`(let ((,(symbol-append aux '::obj)
				#unspecified))
			    (if (correct-arity? ,aux ,len)
				#unspecified
				,(if (and (>fx *compiler-debug* 0) (loc? loc))
				     `(begin
					 ((@ error/location __error)
					  ,(list 'quote (current-function))
					  "Wrong number of arguments in"
					  ,error-msg
					  ,(loc-full-fname loc)
					  ,(loc-pos loc))
					 (failure '_ '_ '_))
				     `(failure
				       ,(list 'quote
					      (current-function))
				       "Wrong number of arguments in"
				       ,error-msg))))
				  '()
				  #f
				  loc
				  'read)))
	     (let ((aux (car (car (let-var-bindings last)))))
		;; and the local variable value to the coerced function
		(set-cdr! (car (let-var-bindings last)) (funcall-fun ast))
		;; we set the conditional slot 
		(conditional-then-set! (let-var-body last)
				       (convert! ast *obj* to))
		(let ((ut *unsafe-type*))
		   (set! *unsafe-type* #t)
		   (conditional-else-set! (let-var-body last)
					  (coerce! (conditional-else
						    (let-var-body last))
						   to))
		   (set! *unsafe-type* ut)
		   ;; we set the function
		   (funcall-fun-set! ast (ast-var loc #f #f aux))
		   last))))))

;*---------------------------------------------------------------------*/
;*    coerce-funcall-actuals! ...                                      */
;*---------------------------------------------------------------------*/
(define (coerce-funcall-actuals! ast to)
   (if (null? (funcall-actuals ast))
       (funcall-actuals-set! ast (list (sexp->ast '__eoa__
						  '()
						  #f
						  (ast-location ast)
						  'read)))
       (let loop ((actuals (funcall-actuals ast))
		  (prev    'dummy))
	  (if (null? actuals)
	      (set-cdr! prev (list (sexp->ast '__eoa__
					      '()
					      #f
					      (ast-location ast)
					      'read)))
	      (begin
		 (set-car! actuals (coerce! (car actuals) *obj*))
		 (loop (cdr actuals) actuals))))))

