/*---------------------------------------------------------------------*/
/*    Copyright (c) 1996 by Manuel Serrano. All rights reserved.       */
/*                                                                     */
/*                                     ,--^,                           */
/*                               _ ___/ /|/                            */
/*                           ,;'( )__, ) '                             */
/*                          ;;  //   L__.                              */
/*                          '   \    /  '                              */
/*                               ^   ^                                 */
/*                                                                     */
/*                                                                     */
/*    This program is distributed in the hope that it will be useful.  */
/*    Use and copying of this software and preparation of derivative   */
/*    works based upon this software are permitted, so long as the     */
/*    following conditions are met:                                    */
/*           o credit to the authors is acknowledged following         */
/*             current academic behaviour                              */
/*           o no fees or compensation are charged for use, copies,    */
/*             or access to this software                              */
/*           o this copyright notice is included intact.               */
/*      This software is made available AS IS, and no warranty is made */
/*      about the software or its performance.                         */
/*                                                                     */
/*      Bug descriptions, use reports, comments or suggestions are     */
/*      welcome Send them to                                           */
/*        <Manuel.Serrano@inria.fr>                                    */
/*        Manuel Serrano                                               */
/*        INRIA -- Rocquencourt                                        */
/*        Domaine de Voluceau, BP 105                                  */
/*        78153 Le Chesnay Cedex                                       */
/*        France                                                       */
/*---------------------------------------------------------------------*/


/*=====================================================================*/
/*    serrano/prgm/project/bigloo/runtime1.8/Clib/trace.c              */
/*    -------------------------------------------------------------    */
/*    Author      :  Manuel Serrano                                    */
/*    Creation    :  Fri Mar 31 18:06:36 1995                          */
/*    Last change :  Mon Aug 14 10:12:31 1995 (serrano)                */
/*    -------------------------------------------------------------    */
/*    We dump a execution trace                                        */
/*=====================================================================*/
#if( !defined( BIGLOO_DEBUG ) )
#   define BIGLOO_DEBUG
#endif

#include <bigloo.h>

/*---------------------------------------------------------------------*/
/*    Globals variables                                                */
/*---------------------------------------------------------------------*/
struct dframe *top_of_frame = 0L;
struct dframe frame;

/*---------------------------------------------------------------------*/
/*    dump_trace_stack ...                                             */
/*---------------------------------------------------------------------*/
obj_t
dump_trace_stack( port, depth )
obj_t port;
long  depth;
{
   long           level = 0L;
   struct dframe *runner = top_of_frame;
   obj_t          old = 0L;
   int            recursion = 0;

   while( (level < depth) && runner && (runner != &frame) )
   {
      if( SYMBOLP( runner->symbol ) )
      {
	 if( EQP( runner->symbol, old ) )
	    recursion++, depth++;
	 else
	 {
	    if( recursion > 0 )
	    {
	       fprintf( OUTPUT_PORT( port ).file, "       ...\n" );
	       recursion = 0;
	    }
	    old = runner->symbol;
	    
	    fprintf( OUTPUT_PORT( port ).file,
		     "  %3ld. %s\n", level, SYMBOL( runner->symbol ).name );
	 }
			
	 level++; 
      }
      
      runner = runner->link;
   }
   
   return BUNSPEC;
}

/*---------------------------------------------------------------------*/
/*    cref ...                                                         */
/*---------------------------------------------------------------------*/
obj_t
cref( obj )
obj_t obj;
{
   return CREF( obj );
}

/*---------------------------------------------------------------------*/
/*    car ...                                                          */
/*---------------------------------------------------------------------*/
obj_t
car( obj )
obj_t obj;
{
   return CAR( obj );
}

/*---------------------------------------------------------------------*/
/*    cdr ...                                                          */
/*---------------------------------------------------------------------*/
obj_t
cdr( obj )
obj_t obj;
{
   return CDR( obj );
}

/*---------------------------------------------------------------------*/
/*    byteshow ...                                                     */
/*---------------------------------------------------------------------*/
static void
byteshow( addr )
unsigned char *addr;
{
#define PP_CHAR( c ) (((c) >= 33) && ((c) < 127)) ? c : '.'

   printf( "  %08x  :  %02x %02x %02x %02x  :  %c%c%c%c\n",
           (unsigned long)addr,
           addr[ 0 ],
           addr[ 1 ],
           addr[ 2 ],
           addr[ 3 ],
           PP_CHAR( addr[ 0 ] ),
           PP_CHAR( addr[ 1 ] ),
           PP_CHAR( addr[ 2 ] ),
           PP_CHAR( addr[ 3 ] ) );
}
             
/*---------------------------------------------------------------------*/
/*    memshow ...                                                      */
/*---------------------------------------------------------------------*/
void
memshow( from, to, step )
char *from, *to;
long  step;
{
   char *i;

   step *= 4;
      
   if( from > to )
      for( i = from; i > to; i -= step )
         byteshow( i );
   else
      for( i = from; i < to; i += step )
         byteshow( i );

   puts( "" );
   return ;
}

      

