#include "cthugha.h"
#include "information.h"
#include "options.h"
#include "display.h"
#include "sound.h"
#include "action.h"
#include "translate.h"

#include <unistd.h>
#include <stdio.h>
#undef COLORS		/* comes again in ncurses */
#include <ncurses.h>

void show_credits() {

    static char * credit_names[] = {
	" ",
	"-------------------------------------------------------------------------------", 
	" ",
	"Want to register?",
	"- for personal use:   send a Postcard to me",
	"                      or a CD if you have too much money",
	"- for commercial use: register for US$50 or 2 CDs",
	"- for magazines:      please send a copy of your review or coverdisk to me",
	" ",
	" ",
	"-------------------------------------------------------------------------------", 
	" Received by me (Harald Deischinger)",
	"-------------------------------------------------------------------------------",
	" ",
	"              The first postcard I received !", 
	"              -------------------------------",
	" ",
	"   Luigi - Milano, Italy     - special thanks",
	" ",
	"              The second (electronic) postcard I received !",
	"              ---------------------------------------------",
	" ",
	"   Kevin McCarthy - USA ",
	" ",
	"              The next three postcards I received !",
	"              -------------------------------------",
	" ",
	"   Reinhold Platzer - Germany",
	"              one in German",
	"              one in English",
	"              one in French",
	" ",
	" ",
	"              Please send me some - I also accept electonic Postcards from",
	"              http://postcards.www.media.mit.edu/Postcards/Welcome.html ",
	" ",
	" ",
	"              These guys helped to improve Cthugha-L !", 
	"              ----------------------------------------", 
	" ",
	".dartmouth.edu:  Christopher L. Platt",
	".hangon.net   :  Someone who gave only root as name",
	".kharkov.ua   :  Stanislav V. Voronyi",
	"dk-online.dk  :  Torsten Martinsen",
	"iki.fi        :  Jarkko Lietolahti",
	" ",
	" ",
	" ",
	"-------------------------------------------------------------------------------", 
	" Received by Kevin Burfitt",
	"-------------------------------------------------------------------------------",
	"This list is a bit out of date.",
	"It will probably vanish as I receive more postcards.",
	" ", 
	"              People who have sent CD's !",
	"              ---------------------------",
	" ",
	"Don Weir  - Sydney, Australia",
	"              (Pete Namlook: The Definative Ambient Collection)",
	"              (Gothic Voices: Music for the lion-hearted king)",
	"              (Sandra: Greatest Hits)",
	" ",
	"Tom Ellard  (Severed Heads) - Sydney, Australia",
	"              (Severed Heads: Dead eyes opened)",
	"              (Tom used Cthugha in the video clip for Dead Eyes Opened)",
	" ",
	"Yasuki Ohsono - Japan",
	"              (Pizzicato Five: Overdose)",
	" ",
	"Oliver & Babsi Mueller, Gerd Joachim Klostermann - Germany",
	"              (Kraftwerk: Die Mensch Maschine)",
	" ",
	"Thomas O. Moll - Germany",
	"              (Divine: Maid in England)",
	" ",
	"DeadZone - USA",
	"              (2 copies of their E.P., a bumper sticker,a photo)",
	"              (DeadZone: An Audio Interpretation of Human Existance)",
	" ",
	"Alex Habbe - Austria",
	"              (Freaky Fukin Weirdoz: Mao Mak Maa)",
	" ",
	"Matt Black - UK",
	"              (Tone Tales From Tomorrow)",
	" ",
	"Dan Foley - USA",
	"              (Pete Namlook: Shades of Orion)",
	" ",
	"Geert-Jan Engelen - Netherlands",
	"              (Wax: Magnetic Heaven",
	" ",
	"David Smith - Michigan, USA",
	"              (King Crimson: VROOOM)",
	" ",
	"Steve Kirby (I-Sense) - Berks, UK",
	"              (I-Sense: cacti and succulents)",
	" ",
	"Jim Hill - Seattle, USA",
	"              (The Neon Interactive CD-ROM advertising CD)",
	"              (see, I said I wasnt fussy about what you send!)",
	" ",
	"Lawrence Wright - USA",
	"              (Ozzy Ozborne: Blizzard of Ozz)",
	" ",
	"Daniel Wigtil - USA",
	"              (American Gramaphone Records: Sampler III)",
	" ",
	" ",
	"              This guys sent their video tapes !",
	"              ----------------------------------",
	"USA        :  Don Slepian - Video Dreamland",
	"Australia  :  Tom Ellard (Severed Heads: Dead eyes opened)",
	" ",
	" ",
	"-------------------------------------------------------------------------------", 
	" ",
	"              If your name is not in the list - don't be sad.",
	"              This list will be updated in the next release of Cthugha-L",
	"              and then your name will be there ",
	" ",
	" ",
	" "
    };
    static int nr_credit_names = sizeof(credit_names) / sizeof(char*);

    WINDOW * title;				/* top-part-message */
    WINDOW * names;				/* scrolling names */
    int i, k;
	
#ifdef DEBUG
    sleep(3);
#endif

    title = newwin(15, 0, 0,0);			/* first 15 lines */
    names = newwin(0,0, 15,0);	

    /* prepare colors */
    if( has_colors() ) {			/* set colors for windows */
	init_pair(1, COLOR_BLUE, COLOR_WHITE);
	init_pair(2, COLOR_WHITE, COLOR_RED);
	
	wattrset(title, COLOR_PAIR(1));
	wattrset(names, COLOR_PAIR(2));
    } else {
	wattrset(title, A_BOLD);
    }
    
    wclear(title);
    wclear(names);
	
    /* write the text for the title */
    wprintw(title, "-------------------------------------------------------------------------------\n");
    wprintw(title, "---                          C T H U G H A - L  0.8                         ---\n");
    wprintw(title, "-------------------------------------------------------------------------------\n");
    wprintw(title, " by Harald Deischinger        k3096e5@c210.edvz.uni-linz.ac.at                 \n");
    wprintw(title, "    Am Edhuegel 46                                                             \n");
    wprintw(title, "    4115  Kleinzell                                                            \n");
    wprintw(title, "    AUSTRIA                                                                    \n");
    wprintw(title, "-------------------------------------------------------------------------------\n");
    wprintw(title, "Original Programm (CTHUGHA V5.1 and V5.3) by:                                  \n");
    wprintw(title, "  Coded by - Torps Productions: The Digital Aasvogel Group - 1995              \n"); 
    wprintw(title, "  Original Idea & Code:          Kevin Burfitt (zaph@torps.apana.org.au)       \n"); 
    wprintw(title, "-------------------------------------------------------------------------------\n");
    wprintw(title, "Cthugha WWW-Page:            http://www.afn.org/~cthugha                       \n");
    wprintw(title, "Cthugha newsgroup:           alt.graphics.cthugha                              \n");
#ifdef BETA
    wprintw(title, "BETA BETA BETA BETA BETA BETA BETA BETA BETA BETA BETA BETA BETA BETA BETA BETA\n");
#else
    wprintw(title, "-------------------------------------------------------------------------------\n");
#endif
    wrefresh(title);
	
    /* write the text for the scrolling names */
    keypad(names, TRUE);
    scrollok(names, TRUE);
    wtimeout(names, 300);
    i=0;
    do {
	wprintw(names, "%-79s\n", credit_names[i]);
	i = (i+1) % nr_credit_names;
	wrefresh(names);
	k = wgetch(names);
    } while( k<= 0);
	
    delwin(title);
    delwin(names);
}

/*****************************************************************************/
		
/* Modifications to update status "interactively" by 
 * Christopher L. Platt  (croutons%crunchy.uucp@dartmouth.edu)
 */

int do_status = 0;

 /* Generate status-information-string
 */
void status(int reset) {
    char s[2000];
    float fps;
    int i;

    /* toggle info */
    if ( do_status && reset ) {
	display_print( NULL, 0, reset);
	return;
    }

    i = time(0) - display_start;
    fps = (i==0) ? 0: ((float)display_frames)/((float)(i));

    sprintf(s, 
	    "Wave    : %s (%s)\n"
	    "Flame   : %s (%s)\n"
	    "Display : %s (%s)\n"
	    "Palette : %s (%s)\n"
	    "Transl. : %s (%s)\n"
	    "Next PCX: %s (%s)\n"
	    "Table   : %d\n"
	    "Massage : %d\n"
	    "Channels: %s\n"
	    "Rate    : %d\n"
	    "%s%s\n"
	    "Frames/s: %2.2f",

	    opt_get(display_wave, waves, nr_waves)->name,
	    opt_get(display_wave, waves, nr_waves)->desc,

	    opt_get(flame, flames, nr_flames)->name,
	    opt_get(flame, flames, nr_flames)->desc,

	    opt_get(update_screen, screens, nr_screens)->name,
	    opt_get(update_screen, screens, nr_screens)->desc,

	    opt_get(active_palette, palettes, nr_palettes)->name,
	    opt_get(active_palette, palettes, nr_palettes)->desc,

	    opt_get(active_translation, translations, nr_translations)->name,
	    opt_get(active_translation, translations, nr_translations)->desc,

	    opt_get(active_pcx, pcxs, nr_pcx)->name,
	    opt_get(active_pcx, pcxs, nr_pcx)->desc,

	    active_table,
	    sound_massage_style,

	    (sound_stereo == 2) ? "Stereo" : "Mono",
	    sound_sample_rate,
	    action_lock ? "LOCKED " : "",
	    (sound_use_fft && sound_FFT) ? "FFT" : "",
	    fps);
		
    display_print( s, 0, reset);
    do_status = 1;
}		

void 
update_status()
{
    if ( do_status )
	status(0);
}

void 
clear_status()
{
    do_status = 0;
}

int status_active() {
    return do_status;
}

/*****************************************************************************/

/* 
 * display help-screen
 */
void help() {

    display_print("f/F  Chg Flame     w/W  Chg Wave\n"
		  "d/D  Chg Display   b/B  Chg Table\n"
		  "t/T  Chg Transl.   m/M  Chg Snd-massage\n"
		  "p/P  Chg Palette   s    Toggle FFT\n"
		  "l    Lock          i    Information\n"
		  "x/X  show PCX      +/- Sample-Rate\n"
		  "*    mono/stereo   </> Minnoise\n"
		  "F1/? This Help     F2  Select Display\n"
		  "F3   Select Wave   F4  Select Flame\n"
		  "F5   Select Trans. F6  Select Palette\n"
		  "F7   Select PCX    g   Chg. gen. flame\n"
		  "o    Optioms       c   Sound/CD Control\n"   
		  "a    write ini-file with current sel.\n"
		  "n    reconnect to cthugha-server\n"
		  "q/ESC  Exit        #   Print screen\n",0,1);
}

