/*
 *	ident_client.c
 *
 * Identifies the remote user of a given connection.
 *
 * Written 940112 by Luke Mewburn <lm@rmit.edu.au>
 *
 * Copyright (C) 1994 by Luke Mewburn.
 * This code may be used freely by anyone as long as this copyright remains.
 *
 */

#include <stdio.h>
#include <string.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <netdb.h>

#define IDENT_PORT	113

/*
 * ident_client
 *	- user interface to identd
 *
 * Args:
 *	peeraddr	sockaddr_in struct of peer end, from getpeername(...)
 *	ouraddr		sockaddr_in struct of local end, from getsockname(...)
 *
 * Returns:
 *	NULL on failure to identify (for whatever reason), or pointer to
 *	static character string with the identity.
 */

char *
ident_client(peeraddr, ouraddr)
	struct sockaddr_in	*peeraddr, *ouraddr;
{
	struct sockaddr_in	authcon;
	int			authfd, authlen;
	struct servent		*identserv;
	int			identport;

	FILE			*authfpin, *authfpout;
	char			buffer[8192];	/* XXX: argh! magic numbers */
	char			reply_type[81]; 
	char			opsys_or_err[81]; 
	int			rport, lport;

	static char		identifier[1024]; 

	authfd = socket(AF_INET, SOCK_STREAM, 0);
	if (authfd == -1) {
		perror("socket");
		return NULL;
	}

	identserv = getservbyname("ident", "tcp");
	if (identserv)
		identport = identserv->s_port;
	else
		identport = ntohs(IDENT_PORT);

	memset(&authcon, 0, sizeof(authcon));
	authcon.sin_family = AF_INET;
	authcon.sin_addr.s_addr = peeraddr->sin_addr.s_addr;
	authcon.sin_port = identport;

	authlen = sizeof(authcon);
	if (connect(authfd, (struct sockaddr *)&authcon, authlen) < 0) {
		perror("connect");
		close(authfd);
		return NULL;
	}

	if ((authfpout = fdopen(authfd, "w")) == NULL) {
		perror("fdopen out");
		close(authfd);
		return NULL;
	}
	fprintf(authfpout, "%d , %d\n", ntohs(peeraddr->sin_port),
		ntohs(ouraddr->sin_port));
	fflush(authfpout);

	if ((authfpin = fdopen(authfd, "r")) == NULL) {
		perror("fdopen in");
		fclose(authfpout);
		close(authfd);
		return NULL;
	}
	if (fgets(buffer, sizeof(buffer)-1, authfpin) == NULL) {
		perror("fgets");
		fclose(authfpout);
		fclose(authfpin);
		close(authfd);
		return NULL;
	}

	fclose(authfpout);
	fclose(authfpin);

	shutdown(authfd, 1);
	close(authfd);

	authlen = sscanf(buffer,
		"%d , %d : %[^ \t\n\r:] : %[^ \t\n\r:] : %[^\n\r]",
		&lport, &rport, reply_type, opsys_or_err, identifier);
	if (authlen < 3) {
		perror("sscanf");
		return NULL;
	}

#if 0		/* XXX: for if we ever handle the ERROR class */
	if (! strcasecmp(reply_type, "ERROR"))
		return NULL;
#endif
	if (strcasecmp(reply_type, "USERID")) {
		fputs("strcasecmp", stderr);
		return NULL;
	}

	return identifier;
} /* ident_client */
