/*

------------------------------------------------------------------------------

A license is hereby granted to reproduce this software source code and
to create executable versions from this source code for personal,
non-commercial use.  The copyright notice included with the software
must be maintained in all copies produced.

THIS PROGRAM IS PROVIDED "AS IS". THE AUTHOR PROVIDES NO WARRANTIES
WHATSOEVER, EXPRESSED OR IMPLIED, INCLUDING WARRANTIES OF
MERCHANTABILITY, TITLE, OR FITNESS FOR ANY PARTICULAR PURPOSE.  THE
AUTHOR DOES NOT WARRANT THAT USE OF THIS PROGRAM DOES NOT INFRINGE THE
INTELLECTUAL PROPERTY RIGHTS OF ANY THIRD PARTY IN ANY COUNTRY.

Copyright (c) 1995, John Conover, All Rights Reserved.

Comments and/or bug reports should be addressed to:

    john@johncon.com (John Conover)

------------------------------------------------------------------------------

postfix.h, general include file for postfix.c

$Revision: 1.0 $
$Date: 1995/04/22 05:14:50 $
$Id: postfix.h,v 1.0 1995/04/22 05:14:50 john Exp $
$Log: postfix.h,v $
 * Revision 1.0  1995/04/22  05:14:50  john
 * Initial revision
 *

*/

#ifndef _POSTFIX_H /* if not defined then postfix.h has not yet been included */

#define _POSTFIX_H

#define POSTFIX_H_ID "$Id: postfix.h,v 1.0 1995/04/22 05:14:50 john Exp $" /* module version */

typedef struct symbol_element /* symbol element structure */
{
    unsigned char *lexicon; /* reference to parsed token */
    enum token_type precedence; /* lexicon type/precedence */
    struct symbol_element *next; /* reference to next element in the stack's list */
    struct eval_element *eval; /* reference to eval structure for storing intermediate results of postfix evaluation */
    struct bmhpattern_struct *pattern; /* reference to bmhpattern structure for this element, null means token is an operator */
} ELEMENT;

#ifdef __STDC__

extern ELEMENT *postfix (char *buffer, unsigned char *tokens);

#else

extern ELEMENT *postfix ();

#endif

#endif
