#include <stdlib.h>
#include <stdio.h>

#include "latex2lyx.h"

/*----------------------------------------------------------------------------*/
/*      Terminals - Constants definitions                                     */
/*----------------------------------------------------------------------------*/

#define L_documentstyle 1
#define L_pagenumbering 2
#define L_pagestyle 3
#define L_maketitle 4
#define L_tableofcontents 5
#define L_begin 6
#define L_end 7
#define L_item 8
#define L_bibitem 9
#define L_label 10
#define L_ref 11
#define L_cite 12
#define L_noindent 13
#define L_input 14
#define L_include 15
#define L_includeonly 16
#define L_centerline 17
#define L_mbox 18
#define L_fbox 19
#define L_framebox 20
#define L_sbox 21
#define L_savebox 22
#define L_newsavebox 23
#define L_usebox 24
#define L_newpage 25
#define L_clearpage 26
#define L_samepage 27
#define L_linebreak 28
#define L_nolinebreak 29
#define L_sloppy 30
#define L_hline 31
#define L_cline 32
#define L_multicolumn 33
#define L_caption 34
#define L_kill 35
#define L_vspace 36
#define L_hspace 37
#define L_vfill 38
#define L_hfill 39
#define L_put 40
#define L_multiput 41
#define L_makebox 42
#define L_dashbox 43
#define L_line 44
#define L_vector 45
#define L_shortstack 46
#define L_circle 47
#define L_oval 48
#define L_frame 49
#define L_thinlines 50
#define L_thicklines 51
#define L_sqrt 52
#define L_frac 53
#define L_overline 54
#define L_appendix 55
#define L_tabset 56
#define L_tabskip 57
#define L_pmod 58
#define L_vec 59
#define L_stackrel 60
#define L_centering 61
#define L_lbracket 62
#define L_rbracket 63
#define L_lcurly 64
#define L_rcurly 65
#define L_word 66
#define L_linefeed 67
#define L_bibliographystyle 68
#define L_newline 69
#define L_smallspace 70
#define L_today 71
#define L_footnote 72
#define L_subscript 73
#define L_superscript 74
#define L_thinspace 75
#define L_negspace 76
#define L_mediumspace 77
#define L_thickspace 78
#define L_plus 79
#define L_div 80
#define L_equal 81
#define L_mathbegin 82
#define L_mathend 83
#define L_less 84
#define L_more 85
#define L_amper 86

#define L_lparen 88
#define L_rparen 89
#define L_tilde 90
#define L_dollar 91
#define L_backslash 92
#define L_mathspace 93
#define L_box 94
#define L_textwidth 95
#define L_bibliography 96
#define L_linespacing 97
#define L_pagebreak 98
#define L_nopagebreak 99
#define L_Heading 100
#define L_FontShape 101
#define L_FontSize 102
#define L_Environment 103
#define L_DocStyle 104
#define L_MathGreek 105
#define L_MathSymbol 106
#define L_MathDelim 107
#define L_accent 108
#define L_LatexMisc 109
#define L_space 110
#define L_document 111
#define L_Heading_star 112


typedef struct _row_info_ {
    int		top;
    int		bot;
} RowInfo;

typedef struct _col_info_ {
    int		align;
    int		left;
    int		right;
} ColInfo;

typedef struct _cell_info_ {
    int		mult;
    int		align;	
    int		top;
    int		bot;
} CellInfo;

char		*buf_ptr;
int		num_rows;
int		num_cols;
RowInfo		*row_info;
ColInfo		*col_info;
CellInfo	**cell_info;

#define SKIP2	while(tree->last){if(tree==start)break;tree=tree->next;}\
                if(tree==start)break;tree=tree->next;continue

int		get_vertical (void)
{
    int		cnt = 0;

    while (*buf_ptr == '|')
    {
	buf_ptr++;
	cnt++;
    }
    return cnt;
}

int		get_align (void)
{
    int		align = 0;

    switch (*buf_ptr) 
    {
      case 'c':
	align = 8; break;
      case 'r':
	align = 4; break;
      case 'l':
	align = 2; break;
    }
    if (*buf_ptr)
        buf_ptr++;
    return align;
}

void		print_table (FILE *fout, Node *start, Node *t, char *ctrl)
{
    Node	*tree;
    int		i, j, k, n, c1, c2, a;
    int		tot_cells;
    int		change;

    /****** Count number of columns */
    buf_ptr = ctrl;
    num_cols = 0;
    get_vertical();
    while (get_align() != 0){
        num_cols++;
	get_vertical();
    }

    /****** Count number of rows */
    num_rows = 0;
    tree = t;
    do {
	if (tree->token == L_newline)
	    num_rows++;

	/****** Walk sintax tree */
	if (tree->down != NULL)
	    tree = tree->down;
	else {
	    while (tree->last) {
		if (tree == start)
		    break;
		tree = tree->next;
	    }
	    if (tree == start)
	        break;
	    tree = tree->next;
	}
    } while (tree != start);

    tot_cells = num_rows * num_cols;

    /****** Allocate memory for this table */
    row_info = (RowInfo *) malloc (sizeof(RowInfo) * num_rows);
    col_info = (ColInfo *) malloc (sizeof(ColInfo) * num_cols);
    cell_info = (CellInfo **) malloc (sizeof(CellInfo *) * num_rows);
    for (i=0; i<num_rows; i++)
        cell_info[i] = (CellInfo *) malloc (sizeof(CellInfo) * num_cols);
    
    /****** Zero all memory */
    for (i=0; i<num_rows; i++) {
        row_info[i].top = 0;
	row_info[i].bot = 0;
    }
    for (i=0; i<num_cols; i++) {
	col_info[i].align = 0;
	col_info[i].left = 0;
	col_info[i].right = 0;
    }
    for (i=0; i<num_rows; i++)
        for (j=0; j<num_cols; j++) {
	    cell_info[i][j].mult = 0;
	    cell_info[i][j].align = 0;
	    cell_info[i][j].top = 0;
	    cell_info[i][j].bot = 0;
	}

    /****** Collect columns info */
    buf_ptr = ctrl;
    for (i=0; i<num_cols; i++) {
	j = get_vertical();
	if (j>=2 && i>0) {
	    col_info[i-1].right = 1;
	    col_info[i].left = 1;
	} else 
	    col_info[i].left = j;
	col_info[i].right = 0;
	col_info[i].align = get_align();
    }
    col_info[num_cols-1].right = get_vertical();

    /****** Collect row info */
    i = 0;
    j = 0;
    tree = t;
    cell_info[i][j].mult = 0;
    cell_info[i][j].align = col_info[j].align;
    do {
	if (tree->token == L_newline) {
	    i++;
	    j = 0;
	    if (i != num_rows) {
		cell_info[i][j].align = col_info[j].align;
		cell_info[i][j].mult = 0;
	    }
	} else if (tree->token == L_amper) {
	    j++;
	    cell_info[i][j].align = col_info[j].align;
	    cell_info[i][j].mult = 0;
	} else if (tree->token == L_hline) {
	    if (i==0) {
		row_info[i].top++;	
		for (k=0; k<num_cols; k++)
		    cell_info[i][k].top = row_info[i].top;
	    } else if (row_info[i-1].bot == 0) {
		row_info[i-1].bot++;
		for (k=0; k<num_cols; k++)
		    cell_info[i-1][k].bot = row_info[i-1].bot;
	    } else if (i != num_rows) {
		row_info[i].top++;
		for (k=0; k<num_cols; k++)
		    cell_info[i][k].top = row_info[i].top;
	    }
	} else if (tree->token == L_latex_3op && tree->data.spec == L_multicolumn) {
	    /****** Get num of columns to span */
	    sscanf (tree->down->data.ptr, "%d", &n);
	    /****** Get alignment of mult-cell */
	    buf_ptr = tree->down->next->data.ptr;
	    get_vertical();
	    a = get_align();
	    for (k=0; k<n; k++) {
		cell_info[i][j+k].mult = 2;
		cell_info[i][j+k].align = a;
	    }
	    cell_info[i][j].mult = 1;
	    j += (n - 1);
	    tot_cells -= (n - 1);
	} else if (tree->token == L_latex_1op && tree->data.spec == L_cline) {
	    sscanf (tree->down->data.ptr, "%d-%d", &c1, &c2);
	    if (i == 0) {
		for (k=c1-1; k<c2; k++)
		    cell_info[i][k].top++;
	    } else if (cell_info[i-1][c1-1].bot == 0) {
		for (k=c1-1; k<c2; k++)
		    cell_info[i-1][k].bot++;
	    } else if (i != num_rows) {
		for (k=c1-1; k<c2; k++)
		    cell_info[i][k].top++;
	    }
	}

	/****** Walk sintax tree */
	if (tree->down != NULL)
	    tree = tree->down;
	else {
	    while (tree->last) {
		if (tree == start)
		    break;
		tree = tree->next;
	    }
	    if (tree == start)
	        break;
	    tree = tree->next;
	}
    } while (tree != start);

    /****** Print table head in Lyx format */
    fprintf(fout, "multicol2\n%d %d\n", num_rows, num_cols);
    for (k=0; k<num_rows; k++)
        fprintf(fout, "%d %d\n", row_info[k].top, row_info[k].bot);
    for (k=0; k<num_cols; k++)
        fprintf(fout, "%d %d %d\n", col_info[k].align, col_info[k].left, col_info[k].right);
    for (i=0; i<num_rows; i++)
        for (j=0; j<num_cols; j++)
	    fprintf(fout, "%d %d %d %d\n", cell_info[i][j].mult, cell_info[i][j].align,
		    cell_info[i][j].top, cell_info[i][j].bot);
    fprintf(fout, "\n");

    /****** Print table body in Lyx format */
    tree = t;
    k = tot_cells;
    /****** Start of a group of words */
    push (fam_stack, &fam_top, family);
    push (ser_stack, &ser_top, series);
    push (shp_stack, &shp_top, shape);
    push (siz_stack, &siz_top, size);
    push (bar_stack, &bar_top, bar);

    do {
        if (tree->token == L_newline || tree->token == L_amper) {
	    k--;
	    if (k == 0)
	        fprintf(fout, "\n");
	    else 
	        fprintf(fout, "\n\\newline\n");

	    /****** End of a group of words */
	    change = (family != fam_stack[fam_top-1]);
	    family = pop (fam_stack, &fam_top);
	    if (change)
		fprintf(fout, "\n\\family %s\n", family<0?"default":FontShapeName[family]);
	    change = (series != ser_stack[ser_top-1]);
	    series = pop (ser_stack, &ser_top);
	    if (change)
		fprintf(fout, "\n\\series %s\n", series<0?"default":FontShapeName[series]);
	    change = (shape != shp_stack[shp_top-1]);
	    shape = pop (shp_stack, &shp_top);
	    if (change)
		fprintf(fout, "\n\\shape %s\n", shape<0?"default":FontShapeName[shape]);
	    change = (size != siz_stack[siz_top-1]);
	    size = pop (siz_stack, &siz_top);
	    if (change)
		fprintf(fout, "\n\\size %s\n", size<0?"default":FontShapeName[size]);
	    change = (bar != bar_stack[bar_top-1]);
	    bar = pop (bar_stack, &bar_top);
	    if (change)
		fprintf(fout, "\n\\bar %s\n", bar<0?"no_bar":FontShapeName[bar]);
	    /****** Start of a group of words */
	    if (k != 0) {
		push (fam_stack, &fam_top, family);
		push (ser_stack, &ser_top, series);
		push (shp_stack, &shp_top, shape);
		push (siz_stack, &siz_top, size);
		push (bar_stack, &bar_top, bar);
	    }
	} else if (tree->token == L_latex_3op && tree->data.spec == L_multicolumn) {
	    print_lyx (fout, tree->lson, tree->lson);
	    SKIP2;
	}
	else if (tree->token == L_hline || tree->token == L_linefeed)
	    ;
	else if (tree->token == L_latex_1op && tree->data.spec == L_cline) {
	    SKIP2;
	} else {
	    print_lyx (fout, tree, tree);
	    SKIP2;
	}

	/****** Walk sintax tree */
	if (tree->down != NULL)
	    tree = tree->down;
	else {
	    while (tree->last) {
		if (tree == start)
		    break;
		tree = tree->next;
	    }
	    if (tree == start)
	        break;
	    tree = tree->next;
	}
    } while (tree != start);

    /****** Free memory */
    free (row_info);
    free (col_info);
    for (k=0; k<num_rows; k++)
        free (cell_info[k]);
    free (cell_info);
}
