// -*- C++ -*-
/* This file is part of
 * ======================================================
 * 
 *           LyX, the High Level Word Processor
 * 	 
 *	    Copyright (C) 1995 Matthias Ettrich
 *
 *======================================================*/
#ifndef _TEXTUTILS_H
#define _TEXTUTILS_H

#include "definitions.h"

	inline bool IsNewlineChar(char c) {
		return (c == LYX_META_NEWLINE);
	}
	inline bool IsSeparatorChar(char c) {
		return (c == ' ' || c == LYX_META_PROTECTED_SEPARATOR);
	}
	inline bool IsHfillChar(char c) {
		return (c == LYX_META_HFILL);
	}
	inline bool IsLineSeparatorChar(char c) {
		return (c == ' ');
	}
	inline bool IsKommaChar(char c) {
		return (c == ',' 
			|| c=='('
			|| c==')'
			|| c=='['
			|| c==']'
			|| c=='{'
			|| c=='}'
			|| c==';'
			|| c=='.'
			|| c==':'
			|| c=='-'
			|| c=='?'
			|| c=='!'
			|| c=='&'
			|| c=='@'
			|| c=='+'
			|| c=='-'
			|| c=='~'
			|| c=='#'
			|| c=='%'
			|| c=='^'
			|| c=='/' 
			|| c=='\\'
			|| c==LYX_META_NEWLINE
			|| c==LYX_META_PROTECTED_SEPARATOR
			);
	}
	inline bool IsWordSeparatorChar(char c) {
		return (IsKommaChar(c)
			|| IsSeparatorChar(c)
			|| c==LYX_META_NEWLINE
			|| c==LYX_META_FOOTNOTE
			|| c==LYX_META_MARGIN
			|| c==LYX_META_FIG
			|| c==LYX_META_TAB
			|| c==LYX_META_HFILL
			|| c==LYX_META_INSET
			);
	}
#endif
