/*	
 *   xtel - Emulateur MINITEL sous X11
 *
 *   Copyright (C) 1991-1994  Lectra Systemes & Pierre Ficheux
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */
#ident "$Id: Videotex.h,v 1.4 1995/02/24 14:33:36 pierre Exp $"

#ifndef _XtVideotex_h
#define _XtVideotex_h

/***********************************************************************
 *
 * Videotex Widget
 *
 ***********************************************************************/

/* Parameters:

 Name		        Class		        RepType		Default Value
 ----		        -----		        -------		-------------
 petiteFonte   	     	PetiteFonte		Boolean		False
 nGris   	     	NGris			Boolean		False
 connecte		Connecte		Boolean		False
 fd_connexion		FdConnexion		int		-1
 commande_deconnexion	CommandeDeconnexion	String		NULL
 callback_mode		modeCallback		Callback	NULL
 mode_videotex		ModeVideotex		Boolean		True
*/

#define XtNpetiteFonte		"petiteFonte"
#define XtNconnecte		"connecte"
#define XtNcommandeDeconnexion	"commandeDeconnexion"
#define XtNnGris		"nGris"
#define XtNfdConnexion		"fdConnexion"
#define XtNmodeCallback		"modeCallback"
#define XtNmodeVideotex		"modeVideotex"

#define XtCPetiteFonte		"PetiteFonte"
#define XtCConnecte		"Connecte"
#define XtCCommandeDeconnexion	"CommandeDeconnexion"
#define XtCNGris		"NGris"
#define XtCFdConnexion		"FDConnexion"
#define XtCModeCallback		"ModeCallback"
#define XtCModeVideotex		"ModeVideotex"

typedef struct _VideotexRec *VideotexWidget;  /* completely defined in VideotexPrivate.h */
typedef struct _VideotexClassRec *VideotexWidgetClass;    /* completely defined in VideotexPrivate.h */

extern WidgetClass videotexWidgetClass;

/*
 * Fonctions publiques 
 */
#ifdef __STDC__
extern void videotexInit(Widget w);
extern void videotexDecode(Widget w, int c);
extern Pixmap videotexPixmapEcranSauve (Widget w);
extern void videotexSauveEcran (Widget w);
extern void videotexAfficheTelephone (Widget w);
extern void videotexEffaceTelephone (Widget w);
#else
extern void videotexDecode ();
extern void videotexInit ();
extern Pixmap videotexPixmapEcranSauve ();
extern void videotexSauveEcran ();
extern void videotexAfficheTelephone ();
extern void videotexEffaceTelephone ();
#endif /* __STDC__ */

#endif /* _XtVideotex_h */
/* DON'T ADD STUFF AFTER THIS #endif */
