/* config.h */

/* Originally, this file was automatically generated by the "configure"
 * shell script.
 *
 * This file contains C macro definitions which indicate which features
 * are to be supported, and which library functions are to be emulated.
 * In general, #define enables the feature or emulating function, and
 * #undef disables the feature or causes the library function to be used.
 */


/* The following determine which user interfaces are to be supported */
#undef	GUI_X11		/* simple X-windows interface */
#undef	GUI_CURSES	/* curses interface */
#define	GUI_TERMCAP	/* termcap interface */
#define	GUI_OPEN	/* open-mode only, does nothing fancy */


/* These allow you to selectively disable the display modes.  You'll probably
 * want the "c" mode disabled, since the "syntax" mode can do the exact same
 * thing.  If you disable "html" then the help files won't look right.
 * #define to enable the mode, #undef to exclude it.
 */
#undef	DISPLAY_C	/* c		C/C++ syntax coloring */
#define	DISPLAY_HEX	/* hex		interactive hex dump */
#define	DISPLAY_MARKUP	/* html, man	formatted text */
#define	DISPLAY_SYNTAX	/* syntax	generic syntax coloring */


/* The following provide custom implementation of some common functions which
 * are either missing or poorly implemented on some systems.
 */
#undef	NEED_ABORT	/* replaces abort() with a simpler macro */
#undef	NEED_ASSERT	/* defines an custom assert() macro */
#undef	NEED_TGETENT	/* causes tinytcap.c to be used instead of library */
#undef	NEED_WINSIZE	/* includes <ptem.h> -- required by SCO */
#define	NEED_SPEED_T	/* includes <termcap.h> -- common on POSIX systems */
#undef	NEED_STRDUP	/* uses a custom version of strdup() */
#undef	NEED_OSPEED	/* causes guitcap.c to supply an ospeed variable */
#undef	NEED_BC		/* causes guitcap.c to supply a BC variable */
#define	NEED_CTYPE	/* uses a custom <ctype.h>, driven by :digraph */
#define	NEED_WAIT_H	/* must include <sys/wait.h> */
#undef	NEED_SELECT_H	/* must include <sys/select.h> */


/* The following control debugging features.  NDEBUG slows elvis down a lot,
 * and the others tend to make it output some confusing messages, so these
 * are all disabled by default.  (Note that NDEBUG is #define'd to disable it)
 */
#define	NDEBUG		/* undef to enable assert() calls; define to disable */
#undef	DEBUG_ALLOC	/* define to debug memory allocations; undef to disable */
#undef	DEBUG_SCAN	/* define to debug character scans; undef to disable */
#undef	DEBUG_SESSION	/* define to debug the block cache; undef to disable */
#undef	DEBUG_EVENT	/* define to trace events; undef to disable */
#undef	DEBUG_MARKUP	/* define to debug markup display modes */


/* The following macros, and their values, are mostly used to determine the
 * default values of some options.
 */
#define	OSLPOUT	"!lpr"	/* default value of lpout option */
#define OSLIBPATH "~/.elvislib:/usr/lib/elvis"	/* default elvispath */
