/* VGAlib version 1.2 - (c) 1993 Tommy Frandsen                    */
/*                                                                 */
/* This library is free software; you can redistribute it and/or   */
/* modify it without any restrictions. This library is distributed */
/* in the hope that it will be useful, but without any warranty.   */

/* Multi-chipset support Copyright 1993 Harm Hanemaayer */

#include <stdio.h>
#include "vga.h"
#include "libvga.h"
#include "driver.h"

int __vga_dumpregs(const unsigned char regs[], int n)
{
    int i;

    printf("static unsigned char regs[%d] = {\n  ", n);

    for (i = 0; i < 12; i++)
	printf("0x%02X,", regs[CRT + i]);
    printf("\t/* CR00-CR%02x */\n  ", CRT_C - 1);
    for (i = 12; i < CRT_C; i++)
	printf("0x%02X,", regs[CRT + i]);
    printf("\n  ");
    for (i = 0; i < 12; i++)
	printf("0x%02X,", regs[ATT + i]);
    printf("\t/* AR00-AR%02x */\n  ", ATT_C - 1);
    for (i = 12; i < ATT_C; i++)
	printf("0x%02X,", regs[ATT + i]);
    printf("\n  ");
    for (i = 0; i < GRA_C; i++)
	printf("0x%02X,", regs[GRA + i]);
    printf("\t\t\t/* GR00-GR%02x */\n  ", GRA_C - 1);
    for (i = 0; i < SEQ_C; i++)
	printf("0x%02X,", regs[SEQ + i]);
    printf("\t\t\t\t\t/* SR00-SR%02x */\n  ", SEQ_C - 1);
    printf("0x%02X", regs[MIS]);

    n -= 60;
    if (n > 0) {
	printf(",\t\t\t\t\t\t\t\t/* MISC_OUT  */\n"
	       "  /* Extended (count = 0x%02x) */\n  ", n);
	i = 0;
	while (i < n - 1) {
	    printf("0x%02X,", regs[EXT + i++]);
	    if (!(i % 8))
		fputs("\n  ", stdout);
	}
	printf("0x%02X", regs[EXT + n - 1]);
    } else
	printf("\t\t\t\t\t\t\t\t/* MISC_OUT  */");

    printf("\n};\n");

    return 0;
}

int vga_dumpregs(void)
{
    unsigned char regs[MAX_REGS];
    int n;

    __vga_getchipset();

    n = __vga_saveregs(regs);

    return __vga_dumpregs(regs, n);
}
