#
# $Source: /home/nlfm/Working/Zircon/Development/lib/RCS/Friends.tcl,v $
# $Date: 1996/02/26 12:26:35 $
# $Revision: 1.16.1.10 $
#
#
# Handle all stuff related to Friends menu/window
#
#
proc friends_call {this op args} {
    switch $op {
    enable { eval friends_state $this normal $args }
    disable { eval friends_state $this disabled $args }
    default { eval friends_$op $this $args }
    }
}
#
proc friends_rename {this usr nnk} {
    if [$this menu] {
	global Fctl
	set ctl [$Fctcl($this) window]
	if {[set x [indexHack $ctl.bf1.friends.menu [$usr name] 0]] >= 0} {
	    $ctl.bf1.friends.menu entryconfigure $x -label $nnk
	}
    } {
	if [winfo exists .@$this.users.userList.$usr] {
	    .@$this.users.userList.$usr config -text $nnk
	}
    }
}
#
proc friends_absent {this usr} {
    if [$this menu] {
	global Fctl
	set ctl [$Fctcl($this) window]
	if {[set x [indexHack $ctl.bf1.friends.menu [$usr name] 0]] >= 0} {
	    set v [$ctl.bf1.friends.menu entryconfigure $x -state]
	    return ![string match {normal} [lindex $v 4]]
	}
	return 0	
    } {
	return [expr {[winfo exists .@$this.users.userList.$usr] \
	      && ![normal .@$this.users.userList.$usr]}]
    }
}
#
proc friends_menu {this} {
    global friendsStyle ; return [string match {menu} $friendsStyle]
}
#
proc friends_mark {this usr what} {
    if [$this menu] {
# Dont do anything at the moment
    } \
    elseif [winfo exists .@$this.users.userList.$usr] {
	markButton .@$this.users.userList.$usr $what
	popup .@$this
    }
}
#
proc friends_delete {this} { catch {destroy .@$this} }
#
proc friends_state {this state args} {
    if [$this menu] {
	global Fctl
	set ctl [$Fctl($this) window]
	foreach id $args {
	    if {[set x [indexHack $ctl.bf1.friends.menu $id 0]] >= 0} {
		$ctl.bf1.friends.menu entryconfigure $x -state $state
	    }
	}
    } {
	foreach id $args {
	    if [winfo exists .@$this.users.userList.$id] {
		.@$this.users.userList.$id conf -state $state
	    }
	}
    }
}
#
proc Friends {name args} {
    global Fctl
    set Fctl($name) [lindex $args 1]
    proc $name {args} "eval friends_call $name \$args"
    return $name
}
#
proc friends_show {this} {
    if [$this menu] {
	makeFriendsMenu $this [$Fctl($this) window].bf1.friends.menu
    } elseif {[winfo exists .@$this]} {popup .@$this} {makeFriends $this}
}
#
proc makeFriendsMenu {this win} {menu $win ; insertFriends $this}
#
proc makeFriends {this} {
    set w [toplevel .@$this -class Zircon]
    wm title $w "Friends"
    wm resizable $w 0 1
    wm protocol $w WM_DELETE_WINDOW "killWindow $w"

    set win [frame $w.users -relief raised]
    scrollbar $win.vscroller -command "$win.userList yview" 
    text $win.userList -yscrollcommand "bsSet $win.vscroller" \
      -width 14 -height 10 -relief flat -borderwidth 0
    bindtags $win.userList {null}
    button $win.ok -text OK -command "killWindow $w"
    pack $win.ok -side right -fill y
    pack $win.userList -side left -fill y -expand 1
    pack $win -expand 1 -fill y
    insertFriends $this
}
#
proc insertFriends {this} {
    global friendsOn UTO myid Fctl
    foreach fr [array names UTO] {
	set usr $UTO($fr)
	if {[$usr isFriend] && $usr != $myid} {
	    if $friendsOn {
		$usr configure -notify 1
		if [$usr ison] { $this add $usr }
	    } {
		$this add $usr
	    }
	}
    }
    if $friendsOn { [$Fctl($this) net] ISON }
}
#
proc friends_add {this usr} {
    if {{nil} != $usr} {
	if [$this menu] {
	    global Fctl
	    set w [$Fctl($this) window].bf1.friends.menu
	    if ![winfo exists $w.$usr] {
		$w add cascade -label [$usr name] -menu $w.$usr
		makeUserMenu nil $w.$usr $usr
	    }
	} \
	elseif [winfo exists .@$this] {
	    set win .@$this.users.userList
	    set winb $win.$usr
	    if ![winfo exists $winb] {
		menubutton $winb -text [$usr name] -menu $winb.menu -width 12
		makeUserMenu nil $winb.menu $usr
		$win window create end -window $winb
		if [$usr ison] { markButton $winb ison }
	    }
	}
    }
}
#
proc friends_remove {this usr} {
    if [$this menu] {
	global Fctl
	set ctl [$Fctl($this) window]
	if {[set x [indexHack $ctl.bf1.friends.menu [$usr name] 0]] >= 0} {
	    $ctl.bf1.friends.menu delete $x
	}
    } \
    elseif [winfo exists .@$this.users.userList.$usr] {
	global friendsOn
	if $friendsOn {
	    if [normal .@$this.users.userList.$usr] {
		destroy .@$this.users.userList.$usr
	    }
	} {
	    $this mark $usr {}
	}
	popup .@$this
    }
}
