.\"
.TH ZSHOPTIONS 1 "March 2, 1995" "zsh version 2.7"
.SH NAME
zshoptions \- zsh options
.SH DESCRIPTIONS
The following options may be set upon invocation of the shell,
or with the \fBset\fP or \fBsetopt\fP builtins. They are case insensitive and
underscores are ignored, that is, "allexport" is equivalent to "A__lleXP_ort".
.RS
.PD 0
.TP
\fBALL_EXPORT\fP (\-\fBa\fP)
All parameters subsequently defined are automatically exported.
.TP
\fBALWAYS_LAST_PROMPT\fP
If unset, key functions that list completions try to return to the last
prompt if given a numeric argument. If set these functions try to
return to the last prompt if given \fBno\fP numeric argument.
.TP
\fBALWAYS_TO_END\fP
If a completion with the cursor in the word was started and it results
in only one match, the cursor is placed at the end of the word.
.TP
\fBAPPEND_HISTORY\fP
If this is set, zsh sessions will append their history list to
the history file, rather than overwrite it. Thus, multiple parallel
zsh sessions will all have their history lists added to the
history file, in the order they are killed.
.TP
\fBAUTO_CD\fP (\-\fBJ\fP)
If a command is not in the hash table, and there exists an
executable directory by that name, perform the \fBcd\fP
command to that directory.
.TP
\fBAUTO_LIST\fP (\-\fB9\fP)
Automatically list choices on an ambiguous completion.
.TP
\fBAUTO_MENU\fP
Automatically use menu completion after the second consecutive request for
completion, for example by pressing the \fPTAB\fP key repeatedly. This option
is overridden by \fBMENU_COMPLETE\fP.
.TP
\fBAUTO_NAME_DIRS
Any parameter that is set to the absolute name of a directory
immediately becomes a name for that directory in the usual form
~param.  If this option is not set, the parameter must be used in that
form for it to become a name (a command-line completion is sufficient
for this).
.TP
\fBAUTO_PARAM_KEYS\fP
If a parameter name was completed and the next character typed is one
of those that have to come directly after the name (like `}', `:',
etc.) they are placed there automatically.
.TP
\fBAUTO_PARAM_SLASH\fP
If a parameter is completed whose content is the name of a directory,
then add a trailing slash.
.TP
\fBAUTO_PUSHD\fP (\-\fBN\fP)
Make \fBcd\fP act like \fBpushd\fP.
.TP
\fBAUTO_REMOVE_SLASH\fP
When the last character resulting from a completion is a slash and the next
character typed is a word delimiter, remove the slash.
.TP
\fBAUTO_RESUME\fP (\-\fBW\fP)
Treat single word simple commands without redirection
as candidates for resumption of an existing job.
.TP
\fBBG_NICE\fP (\-\fB6\fP)
Run all background jobs at a lower priority.  This option
is set by default.
.TP
\fBBRACE_CCL\fP
Expand expressions in braces which would not otherwise undergo brace
expansion to a lexically ordered list of all the characters.  See the
section \fBBRACE EXPANSION\fP in the \fBzshexpn\fP manual page.
.TP
\fBBSD_ECHO\fP
Make the \fBecho\fP builtin compatible with the BSD \fBecho\fP(1) command.
This disables backslashed escape sequences in echo strings unless the
-\fBe\fP option is specified.
.TP
\fBCDABLE_VARS\fP (\-\fBT\fP)
If the argument to a \fBcd\fP command (or an implied \fBcd\fP with the
\fBAUTO_CD\fP option set) is not a directory, and does not begin with a
slash, try to expand the expression as if it were preceded by a ~ (see
\fBFilename Expansion\fP above).
.TP
\fBCHASE_LINKS\fP (\-\fBw\fP)
Resolve symbolic links to their true values.
.TP
\fBCOMPLETE_ALIASES\fP
If set, aliases on the command line are not internally substituted
before completion is attempted.
.TP
\fBCOMPLETE_IN_WORD\fP
If unset, the cursor is set to the end of the word if completion is
started. Otherwise it stays there and completion is done from both ends.
.TP
\fBCORRECT\fP (\-\fB0\fP)
Try to correct the spelling of commands.
.TP
\fBCORRECT_ALL\fP (\-\fBO\fP)
Try to correct the spelling of all arguments in a line.
.TP
\fBCSH_JUNKIE_HISTORY\fP
A history reference without an event specifier will always refer to the
previous command.
.TP
\fBCSH_JUNKIE_LOOPS\fP
Allow loop bodies to take the form
"\fIlist\fP; \fBend\fP" instead of
"\fBdo\fP \fIlist\fP; \fBdone\fP".
.TP
\fBCSH_JUNKIE_PAREN\fP
Allow \fBfor\fP, \fBif\fP and \fBwhile\fP loops where the argument
list is given in parentheses.  Otherwise, the parentheses will be
treated as specifying a subshell.
.TP
\fBCSH_JUNKIE_QUOTES\fP
Complain if a quoted expression runs off the end of a line;
prevent quoted expressions from containing unescaped newlines.
.TP
\fBCSH_NULL_GLOB\fP
If a pattern for filename generation has no matches,
delete the pattern from the argument list;
do not report an error unless all the patterns
in a command have no matches.
Overrides \fBNULLGLOB\fP.
.TP
\fBERR_EXIT\fP (\-\fBe\fP)
If a command has a non-zero exit status, execute the \fBZERR\fP
trap, if set, and exit.  This is disabled while running initialization
scripts.
.TP
\fBEXTENDED_GLOB\fP
Treat the #, ~ and ^ characters as part of patterns for filename
generation, etc.  (An initial unquoted ~ always produces named
directory expansion as in \fBFilename Expansion\fP above.)
.TP
\fBEXTENDED_HISTORY\fP
Save beginning and ending timestamps to the history file.
The format of these timestamps is
\fI:<beginning time>:<ending time>:<command>.\fP
.TP
\fBGLOB_COMPLETE\fP
When the current word has a glob pattern, do not insert all the words
resulting from the expansion but cycle through them like
\fBMENU_COMPLETE\fP. If no matches are found, a `*' is added to the end of the
word or inserted at the cursor if \fBCOMPLETE_IN_WORD\fP is set, and expansion
is attempted again. Using patterns works not only for files but for all
completions, such as options, user names, etc.
.TP
\fBGLOB_DOTS\fP (\-\fB4\fP)
Do not require a leading . in a filename to be matched explicitly.
.TP
\fBGLOB_SUBST\fP
Treat any characters resulting from parameter substitution as being
eligible for file expansion and filename generation, and any
characters resulting from command substitution as being eligible for
filename generation.
.TP
\fBHASH_CMDS\fP
Place the location of each command in the hash table the first
time it is executed.  If this option is unset, no path hashing
will be done at all.
.TP
\fBHASH_DIRS\fP
Whenever a command is executed, hash the directory containing it,
as well as all directories that occur earlier in the path.
Has no effect if \fBHASH_CMDS\fP is unset.
.TP
\fBHASH_LIST_ALL\fP
Whenever a command completion is attempted, make sure the entire
command path is hashed first.  This makes the first completion slower.
.TP
\fBHIST_ALLOW_CLOBBER\fP
Add `|' to output redirections in the history.  This allows history
references to clobber files even when \fBNO_CLOBBER\fP is set.
.TP
\fBHIST_IGNORE_DUPS\fP (\-\fBh\fP)
Do not enter command lines into the history list
if they are duplicates of the previous event.
.TP
\fBHIST_IGNORE_SPACE\fP (\-\fBg\fP)
Do not enter command lines into the history list
if any command on the line begins with a blank.
.TP
\fBHIST_NO_STORE\fP
Remove the \fBhistory\fP (\fBfc\fP \-\fBl\fP) command from
the history when invoked.
.TP
\fBHIST_VERIFY\fP
Whenever the user enters a line with history substitution,
don't execute the line directly; instead, perform
history substitution and reload the line into the editing buffer.
.TP
\fBIGNORE_BRACES\fP (\-\fBI\fP)
Do not perform brace expansion.
.TP
\fBIGNORE_EOF\fP (\-\fB7\fP)
Do not exit on end-of-file.  Require the use
of \fBexit\fP or \fBlogout\fP instead.
.TP
\fBINTERACTIVE\fP (\-\fBi\fP)
This is an interactive shell.
.TP
\fBINTERACTIVE_COMMENTS\fP (\-\fBk\fP)
Allow comments even in interactive shells.
.TP
\fBKSH_OPTION_PRINT\fP
Alters the way options settings are printed.
.TP
\fBLIST_AMBIGUOUS\fP
If this option is set, completions are shown only if the completions
don't have a unambiguous prefix or suffix that could be inserted in
the command line.
.TP
\fBLIST_TYPES\fP (\-\fBX\fP)
When listing files that are possible completions, show the
type of each file with a trailing identifying mark.
.TP
\fBLOCAL_OPTIONS\fP
If this option is set at the point of return from a shell function,
all the options (including this one) which were in force upon entry to
the function are restored.  Otherwise, only this option and the
\fBXTRACE\fP and \fBPRINT_EXIT_VALUE\fP options are restored.  Hence
if this is explicitly unset by a shell function the other options in
force at the point of return will remain so.
.TP
\fBLOGIN\fP (\-\fBl\fP)
This is a login shell.
.TP
\fBLONG_LIST_JOBS\fP (\-\fBR\fP)
List jobs in the long format by default.
.TP
\fBMAGIC_EQUAL_SUBST\fP
All unquoted arguments of the from \fIidentifier\fB=\fIexpression\fR
have file expansion performed on \fIexpression\fR as if it were a
parameter assignment, although the argument is not otherwise treated
specially.
.TP
\fBMAIL_WARNING\fP (\-\fBU\fP)
Print a warning message if a mail file has been
accessed since the shell last checked.
.TP
\fBMARK_DIRS\fP (\-\fB8\fP)
Append a trailing / to all directory
names resulting from filename generation (globbing).
.TP
\fBMENU_COMPLETE\fP (\-\fBY\fP)
On an ambiguous completion, instead of listing possibilities or beeping,
insert the first match immediately.  Then when completion is requested
again, remove the first match and insert the second match, etc.
When there are no more matches, go back to the first one again.
\fBreverse-menu-complete\fP may be used to loop through the list
in the other direction. This option overrides \fBAUTO_MENU\fP.
.TP
\fBMONITOR\fP (\-\fBm\fP)
Allow job control.  Set by default in interactive shells.
.TP
\fBNO_BAD_PATTERN\fP (\-\fB2\fP)
If a pattern for filename generation is badly formed,
leave it unchanged in the argument list instead of
printing an error.
.TP
\fBNO_BANG_HIST\fP (\-\fBK\fP)
Do not perform textual history substitution.  Do not
treat the ! character specially.
.TP
\fBNO_BEEP\fP (\-\fBB\fP)
Do not beep.
.TP
\fBNO_CLOBBER\fP (\-\fB1\fP)
Prevents \fB>\fP redirection from truncating existing files.
\fB>!\fP may be used to truncate a file instead.
Also prevents \fB>>\fP from creating files.
\fB>>!\fP may be used instead.
.TP
\fBNO_EQUALS\fP
Don't perform \fB=\fP filename substitution.
.TP
\fBNO_EXEC\fP (\-\fBn\fP)
Read commands and check them for syntax errors, but do not execute them.
.TP
\fBNO_GLOB\fP (\-\fBF\fP)
Disable filename generation.
.TP
\fBNO_FLOW_CONTROL\fP
Disable output flow control via start/stop characters (usually assigned to
^S/^Q) in the shell's editor.
.TP
\fBNO_HIST_BEEP\fP
Don't beep when an attempt is made to access a history entry which
isn't there.
.TP
\fBNO_HUP\fP
Don't send the \fBHUP\fP signal to running jobs when the
shell exits.
.TP
\fBNO_LIST_BEEP\fP
Don't beep on an ambiguous completion.
.TP
\fBNO_NOMATCH\fP (\-\fB3\fP)
If a pattern for filename generation has no matches,
leave it unchanged in the argument list instead of
printing an error.  This also applies to file expansion 
of an initial ~ or =.
.TP
\fBNO_PROMPT_CR\fP (\-\fBV\fP)
Don't print a carriage return just before printing
a prompt in the line editor.
.TP
\fBNO_RCS\fP (\-\fBf\fP)
Source only the /etc/zshenv file.
Do not source the .zshenv, /etc/zprofile, .zprofile,
/etc/zshrc, .zshrc, /etc/zlogin, .zlogin, or .zlogout files.
.TP
\fBNO_SHORT_LOOPS\fP
Disallow the short forms of \fBfor\fP, \fBselect\fP,
\fBif\fP, and \fBfunction\fP constructs.
.TP
\fBNOTIFY\fP (\-\fB5\fP)
Report the status of background jobs immediately, rather than
waiting until just before printing a prompt.
.TP
\fBNO_UNSET\fP (\-\fBu\fP)
Treat unset parameters as an error when substituting.
.TP
\fBNULL_GLOB\fP (\-\fBG\fP)
If a pattern for filename generation has no matches,
delete the pattern from the argument list instead
of reporting an error.  Overrides \fBNO_NOMATCH\fP.
.TP
\fBNUMERIC_GLOB_SORT\fP
If numeric filenames are matched by a filename generation pattern,
sort the filenames numerically rather than lexicographically.
.TP
\fBOVER_STRIKE\fP
Start up the line editor in overstrike mode.
.TP
\fBPATH_DIRS\fP (\-\fBQ\fP)
Perform a path search even on command names with slashes in them.
Thus if "/usr/local/bin" is in the user's path, and he types
"X11/xinit", the command "/usr/local/bin/X11/xinit" will be executed
(assuming it exists).
This applies to the \fB\&.\fP builtin as well as to command execution.
Commands explicitly beginning with "./" or "../" are not subject to
path search.
.TP
\fBPRINT_EXIT_VALUE\fP (\-\fBC\fP)
Print the exit value of programs with non-zero exit status.
.TP
\fBPRIVILEGED\fP (\-\fBp\fP)
Turn on privileged mode. This is enabled automatically on startup if the
effective user (group) id is not equal to the real user (group) id. Turning
this option off causes the effective user and group ids to be set to the
real user and group ids. This option disables sourcing user startup files.
If \fIzsh\fP is invoked as \fIsh\fP or \fIksh\fP with this option set,
\fI/etc/suid_profile\fP is sourced (after \fI/etc/profile\fP on interactive
shells). Sourcing \fI~/.profile\fP is disabled and the contents of the
\fBENV\fP variable is ignored. This option cannot be changed using the
\-\fBm\fP option of \fBsetopt\fP and \fBunsetopt\fP and changing it inside a
function always changes it globally regardless of the \fBLOCAL_OPTIONS\fP
option.
.TP
\fBPROMPT_SUBST\fP
If set expressions like \fB${...}\fP, \fB$(...)\fP, \fB$[...]\fP and
\fB$((...))\fP in prompts will be expanded.
.TP
\fBPUSHD_IGNORE_DUPS\fP
Don't push multiple copies of the same directory onto the directory stack.
.TP
\fBPUSHD_MINUS\fP
See \fBpopd\fP below.
.TP
\fBPUSHD_SILENT\fP (\-\fBE\fP)
Do not print the directory stack after \fBpushd\fP
or \fBpopd\fP.
.TP
\fBPUSHD_TO_HOME\fP (\-\fBD\fP)
Have \fBpushd\fP with no arguments act like
\fBpushd\fP $HOME.
.TP
\fBRC_EXPAND_PARAM\fP (\-\fBP\fP)
Array expansions of the form
\fIfoo\fB${\fIxx\fB}\fIbar\fR, where the parameter
\fIxx\fP is set to (\fIa b c\fP), are substituted with
\fIfooabar foobbar foocbar\fP instead of the default
\fIfooa b cbar\fP.
.TP
\fBRC_QUOTES\fP
Allow the character sequence \fB''\fP to signify a single quote
within singly quoted strings.
.TP
\fBREC_EXACT\fP (\-\fBS\fP)
In completion, recognize exact matches even
if they are ambiguous.
.TP
\fBRM_STAR_SILENT\fP (\-\fBH\fP)
Do not query the user before executing "rm *" or "rm path/*".
.TP
\fBSHIN_STDIN\fP (\-\fBs\fP)
Read commands from the standard input.
.TP
\fBSH_WORD_SPLIT\fP (\-\fBy\fP)
See \fIParameter Expansion\fP.
.TP
\fBSINGLE_LINE_ZLE\fP (\-\fBM\fP)
Use single-line command line editing instead of multi-line.
.TP
\fBSUN_KEYBOARD_HACK\fP (\-\fBL\fP)
If a line ends with a backquote, and there are an odd number
of backquotes on the line, ignore the trailing backquote.
This is useful on some keyboards where the return key is
too small, and the backquote key lies annoyingly close to it.
.TP
\fBVERBOSE\fP (\-\fBv\fP)
Print shell input lines as they are read.
.TP
\fBXTRACE\fP (\-\fBx\fP)
Print commands and their arguments as they are executed.
.TP
\fBZLE\fP (\-\fBZ\fP)
Use the zsh line editor.

