//  
//  Copyright (c) 1994 by Mike Romberg (  romberg@md.fsl.noaa.gov )
//
//  This file may be distributed under terms of the GPL
//

#include "swapmeter.h"
#include <sys/pstat.h>

static const char COLORS[2][33] = { "blue", "green" };


SwapMeter::SwapMeter( XOSView *parent, int x, int y, int width, int height )
: FieldMeter( parent, x, y, width, height, 2, "SWAP", "USED/FREE" ){
  for ( int i = 0 ; i < 2 ; i++ )
    setfieldcolor( i, COLORS[i] );
}

SwapMeter::~SwapMeter( void ){
}

void SwapMeter::checkevent( void ){
  static int pass = 0;

  pass = (pass + 1)%5;
  if ( pass != 0 )
    return;
  
  getswapinfo();
  drawfields();
}

void SwapMeter::getswapinfo( void ){
  struct pst_dynamic stats;

  pstat_getdynamic( &stats, sizeof( pst_dynamic ), 1, 0 );

  total_ = stats.psd_vm;	

  fields_[0] = stats.psd_avm;
  fields_[1] = total_ - stats.psd_avm;
}
