/*
   config.h

   Copyright (C) 1996 Free Software Foundation, Inc.

   Author: Scott Christley <scottc@net-community.com>
   Author: Ovidiu Predescu <ovidiu@net-community.com>
   Date: 1996
   
   This file is part of the GNUstep GUI Library.

   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.
   
   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   You should have received a copy of the GNU Library General Public
   License along with this library; if not, write to the Free
   Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

#ifndef _GNUstep_H_config
#define _GNUstep_H_config

#include <Foundation/NSGeometry.h>

/* Define NSDebugLog if not defined */
#ifndef NSDebugLog
# ifdef DEBUGLOG
#  define NSDebugLog(format, args...) NSLog(format, ## args)
# else
#  define NSDebugLog(format, args...)
# endif
#endif /* !NSDebugLog */

extern BOOL initialize_gnustep_backend (void);

#ifndef OBJC_MALLOC
# define OBJC_MALLOC(pointer, type, elements) \
	(pointer = calloc (sizeof(type), elements))
#endif

#ifndef OBJC_FREE
# define OBJC_FREE(pointer) \
	if (pointer) free(pointer)
#endif

#endif /* _GNUstep_H_config */
