/* 
   PXKTextField.m

   NSTextField for GNUstep GUI X/DPS Backend.

   Copyright (C) 1996 Free Software Foundation, Inc.

   Author:  Pascal Forget <pascal@wsc.com>
   Author: Ovidiu Predescu <ovidiu@bx.logicnet.ro>
   Date: March 1996
   
   This file is part of the GNUstep GUI X/DPS Backend.

   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.
   
   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   You should have received a copy of the GNU Library General Public
   License along with this library; see the file COPYING.LIB.
   If not, write to the Free Software Foundation,
   59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
*/ 

#include <config.h>
#include <stdlib.h>
#include <AppKit/NSEvent.h>
#include <AppKit/NSWindow.h>
#include <gnustep/xdps/PXKTextFieldCell.h>
#include <gnustep/xdps/PXKTextField.h>
#include <gnustep/xdps/PXKView.h>
#include <gnustep/xdps/PXKApplication.h>
#include <AppKit/NSCursor.h>

@implementation PXKTextField

+ (void)initialize
{
  static BOOL initialized = NO;

  if (!initialized) {
    initialized = YES;
    [self setCellClass:[PXKTextFieldCell class]];
  }
}

- (void)selectText:sender
{
  [super selectText: sender];
  [self setNeedsDisplay:YES];
}
			       
/*
 * Get characters until you encounter
 * a carriage return, return number of characters.
 * Deal with backspaces, etc.  Deal with Expose events
 * on all windows associated with this application.
 * Deal with keyboard remapping.
 */

- (void)keyDown:(NSEvent *)theEvent;
{
  unsigned int flags = [theEvent modifierFlags];
  unsigned int key_code = [theEvent keyCode];
  id nextResponder;

  NSDebugLog(@"PXKTextField: -keyDown %s\n", [[theEvent characters] cString]);

  // If TAB, SHIFT-TAB or RETURN key then make another text the first
  // responder. This depends on key.
  if (key_code == 0x09 || key_code == 0x0d) {
    if (key_code == 0x09 && (flags & NSShiftKeyMask))
      nextResponder = previous_text;
    else
      nextResponder = next_text;

    if ([nextResponder respondsToSelector:@selector(selectText:)])
      // Either select the previous' text
      [nextResponder selectText:self];
    else
      // Or select ourself
      [self selectText:self];

    // Have the target perform the action
    [self sendAction:[self action] to:[self target]];
    return;
  }

  // If not editable then don't recognize the key down
  if (![self isEditable]) return;

  // Hide the cursor during typing
  [NSCursor hide];

  [self lockFocus];
  [[self cell] _handleKeyEvent:theEvent];
  [self unlockFocus];
  [self setNeedsDisplay:YES];
}

- (void)mouseDown:(NSEvent *)theEvent;
{
  NSPoint location = [self convertPoint:[theEvent locationInWindow]
			   fromView:nil];

  [[self cell] _setCursorLocation:location];
  [[self cell] _setCursorVisibility: YES];
  if ([[self window] makeFirstResponder:self])
  [self setNeedsDisplay:YES];
}

@end
