------------------------------------------------------------------------------
--                                                                          --
--                 GNU ADA RUNTIME LIBRARY (GNARL) COMPONENTS               --
--                                                                          --
--     S Y S T E M . T A S K _ P R I M I T I V E S . O P E R A T I O N S    --
--                                                                          --
--                                  B o d y                                 --
--                         (Version for new GNARL)                          --
--                                                                          --
--                             $Revision: 1.28 $                            --
--                                                                          --
--            Copyright (C) 1991-1997, Florida State University             --
--                                                                          --
-- GNARL is free software; you can  redistribute it  and/or modify it under --
-- terms of the  GNU General Public License as published  by the Free Soft- --
-- ware  Foundation;  either version 2,  or (at your option) any later ver- --
-- sion. GNARL is distributed in the hope that it will be useful, but WITH- --
-- OUT ANY WARRANTY;  without even the  implied warranty of MERCHANTABILITY --
-- or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License --
-- for  more details.  You should have  received  a copy of the GNU General --
-- Public License  distributed with GNARL; see file COPYING.  If not, write --
-- to  the Free Software Foundation,  59 Temple Place - Suite 330,  Boston, --
-- MA 02111-1307, USA.                                                      --
--                                                                          --
-- As a special exception,  if other files  instantiate  generics from this --
-- unit, or you link  this unit with other files  to produce an executable, --
-- this  unit  does not  by itself cause  the resulting  executable  to  be --
-- covered  by the  GNU  General  Public  License.  This exception does not --
-- however invalidate  any other reasons why  the executable file  might be --
-- covered by the  GNU Public License.                                      --
--                                                                          --
-- GNARL was developed by the GNARL team at Florida State University. It is --
-- now maintained by Ada Core Technologies Inc. in cooperation with Florida --
-- State University (http://www.gnat.com).                                  --
--                                                                          --
------------------------------------------------------------------------------

--  This is a Solaris version of this package.

--  DO NOT EDIT this file.
--  It was automatically generated from another file by the m4 macro processor.
--  The name of the file you should edit is the same as this one, but with
--  ".ads" replaced by ".sm4", or
--  ".adb" replaced by ".bm4", or
--  ".c" replaced by ".cm4", or
--  ".dat" replaced by ".tm4"

--  Local options selected:
--    __TARGET            = sparc-sun-solaris2
--    __ARCH              = SPARC
--    __OS                = SUNOS5X
--    __HAS_SIGCONTEXT    = 0
--    __HAS_UCONTEXT      = 1
--    __THREADS           = SOLARIS_THREADS
--    __THREAD_VARIANT    = NA
--    __HAS_TIMESPEC      = 1
--    __HAS_NANOSLEEP     = 1
--    __HAS_CLOCK_GETTIME = 1
--    __HAS_GETTIMEOFDAY  = 1
--    __POSIX_THREAD_PRIO_PROTECT = 0
--    __POSIX_THREAD_PRIO_INHERIT = 0
--    __POSIX_THREAD_ATTR_STACKADDR = 0
--    __POSIX_THREAD_ATTR_STACKSIZE = 0
--    __POSIX_THREAD_PRIORITY_SCHEDULING = 0

with Ada.Exceptions;
--  used for Null_ID, in New_Fake_ATCB

with GNAT.OS_Lib;
--  used for String_Access, Getenv

with Interfaces.C;
--  used for int
--           long
--           size_t

with System.Error_Reporting;
--  used for Shutdown

with System.Interrupt_Management;
--  used for Keep_Unmasked
--           Abort_Task_Interrupt
--           Interrupt_ID

with System.Interrupt_Management.Operations;
--  used for Set_Interrupt_Mask
--           All_Tasks_Mask
pragma Elaborate_All (System.Interrupt_Management.Operations);

with System.OS_Interface;
--  used for various type, constant, and operations

with System.Parameters;
--  used for Size_Type

with System.Tasking;
--  used for Ada_Task_Control_Block
--           Task_ID

with System.Assertions;
pragma Elaborate_All (System.Assertions);

with System.Task_Specific_Data;
--  to initialize TSD for a C thread, in function Self

with System.Task_Info;
--  to initialize Task_Info for a C thread, in function Self

with Unchecked_Conversion;
with Unchecked_Deallocation;

package body System.Task_Primitives.Operations is

   use System.Tasking;
   use Interfaces.C;
   use System.Error_Reporting;
   use System.OS_Interface;
   use System.Parameters;

   ------------------
   --  Local Data  --
   ------------------

   ATCB_Magic_Code : constant := 16#ADAADAAD#;
   --  This is used to allow us to catch attempts to call Self
   --  from outside an Ada task, with high probability.
   --  For an Ada task, Task_Wrapper.Magic_Number = ATCB_Magic_Code.

   Environmental_Task_ID : Task_ID;
   --  A variable to hold Task_ID for the environmental task.
   --  If we use this variable to get the Task_ID, we not need the following
   --  ATCB_Key only for non-Ada threads

   ATCB_Key : aliased thread_key_t;
   --  Key used to find the Ada Task_ID associated with a thread,
   --  at least for C threads unknown to the Ada runtime system.

   --  The followings are internal configuration constants needed.

   Default_Stack_Size : constant Interfaces.C.size_t := 0;

   Minimum_Stack_Size : constant Interfaces.C.size_t := thr_min_stack;

   --  The following are used to allow the Self function to
   --  automatically generate ATCB's for C threads that happen to call
   --  Ada procedure, which in turn happen to call the Ada runtime system.

   Result : Interfaces.C.Int;
   type Fake_ATCB;
   type Fake_ATCB_Ptr is access Fake_ATCB;
   type Fake_ATCB_Ptr_Ptr is access Fake_ATCB;
   type Fake_ATCB is record
      Stack_Base : Interfaces.C.Unsigned := 0;
      --  A value of zero indicates the node is not in use.
      Next : Fake_ATCB_Ptr;
      Real_ATCB : Task_ID;
      --  ???? Consider making System.Tasking.Task_ID "access all"
      --  so that we can put the ATCB directly in here?
   end record;
   Fake_ATCB_List : Fake_ATCB_Ptr;
   --  A linear linked list.
   --  The list is protected by Fake_Task_Lock;
   --  Nodes are added to this list from the front.
   --  Once a node is added to this list, it is never removed.

   Next_ATCB : Task_ID;
   Next_Fake_ATCB : Fake_ATCB_Ptr;
   --  Because Ada allocator's call Self, we cannot allocate new
   --  ATCB's until we have a Task_ID.  Therefore, we must require
   --  that thre always be at least one free ATCB.
   --  This is preallocated first in Initialize, and
   --  then is replenished in New_Fake_ATCB, but only after we have
   --  a valid Task_ID.  It is protected by Fake_Task_Lock.

   Fake_Task_Lock : aliased RTS_Lock;

   --  ????
   --  Consider merging this lock with
   --  System.Tasking.Initialization.Global_Lock,
   --  and exporting the Task_Lock and Task_Unlock operations
   --  from this package, instead of that one.
   --  Beware that doing so could be messy, since Task_Lock
   --  calls Self, and Self conditionally calls Task_Lock,
   --  both implicitly via "new".

   Fake_Task_Elaborated : aliased Boolean := True;
   --  Used to identify fake tasks (i.e., non-Ada Threads).

   --  The followings are logically constants, but need to be initialized
   --  at run time.

   -----------------------
   -- Local Subprograms --
   -----------------------

   procedure Abort_Handler
     (Sig     : Signal;
      Code    : access siginfo_t;
      Context : access ucontext_t);

   function To_Task_ID is new Unchecked_Conversion (System.Address, Task_ID);

   function To_Master_ID is
     new Unchecked_Conversion (System.Address, Master_ID);

   function To_Address is new Unchecked_Conversion (Task_ID, System.Address);

   function To_Task_Info is
     new Unchecked_Conversion (Boolean, System.Task_Info.Task_Info_Type);

   type Ptr is access Task_ID;
   function To_Ptr is new Unchecked_Conversion (Interfaces.C.Unsigned, Ptr);
   function To_Ptr is new Unchecked_Conversion (System.Address, Ptr);

   type Iptr is access Interfaces.C.Unsigned;
   function To_Iptr is new Unchecked_Conversion (Interfaces.C.Unsigned, Iptr);

   function Thread_Body_Access is
     new Unchecked_Conversion (System.Address, Thread_Body);

   --  ???? Consider moving into Initialize_ATCB the portions of the
   --  following that are safe to do identically for real Ada tasks.

   function New_Fake_ATCB (Stack_Base : Interfaces.C.Unsigned)
     return Task_ID;

   function New_Fake_ATCB (Stack_Base : Interfaces.C.Unsigned)
     return Task_ID is
      Self_ID : Task_ID := Null_Task;
      P, Q : Fake_ATCB_Ptr;
      Succeeded : Boolean;
   begin
      --  This section is ticklish.
      --  We dare not call anything that might require an ATCB, until
      --  we have the new ATCB in place.
      Write_Lock (Fake_Task_Lock'Access);
      Q := null; P := Fake_ATCB_List;
      while P /= null loop
         if P.Stack_Base = 0 then
            Q := P;
         elsif thr_kill (P.Real_ATCB.LL.Thread, 0) /= 0 then
            --  ????
            --  If a C thread that has dependent Ada tasks terminates
            --  abruptly, e.g. as a result of cancellation, any dependent
            --  tasks are likely to hang up in termination.
            P.Stack_Base := 0;
            Q := P;
         end if;
         P := P.Next;
      end loop;
      if Q = null then
         --  Create a new ATCB with zero entries.
         Self_ID := Next_ATCB;
         Next_ATCB := null;
         --  Do the low-level initialization.
         Initialize_TCB (Self_ID, Succeeded);
         if not Succeeded and then
            Shutdown ("Fake ATCB creation failed. (1)") then
            null;
            --  Shutdown never returns
         end if;
         Next_Fake_ATCB.all := (Stack_Base, Fake_ATCB_List, Self_ID);
         Fake_ATCB_List := Next_Fake_ATCB;
      else
         --  Reuse an existing fake ATCB.
         Self_ID := Q.Real_ATCB;
         Q.Stack_Base := Stack_Base;
      end if;
      --  Record this as the Task_ID for the current thread.
      Self_ID.LL.Thread := thr_self;
      if thr_setspecific (ATCB_Key, To_Address (Self_ID)) /= 0 and then
         Shutdown ("Fake ATCB creation failed. (2)") then
         null;
         --  Shutdown never returns.
      end if;
      --  Finally, it is safe to use an allocator in this thread.
      if Next_ATCB = null then
         Next_ATCB := new Ada_Task_Control_Block (0);
         Next_Fake_ATCB := new Fake_ATCB;
      end if;

      Self_ID.Aborting := False;
      Self_ID.Stage := Active;
      Self_ID.Accepting := Not_Accepting;
      Self_ID.Pending_Priority_Change := False;
      Self_ID.Terminate_Alternative := false;
      Self_ID.Pending_Action := False;

      Self_ID.Activation_Count := 0;
      Self_ID.Awake_Count := 1;                       --  Counting this task.
      Self_ID.Awaited_Dependent_Count := 0;
      Self_ID.Terminating_Dependent_Count := 0;
      Self_ID.Pending_ATC_Level := ATC_Level_Infinity;
      Self_ID.ATC_Nesting_Level := 1;                 --  1 deep; 0 = abnormal.
      Self_ID.Deferral_Level := 0;                    --  Start out Self_ID.
      --  Since this is not an ordinary Ada task, we will start out undeferred
      Self_ID.Global_Task_Lock_Nesting := 0;
      Self_ID.Exception_To_Raise := Ada.Exceptions.Null_Id;
      Self_ID.Call := null;

      Self_ID.Parent := Null_Task;
      Self_ID.Master_of_Task := To_Master_ID (0);
      --  System.Tasking.Initialization.Increment_Master (0) = 1
      Self_ID.Master_Within := To_Master_ID (-1);

      Self_ID.Elaborated := Fake_Task_Elaborated'Access;
      Self_ID.Activator := Null_Task;

      for L in Self_ID.Entry_Calls'Range loop
         Self_ID.Entry_Calls (L).Next := null;
         Self_ID.Entry_Calls (L).Self := Self_ID;
         Self_ID.Entry_Calls (L).Level := L;
      end loop;

      --  ????
      --  Let's hope we don't need Task_Entry_Point for C threads.
      Self_ID.Task_Entry_Point := null;
      --  ????
      --  Let's hope we don't need Task_Arg for C threads.
      Self_ID.Task_Arg := System.Null_Address;
      --  ????
      --  Let's hope we don't need Task_Info for C threads.
      Self_ID.Task_Info := To_Task_Info (False);
      --  ????
      --  Let's hope we don't need Stack_Size for C threads.
      --  If we really need the stack size, we will have to either call
      --  the Solaris-specific thr_stksegment, or invent another hack.
      Self_ID.Stack_Size := 0;

      --  ????
      --  For the Solaris native threads, we currently ignore priority.
      --  If Solaris starts supporting priority scheduling, or if this
      --  is ported to another target, we may want to fetch the current
      --  thread priority.
      Self_ID.Base_Priority := System.Priority'First;

      System.Task_Specific_Data.Create_TSD (Self_ID.Compiler_Data);

      --  ????
      --  The following call is commented out to avoid dependence on
      --  the System.Tasking.Initialization package.
      --  It seems that if we want Ada.Task_Attributes to work correctly
      --  for C threads we will need to raise the visibility of this soft
      --  link to System.Tasking_Soft_Links.
      --  We are putting that off until this new functionality is otherwise
      --  stable.
      --  System.Tasking.Initialization.Initialize_Attributes_Link.all (T);

      --  Must not unlock until Next_ATCB is again allocated.
      Unlock (Fake_Task_Lock'Access);

      return Self_ID;

   end New_Fake_ATCB;

   -------------------
   -- Abort_Handler --
   -------------------

   --  Target-dependent binding of inter-thread Abort signal to
   --  the raising of the Abort_Signal exception.

   --  The technical issues and alternatives here are essentially
   --  the same as for raising exceptions in response to other
   --  signals (e.g. Storage_Error).  See code and comments in
   --  the package body System.Interrupt_Management.

   --  Some implementations may not allow an exception to be propagated
   --  out of a handler, and others might leave the signal or
   --  interrupt that invoked this handler masked after the exceptional
   --  return to the application code.

   --  GNAT exceptions are originally implemented using setjmp()/longjmp().
   --  On most UNIX systems, this will allow transfer out of a signal handler,
   --  which is usually the only mechanism available for implementing
   --  asynchronous handlers of this kind.  However, some
   --  systems do not restore the signal mask on longjmp(), leaving the
   --  abort signal masked.

   --  Alternative solutions include:

   --       1. Change the PC saved in the system-dependent Context
   --          parameter to point to code that raises the exception.
   --          Normal return from this handler will then raise
   --          the exception after the mask and other system state has
   --          been restored (see example below).
   --       2. Use siglongjmp()/sigsetjmp() to implement exceptions.
   --       3. Unmask the signal in the Abortion_Signal exception handler
   --          (in the RTS).

   --  The following procedure would be needed if we can't lonjmp out of
   --  a signal handler.  (See below.)
   --  procedure Raise_Abort_Signal is
   --  begin
   --     raise Standard'Abort_Signal;
   --  end if;

   procedure Abort_Handler
     (Sig     : Signal;
      Code    : access siginfo_t;
      Context : access ucontext_t) is

      T : Task_ID := Self;

   begin
      --  Assuming it is safe to longjmp out of a signal handler, the
      --  following code can be used:

      if T.Deferral_Level = 0
        and then T.Pending_ATC_Level < T.ATC_Nesting_Level then
         raise Standard'Abort_Signal;
      end if;

      --  Otherwise, something like this is required:
      --  if not Abort_Is_Deferred.all then
      --    --  Overwrite the return PC address with the address of the
      --    --  special raise routine, and "return" to that routine's
      --    --  starting address.
      --    Context.PC := Raise_Abort_Signal'Address;
      --    return;
      --  end if;

   end Abort_Handler;

   ----------
   -- Self --
   ----------

   --  For Solaris version of RTS, we use a short cut to get the self
   --  information faster:
   --  We have noticed that on Sparc Solaris, the register g7 always
   --  contains the address near the frame pointer (fp) of the active
   --  thread (fixed offset). This means, if we declare a variable near
   --  the top of the stack for each threads (in our case in the task wrapper)
   --  and let the variable hold the Task_ID information, we can get the
   --  value without going through the thr_getspecific kernel call.
   --
   --  There are two things to take care in this trick.
   --
   --  1) We need to calculate the offset between the g7 value and the
   --     local variable address.
   --     Possible Solutions :
   --        a) Use gdb to figure out the offset.
   --        b) Figure it out during the elaboration of RTS by, say,
   --           creating a dummy task .....
   --     We used solution a) mainly because it is more efficient and keep
   --     the RTS being messed up with some stuff that most other system
   --     won't be using. (i.e. we may have to at least introduce dummy
   --     interfaces.... to do a specific thing for a specific target).
   --
   --     On Sparc Solaris the offset is #10#108# (= #16#6b#).
   --
   --  2) We can not use the same offset business for the main thread
   --     because we do not use a wrapper for the main thread.
   --     So, we use a global variable to store the Task_ID. The trick is
   --     to figure out if we need to use the value only looking at the
   --     contents of the g7 register. In Solaris2.4, g7 contains an address
   --     close to fp register (g7 > fp) when the control is in a thread
   --     other than the main thread. Therefore we use the diffenence
   --     between g7 and fp to get the infomation we need.
   --
   --  NOTE: What we are doing here is ABSOLUTELY for Solaris 2.4!!!!!!!
   --        We need to make sure this is OK when we move to other versions
   --        of the same OS.
   --        We always can go back to the old way of doing this and we include
   --        the code which use thr_getspecifics. Also, look for %%%%%
   --        in comments for other necessary modifications.

   --  function Self return Task_ID is
   --     Temp   : aliased System.Address;
   --     Result : Interfaces.C.int;
   --  begin
   --     Result := thr_getspecific (ATCB_Key, Temp'Unchecked_Access);
   --     pragma Assert (Result = 0
   --       or else Shutdown ("GNULLI failure---thr_getspecific"));
   --     return To_Task_ID (Temp);
   --  end Self;

   --  To make Ada tasks and C threads interoperate better, we have
   --  added some functionality to Self.  Suppose a C main program
   --  (with threads) calls an Ada procedure and the Ada procedure
   --  calls the tasking runtime system.  Eventually, a call will be
   --  made to self.  Since the call is not coming from an Ada task,
   --  there will be no corresponding ATCB.

   --  (The entire Ada runtime system may not have been elaborated,
   --  either, but that is a different problem, that we will need to
   --  solve another way.)

   --  What we do in Self is to catch references that do not come
   --  from recognized Ada tasks, and create an ATCB for the calling
   --  thread.

   --  The new ATCB will be "detached" from the normal Ada task
   --  master hierarchy, much like the existing implicitly created
   --  signal-server tasks.

   --  We will also use such points to poll for disappearance of the
   --  threads associated with any implicit ATCBs that we created
   --  earlier, and take the opportunity to recover them.

   --  A nasty problem here is the limitations of the compilation
   --  order dependency, and in particular the GNARL/GNULLI layering.
   --  To initialize an ATCB we need to assume System.Tasking has
   --  been elaborated.

   function Self return Task_ID is

      function Get_G7 return Interfaces.C.Unsigned;
      pragma Import (C, Get_G7, "get_g7");

      function Get_I6 return Interfaces.C.Unsigned;
      pragma Import (C, Get_I6, "get_i6");

      G7 : Interfaces.C.Unsigned := Get_G7;

      X : Ptr;

      Result : Interfaces.C.int;

   begin
      if G7 - Get_I6 > 16#10000# then
         --  if the difference of these two regs are big, we can say the
         --  content of g7 indicates that we are in the main thread.

         pragma Assert (Environmental_Task_ID /= null or else
            Shutdown ("Ada runtime system not initialized"));

         return Environmental_Task_ID;
      end if;

      if To_Iptr (G7 - 112).all /= Interfaces.C.Unsigned (ATCB_Magic_Code) then
         --  Check whether this is a thread we have seen before.
         --  112 = 108 + Magic_Type'Size/System.Storage_Unit
         declare
            C_Task : aliased System.Address;
         begin
            Result := thr_getspecific (ATCB_Key, C_Task'Unchecked_Access);

            pragma Assert (Result = 0 or else
               Shutdown ("Fake ATCB creation failed. (2)"));

            if C_Task = System.Null_Address then
               --  We are seeing this thread for the first time.
               return New_Fake_ATCB (G7);
            else
               return To_Task_ID (C_Task);
            end if;
         end;
      end if;

      G7 := G7 - 108;
      X := To_Ptr (G7);

      return X.all;

   end Self;

   ---------------------
   -- Initialize_Lock --
   ---------------------

   --  Note: mutexes and cond_variables needed per-task basis are
   --        initialized in Intialize_TCB and the Storage_Error is
   --        handled. Other mutexes (such as All_Tasks_Lock, Memory_Lock...)
   --        used in RTS is initialized before any status change of RTS.
   --        Therefore rasing Storage_Error in the following routines
   --        should be able to be handled safely.

   procedure Initialize_Lock
     (Prio : System.Any_Priority;
      L    : access Lock)
   is
      Result : Interfaces.C.int;

   begin
      Result := mutex_init (L, USYNC_THREAD, System.Null_Address);
      pragma Assert (Result = 0 or else Result = ENOMEM
           or else Shutdown ("GNULLI failure---mutex_init"));
      if Result = ENOMEM then
         raise STORAGE_ERROR;
      end if;
   end Initialize_Lock;

   procedure Initialize_Lock (L : access RTS_Lock) is
      Result : Interfaces.C.int;

   begin
      Result := mutex_init (L, USYNC_THREAD, System.Null_Address);
      pragma Assert (Result = 0 or else Result = ENOMEM
           or else Shutdown ("GNULLI failure---mutex_init"));
      if Result = ENOMEM then
         raise STORAGE_ERROR;
      end if;
   end Initialize_Lock;

   -------------------
   -- Finalize_Lock --
   -------------------

   procedure Finalize_Lock (L : access Lock) is
      Result : Interfaces.C.int;

   begin
      Result := mutex_destroy (L);
      pragma Assert (Result = 0
        or else Shutdown ("GNULLI failure---mutex_destroy"));
   end Finalize_Lock;

   procedure Finalize_Lock (L : access RTS_Lock) is
      Result : Interfaces.C.int;

   begin
      Result := mutex_destroy (L);
      pragma Assert (Result = 0
        or else Shutdown ("GNULLI failure---mutex_destroy"));
   end Finalize_Lock;

   ----------------
   -- Write_Lock --
   ----------------

   procedure Write_Lock (L : access Lock; Ceiling_Violation : out Boolean) is
      Self_ID      : Task_ID;
      Result       : Interfaces.C.int;

   begin
      Result := mutex_lock (L);
      pragma Assert (Result = 0 or else
        Shutdown ("GNULLI failure---mutex_lock"));
      Ceiling_Violation := False;
   end Write_Lock;

   procedure Write_Lock (L : access RTS_Lock) is
      Result : Interfaces.C.int;

   begin
      Result := mutex_lock (L);
      pragma Assert (Result = 0
          or else Shutdown ("GNULLI failure---mutex_lock"));
   end Write_Lock;

   procedure Write_Lock (T : Task_ID) is
      Result : Interfaces.C.int;

   begin
      Result := mutex_lock (T.LL.L'Access);
      pragma Assert (Result = 0
          or else Shutdown ("GNULLI failure---mutex_lock"));
   end Write_Lock;

   ---------------
   -- Read_Lock --
   ---------------

   procedure Read_Lock (L : access Lock; Ceiling_Violation : out Boolean) is
   begin
      Write_Lock (L, Ceiling_Violation);
   end Read_Lock;

   ------------
   -- Unlock --
   ------------

   procedure Unlock (L : access Lock) is
      Self_ID : Task_ID := Self;
      Result  : Interfaces.C.int;
   begin
      Result := mutex_unlock (L);
      pragma Assert (Result = 0
        or else Shutdown ("GNULLI failure---mutex_unlock"));
   end Unlock;

   procedure Unlock (L : access RTS_Lock) is
      Result : Interfaces.C.int;

   begin
      Result := mutex_unlock (L);
      pragma Assert (Result = 0
        or else Shutdown ("GNULLI failure---mutex_unlock"));
   end Unlock;

   procedure Unlock (T : Task_ID) is
      Result : Interfaces.C.int;

   begin
      Result := mutex_unlock (T.LL.L'Access);
      pragma Assert (Result = 0
        or else Shutdown ("GNULLI failure---mutex_unlock"));
   end Unlock;

   -------------
   --  Sleep  --
   -------------

   procedure Sleep (Self_ID : Task_ID) is
      Result : Interfaces.C.int;

   begin
      pragma Assert (Self_ID = Self
        or else Shutdown ("GNULLI failure---Self in Sleep"));
      Result := cond_wait (Self_ID.LL.CV'Access, Self_ID.LL.L'Access);
      --  EINTR is not considered a failure.
      pragma Assert (Result = 0 or else Result = EINTR
        or else Shutdown ("GNULLI failure---Sleep"));
   end Sleep;

   ---------------
   -- Sleep_For --
   ---------------

   procedure Sleep_For
     (Self_ID  : Task_ID;
      Rel_Time : Duration;
      Timedout : out Boolean)
   is
   begin
      Sleep_Until (Self_ID, Rel_Time + Clock, Timedout);
   end Sleep_For;

   -----------------
   -- Sleep_Until --
   -----------------

   --  For the delay implementation, we need to make sure we achieve
   --  following criterias:
   --  1) We have to delay at least for the amount requested.
   --  2) We have to give up CPU even though the actual delay does not
   --     result in blocking.
   --  3) The implementation has to be efficient so that the delay overhead
   --     is relatively cheap.
   --  1) and 2) are Ada requirements. Even though 2) is an Annex-D
   --     requirement we still want to provide the effect in all cases.
   --     The reason is that users may want to use short delays to implement
   --     their own scheduling effect in the absence of language provided
   --     scheduling policies.

   --  Implementation of Sleep_For (Until) can be simplfied for the
   --  systems on which the cond_timedwait() function does not
   --  return early. For the reason, we provide two different
   --  implementations. Test both versions and use the simpler one if possible.

   --   -----------------
   --   -- Sleep_Until --
   --   -----------------
   --
   --   procedure Sleep_Until
   --     (Self_ID  : Task_ID;
   --      Abs_Time : Duration;
   --      Timedout : out Boolean)
   --   is
   --      Request : aliased timespec;
   --      Result  : Interfaces.C.int;
   --
   --   begin
   --      pragma Assert (Self_ID = Self
   --        or else Shutdown ("GNULLI failure---Self in Sleep_Until"));
   --
   --      if Abs_Time <= Clock then
   --         Timedout := True;
   --         thr_yield;
   --         return;
   --      end if;
   --
   --      Request := To_Timespec (Abs_Time);
   --
   --      --  Perform delays until one of the following conditions is true:
   --      --  1) cond_timedwait wakes up due to time expiration.
   --      --  2) We were interrupted by an abort signal (abortion is pending).
   --      --  3) We received a wakeup, via cond_signal to our CV.
   --      --  4) An error has occurred in the OS-provided delay primitive.
   --      --  Conditions (1), (2), and (3) are normal.
   --      --  Condition (4) should never happen unless the OS is broken,
   --      --  or there is an error in our own runtime system code.
   --
   --      loop
   --         Result := cond_timedwait
   --           (Self_ID.LL.CV'Access, Self_ID.LL.L'Access, Request'Access);
   --
   --         if Result = 0 or else
   --           (Self_ID.Pending_Action and then
   --             Self_ID.Pending_ATC_Level < Self_ID.ATC_Nesting_Level)
   --         then
   --            Timedout := False;
   --            return;
   --         end if;
   --
   --         if Result = ETIME then
   --            exit;
   --         end if;
   --
   --         --  Other than a spurious wakeup is considered an erorr.
   --
   --         pragma Assert (Result = EINTR or else
   --           Shutdown ("GNULLI failure---Sleep_Until (cond_timedwait)"));
   --      end loop;
   --
   --      Timedout := True;
   --      thr_yield;
   --
   --   end Sleep_Until;

   procedure Sleep_Until
     (Self_ID  : Task_ID;
      Abs_Time : Duration;
      Timedout : out Boolean)
   is
      Request : aliased timespec;
      Result  : Interfaces.C.int;

   begin
      pragma Assert (Self_ID = Self
        or else Shutdown ("GNULLI failure---Self in Sleep_Until"));

      if Abs_Time <= Clock then
         Timedout := True;
         thr_yield;
         return;
      end if;

      Request := To_Timespec (Abs_Time);

      --  We loop until the requested delay is serviced. For early wakeups,
      --  we check the Clock again and re-request delays until we sleep
      --  at least for the specified amount.

      loop
         --  Perform delays until one of the following conditions is true:
         --  1) cond_timedwait wakes up due to time expiration.
         --  2) We were interrupted by an abort signal (abortion is pending).
         --  3) We received a wakeup, via cond_signal to our CV.
         --  4) An error has occurred in the OS-provided delay primitive.
         --  Conditions (1), (2), and (3) are normal.
         --  Condition (4) should never happen unless the OS is broken,
         --  or there is an error in our own runtime system code.

         loop
            Result := cond_timedwait
              (Self_ID.LL.CV'Access, Self_ID.LL.L'Access, Request'Access);

            if Result = 0 or else
              (Self_ID.Pending_Action and then
                Self_ID.Pending_ATC_Level < Self_ID.ATC_Nesting_Level)
            then
               Timedout := False;
               return;
            end if;

            if Result = ETIME then
               exit;
            end if;

            --  Other than a spurious wakeup is considered an erorr.

            pragma Assert (Result = EINTR or else
              Shutdown ("GNULLI failure---Sleep_Until (cond_timedwait)"));
         end loop;

         --  Make sure we delayed long enough. If we did, give up the
         --  CPU. Otherwise, request a delay again with unserviced amount
         --  of time.

         if (Abs_Time <= Clock) then
            Timedout := True;
            thr_yield;
            exit;
         else
            Request := To_Timespec (Abs_Time);
         end if;
      end loop;
   end Sleep_Until;

   -----------
   -- Clock --
   -----------

   function Clock return Duration is
      TS     : aliased timespec;
      Result : Interfaces.C.int;

   begin
      Result := clock_gettime (CLOCK_REALTIME, TS'Unchecked_Access);
      pragma Assert (Result = 0
        or else Shutdown ("GNULLI failure---clock_gettime"));
      return To_Duration (TS);
   exception
      when others =>
         pragma Assert (Shutdown ("exception in Clock"));
         return 0.0;
   end Clock;

   ------------
   -- Wakeup --
   ------------

   procedure Wakeup (T : Task_ID) is
      Result : Interfaces.C.int;

   begin
      Result := cond_signal (T.LL.CV'Access);
      pragma Assert (Result = 0
        or else Shutdown ("GNULLI failure---Wakeup"));
   end Wakeup;

   -----------
   -- Yield --
   -----------

   procedure Yield is
   begin
      System.OS_Interface.thr_yield;
   end Yield;

   ------------------
   -- Set_Priority --
   ------------------

   procedure Set_Priority (T : Task_ID; Prio : System.Any_Priority) is
   begin
      T.LL.Current_Priority := Interfaces.C.int (Prio);
   end Set_Priority;

   ------------------
   -- Get_Priority --
   ------------------

   function Get_Priority (T : Task_ID) return System.Any_Priority is
   begin
      return System.Any_Priority (T.LL.Current_Priority);
   end Get_Priority;

   ----------------
   -- Enter_Task --
   ----------------

   procedure Enter_Task (Self_ID : Task_ID) is
   begin

      Self_ID.LL.Thread := thr_self;

      --  Result := thr_setspecific (ATCB_Key, To_Address (Self_ID));
      --  pragma Assert (Result = 0
      --   or else Shutdown ("GNULLI failure---Enter_Task (thr_setspecific)"));
      --  We do not need above code if we do direct fetch of Task_ID in Self.
      --  %%%%%
   end Enter_Task;

   ----------------------
   --  Initialize_TCB  --
   ----------------------

   procedure Initialize_TCB (Self_ID : Task_ID; Succeeded : out Boolean) is
      Result : Interfaces.C.int;

   begin

      Result := mutex_init
        (Self_ID.LL.L'Access, USYNC_THREAD, System.Null_Address);
      pragma Assert (Result = 0 or else Result = ENOMEM
        or else Shutdown ("GNULLI failure---mutex_init"));
      if Result = 0 then
         Result := cond_init (Self_ID.LL.CV'Access, USYNC_THREAD, 0);
         pragma Assert (Result = 0 or else Result = ENOMEM
           or else Shutdown ("GNULLI failure---cond_init"));
         if Result /= 0 then
            Result := mutex_destroy (Self_ID.LL.L'Access);
            pragma Assert (Result = 0
              or else Shutdown ("GNULLI failure---mutex_destory"));
            Succeeded := False;
         else
            Succeeded := True;
         end if;
      else
         Succeeded := False;
      end if;

   end Initialize_TCB;

   -----------------
   -- Create_Task --
   -----------------

   procedure Create_Task
     (T          : Task_ID;
      Wrapper    : System.Address;
      Stack_Size : System.Parameters.Size_Type;
      Priority   : System.Any_Priority;
      Succeeded  : out Boolean)
   is
      Result     : Interfaces.C.int;
      Activator  : Task_ID := Self;
      --  This could be passed as a parameter.
      --  However, this infomation is needed only for Solaris.
      --  We did not want to modiy the procedure specification in the
      --  spec of this package which is shared by all implementations.

      Adjusted_Stack_Size : Interfaces.C.size_t;

      function Thread_Body_Access is new
        Unchecked_Conversion (System.Address, Thread_Body);

   begin
      if Stack_Size = System.Parameters.Unspecified_Size then
         Adjusted_Stack_Size := Default_Stack_Size;
      else
         if Stack_Size < Size_Type (Minimum_Stack_Size) then
            Adjusted_Stack_Size :=
              Interfaces.C.size_t (Stack_Size) + Minimum_Stack_Size;

            --  sum, instead of max:  may be overkill, but should be safe
            --  thr_min_stack is a function call.

            --  Actually, we want to get the Default_Stack_Size and
            --  Minimum_Stack_Size from the file System.Parameters.
            --  Right now the package is not made target specific.
            --  We use our own local definitions for now ???

         else
            Adjusted_Stack_Size := Interfaces.C.size_t (Stack_Size);
         end if;

      end if;

      --  Since the initial signal mask of a thread is inherited from the
      --  creator, and the Environment task has all its signals masked, we
      --  do not need to manipulate caller's signal mask at this point.
      --  All tasks in RTS will have All_Tasks_Mask initially.

      Result := thr_create
        (System.Null_Address,
         Adjusted_Stack_Size,
         Thread_Body_Access (Wrapper),
         To_Address (T),
         THR_DETACHED + THR_BOUND,
         T.LL.Thread'Access);

      Succeeded := Result = 0;
      pragma Assert (Result = 0 or else Result = ENOMEM
        or else Result = EAGAIN
        or else Shutdown ("GNULLI failure---Create_Task (thr_create)"));
   end Create_Task;

   ------------------
   -- Finalize_TCB --
   ------------------

   procedure Finalize_TCB (T : Task_ID) is
      Result : Interfaces.C.int;
      Tmp    : Task_ID := T;

      procedure Free is new
        Unchecked_Deallocation (Ada_Task_Control_Block, Task_ID);

   begin
      Result := mutex_destroy (T.LL.L'Access);
      pragma Assert (Result = 0
        or else Shutdown ("GNULLI failure---Finalize_TCB (mutex_destroy)"));
      Result := cond_destroy (T.LL.CV'Access);
      pragma Assert (Result = 0
        or else Shutdown ("GNULLI failure---Finalize_TCB (cond_destroy)"));
      Free (Tmp);
   end Finalize_TCB;

   ---------------
   -- Exit_Task --
   ---------------

   procedure Exit_Task is
   begin
      thr_exit (System.Null_Address);
   end Exit_Task;

   ----------------
   -- Abort_Task --
   ----------------

   procedure Abort_Task (T : Task_ID) is
      Result : Interfaces.C.int;

   begin
      Result := thr_kill (T.LL.Thread,
        Signal (System.Interrupt_Management.Abort_Task_Interrupt));
      pragma Assert (Result = 0
        or else Shutdown ("GNULLI failure---Abort_Task"));
   end Abort_Task;

   ----------------
   -- Initialize --
   ----------------

   procedure Initialize (Environment_Task : Task_ID) is
      act       : aliased struct_sigaction;
      old_act   : aliased struct_sigaction;
      Tmp_Set   : aliased sigset_t;
      Result    : Interfaces.C.int;

      procedure Configure_Processors;
      --  Processors configuration
      --  The user can specify a processor which the program should run
      --  on to emulate a single-processor system. This can be easily
      --  done by setting environment variable GNAT_PROCESSOR to one of
      --  the following :
      --
      --    -2 : use the default configuration (run the program on all
      --         available processors) - this is the same as having
      --         GNAT_PROCESSOR unset
      --    -1 : let the RTS choose one processor and run the program on
      --         that processor
      --    0 .. Last_Proc : run the program on the specified processor
      --
      --  Last_Proc is equal to the value of the system variable
      --  _SC_NPROCESSORS_CONF, minus one.

      procedure Configure_Processors is

         function sysconf (name : System.OS_Interface.int)
                           return processorid_t;
         pragma Import (C, sysconf, "sysconf");

         SC_NPROCESSORS_CONF : constant System.OS_Interface.int := 14;

         Proc_Acc : constant GNAT.OS_Lib.String_Access :=
                        GNAT.OS_Lib.Getenv ("GNAT_PROCESSOR");
      begin
         if Proc_Acc.all'Length /= 0 then
            --  Environment variable is defined
            declare
               Proc : aliased processorid_t;  --  User processor #
               Last_Proc : processorid_t;     --  Last processor #

            begin
               Last_Proc := sysconf (SC_NPROCESSORS_CONF) - 1;
               if Last_Proc = processorid_t'(-1) then
                  System.Error_Reporting.Trace (
         "Warning: unable to read system variable _SC_NPROCESSORS_CONF");
                  System.Error_Reporting.Trace (
         "Warning: ignored environment variable GNAT_PROCESSOR");
               else
                  Proc := processorid_t'Value (Proc_Acc.all);
                  if Proc < -2  or Proc > Last_Proc then
                     raise Constraint_Error;
                  elsif Proc = -2 then
                     --  Use the default configuration
                     null;
                  elsif Proc = -1 then
                     --  Choose a processor
                     Result := 0;
                     while Proc < Last_Proc loop
                        Proc := Proc + 1;
                        Result := p_online (Proc, PR_STATUS);
                        exit when Result = PR_ONLINE;
                     end loop;
                     pragma Assert (Result = PR_ONLINE or else
                            Shutdown ("Unable to find online processor"));
                     Result := processor_bind (P_PID, P_MYID, Proc, null);
                     pragma Assert (Result = 0 or else Shutdown (
                            "Unable to bind process to one processor"));
                  else
                     --  Use user processor
                     Result := processor_bind (P_PID, P_MYID, Proc, null);
                     pragma Assert (Result = 0 or else Shutdown (
                       "Unable to bind process to processor GNAT_PROCESSOR"));
                  end if;
               end if;
            exception
               when Constraint_Error =>
                  System.Error_Reporting.Trace (
         "Warning: illegal environment variable GNAT_PROCESSOR - ignored");
            end;
         end if;
      end Configure_Processors;

   begin

      Environmental_Task_ID := Environment_Task;

      Enter_Task (Environment_Task);

      --  Install the abort-signal handler

      act.sa_flags := 16;
      --  Set sa_flags to SA_NODEFER so that during the handler execution
      --  we do not change the Signal_Mask to be masked for the Abort_Signal.
      --  This is a temporary fix to the problem that the Signal_Mask is
      --  not restored after the exception (longjmp) from the handler.
      --  The right fix should be made in sigsetjmp so that we save
      --  the Signal_Set and restore it after a longjmp.
      --  In that case, this field should be changed back to 0. ???

      act.sa_handler := Abort_Handler'Address;
      Result := sigemptyset (Tmp_Set'Access);
      pragma Assert (Result = 0
        or else Shutdown ("GNULLI failure---Initialize (sigemptyset)"));
      act.sa_mask := Tmp_Set;

      Result :=
        sigaction (
          Signal (System.Interrupt_Management.Abort_Task_Interrupt),
          act'Access,
          old_act'Unchecked_Access);
      pragma Assert (Result = 0
        or else Shutdown ("GNULLI failure---Initialize (sigaction)"));

      Configure_Processors;

      Initialize_Lock (Fake_Task_Lock'Access);
      --  Create a free ATCB for use on the Fake_ATCB_List.
      Next_ATCB := new Ada_Task_Control_Block (0);
      Next_Fake_ATCB := new Fake_ATCB;

   end Initialize;

begin

   --  Mask Environment task for all signals. The original mask of the
   --  Environment task will be recovered by Interrupt_Server task
   --  during the elaboration of s-interr.adb.

   System.Interrupt_Management.Operations.Set_Interrupt_Mask
     (System.Interrupt_Management.Operations.All_Tasks_Mask'Access);

   Result := thr_keycreate (ATCB_Key'Access, System.Null_Address);
   pragma Assert (Result = 0
     or else Shutdown ("GNULLI failure---Initialize (thr_keycreate)"));
   --  We need the above code to support automatic creation of fake
   --  ATCB's for C threads that call the Ada runtime system, even if
   --  we use a faster way of getting Self for real Ada tasks.

end System.Task_Primitives.Operations;
