/* IluJava_IluOInt.c */
/* Chris Jacobi, September 18, 1997 6:16 pm PDT */

/*
 * Copyright (c) 1996 Xerox Corporation.  All Rights Reserved.  
 * Unlimited use, reproduction, and distribution of this software is
 * permitted.  Any copy of this software must include both the above
 * copyright notice of Xerox Corporation and this paragraph.  Any
 * distribution of this software must comply with all applicable United
 * States export control laws.  This software is made available AS IS,
 * and XEROX CORPORATION DISCLAIMS ALL WARRANTIES, EXPRESS OR IMPLIED,
 * INCLUDING WITHOUT LIMITATION THE IMPLIED WARRANTIES OF MERCHANTABILITY
 * AND FITNESS FOR A PARTICULAR PURPOSE, AND NOTWITHSTANDING ANY OTHER
 * PROVISION CONTAINED HEREIN, ANY LIABILITY FOR DAMAGES RESULTING FROM
 * THE SOFTWARE OR ITS USE IS EXPRESSLY DISCLAIMED, WHETHER ARISING IN
 * CONTRACT, TORT (INCLUDING NEGLIGENCE) OR STRICT LIABILITY, EVEN IF
 * XEROX CORPORATION IS ADVISED OF THE POSSIBILITY OF SUCH DAMAGES.
 */
 
/* 
 * $Id: IluJava_IluOInt.c,v 1.43 1997/09/19 01:42:17 jacobi Exp $ 
 *
 *
 * This class helps in the mapping from real Java objects to kernel object 
 * Native side for IluOInt.java
 */

 
#include "IluJava_Includes.h"
#include "IluJava_Common.h"
#include "IluJava_JGC.h"


#include "IluJava_JStubs.h"

#include "IluJava_JTypes.h"
#include <iluhash.h>
#include "IluJava_Ops.h"

#include "IluJava_JMon.h"

static ILUJAVA_JMON_PTR iluoint_LOCK;
static JGC_GLOBALOBJ_DECL(jsp_iluOIntProto);

JAVAEXPORT(IluOInt_reportIluOIntInst, Void)
	JIluOInt jh_oi
	ENDJAVAEXPORT 
    /* 
     * Report the prototipical instance.
     */
{
    JGC_GLOBALOBJ_ASSIGNTO(jsp_iluOIntProto, jh_oi);
    if (_ilujava_gcFlag > 0) {
        ilu_DebugPrintf("$ IluOInt reportIluOIntInst: j<%x> \n", jh_oi);
    }
}


EXPORTLIMITED ilu_refany _ilujava_newIluOInt ()
{
    ilu_refany x;
    HObject* jh_proto;
    JGC_GLOBALOBJ_GETFROM(jh_proto, jsp_iluOIntProto)
    x = (ilu_refany) JCALL_IluOInt_allocateOI(jh_proto);
    return x;
}


/* Assigns values to kinfo* and returns kernel object from an IluOInt
 *
 * before: not Inside (kinfo->cServer, kinfo->cClass)
 * after:  return != ILU_NIL => Inside(kinfo->cServer, kinfo->cClass)
 * after:  return == ILU_NIL => not Inside (kinfo->cServer, kinfo->cClass)
 * gc: may move objects
 */
EXPORTLIMITED ilu_Object 
_ilujava_getSetCIluObject(JIluOInt jh_oi, KInfo* kinfo, ilu_boolean raiseErrs)
{
    JGC_WP_TYPE(JIluOInt) jwp_oi = JGC_GET_WP_FROM_JAVA_OBJECT(jh_oi);
    JIluClassRep jh_class = GET_IluOInt_jjClassRep(jh_oi);
    if (jh_class) {
        kinfo->cClass = GET_IluClassRep_yIluClass(jh_class);
    } else {
        kinfo->cClass = ilu_rootClass;
    }
    if (kinfo->cClass == 0) {
        kinfo->cIluObject = 0;
        if (raiseErrs) {
            SignalError(EE(), "xerox/ilu/IluSomeSystemException", 
                "no ilu_Class");
        }
        return 0;
    }
    kinfo->cServer = _ilujava_EnterServer(jh_oi, kinfo->cClass);
    /* gc may move objects */
    if (kinfo->cServer == 0) {
        kinfo->cIluObject = 0;
        if (raiseErrs) {
            SignalError(EE(), "xerox/ilu/IluSomeSystemException", 
                "no ilu_Server");
        }
        return 0;
    }
    kinfo->cIluObject = GET_IluOInt_yIluKernelObject(JGC_WP_REVEAL(jwp_oi));
    if (kinfo->cIluObject == 0) {
        ilu_ExitServer(kinfo->cServer, kinfo->cClass);
        if (raiseErrs) {
            SignalError(EE(), "xerox/ilu/IluSomeSystemException", 
                "no ilu kernel object");
        }
        return 0;
    }
    return kinfo->cIluObject;
}


JAVAEXPORT(IluOInt_destroyGentleOI, Jboolean) 
	JIluOInt jh_oi
	ENDJAVAEXPORT 
{
     JGC_WP_TYPE(JIluOInt) jwp_oi = JGC_GET_WP_FROM_JAVA_OBJECT(jh_oi);
     JIluClassRep jh_class = GET_IluOInt_jjClassRep(jh_oi);
     ilu_Class cClass = GET_IluClassRep_yIluClass(jh_class);
     ilu_Server cServer = 0;
     ilu_Object cIluObject;
     if (_ilujava_gcFlag > 0) {
         ilu_DebugPrintf("$ destroyGentleOI: enter j<%x> \n", 
             JGC_WP_REVEAL(jwp_oi));
     }
     if (GET_IluOInt_yServer(JGC_WP_REVEAL(jwp_oi)) == 0) {
         if (_ilujava_gcFlag > 0) {
             ilu_DebugPrintf("$ destroyGentleOI: j<%x> no server A \n", 
                 JGC_WP_REVEAL(jwp_oi));   
         }
         return 0; /*don't re-finalize*/
     }
     jh_oi = (JIluOInt) JGC_WP_REVEAL(jwp_oi);
     if (GET_IluOInt_veryInterest(jh_oi) OR  
             GET_IluOInt_retained(jh_oi) OR 
             GET_IluOInt_ghost(jh_oi)) {
         /* Not monitored, must be conservative */
         if (_ilujava_gcFlag > 0) {
             ilu_DebugPrintf("$ destroyGentleOI: re-finalize A j<%x> \n", 
                 JGC_WP_REVEAL(jwp_oi));   
         }
         return 1; /*re-finalize*/
     }
     /* use the server lock */  
     cServer = _ilujava_EnterServer((JIluOInt)JGC_WP_REVEAL(jwp_oi), cClass);
     if (cServer == 0) {
         if (_ilujava_gcFlag > 0) {
             ilu_DebugPrintf("$ destroyGentleOI: j<%x> no server B \n", 
                 JGC_WP_REVEAL(jwp_oi));   
         }
         return 0; /*don't re-finalize*/
     }
     cIluObject = GET_IluOInt_yIluKernelObject(JGC_WP_REVEAL(jwp_oi));
     if (cIluObject != 0) {
         if (ilu_VeryInterested(cIluObject) OR GET_IluOInt_ghost(JGC_WP_REVEAL(jwp_oi))) {
             ilu_ExitServer(cServer, cClass);
             if (_ilujava_gcFlag > 0) {
                 ilu_DebugPrintf("$ destroyGentleOI: re-finalize B j<%x> \n", 
                     JGC_WP_REVEAL(jwp_oi));   
             }
             return 1; /*re-finalize*/
         }
     }
    ILUJAVA_MON_ENTER(iluoint_LOCK);
    if (GET_IluOInt_veryInterest(JGC_WP_REVEAL(jwp_oi)) OR  
            GET_IluOInt_retained(JGC_WP_REVEAL(jwp_oi)) OR  
            GET_IluOInt_ghost(JGC_WP_REVEAL(jwp_oi))) {
        ILUJAVA_MON_EXIT(iluoint_LOCK);
        ilu_ExitServer(cServer, cClass);
        if (_ilujava_gcFlag > 0) {
             ilu_DebugPrintf("$ destroyGentleOI: re-finalize C j<%x> \n", 
                 JGC_WP_REVEAL(jwp_oi));   
        }
        return 1; /*re-finalize*/
     }
     ILUJAVA_MON_EXIT(iluoint_LOCK);
     ilu_ExitServer(cServer, cClass);
     /* Exit the locks and re-enter them in nDestroyRudeOI
      * This is necessary to null-out the yServer field with the
      * global server lock held again.
      */
     xerox_ilu_IluOInt_nDestroyRudeOI((JIluOInt)JGC_WP_REVEAL(jwp_oi));
     return 0; /*don't re-finalize*/
}


JAVAEXPORT(IluOInt_nDestroyRudeOI, void)
    JIluOInt jh_oi
    ENDJAVAEXPORT
{
     JGC_WP_TYPE(JIluOInt) jwp_oi = JGC_GET_WP_FROM_JAVA_OBJECT(jh_oi);
     JIluClassRep jh_class = GET_IluOInt_jjClassRep(jh_oi);		  
     ilu_Class cClass = GET_IluClassRep_yIluClass(jh_class);
     ilu_Server cServer;
     if (_ilujava_gcFlag > 0) {
         ilu_DebugPrintf("$ nDestroyRudeOI enter j<%x> \n", 
             JGC_WP_REVEAL(jwp_oi));
     }
     if (GET_IluOInt_destroyed(JGC_WP_REVEAL(jwp_oi))) {
         if (_ilujava_gcFlag > 2) {
             ilu_DebugPrintf("$ nDestroyRudeOI was previously destroyed \n");
         }
         return;
     }
     cServer = _ilujava_EnterServerDisable((JIluOInt)JGC_WP_REVEAL(jwp_oi), cClass);
     if (cServer) {
         ilu_Object cIluObject;
         ILUJAVA_MON_ENTER(iluoint_LOCK);
         jh_oi = (JIluOInt)JGC_WP_REVEAL(jwp_oi);
         cIluObject = GET_IluOInt_yIluKernelObject(jh_oi);
         PUT_IluOInt_destroyed(jh_oi, 1);
         PUT_IluOInt_yIluKernelObject(jh_oi, 0);
         ILUJAVA_MON_EXIT(iluoint_LOCK);
         if (cIluObject) {
             if (_ilujava_gcFlag > 0) {
                 ilu_DebugPrintf("$ nDestroyRudeOI doit j<%x> c<%x> \n",
                     JGC_WP_REVEAL(jwp_oi), cIluObject);
             }
             ilu_RegisterLanguageSpecificObject(cIluObject, 0, JAVALANGIDX);
         }
         ilu_ExitServer(cServer, cClass);
     }
     if (_ilujava_gcFlag > 2) {
         ilu_DebugPrintf("$ nDestroyRudeOI exit j<%x> \n", 
             JGC_WP_REVEAL(jwp_oi));
     }
}


JAVAEXPORT(IluOInt_withdrawOI, void)
    JIluOInt jh_oi
    ENDJAVAEXPORT
{
    JGC_WP_TYPE(JIluOInt) jwp_oi = JGC_GET_WP_FROM_JAVA_OBJECT(jh_oi);
    KInfo kinfo;
    char * ckey;
    ilu_boolean huh;
    _ilujava_getSetCIluObject(jh_oi, &kinfo, ilu_TRUE);
    if (kinfo.cIluObject) {
         ckey = GET_IluOInt_yOwnerKey(JGC_WP_REVEAL(jwp_oi));
         if (ckey) {
             PUT_IluOInt_yOwnerKey(JGC_WP_REVEAL(jwp_oi), 0);
             huh = ilu_WithdrawObject(kinfo.cIluObject, ckey);
         } else {
             ilu_ExitServer(kinfo.cServer, kinfo.cClass);
         }
    }
}


JAVAEXPORT(IluOInt_publishOI, void)
    JIluOInt jh_oi
    ENDJAVAEXPORT
{
    JGC_WP_TYPE(JIluOInt) jwp_oi = JGC_GET_WP_FROM_JAVA_OBJECT(jh_oi);
    KInfo kinfo;
    char * ckey;
    _ilujava_getSetCIluObject(jh_oi, &kinfo, ilu_TRUE);
    if (kinfo.cIluObject) {
        ckey = GET_IluOInt_yOwnerKey(JGC_WP_REVEAL(jwp_oi));
        if (ckey) {
            ilu_ExitServer(kinfo.cServer, kinfo.cClass);
            SignalError(EE(), "xerox/ilu/IluSomeSystemException", "xxx-204");
            return;
        }
        ckey = ilu_PublishObject(kinfo.cIluObject);
        PUT_IluOInt_yOwnerKey(JGC_WP_REVEAL(jwp_oi), ckey);
    }
}


/* called within server lock */
static ilu_boolean 
_ilujava_noter(ilu_Object cobj, int vi)
{
    JGC_WP_TYPE(JIluOInt) jwp_oi = 
        ilu_GetLanguageSpecificObject(cobj, JAVALANGIDX);

    if (_ilujava_gcFlag > 0) {
        ilu_DebugPrintf("$ IluOInt noter: %d j<%x> c<%x> \n", vi, 
            JGC_WP_REVEAL(jwp_oi), cobj);
    }

    if (JGC_WP_REVEAL(jwp_oi) != ILU_NIL && ilu_TrueInstanceP(cobj)) {
        ilu_Class cl = ilu_ClassOfObject(cobj);
        if (_ilujava_gcFlag>1) {
            ilu_DebugPrintf("$ IluOInt noter: obj-true\n");
        }
        if ( ilu_CollectibleP(cl)) {
            if (vi) {
                if (_ilujava_gcFlag>1) {
                    ilu_DebugPrintf("$ IluOInt noter: showInterest\n");
                }
                JCALL_IluOInt_showInterest(JGC_WP_REVEAL(jwp_oi));
                /* no java exceptions */
            } else {
                if (_ilujava_gcFlag>1) {
                    ilu_DebugPrintf("$ IluOInt noter: removeInterest\n");
                }
                JCALL_IluOInt_removeInterest(JGC_WP_REVEAL(jwp_oi));
                /* no java exceptions */
            }
        }
    }
    return ilu_TRUE;
}				


EXPORTLIMITED void
_ilujava_IluOIntInit()
{
    iluoint_LOCK = ILUJAVA_MON_ALLOC();
    ilu_SetNoter(_ilujava_noter, JAVALANGIDX);
}



JAVAEXPORT(IluOInt_sbhOfOI, JString)
    JIluOInt jh_oi
    ENDJAVAEXPORT
{
    KInfo kinfo;
    JString jsbh = 0;
    char * csbh;
    _ilujava_getSetCIluObject(jh_oi, &kinfo, ilu_TRUE);
    if (kinfo.cIluObject) {
        csbh = ilu_SBHOfObject(kinfo.cIluObject);
        if (csbh) {
            jsbh = makeJavaString(csbh, strlen(csbh));
        }
        ilu_ExitServer(kinfo.cServer, kinfo.cClass);
    }
    return jsbh;
}


JAVAEXPORT(IluOInt_iorOfOI, JString)
    JIluOInt jh_oi
    ENDJAVAEXPORT
{
    JString jsbh = 0;
#ifdef IIOP_PROTOCOL
    ilu_Error err = ILU_INIT_NO_ERR;
    KInfo kinfo;
    char * csbh;
    _ilujava_getSetCIluObject(jh_oi, &kinfo, ilu_TRUE);
    if (kinfo.cIluObject) {
        csbh = ilu_IOROfObject(kinfo.cIluObject, &err);
        if (csbh) {
            jsbh = makeJavaString(csbh, strlen(csbh));
        }
        ilu_ExitServer(kinfo.cServer, kinfo.cClass);
    }
    if (ILU_ERRNOK(err)) {
        _ilujava_IluErrorToCallException(&err, "iorOfOI");
    }
#endif /* IIOP_PROTOCOL */
    return jsbh;
}



JAVAEXPORT(IluOInt_nativePingOI, void)
    JIluOInt jh_oi
    ENDJAVAEXPORT
{
    KInfo kinfo;
    _ilujava_getSetCIluObject(jh_oi, &kinfo, ilu_TRUE);
    if (kinfo.cIluObject) {
        ilu_Error err = ILU_INIT_NO_ERR;
        ilu_boolean ok;
        ilu_Connection newConnection;
        err = ilu_DeltaHolds(kinfo.cIluObject, 1); 
                /* as side effect also helds server */
        ilu_ExitServer(kinfo.cServer, kinfo.cClass);
        if (ILU_ERRNOK(err)) {
            _ilujava_IluErrorToCallException(&err, "ping 0");
            return;
        }
        ok = ilu_PingObject(kinfo.cIluObject, &newConnection);
        if (newConnection) {
            /* need to monitor outgoing connection */
            _ilujava_forkConnectionHandler(JENV_ACTUAL newConnection);
            /* BUG ??? WARNING: With RNI this enabled garbage collections */
        }
        ilu_EnterServer(kinfo.cServer, kinfo.cClass);
        err = ilu_DeltaHolds(kinfo.cIluObject, -1);
        ilu_ExitServer(kinfo.cServer, kinfo.cClass);
        if (ILU_ERRNOK(err)) {
            _ilujava_IluErrorToCallException(&err, "ping 1");
        } else if (!ok) {
            _ilujava_IluErrorToCallException(0, "ping 2");
        }
    }
}

JAVAEXPORT(IluOInt_nativeURLOfObject, JString)
    JIluOInt jh_oi
    ENDJAVAEXPORT
{
    JString jh_url = 0;
  #if defined(HTTP_PROTOCOL) 
    ilu_Error err = ILU_INIT_NO_ERR;
    char * c_url = 0;
    KInfo kinfo;
    _ilujava_getSetCIluObject(jh_oi, &kinfo, ilu_FALSE);
    if (kinfo.cIluObject) {
        c_url = ilu_URLOfObject(kinfo.cIluObject, &err);
        ilu_ExitServer(kinfo.cServer, kinfo.cClass);
    }
    if (ILU_ERRNOK(err)) {
        _ilujava_IluErrorToCallException(&err, "URLOfObject");
    }
    if (c_url) {
        jh_url = makeJavaString(c_url, strlen(c_url));
        ilu_free(c_url);
    }
  #endif /* HTTP_PROTOCOL */
    return jh_url;
}


/* end */


