/*
Copyright (c) 1996-1997 Xerox Corporation.  All Rights Reserved.  

Unlimited use, reproduction, and distribution of this software is
permitted.  Any copy of this software must include both the above
copyright notice of Xerox Corporation and this paragraph.  Any
distribution of this software must comply with all applicable United
States export control laws.  This software is made available AS IS,
and XEROX CORPORATION DISCLAIMS ALL WARRANTIES, EXPRESS OR IMPLIED,
INCLUDING WITHOUT LIMITATION THE IMPLIED WARRANTIES OF MERCHANTABILITY
AND FITNESS FOR A PARTICULAR PURPOSE, AND NOTWITHSTANDING ANY OTHER
PROVISION CONTAINED HEREIN, ANY LIABILITY FOR DAMAGES RESULTING FROM
THE SOFTWARE OR ITS USE IS EXPRESSLY DISCLAIMED, WHETHER ARISING IN
CONTRACT, TORT (INCLUDING NEGLIGENCE) OR STRICT LIABILITY, EVEN IF
XEROX CORPORATION IS ADVISED OF THE POSSIBILITY OF SUCH DAMAGES.

$Id: cppgenname.cpp,v 1.20 1997/09/10 17:41:29 srjohnso Exp $
*/

#ifdef __GNUC__
#pragma implementation "cppgenname.hpp"
#endif  // __GNUC__


#include <string.h>

#include "cppgen.hpp"
#include "cppparse.hpp"
#include "cppportability.hpp"

const CppParseName(Key) CppGen(true_key) = "true";
const CppParseName(Key) CppGen(surrogate_key) = "surrogate";
const CppParseName(Key) CppGen(underscore_key) = "underscore";
const CppParseName(Key) CppGen(period_key) = "period";
const CppParseName(Key) CppGen(parm_out_key) = "parm_out";
const CppParseName(Key) CppGen(wrapper_key) = "wrapper";
const CppParseName(Key) CppGen(parm_length_key) = "parm_length";
const CppParseName(Key) CppGen(parm_ptr_key) = "parm_ptr";
const CppParseName(Key) CppGen(parm_var_key) = "parm_var";
const CppParseName(Key) CppGen(parm_slice_key) = "parm_slice";
const CppParseName(Key) CppGen(instance_key) = "instance";
const CppParseName(Key) CppGen(member_key) = "member";
const CppParseName(Key) CppGen(accessor_key) = "accessor";
const CppParseName(Key) CppGen(element_key) = "element";
const CppParseName(Key) CppGen(val_key) = "val";


class ReusableString {
public:
    ReusableString (int initialMaxLen = 100) {
        initialMaxLen = (initialMaxLen < 0) ? 0 : initialMaxLen;
        maxLen = 0;
        resize(initialMaxLen);
    }
    ~ReusableString () {
        if (str != NULL)
            delete [] str;
    }
    void reset () {
        str[0] = '\0';
    }
    char * resize (int newMaxLen) {
        char * old = str;
        str = new char[(maxLen = newMaxLen) + 1];
        return old;
    }
    void strcpy (const char * from, int extraBytes = 100) {
        str[0] = '\0';
        strcat(from, extraBytes);
    }
    void strcat (const char * from, int extraBytes = 100) {
        extraBytes = (extraBytes < 0) ? 0 : extraBytes;
        if (from == NULL)
            from = "";
        const int newLen = strlen(str) + strlen(from);
        if (maxLen < newLen) {
            char * oldStr = resize(newLen + extraBytes);
            delete [] oldStr;
        };
        ::strcat(str, from);
    }
    void ucat (unsigned long u, int extraBytes = 100) {
        #define CHARS_FOR_2E64 20  // string length needed for max 64-bit unsigned
        char num[CHARS_FOR_2E64 + 1];
        extraBytes = (extraBytes < 0) ? 0 : extraBytes;
        sprintf(num, "%lu", u);
        const int newLen = strlen(str) + strlen(num);
        if (maxLen < newLen) {
            char * oldStr = resize(newLen + extraBytes);
            delete [] oldStr;
        };
        ::strcat(str, num);
    }
    char * str;
    int maxLen;
};


static
char *
qualifyUnderscores (const char * n, const CppParseName(Scope) * ns, CppParseName(Key) key) {
  static ReusableString safeN;
  static ReusableString rtn;
  safeN.strcpy(n);
  // It's likely that n came from a previous call to qualifyUnderscores,
  // so we need to be careful about overwriting it's backing string
  // prematurely; thus, we copy it into safeN.
  rtn.strcpy(ns->simpleName(key));
  rtn.strcat("_");
  rtn.strcat(safeN.str);
  return rtn.str;
}

static
char *
qualifyPeriods (const char * n, const CppParseName(Scope) * ns, CppParseName(Key) key) {
  static ReusableString safeN;
  static ReusableString rtn;
  safeN.strcpy(n);
  // It's likely that n came from a previous call to qualifyPeriods,
  // so we need to be careful about overwriting it's backing string
  // prematurely; thus, we copy it into safeN.
  rtn.strcpy(ns->simpleName(key));
  rtn.strcat(".");
  rtn.strcat(safeN.str);
  return rtn.str;
}

static
char *
qualifyPortable (const char * n, const CppParseName(Scope) * ns, CppParseName(Key) key, ILUCPP_BOOL local) {
  static ReusableString safeN;
  static ReusableString rtn;
  safeN.strcpy(n);
  // It's likely that n came from a previous call to qualifyPortable,
  // so we need to be careful about overwriting it's backing string
  // prematurely; thus, we copy it into safeN.
  rtn.strcpy(ns->simpleName(key));
  rtn.strcat(local ? "_(" : "(");
  rtn.strcat(safeN.str);
  rtn.strcat(")");
  return rtn.str;
}


const char *
CppGen(Interface)::
simpleName (CppParseName(Key) key) const {
  const char * rtn = CppParseName(Scope)::simpleName(key);
  if (definedIn == NULL) {
    const char * suffix =
      (key == CppGen_(true_key)) ? "_true" :
      (key == CppGen_(surrogate_key)) ? "_surrogate" :
      NULL;
    if (suffix != NULL) {
      static ReusableString work;
      work.strcpy(rtn);
      work.strcat(suffix);
      rtn = work.str;
    };
  };
  return rtn;
}

CppParseName(ContinuationFlag)
CppGen(Interface)::
qualify (const char * n, const char ** qn, CppParseName(Key) key, const CppParseName(Scope) * context) const {
  CppParseName(ContinuationFlag) rtn = CppParseName(proceed);
  if (key == CppGen_(underscore_key))
    *qn = qualifyUnderscores(n, this, key);
  else if (key == CppGen_(period_key))
    *qn = qualifyPeriods(n, this, key);
  else if (key == CppGen(instance_key)) {
    *qn = n;
    rtn = CppParseName(halt);
  }
  else
      switch (CppGen_(Namespace)::mode) {
      case CppGen_(namespaces):
      case CppGen_(classes):
        rtn = CppParseName(Scope)::qualify(n, qn, key, context);
      break;
      case CppGen_(underscores):
        *qn = qualifyUnderscores(n, this, key);
      break;
      default:
        *qn = qualifyPortable(n, this, key, ILUCPP_FALSE);
      break;
    };
  return rtn;
}

CppParseName(ContinuationFlag)
CppGen(Interface)::
qualifyLocal (const char * n, const char ** qn, CppParseName(Key) key) const {
  CppParseName(ContinuationFlag) rtn = CppParseName(proceed);
  if (key == CppGen_(underscore_key))
    *qn = qualifyUnderscores(n, this, key);
  else if (key == CppGen_(period_key))
    *qn = qualifyPeriods(n, this, key);
  else if (key == CppGen(instance_key)) {
    *qn = n;
    rtn = CppParseName(halt);
  }
  else
      switch (CppGen_(Namespace)::mode) {
      case CppGen_(namespaces):
      case CppGen_(classes):
        rtn = CppParseName(Scope)::qualifyLocal(n, qn, key);
      break;
      case CppGen_(underscores):
        *qn = qualifyUnderscores(n, this, key);
      break;
      default:
        *qn = qualifyPortable(n, this, key, ILUCPP_TRUE);
      break;
    };
  return rtn;
}


const char *
CppGen(NamedValue)::
simpleName (CppParseName(Key) key) const {

// TMP 8/28    const char * rtn = CppParseName(Name)::simpleName(key);
    const char * rtn = CppParse(NamedValue)::simpleName(key);  // TMP 8/28: NEW

	// determine suffix, if any
    const char * suffix =
        (key == CppGen_(parm_out_key)) ? "_out" :
        (key == CppGen_(wrapper_key)) ? "_wrapper" :
        (key == CppGen_(parm_length_key)) ? "_length" :
        (key == CppGen_(parm_ptr_key)) ? "_ptr" :
        (key == CppGen_(parm_var_key)) ? "_var" :
        (key == CppGen_(parm_slice_key)) ? "_slice" :
        (key == CppGen_(val_key)) ? "_val" :
        (usage() == CppParseName(unionMember)) ?
            ((key == CppGen_(accessor_key)) ? NULL :
            "_val") :
        NULL;

    // if suffix is needed, first prepend "_", then append suffix
	if (suffix != NULL) {
		// insert "_" prefix, append suffix
        static ReusableString work;
        work.reset();
        if (rtn[0] != '_')
            work.strcat("_");
        work.strcat(rtn);
        work.strcat(suffix);
        rtn = work.str;
    };

    return rtn;
}


const char *
CppGen(Record)::
simpleName (CppParseName(Key) key) const {
    static char _rec[] = "_rec";
    return (key == CppGen_(instance_key))
        ? _rec
        : CppGen_(Type)::simpleName(key);
}


const char *
CppGen(Union)::
simpleName (CppParseName(Key) key) const {
    static char _union[] = "_union";
    return (key == CppGen_(instance_key))
        ? _union
        : CppGen_(Type)::simpleName(key);
}


const char *
CppGen(Exception)::
simpleName (CppParseName(Key) key) const {
    static char _exception[] = "_exception";
    return (key == CppGen_(instance_key))
        ? _exception
        : CppParseName(Name)::simpleName(key);
}


CppParseName(ContinuationFlag)
CppGen(Record)::
qualify (const char * n, const char ** qn, CppParseName(Key) key, const CppParseName(Scope) * context) const {
    CppParseName(ContinuationFlag) rtn;
    if (key == CppGen_(underscore_key)) {
        *qn = qualifyUnderscores(n, this, key);
        rtn = CppParseName(proceed);
    }
    else if (key == CppGen_(period_key)) {
        *qn = qualifyPeriods(n, this, key);
        rtn = CppParseName(proceed);
    }
    else if (key == CppGen_(member_key) || key == CppGen_(accessor_key)) {
        *qn = qualifyPeriods(n, this, CppGen_(instance_key));
        rtn = CppParseName(halt);
    }
    else
        rtn = CppParseName(Scope)::qualify(n, qn, key, context);
    return rtn;
}

CppParseName(ContinuationFlag)
CppGen(Record)::
qualifyLocal (const char * n, const char ** qn, CppParseName(Key) key) const {
    CppParseName(ContinuationFlag) rtn;
    if (key == CppGen_(underscore_key)) {
        *qn = qualifyUnderscores(n, this, key);
        rtn = CppParseName(proceed);
    }
    else if (key == CppGen_(period_key)) {
        *qn = qualifyPeriods(n, this, key);
        rtn = CppParseName(proceed);
    }
    else
        rtn = CppParseName(Scope)::qualifyLocal(n, qn, key);
    return rtn;
}


CppParseName(ContinuationFlag)
CppGen(Exception)::
qualify (const char * n, const char ** qn, CppParseName(Key) key, const CppParseName(Scope) * context) const {
    CppParseName(ContinuationFlag) rtn;
    if (key == CppGen_(underscore_key)) {
        *qn = qualifyUnderscores(n, this, key);
        rtn = CppParseName(proceed);
    }
    else if (key == CppGen_(period_key)) {
        *qn = qualifyPeriods(n, this, key);
        rtn = CppParseName(proceed);
    }
    else if (key == CppGen_(member_key)) {
        *qn = qualifyPeriods(n, this, CppGen_(instance_key));
        rtn = CppParseName(halt);
    }
    else
        rtn = CppParseName(Scope)::qualify(n, qn, key, context);
    return rtn;
}

CppParseName(ContinuationFlag)
CppGen(Exception)::
qualifyLocal (const char * n, const char ** qn, CppParseName(Key) key) const {
    CppParseName(ContinuationFlag) rtn;
    if (key == CppGen_(underscore_key)) {
        *qn = qualifyUnderscores(n, this, key);
        rtn = CppParseName(proceed);
    }
    else if (key == CppGen_(period_key)) {
        *qn = qualifyPeriods(n, this, key);
        rtn = CppParseName(proceed);
    }
    else
        rtn = CppParseName(Scope)::qualifyLocal(n, qn, key);
    return rtn;
}


/* TMP 9/8
const char *
CppGen(ArrayElement)::
simpleName (CppParseName(Key) key) const {
    return _array->simpleName(key);
}
TMP 9/8 */

static  // TMP 9/9: NEW
const char *
elementSimpleName (CppParseName(Key) key, long unsigned nDims, const char* aggregate_name) {
	// nDims = 0 => index is named "_index"
	// nDims > 0 => indices are named "_indexn" where n = 0 .. nDims

	static char element_out[] = "_element_out";
	static char element_wrapper[] = "_element_wrapper";
	static char element_length[] = "_element_length";
	static char element_ptr[] = "_element_ptr";
	static char element_var[] = "_element_var";
	static char element_slice[] = "_element_slice";
	static char element_val[] = "_element_val";

	// Check key value to see if special variant on name is being requested
    const char * rtn =
        (key == CppGen_(parm_out_key)) ? element_out :
        (key == CppGen_(wrapper_key)) ? element_wrapper :
        (key == CppGen_(parm_length_key)) ? element_length :
        (key == CppGen_(parm_ptr_key)) ? element_ptr :
        (key == CppGen_(parm_var_key)) ? element_var :
        (key == CppGen_(parm_slice_key)) ? element_slice :
        (key == CppGen_(val_key)) ? element_val :
        NULL;

    // If no variant on name is being requested, index into array
	if (rtn == NULL) {
        static ReusableString work;
        work.strcpy(aggregate_name);
		if (nDims == 0)
			work.strcat("[_index]");
		else {
			for (long unsigned dimNum = 0; dimNum < nDims; dimNum++) {
				work.strcat("[_index");
				work.ucat(dimNum);
				work.strcat("]");
			};
		};
		rtn = work.str;
	};

	return rtn;
}

const char *  // TMP 9/8: NEW
CppGen(ArrayElement)::
simpleName (CppParseName(Key) key) const {
	return elementSimpleName(key, _array->dimensions().count(), "_array");
}

const char *  // TMP 9/9: NEW
CppGen(SequenceElement)::
simpleName (CppParseName(Key) key) const {
	return elementSimpleName(key, 0, "_seq");
}

const char *
CppGen(Array)::
simpleName (CppParseName(Key) key) const {
    static char _array[] = "_array";
    const char * rtn;
    if (key == CppGen_(instance_key))
        rtn = _array;
    else if (key == CppGen_(element_key)) {
        static ReusableString work;
        const long unsigned nDims = dimensions().count();
        work.strcpy("_array");
        for (long unsigned dimNum = 0; dimNum < nDims; dimNum++) {
            work.strcat("[_index");
            work.ucat(dimNum);
            work.strcat("]");
        };
        rtn = work.str;
    }
    else
        rtn = CppGen_(Type)::simpleName(key);

    return rtn;
}


const char *
CppGen(ReturnVal)::
simpleName (CppParseName(Key) key) const {
    static const char * returnVal = "_returnVal";
    const char * rtn = returnVal;
    const char * suffix =
        (key == CppGen_(parm_out_key)) ? "Out" :
        (key == CppGen_(wrapper_key)) ? "Wrapper" :
        (key == CppGen_(parm_length_key)) ? "_length" :
        (key == CppGen_(parm_ptr_key)) ? "Ptr" :
        (key == CppGen_(parm_ptr_key)) ? "Var" :
        (key == CppGen_(val_key)) ? "Val" :
        NULL;
    if (suffix != NULL) {
        static ReusableString work;
        work.reset();
        if (rtn[0] != '_')
            work.strcat("_");
        work.strcat(rtn);
        work.strcat(suffix);
        rtn = work.str;
    };
    return rtn;
}


const char *
CppGen(Object)::
simpleName (CppParseName(TypeUsage) usage) const {
    const char * rtn;
    static ReusableString work;
    switch (usage) {
    case CppParseName(recordMember):
    case CppParseName(element):
        rtn = CppParseName(TypeName)::simpleName(CppParseName(var));
        break;
    case CppParseName(unionMember):
        rtn = CppParseName(TypeName)::simpleName(CppParseName(var));
        work.strcpy(rtn);
        work.strcat("*");
        rtn = work.str;
        break;
    default:
        rtn = CppParseName(TypeName)::simpleName(usage);
        break;
    };
    return rtn;
};

CppParseName(ContinuationFlag)
CppGen(Object)::
qualify (const char * n, const char ** qn, CppParseName(Key) key, const CppParseName(Scope) * context) const {
  CppParseName(ContinuationFlag) rtn;
  if (key == CppGen_(underscore_key)) {
    *qn = qualifyUnderscores(n, this, key);
    rtn = CppParseName(proceed);
  }
  else if (key == CppGen_(period_key)) {
    *qn = qualifyPeriods(n, this, key);
    rtn = CppParseName(proceed);
  }
  else if (key == CppGen(instance_key)) {
    *qn = n;
    rtn = CppParseName(halt);
  }
  else
    rtn = CppParseName(Scope)::qualify(n, qn, key, context);
  return rtn;
}

CppParseName(ContinuationFlag)
CppGen(Object)::
qualifyLocal (const char * n, const char ** qn, CppParseName(Key) key) const {
  CppParseName(ContinuationFlag) rtn;
  if (key == CppGen_(underscore_key)) {
    *qn = qualifyUnderscores(n, this, key);
    rtn = CppParseName(proceed);
  }
  else if (key == CppGen_(period_key)) {
    *qn = qualifyPeriods(n, this, key);
    rtn = CppParseName(proceed);
  }
  else if (key == CppGen(instance_key)) {
    *qn = n;
    rtn = CppParseName(halt);
  }
  else
    rtn = CppParseName(Scope)::qualifyLocal(n, qn, key);
  return rtn;
}


/* TMP 9/6
const char *
CppGen(String)::
simpleName (CppParseName(TypeUsage) usage) const {
    // TMP 4/30: quick & dirty
    const char * rtn;
    static ReusableString work;
    switch (usage) {
    case CppParseName(recordMember):
    case CppParseName(unionMember):
    case CppParseName(element):
        work.strcpy(CppGen(Type)::simpleName());
        work.strcat("_var");
        rtn = work.str;
        break;
    default:
        rtn = CppParseName(TypeName)::simpleName(usage);
        break;
    };
    return rtn;
}
TMP 9/6 */

const char *  // TMP 9/6: NEW
CppGen(String)::
simpleName (CppParseName(TypeUsage) usage) const {
    switch (usage) {
    case CppParseName(recordMember):
    case CppParseName(unionMember):
    case CppParseName(element):
        usage = CppParseName(var);
        break;
    default:
        break;
    };
    return CppParseName(TypeName)::simpleName(usage);
}

const char *  // TMP 9/7: NEW
CppGen(String)::
usageName (CppParseName(TypeUsage) usage, const CppParseName(Scope) * context) const {
    switch (usage) {
    case CppParseName(recordMember):
    case CppParseName(unionMember):
    case CppParseName(element):
        usage = CppParseName(var);
        break;
    default:
        break;
    };
    return CppParseName(TypeName)::usageName(usage, context);
}

/* TMP 9/6
const char *
CppGen(WideString)::
simpleName (CppParseName(TypeUsage) usage) const {
    // TMP 4/30: quick & dirty
    const char * rtn;
    static ReusableString work;
    switch (usage) {
    case CppParseName(recordMember):
    case CppParseName(unionMember):
    case CppParseName(element):
        work.strcpy(CppGen(Type)::simpleName());
        work.strcat("_var");
        rtn = work.str;
        break;
    default:
        rtn = CppParseName(TypeName)::simpleName(usage);
        break;
    };
    return rtn;
}
TMP 9/6 */

const char *  // TMP 9/6: NEW
CppGen(WideString)::
simpleName (CppParseName(TypeUsage) usage) const {
    switch (usage) {
    case CppParseName(recordMember):
    case CppParseName(unionMember):
    case CppParseName(element):
        usage = CppParseName(var);
        break;
    default:
        break;
    };
    return CppParseName(TypeName)::simpleName(usage);
}


const char *
CppGen(Optional)::
simpleName (CppParseName(TypeUsage) usage) const {
    const char * rtn;
    static ReusableString work;
    switch (usage) {
    case CppParseName(recordMember):
    case CppParseName(unionMember):  // TMP 7/10: Don't really know if this is ok for unions
    case CppParseName(element):
        work.strcpy(CppGen(Type)::simpleName());
        work.strcat("_var");
        rtn = work.str;
        break;
    default:
        rtn = CppParseName(TypeName)::simpleName(usage);
        break;
    };
    return rtn;
}


/* TMP 7/20
#define DEF_CORBA_SCALAR_TYPE_SIMPLE_NAME_FUNC(T, UNUSED1, UNUSED2, BASENAME, ILUNAME) \
    const char *                                                                       \
    CppGen(T)::                                                                        \
    simpleName (CppParseName(TypeUsage) usage) const {                                 \
        static const char * var_name = #ILUNAME "_var";                                \
        return (usage == CppParseName(var))                                            \
            ? var_name                                                                 \
            : CppParseName(TypeName)::simpleName(usage);                               \
    }

CppParse_ENUMERATE_CORBA_SCALAR_TYPES(DEF_CORBA_SCALAR_TYPE_SIMPLE_NAME_FUNC)
*/